package cs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetTriggerHook invokes the cs.GetTriggerHook API synchronously
// api document: https://help.aliyun.com/api/cs/gettriggerhook.html
func (client *Client) GetTriggerHook(request *GetTriggerHookRequest) (response *GetTriggerHookResponse, err error) {
	response = CreateGetTriggerHookResponse()
	err = client.DoAction(request, response)
	return
}

// GetTriggerHookWithChan invokes the cs.GetTriggerHook API asynchronously
// api document: https://help.aliyun.com/api/cs/gettriggerhook.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetTriggerHookWithChan(request *GetTriggerHookRequest) (<-chan *GetTriggerHookResponse, <-chan error) {
	responseChan := make(chan *GetTriggerHookResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetTriggerHook(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetTriggerHookWithCallback invokes the cs.GetTriggerHook API asynchronously
// api document: https://help.aliyun.com/api/cs/gettriggerhook.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetTriggerHookWithCallback(request *GetTriggerHookRequest, callback func(response *GetTriggerHookResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTriggerHookResponse
		var err error
		defer close(result)
		response, err = client.GetTriggerHook(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetTriggerHookRequest is the request struct for api GetTriggerHook
type GetTriggerHookRequest struct {
	*requests.RoaRequest
	ClusterId string `position:"Path" name:"ClusterId"`
	ProjectId string `position:"Path" name:"ProjectId"`
}

// GetTriggerHookResponse is the response struct for api GetTriggerHook
type GetTriggerHookResponse struct {
	*responses.BaseResponse
}

// CreateGetTriggerHookRequest creates a request to invoke GetTriggerHook API
func CreateGetTriggerHookRequest() (request *GetTriggerHookRequest) {
	request = &GetTriggerHookRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("CS", "2015-12-15", "GetTriggerHook", "/hook/trigger/[ClusterId]/[ProjectId]", "", "")
	request.Method = requests.GET
	return
}

// CreateGetTriggerHookResponse creates a response to parse from GetTriggerHook response
func CreateGetTriggerHookResponse() (response *GetTriggerHookResponse) {
	response = &GetTriggerHookResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
