package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetChangeOrderInfo invokes the edas.GetChangeOrderInfo API synchronously
// api document: https://help.aliyun.com/api/edas/getchangeorderinfo.html
func (client *Client) GetChangeOrderInfo(request *GetChangeOrderInfoRequest) (response *GetChangeOrderInfoResponse, err error) {
	response = CreateGetChangeOrderInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetChangeOrderInfoWithChan invokes the edas.GetChangeOrderInfo API asynchronously
// api document: https://help.aliyun.com/api/edas/getchangeorderinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetChangeOrderInfoWithChan(request *GetChangeOrderInfoRequest) (<-chan *GetChangeOrderInfoResponse, <-chan error) {
	responseChan := make(chan *GetChangeOrderInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetChangeOrderInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetChangeOrderInfoWithCallback invokes the edas.GetChangeOrderInfo API asynchronously
// api document: https://help.aliyun.com/api/edas/getchangeorderinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetChangeOrderInfoWithCallback(request *GetChangeOrderInfoRequest, callback func(response *GetChangeOrderInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetChangeOrderInfoResponse
		var err error
		defer close(result)
		response, err = client.GetChangeOrderInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetChangeOrderInfoRequest is the request struct for api GetChangeOrderInfo
type GetChangeOrderInfoRequest struct {
	*requests.RoaRequest
	ChangeOrderId string `position:"Query" name:"ChangeOrderId"`
}

// GetChangeOrderInfoResponse is the response struct for api GetChangeOrderInfo
type GetChangeOrderInfoResponse struct {
	*responses.BaseResponse
	Code            int             `json:"Code" xml:"Code"`
	Message         string          `json:"Message" xml:"Message"`
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	ChangeOrderInfo ChangeOrderInfo `json:"changeOrderInfo" xml:"changeOrderInfo"`
}

// CreateGetChangeOrderInfoRequest creates a request to invoke GetChangeOrderInfo API
func CreateGetChangeOrderInfoRequest() (request *GetChangeOrderInfoRequest) {
	request = &GetChangeOrderInfoRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "GetChangeOrderInfo", "/pop/v5/changeorder/change_order_info", "edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetChangeOrderInfoResponse creates a response to parse from GetChangeOrderInfo response
func CreateGetChangeOrderInfoResponse() (response *GetChangeOrderInfoResponse) {
	response = &GetChangeOrderInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
