package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateUsers invokes the emr.CreateUsers API synchronously
// api document: https://help.aliyun.com/api/emr/createusers.html
func (client *Client) CreateUsers(request *CreateUsersRequest) (response *CreateUsersResponse, err error) {
	response = CreateCreateUsersResponse()
	err = client.DoAction(request, response)
	return
}

// CreateUsersWithChan invokes the emr.CreateUsers API asynchronously
// api document: https://help.aliyun.com/api/emr/createusers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateUsersWithChan(request *CreateUsersRequest) (<-chan *CreateUsersResponse, <-chan error) {
	responseChan := make(chan *CreateUsersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateUsers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateUsersWithCallback invokes the emr.CreateUsers API asynchronously
// api document: https://help.aliyun.com/api/emr/createusers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateUsersWithCallback(request *CreateUsersRequest, callback func(response *CreateUsersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateUsersResponse
		var err error
		defer close(result)
		response, err = client.CreateUsers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateUsersRequest is the request struct for api CreateUsers
type CreateUsersRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer       `position:"Query" name:"ResourceOwnerId"`
	ClusterId       string                 `position:"Query" name:"ClusterId"`
	UserInfo        *[]CreateUsersUserInfo `position:"Query" name:"UserInfo"  type:"Repeated"`
}

// CreateUsersUserInfo is a repeated param struct in CreateUsersRequest
type CreateUsersUserInfo struct {
	Type     string `name:"Type"`
	UserId   string `name:"UserId"`
	UserName string `name:"UserName"`
}

// CreateUsersResponse is the response struct for api CreateUsers
type CreateUsersResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateUsersRequest creates a request to invoke CreateUsers API
func CreateCreateUsersRequest() (request *CreateUsersRequest) {
	request = &CreateUsersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "CreateUsers", "emr", "openAPI")
	return
}

// CreateCreateUsersResponse creates a response to parse from CreateUsers response
func CreateCreateUsersResponse() (response *CreateUsersResponse) {
	response = &CreateUsersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
