package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeClusterServiceConfigHistory invokes the emr.DescribeClusterServiceConfigHistory API synchronously
// api document: https://help.aliyun.com/api/emr/describeclusterserviceconfighistory.html
func (client *Client) DescribeClusterServiceConfigHistory(request *DescribeClusterServiceConfigHistoryRequest) (response *DescribeClusterServiceConfigHistoryResponse, err error) {
	response = CreateDescribeClusterServiceConfigHistoryResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeClusterServiceConfigHistoryWithChan invokes the emr.DescribeClusterServiceConfigHistory API asynchronously
// api document: https://help.aliyun.com/api/emr/describeclusterserviceconfighistory.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeClusterServiceConfigHistoryWithChan(request *DescribeClusterServiceConfigHistoryRequest) (<-chan *DescribeClusterServiceConfigHistoryResponse, <-chan error) {
	responseChan := make(chan *DescribeClusterServiceConfigHistoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeClusterServiceConfigHistory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeClusterServiceConfigHistoryWithCallback invokes the emr.DescribeClusterServiceConfigHistory API asynchronously
// api document: https://help.aliyun.com/api/emr/describeclusterserviceconfighistory.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeClusterServiceConfigHistoryWithCallback(request *DescribeClusterServiceConfigHistoryRequest, callback func(response *DescribeClusterServiceConfigHistoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeClusterServiceConfigHistoryResponse
		var err error
		defer close(result)
		response, err = client.DescribeClusterServiceConfigHistory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeClusterServiceConfigHistoryRequest is the request struct for api DescribeClusterServiceConfigHistory
type DescribeClusterServiceConfigHistoryRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ServiceName     string           `position:"Query" name:"ServiceName"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	ConfigVersion   string           `position:"Query" name:"ConfigVersion"`
}

// DescribeClusterServiceConfigHistoryResponse is the response struct for api DescribeClusterServiceConfigHistory
type DescribeClusterServiceConfigHistoryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Config    Config `json:"Config" xml:"Config"`
}

// CreateDescribeClusterServiceConfigHistoryRequest creates a request to invoke DescribeClusterServiceConfigHistory API
func CreateDescribeClusterServiceConfigHistoryRequest() (request *DescribeClusterServiceConfigHistoryRequest) {
	request = &DescribeClusterServiceConfigHistoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DescribeClusterServiceConfigHistory", "emr", "openAPI")
	return
}

// CreateDescribeClusterServiceConfigHistoryResponse creates a response to parse from DescribeClusterServiceConfigHistory response
func CreateDescribeClusterServiceConfigHistoryResponse() (response *DescribeClusterServiceConfigHistoryResponse) {
	response = &DescribeClusterServiceConfigHistoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
