package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListFlowNodeInstance invokes the emr.ListFlowNodeInstance API synchronously
// api document: https://help.aliyun.com/api/emr/listflownodeinstance.html
func (client *Client) ListFlowNodeInstance(request *ListFlowNodeInstanceRequest) (response *ListFlowNodeInstanceResponse, err error) {
	response = CreateListFlowNodeInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// ListFlowNodeInstanceWithChan invokes the emr.ListFlowNodeInstance API asynchronously
// api document: https://help.aliyun.com/api/emr/listflownodeinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListFlowNodeInstanceWithChan(request *ListFlowNodeInstanceRequest) (<-chan *ListFlowNodeInstanceResponse, <-chan error) {
	responseChan := make(chan *ListFlowNodeInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListFlowNodeInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListFlowNodeInstanceWithCallback invokes the emr.ListFlowNodeInstance API asynchronously
// api document: https://help.aliyun.com/api/emr/listflownodeinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListFlowNodeInstanceWithCallback(request *ListFlowNodeInstanceRequest, callback func(response *ListFlowNodeInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListFlowNodeInstanceResponse
		var err error
		defer close(result)
		response, err = client.ListFlowNodeInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListFlowNodeInstanceRequest is the request struct for api ListFlowNodeInstance
type ListFlowNodeInstanceRequest struct {
	*requests.RpcRequest
	StatusList *[]string        `position:"Query" name:"StatusList"  type:"Repeated"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	OrderBy    string           `position:"Query" name:"OrderBy"`
	StartTime  requests.Integer `position:"Query" name:"StartTime"`
	ProjectId  string           `position:"Query" name:"ProjectId"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	OrderType  string           `position:"Query" name:"OrderType"`
}

// ListFlowNodeInstanceResponse is the response struct for api ListFlowNodeInstance
type ListFlowNodeInstanceResponse struct {
	*responses.BaseResponse
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	PageNumber        int               `json:"PageNumber" xml:"PageNumber"`
	PageSize          int               `json:"PageSize" xml:"PageSize"`
	Total             int               `json:"Total" xml:"Total"`
	FlowNodeInstances FlowNodeInstances `json:"FlowNodeInstances" xml:"FlowNodeInstances"`
}

// CreateListFlowNodeInstanceRequest creates a request to invoke ListFlowNodeInstance API
func CreateListFlowNodeInstanceRequest() (request *ListFlowNodeInstanceRequest) {
	request = &ListFlowNodeInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListFlowNodeInstance", "emr", "openAPI")
	return
}

// CreateListFlowNodeInstanceResponse creates a response to parse from ListFlowNodeInstance response
func CreateListFlowNodeInstanceResponse() (response *ListFlowNodeInstanceResponse) {
	response = &ListFlowNodeInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
