package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListUserStatistics invokes the emr.ListUserStatistics API synchronously
// api document: https://help.aliyun.com/api/emr/listuserstatistics.html
func (client *Client) ListUserStatistics(request *ListUserStatisticsRequest) (response *ListUserStatisticsResponse, err error) {
	response = CreateListUserStatisticsResponse()
	err = client.DoAction(request, response)
	return
}

// ListUserStatisticsWithChan invokes the emr.ListUserStatistics API asynchronously
// api document: https://help.aliyun.com/api/emr/listuserstatistics.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListUserStatisticsWithChan(request *ListUserStatisticsRequest) (<-chan *ListUserStatisticsResponse, <-chan error) {
	responseChan := make(chan *ListUserStatisticsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListUserStatistics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListUserStatisticsWithCallback invokes the emr.ListUserStatistics API asynchronously
// api document: https://help.aliyun.com/api/emr/listuserstatistics.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListUserStatisticsWithCallback(request *ListUserStatisticsRequest, callback func(response *ListUserStatisticsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListUserStatisticsResponse
		var err error
		defer close(result)
		response, err = client.ListUserStatistics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListUserStatisticsRequest is the request struct for api ListUserStatistics
type ListUserStatisticsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	OrderMode       string           `position:"Query" name:"OrderMode"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	OrderFieldName  string           `position:"Query" name:"OrderFieldName"`
	CurrentSize     requests.Integer `position:"Query" name:"CurrentSize"`
}

// ListUserStatisticsResponse is the response struct for api ListUserStatistics
type ListUserStatisticsResponse struct {
	*responses.BaseResponse
	Total              int              `json:"Total" xml:"Total"`
	UserStatisticsList []UserStatistics `json:"UserStatisticsList" xml:"UserStatisticsList"`
}

// CreateListUserStatisticsRequest creates a request to invoke ListUserStatistics API
func CreateListUserStatisticsRequest() (request *ListUserStatisticsRequest) {
	request = &ListUserStatisticsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListUserStatistics", "emr", "openAPI")
	return
}

// CreateListUserStatisticsResponse creates a response to parse from ListUserStatistics response
func CreateListUserStatisticsResponse() (response *ListUserStatisticsResponse) {
	response = &ListUserStatisticsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
