package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MetastoreModifyDataResource invokes the emr.MetastoreModifyDataResource API synchronously
// api document: https://help.aliyun.com/api/emr/metastoremodifydataresource.html
func (client *Client) MetastoreModifyDataResource(request *MetastoreModifyDataResourceRequest) (response *MetastoreModifyDataResourceResponse, err error) {
	response = CreateMetastoreModifyDataResourceResponse()
	err = client.DoAction(request, response)
	return
}

// MetastoreModifyDataResourceWithChan invokes the emr.MetastoreModifyDataResource API asynchronously
// api document: https://help.aliyun.com/api/emr/metastoremodifydataresource.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MetastoreModifyDataResourceWithChan(request *MetastoreModifyDataResourceRequest) (<-chan *MetastoreModifyDataResourceResponse, <-chan error) {
	responseChan := make(chan *MetastoreModifyDataResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MetastoreModifyDataResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MetastoreModifyDataResourceWithCallback invokes the emr.MetastoreModifyDataResource API asynchronously
// api document: https://help.aliyun.com/api/emr/metastoremodifydataresource.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MetastoreModifyDataResourceWithCallback(request *MetastoreModifyDataResourceRequest, callback func(response *MetastoreModifyDataResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MetastoreModifyDataResourceResponse
		var err error
		defer close(result)
		response, err = client.MetastoreModifyDataResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MetastoreModifyDataResourceRequest is the request struct for api MetastoreModifyDataResource
type MetastoreModifyDataResourceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Default         requests.Boolean `position:"Query" name:"Default"`
	Name            string           `position:"Query" name:"Name"`
	Description     string           `position:"Query" name:"Description"`
	Id              string           `position:"Query" name:"Id"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
}

// MetastoreModifyDataResourceResponse is the response struct for api MetastoreModifyDataResource
type MetastoreModifyDataResourceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateMetastoreModifyDataResourceRequest creates a request to invoke MetastoreModifyDataResource API
func CreateMetastoreModifyDataResourceRequest() (request *MetastoreModifyDataResourceRequest) {
	request = &MetastoreModifyDataResourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "MetastoreModifyDataResource", "emr", "openAPI")
	return
}

// CreateMetastoreModifyDataResourceResponse creates a response to parse from MetastoreModifyDataResource response
func CreateMetastoreModifyDataResourceResponse() (response *MetastoreModifyDataResourceResponse) {
	response = &MetastoreModifyDataResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
