package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MetastoreRetryTask invokes the emr.MetastoreRetryTask API synchronously
// api document: https://help.aliyun.com/api/emr/metastoreretrytask.html
func (client *Client) MetastoreRetryTask(request *MetastoreRetryTaskRequest) (response *MetastoreRetryTaskResponse, err error) {
	response = CreateMetastoreRetryTaskResponse()
	err = client.DoAction(request, response)
	return
}

// MetastoreRetryTaskWithChan invokes the emr.MetastoreRetryTask API asynchronously
// api document: https://help.aliyun.com/api/emr/metastoreretrytask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MetastoreRetryTaskWithChan(request *MetastoreRetryTaskRequest) (<-chan *MetastoreRetryTaskResponse, <-chan error) {
	responseChan := make(chan *MetastoreRetryTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MetastoreRetryTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MetastoreRetryTaskWithCallback invokes the emr.MetastoreRetryTask API asynchronously
// api document: https://help.aliyun.com/api/emr/metastoreretrytask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MetastoreRetryTaskWithCallback(request *MetastoreRetryTaskRequest, callback func(response *MetastoreRetryTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MetastoreRetryTaskResponse
		var err error
		defer close(result)
		response, err = client.MetastoreRetryTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MetastoreRetryTaskRequest is the request struct for api MetastoreRetryTask
type MetastoreRetryTaskRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	TaskId          string           `position:"Query" name:"TaskId"`
}

// MetastoreRetryTaskResponse is the response struct for api MetastoreRetryTask
type MetastoreRetryTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"success" xml:"success"`
	NewTaskId bool   `json:"NewTaskId" xml:"NewTaskId"`
}

// CreateMetastoreRetryTaskRequest creates a request to invoke MetastoreRetryTask API
func CreateMetastoreRetryTaskRequest() (request *MetastoreRetryTaskRequest) {
	request = &MetastoreRetryTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "MetastoreRetryTask", "emr", "openAPI")
	return
}

// CreateMetastoreRetryTaskResponse creates a response to parse from MetastoreRetryTask response
func CreateMetastoreRetryTaskResponse() (response *MetastoreRetryTaskResponse) {
	response = &MetastoreRetryTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
