package httpdns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDomains invokes the httpdns.ListDomains API synchronously
// api document: https://help.aliyun.com/api/httpdns/listdomains.html
func (client *Client) ListDomains(request *ListDomainsRequest) (response *ListDomainsResponse, err error) {
	response = CreateListDomainsResponse()
	err = client.DoAction(request, response)
	return
}

// ListDomainsWithChan invokes the httpdns.ListDomains API asynchronously
// api document: https://help.aliyun.com/api/httpdns/listdomains.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListDomainsWithChan(request *ListDomainsRequest) (<-chan *ListDomainsResponse, <-chan error) {
	responseChan := make(chan *ListDomainsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDomains(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDomainsWithCallback invokes the httpdns.ListDomains API asynchronously
// api document: https://help.aliyun.com/api/httpdns/listdomains.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListDomainsWithCallback(request *ListDomainsRequest, callback func(response *ListDomainsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDomainsResponse
		var err error
		defer close(result)
		response, err = client.ListDomains(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDomainsRequest is the request struct for api ListDomains
type ListDomainsRequest struct {
	*requests.RpcRequest
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
}

// ListDomainsResponse is the response struct for api ListDomains
type ListDomainsResponse struct {
	*responses.BaseResponse
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	TotalCount  int         `json:"TotalCount" xml:"TotalCount"`
	PageNumber  int         `json:"PageNumber" xml:"PageNumber"`
	PageSize    int         `json:"PageSize" xml:"PageSize"`
	DomainInfos DomainInfos `json:"DomainInfos" xml:"DomainInfos"`
}

// CreateListDomainsRequest creates a request to invoke ListDomains API
func CreateListDomainsRequest() (request *ListDomainsRequest) {
	request = &ListDomainsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Httpdns", "2016-02-01", "ListDomains", "", "")
	return
}

// CreateListDomainsResponse creates a response to parse from ListDomains response
func CreateListDomainsResponse() (response *ListDomainsResponse) {
	response = &ListDomainsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
