package imm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListFaceSearchGroupImages invokes the imm.ListFaceSearchGroupImages API synchronously
// api document: https://help.aliyun.com/api/imm/listfacesearchgroupimages.html
func (client *Client) ListFaceSearchGroupImages(request *ListFaceSearchGroupImagesRequest) (response *ListFaceSearchGroupImagesResponse, err error) {
	response = CreateListFaceSearchGroupImagesResponse()
	err = client.DoAction(request, response)
	return
}

// ListFaceSearchGroupImagesWithChan invokes the imm.ListFaceSearchGroupImages API asynchronously
// api document: https://help.aliyun.com/api/imm/listfacesearchgroupimages.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListFaceSearchGroupImagesWithChan(request *ListFaceSearchGroupImagesRequest) (<-chan *ListFaceSearchGroupImagesResponse, <-chan error) {
	responseChan := make(chan *ListFaceSearchGroupImagesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListFaceSearchGroupImages(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListFaceSearchGroupImagesWithCallback invokes the imm.ListFaceSearchGroupImages API asynchronously
// api document: https://help.aliyun.com/api/imm/listfacesearchgroupimages.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListFaceSearchGroupImagesWithCallback(request *ListFaceSearchGroupImagesRequest, callback func(response *ListFaceSearchGroupImagesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListFaceSearchGroupImagesResponse
		var err error
		defer close(result)
		response, err = client.ListFaceSearchGroupImages(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListFaceSearchGroupImagesRequest is the request struct for api ListFaceSearchGroupImages
type ListFaceSearchGroupImagesRequest struct {
	*requests.RpcRequest
	MaxKeys   requests.Integer `position:"Query" name:"MaxKeys"`
	Marker    string           `position:"Query" name:"Marker"`
	Project   string           `position:"Query" name:"Project"`
	GroupName string           `position:"Query" name:"GroupName"`
	User      string           `position:"Query" name:"User"`
}

// ListFaceSearchGroupImagesResponse is the response struct for api ListFaceSearchGroupImages
type ListFaceSearchGroupImagesResponse struct {
	*responses.BaseResponse
	RequestId  string       `json:"RequestId" xml:"RequestId"`
	NextMarker string       `json:"NextMarker" xml:"NextMarker"`
	GroupName  string       `json:"GroupName" xml:"GroupName"`
	GroupId    string       `json:"GroupId" xml:"GroupId"`
	Images     []ImagesItem `json:"Images" xml:"Images"`
}

// CreateListFaceSearchGroupImagesRequest creates a request to invoke ListFaceSearchGroupImages API
func CreateListFaceSearchGroupImagesRequest() (request *ListFaceSearchGroupImagesRequest) {
	request = &ListFaceSearchGroupImagesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imm", "2017-09-06", "ListFaceSearchGroupImages", "imm", "openAPI")
	return
}

// CreateListFaceSearchGroupImagesResponse creates a response to parse from ListFaceSearchGroupImages response
func CreateListFaceSearchGroupImagesResponse() (response *ListFaceSearchGroupImagesResponse) {
	response = &ListFaceSearchGroupImagesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
