package kms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAliases invokes the kms.ListAliases API synchronously
// api document: https://help.aliyun.com/api/kms/listaliases.html
func (client *Client) ListAliases(request *ListAliasesRequest) (response *ListAliasesResponse, err error) {
	response = CreateListAliasesResponse()
	err = client.DoAction(request, response)
	return
}

// ListAliasesWithChan invokes the kms.ListAliases API asynchronously
// api document: https://help.aliyun.com/api/kms/listaliases.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListAliasesWithChan(request *ListAliasesRequest) (<-chan *ListAliasesResponse, <-chan error) {
	responseChan := make(chan *ListAliasesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAliases(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAliasesWithCallback invokes the kms.ListAliases API asynchronously
// api document: https://help.aliyun.com/api/kms/listaliases.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListAliasesWithCallback(request *ListAliasesRequest, callback func(response *ListAliasesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAliasesResponse
		var err error
		defer close(result)
		response, err = client.ListAliases(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAliasesRequest is the request struct for api ListAliases
type ListAliasesRequest struct {
	*requests.RpcRequest
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	STSToken   string           `position:"Query" name:"STSToken"`
}

// ListAliasesResponse is the response struct for api ListAliases
type ListAliasesResponse struct {
	*responses.BaseResponse
	TotalCount int                  `json:"TotalCount" xml:"TotalCount"`
	PageNumber int                  `json:"PageNumber" xml:"PageNumber"`
	PageSize   int                  `json:"PageSize" xml:"PageSize"`
	RequestId  string               `json:"RequestId" xml:"RequestId"`
	Aliases    AliasesInListAliases `json:"Aliases" xml:"Aliases"`
}

// CreateListAliasesRequest creates a request to invoke ListAliases API
func CreateListAliasesRequest() (request *ListAliasesRequest) {
	request = &ListAliasesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Kms", "2016-01-20", "ListAliases", "kms", "openAPI")
	return
}

// CreateListAliasesResponse creates a response to parse from ListAliases response
func CreateListAliasesResponse() (response *ListAliasesResponse) {
	response = &ListAliasesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
