package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddLiveMixNotifyConfig invokes the live.AddLiveMixNotifyConfig API synchronously
// api document: https://help.aliyun.com/api/live/addlivemixnotifyconfig.html
func (client *Client) AddLiveMixNotifyConfig(request *AddLiveMixNotifyConfigRequest) (response *AddLiveMixNotifyConfigResponse, err error) {
	response = CreateAddLiveMixNotifyConfigResponse()
	err = client.DoAction(request, response)
	return
}

// AddLiveMixNotifyConfigWithChan invokes the live.AddLiveMixNotifyConfig API asynchronously
// api document: https://help.aliyun.com/api/live/addlivemixnotifyconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddLiveMixNotifyConfigWithChan(request *AddLiveMixNotifyConfigRequest) (<-chan *AddLiveMixNotifyConfigResponse, <-chan error) {
	responseChan := make(chan *AddLiveMixNotifyConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddLiveMixNotifyConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddLiveMixNotifyConfigWithCallback invokes the live.AddLiveMixNotifyConfig API asynchronously
// api document: https://help.aliyun.com/api/live/addlivemixnotifyconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddLiveMixNotifyConfigWithCallback(request *AddLiveMixNotifyConfigRequest, callback func(response *AddLiveMixNotifyConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddLiveMixNotifyConfigResponse
		var err error
		defer close(result)
		response, err = client.AddLiveMixNotifyConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddLiveMixNotifyConfigRequest is the request struct for api AddLiveMixNotifyConfig
type AddLiveMixNotifyConfigRequest struct {
	*requests.RpcRequest
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	DomainName    string           `position:"Query" name:"DomainName"`
	NotifyUrl     string           `position:"Query" name:"NotifyUrl"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
}

// AddLiveMixNotifyConfigResponse is the response struct for api AddLiveMixNotifyConfig
type AddLiveMixNotifyConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddLiveMixNotifyConfigRequest creates a request to invoke AddLiveMixNotifyConfig API
func CreateAddLiveMixNotifyConfigRequest() (request *AddLiveMixNotifyConfigRequest) {
	request = &AddLiveMixNotifyConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "AddLiveMixNotifyConfig", "live", "openAPI")
	return
}

// CreateAddLiveMixNotifyConfigResponse creates a response to parse from AddLiveMixNotifyConfig response
func CreateAddLiveMixNotifyConfigResponse() (response *AddLiveMixNotifyConfigResponse) {
	response = &AddLiveMixNotifyConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
