package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SearchMedia invokes the vod.SearchMedia API synchronously
// api document: https://help.aliyun.com/api/vod/searchmedia.html
func (client *Client) SearchMedia(request *SearchMediaRequest) (response *SearchMediaResponse, err error) {
	response = CreateSearchMediaResponse()
	err = client.DoAction(request, response)
	return
}

// SearchMediaWithChan invokes the vod.SearchMedia API asynchronously
// api document: https://help.aliyun.com/api/vod/searchmedia.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SearchMediaWithChan(request *SearchMediaRequest) (<-chan *SearchMediaResponse, <-chan error) {
	responseChan := make(chan *SearchMediaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SearchMedia(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SearchMediaWithCallback invokes the vod.SearchMedia API asynchronously
// api document: https://help.aliyun.com/api/vod/searchmedia.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SearchMediaWithCallback(request *SearchMediaRequest, callback func(response *SearchMediaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SearchMediaResponse
		var err error
		defer close(result)
		response, err = client.SearchMedia(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SearchMediaRequest is the request struct for api SearchMedia
type SearchMediaRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	Match                string           `position:"Query" name:"Match"`
	SessionId            string           `position:"Query" name:"SessionId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ScrollToken          string           `position:"Query" name:"ScrollToken"`
	PageNo               requests.Integer `position:"Query" name:"PageNo"`
	SearchType           string           `position:"Query" name:"SearchType"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	SortBy               string           `position:"Query" name:"SortBy"`
	ResultTypes          string           `position:"Query" name:"ResultTypes"`
	Fields               string           `position:"Query" name:"Fields"`
}

// SearchMediaResponse is the response struct for api SearchMedia
type SearchMediaResponse struct {
	*responses.BaseResponse
	RequestId   string  `json:"RequestId" xml:"RequestId"`
	ScrollToken string  `json:"ScrollToken" xml:"ScrollToken"`
	Total       int     `json:"Total" xml:"Total"`
	MediaList   []Media `json:"MediaList" xml:"MediaList"`
}

// CreateSearchMediaRequest creates a request to invoke SearchMedia API
func CreateSearchMediaRequest() (request *SearchMediaRequest) {
	request = &SearchMediaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "SearchMedia", "vod", "openAPI")
	return
}

// CreateSearchMediaResponse creates a response to parse from SearchMedia response
func CreateSearchMediaResponse() (response *SearchMediaResponse) {
	response = &SearchMediaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
