package billing

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// EnrollmentAccountsClient is the billing client provides access to billing resources for Azure subscriptions.
type EnrollmentAccountsClient struct {
	BaseClient
}

// NewEnrollmentAccountsClient creates an instance of the EnrollmentAccountsClient client.
func NewEnrollmentAccountsClient(subscriptionID string) EnrollmentAccountsClient {
	return NewEnrollmentAccountsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewEnrollmentAccountsClientWithBaseURI creates an instance of the EnrollmentAccountsClient client.
func NewEnrollmentAccountsClientWithBaseURI(baseURI string, subscriptionID string) EnrollmentAccountsClient {
	return EnrollmentAccountsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// GetByEnrollmentAccountAccountID get the enrollment account by id.
// Parameters:
// billingAccountName - billing Account Id.
// enrollmentAccountName - enrollment Account Id.
// expand - may be used to expand the Department.
// filter - the filter supports 'eq', 'lt', 'gt', 'le', 'ge', and 'and'. It does not currently support 'ne',
// 'or', or 'not'. Tag filter is a key value pair string where key and value is separated by a colon (:).
func (client EnrollmentAccountsClient) GetByEnrollmentAccountAccountID(ctx context.Context, billingAccountName string, enrollmentAccountName string, expand string, filter string) (result EnrollmentAccount, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EnrollmentAccountsClient.GetByEnrollmentAccountAccountID")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetByEnrollmentAccountAccountIDPreparer(ctx, billingAccountName, enrollmentAccountName, expand, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.EnrollmentAccountsClient", "GetByEnrollmentAccountAccountID", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetByEnrollmentAccountAccountIDSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "billing.EnrollmentAccountsClient", "GetByEnrollmentAccountAccountID", resp, "Failure sending request")
		return
	}

	result, err = client.GetByEnrollmentAccountAccountIDResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.EnrollmentAccountsClient", "GetByEnrollmentAccountAccountID", resp, "Failure responding to request")
	}

	return
}

// GetByEnrollmentAccountAccountIDPreparer prepares the GetByEnrollmentAccountAccountID request.
func (client EnrollmentAccountsClient) GetByEnrollmentAccountAccountIDPreparer(ctx context.Context, billingAccountName string, enrollmentAccountName string, expand string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"billingAccountName":    autorest.Encode("path", billingAccountName),
		"enrollmentAccountName": autorest.Encode("path", enrollmentAccountName),
	}

	const APIVersion = "2018-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(expand) > 0 {
		queryParameters["$expand"] = autorest.Encode("query", expand)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/enrollmentAccounts/{enrollmentAccountName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetByEnrollmentAccountAccountIDSender sends the GetByEnrollmentAccountAccountID request. The method will close the
// http.Response Body if it receives an error.
func (client EnrollmentAccountsClient) GetByEnrollmentAccountAccountIDSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetByEnrollmentAccountAccountIDResponder handles the response to the GetByEnrollmentAccountAccountID request. The method always
// closes the http.Response Body.
func (client EnrollmentAccountsClient) GetByEnrollmentAccountAccountIDResponder(resp *http.Response) (result EnrollmentAccount, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
