package frontdoor

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/frontdoor/mgmt/2018-08-01-preview/frontdoor"

// Action enumerates the values for action.
type Action string

const (
	// Allow ...
	Allow Action = "Allow"
	// Block ...
	Block Action = "Block"
	// Log ...
	Log Action = "Log"
)

// PossibleActionValues returns an array of possible values for the Action const type.
func PossibleActionValues() []Action {
	return []Action{Allow, Block, Log}
}

// Availability enumerates the values for availability.
type Availability string

const (
	// Available ...
	Available Availability = "Available"
	// Unavailable ...
	Unavailable Availability = "Unavailable"
)

// PossibleAvailabilityValues returns an array of possible values for the Availability const type.
func PossibleAvailabilityValues() []Availability {
	return []Availability{Available, Unavailable}
}

// CertificateSource enumerates the values for certificate source.
type CertificateSource string

const (
	// CertificateSourceAzureKeyVault ...
	CertificateSourceAzureKeyVault CertificateSource = "AzureKeyVault"
	// CertificateSourceFrontDoor ...
	CertificateSourceFrontDoor CertificateSource = "FrontDoor"
)

// PossibleCertificateSourceValues returns an array of possible values for the CertificateSource const type.
func PossibleCertificateSourceValues() []CertificateSource {
	return []CertificateSource{CertificateSourceAzureKeyVault, CertificateSourceFrontDoor}
}

// CertificateType enumerates the values for certificate type.
type CertificateType string

const (
	// Dedicated ...
	Dedicated CertificateType = "Dedicated"
)

// PossibleCertificateTypeValues returns an array of possible values for the CertificateType const type.
func PossibleCertificateTypeValues() []CertificateType {
	return []CertificateType{Dedicated}
}

// CustomHTTPSProvisioningState enumerates the values for custom https provisioning state.
type CustomHTTPSProvisioningState string

const (
	// Disabled ...
	Disabled CustomHTTPSProvisioningState = "Disabled"
	// Disabling ...
	Disabling CustomHTTPSProvisioningState = "Disabling"
	// Enabled ...
	Enabled CustomHTTPSProvisioningState = "Enabled"
	// Enabling ...
	Enabling CustomHTTPSProvisioningState = "Enabling"
	// Failed ...
	Failed CustomHTTPSProvisioningState = "Failed"
)

// PossibleCustomHTTPSProvisioningStateValues returns an array of possible values for the CustomHTTPSProvisioningState const type.
func PossibleCustomHTTPSProvisioningStateValues() []CustomHTTPSProvisioningState {
	return []CustomHTTPSProvisioningState{Disabled, Disabling, Enabled, Enabling, Failed}
}

// CustomHTTPSProvisioningSubstate enumerates the values for custom https provisioning substate.
type CustomHTTPSProvisioningSubstate string

const (
	// CertificateDeleted ...
	CertificateDeleted CustomHTTPSProvisioningSubstate = "CertificateDeleted"
	// CertificateDeployed ...
	CertificateDeployed CustomHTTPSProvisioningSubstate = "CertificateDeployed"
	// DeletingCertificate ...
	DeletingCertificate CustomHTTPSProvisioningSubstate = "DeletingCertificate"
	// DeployingCertificate ...
	DeployingCertificate CustomHTTPSProvisioningSubstate = "DeployingCertificate"
	// DomainControlValidationRequestApproved ...
	DomainControlValidationRequestApproved CustomHTTPSProvisioningSubstate = "DomainControlValidationRequestApproved"
	// DomainControlValidationRequestRejected ...
	DomainControlValidationRequestRejected CustomHTTPSProvisioningSubstate = "DomainControlValidationRequestRejected"
	// DomainControlValidationRequestTimedOut ...
	DomainControlValidationRequestTimedOut CustomHTTPSProvisioningSubstate = "DomainControlValidationRequestTimedOut"
	// IssuingCertificate ...
	IssuingCertificate CustomHTTPSProvisioningSubstate = "IssuingCertificate"
	// PendingDomainControlValidationREquestApproval ...
	PendingDomainControlValidationREquestApproval CustomHTTPSProvisioningSubstate = "PendingDomainControlValidationREquestApproval"
	// SubmittingDomainControlValidationRequest ...
	SubmittingDomainControlValidationRequest CustomHTTPSProvisioningSubstate = "SubmittingDomainControlValidationRequest"
)

// PossibleCustomHTTPSProvisioningSubstateValues returns an array of possible values for the CustomHTTPSProvisioningSubstate const type.
func PossibleCustomHTTPSProvisioningSubstateValues() []CustomHTTPSProvisioningSubstate {
	return []CustomHTTPSProvisioningSubstate{CertificateDeleted, CertificateDeployed, DeletingCertificate, DeployingCertificate, DomainControlValidationRequestApproved, DomainControlValidationRequestRejected, DomainControlValidationRequestTimedOut, IssuingCertificate, PendingDomainControlValidationREquestApproval, SubmittingDomainControlValidationRequest}
}

// DynamicCompressionEnabled enumerates the values for dynamic compression enabled.
type DynamicCompressionEnabled string

const (
	// DynamicCompressionEnabledDisabled ...
	DynamicCompressionEnabledDisabled DynamicCompressionEnabled = "Disabled"
	// DynamicCompressionEnabledEnabled ...
	DynamicCompressionEnabledEnabled DynamicCompressionEnabled = "Enabled"
)

// PossibleDynamicCompressionEnabledValues returns an array of possible values for the DynamicCompressionEnabled const type.
func PossibleDynamicCompressionEnabledValues() []DynamicCompressionEnabled {
	return []DynamicCompressionEnabled{DynamicCompressionEnabledDisabled, DynamicCompressionEnabledEnabled}
}

// EnabledState enumerates the values for enabled state.
type EnabledState string

const (
	// EnabledStateDisabled ...
	EnabledStateDisabled EnabledState = "Disabled"
	// EnabledStateEnabled ...
	EnabledStateEnabled EnabledState = "Enabled"
)

// PossibleEnabledStateValues returns an array of possible values for the EnabledState const type.
func PossibleEnabledStateValues() []EnabledState {
	return []EnabledState{EnabledStateDisabled, EnabledStateEnabled}
}

// EnabledStateEnum enumerates the values for enabled state enum.
type EnabledStateEnum string

const (
	// EnabledStateEnumDisabled ...
	EnabledStateEnumDisabled EnabledStateEnum = "Disabled"
	// EnabledStateEnumEnabled ...
	EnabledStateEnumEnabled EnabledStateEnum = "Enabled"
)

// PossibleEnabledStateEnumValues returns an array of possible values for the EnabledStateEnum const type.
func PossibleEnabledStateEnumValues() []EnabledStateEnum {
	return []EnabledStateEnum{EnabledStateEnumDisabled, EnabledStateEnumEnabled}
}

// ForwardingProtocol enumerates the values for forwarding protocol.
type ForwardingProtocol string

const (
	// HTTPOnly ...
	HTTPOnly ForwardingProtocol = "HttpOnly"
	// HTTPSOnly ...
	HTTPSOnly ForwardingProtocol = "HttpsOnly"
	// MatchRequest ...
	MatchRequest ForwardingProtocol = "MatchRequest"
)

// PossibleForwardingProtocolValues returns an array of possible values for the ForwardingProtocol const type.
func PossibleForwardingProtocolValues() []ForwardingProtocol {
	return []ForwardingProtocol{HTTPOnly, HTTPSOnly, MatchRequest}
}

// MatchCondition enumerates the values for match condition.
type MatchCondition string

const (
	// PostArgs ...
	PostArgs MatchCondition = "PostArgs"
	// QueryString ...
	QueryString MatchCondition = "QueryString"
	// RemoteAddr ...
	RemoteAddr MatchCondition = "RemoteAddr"
	// RequestBody ...
	RequestBody MatchCondition = "RequestBody"
	// RequestHeader ...
	RequestHeader MatchCondition = "RequestHeader"
	// RequestMethod ...
	RequestMethod MatchCondition = "RequestMethod"
	// RequestURI ...
	RequestURI MatchCondition = "RequestUri"
)

// PossibleMatchConditionValues returns an array of possible values for the MatchCondition const type.
func PossibleMatchConditionValues() []MatchCondition {
	return []MatchCondition{PostArgs, QueryString, RemoteAddr, RequestBody, RequestHeader, RequestMethod, RequestURI}
}

// Mode enumerates the values for mode.
type Mode string

const (
	// Detection ...
	Detection Mode = "Detection"
	// Prevention ...
	Prevention Mode = "Prevention"
)

// PossibleModeValues returns an array of possible values for the Mode const type.
func PossibleModeValues() []Mode {
	return []Mode{Detection, Prevention}
}

// NetworkOperationStatus enumerates the values for network operation status.
type NetworkOperationStatus string

const (
	// NetworkOperationStatusFailed ...
	NetworkOperationStatusFailed NetworkOperationStatus = "Failed"
	// NetworkOperationStatusInProgress ...
	NetworkOperationStatusInProgress NetworkOperationStatus = "InProgress"
	// NetworkOperationStatusSucceeded ...
	NetworkOperationStatusSucceeded NetworkOperationStatus = "Succeeded"
)

// PossibleNetworkOperationStatusValues returns an array of possible values for the NetworkOperationStatus const type.
func PossibleNetworkOperationStatusValues() []NetworkOperationStatus {
	return []NetworkOperationStatus{NetworkOperationStatusFailed, NetworkOperationStatusInProgress, NetworkOperationStatusSucceeded}
}

// Operator enumerates the values for operator.
type Operator string

const (
	// Any ...
	Any Operator = "Any"
	// BeginsWith ...
	BeginsWith Operator = "BeginsWith"
	// Contains ...
	Contains Operator = "Contains"
	// EndsWith ...
	EndsWith Operator = "EndsWith"
	// Equal ...
	Equal Operator = "Equal"
	// GeoMatch ...
	GeoMatch Operator = "GeoMatch"
	// GreaterThan ...
	GreaterThan Operator = "GreaterThan"
	// GreaterThanOrEqual ...
	GreaterThanOrEqual Operator = "GreaterThanOrEqual"
	// IPMatch ...
	IPMatch Operator = "IPMatch"
	// LessThan ...
	LessThan Operator = "LessThan"
	// LessThanOrEqual ...
	LessThanOrEqual Operator = "LessThanOrEqual"
)

// PossibleOperatorValues returns an array of possible values for the Operator const type.
func PossibleOperatorValues() []Operator {
	return []Operator{Any, BeginsWith, Contains, EndsWith, Equal, GeoMatch, GreaterThan, GreaterThanOrEqual, IPMatch, LessThan, LessThanOrEqual}
}

// Protocol enumerates the values for protocol.
type Protocol string

const (
	// HTTP ...
	HTTP Protocol = "Http"
	// HTTPS ...
	HTTPS Protocol = "Https"
)

// PossibleProtocolValues returns an array of possible values for the Protocol const type.
func PossibleProtocolValues() []Protocol {
	return []Protocol{HTTP, HTTPS}
}

// Query enumerates the values for query.
type Query string

const (
	// StripAll ...
	StripAll Query = "StripAll"
	// StripNone ...
	StripNone Query = "StripNone"
)

// PossibleQueryValues returns an array of possible values for the Query const type.
func PossibleQueryValues() []Query {
	return []Query{StripAll, StripNone}
}

// ResourceState enumerates the values for resource state.
type ResourceState string

const (
	// ResourceStateCreating ...
	ResourceStateCreating ResourceState = "Creating"
	// ResourceStateDeleting ...
	ResourceStateDeleting ResourceState = "Deleting"
	// ResourceStateDisabled ...
	ResourceStateDisabled ResourceState = "Disabled"
	// ResourceStateDisabling ...
	ResourceStateDisabling ResourceState = "Disabling"
	// ResourceStateEnabled ...
	ResourceStateEnabled ResourceState = "Enabled"
	// ResourceStateEnabling ...
	ResourceStateEnabling ResourceState = "Enabling"
)

// PossibleResourceStateValues returns an array of possible values for the ResourceState const type.
func PossibleResourceStateValues() []ResourceState {
	return []ResourceState{ResourceStateCreating, ResourceStateDeleting, ResourceStateDisabled, ResourceStateDisabling, ResourceStateEnabled, ResourceStateEnabling}
}

// ResourceType enumerates the values for resource type.
type ResourceType string

const (
	// MicrosoftNetworkfrontDoors ...
	MicrosoftNetworkfrontDoors ResourceType = "Microsoft.Network/frontDoors"
	// MicrosoftNetworkfrontDoorsfrontendEndpoints ...
	MicrosoftNetworkfrontDoorsfrontendEndpoints ResourceType = "Microsoft.Network/frontDoors/frontendEndpoints"
)

// PossibleResourceTypeValues returns an array of possible values for the ResourceType const type.
func PossibleResourceTypeValues() []ResourceType {
	return []ResourceType{MicrosoftNetworkfrontDoors, MicrosoftNetworkfrontDoorsfrontendEndpoints}
}

// RuleGroupOverride enumerates the values for rule group override.
type RuleGroupOverride string

const (
	// SQLInjection ...
	SQLInjection RuleGroupOverride = "SqlInjection"
	// XSS ...
	XSS RuleGroupOverride = "XSS"
)

// PossibleRuleGroupOverrideValues returns an array of possible values for the RuleGroupOverride const type.
func PossibleRuleGroupOverrideValues() []RuleGroupOverride {
	return []RuleGroupOverride{SQLInjection, XSS}
}

// RuleSetType enumerates the values for rule set type.
type RuleSetType string

const (
	// RuleSetTypeAzureManagedRuleSet ...
	RuleSetTypeAzureManagedRuleSet RuleSetType = "AzureManagedRuleSet"
	// RuleSetTypeUnknown ...
	RuleSetTypeUnknown RuleSetType = "Unknown"
)

// PossibleRuleSetTypeValues returns an array of possible values for the RuleSetType const type.
func PossibleRuleSetTypeValues() []RuleSetType {
	return []RuleSetType{RuleSetTypeAzureManagedRuleSet, RuleSetTypeUnknown}
}

// RuleType enumerates the values for rule type.
type RuleType string

const (
	// MatchRule ...
	MatchRule RuleType = "MatchRule"
	// RateLimitRule ...
	RateLimitRule RuleType = "RateLimitRule"
)

// PossibleRuleTypeValues returns an array of possible values for the RuleType const type.
func PossibleRuleTypeValues() []RuleType {
	return []RuleType{MatchRule, RateLimitRule}
}

// SessionAffinityEnabledState enumerates the values for session affinity enabled state.
type SessionAffinityEnabledState string

const (
	// SessionAffinityEnabledStateDisabled ...
	SessionAffinityEnabledStateDisabled SessionAffinityEnabledState = "Disabled"
	// SessionAffinityEnabledStateEnabled ...
	SessionAffinityEnabledStateEnabled SessionAffinityEnabledState = "Enabled"
)

// PossibleSessionAffinityEnabledStateValues returns an array of possible values for the SessionAffinityEnabledState const type.
func PossibleSessionAffinityEnabledStateValues() []SessionAffinityEnabledState {
	return []SessionAffinityEnabledState{SessionAffinityEnabledStateDisabled, SessionAffinityEnabledStateEnabled}
}

// TLSProtocolType enumerates the values for tls protocol type.
type TLSProtocolType string

const (
	// ServerNameIndication ...
	ServerNameIndication TLSProtocolType = "ServerNameIndication"
)

// PossibleTLSProtocolTypeValues returns an array of possible values for the TLSProtocolType const type.
func PossibleTLSProtocolTypeValues() []TLSProtocolType {
	return []TLSProtocolType{ServerNameIndication}
}

// Transform enumerates the values for transform.
type Transform string

const (
	// HTMLEntityDecode ...
	HTMLEntityDecode Transform = "HtmlEntityDecode"
	// Lowercase ...
	Lowercase Transform = "Lowercase"
	// RemoveNulls ...
	RemoveNulls Transform = "RemoveNulls"
	// Trim ...
	Trim Transform = "Trim"
	// Uppercase ...
	Uppercase Transform = "Uppercase"
	// URLDecode ...
	URLDecode Transform = "UrlDecode"
	// URLEncode ...
	URLEncode Transform = "UrlEncode"
)

// PossibleTransformValues returns an array of possible values for the Transform const type.
func PossibleTransformValues() []Transform {
	return []Transform{HTMLEntityDecode, Lowercase, RemoveNulls, Trim, Uppercase, URLDecode, URLEncode}
}

// WebApplicationFirewallPolicy enumerates the values for web application firewall policy.
type WebApplicationFirewallPolicy string

const (
	// WebApplicationFirewallPolicyCreating ...
	WebApplicationFirewallPolicyCreating WebApplicationFirewallPolicy = "Creating"
	// WebApplicationFirewallPolicyDeleting ...
	WebApplicationFirewallPolicyDeleting WebApplicationFirewallPolicy = "Deleting"
	// WebApplicationFirewallPolicyDisabled ...
	WebApplicationFirewallPolicyDisabled WebApplicationFirewallPolicy = "Disabled"
	// WebApplicationFirewallPolicyDisabling ...
	WebApplicationFirewallPolicyDisabling WebApplicationFirewallPolicy = "Disabling"
	// WebApplicationFirewallPolicyEnabled ...
	WebApplicationFirewallPolicyEnabled WebApplicationFirewallPolicy = "Enabled"
	// WebApplicationFirewallPolicyEnabling ...
	WebApplicationFirewallPolicyEnabling WebApplicationFirewallPolicy = "Enabling"
)

// PossibleWebApplicationFirewallPolicyValues returns an array of possible values for the WebApplicationFirewallPolicy const type.
func PossibleWebApplicationFirewallPolicyValues() []WebApplicationFirewallPolicy {
	return []WebApplicationFirewallPolicy{WebApplicationFirewallPolicyCreating, WebApplicationFirewallPolicyDeleting, WebApplicationFirewallPolicyDisabled, WebApplicationFirewallPolicyDisabling, WebApplicationFirewallPolicyEnabled, WebApplicationFirewallPolicyEnabling}
}

// AzureAsyncOperationResult the response body contains the status of the specified asynchronous operation,
// indicating whether it has succeeded, is in progress, or has failed. Note that this status is distinct
// from the HTTP status code returned for the Get Operation Status operation itself. If the asynchronous
// operation succeeded, the response body includes the HTTP status code for the successful request. If the
// asynchronous operation failed, the response body includes the HTTP status code for the failed request
// and error information regarding the failure.
type AzureAsyncOperationResult struct {
	// Status - Status of the Azure async operation. Possible values are: 'InProgress', 'Succeeded', and 'Failed'. Possible values include: 'NetworkOperationStatusInProgress', 'NetworkOperationStatusSucceeded', 'NetworkOperationStatusFailed'
	Status NetworkOperationStatus `json:"status,omitempty"`
	Error  *Error                 `json:"error,omitempty"`
}

// AzureManagedOverrideRuleGroup defines contents of a web application rule
type AzureManagedOverrideRuleGroup struct {
	// RuleGroupOverride - Describes override rule group. Possible values include: 'SQLInjection', 'XSS'
	RuleGroupOverride RuleGroupOverride `json:"ruleGroupOverride,omitempty"`
	// Action - Type of Actions. Possible values include: 'Allow', 'Block', 'Log'
	Action Action `json:"action,omitempty"`
}

// AzureManagedRuleSet describes azure managed provider.
type AzureManagedRuleSet struct {
	// RuleGroupOverrides - List of azure managed provider override configuration (optional)
	RuleGroupOverrides *[]AzureManagedOverrideRuleGroup `json:"ruleGroupOverrides,omitempty"`
	// Priority - Describes priority of the rule
	Priority *int32 `json:"priority,omitempty"`
	// Version - defines version of the rule set
	Version *int32 `json:"version,omitempty"`
	// RuleSetType - Possible values include: 'RuleSetTypeUnknown', 'RuleSetTypeAzureManagedRuleSet'
	RuleSetType RuleSetType `json:"ruleSetType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureManagedRuleSet.
func (amrs AzureManagedRuleSet) MarshalJSON() ([]byte, error) {
	amrs.RuleSetType = RuleSetTypeAzureManagedRuleSet
	objectMap := make(map[string]interface{})
	if amrs.RuleGroupOverrides != nil {
		objectMap["ruleGroupOverrides"] = amrs.RuleGroupOverrides
	}
	if amrs.Priority != nil {
		objectMap["priority"] = amrs.Priority
	}
	if amrs.Version != nil {
		objectMap["version"] = amrs.Version
	}
	if amrs.RuleSetType != "" {
		objectMap["ruleSetType"] = amrs.RuleSetType
	}
	return json.Marshal(objectMap)
}

// AsAzureManagedRuleSet is the BasicManagedRuleSet implementation for AzureManagedRuleSet.
func (amrs AzureManagedRuleSet) AsAzureManagedRuleSet() (*AzureManagedRuleSet, bool) {
	return &amrs, true
}

// AsManagedRuleSet is the BasicManagedRuleSet implementation for AzureManagedRuleSet.
func (amrs AzureManagedRuleSet) AsManagedRuleSet() (*ManagedRuleSet, bool) {
	return nil, false
}

// AsBasicManagedRuleSet is the BasicManagedRuleSet implementation for AzureManagedRuleSet.
func (amrs AzureManagedRuleSet) AsBasicManagedRuleSet() (BasicManagedRuleSet, bool) {
	return &amrs, true
}

// Backend backend address of a frontDoor load balancer.
type Backend struct {
	// Address - Location of the backend (IP address or FQDN)
	Address *string `json:"address,omitempty"`
	// HTTPPort - The HTTP TCP port number. Must be between 1 and 65535.
	HTTPPort *int32 `json:"httpPort,omitempty"`
	// HTTPSPort - The HTTPS TCP port number. Must be between 1 and 65535.
	HTTPSPort *int32 `json:"httpsPort,omitempty"`
	// EnabledState - Whether to enable use of this backend. Permitted values are 'Enabled' or 'Disabled'. Possible values include: 'EnabledStateEnumEnabled', 'EnabledStateEnumDisabled'
	EnabledState EnabledStateEnum `json:"enabledState,omitempty"`
	// Priority - Priority to use for load balancing. Higher priorities will not be used for load balancing if any lower priority backend is healthy.
	Priority *int32 `json:"priority,omitempty"`
	// Weight - Weight of this endpoint for load balancing purposes.
	Weight *int32 `json:"weight,omitempty"`
	// BackendHostHeader - The value to use as the host header sent to the backend. If blank or unspecified, this defaults to the incoming host.
	BackendHostHeader *string `json:"backendHostHeader,omitempty"`
}

// BackendPool a backend pool is a collection of backends that can be routed to.
type BackendPool struct {
	autorest.Response `json:"-"`
	// BackendPoolProperties - Properties of the Front Door Backend Pool
	*BackendPoolProperties `json:"properties,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for BackendPool.
func (bp BackendPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bp.BackendPoolProperties != nil {
		objectMap["properties"] = bp.BackendPoolProperties
	}
	if bp.Name != nil {
		objectMap["name"] = bp.Name
	}
	if bp.Type != nil {
		objectMap["type"] = bp.Type
	}
	if bp.ID != nil {
		objectMap["id"] = bp.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BackendPool struct.
func (bp *BackendPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var backendPoolProperties BackendPoolProperties
				err = json.Unmarshal(*v, &backendPoolProperties)
				if err != nil {
					return err
				}
				bp.BackendPoolProperties = &backendPoolProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bp.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bp.ID = &ID
			}
		}
	}

	return nil
}

// BackendPoolListResult result of the request to list Backend Pools. It contains a list of Backend Pools
// objects and a URL link to get the next set of results.
type BackendPoolListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Backend Pools within a Front Door.
	Value *[]BackendPool `json:"value,omitempty"`
	// NextLink - URL to get the next set of BackendPool objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// BackendPoolListResultIterator provides access to a complete listing of BackendPool values.
type BackendPoolListResultIterator struct {
	i    int
	page BackendPoolListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BackendPoolListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BackendPoolListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BackendPoolListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BackendPoolListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BackendPoolListResultIterator) Response() BackendPoolListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BackendPoolListResultIterator) Value() BackendPool {
	if !iter.page.NotDone() {
		return BackendPool{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BackendPoolListResultIterator type.
func NewBackendPoolListResultIterator(page BackendPoolListResultPage) BackendPoolListResultIterator {
	return BackendPoolListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (bplr BackendPoolListResult) IsEmpty() bool {
	return bplr.Value == nil || len(*bplr.Value) == 0
}

// backendPoolListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (bplr BackendPoolListResult) backendPoolListResultPreparer(ctx context.Context) (*http.Request, error) {
	if bplr.NextLink == nil || len(to.String(bplr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(bplr.NextLink)))
}

// BackendPoolListResultPage contains a page of BackendPool values.
type BackendPoolListResultPage struct {
	fn   func(context.Context, BackendPoolListResult) (BackendPoolListResult, error)
	bplr BackendPoolListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BackendPoolListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BackendPoolListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.bplr)
	if err != nil {
		return err
	}
	page.bplr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BackendPoolListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BackendPoolListResultPage) NotDone() bool {
	return !page.bplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BackendPoolListResultPage) Response() BackendPoolListResult {
	return page.bplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BackendPoolListResultPage) Values() []BackendPool {
	if page.bplr.IsEmpty() {
		return nil
	}
	return *page.bplr.Value
}

// Creates a new instance of the BackendPoolListResultPage type.
func NewBackendPoolListResultPage(getNextPage func(context.Context, BackendPoolListResult) (BackendPoolListResult, error)) BackendPoolListResultPage {
	return BackendPoolListResultPage{fn: getNextPage}
}

// BackendPoolProperties the JSON object that contains the properties required to create a routing rule.
type BackendPoolProperties struct {
	// ResourceState - Resource status. Possible values include: 'ResourceStateCreating', 'ResourceStateEnabling', 'ResourceStateEnabled', 'ResourceStateDisabling', 'ResourceStateDisabled', 'ResourceStateDeleting'
	ResourceState ResourceState `json:"resourceState,omitempty"`
	// Backends - The set of backends for this pool
	Backends *[]Backend `json:"backends,omitempty"`
	// LoadBalancingSettings - Load balancing settings for a backend pool
	LoadBalancingSettings *SubResource `json:"loadBalancingSettings,omitempty"`
	// HealthProbeSettings - L7 health probe settings for a backend pool
	HealthProbeSettings *SubResource `json:"healthProbeSettings,omitempty"`
}

// BackendPoolsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type BackendPoolsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *BackendPoolsCreateOrUpdateFuture) Result(client BackendPoolsClient) (bp BackendPool, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "frontdoor.BackendPoolsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("frontdoor.BackendPoolsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if bp.Response.Response, err = future.GetResult(sender); err == nil && bp.Response.Response.StatusCode != http.StatusNoContent {
		bp, err = client.CreateOrUpdateResponder(bp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "frontdoor.BackendPoolsCreateOrUpdateFuture", "Result", bp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// BackendPoolsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type BackendPoolsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *BackendPoolsDeleteFuture) Result(client BackendPoolsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "frontdoor.BackendPoolsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("frontdoor.BackendPoolsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// BackendPoolUpdateParameters a collection of backends that can be routed to.
type BackendPoolUpdateParameters struct {
	// Backends - The set of backends for this pool
	Backends *[]Backend `json:"backends,omitempty"`
	// LoadBalancingSettings - Load balancing settings for a backend pool
	LoadBalancingSettings *SubResource `json:"loadBalancingSettings,omitempty"`
	// HealthProbeSettings - L7 health probe settings for a backend pool
	HealthProbeSettings *SubResource `json:"healthProbeSettings,omitempty"`
}

// CacheConfiguration caching settings for a caching-type route. To disable caching, do not provide a
// cacheConfiguration object.
type CacheConfiguration struct {
	// QueryParameterStripDirective - Treatment of URL query terms when forming the cache key. Possible values include: 'StripNone', 'StripAll'
	QueryParameterStripDirective Query `json:"queryParameterStripDirective,omitempty"`
	// DynamicCompression - Whether to use dynamic compression for cached content. Possible values include: 'DynamicCompressionEnabledEnabled', 'DynamicCompressionEnabledDisabled'
	DynamicCompression DynamicCompressionEnabled `json:"dynamicCompression,omitempty"`
}

// CertificateSourceParameters parameters required for enabling SSL with Front Door-managed certificates
type CertificateSourceParameters struct {
	// CertificateType - Defines the type of the certificate used for secure connections to a frontendEndpoint. Possible values include: 'Dedicated'
	CertificateType CertificateType `json:"certificateType,omitempty"`
}

// CheckNameAvailabilityInput input of CheckNameAvailability API.
type CheckNameAvailabilityInput struct {
	// Name - The resource name to validate.
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource whose name is to be validated. Possible values include: 'MicrosoftNetworkfrontDoors', 'MicrosoftNetworkfrontDoorsfrontendEndpoints'
	Type ResourceType `json:"type,omitempty"`
}

// CheckNameAvailabilityOutput output of check name availability API.
type CheckNameAvailabilityOutput struct {
	autorest.Response `json:"-"`
	// NameAvailability - Indicates whether the name is available. Possible values include: 'Available', 'Unavailable'
	NameAvailability Availability `json:"nameAvailability,omitempty"`
	// Reason - The reason why the name is not available.
	Reason *string `json:"reason,omitempty"`
	// Message - The detailed error message describing why the name is not available.
	Message *string `json:"message,omitempty"`
}

// CustomHTTPSConfiguration https settings for a domain
type CustomHTTPSConfiguration struct {
	// CertificateSource - Defines the source of the SSL certificate. Possible values include: 'CertificateSourceAzureKeyVault', 'CertificateSourceFrontDoor'
	CertificateSource CertificateSource `json:"certificateSource,omitempty"`
	// ProtocolType - Defines the TLS extension protocol that is used for secure delivery. Possible values include: 'ServerNameIndication'
	ProtocolType TLSProtocolType `json:"protocolType,omitempty"`
	// KeyVaultCertificateSourceParameters - KeyVault certificate source parameters (if certificateSource=AzureKeyVault)
	*KeyVaultCertificateSourceParameters `json:"keyVaultCertificateSourceParameters,omitempty"`
	// CertificateSourceParameters - Parameters required for enabling SSL with Front Door-managed certificates (if certificateSource=FrontDoor)
	*CertificateSourceParameters `json:"frontDoorCertificateSourceParameters,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomHTTPSConfiguration.
func (chc CustomHTTPSConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if chc.CertificateSource != "" {
		objectMap["certificateSource"] = chc.CertificateSource
	}
	if chc.ProtocolType != "" {
		objectMap["protocolType"] = chc.ProtocolType
	}
	if chc.KeyVaultCertificateSourceParameters != nil {
		objectMap["keyVaultCertificateSourceParameters"] = chc.KeyVaultCertificateSourceParameters
	}
	if chc.CertificateSourceParameters != nil {
		objectMap["frontDoorCertificateSourceParameters"] = chc.CertificateSourceParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CustomHTTPSConfiguration struct.
func (chc *CustomHTTPSConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "certificateSource":
			if v != nil {
				var certificateSource CertificateSource
				err = json.Unmarshal(*v, &certificateSource)
				if err != nil {
					return err
				}
				chc.CertificateSource = certificateSource
			}
		case "protocolType":
			if v != nil {
				var protocolType TLSProtocolType
				err = json.Unmarshal(*v, &protocolType)
				if err != nil {
					return err
				}
				chc.ProtocolType = protocolType
			}
		case "keyVaultCertificateSourceParameters":
			if v != nil {
				var keyVaultCertificateSourceParameters KeyVaultCertificateSourceParameters
				err = json.Unmarshal(*v, &keyVaultCertificateSourceParameters)
				if err != nil {
					return err
				}
				chc.KeyVaultCertificateSourceParameters = &keyVaultCertificateSourceParameters
			}
		case "frontDoorCertificateSourceParameters":
			if v != nil {
				var certificateSourceParameters CertificateSourceParameters
				err = json.Unmarshal(*v, &certificateSourceParameters)
				if err != nil {
					return err
				}
				chc.CertificateSourceParameters = &certificateSourceParameters
			}
		}
	}

	return nil
}

// CustomRule defines contents of a web application rule
type CustomRule struct {
	// Name - Gets name of the resource that is unique within a policy. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - Gets a unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Priority - Describes priority of the rule. Rules with a lower value will be evaluated before rules with a higher value
	Priority *int32 `json:"priority,omitempty"`
	// RuleType - Describes type of rule. Possible values include: 'MatchRule', 'RateLimitRule'
	RuleType RuleType `json:"ruleType,omitempty"`
	// RateLimitDurationInMinutes - Defines rate limit duration. Default - 1 minute
	RateLimitDurationInMinutes *int32 `json:"rateLimitDurationInMinutes,omitempty"`
	// RateLimitThreshold - Defines rate limit threshold
	RateLimitThreshold *int32 `json:"rateLimitThreshold,omitempty"`
	// MatchConditions - List of match conditions
	MatchConditions *[]MatchCondition1 `json:"matchConditions,omitempty"`
	// Action - Type of Actions. Possible values include: 'Allow', 'Block', 'Log'
	Action Action `json:"action,omitempty"`
	// Transforms - List of transforms
	Transforms *[]Transform `json:"transforms,omitempty"`
}

// CustomRules defines contents of custom rules
type CustomRules struct {
	// Rules - List of rules
	Rules *[]CustomRule `json:"rules,omitempty"`
}

// EndpointsPurgeContentFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type EndpointsPurgeContentFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *EndpointsPurgeContentFuture) Result(client EndpointsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "frontdoor.EndpointsPurgeContentFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("frontdoor.EndpointsPurgeContentFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Error ...
type Error struct {
	Code       *string         `json:"code,omitempty"`
	Message    *string         `json:"message,omitempty"`
	Target     *string         `json:"target,omitempty"`
	Details    *[]ErrorDetails `json:"details,omitempty"`
	InnerError *string         `json:"innerError,omitempty"`
}

// ErrorDetails ...
type ErrorDetails struct {
	Code    *string `json:"code,omitempty"`
	Target  *string `json:"target,omitempty"`
	Message *string `json:"message,omitempty"`
}

// ErrorResponse error response indicates Front Door service is not able to process the incoming request.
// The reason is provided in the error message.
type ErrorResponse struct {
	// Code - Error code.
	Code *string `json:"code,omitempty"`
	// Message - Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// FrontDoor front Door represents a collection of backend endpoints to route traffic to along with rules
// that specify how traffic is sent there.
type FrontDoor struct {
	autorest.Response `json:"-"`
	// Properties - Properties of the Front Door Load Balancer
	*Properties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for FrontDoor.
func (fd FrontDoor) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fd.Properties != nil {
		objectMap["properties"] = fd.Properties
	}
	if fd.ID != nil {
		objectMap["id"] = fd.ID
	}
	if fd.Name != nil {
		objectMap["name"] = fd.Name
	}
	if fd.Type != nil {
		objectMap["type"] = fd.Type
	}
	if fd.Location != nil {
		objectMap["location"] = fd.Location
	}
	if fd.Tags != nil {
		objectMap["tags"] = fd.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FrontDoor struct.
func (fd *FrontDoor) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var properties Properties
				err = json.Unmarshal(*v, &properties)
				if err != nil {
					return err
				}
				fd.Properties = &properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fd.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				fd.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				fd.Tags = tags
			}
		}
	}

	return nil
}

// FrontDoorsCreateOrUpdateFutureType an abstraction for monitoring and retrieving the results of a
// long-running operation.
type FrontDoorsCreateOrUpdateFutureType struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *FrontDoorsCreateOrUpdateFutureType) Result(client FrontDoorsClient) (fd FrontDoor, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "frontdoor.FrontDoorsCreateOrUpdateFutureType", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("frontdoor.FrontDoorsCreateOrUpdateFutureType")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if fd.Response.Response, err = future.GetResult(sender); err == nil && fd.Response.Response.StatusCode != http.StatusNoContent {
		fd, err = client.CreateOrUpdateResponder(fd.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "frontdoor.FrontDoorsCreateOrUpdateFutureType", "Result", fd.Response.Response, "Failure responding to request")
		}
	}
	return
}

// FrontDoorsDeleteFutureType an abstraction for monitoring and retrieving the results of a long-running
// operation.
type FrontDoorsDeleteFutureType struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *FrontDoorsDeleteFutureType) Result(client FrontDoorsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "frontdoor.FrontDoorsDeleteFutureType", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("frontdoor.FrontDoorsDeleteFutureType")
		return
	}
	ar.Response = future.Response()
	return
}

// FrontendEndpoint a frontend endpoint used for routing.
type FrontendEndpoint struct {
	autorest.Response `json:"-"`
	// FrontendEndpointProperties - Properties of the Frontend endpoint
	*FrontendEndpointProperties `json:"properties,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for FrontendEndpoint.
func (fe FrontendEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fe.FrontendEndpointProperties != nil {
		objectMap["properties"] = fe.FrontendEndpointProperties
	}
	if fe.Name != nil {
		objectMap["name"] = fe.Name
	}
	if fe.Type != nil {
		objectMap["type"] = fe.Type
	}
	if fe.ID != nil {
		objectMap["id"] = fe.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FrontendEndpoint struct.
func (fe *FrontendEndpoint) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var frontendEndpointProperties FrontendEndpointProperties
				err = json.Unmarshal(*v, &frontendEndpointProperties)
				if err != nil {
					return err
				}
				fe.FrontendEndpointProperties = &frontendEndpointProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fe.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fe.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fe.ID = &ID
			}
		}
	}

	return nil
}

// FrontendEndpointProperties the JSON object that contains the properties required to create a frontend
// endpoint.
type FrontendEndpointProperties struct {
	// ResourceState - Resource status. Possible values include: 'ResourceStateCreating', 'ResourceStateEnabling', 'ResourceStateEnabled', 'ResourceStateDisabling', 'ResourceStateDisabled', 'ResourceStateDeleting'
	ResourceState ResourceState `json:"resourceState,omitempty"`
	// CustomHTTPSProvisioningState - Provisioning status of Custom Https of the frontendEndpoint. Possible values include: 'Enabling', 'Enabled', 'Disabling', 'Disabled', 'Failed'
	CustomHTTPSProvisioningState CustomHTTPSProvisioningState `json:"customHttpsProvisioningState,omitempty"`
	// CustomHTTPSProvisioningSubstate - Provisioning substate shows the progress of custom HTTPS enabling/disabling process step by step. Possible values include: 'SubmittingDomainControlValidationRequest', 'PendingDomainControlValidationREquestApproval', 'DomainControlValidationRequestApproved', 'DomainControlValidationRequestRejected', 'DomainControlValidationRequestTimedOut', 'IssuingCertificate', 'DeployingCertificate', 'CertificateDeployed', 'DeletingCertificate', 'CertificateDeleted'
	CustomHTTPSProvisioningSubstate CustomHTTPSProvisioningSubstate `json:"customHttpsProvisioningSubstate,omitempty"`
	// CustomHTTPSConfiguration - The configuration specifying how to enable HTTPS
	CustomHTTPSConfiguration *CustomHTTPSConfiguration `json:"customHttpsConfiguration,omitempty"`
	// HostName - The host name of the frontendEndpoint. Must be a domain name.
	HostName *string `json:"hostName,omitempty"`
	// SessionAffinityEnabledState - Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'. Possible values include: 'SessionAffinityEnabledStateEnabled', 'SessionAffinityEnabledStateDisabled'
	SessionAffinityEnabledState SessionAffinityEnabledState `json:"sessionAffinityEnabledState,omitempty"`
	// SessionAffinityTTLSeconds - UNUSED. This field will be ignored. The TTL to use in seconds for session affinity, if applicable.
	SessionAffinityTTLSeconds *int32 `json:"sessionAffinityTtlSeconds,omitempty"`
	// WebApplicationFirewallPolicyLink - Defines the Web Application Firewall policy for each host (if applicable)
	WebApplicationFirewallPolicyLink *FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink `json:"webApplicationFirewallPolicyLink,omitempty"`
}

// FrontendEndpointsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type FrontendEndpointsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *FrontendEndpointsCreateOrUpdateFuture) Result(client FrontendEndpointsClient) (fe FrontendEndpoint, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "frontdoor.FrontendEndpointsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("frontdoor.FrontendEndpointsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if fe.Response.Response, err = future.GetResult(sender); err == nil && fe.Response.Response.StatusCode != http.StatusNoContent {
		fe, err = client.CreateOrUpdateResponder(fe.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "frontdoor.FrontendEndpointsCreateOrUpdateFuture", "Result", fe.Response.Response, "Failure responding to request")
		}
	}
	return
}

// FrontendEndpointsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type FrontendEndpointsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *FrontendEndpointsDeleteFuture) Result(client FrontendEndpointsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "frontdoor.FrontendEndpointsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("frontdoor.FrontendEndpointsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// FrontendEndpointsDisableHTTPSFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type FrontendEndpointsDisableHTTPSFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *FrontendEndpointsDisableHTTPSFuture) Result(client FrontendEndpointsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "frontdoor.FrontendEndpointsDisableHTTPSFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("frontdoor.FrontendEndpointsDisableHTTPSFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// FrontendEndpointsEnableHTTPSFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type FrontendEndpointsEnableHTTPSFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *FrontendEndpointsEnableHTTPSFuture) Result(client FrontendEndpointsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "frontdoor.FrontendEndpointsEnableHTTPSFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("frontdoor.FrontendEndpointsEnableHTTPSFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// FrontendEndpointsListResult result of the request to list frontend endpoints. It contains a list of
// Frontend endpoint objects and a URL link to get the next set of results.
type FrontendEndpointsListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Frontend endpoints within a Front Door.
	Value *[]FrontendEndpoint `json:"value,omitempty"`
	// NextLink - URL to get the next set of frontend endpoints if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// FrontendEndpointsListResultIterator provides access to a complete listing of FrontendEndpoint values.
type FrontendEndpointsListResultIterator struct {
	i    int
	page FrontendEndpointsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *FrontendEndpointsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FrontendEndpointsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *FrontendEndpointsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter FrontendEndpointsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter FrontendEndpointsListResultIterator) Response() FrontendEndpointsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter FrontendEndpointsListResultIterator) Value() FrontendEndpoint {
	if !iter.page.NotDone() {
		return FrontendEndpoint{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the FrontendEndpointsListResultIterator type.
func NewFrontendEndpointsListResultIterator(page FrontendEndpointsListResultPage) FrontendEndpointsListResultIterator {
	return FrontendEndpointsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (felr FrontendEndpointsListResult) IsEmpty() bool {
	return felr.Value == nil || len(*felr.Value) == 0
}

// frontendEndpointsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (felr FrontendEndpointsListResult) frontendEndpointsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if felr.NextLink == nil || len(to.String(felr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(felr.NextLink)))
}

// FrontendEndpointsListResultPage contains a page of FrontendEndpoint values.
type FrontendEndpointsListResultPage struct {
	fn   func(context.Context, FrontendEndpointsListResult) (FrontendEndpointsListResult, error)
	felr FrontendEndpointsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *FrontendEndpointsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FrontendEndpointsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.felr)
	if err != nil {
		return err
	}
	page.felr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *FrontendEndpointsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page FrontendEndpointsListResultPage) NotDone() bool {
	return !page.felr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page FrontendEndpointsListResultPage) Response() FrontendEndpointsListResult {
	return page.felr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page FrontendEndpointsListResultPage) Values() []FrontendEndpoint {
	if page.felr.IsEmpty() {
		return nil
	}
	return *page.felr.Value
}

// Creates a new instance of the FrontendEndpointsListResultPage type.
func NewFrontendEndpointsListResultPage(getNextPage func(context.Context, FrontendEndpointsListResult) (FrontendEndpointsListResult, error)) FrontendEndpointsListResultPage {
	return FrontendEndpointsListResultPage{fn: getNextPage}
}

// FrontendEndpointUpdateParameters frontend endpoint used in routing rule
type FrontendEndpointUpdateParameters struct {
	// HostName - The host name of the frontendEndpoint. Must be a domain name.
	HostName *string `json:"hostName,omitempty"`
	// SessionAffinityEnabledState - Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'. Possible values include: 'SessionAffinityEnabledStateEnabled', 'SessionAffinityEnabledStateDisabled'
	SessionAffinityEnabledState SessionAffinityEnabledState `json:"sessionAffinityEnabledState,omitempty"`
	// SessionAffinityTTLSeconds - UNUSED. This field will be ignored. The TTL to use in seconds for session affinity, if applicable.
	SessionAffinityTTLSeconds *int32 `json:"sessionAffinityTtlSeconds,omitempty"`
	// WebApplicationFirewallPolicyLink - Defines the Web Application Firewall policy for each host (if applicable)
	WebApplicationFirewallPolicyLink *FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink `json:"webApplicationFirewallPolicyLink,omitempty"`
}

// FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink defines the Web Application Firewall
// policy for each host (if applicable)
type FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink struct {
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// HealthProbeSettingsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type HealthProbeSettingsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *HealthProbeSettingsCreateOrUpdateFuture) Result(client HealthProbeSettingsClient) (hpsm HealthProbeSettingsModel, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "frontdoor.HealthProbeSettingsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("frontdoor.HealthProbeSettingsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if hpsm.Response.Response, err = future.GetResult(sender); err == nil && hpsm.Response.Response.StatusCode != http.StatusNoContent {
		hpsm, err = client.CreateOrUpdateResponder(hpsm.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "frontdoor.HealthProbeSettingsCreateOrUpdateFuture", "Result", hpsm.Response.Response, "Failure responding to request")
		}
	}
	return
}

// HealthProbeSettingsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type HealthProbeSettingsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *HealthProbeSettingsDeleteFuture) Result(client HealthProbeSettingsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "frontdoor.HealthProbeSettingsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("frontdoor.HealthProbeSettingsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// HealthProbeSettingsListResult result of the request to list HealthProbeSettings. It contains a list of
// HealthProbeSettings objects and a URL link to get the next set of results.
type HealthProbeSettingsListResult struct {
	autorest.Response `json:"-"`
	// Value - List of HealthProbeSettings within a Front Door.
	Value *[]HealthProbeSettingsModel `json:"value,omitempty"`
	// NextLink - URL to get the next set of HealthProbeSettings objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// HealthProbeSettingsListResultIterator provides access to a complete listing of HealthProbeSettingsModel
// values.
type HealthProbeSettingsListResultIterator struct {
	i    int
	page HealthProbeSettingsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *HealthProbeSettingsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HealthProbeSettingsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *HealthProbeSettingsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter HealthProbeSettingsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter HealthProbeSettingsListResultIterator) Response() HealthProbeSettingsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter HealthProbeSettingsListResultIterator) Value() HealthProbeSettingsModel {
	if !iter.page.NotDone() {
		return HealthProbeSettingsModel{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the HealthProbeSettingsListResultIterator type.
func NewHealthProbeSettingsListResultIterator(page HealthProbeSettingsListResultPage) HealthProbeSettingsListResultIterator {
	return HealthProbeSettingsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (hpslr HealthProbeSettingsListResult) IsEmpty() bool {
	return hpslr.Value == nil || len(*hpslr.Value) == 0
}

// healthProbeSettingsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (hpslr HealthProbeSettingsListResult) healthProbeSettingsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if hpslr.NextLink == nil || len(to.String(hpslr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(hpslr.NextLink)))
}

// HealthProbeSettingsListResultPage contains a page of HealthProbeSettingsModel values.
type HealthProbeSettingsListResultPage struct {
	fn    func(context.Context, HealthProbeSettingsListResult) (HealthProbeSettingsListResult, error)
	hpslr HealthProbeSettingsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *HealthProbeSettingsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HealthProbeSettingsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.hpslr)
	if err != nil {
		return err
	}
	page.hpslr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *HealthProbeSettingsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page HealthProbeSettingsListResultPage) NotDone() bool {
	return !page.hpslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page HealthProbeSettingsListResultPage) Response() HealthProbeSettingsListResult {
	return page.hpslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page HealthProbeSettingsListResultPage) Values() []HealthProbeSettingsModel {
	if page.hpslr.IsEmpty() {
		return nil
	}
	return *page.hpslr.Value
}

// Creates a new instance of the HealthProbeSettingsListResultPage type.
func NewHealthProbeSettingsListResultPage(getNextPage func(context.Context, HealthProbeSettingsListResult) (HealthProbeSettingsListResult, error)) HealthProbeSettingsListResultPage {
	return HealthProbeSettingsListResultPage{fn: getNextPage}
}

// HealthProbeSettingsModel load balancing settings for a backend pool
type HealthProbeSettingsModel struct {
	autorest.Response `json:"-"`
	// HealthProbeSettingsProperties - Properties of the health probe settings
	*HealthProbeSettingsProperties `json:"properties,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for HealthProbeSettingsModel.
func (hpsm HealthProbeSettingsModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hpsm.HealthProbeSettingsProperties != nil {
		objectMap["properties"] = hpsm.HealthProbeSettingsProperties
	}
	if hpsm.Name != nil {
		objectMap["name"] = hpsm.Name
	}
	if hpsm.Type != nil {
		objectMap["type"] = hpsm.Type
	}
	if hpsm.ID != nil {
		objectMap["id"] = hpsm.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for HealthProbeSettingsModel struct.
func (hpsm *HealthProbeSettingsModel) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var healthProbeSettingsProperties HealthProbeSettingsProperties
				err = json.Unmarshal(*v, &healthProbeSettingsProperties)
				if err != nil {
					return err
				}
				hpsm.HealthProbeSettingsProperties = &healthProbeSettingsProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				hpsm.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				hpsm.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				hpsm.ID = &ID
			}
		}
	}

	return nil
}

// HealthProbeSettingsProperties the JSON object that contains the properties required to create a health
// probe settings.
type HealthProbeSettingsProperties struct {
	// ResourceState - Resource status. Possible values include: 'ResourceStateCreating', 'ResourceStateEnabling', 'ResourceStateEnabled', 'ResourceStateDisabling', 'ResourceStateDisabled', 'ResourceStateDeleting'
	ResourceState ResourceState `json:"resourceState,omitempty"`
	// Path - The path to use for the health probe. Default is /
	Path *string `json:"path,omitempty"`
	// Protocol - Protocol scheme to use for this probe. Possible values include: 'HTTP', 'HTTPS'
	Protocol Protocol `json:"protocol,omitempty"`
	// IntervalInSeconds - The number of seconds between health probes.
	IntervalInSeconds *int32 `json:"intervalInSeconds,omitempty"`
}

// HealthProbeSettingsUpdateParameters l7 health probe settings for a backend pool
type HealthProbeSettingsUpdateParameters struct {
	// Path - The path to use for the health probe. Default is /
	Path *string `json:"path,omitempty"`
	// Protocol - Protocol scheme to use for this probe. Possible values include: 'HTTP', 'HTTPS'
	Protocol Protocol `json:"protocol,omitempty"`
	// IntervalInSeconds - The number of seconds between health probes.
	IntervalInSeconds *int32 `json:"intervalInSeconds,omitempty"`
}

// KeyVaultCertificateSourceParameters parameters required for bring-your-own-certification via Key Vault
type KeyVaultCertificateSourceParameters struct {
	// Vault - The Key Vault containing the SSL certificate
	Vault *KeyVaultCertificateSourceParametersVault `json:"vault,omitempty"`
	// SecretName - The name of the Key Vault secret representing the full certificate PFX
	SecretName *string `json:"secretName,omitempty"`
	// SecretVersion - The version of the Key Vault secret representing the full certificate PFX
	SecretVersion *string `json:"secretVersion,omitempty"`
}

// KeyVaultCertificateSourceParametersVault the Key Vault containing the SSL certificate
type KeyVaultCertificateSourceParametersVault struct {
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// ListResult result of the request to list Front Doors. It contains a list of Front Door objects and a URL
// link to get the next set of results.
type ListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Front Doors within a resource group.
	Value *[]FrontDoor `json:"value,omitempty"`
	// NextLink - URL to get the next set of Front Door objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListResultIterator provides access to a complete listing of FrontDoor values.
type ListResultIterator struct {
	i    int
	page ListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListResultIterator) Response() ListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListResultIterator) Value() FrontDoor {
	if !iter.page.NotDone() {
		return FrontDoor{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListResultIterator type.
func NewListResultIterator(page ListResultPage) ListResultIterator {
	return ListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lr ListResult) IsEmpty() bool {
	return lr.Value == nil || len(*lr.Value) == 0
}

// listResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lr ListResult) listResultPreparer(ctx context.Context) (*http.Request, error) {
	if lr.NextLink == nil || len(to.String(lr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lr.NextLink)))
}

// ListResultPage contains a page of FrontDoor values.
type ListResultPage struct {
	fn func(context.Context, ListResult) (ListResult, error)
	lr ListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.lr)
	if err != nil {
		return err
	}
	page.lr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListResultPage) NotDone() bool {
	return !page.lr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListResultPage) Response() ListResult {
	return page.lr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListResultPage) Values() []FrontDoor {
	if page.lr.IsEmpty() {
		return nil
	}
	return *page.lr.Value
}

// Creates a new instance of the ListResultPage type.
func NewListResultPage(getNextPage func(context.Context, ListResult) (ListResult, error)) ListResultPage {
	return ListResultPage{fn: getNextPage}
}

// LoadBalancingSettingsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type LoadBalancingSettingsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *LoadBalancingSettingsCreateOrUpdateFuture) Result(client LoadBalancingSettingsClient) (lbsm LoadBalancingSettingsModel, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "frontdoor.LoadBalancingSettingsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("frontdoor.LoadBalancingSettingsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if lbsm.Response.Response, err = future.GetResult(sender); err == nil && lbsm.Response.Response.StatusCode != http.StatusNoContent {
		lbsm, err = client.CreateOrUpdateResponder(lbsm.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "frontdoor.LoadBalancingSettingsCreateOrUpdateFuture", "Result", lbsm.Response.Response, "Failure responding to request")
		}
	}
	return
}

// LoadBalancingSettingsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type LoadBalancingSettingsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *LoadBalancingSettingsDeleteFuture) Result(client LoadBalancingSettingsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "frontdoor.LoadBalancingSettingsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("frontdoor.LoadBalancingSettingsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// LoadBalancingSettingsListResult result of the request to list load balancing settings. It contains a
// list of load balancing settings objects and a URL link to get the next set of results.
type LoadBalancingSettingsListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Backend Pools within a Front Door.
	Value *[]LoadBalancingSettingsModel `json:"value,omitempty"`
	// NextLink - URL to get the next set of LoadBalancingSettings objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// LoadBalancingSettingsListResultIterator provides access to a complete listing of
// LoadBalancingSettingsModel values.
type LoadBalancingSettingsListResultIterator struct {
	i    int
	page LoadBalancingSettingsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LoadBalancingSettingsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LoadBalancingSettingsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *LoadBalancingSettingsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LoadBalancingSettingsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LoadBalancingSettingsListResultIterator) Response() LoadBalancingSettingsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LoadBalancingSettingsListResultIterator) Value() LoadBalancingSettingsModel {
	if !iter.page.NotDone() {
		return LoadBalancingSettingsModel{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the LoadBalancingSettingsListResultIterator type.
func NewLoadBalancingSettingsListResultIterator(page LoadBalancingSettingsListResultPage) LoadBalancingSettingsListResultIterator {
	return LoadBalancingSettingsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lbslr LoadBalancingSettingsListResult) IsEmpty() bool {
	return lbslr.Value == nil || len(*lbslr.Value) == 0
}

// loadBalancingSettingsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lbslr LoadBalancingSettingsListResult) loadBalancingSettingsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if lbslr.NextLink == nil || len(to.String(lbslr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lbslr.NextLink)))
}

// LoadBalancingSettingsListResultPage contains a page of LoadBalancingSettingsModel values.
type LoadBalancingSettingsListResultPage struct {
	fn    func(context.Context, LoadBalancingSettingsListResult) (LoadBalancingSettingsListResult, error)
	lbslr LoadBalancingSettingsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LoadBalancingSettingsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LoadBalancingSettingsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.lbslr)
	if err != nil {
		return err
	}
	page.lbslr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *LoadBalancingSettingsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LoadBalancingSettingsListResultPage) NotDone() bool {
	return !page.lbslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LoadBalancingSettingsListResultPage) Response() LoadBalancingSettingsListResult {
	return page.lbslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LoadBalancingSettingsListResultPage) Values() []LoadBalancingSettingsModel {
	if page.lbslr.IsEmpty() {
		return nil
	}
	return *page.lbslr.Value
}

// Creates a new instance of the LoadBalancingSettingsListResultPage type.
func NewLoadBalancingSettingsListResultPage(getNextPage func(context.Context, LoadBalancingSettingsListResult) (LoadBalancingSettingsListResult, error)) LoadBalancingSettingsListResultPage {
	return LoadBalancingSettingsListResultPage{fn: getNextPage}
}

// LoadBalancingSettingsModel load balancing settings for a backend pool
type LoadBalancingSettingsModel struct {
	autorest.Response `json:"-"`
	// LoadBalancingSettingsProperties - Properties of the load balancing settings
	*LoadBalancingSettingsProperties `json:"properties,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for LoadBalancingSettingsModel.
func (lbsm LoadBalancingSettingsModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lbsm.LoadBalancingSettingsProperties != nil {
		objectMap["properties"] = lbsm.LoadBalancingSettingsProperties
	}
	if lbsm.Name != nil {
		objectMap["name"] = lbsm.Name
	}
	if lbsm.Type != nil {
		objectMap["type"] = lbsm.Type
	}
	if lbsm.ID != nil {
		objectMap["id"] = lbsm.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LoadBalancingSettingsModel struct.
func (lbsm *LoadBalancingSettingsModel) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var loadBalancingSettingsProperties LoadBalancingSettingsProperties
				err = json.Unmarshal(*v, &loadBalancingSettingsProperties)
				if err != nil {
					return err
				}
				lbsm.LoadBalancingSettingsProperties = &loadBalancingSettingsProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lbsm.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lbsm.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lbsm.ID = &ID
			}
		}
	}

	return nil
}

// LoadBalancingSettingsProperties the JSON object that contains the properties required to create load
// balancing settings
type LoadBalancingSettingsProperties struct {
	// ResourceState - Resource status. Possible values include: 'ResourceStateCreating', 'ResourceStateEnabling', 'ResourceStateEnabled', 'ResourceStateDisabling', 'ResourceStateDisabled', 'ResourceStateDeleting'
	ResourceState ResourceState `json:"resourceState,omitempty"`
	// SampleSize - The number of samples to consider for load balancing decisions
	SampleSize *int32 `json:"sampleSize,omitempty"`
	// SuccessfulSamplesRequired - The number of samples within the sample period that must succeed
	SuccessfulSamplesRequired *int32 `json:"successfulSamplesRequired,omitempty"`
	// AdditionalLatencyMilliseconds - The additional latency in milliseconds for probes to fall into the lowest latency bucket
	AdditionalLatencyMilliseconds *int32 `json:"additionalLatencyMilliseconds,omitempty"`
}

// LoadBalancingSettingsUpdateParameters round-Robin load balancing settings for a backend pool
type LoadBalancingSettingsUpdateParameters struct {
	// SampleSize - The number of samples to consider for load balancing decisions
	SampleSize *int32 `json:"sampleSize,omitempty"`
	// SuccessfulSamplesRequired - The number of samples within the sample period that must succeed
	SuccessfulSamplesRequired *int32 `json:"successfulSamplesRequired,omitempty"`
	// AdditionalLatencyMilliseconds - The additional latency in milliseconds for probes to fall into the lowest latency bucket
	AdditionalLatencyMilliseconds *int32 `json:"additionalLatencyMilliseconds,omitempty"`
}

// BasicManagedRuleSet base class for all types of ManagedRuleSet.
type BasicManagedRuleSet interface {
	AsAzureManagedRuleSet() (*AzureManagedRuleSet, bool)
	AsManagedRuleSet() (*ManagedRuleSet, bool)
}

// ManagedRuleSet base class for all types of ManagedRuleSet.
type ManagedRuleSet struct {
	// Priority - Describes priority of the rule
	Priority *int32 `json:"priority,omitempty"`
	// Version - defines version of the rule set
	Version *int32 `json:"version,omitempty"`
	// RuleSetType - Possible values include: 'RuleSetTypeUnknown', 'RuleSetTypeAzureManagedRuleSet'
	RuleSetType RuleSetType `json:"ruleSetType,omitempty"`
}

func unmarshalBasicManagedRuleSet(body []byte) (BasicManagedRuleSet, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["ruleSetType"] {
	case string(RuleSetTypeAzureManagedRuleSet):
		var amrs AzureManagedRuleSet
		err := json.Unmarshal(body, &amrs)
		return amrs, err
	default:
		var mrs ManagedRuleSet
		err := json.Unmarshal(body, &mrs)
		return mrs, err
	}
}
func unmarshalBasicManagedRuleSetArray(body []byte) ([]BasicManagedRuleSet, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	mrsArray := make([]BasicManagedRuleSet, len(rawMessages))

	for index, rawMessage := range rawMessages {
		mrs, err := unmarshalBasicManagedRuleSet(*rawMessage)
		if err != nil {
			return nil, err
		}
		mrsArray[index] = mrs
	}
	return mrsArray, nil
}

// MarshalJSON is the custom marshaler for ManagedRuleSet.
func (mrs ManagedRuleSet) MarshalJSON() ([]byte, error) {
	mrs.RuleSetType = RuleSetTypeUnknown
	objectMap := make(map[string]interface{})
	if mrs.Priority != nil {
		objectMap["priority"] = mrs.Priority
	}
	if mrs.Version != nil {
		objectMap["version"] = mrs.Version
	}
	if mrs.RuleSetType != "" {
		objectMap["ruleSetType"] = mrs.RuleSetType
	}
	return json.Marshal(objectMap)
}

// AsAzureManagedRuleSet is the BasicManagedRuleSet implementation for ManagedRuleSet.
func (mrs ManagedRuleSet) AsAzureManagedRuleSet() (*AzureManagedRuleSet, bool) {
	return nil, false
}

// AsManagedRuleSet is the BasicManagedRuleSet implementation for ManagedRuleSet.
func (mrs ManagedRuleSet) AsManagedRuleSet() (*ManagedRuleSet, bool) {
	return &mrs, true
}

// AsBasicManagedRuleSet is the BasicManagedRuleSet implementation for ManagedRuleSet.
func (mrs ManagedRuleSet) AsBasicManagedRuleSet() (BasicManagedRuleSet, bool) {
	return &mrs, true
}

// ManagedRuleSets defines ManagedRuleSets - array of managedRuleSet
type ManagedRuleSets struct {
	// RuleSets - List of rules
	RuleSets *[]BasicManagedRuleSet `json:"ruleSets,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ManagedRuleSets struct.
func (mrs *ManagedRuleSets) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "ruleSets":
			if v != nil {
				ruleSets, err := unmarshalBasicManagedRuleSetArray(*v)
				if err != nil {
					return err
				}
				mrs.RuleSets = &ruleSets
			}
		}
	}

	return nil
}

// MatchCondition1 define match conditions
type MatchCondition1 struct {
	// MatchVariable - Match Variable. Possible values include: 'RemoteAddr', 'RequestMethod', 'QueryString', 'PostArgs', 'RequestURI', 'RequestHeader', 'RequestBody'
	MatchVariable MatchCondition `json:"matchVariable,omitempty"`
	// Selector - Name of selector in RequestHeader or RequestBody to be matched
	Selector *string `json:"selector,omitempty"`
	// Operator - Describes operator to be matched. Possible values include: 'Any', 'IPMatch', 'GeoMatch', 'Equal', 'Contains', 'LessThan', 'GreaterThan', 'LessThanOrEqual', 'GreaterThanOrEqual', 'BeginsWith', 'EndsWith'
	Operator Operator `json:"operator,omitempty"`
	// NegateCondition - Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`
	// MatchValue - Match value
	MatchValue *[]string `json:"matchValue,omitempty"`
}

// PoliciesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PoliciesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *PoliciesDeleteFuture) Result(client PoliciesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "frontdoor.PoliciesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("frontdoor.PoliciesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// PolicySettings defines contents of a web application firewall global configuration
type PolicySettings struct {
	// EnabledState - describes if the policy is in enabled state or disabled state. Possible values include: 'EnabledStateDisabled', 'EnabledStateEnabled'
	EnabledState EnabledState `json:"enabledState,omitempty"`
	// Mode - Describes if it is in detection mode  or prevention mode at policy level. Possible values include: 'Prevention', 'Detection'
	Mode Mode `json:"mode,omitempty"`
}

// Properties the JSON object that contains the properties required to create an endpoint.
type Properties struct {
	// ResourceState - Resource status of the Front Door. Possible values include: 'ResourceStateCreating', 'ResourceStateEnabling', 'ResourceStateEnabled', 'ResourceStateDisabling', 'ResourceStateDisabled', 'ResourceStateDeleting'
	ResourceState ResourceState `json:"resourceState,omitempty"`
	// ProvisioningState - Provisioning state of the Front Door.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// Cname - The host that each frontendEndpoint must CNAME to.
	Cname *string `json:"cname,omitempty"`
	// FriendlyName - A friendly name for the frontDoor
	FriendlyName *string `json:"friendlyName,omitempty"`
	// RoutingRules - Routing rules associated with this Front Door.
	RoutingRules *[]RoutingRule `json:"routingRules,omitempty"`
	// LoadBalancingSettings - Load balancing settings associated with this Front Door instance.
	LoadBalancingSettings *[]LoadBalancingSettingsModel `json:"loadBalancingSettings,omitempty"`
	// HealthProbeSettings - Health probe settings associated with this Front Door instance.
	HealthProbeSettings *[]HealthProbeSettingsModel `json:"healthProbeSettings,omitempty"`
	// BackendPools - Backend pools available to routing rules.
	BackendPools *[]BackendPool `json:"backendPools,omitempty"`
	// FrontendEndpoints - Frontend endpoints available to routing rules.
	FrontendEndpoints *[]FrontendEndpoint `json:"frontendEndpoints,omitempty"`
	// EnabledState - Operational status of the Front Door load balancer. Permitted values are 'Enabled' or 'Disabled'. Possible values include: 'EnabledStateEnumEnabled', 'EnabledStateEnumDisabled'
	EnabledState EnabledStateEnum `json:"enabledState,omitempty"`
}

// PurgeParameters parameters required for content purge.
type PurgeParameters struct {
	// ContentPaths - The path to the content to be purged. Can describe a file path or a wild card directory.
	ContentPaths *[]string `json:"contentPaths,omitempty"`
}

// Resource common resource representation.
type Resource struct {
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	if r.Name != nil {
		objectMap["name"] = r.Name
	}
	if r.Type != nil {
		objectMap["type"] = r.Type
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// RoutingRule a routing rule represents a specification for traffic to treat and where to send it, along
// with health probe information.
type RoutingRule struct {
	autorest.Response `json:"-"`
	// RoutingRuleProperties - Properties of the Front Door Routing Rule
	*RoutingRuleProperties `json:"properties,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for RoutingRule.
func (rr RoutingRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rr.RoutingRuleProperties != nil {
		objectMap["properties"] = rr.RoutingRuleProperties
	}
	if rr.Name != nil {
		objectMap["name"] = rr.Name
	}
	if rr.Type != nil {
		objectMap["type"] = rr.Type
	}
	if rr.ID != nil {
		objectMap["id"] = rr.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RoutingRule struct.
func (rr *RoutingRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var routingRuleProperties RoutingRuleProperties
				err = json.Unmarshal(*v, &routingRuleProperties)
				if err != nil {
					return err
				}
				rr.RoutingRuleProperties = &routingRuleProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rr.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rr.ID = &ID
			}
		}
	}

	return nil
}

// RoutingRuleListResult result of the request to list Routing Rules. It contains a list of Routing Rule
// objects and a URL link to get the next set of results.
type RoutingRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Routing Rules within a Front Door.
	Value *[]RoutingRule `json:"value,omitempty"`
	// NextLink - URL to get the next set of RoutingRule objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// RoutingRuleListResultIterator provides access to a complete listing of RoutingRule values.
type RoutingRuleListResultIterator struct {
	i    int
	page RoutingRuleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RoutingRuleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoutingRuleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RoutingRuleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RoutingRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RoutingRuleListResultIterator) Response() RoutingRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RoutingRuleListResultIterator) Value() RoutingRule {
	if !iter.page.NotDone() {
		return RoutingRule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RoutingRuleListResultIterator type.
func NewRoutingRuleListResultIterator(page RoutingRuleListResultPage) RoutingRuleListResultIterator {
	return RoutingRuleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rrlr RoutingRuleListResult) IsEmpty() bool {
	return rrlr.Value == nil || len(*rrlr.Value) == 0
}

// routingRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rrlr RoutingRuleListResult) routingRuleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if rrlr.NextLink == nil || len(to.String(rrlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rrlr.NextLink)))
}

// RoutingRuleListResultPage contains a page of RoutingRule values.
type RoutingRuleListResultPage struct {
	fn   func(context.Context, RoutingRuleListResult) (RoutingRuleListResult, error)
	rrlr RoutingRuleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RoutingRuleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoutingRuleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.rrlr)
	if err != nil {
		return err
	}
	page.rrlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RoutingRuleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RoutingRuleListResultPage) NotDone() bool {
	return !page.rrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RoutingRuleListResultPage) Response() RoutingRuleListResult {
	return page.rrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RoutingRuleListResultPage) Values() []RoutingRule {
	if page.rrlr.IsEmpty() {
		return nil
	}
	return *page.rrlr.Value
}

// Creates a new instance of the RoutingRuleListResultPage type.
func NewRoutingRuleListResultPage(getNextPage func(context.Context, RoutingRuleListResult) (RoutingRuleListResult, error)) RoutingRuleListResultPage {
	return RoutingRuleListResultPage{fn: getNextPage}
}

// RoutingRuleProperties the JSON object that contains the properties required to create a routing rule.
type RoutingRuleProperties struct {
	// ResourceState - Resource status. Possible values include: 'ResourceStateCreating', 'ResourceStateEnabling', 'ResourceStateEnabled', 'ResourceStateDisabling', 'ResourceStateDisabled', 'ResourceStateDeleting'
	ResourceState ResourceState `json:"resourceState,omitempty"`
	// FrontendEndpoints - Frontend endpoints associated with this rule
	FrontendEndpoints *[]SubResource `json:"frontendEndpoints,omitempty"`
	// AcceptedProtocols - Protocol schemes to match for this rule
	AcceptedProtocols *[]Protocol `json:"acceptedProtocols,omitempty"`
	// PatternsToMatch - The route patterns of the rule.
	PatternsToMatch *[]string `json:"patternsToMatch,omitempty"`
	// CustomForwardingPath - A custom path used to rewrite resource paths matched by this rule. Leave empty to use incoming path.
	CustomForwardingPath *string `json:"customForwardingPath,omitempty"`
	// ForwardingProtocol - Protocol this rule will use when forwarding traffic to backends. Possible values include: 'HTTPOnly', 'HTTPSOnly', 'MatchRequest'
	ForwardingProtocol ForwardingProtocol `json:"forwardingProtocol,omitempty"`
	// CacheConfiguration - The caching configuration associated with this rule.
	CacheConfiguration *CacheConfiguration `json:"cacheConfiguration,omitempty"`
	// BackendPool - A reference to the BackendPool which this rule routes to.
	BackendPool *SubResource `json:"backendPool,omitempty"`
	// EnabledState - Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'. Possible values include: 'EnabledStateEnumEnabled', 'EnabledStateEnumDisabled'
	EnabledState EnabledStateEnum `json:"enabledState,omitempty"`
}

// RoutingRulesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type RoutingRulesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *RoutingRulesCreateOrUpdateFuture) Result(client RoutingRulesClient) (rr RoutingRule, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "frontdoor.RoutingRulesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("frontdoor.RoutingRulesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rr.Response.Response, err = future.GetResult(sender); err == nil && rr.Response.Response.StatusCode != http.StatusNoContent {
		rr, err = client.CreateOrUpdateResponder(rr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "frontdoor.RoutingRulesCreateOrUpdateFuture", "Result", rr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// RoutingRulesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RoutingRulesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *RoutingRulesDeleteFuture) Result(client RoutingRulesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "frontdoor.RoutingRulesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("frontdoor.RoutingRulesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// RoutingRuleUpdateParameters routing rules to apply to an endpoint
type RoutingRuleUpdateParameters struct {
	// FrontendEndpoints - Frontend endpoints associated with this rule
	FrontendEndpoints *[]SubResource `json:"frontendEndpoints,omitempty"`
	// AcceptedProtocols - Protocol schemes to match for this rule
	AcceptedProtocols *[]Protocol `json:"acceptedProtocols,omitempty"`
	// PatternsToMatch - The route patterns of the rule.
	PatternsToMatch *[]string `json:"patternsToMatch,omitempty"`
	// CustomForwardingPath - A custom path used to rewrite resource paths matched by this rule. Leave empty to use incoming path.
	CustomForwardingPath *string `json:"customForwardingPath,omitempty"`
	// ForwardingProtocol - Protocol this rule will use when forwarding traffic to backends. Possible values include: 'HTTPOnly', 'HTTPSOnly', 'MatchRequest'
	ForwardingProtocol ForwardingProtocol `json:"forwardingProtocol,omitempty"`
	// CacheConfiguration - The caching configuration associated with this rule.
	CacheConfiguration *CacheConfiguration `json:"cacheConfiguration,omitempty"`
	// BackendPool - A reference to the BackendPool which this rule routes to.
	BackendPool *SubResource `json:"backendPool,omitempty"`
	// EnabledState - Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'. Possible values include: 'EnabledStateEnumEnabled', 'EnabledStateEnumDisabled'
	EnabledState EnabledStateEnum `json:"enabledState,omitempty"`
}

// SubResource reference to another subresource.
type SubResource struct {
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// TagsObject tags object for patch operations.
type TagsObject struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for TagsObject.
func (toVar TagsObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if toVar.Tags != nil {
		objectMap["tags"] = toVar.Tags
	}
	return json.Marshal(objectMap)
}

// UpdateParameters the properties needed to update a Front Door
type UpdateParameters struct {
	// FriendlyName - A friendly name for the frontDoor
	FriendlyName *string `json:"friendlyName,omitempty"`
	// RoutingRules - Routing rules associated with this Front Door.
	RoutingRules *[]RoutingRule `json:"routingRules,omitempty"`
	// LoadBalancingSettings - Load balancing settings associated with this Front Door instance.
	LoadBalancingSettings *[]LoadBalancingSettingsModel `json:"loadBalancingSettings,omitempty"`
	// HealthProbeSettings - Health probe settings associated with this Front Door instance.
	HealthProbeSettings *[]HealthProbeSettingsModel `json:"healthProbeSettings,omitempty"`
	// BackendPools - Backend pools available to routing rules.
	BackendPools *[]BackendPool `json:"backendPools,omitempty"`
	// FrontendEndpoints - Frontend endpoints available to routing rules.
	FrontendEndpoints *[]FrontendEndpoint `json:"frontendEndpoints,omitempty"`
	// EnabledState - Operational status of the Front Door load balancer. Permitted values are 'Enabled' or 'Disabled'. Possible values include: 'EnabledStateEnumEnabled', 'EnabledStateEnumDisabled'
	EnabledState EnabledStateEnum `json:"enabledState,omitempty"`
}

// ValidateCustomDomainInput input of the custom domain to be validated for DNS mapping.
type ValidateCustomDomainInput struct {
	// HostName - The host name of the custom domain. Must be a domain name.
	HostName *string `json:"hostName,omitempty"`
}

// ValidateCustomDomainOutput output of custom domain validation.
type ValidateCustomDomainOutput struct {
	autorest.Response `json:"-"`
	// CustomDomainValidated - Indicates whether the custom domain is valid or not.
	CustomDomainValidated *bool `json:"customDomainValidated,omitempty"`
	// Reason - The reason why the custom domain is not valid.
	Reason *string `json:"reason,omitempty"`
	// Message - Error message describing why the custom domain is not valid.
	Message *string `json:"message,omitempty"`
}

// WebApplicationFirewallPolicy1 defines web application firewall policy.
type WebApplicationFirewallPolicy1 struct {
	autorest.Response `json:"-"`
	// WebApplicationFirewallPolicyPropertiesFormat - Properties of the web application firewall policy.
	*WebApplicationFirewallPolicyPropertiesFormat `json:"properties,omitempty"`
	// Etag - Gets a unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for WebApplicationFirewallPolicy1.
func (wafp1 WebApplicationFirewallPolicy1) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wafp1.WebApplicationFirewallPolicyPropertiesFormat != nil {
		objectMap["properties"] = wafp1.WebApplicationFirewallPolicyPropertiesFormat
	}
	if wafp1.Etag != nil {
		objectMap["etag"] = wafp1.Etag
	}
	if wafp1.ID != nil {
		objectMap["id"] = wafp1.ID
	}
	if wafp1.Name != nil {
		objectMap["name"] = wafp1.Name
	}
	if wafp1.Type != nil {
		objectMap["type"] = wafp1.Type
	}
	if wafp1.Location != nil {
		objectMap["location"] = wafp1.Location
	}
	if wafp1.Tags != nil {
		objectMap["tags"] = wafp1.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WebApplicationFirewallPolicy1 struct.
func (wafp1 *WebApplicationFirewallPolicy1) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var webApplicationFirewallPolicyPropertiesFormat WebApplicationFirewallPolicyPropertiesFormat
				err = json.Unmarshal(*v, &webApplicationFirewallPolicyPropertiesFormat)
				if err != nil {
					return err
				}
				wafp1.WebApplicationFirewallPolicyPropertiesFormat = &webApplicationFirewallPolicyPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				wafp1.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wafp1.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wafp1.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wafp1.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				wafp1.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				wafp1.Tags = tags
			}
		}
	}

	return nil
}

// WebApplicationFirewallPolicyListResult result of the request to list WebApplicationFirewallPolicies. It
// contains a list of WebApplicationFirewallPolicy objects and a URL link to get the next set of results.
type WebApplicationFirewallPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - List of WebApplicationFirewallPolicies within a resource group.
	Value *[]WebApplicationFirewallPolicy1 `json:"value,omitempty"`
	// NextLink - URL to get the next set of WebApplicationFirewallPolicy objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// WebApplicationFirewallPolicyListResultIterator provides access to a complete listing of
// WebApplicationFirewallPolicy1 values.
type WebApplicationFirewallPolicyListResultIterator struct {
	i    int
	page WebApplicationFirewallPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WebApplicationFirewallPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WebApplicationFirewallPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WebApplicationFirewallPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WebApplicationFirewallPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WebApplicationFirewallPolicyListResultIterator) Response() WebApplicationFirewallPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WebApplicationFirewallPolicyListResultIterator) Value() WebApplicationFirewallPolicy1 {
	if !iter.page.NotDone() {
		return WebApplicationFirewallPolicy1{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WebApplicationFirewallPolicyListResultIterator type.
func NewWebApplicationFirewallPolicyListResultIterator(page WebApplicationFirewallPolicyListResultPage) WebApplicationFirewallPolicyListResultIterator {
	return WebApplicationFirewallPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wafplr WebApplicationFirewallPolicyListResult) IsEmpty() bool {
	return wafplr.Value == nil || len(*wafplr.Value) == 0
}

// webApplicationFirewallPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wafplr WebApplicationFirewallPolicyListResult) webApplicationFirewallPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if wafplr.NextLink == nil || len(to.String(wafplr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wafplr.NextLink)))
}

// WebApplicationFirewallPolicyListResultPage contains a page of WebApplicationFirewallPolicy1 values.
type WebApplicationFirewallPolicyListResultPage struct {
	fn     func(context.Context, WebApplicationFirewallPolicyListResult) (WebApplicationFirewallPolicyListResult, error)
	wafplr WebApplicationFirewallPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WebApplicationFirewallPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WebApplicationFirewallPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.wafplr)
	if err != nil {
		return err
	}
	page.wafplr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WebApplicationFirewallPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WebApplicationFirewallPolicyListResultPage) NotDone() bool {
	return !page.wafplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WebApplicationFirewallPolicyListResultPage) Response() WebApplicationFirewallPolicyListResult {
	return page.wafplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WebApplicationFirewallPolicyListResultPage) Values() []WebApplicationFirewallPolicy1 {
	if page.wafplr.IsEmpty() {
		return nil
	}
	return *page.wafplr.Value
}

// Creates a new instance of the WebApplicationFirewallPolicyListResultPage type.
func NewWebApplicationFirewallPolicyListResultPage(getNextPage func(context.Context, WebApplicationFirewallPolicyListResult) (WebApplicationFirewallPolicyListResult, error)) WebApplicationFirewallPolicyListResultPage {
	return WebApplicationFirewallPolicyListResultPage{fn: getNextPage}
}

// WebApplicationFirewallPolicyPropertiesFormat defines web application firewall policy properties
type WebApplicationFirewallPolicyPropertiesFormat struct {
	// PolicySettings - Describes  policySettings for policy
	PolicySettings *PolicySettings `json:"policySettings,omitempty"`
	// CustomRules - Describes custom rules inside the policy
	CustomRules *CustomRules `json:"customRules,omitempty"`
	// ManagedRules - Describes managed rules inside the policy
	ManagedRules *ManagedRuleSets `json:"managedRules,omitempty"`
	// ProvisioningState - Provisioning state of the WebApplicationFirewallPolicy.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// ResourceState - Possible values include: 'WebApplicationFirewallPolicyCreating', 'WebApplicationFirewallPolicyEnabling', 'WebApplicationFirewallPolicyEnabled', 'WebApplicationFirewallPolicyDisabling', 'WebApplicationFirewallPolicyDisabled', 'WebApplicationFirewallPolicyDeleting'
	ResourceState WebApplicationFirewallPolicy `json:"resourceState,omitempty"`
}
