package resources

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/resources/mgmt/2015-11-01/resources"

// DeploymentMode enumerates the values for deployment mode.
type DeploymentMode string

const (
	// Complete ...
	Complete DeploymentMode = "Complete"
	// Incremental ...
	Incremental DeploymentMode = "Incremental"
)

// PossibleDeploymentModeValues returns an array of possible values for the DeploymentMode const type.
func PossibleDeploymentModeValues() []DeploymentMode {
	return []DeploymentMode{Complete, Incremental}
}

// BasicDependency deployment dependency information.
type BasicDependency struct {
	// ID - Gets or sets the ID of the dependency.
	ID *string `json:"id,omitempty"`
	// ResourceType - Gets or sets the dependency resource type.
	ResourceType *string `json:"resourceType,omitempty"`
	// ResourceName - Gets or sets the dependency resource name.
	ResourceName *string `json:"resourceName,omitempty"`
}

// Dependency deployment dependency information.
type Dependency struct {
	// DependsOn - Gets the list of dependencies.
	DependsOn *[]BasicDependency `json:"dependsOn,omitempty"`
	// ID - Gets or sets the ID of the dependency.
	ID *string `json:"id,omitempty"`
	// ResourceType - Gets or sets the dependency resource type.
	ResourceType *string `json:"resourceType,omitempty"`
	// ResourceName - Gets or sets the dependency resource name.
	ResourceName *string `json:"resourceName,omitempty"`
}

// Deployment deployment operation parameters.
type Deployment struct {
	// Properties - Gets or sets the deployment properties.
	Properties *DeploymentProperties `json:"properties,omitempty"`
}

// DeploymentExtended deployment information.
type DeploymentExtended struct {
	autorest.Response `json:"-"`
	// ID - Gets or sets the ID of the deployment.
	ID *string `json:"id,omitempty"`
	// Name - Gets or sets the name of the deployment.
	Name *string `json:"name,omitempty"`
	// Properties - Gets or sets deployment properties.
	Properties *DeploymentPropertiesExtended `json:"properties,omitempty"`
}

// DeploymentExtendedFilter deployment filter.
type DeploymentExtendedFilter struct {
	// ProvisioningState - Gets or sets the provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// DeploymentListResult list of deployments.
type DeploymentListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets the list of deployments.
	Value *[]DeploymentExtended `json:"value,omitempty"`
	// NextLink - Gets or sets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// DeploymentListResultIterator provides access to a complete listing of DeploymentExtended values.
type DeploymentListResultIterator struct {
	i    int
	page DeploymentListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DeploymentListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeploymentListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DeploymentListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DeploymentListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DeploymentListResultIterator) Response() DeploymentListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DeploymentListResultIterator) Value() DeploymentExtended {
	if !iter.page.NotDone() {
		return DeploymentExtended{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DeploymentListResultIterator type.
func NewDeploymentListResultIterator(page DeploymentListResultPage) DeploymentListResultIterator {
	return DeploymentListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dlr DeploymentListResult) IsEmpty() bool {
	return dlr.Value == nil || len(*dlr.Value) == 0
}

// deploymentListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dlr DeploymentListResult) deploymentListResultPreparer(ctx context.Context) (*http.Request, error) {
	if dlr.NextLink == nil || len(to.String(dlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dlr.NextLink)))
}

// DeploymentListResultPage contains a page of DeploymentExtended values.
type DeploymentListResultPage struct {
	fn  func(context.Context, DeploymentListResult) (DeploymentListResult, error)
	dlr DeploymentListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DeploymentListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeploymentListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.dlr)
	if err != nil {
		return err
	}
	page.dlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DeploymentListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DeploymentListResultPage) NotDone() bool {
	return !page.dlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DeploymentListResultPage) Response() DeploymentListResult {
	return page.dlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DeploymentListResultPage) Values() []DeploymentExtended {
	if page.dlr.IsEmpty() {
		return nil
	}
	return *page.dlr.Value
}

// Creates a new instance of the DeploymentListResultPage type.
func NewDeploymentListResultPage(getNextPage func(context.Context, DeploymentListResult) (DeploymentListResult, error)) DeploymentListResultPage {
	return DeploymentListResultPage{fn: getNextPage}
}

// DeploymentOperation deployment operation information.
type DeploymentOperation struct {
	autorest.Response `json:"-"`
	// ID - Gets or sets full deployment operation id.
	ID *string `json:"id,omitempty"`
	// OperationID - Gets or sets deployment operation id.
	OperationID *string `json:"operationId,omitempty"`
	// Properties - Gets or sets deployment properties.
	Properties *DeploymentOperationProperties `json:"properties,omitempty"`
}

// DeploymentOperationProperties deployment operation properties.
type DeploymentOperationProperties struct {
	// ProvisioningState - Gets or sets the state of the provisioning.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// Timestamp - Gets or sets the date and time of the operation.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// StatusCode - Gets or sets operation status code.
	StatusCode *string `json:"statusCode,omitempty"`
	// StatusMessage - Gets or sets operation status message.
	StatusMessage interface{} `json:"statusMessage,omitempty"`
	// TargetResource - Gets or sets the target resource.
	TargetResource *TargetResource `json:"targetResource,omitempty"`
}

// DeploymentOperationsListResult list of deployment operations.
type DeploymentOperationsListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets the list of deployments.
	Value *[]DeploymentOperation `json:"value,omitempty"`
	// NextLink - Gets or sets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// DeploymentOperationsListResultIterator provides access to a complete listing of DeploymentOperation
// values.
type DeploymentOperationsListResultIterator struct {
	i    int
	page DeploymentOperationsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DeploymentOperationsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeploymentOperationsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DeploymentOperationsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DeploymentOperationsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DeploymentOperationsListResultIterator) Response() DeploymentOperationsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DeploymentOperationsListResultIterator) Value() DeploymentOperation {
	if !iter.page.NotDone() {
		return DeploymentOperation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DeploymentOperationsListResultIterator type.
func NewDeploymentOperationsListResultIterator(page DeploymentOperationsListResultPage) DeploymentOperationsListResultIterator {
	return DeploymentOperationsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dolr DeploymentOperationsListResult) IsEmpty() bool {
	return dolr.Value == nil || len(*dolr.Value) == 0
}

// deploymentOperationsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dolr DeploymentOperationsListResult) deploymentOperationsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if dolr.NextLink == nil || len(to.String(dolr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dolr.NextLink)))
}

// DeploymentOperationsListResultPage contains a page of DeploymentOperation values.
type DeploymentOperationsListResultPage struct {
	fn   func(context.Context, DeploymentOperationsListResult) (DeploymentOperationsListResult, error)
	dolr DeploymentOperationsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DeploymentOperationsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeploymentOperationsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.dolr)
	if err != nil {
		return err
	}
	page.dolr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DeploymentOperationsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DeploymentOperationsListResultPage) NotDone() bool {
	return !page.dolr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DeploymentOperationsListResultPage) Response() DeploymentOperationsListResult {
	return page.dolr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DeploymentOperationsListResultPage) Values() []DeploymentOperation {
	if page.dolr.IsEmpty() {
		return nil
	}
	return *page.dolr.Value
}

// Creates a new instance of the DeploymentOperationsListResultPage type.
func NewDeploymentOperationsListResultPage(getNextPage func(context.Context, DeploymentOperationsListResult) (DeploymentOperationsListResult, error)) DeploymentOperationsListResultPage {
	return DeploymentOperationsListResultPage{fn: getNextPage}
}

// DeploymentProperties deployment properties.
type DeploymentProperties struct {
	// Template - Gets or sets the template content. Use only one of Template or TemplateLink.
	Template interface{} `json:"template,omitempty"`
	// TemplateLink - Gets or sets the URI referencing the template. Use only one of Template or TemplateLink.
	TemplateLink *TemplateLink `json:"templateLink,omitempty"`
	// Parameters - Deployment parameters. Use only one of Parameters or ParametersLink.
	Parameters interface{} `json:"parameters,omitempty"`
	// ParametersLink - Gets or sets the URI referencing the parameters. Use only one of Parameters or ParametersLink.
	ParametersLink *ParametersLink `json:"parametersLink,omitempty"`
	// Mode - Gets or sets the deployment mode. Possible values include: 'Incremental', 'Complete'
	Mode DeploymentMode `json:"mode,omitempty"`
}

// DeploymentPropertiesExtended deployment properties with additional details.
type DeploymentPropertiesExtended struct {
	// ProvisioningState - Gets or sets the state of the provisioning.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// CorrelationID - Gets or sets the correlation ID of the deployment.
	CorrelationID *string `json:"correlationId,omitempty"`
	// Timestamp - Gets or sets the timestamp of the template deployment.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Outputs - Gets or sets key/value pairs that represent deployment output.
	Outputs interface{} `json:"outputs,omitempty"`
	// Providers - Gets the list of resource providers needed for the deployment.
	Providers *[]Provider `json:"providers,omitempty"`
	// Dependencies - Gets the list of deployment dependencies.
	Dependencies *[]Dependency `json:"dependencies,omitempty"`
	// Template - Gets or sets the template content. Use only one of Template or TemplateLink.
	Template interface{} `json:"template,omitempty"`
	// TemplateLink - Gets or sets the URI referencing the template. Use only one of Template or TemplateLink.
	TemplateLink *TemplateLink `json:"templateLink,omitempty"`
	// Parameters - Deployment parameters. Use only one of Parameters or ParametersLink.
	Parameters interface{} `json:"parameters,omitempty"`
	// ParametersLink - Gets or sets the URI referencing the parameters. Use only one of Parameters or ParametersLink.
	ParametersLink *ParametersLink `json:"parametersLink,omitempty"`
	// Mode - Gets or sets the deployment mode. Possible values include: 'Incremental', 'Complete'
	Mode DeploymentMode `json:"mode,omitempty"`
}

// DeploymentsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DeploymentsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DeploymentsCreateOrUpdateFuture) Result(client DeploymentsClient) (de DeploymentExtended, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.DeploymentsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("resources.DeploymentsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if de.Response.Response, err = future.GetResult(sender); err == nil && de.Response.Response.StatusCode != http.StatusNoContent {
		de, err = client.CreateOrUpdateResponder(de.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "resources.DeploymentsCreateOrUpdateFuture", "Result", de.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DeploymentsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DeploymentsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DeploymentsDeleteFuture) Result(client DeploymentsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.DeploymentsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("resources.DeploymentsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DeploymentValidateResult information from validate template deployment response.
type DeploymentValidateResult struct {
	autorest.Response `json:"-"`
	// Error - Gets or sets validation error.
	Error *ManagementErrorWithDetails `json:"error,omitempty"`
	// Properties - Gets or sets the template deployment properties.
	Properties *DeploymentPropertiesExtended `json:"properties,omitempty"`
}

// GenericResource resource information.
type GenericResource struct {
	autorest.Response `json:"-"`
	// Plan - Gets or sets the plan of the resource.
	Plan *Plan `json:"plan,omitempty"`
	// Properties - Gets or sets the resource properties.
	Properties interface{} `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for GenericResource.
func (gr GenericResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gr.Plan != nil {
		objectMap["plan"] = gr.Plan
	}
	if gr.Properties != nil {
		objectMap["properties"] = gr.Properties
	}
	if gr.ID != nil {
		objectMap["id"] = gr.ID
	}
	if gr.Name != nil {
		objectMap["name"] = gr.Name
	}
	if gr.Type != nil {
		objectMap["type"] = gr.Type
	}
	if gr.Location != nil {
		objectMap["location"] = gr.Location
	}
	if gr.Tags != nil {
		objectMap["tags"] = gr.Tags
	}
	return json.Marshal(objectMap)
}

// GenericResourceFilter resource filter.
type GenericResourceFilter struct {
	// ResourceType - Gets or sets the resource type.
	ResourceType *string `json:"resourceType,omitempty"`
	// Tagname - Gets or sets the tag name.
	Tagname *string `json:"tagname,omitempty"`
	// Tagvalue - Gets or sets the tag value.
	Tagvalue *string `json:"tagvalue,omitempty"`
}

// Group resource group information.
type Group struct {
	autorest.Response `json:"-"`
	// ID - Gets the ID of the resource group.
	ID *string `json:"id,omitempty"`
	// Name - Gets or sets the Name of the resource group.
	Name       *string          `json:"name,omitempty"`
	Properties *GroupProperties `json:"properties,omitempty"`
	// Location - Gets or sets the location of the resource group. It cannot be changed after the resource group has been created. Has to be one of the supported Azure Locations, such as West US, East US, West Europe, East Asia, etc.
	Location *string `json:"location,omitempty"`
	// Tags - Gets or sets the tags attached to the resource group.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Group.
func (g Group) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if g.ID != nil {
		objectMap["id"] = g.ID
	}
	if g.Name != nil {
		objectMap["name"] = g.Name
	}
	if g.Properties != nil {
		objectMap["properties"] = g.Properties
	}
	if g.Location != nil {
		objectMap["location"] = g.Location
	}
	if g.Tags != nil {
		objectMap["tags"] = g.Tags
	}
	return json.Marshal(objectMap)
}

// GroupFilter resource group filter.
type GroupFilter struct {
	// TagName - Gets or sets the tag name.
	TagName *string `json:"tagName,omitempty"`
	// TagValue - Gets or sets the tag value.
	TagValue *string `json:"tagValue,omitempty"`
}

// GroupListResult list of resource groups.
type GroupListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets the list of resource groups.
	Value *[]Group `json:"value,omitempty"`
	// NextLink - Gets or sets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// GroupListResultIterator provides access to a complete listing of Group values.
type GroupListResultIterator struct {
	i    int
	page GroupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *GroupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GroupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *GroupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter GroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter GroupListResultIterator) Response() GroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter GroupListResultIterator) Value() Group {
	if !iter.page.NotDone() {
		return Group{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the GroupListResultIterator type.
func NewGroupListResultIterator(page GroupListResultPage) GroupListResultIterator {
	return GroupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (glr GroupListResult) IsEmpty() bool {
	return glr.Value == nil || len(*glr.Value) == 0
}

// groupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (glr GroupListResult) groupListResultPreparer(ctx context.Context) (*http.Request, error) {
	if glr.NextLink == nil || len(to.String(glr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(glr.NextLink)))
}

// GroupListResultPage contains a page of Group values.
type GroupListResultPage struct {
	fn  func(context.Context, GroupListResult) (GroupListResult, error)
	glr GroupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *GroupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GroupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.glr)
	if err != nil {
		return err
	}
	page.glr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *GroupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page GroupListResultPage) NotDone() bool {
	return !page.glr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page GroupListResultPage) Response() GroupListResult {
	return page.glr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page GroupListResultPage) Values() []Group {
	if page.glr.IsEmpty() {
		return nil
	}
	return *page.glr.Value
}

// Creates a new instance of the GroupListResultPage type.
func NewGroupListResultPage(getNextPage func(context.Context, GroupListResult) (GroupListResult, error)) GroupListResultPage {
	return GroupListResultPage{fn: getNextPage}
}

// GroupProperties the resource group properties.
type GroupProperties struct {
	// ProvisioningState - Gets resource group provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// GroupsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type GroupsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *GroupsDeleteFuture) Result(client GroupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.GroupsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("resources.GroupsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ListResult list of resource groups.
type ListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets the list of resource groups.
	Value *[]GenericResource `json:"value,omitempty"`
	// NextLink - Gets or sets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListResultIterator provides access to a complete listing of GenericResource values.
type ListResultIterator struct {
	i    int
	page ListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListResultIterator) Response() ListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListResultIterator) Value() GenericResource {
	if !iter.page.NotDone() {
		return GenericResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListResultIterator type.
func NewListResultIterator(page ListResultPage) ListResultIterator {
	return ListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lr ListResult) IsEmpty() bool {
	return lr.Value == nil || len(*lr.Value) == 0
}

// listResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lr ListResult) listResultPreparer(ctx context.Context) (*http.Request, error) {
	if lr.NextLink == nil || len(to.String(lr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lr.NextLink)))
}

// ListResultPage contains a page of GenericResource values.
type ListResultPage struct {
	fn func(context.Context, ListResult) (ListResult, error)
	lr ListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.lr)
	if err != nil {
		return err
	}
	page.lr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListResultPage) NotDone() bool {
	return !page.lr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListResultPage) Response() ListResult {
	return page.lr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListResultPage) Values() []GenericResource {
	if page.lr.IsEmpty() {
		return nil
	}
	return *page.lr.Value
}

// Creates a new instance of the ListResultPage type.
func NewListResultPage(getNextPage func(context.Context, ListResult) (ListResult, error)) ListResultPage {
	return ListResultPage{fn: getNextPage}
}

// ManagementError ...
type ManagementError struct {
	// Code - Gets or sets the error code returned from the server.
	Code *string `json:"code,omitempty"`
	// Message - Gets or sets the error message returned from the server.
	Message *string `json:"message,omitempty"`
	// Target - Gets or sets the target of the error.
	Target *string `json:"target,omitempty"`
}

// ManagementErrorWithDetails ...
type ManagementErrorWithDetails struct {
	// Details - Gets or sets validation error.
	Details *[]ManagementError `json:"details,omitempty"`
	// Code - Gets or sets the error code returned from the server.
	Code *string `json:"code,omitempty"`
	// Message - Gets or sets the error message returned from the server.
	Message *string `json:"message,omitempty"`
	// Target - Gets or sets the target of the error.
	Target *string `json:"target,omitempty"`
}

// MoveInfo parameters of move resources.
type MoveInfo struct {
	// ResourcesProperty - Gets or sets the ids of the resources.
	ResourcesProperty *[]string `json:"resources,omitempty"`
	// TargetResourceGroup - The target resource group.
	TargetResourceGroup *string `json:"targetResourceGroup,omitempty"`
}

// MoveResourcesFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type MoveResourcesFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *MoveResourcesFuture) Result(client Client) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.MoveResourcesFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("resources.MoveResourcesFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ParametersLink entity representing the reference to the deployment parameters.
type ParametersLink struct {
	// URI - URI referencing the template.
	URI *string `json:"uri,omitempty"`
	// ContentVersion - If included it must match the ContentVersion in the template.
	ContentVersion *string `json:"contentVersion,omitempty"`
}

// Plan plan for the resource.
type Plan struct {
	// Name - Gets or sets the plan ID.
	Name *string `json:"name,omitempty"`
	// Publisher - Gets or sets the publisher ID.
	Publisher *string `json:"publisher,omitempty"`
	// Product - Gets or sets the offer ID.
	Product *string `json:"product,omitempty"`
	// PromotionCode - Gets or sets the promotion code.
	PromotionCode *string `json:"promotionCode,omitempty"`
}

// PolicyAssignment policy assignment.
type PolicyAssignment struct {
	autorest.Response `json:"-"`
	// Properties - Gets or sets the policy assignment properties.
	Properties *PolicyAssignmentProperties `json:"properties,omitempty"`
	// Name - Gets or sets the policy assignment name.
	Name *string `json:"name,omitempty"`
}

// PolicyAssignmentListResult policy assignment list operation result.
type PolicyAssignmentListResult struct {
	autorest.Response `json:"-"`
	// Value - Policy assignment list.
	Value *[]PolicyAssignment `json:"value,omitempty"`
	// NextLink - Gets or sets the URL to get the next set of policy assignment results.
	NextLink *string `json:"nextLink,omitempty"`
}

// PolicyAssignmentListResultIterator provides access to a complete listing of PolicyAssignment values.
type PolicyAssignmentListResultIterator struct {
	i    int
	page PolicyAssignmentListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PolicyAssignmentListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyAssignmentListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PolicyAssignmentListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PolicyAssignmentListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PolicyAssignmentListResultIterator) Response() PolicyAssignmentListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PolicyAssignmentListResultIterator) Value() PolicyAssignment {
	if !iter.page.NotDone() {
		return PolicyAssignment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PolicyAssignmentListResultIterator type.
func NewPolicyAssignmentListResultIterator(page PolicyAssignmentListResultPage) PolicyAssignmentListResultIterator {
	return PolicyAssignmentListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (palr PolicyAssignmentListResult) IsEmpty() bool {
	return palr.Value == nil || len(*palr.Value) == 0
}

// policyAssignmentListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (palr PolicyAssignmentListResult) policyAssignmentListResultPreparer(ctx context.Context) (*http.Request, error) {
	if palr.NextLink == nil || len(to.String(palr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(palr.NextLink)))
}

// PolicyAssignmentListResultPage contains a page of PolicyAssignment values.
type PolicyAssignmentListResultPage struct {
	fn   func(context.Context, PolicyAssignmentListResult) (PolicyAssignmentListResult, error)
	palr PolicyAssignmentListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PolicyAssignmentListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyAssignmentListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.palr)
	if err != nil {
		return err
	}
	page.palr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PolicyAssignmentListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PolicyAssignmentListResultPage) NotDone() bool {
	return !page.palr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PolicyAssignmentListResultPage) Response() PolicyAssignmentListResult {
	return page.palr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PolicyAssignmentListResultPage) Values() []PolicyAssignment {
	if page.palr.IsEmpty() {
		return nil
	}
	return *page.palr.Value
}

// Creates a new instance of the PolicyAssignmentListResultPage type.
func NewPolicyAssignmentListResultPage(getNextPage func(context.Context, PolicyAssignmentListResult) (PolicyAssignmentListResult, error)) PolicyAssignmentListResultPage {
	return PolicyAssignmentListResultPage{fn: getNextPage}
}

// PolicyAssignmentProperties policy Assignment properties.
type PolicyAssignmentProperties struct {
	// Scope - Gets or sets the policy assignment scope.
	Scope *string `json:"scope,omitempty"`
	// DisplayName - Gets or sets the policy assignment display name.
	DisplayName *string `json:"displayName,omitempty"`
	// PolicyDefinitionID - Gets or sets the policy definition Id.
	PolicyDefinitionID *string `json:"policyDefinitionId,omitempty"`
}

// PolicyDefinition policy definition.
type PolicyDefinition struct {
	autorest.Response `json:"-"`
	// Properties - Gets or sets the policy definition properties.
	Properties *PolicyDefinitionProperties `json:"properties,omitempty"`
	// Name - Gets or sets the policy definition name.
	Name *string `json:"name,omitempty"`
}

// PolicyDefinitionProperties policy definition properties.
type PolicyDefinitionProperties struct {
	// Description - Gets or sets the policy definition description.
	Description *string `json:"description,omitempty"`
	// DisplayName - Gets or sets the policy definition display name.
	DisplayName *string `json:"displayName,omitempty"`
	// PolicyRule - The policy rule json.
	PolicyRule interface{} `json:"policyRule,omitempty"`
}

// Provider resource provider information.
type Provider struct {
	autorest.Response `json:"-"`
	// ID - Gets or sets the provider id.
	ID *string `json:"id,omitempty"`
	// Namespace - Gets or sets the namespace of the provider.
	Namespace *string `json:"namespace,omitempty"`
	// RegistrationState - Gets or sets the registration state of the provider.
	RegistrationState *string `json:"registrationState,omitempty"`
	// ResourceTypes - Gets or sets the collection of provider resource types.
	ResourceTypes *[]ProviderResourceType `json:"resourceTypes,omitempty"`
}

// ProviderListResult list of resource providers.
type ProviderListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets the list of resource providers.
	Value *[]Provider `json:"value,omitempty"`
	// NextLink - Gets or sets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProviderListResultIterator provides access to a complete listing of Provider values.
type ProviderListResultIterator struct {
	i    int
	page ProviderListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProviderListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProviderListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProviderListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProviderListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProviderListResultIterator) Response() ProviderListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProviderListResultIterator) Value() Provider {
	if !iter.page.NotDone() {
		return Provider{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProviderListResultIterator type.
func NewProviderListResultIterator(page ProviderListResultPage) ProviderListResultIterator {
	return ProviderListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (plr ProviderListResult) IsEmpty() bool {
	return plr.Value == nil || len(*plr.Value) == 0
}

// providerListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (plr ProviderListResult) providerListResultPreparer(ctx context.Context) (*http.Request, error) {
	if plr.NextLink == nil || len(to.String(plr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(plr.NextLink)))
}

// ProviderListResultPage contains a page of Provider values.
type ProviderListResultPage struct {
	fn  func(context.Context, ProviderListResult) (ProviderListResult, error)
	plr ProviderListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProviderListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProviderListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.plr)
	if err != nil {
		return err
	}
	page.plr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProviderListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProviderListResultPage) NotDone() bool {
	return !page.plr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProviderListResultPage) Response() ProviderListResult {
	return page.plr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProviderListResultPage) Values() []Provider {
	if page.plr.IsEmpty() {
		return nil
	}
	return *page.plr.Value
}

// Creates a new instance of the ProviderListResultPage type.
func NewProviderListResultPage(getNextPage func(context.Context, ProviderListResult) (ProviderListResult, error)) ProviderListResultPage {
	return ProviderListResultPage{fn: getNextPage}
}

// ProviderOperationDefinition resource provider operation information.
type ProviderOperationDefinition struct {
	// Name - Gets or sets the provider operation name.
	Name *string `json:"name,omitempty"`
	// Display - Gets or sets the display property of the provider operation.
	Display *ProviderOperationDisplayProperties `json:"display,omitempty"`
}

// ProviderOperationDetailListResult list of resource provider operations.
type ProviderOperationDetailListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets the list of resource provider operations.
	Value *[]ProviderOperationDefinition `json:"value,omitempty"`
	// NextLink - URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProviderOperationDetailListResultIterator provides access to a complete listing of
// ProviderOperationDefinition values.
type ProviderOperationDetailListResultIterator struct {
	i    int
	page ProviderOperationDetailListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProviderOperationDetailListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProviderOperationDetailListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProviderOperationDetailListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProviderOperationDetailListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProviderOperationDetailListResultIterator) Response() ProviderOperationDetailListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProviderOperationDetailListResultIterator) Value() ProviderOperationDefinition {
	if !iter.page.NotDone() {
		return ProviderOperationDefinition{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProviderOperationDetailListResultIterator type.
func NewProviderOperationDetailListResultIterator(page ProviderOperationDetailListResultPage) ProviderOperationDetailListResultIterator {
	return ProviderOperationDetailListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (podlr ProviderOperationDetailListResult) IsEmpty() bool {
	return podlr.Value == nil || len(*podlr.Value) == 0
}

// providerOperationDetailListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (podlr ProviderOperationDetailListResult) providerOperationDetailListResultPreparer(ctx context.Context) (*http.Request, error) {
	if podlr.NextLink == nil || len(to.String(podlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(podlr.NextLink)))
}

// ProviderOperationDetailListResultPage contains a page of ProviderOperationDefinition values.
type ProviderOperationDetailListResultPage struct {
	fn    func(context.Context, ProviderOperationDetailListResult) (ProviderOperationDetailListResult, error)
	podlr ProviderOperationDetailListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProviderOperationDetailListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProviderOperationDetailListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.podlr)
	if err != nil {
		return err
	}
	page.podlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProviderOperationDetailListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProviderOperationDetailListResultPage) NotDone() bool {
	return !page.podlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProviderOperationDetailListResultPage) Response() ProviderOperationDetailListResult {
	return page.podlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProviderOperationDetailListResultPage) Values() []ProviderOperationDefinition {
	if page.podlr.IsEmpty() {
		return nil
	}
	return *page.podlr.Value
}

// Creates a new instance of the ProviderOperationDetailListResultPage type.
func NewProviderOperationDetailListResultPage(getNextPage func(context.Context, ProviderOperationDetailListResult) (ProviderOperationDetailListResult, error)) ProviderOperationDetailListResultPage {
	return ProviderOperationDetailListResultPage{fn: getNextPage}
}

// ProviderOperationDisplayProperties resource provider operation's display properties.
type ProviderOperationDisplayProperties struct {
	// Publisher - Gets or sets operation description.
	Publisher *string `json:"publisher,omitempty"`
	// Provider - Gets or sets operation provider.
	Provider *string `json:"provider,omitempty"`
	// Resource - Gets or sets operation resource.
	Resource *string `json:"resource,omitempty"`
	// Operation - Gets or sets operation.
	Operation *string `json:"operation,omitempty"`
	// Description - Gets or sets operation description.
	Description *string `json:"description,omitempty"`
}

// ProviderResourceType resource type managed by the resource provider.
type ProviderResourceType struct {
	// ResourceType - Gets or sets the resource type.
	ResourceType *string `json:"resourceType,omitempty"`
	// Locations - Gets or sets the collection of locations where this resource type can be created in.
	Locations *[]string `json:"locations,omitempty"`
	// APIVersions - Gets or sets the api version.
	APIVersions *[]string `json:"apiVersions,omitempty"`
	// Properties - Gets or sets the properties.
	Properties map[string]*string `json:"properties"`
}

// MarshalJSON is the custom marshaler for ProviderResourceType.
func (prt ProviderResourceType) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if prt.ResourceType != nil {
		objectMap["resourceType"] = prt.ResourceType
	}
	if prt.Locations != nil {
		objectMap["locations"] = prt.Locations
	}
	if prt.APIVersions != nil {
		objectMap["apiVersions"] = prt.APIVersions
	}
	if prt.Properties != nil {
		objectMap["properties"] = prt.Properties
	}
	return json.Marshal(objectMap)
}

// Resource ...
type Resource struct {
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	if r.Name != nil {
		objectMap["name"] = r.Name
	}
	if r.Type != nil {
		objectMap["type"] = r.Type
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// SubResource ...
type SubResource struct {
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// TagCount tag count.
type TagCount struct {
	// Type - Type of count.
	Type *string `json:"type,omitempty"`
	// Value - Value of count.
	Value *string `json:"value,omitempty"`
}

// TagDetails tag details.
type TagDetails struct {
	autorest.Response `json:"-"`
	// ID - Gets or sets the tag ID.
	ID *string `json:"id,omitempty"`
	// TagName - Gets or sets the tag name.
	TagName *string `json:"tagName,omitempty"`
	// Count - Gets or sets the tag count.
	Count *TagCount `json:"count,omitempty"`
	// Values - Gets or sets the list of tag values.
	Values *[]TagValue `json:"values,omitempty"`
}

// TagsListResult list of subscription tags.
type TagsListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets the list of tags.
	Value *[]TagDetails `json:"value,omitempty"`
	// NextLink - Gets or sets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// TagsListResultIterator provides access to a complete listing of TagDetails values.
type TagsListResultIterator struct {
	i    int
	page TagsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TagsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TagsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TagsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TagsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TagsListResultIterator) Response() TagsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TagsListResultIterator) Value() TagDetails {
	if !iter.page.NotDone() {
		return TagDetails{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TagsListResultIterator type.
func NewTagsListResultIterator(page TagsListResultPage) TagsListResultIterator {
	return TagsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tlr TagsListResult) IsEmpty() bool {
	return tlr.Value == nil || len(*tlr.Value) == 0
}

// tagsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tlr TagsListResult) tagsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if tlr.NextLink == nil || len(to.String(tlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tlr.NextLink)))
}

// TagsListResultPage contains a page of TagDetails values.
type TagsListResultPage struct {
	fn  func(context.Context, TagsListResult) (TagsListResult, error)
	tlr TagsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TagsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TagsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.tlr)
	if err != nil {
		return err
	}
	page.tlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TagsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TagsListResultPage) NotDone() bool {
	return !page.tlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TagsListResultPage) Response() TagsListResult {
	return page.tlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TagsListResultPage) Values() []TagDetails {
	if page.tlr.IsEmpty() {
		return nil
	}
	return *page.tlr.Value
}

// Creates a new instance of the TagsListResultPage type.
func NewTagsListResultPage(getNextPage func(context.Context, TagsListResult) (TagsListResult, error)) TagsListResultPage {
	return TagsListResultPage{fn: getNextPage}
}

// TagValue tag information.
type TagValue struct {
	autorest.Response `json:"-"`
	// ID - Gets or sets the tag ID.
	ID *string `json:"id,omitempty"`
	// TagValue - Gets or sets the tag value.
	TagValue *string `json:"tagValue,omitempty"`
	// Count - Gets or sets the tag value count.
	Count *TagCount `json:"count,omitempty"`
}

// TargetResource target resource.
type TargetResource struct {
	// ID - Gets or sets the ID of the resource.
	ID *string `json:"id,omitempty"`
	// ResourceName - Gets or sets the name of the resource.
	ResourceName *string `json:"resourceName,omitempty"`
	// ResourceType - Gets or sets the type of the resource.
	ResourceType *string `json:"resourceType,omitempty"`
}

// TemplateLink entity representing the reference to the template.
type TemplateLink struct {
	// URI - URI referencing the template.
	URI *string `json:"uri,omitempty"`
	// ContentVersion - If included it must match the ContentVersion in the template.
	ContentVersion *string `json:"contentVersion,omitempty"`
}

// UpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type UpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *UpdateFuture) Result(client Client) (gr GenericResource, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.UpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("resources.UpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if gr.Response.Response, err = future.GetResult(sender); err == nil && gr.Response.Response.StatusCode != http.StatusNoContent {
		gr, err = client.UpdateResponder(gr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "resources.UpdateFuture", "Result", gr.Response.Response, "Failure responding to request")
		}
	}
	return
}
