package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeBatchResult invokes the alidns.DescribeBatchResult API synchronously
// api document: https://help.aliyun.com/api/alidns/describebatchresult.html
func (client *Client) DescribeBatchResult(request *DescribeBatchResultRequest) (response *DescribeBatchResultResponse, err error) {
	response = CreateDescribeBatchResultResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeBatchResultWithChan invokes the alidns.DescribeBatchResult API asynchronously
// api document: https://help.aliyun.com/api/alidns/describebatchresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeBatchResultWithChan(request *DescribeBatchResultRequest) (<-chan *DescribeBatchResultResponse, <-chan error) {
	responseChan := make(chan *DescribeBatchResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeBatchResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeBatchResultWithCallback invokes the alidns.DescribeBatchResult API asynchronously
// api document: https://help.aliyun.com/api/alidns/describebatchresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeBatchResultWithCallback(request *DescribeBatchResultRequest, callback func(response *DescribeBatchResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeBatchResultResponse
		var err error
		defer close(result)
		response, err = client.DescribeBatchResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeBatchResultRequest is the request struct for api DescribeBatchResult
type DescribeBatchResultRequest struct {
	*requests.RpcRequest
	Lang         string `position:"Query" name:"Lang"`
	UserClientIp string `position:"Query" name:"UserClientIp"`
	TraceId      string `position:"Query" name:"TraceId"`
}

// DescribeBatchResultResponse is the response struct for api DescribeBatchResult
type DescribeBatchResultResponse struct {
	*responses.BaseResponse
	RequestId     string      `json:"RequestId" xml:"RequestId"`
	TraceId       string      `json:"TraceId" xml:"TraceId"`
	Status        int         `json:"Status" xml:"Status"`
	BatchCount    int         `json:"BatchCount" xml:"BatchCount"`
	SuccessNumber int         `json:"SuccessNumber" xml:"SuccessNumber"`
	FailResults   FailResults `json:"FailResults" xml:"FailResults"`
}

// CreateDescribeBatchResultRequest creates a request to invoke DescribeBatchResult API
func CreateDescribeBatchResultRequest() (request *DescribeBatchResultRequest) {
	request = &DescribeBatchResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "DescribeBatchResult", "", "")
	return
}

// CreateDescribeBatchResultResponse creates a response to parse from DescribeBatchResult response
func CreateDescribeBatchResultResponse() (response *DescribeBatchResultResponse) {
	response = &DescribeBatchResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
