package cas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateUserCertificate invokes the cas.CreateUserCertificate API synchronously
// api document: https://help.aliyun.com/api/cas/createusercertificate.html
func (client *Client) CreateUserCertificate(request *CreateUserCertificateRequest) (response *CreateUserCertificateResponse, err error) {
	response = CreateCreateUserCertificateResponse()
	err = client.DoAction(request, response)
	return
}

// CreateUserCertificateWithChan invokes the cas.CreateUserCertificate API asynchronously
// api document: https://help.aliyun.com/api/cas/createusercertificate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateUserCertificateWithChan(request *CreateUserCertificateRequest) (<-chan *CreateUserCertificateResponse, <-chan error) {
	responseChan := make(chan *CreateUserCertificateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateUserCertificate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateUserCertificateWithCallback invokes the cas.CreateUserCertificate API asynchronously
// api document: https://help.aliyun.com/api/cas/createusercertificate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateUserCertificateWithCallback(request *CreateUserCertificateRequest, callback func(response *CreateUserCertificateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateUserCertificateResponse
		var err error
		defer close(result)
		response, err = client.CreateUserCertificate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateUserCertificateRequest is the request struct for api CreateUserCertificate
type CreateUserCertificateRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	Name     string `position:"Query" name:"Name"`
	Cert     string `position:"Query" name:"Cert"`
	Lang     string `position:"Query" name:"Lang"`
	Key      string `position:"Query" name:"Key"`
}

// CreateUserCertificateResponse is the response struct for api CreateUserCertificate
type CreateUserCertificateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	CertId   requests.Integer `json:"CertId" xml:"CertId"`
}

// CreateCreateUserCertificateRequest creates a request to invoke CreateUserCertificate API
func CreateCreateUserCertificateRequest() (request *CreateUserCertificateRequest) {
	request = &CreateUserCertificateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cas", "2018-07-13", "CreateUserCertificate", "cas", "openAPI")
	return
}

// CreateCreateUserCertificateResponse creates a response to parse from CreateUserCertificate response
func CreateCreateUserCertificateResponse() (response *CreateUserCertificateResponse) {
	response = &CreateUserCertificateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
