package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ProfileSet invokes the cms.ProfileSet API synchronously
// api document: https://help.aliyun.com/api/cms/profileset.html
func (client *Client) ProfileSet(request *ProfileSetRequest) (response *ProfileSetResponse, err error) {
	response = CreateProfileSetResponse()
	err = client.DoAction(request, response)
	return
}

// ProfileSetWithChan invokes the cms.ProfileSet API asynchronously
// api document: https://help.aliyun.com/api/cms/profileset.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ProfileSetWithChan(request *ProfileSetRequest) (<-chan *ProfileSetResponse, <-chan error) {
	responseChan := make(chan *ProfileSetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ProfileSet(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ProfileSetWithCallback invokes the cms.ProfileSet API asynchronously
// api document: https://help.aliyun.com/api/cms/profileset.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ProfileSetWithCallback(request *ProfileSetRequest, callback func(response *ProfileSetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ProfileSetResponse
		var err error
		defer close(result)
		response, err = client.ProfileSet(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ProfileSetRequest is the request struct for api ProfileSet
type ProfileSetRequest struct {
	*requests.RpcRequest
	EnableInstallAgentNewECS requests.Boolean `position:"Query" name:"EnableInstallAgentNewECS"`
	EnableActiveAlert        string           `position:"Query" name:"EnableActiveAlert"`
	AutoInstall              requests.Boolean `position:"Query" name:"AutoInstall"`
	UserId                   requests.Integer `position:"Query" name:"UserId"`
}

// ProfileSetResponse is the response struct for api ProfileSet
type ProfileSetResponse struct {
	*responses.BaseResponse
	ErrorCode    int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
}

// CreateProfileSetRequest creates a request to invoke ProfileSet API
func CreateProfileSetRequest() (request *ProfileSetRequest) {
	request = &ProfileSetRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2018-03-08", "ProfileSet", "cms", "openAPI")
	return
}

// CreateProfileSetResponse creates a response to parse from ProfileSet response
func CreateProfileSetResponse() (response *ProfileSetResponse) {
	response = &ProfileSetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
