package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryMetricData invokes the cms.QueryMetricData API synchronously
// api document: https://help.aliyun.com/api/cms/querymetricdata.html
func (client *Client) QueryMetricData(request *QueryMetricDataRequest) (response *QueryMetricDataResponse, err error) {
	response = CreateQueryMetricDataResponse()
	err = client.DoAction(request, response)
	return
}

// QueryMetricDataWithChan invokes the cms.QueryMetricData API asynchronously
// api document: https://help.aliyun.com/api/cms/querymetricdata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryMetricDataWithChan(request *QueryMetricDataRequest) (<-chan *QueryMetricDataResponse, <-chan error) {
	responseChan := make(chan *QueryMetricDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryMetricData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryMetricDataWithCallback invokes the cms.QueryMetricData API asynchronously
// api document: https://help.aliyun.com/api/cms/querymetricdata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryMetricDataWithCallback(request *QueryMetricDataRequest, callback func(response *QueryMetricDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryMetricDataResponse
		var err error
		defer close(result)
		response, err = client.QueryMetricData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryMetricDataRequest is the request struct for api QueryMetricData
type QueryMetricDataRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Period          string           `position:"Query" name:"Period"`
	Metric          string           `position:"Query" name:"Metric"`
	Length          string           `position:"Query" name:"Length"`
	Project         string           `position:"Query" name:"Project"`
	EndTime         string           `position:"Query" name:"EndTime"`
	Express         string           `position:"Query" name:"Express"`
	StartTime       string           `position:"Query" name:"StartTime"`
	Dimensions      string           `position:"Query" name:"Dimensions"`
}

// QueryMetricDataResponse is the response struct for api QueryMetricData
type QueryMetricDataResponse struct {
	*responses.BaseResponse
	Code       string `json:"Code" xml:"Code"`
	Message    string `json:"Message" xml:"Message"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Datapoints string `json:"Datapoints" xml:"Datapoints"`
	Period     string `json:"Period" xml:"Period"`
}

// CreateQueryMetricDataRequest creates a request to invoke QueryMetricData API
func CreateQueryMetricDataRequest() (request *QueryMetricDataRequest) {
	request = &QueryMetricDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2018-03-08", "QueryMetricData", "cms", "openAPI")
	return
}

// CreateQueryMetricDataResponse creates a response to parse from QueryMetricData response
func CreateQueryMetricDataResponse() (response *QueryMetricDataResponse) {
	response = &QueryMetricDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
