package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableDegradeControl invokes the edas.DisableDegradeControl API synchronously
// api document: https://help.aliyun.com/api/edas/disabledegradecontrol.html
func (client *Client) DisableDegradeControl(request *DisableDegradeControlRequest) (response *DisableDegradeControlResponse, err error) {
	response = CreateDisableDegradeControlResponse()
	err = client.DoAction(request, response)
	return
}

// DisableDegradeControlWithChan invokes the edas.DisableDegradeControl API asynchronously
// api document: https://help.aliyun.com/api/edas/disabledegradecontrol.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DisableDegradeControlWithChan(request *DisableDegradeControlRequest) (<-chan *DisableDegradeControlResponse, <-chan error) {
	responseChan := make(chan *DisableDegradeControlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableDegradeControl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableDegradeControlWithCallback invokes the edas.DisableDegradeControl API asynchronously
// api document: https://help.aliyun.com/api/edas/disabledegradecontrol.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DisableDegradeControlWithCallback(request *DisableDegradeControlRequest, callback func(response *DisableDegradeControlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableDegradeControlResponse
		var err error
		defer close(result)
		response, err = client.DisableDegradeControl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableDegradeControlRequest is the request struct for api DisableDegradeControl
type DisableDegradeControlRequest struct {
	*requests.RoaRequest
	AppId  string `position:"Query" name:"AppId"`
	RuleId string `position:"Query" name:"RuleId"`
}

// DisableDegradeControlResponse is the response struct for api DisableDegradeControl
type DisableDegradeControlResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDisableDegradeControlRequest creates a request to invoke DisableDegradeControl API
func CreateDisableDegradeControlRequest() (request *DisableDegradeControlRequest) {
	request = &DisableDegradeControlRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "DisableDegradeControl", "/pop/v5/degradecontrol/disable", "edas", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateDisableDegradeControlResponse creates a response to parse from DisableDegradeControl response
func CreateDisableDegradeControlResponse() (response *DisableDegradeControlResponse) {
	response = &DisableDegradeControlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
