package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeScalingTaskGroup invokes the emr.DescribeScalingTaskGroup API synchronously
// api document: https://help.aliyun.com/api/emr/describescalingtaskgroup.html
func (client *Client) DescribeScalingTaskGroup(request *DescribeScalingTaskGroupRequest) (response *DescribeScalingTaskGroupResponse, err error) {
	response = CreateDescribeScalingTaskGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeScalingTaskGroupWithChan invokes the emr.DescribeScalingTaskGroup API asynchronously
// api document: https://help.aliyun.com/api/emr/describescalingtaskgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeScalingTaskGroupWithChan(request *DescribeScalingTaskGroupRequest) (<-chan *DescribeScalingTaskGroupResponse, <-chan error) {
	responseChan := make(chan *DescribeScalingTaskGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeScalingTaskGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeScalingTaskGroupWithCallback invokes the emr.DescribeScalingTaskGroup API asynchronously
// api document: https://help.aliyun.com/api/emr/describescalingtaskgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeScalingTaskGroupWithCallback(request *DescribeScalingTaskGroupRequest, callback func(response *DescribeScalingTaskGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeScalingTaskGroupResponse
		var err error
		defer close(result)
		response, err = client.DescribeScalingTaskGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeScalingTaskGroupRequest is the request struct for api DescribeScalingTaskGroup
type DescribeScalingTaskGroupRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	HostGroupId     string           `position:"Query" name:"HostGroupId"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
}

// DescribeScalingTaskGroupResponse is the response struct for api DescribeScalingTaskGroup
type DescribeScalingTaskGroupResponse struct {
	*responses.BaseResponse
	RequestId          string        `json:"RequestId" xml:"RequestId"`
	ScalingGroupId     string        `json:"ScalingGroupId" xml:"ScalingGroupId"`
	HostGroupId        string        `json:"HostGroupId" xml:"HostGroupId"`
	MinSize            int           `json:"MinSize" xml:"MinSize"`
	MaxSize            int           `json:"MaxSize" xml:"MaxSize"`
	DefaultCooldown    int           `json:"DefaultCooldown" xml:"DefaultCooldown"`
	Status             string        `json:"Status" xml:"Status"`
	ActiveRuleCategory string        `json:"ActiveRuleCategory" xml:"ActiveRuleCategory"`
	ScalingConfig      ScalingConfig `json:"ScalingConfig" xml:"ScalingConfig"`
}

// CreateDescribeScalingTaskGroupRequest creates a request to invoke DescribeScalingTaskGroup API
func CreateDescribeScalingTaskGroupRequest() (request *DescribeScalingTaskGroupRequest) {
	request = &DescribeScalingTaskGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DescribeScalingTaskGroup", "emr", "openAPI")
	return
}

// CreateDescribeScalingTaskGroupResponse creates a response to parse from DescribeScalingTaskGroup response
func CreateDescribeScalingTaskGroupResponse() (response *DescribeScalingTaskGroupResponse) {
	response = &DescribeScalingTaskGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
