package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDataSourceSchemaDatabase invokes the emr.ListDataSourceSchemaDatabase API synchronously
// api document: https://help.aliyun.com/api/emr/listdatasourceschemadatabase.html
func (client *Client) ListDataSourceSchemaDatabase(request *ListDataSourceSchemaDatabaseRequest) (response *ListDataSourceSchemaDatabaseResponse, err error) {
	response = CreateListDataSourceSchemaDatabaseResponse()
	err = client.DoAction(request, response)
	return
}

// ListDataSourceSchemaDatabaseWithChan invokes the emr.ListDataSourceSchemaDatabase API asynchronously
// api document: https://help.aliyun.com/api/emr/listdatasourceschemadatabase.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListDataSourceSchemaDatabaseWithChan(request *ListDataSourceSchemaDatabaseRequest) (<-chan *ListDataSourceSchemaDatabaseResponse, <-chan error) {
	responseChan := make(chan *ListDataSourceSchemaDatabaseResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDataSourceSchemaDatabase(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDataSourceSchemaDatabaseWithCallback invokes the emr.ListDataSourceSchemaDatabase API asynchronously
// api document: https://help.aliyun.com/api/emr/listdatasourceschemadatabase.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListDataSourceSchemaDatabaseWithCallback(request *ListDataSourceSchemaDatabaseRequest, callback func(response *ListDataSourceSchemaDatabaseResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDataSourceSchemaDatabaseResponse
		var err error
		defer close(result)
		response, err = client.ListDataSourceSchemaDatabase(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDataSourceSchemaDatabaseRequest is the request struct for api ListDataSourceSchemaDatabase
type ListDataSourceSchemaDatabaseRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DbName          string           `position:"Query" name:"DbName"`
	DataSourceId    string           `position:"Query" name:"DataSourceId"`
}

// ListDataSourceSchemaDatabaseResponse is the response struct for api ListDataSourceSchemaDatabase
type ListDataSourceSchemaDatabaseResponse struct {
	*responses.BaseResponse
	RequestId    string                                   `json:"RequestId" xml:"RequestId"`
	DataSourceId string                                   `json:"DataSourceId" xml:"DataSourceId"`
	SchemaList   SchemaListInListDataSourceSchemaDatabase `json:"SchemaList" xml:"SchemaList"`
}

// CreateListDataSourceSchemaDatabaseRequest creates a request to invoke ListDataSourceSchemaDatabase API
func CreateListDataSourceSchemaDatabaseRequest() (request *ListDataSourceSchemaDatabaseRequest) {
	request = &ListDataSourceSchemaDatabaseRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListDataSourceSchemaDatabase", "emr", "openAPI")
	return
}

// CreateListDataSourceSchemaDatabaseResponse creates a response to parse from ListDataSourceSchemaDatabase response
func CreateListDataSourceSchemaDatabaseResponse() (response *ListDataSourceSchemaDatabaseResponse) {
	response = &ListDataSourceSchemaDatabaseResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
