package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryAlarmHistory invokes the emr.QueryAlarmHistory API synchronously
// api document: https://help.aliyun.com/api/emr/queryalarmhistory.html
func (client *Client) QueryAlarmHistory(request *QueryAlarmHistoryRequest) (response *QueryAlarmHistoryResponse, err error) {
	response = CreateQueryAlarmHistoryResponse()
	err = client.DoAction(request, response)
	return
}

// QueryAlarmHistoryWithChan invokes the emr.QueryAlarmHistory API asynchronously
// api document: https://help.aliyun.com/api/emr/queryalarmhistory.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryAlarmHistoryWithChan(request *QueryAlarmHistoryRequest) (<-chan *QueryAlarmHistoryResponse, <-chan error) {
	responseChan := make(chan *QueryAlarmHistoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryAlarmHistory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryAlarmHistoryWithCallback invokes the emr.QueryAlarmHistory API asynchronously
// api document: https://help.aliyun.com/api/emr/queryalarmhistory.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryAlarmHistoryWithCallback(request *QueryAlarmHistoryRequest, callback func(response *QueryAlarmHistoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryAlarmHistoryResponse
		var err error
		defer close(result)
		response, err = client.QueryAlarmHistory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryAlarmHistoryRequest is the request struct for api QueryAlarmHistory
type QueryAlarmHistoryRequest struct {
	*requests.RpcRequest
	Cursor          string           `position:"Query" name:"Cursor"`
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Size            requests.Integer `position:"Query" name:"Size"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	StartTimeStamp  requests.Integer `position:"Query" name:"StartTimeStamp"`
	EndTimeStamp    requests.Integer `position:"Query" name:"EndTimeStamp"`
}

// QueryAlarmHistoryResponse is the response struct for api QueryAlarmHistory
type QueryAlarmHistoryResponse struct {
	*responses.BaseResponse
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	Total            string           `json:"Total" xml:"Total"`
	Cursor           string           `json:"Cursor" xml:"Cursor"`
	AlarmHistoryList AlarmHistoryList `json:"AlarmHistoryList" xml:"AlarmHistoryList"`
}

// CreateQueryAlarmHistoryRequest creates a request to invoke QueryAlarmHistory API
func CreateQueryAlarmHistoryRequest() (request *QueryAlarmHistoryRequest) {
	request = &QueryAlarmHistoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "QueryAlarmHistory", "emr", "openAPI")
	return
}

// CreateQueryAlarmHistoryResponse creates a response to parse from QueryAlarmHistory response
func CreateQueryAlarmHistoryResponse() (response *QueryAlarmHistoryResponse) {
	response = &QueryAlarmHistoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
