package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RunNoteParagraphs invokes the emr.RunNoteParagraphs API synchronously
// api document: https://help.aliyun.com/api/emr/runnoteparagraphs.html
func (client *Client) RunNoteParagraphs(request *RunNoteParagraphsRequest) (response *RunNoteParagraphsResponse, err error) {
	response = CreateRunNoteParagraphsResponse()
	err = client.DoAction(request, response)
	return
}

// RunNoteParagraphsWithChan invokes the emr.RunNoteParagraphs API asynchronously
// api document: https://help.aliyun.com/api/emr/runnoteparagraphs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RunNoteParagraphsWithChan(request *RunNoteParagraphsRequest) (<-chan *RunNoteParagraphsResponse, <-chan error) {
	responseChan := make(chan *RunNoteParagraphsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RunNoteParagraphs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RunNoteParagraphsWithCallback invokes the emr.RunNoteParagraphs API asynchronously
// api document: https://help.aliyun.com/api/emr/runnoteparagraphs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RunNoteParagraphsWithCallback(request *RunNoteParagraphsRequest, callback func(response *RunNoteParagraphsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RunNoteParagraphsResponse
		var err error
		defer close(result)
		response, err = client.RunNoteParagraphs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RunNoteParagraphsRequest is the request struct for api RunNoteParagraphs
type RunNoteParagraphsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	NoteId          string           `position:"Query" name:"NoteId"`
}

// RunNoteParagraphsResponse is the response struct for api RunNoteParagraphs
type RunNoteParagraphsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRunNoteParagraphsRequest creates a request to invoke RunNoteParagraphs API
func CreateRunNoteParagraphsRequest() (request *RunNoteParagraphsRequest) {
	request = &RunNoteParagraphsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "RunNoteParagraphs", "emr", "openAPI")
	return
}

// CreateRunNoteParagraphsResponse creates a response to parse from RunNoteParagraphs response
func CreateRunNoteParagraphsResponse() (response *RunNoteParagraphsResponse) {
	response = &RunNoteParagraphsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
