package finmall

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetCurrentTermRepayInfo invokes the finmall.GetCurrentTermRepayInfo API synchronously
// api document: https://help.aliyun.com/api/finmall/getcurrenttermrepayinfo.html
func (client *Client) GetCurrentTermRepayInfo(request *GetCurrentTermRepayInfoRequest) (response *GetCurrentTermRepayInfoResponse, err error) {
	response = CreateGetCurrentTermRepayInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetCurrentTermRepayInfoWithChan invokes the finmall.GetCurrentTermRepayInfo API asynchronously
// api document: https://help.aliyun.com/api/finmall/getcurrenttermrepayinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetCurrentTermRepayInfoWithChan(request *GetCurrentTermRepayInfoRequest) (<-chan *GetCurrentTermRepayInfoResponse, <-chan error) {
	responseChan := make(chan *GetCurrentTermRepayInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetCurrentTermRepayInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetCurrentTermRepayInfoWithCallback invokes the finmall.GetCurrentTermRepayInfo API asynchronously
// api document: https://help.aliyun.com/api/finmall/getcurrenttermrepayinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetCurrentTermRepayInfoWithCallback(request *GetCurrentTermRepayInfoRequest, callback func(response *GetCurrentTermRepayInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetCurrentTermRepayInfoResponse
		var err error
		defer close(result)
		response, err = client.GetCurrentTermRepayInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetCurrentTermRepayInfoRequest is the request struct for api GetCurrentTermRepayInfo
type GetCurrentTermRepayInfoRequest struct {
	*requests.RpcRequest
	CreditId string `position:"Query" name:"CreditId"`
	UserId   string `position:"Query" name:"UserId"`
}

// GetCurrentTermRepayInfoResponse is the response struct for api GetCurrentTermRepayInfo
type GetCurrentTermRepayInfoResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetCurrentTermRepayInfoRequest creates a request to invoke GetCurrentTermRepayInfo API
func CreateGetCurrentTermRepayInfoRequest() (request *GetCurrentTermRepayInfoRequest) {
	request = &GetCurrentTermRepayInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("finmall", "2018-07-23", "GetCurrentTermRepayInfo", "finmall", "openAPI")
	return
}

// CreateGetCurrentTermRepayInfoResponse creates a response to parse from GetCurrentTermRepayInfo response
func CreateGetCurrentTermRepayInfoResponse() (response *GetCurrentTermRepayInfoResponse) {
	response = &GetCurrentTermRepayInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
