package finmall

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetRepayPlanTrial invokes the finmall.GetRepayPlanTrial API synchronously
// api document: https://help.aliyun.com/api/finmall/getrepayplantrial.html
func (client *Client) GetRepayPlanTrial(request *GetRepayPlanTrialRequest) (response *GetRepayPlanTrialResponse, err error) {
	response = CreateGetRepayPlanTrialResponse()
	err = client.DoAction(request, response)
	return
}

// GetRepayPlanTrialWithChan invokes the finmall.GetRepayPlanTrial API asynchronously
// api document: https://help.aliyun.com/api/finmall/getrepayplantrial.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetRepayPlanTrialWithChan(request *GetRepayPlanTrialRequest) (<-chan *GetRepayPlanTrialResponse, <-chan error) {
	responseChan := make(chan *GetRepayPlanTrialResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetRepayPlanTrial(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetRepayPlanTrialWithCallback invokes the finmall.GetRepayPlanTrial API asynchronously
// api document: https://help.aliyun.com/api/finmall/getrepayplantrial.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetRepayPlanTrialWithCallback(request *GetRepayPlanTrialRequest, callback func(response *GetRepayPlanTrialResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetRepayPlanTrialResponse
		var err error
		defer close(result)
		response, err = client.GetRepayPlanTrial(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetRepayPlanTrialRequest is the request struct for api GetRepayPlanTrial
type GetRepayPlanTrialRequest struct {
	*requests.RpcRequest
	CreditId  string `position:"Query" name:"CreditId"`
	ProductId string `position:"Query" name:"ProductId"`
	UserId    string `position:"Query" name:"UserId"`
}

// GetRepayPlanTrialResponse is the response struct for api GetRepayPlanTrial
type GetRepayPlanTrialResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetRepayPlanTrialRequest creates a request to invoke GetRepayPlanTrial API
func CreateGetRepayPlanTrialRequest() (request *GetRepayPlanTrialRequest) {
	request = &GetRepayPlanTrialRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("finmall", "2018-07-23", "GetRepayPlanTrial", "finmall", "openAPI")
	return
}

// CreateGetRepayPlanTrialResponse creates a response to parse from GetRepayPlanTrial response
func CreateGetRepayPlanTrialResponse() (response *GetRepayPlanTrialResponse) {
	response = &GetRepayPlanTrialResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
