package imm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPhotoProcessTask invokes the imm.GetPhotoProcessTask API synchronously
// api document: https://help.aliyun.com/api/imm/getphotoprocesstask.html
func (client *Client) GetPhotoProcessTask(request *GetPhotoProcessTaskRequest) (response *GetPhotoProcessTaskResponse, err error) {
	response = CreateGetPhotoProcessTaskResponse()
	err = client.DoAction(request, response)
	return
}

// GetPhotoProcessTaskWithChan invokes the imm.GetPhotoProcessTask API asynchronously
// api document: https://help.aliyun.com/api/imm/getphotoprocesstask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetPhotoProcessTaskWithChan(request *GetPhotoProcessTaskRequest) (<-chan *GetPhotoProcessTaskResponse, <-chan error) {
	responseChan := make(chan *GetPhotoProcessTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPhotoProcessTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPhotoProcessTaskWithCallback invokes the imm.GetPhotoProcessTask API asynchronously
// api document: https://help.aliyun.com/api/imm/getphotoprocesstask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetPhotoProcessTaskWithCallback(request *GetPhotoProcessTaskRequest, callback func(response *GetPhotoProcessTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPhotoProcessTaskResponse
		var err error
		defer close(result)
		response, err = client.GetPhotoProcessTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPhotoProcessTaskRequest is the request struct for api GetPhotoProcessTask
type GetPhotoProcessTaskRequest struct {
	*requests.RpcRequest
	Project string `position:"Query" name:"Project"`
	TaskId  string `position:"Query" name:"TaskId"`
}

// GetPhotoProcessTaskResponse is the response struct for api GetPhotoProcessTask
type GetPhotoProcessTaskResponse struct {
	*responses.BaseResponse
	RequestId       string `json:"RequestId" xml:"RequestId"`
	TaskId          string `json:"TaskId" xml:"TaskId"`
	Status          string `json:"Status" xml:"Status"`
	SrcUri          string `json:"SrcUri" xml:"SrcUri"`
	TgtUri          string `json:"TgtUri" xml:"TgtUri"`
	Style           string `json:"Style" xml:"Style"`
	NotifyTopicName string `json:"NotifyTopicName" xml:"NotifyTopicName"`
	NotifyEndpoint  string `json:"NotifyEndpoint" xml:"NotifyEndpoint"`
	ExternalID      string `json:"ExternalID" xml:"ExternalID"`
	CreateTime      string `json:"CreateTime" xml:"CreateTime"`
	FinishTime      string `json:"FinishTime" xml:"FinishTime"`
	Percent         int    `json:"Percent" xml:"Percent"`
}

// CreateGetPhotoProcessTaskRequest creates a request to invoke GetPhotoProcessTask API
func CreateGetPhotoProcessTaskRequest() (request *GetPhotoProcessTaskRequest) {
	request = &GetPhotoProcessTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imm", "2017-09-06", "GetPhotoProcessTask", "imm", "openAPI")
	return
}

// CreateGetPhotoProcessTaskResponse creates a response to parse from GetPhotoProcessTask response
func CreateGetPhotoProcessTaskResponse() (response *GetPhotoProcessTaskResponse) {
	response = &GetPhotoProcessTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
