package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteLiveMixConfig invokes the live.DeleteLiveMixConfig API synchronously
// api document: https://help.aliyun.com/api/live/deletelivemixconfig.html
func (client *Client) DeleteLiveMixConfig(request *DeleteLiveMixConfigRequest) (response *DeleteLiveMixConfigResponse, err error) {
	response = CreateDeleteLiveMixConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteLiveMixConfigWithChan invokes the live.DeleteLiveMixConfig API asynchronously
// api document: https://help.aliyun.com/api/live/deletelivemixconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteLiveMixConfigWithChan(request *DeleteLiveMixConfigRequest) (<-chan *DeleteLiveMixConfigResponse, <-chan error) {
	responseChan := make(chan *DeleteLiveMixConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteLiveMixConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteLiveMixConfigWithCallback invokes the live.DeleteLiveMixConfig API asynchronously
// api document: https://help.aliyun.com/api/live/deletelivemixconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteLiveMixConfigWithCallback(request *DeleteLiveMixConfigRequest, callback func(response *DeleteLiveMixConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteLiveMixConfigResponse
		var err error
		defer close(result)
		response, err = client.DeleteLiveMixConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteLiveMixConfigRequest is the request struct for api DeleteLiveMixConfig
type DeleteLiveMixConfigRequest struct {
	*requests.RpcRequest
	AppName       string           `position:"Query" name:"AppName"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	DomainName    string           `position:"Query" name:"DomainName"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteLiveMixConfigResponse is the response struct for api DeleteLiveMixConfig
type DeleteLiveMixConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteLiveMixConfigRequest creates a request to invoke DeleteLiveMixConfig API
func CreateDeleteLiveMixConfigRequest() (request *DeleteLiveMixConfigRequest) {
	request = &DeleteLiveMixConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DeleteLiveMixConfig", "live", "openAPI")
	return
}

// CreateDeleteLiveMixConfigResponse creates a response to parse from DeleteLiveMixConfig response
func CreateDeleteLiveMixConfigResponse() (response *DeleteLiveMixConfigResponse) {
	response = &DeleteLiveMixConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
