package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RenewMultiInstance invokes the r_kvstore.RenewMultiInstance API synchronously
// api document: https://help.aliyun.com/api/r-kvstore/renewmultiinstance.html
func (client *Client) RenewMultiInstance(request *RenewMultiInstanceRequest) (response *RenewMultiInstanceResponse, err error) {
	response = CreateRenewMultiInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// RenewMultiInstanceWithChan invokes the r_kvstore.RenewMultiInstance API asynchronously
// api document: https://help.aliyun.com/api/r-kvstore/renewmultiinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RenewMultiInstanceWithChan(request *RenewMultiInstanceRequest) (<-chan *RenewMultiInstanceResponse, <-chan error) {
	responseChan := make(chan *RenewMultiInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RenewMultiInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RenewMultiInstanceWithCallback invokes the r_kvstore.RenewMultiInstance API asynchronously
// api document: https://help.aliyun.com/api/r-kvstore/renewmultiinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RenewMultiInstanceWithCallback(request *RenewMultiInstanceRequest, callback func(response *RenewMultiInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RenewMultiInstanceResponse
		var err error
		defer close(result)
		response, err = client.RenewMultiInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RenewMultiInstanceRequest is the request struct for api RenewMultiInstance
type RenewMultiInstanceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Period               requests.Integer `position:"Query" name:"Period"`
	AutoPay              requests.Boolean `position:"Query" name:"AutoPay"`
	FromApp              string           `position:"Query" name:"FromApp"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	CouponNo             string           `position:"Query" name:"CouponNo"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	InstanceIds          string           `position:"Query" name:"InstanceIds"`
	BusinessInfo         string           `position:"Query" name:"BusinessInfo"`
}

// RenewMultiInstanceResponse is the response struct for api RenewMultiInstance
type RenewMultiInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	OrderId   string `json:"OrderId" xml:"OrderId"`
}

// CreateRenewMultiInstanceRequest creates a request to invoke RenewMultiInstance API
func CreateRenewMultiInstanceRequest() (request *RenewMultiInstanceRequest) {
	request = &RenewMultiInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "RenewMultiInstance", "redisa", "openAPI")
	return
}

// CreateRenewMultiInstanceResponse creates a response to parse from RenewMultiInstance response
func CreateRenewMultiInstanceResponse() (response *RenewMultiInstanceResponse) {
	response = &RenewMultiInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
