package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyIPv6TranslatorBandwidth invokes the vpc.ModifyIPv6TranslatorBandwidth API synchronously
// api document: https://help.aliyun.com/api/vpc/modifyipv6translatorbandwidth.html
func (client *Client) ModifyIPv6TranslatorBandwidth(request *ModifyIPv6TranslatorBandwidthRequest) (response *ModifyIPv6TranslatorBandwidthResponse, err error) {
	response = CreateModifyIPv6TranslatorBandwidthResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyIPv6TranslatorBandwidthWithChan invokes the vpc.ModifyIPv6TranslatorBandwidth API asynchronously
// api document: https://help.aliyun.com/api/vpc/modifyipv6translatorbandwidth.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyIPv6TranslatorBandwidthWithChan(request *ModifyIPv6TranslatorBandwidthRequest) (<-chan *ModifyIPv6TranslatorBandwidthResponse, <-chan error) {
	responseChan := make(chan *ModifyIPv6TranslatorBandwidthResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyIPv6TranslatorBandwidth(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyIPv6TranslatorBandwidthWithCallback invokes the vpc.ModifyIPv6TranslatorBandwidth API asynchronously
// api document: https://help.aliyun.com/api/vpc/modifyipv6translatorbandwidth.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyIPv6TranslatorBandwidthWithCallback(request *ModifyIPv6TranslatorBandwidthRequest, callback func(response *ModifyIPv6TranslatorBandwidthResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyIPv6TranslatorBandwidthResponse
		var err error
		defer close(result)
		response, err = client.ModifyIPv6TranslatorBandwidth(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyIPv6TranslatorBandwidthRequest is the request struct for api ModifyIPv6TranslatorBandwidth
type ModifyIPv6TranslatorBandwidthRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	AutoPay              requests.Boolean `position:"Query" name:"AutoPay"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	Bandwidth            requests.Integer `position:"Query" name:"Bandwidth"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	Ipv6TranslatorId     string           `position:"Query" name:"Ipv6TranslatorId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// ModifyIPv6TranslatorBandwidthResponse is the response struct for api ModifyIPv6TranslatorBandwidth
type ModifyIPv6TranslatorBandwidthResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	OrderId   string `json:"OrderId" xml:"OrderId"`
}

// CreateModifyIPv6TranslatorBandwidthRequest creates a request to invoke ModifyIPv6TranslatorBandwidth API
func CreateModifyIPv6TranslatorBandwidthRequest() (request *ModifyIPv6TranslatorBandwidthRequest) {
	request = &ModifyIPv6TranslatorBandwidthRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "ModifyIPv6TranslatorBandwidth", "vpc", "openAPI")
	return
}

// CreateModifyIPv6TranslatorBandwidthResponse creates a response to parse from ModifyIPv6TranslatorBandwidth response
func CreateModifyIPv6TranslatorBandwidthResponse() (response *ModifyIPv6TranslatorBandwidthResponse) {
	response = &ModifyIPv6TranslatorBandwidthResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
