package newssearch

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/cognitiveservices/v1.0/newssearch"

// ErrorCode enumerates the values for error code.
type ErrorCode string

const (
	// InsufficientAuthorization ...
	InsufficientAuthorization ErrorCode = "InsufficientAuthorization"
	// InvalidAuthorization ...
	InvalidAuthorization ErrorCode = "InvalidAuthorization"
	// InvalidRequest ...
	InvalidRequest ErrorCode = "InvalidRequest"
	// None ...
	None ErrorCode = "None"
	// RateLimitExceeded ...
	RateLimitExceeded ErrorCode = "RateLimitExceeded"
	// ServerError ...
	ServerError ErrorCode = "ServerError"
)

// PossibleErrorCodeValues returns an array of possible values for the ErrorCode const type.
func PossibleErrorCodeValues() []ErrorCode {
	return []ErrorCode{InsufficientAuthorization, InvalidAuthorization, InvalidRequest, None, RateLimitExceeded, ServerError}
}

// ErrorSubCode enumerates the values for error sub code.
type ErrorSubCode string

const (
	// AuthorizationDisabled ...
	AuthorizationDisabled ErrorSubCode = "AuthorizationDisabled"
	// AuthorizationExpired ...
	AuthorizationExpired ErrorSubCode = "AuthorizationExpired"
	// AuthorizationMissing ...
	AuthorizationMissing ErrorSubCode = "AuthorizationMissing"
	// AuthorizationRedundancy ...
	AuthorizationRedundancy ErrorSubCode = "AuthorizationRedundancy"
	// Blocked ...
	Blocked ErrorSubCode = "Blocked"
	// HTTPNotAllowed ...
	HTTPNotAllowed ErrorSubCode = "HttpNotAllowed"
	// NotImplemented ...
	NotImplemented ErrorSubCode = "NotImplemented"
	// ParameterInvalidValue ...
	ParameterInvalidValue ErrorSubCode = "ParameterInvalidValue"
	// ParameterMissing ...
	ParameterMissing ErrorSubCode = "ParameterMissing"
	// ResourceError ...
	ResourceError ErrorSubCode = "ResourceError"
	// UnexpectedError ...
	UnexpectedError ErrorSubCode = "UnexpectedError"
)

// PossibleErrorSubCodeValues returns an array of possible values for the ErrorSubCode const type.
func PossibleErrorSubCodeValues() []ErrorSubCode {
	return []ErrorSubCode{AuthorizationDisabled, AuthorizationExpired, AuthorizationMissing, AuthorizationRedundancy, Blocked, HTTPNotAllowed, NotImplemented, ParameterInvalidValue, ParameterMissing, ResourceError, UnexpectedError}
}

// Freshness enumerates the values for freshness.
type Freshness string

const (
	// Day ...
	Day Freshness = "Day"
	// Month ...
	Month Freshness = "Month"
	// Week ...
	Week Freshness = "Week"
)

// PossibleFreshnessValues returns an array of possible values for the Freshness const type.
func PossibleFreshnessValues() []Freshness {
	return []Freshness{Day, Month, Week}
}

// SafeSearch enumerates the values for safe search.
type SafeSearch string

const (
	// Moderate ...
	Moderate SafeSearch = "Moderate"
	// Off ...
	Off SafeSearch = "Off"
	// Strict ...
	Strict SafeSearch = "Strict"
)

// PossibleSafeSearchValues returns an array of possible values for the SafeSearch const type.
func PossibleSafeSearchValues() []SafeSearch {
	return []SafeSearch{Moderate, Off, Strict}
}

// TextFormat enumerates the values for text format.
type TextFormat string

const (
	// HTML ...
	HTML TextFormat = "Html"
	// Raw ...
	Raw TextFormat = "Raw"
)

// PossibleTextFormatValues returns an array of possible values for the TextFormat const type.
func PossibleTextFormatValues() []TextFormat {
	return []TextFormat{HTML, Raw}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeAnswer ...
	TypeAnswer Type = "Answer"
	// TypeArticle ...
	TypeArticle Type = "Article"
	// TypeCreativeWork ...
	TypeCreativeWork Type = "CreativeWork"
	// TypeErrorResponse ...
	TypeErrorResponse Type = "ErrorResponse"
	// TypeIdentifiable ...
	TypeIdentifiable Type = "Identifiable"
	// TypeImageObject ...
	TypeImageObject Type = "ImageObject"
	// TypeMediaObject ...
	TypeMediaObject Type = "MediaObject"
	// TypeNews ...
	TypeNews Type = "News"
	// TypeNewsArticle ...
	TypeNewsArticle Type = "NewsArticle"
	// TypeNewsTopic ...
	TypeNewsTopic Type = "News/Topic"
	// TypeOrganization ...
	TypeOrganization Type = "Organization"
	// TypeResponse ...
	TypeResponse Type = "Response"
	// TypeResponseBase ...
	TypeResponseBase Type = "ResponseBase"
	// TypeSearchResultsAnswer ...
	TypeSearchResultsAnswer Type = "SearchResultsAnswer"
	// TypeThing ...
	TypeThing Type = "Thing"
	// TypeTrendingTopics ...
	TypeTrendingTopics Type = "TrendingTopics"
	// TypeVideoObject ...
	TypeVideoObject Type = "VideoObject"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeAnswer, TypeArticle, TypeCreativeWork, TypeErrorResponse, TypeIdentifiable, TypeImageObject, TypeMediaObject, TypeNews, TypeNewsArticle, TypeNewsTopic, TypeOrganization, TypeResponse, TypeResponseBase, TypeSearchResultsAnswer, TypeThing, TypeTrendingTopics, TypeVideoObject}
}

// BasicAnswer defines an answer.
type BasicAnswer interface {
	AsNews() (*News, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
	AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool)
	AsTrendingTopics() (*TrendingTopics, bool)
	AsAnswer() (*Answer, bool)
}

// Answer defines an answer.
type Answer struct {
	FollowUpQueries *[]Query `json:"followUpQueries,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeNewsArticle', 'TypeNews', 'TypeSearchResultsAnswer', 'TypeImageObject', 'TypeNewsTopic', 'TypeAnswer', 'TypeArticle', 'TypeThing', 'TypeResponse', 'TypeTrendingTopics', 'TypeVideoObject', 'TypeCreativeWork', 'TypeOrganization', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeMediaObject'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicAnswer(body []byte) (BasicAnswer, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeNews):
		var n News
		err := json.Unmarshal(body, &n)
		return n, err
	case string(TypeSearchResultsAnswer):
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	case string(TypeTrendingTopics):
		var tt TrendingTopics
		err := json.Unmarshal(body, &tt)
		return tt, err
	default:
		var a Answer
		err := json.Unmarshal(body, &a)
		return a, err
	}
}
func unmarshalBasicAnswerArray(body []byte) ([]BasicAnswer, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	aArray := make([]BasicAnswer, len(rawMessages))

	for index, rawMessage := range rawMessages {
		a, err := unmarshalBasicAnswer(*rawMessage)
		if err != nil {
			return nil, err
		}
		aArray[index] = a
	}
	return aArray, nil
}

// MarshalJSON is the custom marshaler for Answer.
func (a Answer) MarshalJSON() ([]byte, error) {
	a.Type = TypeAnswer
	objectMap := make(map[string]interface{})
	if a.FollowUpQueries != nil {
		objectMap["followUpQueries"] = a.FollowUpQueries
	}
	if a.WebSearchURL != nil {
		objectMap["webSearchUrl"] = a.WebSearchURL
	}
	if a.ID != nil {
		objectMap["id"] = a.ID
	}
	if a.Type != "" {
		objectMap["_type"] = a.Type
	}
	return json.Marshal(objectMap)
}

// AsNewsArticle is the BasicResponseBase implementation for Answer.
func (a Answer) AsNewsArticle() (*NewsArticle, bool) {
	return nil, false
}

// AsNews is the BasicResponseBase implementation for Answer.
func (a Answer) AsNews() (*News, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for Answer.
func (a Answer) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsNewsTopic is the BasicResponseBase implementation for Answer.
func (a Answer) AsNewsTopic() (*NewsTopic, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsAnswer() (*Answer, bool) {
	return &a, true
}

// AsBasicAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicAnswer() (BasicAnswer, bool) {
	return &a, true
}

// AsArticle is the BasicResponseBase implementation for Answer.
func (a Answer) AsArticle() (*Article, bool) {
	return nil, false
}

// AsBasicArticle is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicArticle() (BasicArticle, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for Answer.
func (a Answer) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Answer.
func (a Answer) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicResponse() (BasicResponse, bool) {
	return &a, true
}

// AsTrendingTopics is the BasicResponseBase implementation for Answer.
func (a Answer) AsTrendingTopics() (*TrendingTopics, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for Answer.
func (a Answer) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Answer.
func (a Answer) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for Answer.
func (a Answer) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Answer.
func (a Answer) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &a, true
}

// AsErrorResponse is the BasicResponseBase implementation for Answer.
func (a Answer) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Answer.
func (a Answer) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Answer.
func (a Answer) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &a, true
}

// BasicArticle ...
type BasicArticle interface {
	AsNewsArticle() (*NewsArticle, bool)
	AsArticle() (*Article, bool)
}

// Article ...
type Article struct {
	// WordCount - The number of words in the text of the Article.
	WordCount *int32 `json:"wordCount,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	// DatePublished - The date on which the CreativeWork was published.
	DatePublished *string `json:"datePublished,omitempty"`
	// Video - A video of the item.
	Video *VideoObject `json:"video,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeNewsArticle', 'TypeNews', 'TypeSearchResultsAnswer', 'TypeImageObject', 'TypeNewsTopic', 'TypeAnswer', 'TypeArticle', 'TypeThing', 'TypeResponse', 'TypeTrendingTopics', 'TypeVideoObject', 'TypeCreativeWork', 'TypeOrganization', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeMediaObject'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicArticle(body []byte) (BasicArticle, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeNewsArticle):
		var na NewsArticle
		err := json.Unmarshal(body, &na)
		return na, err
	default:
		var a Article
		err := json.Unmarshal(body, &a)
		return a, err
	}
}
func unmarshalBasicArticleArray(body []byte) ([]BasicArticle, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	aArray := make([]BasicArticle, len(rawMessages))

	for index, rawMessage := range rawMessages {
		a, err := unmarshalBasicArticle(*rawMessage)
		if err != nil {
			return nil, err
		}
		aArray[index] = a
	}
	return aArray, nil
}

// MarshalJSON is the custom marshaler for Article.
func (a Article) MarshalJSON() ([]byte, error) {
	a.Type = TypeArticle
	objectMap := make(map[string]interface{})
	if a.WordCount != nil {
		objectMap["wordCount"] = a.WordCount
	}
	if a.ThumbnailURL != nil {
		objectMap["thumbnailUrl"] = a.ThumbnailURL
	}
	if a.Provider != nil {
		objectMap["provider"] = a.Provider
	}
	if a.DatePublished != nil {
		objectMap["datePublished"] = a.DatePublished
	}
	if a.Video != nil {
		objectMap["video"] = a.Video
	}
	if a.Name != nil {
		objectMap["name"] = a.Name
	}
	if a.URL != nil {
		objectMap["url"] = a.URL
	}
	if a.Image != nil {
		objectMap["image"] = a.Image
	}
	if a.Description != nil {
		objectMap["description"] = a.Description
	}
	if a.AlternateName != nil {
		objectMap["alternateName"] = a.AlternateName
	}
	if a.BingID != nil {
		objectMap["bingId"] = a.BingID
	}
	if a.WebSearchURL != nil {
		objectMap["webSearchUrl"] = a.WebSearchURL
	}
	if a.ID != nil {
		objectMap["id"] = a.ID
	}
	if a.Type != "" {
		objectMap["_type"] = a.Type
	}
	return json.Marshal(objectMap)
}

// AsNewsArticle is the BasicResponseBase implementation for Article.
func (a Article) AsNewsArticle() (*NewsArticle, bool) {
	return nil, false
}

// AsNews is the BasicResponseBase implementation for Article.
func (a Article) AsNews() (*News, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Article.
func (a Article) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Article.
func (a Article) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for Article.
func (a Article) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsNewsTopic is the BasicResponseBase implementation for Article.
func (a Article) AsNewsTopic() (*NewsTopic, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Article.
func (a Article) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Article.
func (a Article) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsArticle is the BasicResponseBase implementation for Article.
func (a Article) AsArticle() (*Article, bool) {
	return &a, true
}

// AsBasicArticle is the BasicResponseBase implementation for Article.
func (a Article) AsBasicArticle() (BasicArticle, bool) {
	return &a, true
}

// AsThing is the BasicResponseBase implementation for Article.
func (a Article) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Article.
func (a Article) AsBasicThing() (BasicThing, bool) {
	return &a, true
}

// AsResponse is the BasicResponseBase implementation for Article.
func (a Article) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Article.
func (a Article) AsBasicResponse() (BasicResponse, bool) {
	return &a, true
}

// AsTrendingTopics is the BasicResponseBase implementation for Article.
func (a Article) AsTrendingTopics() (*TrendingTopics, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for Article.
func (a Article) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Article.
func (a Article) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Article.
func (a Article) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &a, true
}

// AsOrganization is the BasicResponseBase implementation for Article.
func (a Article) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Article.
func (a Article) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Article.
func (a Article) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &a, true
}

// AsErrorResponse is the BasicResponseBase implementation for Article.
func (a Article) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Article.
func (a Article) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Article.
func (a Article) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Article.
func (a Article) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Article.
func (a Article) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &a, true
}

// UnmarshalJSON is the custom unmarshaler for Article struct.
func (a *Article) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "wordCount":
			if v != nil {
				var wordCount int32
				err = json.Unmarshal(*v, &wordCount)
				if err != nil {
					return err
				}
				a.WordCount = &wordCount
			}
		case "thumbnailUrl":
			if v != nil {
				var thumbnailURL string
				err = json.Unmarshal(*v, &thumbnailURL)
				if err != nil {
					return err
				}
				a.ThumbnailURL = &thumbnailURL
			}
		case "provider":
			if v != nil {
				provider, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				a.Provider = &provider
			}
		case "datePublished":
			if v != nil {
				var datePublished string
				err = json.Unmarshal(*v, &datePublished)
				if err != nil {
					return err
				}
				a.DatePublished = &datePublished
			}
		case "video":
			if v != nil {
				var video VideoObject
				err = json.Unmarshal(*v, &video)
				if err != nil {
					return err
				}
				a.Video = &video
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				a.URL = &URL
			}
		case "image":
			if v != nil {
				var imageVar ImageObject
				err = json.Unmarshal(*v, &imageVar)
				if err != nil {
					return err
				}
				a.Image = &imageVar
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				a.Description = &description
			}
		case "alternateName":
			if v != nil {
				var alternateName string
				err = json.Unmarshal(*v, &alternateName)
				if err != nil {
					return err
				}
				a.AlternateName = &alternateName
			}
		case "bingId":
			if v != nil {
				var bingID string
				err = json.Unmarshal(*v, &bingID)
				if err != nil {
					return err
				}
				a.BingID = &bingID
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				a.WebSearchURL = &webSearchURL
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar Type
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = typeVar
			}
		}
	}

	return nil
}

// BasicCreativeWork the most generic kind of creative work, including books, movies, photographs, software programs,
// etc.
type BasicCreativeWork interface {
	AsNewsArticle() (*NewsArticle, bool)
	AsImageObject() (*ImageObject, bool)
	AsArticle() (*Article, bool)
	AsBasicArticle() (BasicArticle, bool)
	AsVideoObject() (*VideoObject, bool)
	AsMediaObject() (*MediaObject, bool)
	AsBasicMediaObject() (BasicMediaObject, bool)
	AsCreativeWork() (*CreativeWork, bool)
}

// CreativeWork the most generic kind of creative work, including books, movies, photographs, software
// programs, etc.
type CreativeWork struct {
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	// DatePublished - The date on which the CreativeWork was published.
	DatePublished *string `json:"datePublished,omitempty"`
	// Video - A video of the item.
	Video *VideoObject `json:"video,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeNewsArticle', 'TypeNews', 'TypeSearchResultsAnswer', 'TypeImageObject', 'TypeNewsTopic', 'TypeAnswer', 'TypeArticle', 'TypeThing', 'TypeResponse', 'TypeTrendingTopics', 'TypeVideoObject', 'TypeCreativeWork', 'TypeOrganization', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeMediaObject'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicCreativeWork(body []byte) (BasicCreativeWork, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeNewsArticle):
		var na NewsArticle
		err := json.Unmarshal(body, &na)
		return na, err
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeArticle):
		var a Article
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeVideoObject):
		var vo VideoObject
		err := json.Unmarshal(body, &vo)
		return vo, err
	case string(TypeMediaObject):
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	default:
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	}
}
func unmarshalBasicCreativeWorkArray(body []byte) ([]BasicCreativeWork, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	cwArray := make([]BasicCreativeWork, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cw, err := unmarshalBasicCreativeWork(*rawMessage)
		if err != nil {
			return nil, err
		}
		cwArray[index] = cw
	}
	return cwArray, nil
}

// MarshalJSON is the custom marshaler for CreativeWork.
func (cw CreativeWork) MarshalJSON() ([]byte, error) {
	cw.Type = TypeCreativeWork
	objectMap := make(map[string]interface{})
	if cw.ThumbnailURL != nil {
		objectMap["thumbnailUrl"] = cw.ThumbnailURL
	}
	if cw.Provider != nil {
		objectMap["provider"] = cw.Provider
	}
	if cw.DatePublished != nil {
		objectMap["datePublished"] = cw.DatePublished
	}
	if cw.Video != nil {
		objectMap["video"] = cw.Video
	}
	if cw.Name != nil {
		objectMap["name"] = cw.Name
	}
	if cw.URL != nil {
		objectMap["url"] = cw.URL
	}
	if cw.Image != nil {
		objectMap["image"] = cw.Image
	}
	if cw.Description != nil {
		objectMap["description"] = cw.Description
	}
	if cw.AlternateName != nil {
		objectMap["alternateName"] = cw.AlternateName
	}
	if cw.BingID != nil {
		objectMap["bingId"] = cw.BingID
	}
	if cw.WebSearchURL != nil {
		objectMap["webSearchUrl"] = cw.WebSearchURL
	}
	if cw.ID != nil {
		objectMap["id"] = cw.ID
	}
	if cw.Type != "" {
		objectMap["_type"] = cw.Type
	}
	return json.Marshal(objectMap)
}

// AsNewsArticle is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsNewsArticle() (*NewsArticle, bool) {
	return nil, false
}

// AsNews is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsNews() (*News, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsNewsTopic is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsNewsTopic() (*NewsTopic, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsArticle is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsArticle() (*Article, bool) {
	return nil, false
}

// AsBasicArticle is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicArticle() (BasicArticle, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicThing() (BasicThing, bool) {
	return &cw, true
}

// AsResponse is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicResponse() (BasicResponse, bool) {
	return &cw, true
}

// AsTrendingTopics is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsTrendingTopics() (*TrendingTopics, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsCreativeWork() (*CreativeWork, bool) {
	return &cw, true
}

// AsBasicCreativeWork is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &cw, true
}

// AsOrganization is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &cw, true
}

// AsErrorResponse is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &cw, true
}

// UnmarshalJSON is the custom unmarshaler for CreativeWork struct.
func (cw *CreativeWork) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "thumbnailUrl":
			if v != nil {
				var thumbnailURL string
				err = json.Unmarshal(*v, &thumbnailURL)
				if err != nil {
					return err
				}
				cw.ThumbnailURL = &thumbnailURL
			}
		case "provider":
			if v != nil {
				provider, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				cw.Provider = &provider
			}
		case "datePublished":
			if v != nil {
				var datePublished string
				err = json.Unmarshal(*v, &datePublished)
				if err != nil {
					return err
				}
				cw.DatePublished = &datePublished
			}
		case "video":
			if v != nil {
				var video VideoObject
				err = json.Unmarshal(*v, &video)
				if err != nil {
					return err
				}
				cw.Video = &video
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cw.Name = &name
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				cw.URL = &URL
			}
		case "image":
			if v != nil {
				var imageVar ImageObject
				err = json.Unmarshal(*v, &imageVar)
				if err != nil {
					return err
				}
				cw.Image = &imageVar
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				cw.Description = &description
			}
		case "alternateName":
			if v != nil {
				var alternateName string
				err = json.Unmarshal(*v, &alternateName)
				if err != nil {
					return err
				}
				cw.AlternateName = &alternateName
			}
		case "bingId":
			if v != nil {
				var bingID string
				err = json.Unmarshal(*v, &bingID)
				if err != nil {
					return err
				}
				cw.BingID = &bingID
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				cw.WebSearchURL = &webSearchURL
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cw.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar Type
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cw.Type = typeVar
			}
		}
	}

	return nil
}

// Error defines the error that occurred.
type Error struct {
	// Code - The error code that identifies the category of error. Possible values include: 'None', 'ServerError', 'InvalidRequest', 'RateLimitExceeded', 'InvalidAuthorization', 'InsufficientAuthorization'
	Code ErrorCode `json:"code,omitempty"`
	// SubCode - The error code that further helps to identify the error. Possible values include: 'UnexpectedError', 'ResourceError', 'NotImplemented', 'ParameterMissing', 'ParameterInvalidValue', 'HTTPNotAllowed', 'Blocked', 'AuthorizationMissing', 'AuthorizationRedundancy', 'AuthorizationDisabled', 'AuthorizationExpired'
	SubCode ErrorSubCode `json:"subCode,omitempty"`
	// Message - A description of the error.
	Message *string `json:"message,omitempty"`
	// MoreDetails - A description that provides additional information about the error.
	MoreDetails *string `json:"moreDetails,omitempty"`
	// Parameter - The parameter in the request that caused the error.
	Parameter *string `json:"parameter,omitempty"`
	// Value - The parameter's value in the request that was not valid.
	Value *string `json:"value,omitempty"`
}

// ErrorResponse the top-level response that represents a failed request.
type ErrorResponse struct {
	// Errors - A list of errors that describe the reasons why the request failed.
	Errors *[]Error `json:"errors,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeNewsArticle', 'TypeNews', 'TypeSearchResultsAnswer', 'TypeImageObject', 'TypeNewsTopic', 'TypeAnswer', 'TypeArticle', 'TypeThing', 'TypeResponse', 'TypeTrendingTopics', 'TypeVideoObject', 'TypeCreativeWork', 'TypeOrganization', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeMediaObject'
	Type Type `json:"_type,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorResponse.
func (er ErrorResponse) MarshalJSON() ([]byte, error) {
	er.Type = TypeErrorResponse
	objectMap := make(map[string]interface{})
	if er.Errors != nil {
		objectMap["errors"] = er.Errors
	}
	if er.WebSearchURL != nil {
		objectMap["webSearchUrl"] = er.WebSearchURL
	}
	if er.ID != nil {
		objectMap["id"] = er.ID
	}
	if er.Type != "" {
		objectMap["_type"] = er.Type
	}
	return json.Marshal(objectMap)
}

// AsNewsArticle is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsNewsArticle() (*NewsArticle, bool) {
	return nil, false
}

// AsNews is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsNews() (*News, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsNewsTopic is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsNewsTopic() (*NewsTopic, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsArticle is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsArticle() (*Article, bool) {
	return nil, false
}

// AsBasicArticle is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicArticle() (BasicArticle, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicResponse() (BasicResponse, bool) {
	return &er, true
}

// AsTrendingTopics is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsTrendingTopics() (*TrendingTopics, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &er, true
}

// AsErrorResponse is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsErrorResponse() (*ErrorResponse, bool) {
	return &er, true
}

// AsMediaObject is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &er, true
}

// BasicIdentifiable defines the identity of a resource.
type BasicIdentifiable interface {
	AsNewsArticle() (*NewsArticle, bool)
	AsNews() (*News, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
	AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool)
	AsImageObject() (*ImageObject, bool)
	AsNewsTopic() (*NewsTopic, bool)
	AsAnswer() (*Answer, bool)
	AsBasicAnswer() (BasicAnswer, bool)
	AsArticle() (*Article, bool)
	AsBasicArticle() (BasicArticle, bool)
	AsThing() (*Thing, bool)
	AsBasicThing() (BasicThing, bool)
	AsResponse() (*Response, bool)
	AsBasicResponse() (BasicResponse, bool)
	AsTrendingTopics() (*TrendingTopics, bool)
	AsVideoObject() (*VideoObject, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsOrganization() (*Organization, bool)
	AsErrorResponse() (*ErrorResponse, bool)
	AsMediaObject() (*MediaObject, bool)
	AsBasicMediaObject() (BasicMediaObject, bool)
	AsIdentifiable() (*Identifiable, bool)
}

// Identifiable defines the identity of a resource.
type Identifiable struct {
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeNewsArticle', 'TypeNews', 'TypeSearchResultsAnswer', 'TypeImageObject', 'TypeNewsTopic', 'TypeAnswer', 'TypeArticle', 'TypeThing', 'TypeResponse', 'TypeTrendingTopics', 'TypeVideoObject', 'TypeCreativeWork', 'TypeOrganization', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeMediaObject'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicIdentifiable(body []byte) (BasicIdentifiable, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeNewsArticle):
		var na NewsArticle
		err := json.Unmarshal(body, &na)
		return na, err
	case string(TypeNews):
		var n News
		err := json.Unmarshal(body, &n)
		return n, err
	case string(TypeSearchResultsAnswer):
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeNewsTopic):
		var nt NewsTopic
		err := json.Unmarshal(body, &nt)
		return nt, err
	case string(TypeAnswer):
		var a Answer
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeArticle):
		var a Article
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeThing):
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	case string(TypeResponse):
		var r Response
		err := json.Unmarshal(body, &r)
		return r, err
	case string(TypeTrendingTopics):
		var tt TrendingTopics
		err := json.Unmarshal(body, &tt)
		return tt, err
	case string(TypeVideoObject):
		var vo VideoObject
		err := json.Unmarshal(body, &vo)
		return vo, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	case string(TypeOrganization):
		var o Organization
		err := json.Unmarshal(body, &o)
		return o, err
	case string(TypeErrorResponse):
		var er ErrorResponse
		err := json.Unmarshal(body, &er)
		return er, err
	case string(TypeMediaObject):
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	default:
		var i Identifiable
		err := json.Unmarshal(body, &i)
		return i, err
	}
}
func unmarshalBasicIdentifiableArray(body []byte) ([]BasicIdentifiable, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	iArray := make([]BasicIdentifiable, len(rawMessages))

	for index, rawMessage := range rawMessages {
		i, err := unmarshalBasicIdentifiable(*rawMessage)
		if err != nil {
			return nil, err
		}
		iArray[index] = i
	}
	return iArray, nil
}

// MarshalJSON is the custom marshaler for Identifiable.
func (i Identifiable) MarshalJSON() ([]byte, error) {
	i.Type = TypeIdentifiable
	objectMap := make(map[string]interface{})
	if i.ID != nil {
		objectMap["id"] = i.ID
	}
	if i.Type != "" {
		objectMap["_type"] = i.Type
	}
	return json.Marshal(objectMap)
}

// AsNewsArticle is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsNewsArticle() (*NewsArticle, bool) {
	return nil, false
}

// AsNews is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsNews() (*News, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsNewsTopic is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsNewsTopic() (*NewsTopic, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsArticle is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsArticle() (*Article, bool) {
	return nil, false
}

// AsBasicArticle is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicArticle() (BasicArticle, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicResponse() (BasicResponse, bool) {
	return nil, false
}

// AsTrendingTopics is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsTrendingTopics() (*TrendingTopics, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsIdentifiable() (*Identifiable, bool) {
	return &i, true
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &i, true
}

// AsErrorResponse is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &i, true
}

// ImageObject defines an image
type ImageObject struct {
	// Thumbnail - The URL to a thumbnail of the image
	Thumbnail *ImageObject `json:"thumbnail,omitempty"`
	// ContentURL - Original URL to retrieve the source (file) for the media object (e.g the source URL for the image).
	ContentURL *string `json:"contentUrl,omitempty"`
	// Width - The width of the source media object, in pixels.
	Width *int32 `json:"width,omitempty"`
	// Height - The height of the source media object, in pixels.
	Height *int32 `json:"height,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	// DatePublished - The date on which the CreativeWork was published.
	DatePublished *string `json:"datePublished,omitempty"`
	// Video - A video of the item.
	Video *VideoObject `json:"video,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeNewsArticle', 'TypeNews', 'TypeSearchResultsAnswer', 'TypeImageObject', 'TypeNewsTopic', 'TypeAnswer', 'TypeArticle', 'TypeThing', 'TypeResponse', 'TypeTrendingTopics', 'TypeVideoObject', 'TypeCreativeWork', 'TypeOrganization', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeMediaObject'
	Type Type `json:"_type,omitempty"`
}

// MarshalJSON is the custom marshaler for ImageObject.
func (ioVar ImageObject) MarshalJSON() ([]byte, error) {
	ioVar.Type = TypeImageObject
	objectMap := make(map[string]interface{})
	if ioVar.Thumbnail != nil {
		objectMap["thumbnail"] = ioVar.Thumbnail
	}
	if ioVar.ContentURL != nil {
		objectMap["contentUrl"] = ioVar.ContentURL
	}
	if ioVar.Width != nil {
		objectMap["width"] = ioVar.Width
	}
	if ioVar.Height != nil {
		objectMap["height"] = ioVar.Height
	}
	if ioVar.ThumbnailURL != nil {
		objectMap["thumbnailUrl"] = ioVar.ThumbnailURL
	}
	if ioVar.Provider != nil {
		objectMap["provider"] = ioVar.Provider
	}
	if ioVar.DatePublished != nil {
		objectMap["datePublished"] = ioVar.DatePublished
	}
	if ioVar.Video != nil {
		objectMap["video"] = ioVar.Video
	}
	if ioVar.Name != nil {
		objectMap["name"] = ioVar.Name
	}
	if ioVar.URL != nil {
		objectMap["url"] = ioVar.URL
	}
	if ioVar.Image != nil {
		objectMap["image"] = ioVar.Image
	}
	if ioVar.Description != nil {
		objectMap["description"] = ioVar.Description
	}
	if ioVar.AlternateName != nil {
		objectMap["alternateName"] = ioVar.AlternateName
	}
	if ioVar.BingID != nil {
		objectMap["bingId"] = ioVar.BingID
	}
	if ioVar.WebSearchURL != nil {
		objectMap["webSearchUrl"] = ioVar.WebSearchURL
	}
	if ioVar.ID != nil {
		objectMap["id"] = ioVar.ID
	}
	if ioVar.Type != "" {
		objectMap["_type"] = ioVar.Type
	}
	return json.Marshal(objectMap)
}

// AsNewsArticle is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsNewsArticle() (*NewsArticle, bool) {
	return nil, false
}

// AsNews is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsNews() (*News, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsImageObject() (*ImageObject, bool) {
	return &ioVar, true
}

// AsNewsTopic is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsNewsTopic() (*NewsTopic, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsArticle is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsArticle() (*Article, bool) {
	return nil, false
}

// AsBasicArticle is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicArticle() (BasicArticle, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicThing() (BasicThing, bool) {
	return &ioVar, true
}

// AsResponse is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicResponse() (BasicResponse, bool) {
	return &ioVar, true
}

// AsTrendingTopics is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsTrendingTopics() (*TrendingTopics, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &ioVar, true
}

// AsOrganization is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &ioVar, true
}

// AsErrorResponse is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicMediaObject() (BasicMediaObject, bool) {
	return &ioVar, true
}

// AsResponseBase is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &ioVar, true
}

// UnmarshalJSON is the custom unmarshaler for ImageObject struct.
func (ioVar *ImageObject) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "thumbnail":
			if v != nil {
				var thumbnail ImageObject
				err = json.Unmarshal(*v, &thumbnail)
				if err != nil {
					return err
				}
				ioVar.Thumbnail = &thumbnail
			}
		case "contentUrl":
			if v != nil {
				var contentURL string
				err = json.Unmarshal(*v, &contentURL)
				if err != nil {
					return err
				}
				ioVar.ContentURL = &contentURL
			}
		case "width":
			if v != nil {
				var width int32
				err = json.Unmarshal(*v, &width)
				if err != nil {
					return err
				}
				ioVar.Width = &width
			}
		case "height":
			if v != nil {
				var height int32
				err = json.Unmarshal(*v, &height)
				if err != nil {
					return err
				}
				ioVar.Height = &height
			}
		case "thumbnailUrl":
			if v != nil {
				var thumbnailURL string
				err = json.Unmarshal(*v, &thumbnailURL)
				if err != nil {
					return err
				}
				ioVar.ThumbnailURL = &thumbnailURL
			}
		case "provider":
			if v != nil {
				provider, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				ioVar.Provider = &provider
			}
		case "datePublished":
			if v != nil {
				var datePublished string
				err = json.Unmarshal(*v, &datePublished)
				if err != nil {
					return err
				}
				ioVar.DatePublished = &datePublished
			}
		case "video":
			if v != nil {
				var video VideoObject
				err = json.Unmarshal(*v, &video)
				if err != nil {
					return err
				}
				ioVar.Video = &video
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ioVar.Name = &name
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				ioVar.URL = &URL
			}
		case "image":
			if v != nil {
				var imageVar ImageObject
				err = json.Unmarshal(*v, &imageVar)
				if err != nil {
					return err
				}
				ioVar.Image = &imageVar
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				ioVar.Description = &description
			}
		case "alternateName":
			if v != nil {
				var alternateName string
				err = json.Unmarshal(*v, &alternateName)
				if err != nil {
					return err
				}
				ioVar.AlternateName = &alternateName
			}
		case "bingId":
			if v != nil {
				var bingID string
				err = json.Unmarshal(*v, &bingID)
				if err != nil {
					return err
				}
				ioVar.BingID = &bingID
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				ioVar.WebSearchURL = &webSearchURL
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ioVar.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar Type
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ioVar.Type = typeVar
			}
		}
	}

	return nil
}

// BasicMediaObject defines a media object.
type BasicMediaObject interface {
	AsImageObject() (*ImageObject, bool)
	AsVideoObject() (*VideoObject, bool)
	AsMediaObject() (*MediaObject, bool)
}

// MediaObject defines a media object.
type MediaObject struct {
	// ContentURL - Original URL to retrieve the source (file) for the media object (e.g the source URL for the image).
	ContentURL *string `json:"contentUrl,omitempty"`
	// Width - The width of the source media object, in pixels.
	Width *int32 `json:"width,omitempty"`
	// Height - The height of the source media object, in pixels.
	Height *int32 `json:"height,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	// DatePublished - The date on which the CreativeWork was published.
	DatePublished *string `json:"datePublished,omitempty"`
	// Video - A video of the item.
	Video *VideoObject `json:"video,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeNewsArticle', 'TypeNews', 'TypeSearchResultsAnswer', 'TypeImageObject', 'TypeNewsTopic', 'TypeAnswer', 'TypeArticle', 'TypeThing', 'TypeResponse', 'TypeTrendingTopics', 'TypeVideoObject', 'TypeCreativeWork', 'TypeOrganization', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeMediaObject'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicMediaObject(body []byte) (BasicMediaObject, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeVideoObject):
		var vo VideoObject
		err := json.Unmarshal(body, &vo)
		return vo, err
	default:
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	}
}
func unmarshalBasicMediaObjectArray(body []byte) ([]BasicMediaObject, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	moArray := make([]BasicMediaObject, len(rawMessages))

	for index, rawMessage := range rawMessages {
		mo, err := unmarshalBasicMediaObject(*rawMessage)
		if err != nil {
			return nil, err
		}
		moArray[index] = mo
	}
	return moArray, nil
}

// MarshalJSON is the custom marshaler for MediaObject.
func (mo MediaObject) MarshalJSON() ([]byte, error) {
	mo.Type = TypeMediaObject
	objectMap := make(map[string]interface{})
	if mo.ContentURL != nil {
		objectMap["contentUrl"] = mo.ContentURL
	}
	if mo.Width != nil {
		objectMap["width"] = mo.Width
	}
	if mo.Height != nil {
		objectMap["height"] = mo.Height
	}
	if mo.ThumbnailURL != nil {
		objectMap["thumbnailUrl"] = mo.ThumbnailURL
	}
	if mo.Provider != nil {
		objectMap["provider"] = mo.Provider
	}
	if mo.DatePublished != nil {
		objectMap["datePublished"] = mo.DatePublished
	}
	if mo.Video != nil {
		objectMap["video"] = mo.Video
	}
	if mo.Name != nil {
		objectMap["name"] = mo.Name
	}
	if mo.URL != nil {
		objectMap["url"] = mo.URL
	}
	if mo.Image != nil {
		objectMap["image"] = mo.Image
	}
	if mo.Description != nil {
		objectMap["description"] = mo.Description
	}
	if mo.AlternateName != nil {
		objectMap["alternateName"] = mo.AlternateName
	}
	if mo.BingID != nil {
		objectMap["bingId"] = mo.BingID
	}
	if mo.WebSearchURL != nil {
		objectMap["webSearchUrl"] = mo.WebSearchURL
	}
	if mo.ID != nil {
		objectMap["id"] = mo.ID
	}
	if mo.Type != "" {
		objectMap["_type"] = mo.Type
	}
	return json.Marshal(objectMap)
}

// AsNewsArticle is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsNewsArticle() (*NewsArticle, bool) {
	return nil, false
}

// AsNews is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsNews() (*News, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsNewsTopic is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsNewsTopic() (*NewsTopic, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsArticle is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsArticle() (*Article, bool) {
	return nil, false
}

// AsBasicArticle is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicArticle() (BasicArticle, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicThing() (BasicThing, bool) {
	return &mo, true
}

// AsResponse is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicResponse() (BasicResponse, bool) {
	return &mo, true
}

// AsTrendingTopics is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsTrendingTopics() (*TrendingTopics, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &mo, true
}

// AsOrganization is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &mo, true
}

// AsErrorResponse is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsMediaObject() (*MediaObject, bool) {
	return &mo, true
}

// AsBasicMediaObject is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicMediaObject() (BasicMediaObject, bool) {
	return &mo, true
}

// AsResponseBase is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &mo, true
}

// UnmarshalJSON is the custom unmarshaler for MediaObject struct.
func (mo *MediaObject) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "contentUrl":
			if v != nil {
				var contentURL string
				err = json.Unmarshal(*v, &contentURL)
				if err != nil {
					return err
				}
				mo.ContentURL = &contentURL
			}
		case "width":
			if v != nil {
				var width int32
				err = json.Unmarshal(*v, &width)
				if err != nil {
					return err
				}
				mo.Width = &width
			}
		case "height":
			if v != nil {
				var height int32
				err = json.Unmarshal(*v, &height)
				if err != nil {
					return err
				}
				mo.Height = &height
			}
		case "thumbnailUrl":
			if v != nil {
				var thumbnailURL string
				err = json.Unmarshal(*v, &thumbnailURL)
				if err != nil {
					return err
				}
				mo.ThumbnailURL = &thumbnailURL
			}
		case "provider":
			if v != nil {
				provider, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				mo.Provider = &provider
			}
		case "datePublished":
			if v != nil {
				var datePublished string
				err = json.Unmarshal(*v, &datePublished)
				if err != nil {
					return err
				}
				mo.DatePublished = &datePublished
			}
		case "video":
			if v != nil {
				var video VideoObject
				err = json.Unmarshal(*v, &video)
				if err != nil {
					return err
				}
				mo.Video = &video
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mo.Name = &name
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				mo.URL = &URL
			}
		case "image":
			if v != nil {
				var imageVar ImageObject
				err = json.Unmarshal(*v, &imageVar)
				if err != nil {
					return err
				}
				mo.Image = &imageVar
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				mo.Description = &description
			}
		case "alternateName":
			if v != nil {
				var alternateName string
				err = json.Unmarshal(*v, &alternateName)
				if err != nil {
					return err
				}
				mo.AlternateName = &alternateName
			}
		case "bingId":
			if v != nil {
				var bingID string
				err = json.Unmarshal(*v, &bingID)
				if err != nil {
					return err
				}
				mo.BingID = &bingID
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				mo.WebSearchURL = &webSearchURL
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mo.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar Type
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mo.Type = typeVar
			}
		}
	}

	return nil
}

// News defines a news answer.
type News struct {
	autorest.Response `json:"-"`
	// Value - An array of NewsArticle objects that contain information about news articles that are relevant to the query. If there are no results to return for the request, the array is empty.
	Value *[]NewsArticle `json:"value,omitempty"`
	// Location - Location of local news
	Location *string `json:"location,omitempty"`
	// TotalEstimatedMatches - The estimated number of webpages that are relevant to the query. Use this number along with the count and offset query parameters to page the results.
	TotalEstimatedMatches *int64   `json:"totalEstimatedMatches,omitempty"`
	FollowUpQueries       *[]Query `json:"followUpQueries,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeNewsArticle', 'TypeNews', 'TypeSearchResultsAnswer', 'TypeImageObject', 'TypeNewsTopic', 'TypeAnswer', 'TypeArticle', 'TypeThing', 'TypeResponse', 'TypeTrendingTopics', 'TypeVideoObject', 'TypeCreativeWork', 'TypeOrganization', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeMediaObject'
	Type Type `json:"_type,omitempty"`
}

// MarshalJSON is the custom marshaler for News.
func (n News) MarshalJSON() ([]byte, error) {
	n.Type = TypeNews
	objectMap := make(map[string]interface{})
	if n.Value != nil {
		objectMap["value"] = n.Value
	}
	if n.Location != nil {
		objectMap["location"] = n.Location
	}
	if n.TotalEstimatedMatches != nil {
		objectMap["totalEstimatedMatches"] = n.TotalEstimatedMatches
	}
	if n.FollowUpQueries != nil {
		objectMap["followUpQueries"] = n.FollowUpQueries
	}
	if n.WebSearchURL != nil {
		objectMap["webSearchUrl"] = n.WebSearchURL
	}
	if n.ID != nil {
		objectMap["id"] = n.ID
	}
	if n.Type != "" {
		objectMap["_type"] = n.Type
	}
	return json.Marshal(objectMap)
}

// AsNewsArticle is the BasicResponseBase implementation for News.
func (n News) AsNewsArticle() (*NewsArticle, bool) {
	return nil, false
}

// AsNews is the BasicResponseBase implementation for News.
func (n News) AsNews() (*News, bool) {
	return &n, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for News.
func (n News) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for News.
func (n News) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return &n, true
}

// AsImageObject is the BasicResponseBase implementation for News.
func (n News) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsNewsTopic is the BasicResponseBase implementation for News.
func (n News) AsNewsTopic() (*NewsTopic, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for News.
func (n News) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for News.
func (n News) AsBasicAnswer() (BasicAnswer, bool) {
	return &n, true
}

// AsArticle is the BasicResponseBase implementation for News.
func (n News) AsArticle() (*Article, bool) {
	return nil, false
}

// AsBasicArticle is the BasicResponseBase implementation for News.
func (n News) AsBasicArticle() (BasicArticle, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for News.
func (n News) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for News.
func (n News) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for News.
func (n News) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for News.
func (n News) AsBasicResponse() (BasicResponse, bool) {
	return &n, true
}

// AsTrendingTopics is the BasicResponseBase implementation for News.
func (n News) AsTrendingTopics() (*TrendingTopics, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for News.
func (n News) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for News.
func (n News) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for News.
func (n News) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for News.
func (n News) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for News.
func (n News) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for News.
func (n News) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &n, true
}

// AsErrorResponse is the BasicResponseBase implementation for News.
func (n News) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for News.
func (n News) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for News.
func (n News) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for News.
func (n News) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for News.
func (n News) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &n, true
}

// NewsArticle defines a news article.
type NewsArticle struct {
	// Category - The news category that the article belongs to. For example, Sports. If the news category cannot be determined, the article does not include this field.
	Category *string `json:"category,omitempty"`
	// Headline - A Boolean value that indicates whether the news article is a headline. If true, the article is a headline. The article includes this field only for news categories requests that do not specify the category query parameter.
	Headline *bool `json:"headline,omitempty"`
	// ClusteredArticles - A list of related news articles.
	ClusteredArticles *[]NewsArticle `json:"clusteredArticles,omitempty"`
	// WordCount - The number of words in the text of the Article.
	WordCount *int32 `json:"wordCount,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	// DatePublished - The date on which the CreativeWork was published.
	DatePublished *string `json:"datePublished,omitempty"`
	// Video - A video of the item.
	Video *VideoObject `json:"video,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeNewsArticle', 'TypeNews', 'TypeSearchResultsAnswer', 'TypeImageObject', 'TypeNewsTopic', 'TypeAnswer', 'TypeArticle', 'TypeThing', 'TypeResponse', 'TypeTrendingTopics', 'TypeVideoObject', 'TypeCreativeWork', 'TypeOrganization', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeMediaObject'
	Type Type `json:"_type,omitempty"`
}

// MarshalJSON is the custom marshaler for NewsArticle.
func (na NewsArticle) MarshalJSON() ([]byte, error) {
	na.Type = TypeNewsArticle
	objectMap := make(map[string]interface{})
	if na.Category != nil {
		objectMap["category"] = na.Category
	}
	if na.Headline != nil {
		objectMap["headline"] = na.Headline
	}
	if na.ClusteredArticles != nil {
		objectMap["clusteredArticles"] = na.ClusteredArticles
	}
	if na.WordCount != nil {
		objectMap["wordCount"] = na.WordCount
	}
	if na.ThumbnailURL != nil {
		objectMap["thumbnailUrl"] = na.ThumbnailURL
	}
	if na.Provider != nil {
		objectMap["provider"] = na.Provider
	}
	if na.DatePublished != nil {
		objectMap["datePublished"] = na.DatePublished
	}
	if na.Video != nil {
		objectMap["video"] = na.Video
	}
	if na.Name != nil {
		objectMap["name"] = na.Name
	}
	if na.URL != nil {
		objectMap["url"] = na.URL
	}
	if na.Image != nil {
		objectMap["image"] = na.Image
	}
	if na.Description != nil {
		objectMap["description"] = na.Description
	}
	if na.AlternateName != nil {
		objectMap["alternateName"] = na.AlternateName
	}
	if na.BingID != nil {
		objectMap["bingId"] = na.BingID
	}
	if na.WebSearchURL != nil {
		objectMap["webSearchUrl"] = na.WebSearchURL
	}
	if na.ID != nil {
		objectMap["id"] = na.ID
	}
	if na.Type != "" {
		objectMap["_type"] = na.Type
	}
	return json.Marshal(objectMap)
}

// AsNewsArticle is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsNewsArticle() (*NewsArticle, bool) {
	return &na, true
}

// AsNews is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsNews() (*News, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsNewsTopic is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsNewsTopic() (*NewsTopic, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsArticle is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsArticle() (*Article, bool) {
	return nil, false
}

// AsBasicArticle is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsBasicArticle() (BasicArticle, bool) {
	return &na, true
}

// AsThing is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsBasicThing() (BasicThing, bool) {
	return &na, true
}

// AsResponse is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsBasicResponse() (BasicResponse, bool) {
	return &na, true
}

// AsTrendingTopics is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsTrendingTopics() (*TrendingTopics, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &na, true
}

// AsOrganization is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &na, true
}

// AsErrorResponse is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &na, true
}

// UnmarshalJSON is the custom unmarshaler for NewsArticle struct.
func (na *NewsArticle) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "category":
			if v != nil {
				var category string
				err = json.Unmarshal(*v, &category)
				if err != nil {
					return err
				}
				na.Category = &category
			}
		case "headline":
			if v != nil {
				var headline bool
				err = json.Unmarshal(*v, &headline)
				if err != nil {
					return err
				}
				na.Headline = &headline
			}
		case "clusteredArticles":
			if v != nil {
				var clusteredArticles []NewsArticle
				err = json.Unmarshal(*v, &clusteredArticles)
				if err != nil {
					return err
				}
				na.ClusteredArticles = &clusteredArticles
			}
		case "wordCount":
			if v != nil {
				var wordCount int32
				err = json.Unmarshal(*v, &wordCount)
				if err != nil {
					return err
				}
				na.WordCount = &wordCount
			}
		case "thumbnailUrl":
			if v != nil {
				var thumbnailURL string
				err = json.Unmarshal(*v, &thumbnailURL)
				if err != nil {
					return err
				}
				na.ThumbnailURL = &thumbnailURL
			}
		case "provider":
			if v != nil {
				provider, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				na.Provider = &provider
			}
		case "datePublished":
			if v != nil {
				var datePublished string
				err = json.Unmarshal(*v, &datePublished)
				if err != nil {
					return err
				}
				na.DatePublished = &datePublished
			}
		case "video":
			if v != nil {
				var video VideoObject
				err = json.Unmarshal(*v, &video)
				if err != nil {
					return err
				}
				na.Video = &video
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				na.Name = &name
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				na.URL = &URL
			}
		case "image":
			if v != nil {
				var imageVar ImageObject
				err = json.Unmarshal(*v, &imageVar)
				if err != nil {
					return err
				}
				na.Image = &imageVar
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				na.Description = &description
			}
		case "alternateName":
			if v != nil {
				var alternateName string
				err = json.Unmarshal(*v, &alternateName)
				if err != nil {
					return err
				}
				na.AlternateName = &alternateName
			}
		case "bingId":
			if v != nil {
				var bingID string
				err = json.Unmarshal(*v, &bingID)
				if err != nil {
					return err
				}
				na.BingID = &bingID
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				na.WebSearchURL = &webSearchURL
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				na.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar Type
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				na.Type = typeVar
			}
		}
	}

	return nil
}

// NewsTopic ...
type NewsTopic struct {
	// IsBreakingNews - A Boolean value that indicates whether the topic is considered breaking news. If the topic is considered breaking news, the value is true.
	IsBreakingNews *bool `json:"isBreakingNews,omitempty"`
	// Query - A search query term that returns this trending topic.
	Query *Query `json:"query,omitempty"`
	// NewsSearchURL - The URL to the Bing News search results for the search query term
	NewsSearchURL *string `json:"newsSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeNewsArticle', 'TypeNews', 'TypeSearchResultsAnswer', 'TypeImageObject', 'TypeNewsTopic', 'TypeAnswer', 'TypeArticle', 'TypeThing', 'TypeResponse', 'TypeTrendingTopics', 'TypeVideoObject', 'TypeCreativeWork', 'TypeOrganization', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeMediaObject'
	Type Type `json:"_type,omitempty"`
}

// MarshalJSON is the custom marshaler for NewsTopic.
func (nt NewsTopic) MarshalJSON() ([]byte, error) {
	nt.Type = TypeNewsTopic
	objectMap := make(map[string]interface{})
	if nt.IsBreakingNews != nil {
		objectMap["isBreakingNews"] = nt.IsBreakingNews
	}
	if nt.Query != nil {
		objectMap["query"] = nt.Query
	}
	if nt.NewsSearchURL != nil {
		objectMap["newsSearchUrl"] = nt.NewsSearchURL
	}
	if nt.Name != nil {
		objectMap["name"] = nt.Name
	}
	if nt.URL != nil {
		objectMap["url"] = nt.URL
	}
	if nt.Image != nil {
		objectMap["image"] = nt.Image
	}
	if nt.Description != nil {
		objectMap["description"] = nt.Description
	}
	if nt.AlternateName != nil {
		objectMap["alternateName"] = nt.AlternateName
	}
	if nt.BingID != nil {
		objectMap["bingId"] = nt.BingID
	}
	if nt.WebSearchURL != nil {
		objectMap["webSearchUrl"] = nt.WebSearchURL
	}
	if nt.ID != nil {
		objectMap["id"] = nt.ID
	}
	if nt.Type != "" {
		objectMap["_type"] = nt.Type
	}
	return json.Marshal(objectMap)
}

// AsNewsArticle is the BasicResponseBase implementation for NewsTopic.
func (nt NewsTopic) AsNewsArticle() (*NewsArticle, bool) {
	return nil, false
}

// AsNews is the BasicResponseBase implementation for NewsTopic.
func (nt NewsTopic) AsNews() (*News, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for NewsTopic.
func (nt NewsTopic) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for NewsTopic.
func (nt NewsTopic) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for NewsTopic.
func (nt NewsTopic) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsNewsTopic is the BasicResponseBase implementation for NewsTopic.
func (nt NewsTopic) AsNewsTopic() (*NewsTopic, bool) {
	return &nt, true
}

// AsAnswer is the BasicResponseBase implementation for NewsTopic.
func (nt NewsTopic) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for NewsTopic.
func (nt NewsTopic) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsArticle is the BasicResponseBase implementation for NewsTopic.
func (nt NewsTopic) AsArticle() (*Article, bool) {
	return nil, false
}

// AsBasicArticle is the BasicResponseBase implementation for NewsTopic.
func (nt NewsTopic) AsBasicArticle() (BasicArticle, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for NewsTopic.
func (nt NewsTopic) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for NewsTopic.
func (nt NewsTopic) AsBasicThing() (BasicThing, bool) {
	return &nt, true
}

// AsResponse is the BasicResponseBase implementation for NewsTopic.
func (nt NewsTopic) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for NewsTopic.
func (nt NewsTopic) AsBasicResponse() (BasicResponse, bool) {
	return &nt, true
}

// AsTrendingTopics is the BasicResponseBase implementation for NewsTopic.
func (nt NewsTopic) AsTrendingTopics() (*TrendingTopics, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for NewsTopic.
func (nt NewsTopic) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for NewsTopic.
func (nt NewsTopic) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for NewsTopic.
func (nt NewsTopic) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for NewsTopic.
func (nt NewsTopic) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for NewsTopic.
func (nt NewsTopic) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for NewsTopic.
func (nt NewsTopic) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &nt, true
}

// AsErrorResponse is the BasicResponseBase implementation for NewsTopic.
func (nt NewsTopic) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for NewsTopic.
func (nt NewsTopic) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for NewsTopic.
func (nt NewsTopic) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for NewsTopic.
func (nt NewsTopic) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for NewsTopic.
func (nt NewsTopic) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &nt, true
}

// Organization defines an organization.
type Organization struct {
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeNewsArticle', 'TypeNews', 'TypeSearchResultsAnswer', 'TypeImageObject', 'TypeNewsTopic', 'TypeAnswer', 'TypeArticle', 'TypeThing', 'TypeResponse', 'TypeTrendingTopics', 'TypeVideoObject', 'TypeCreativeWork', 'TypeOrganization', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeMediaObject'
	Type Type `json:"_type,omitempty"`
}

// MarshalJSON is the custom marshaler for Organization.
func (o Organization) MarshalJSON() ([]byte, error) {
	o.Type = TypeOrganization
	objectMap := make(map[string]interface{})
	if o.Name != nil {
		objectMap["name"] = o.Name
	}
	if o.URL != nil {
		objectMap["url"] = o.URL
	}
	if o.Image != nil {
		objectMap["image"] = o.Image
	}
	if o.Description != nil {
		objectMap["description"] = o.Description
	}
	if o.AlternateName != nil {
		objectMap["alternateName"] = o.AlternateName
	}
	if o.BingID != nil {
		objectMap["bingId"] = o.BingID
	}
	if o.WebSearchURL != nil {
		objectMap["webSearchUrl"] = o.WebSearchURL
	}
	if o.ID != nil {
		objectMap["id"] = o.ID
	}
	if o.Type != "" {
		objectMap["_type"] = o.Type
	}
	return json.Marshal(objectMap)
}

// AsNewsArticle is the BasicResponseBase implementation for Organization.
func (o Organization) AsNewsArticle() (*NewsArticle, bool) {
	return nil, false
}

// AsNews is the BasicResponseBase implementation for Organization.
func (o Organization) AsNews() (*News, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Organization.
func (o Organization) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for Organization.
func (o Organization) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsNewsTopic is the BasicResponseBase implementation for Organization.
func (o Organization) AsNewsTopic() (*NewsTopic, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Organization.
func (o Organization) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsArticle is the BasicResponseBase implementation for Organization.
func (o Organization) AsArticle() (*Article, bool) {
	return nil, false
}

// AsBasicArticle is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicArticle() (BasicArticle, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for Organization.
func (o Organization) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicThing() (BasicThing, bool) {
	return &o, true
}

// AsResponse is the BasicResponseBase implementation for Organization.
func (o Organization) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicResponse() (BasicResponse, bool) {
	return &o, true
}

// AsTrendingTopics is the BasicResponseBase implementation for Organization.
func (o Organization) AsTrendingTopics() (*TrendingTopics, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for Organization.
func (o Organization) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Organization.
func (o Organization) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for Organization.
func (o Organization) AsOrganization() (*Organization, bool) {
	return &o, true
}

// AsIdentifiable is the BasicResponseBase implementation for Organization.
func (o Organization) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &o, true
}

// AsErrorResponse is the BasicResponseBase implementation for Organization.
func (o Organization) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Organization.
func (o Organization) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Organization.
func (o Organization) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &o, true
}

// Query defines a search query.
type Query struct {
	// Text - The query string. Use this string as the query term in a new search request.
	Text *string `json:"text,omitempty"`
	// DisplayText - The display version of the query term. This version of the query term may contain special characters that highlight the search term found in the query string. The string contains the highlighting characters only if the query enabled hit highlighting
	DisplayText *string `json:"displayText,omitempty"`
	// WebSearchURL - The URL that takes the user to the Bing search results page for the query.Only related search results include this field.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// SearchLink - The URL that you use to get the results of the related search. Before using the URL, you must append query parameters as appropriate and include the Ocp-Apim-Subscription-Key header. Use this URL if you're displaying the results in your own user interface. Otherwise, use the webSearchUrl URL.
	SearchLink *string `json:"searchLink,omitempty"`
	// Thumbnail - The URL to a thumbnail of a related image.
	Thumbnail *ImageObject `json:"thumbnail,omitempty"`
}

// BasicResponse defines a response. All schemas that could be returned at the root of a response should inherit from
// this
type BasicResponse interface {
	AsNewsArticle() (*NewsArticle, bool)
	AsNews() (*News, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
	AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool)
	AsImageObject() (*ImageObject, bool)
	AsNewsTopic() (*NewsTopic, bool)
	AsAnswer() (*Answer, bool)
	AsBasicAnswer() (BasicAnswer, bool)
	AsArticle() (*Article, bool)
	AsBasicArticle() (BasicArticle, bool)
	AsThing() (*Thing, bool)
	AsBasicThing() (BasicThing, bool)
	AsTrendingTopics() (*TrendingTopics, bool)
	AsVideoObject() (*VideoObject, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsOrganization() (*Organization, bool)
	AsErrorResponse() (*ErrorResponse, bool)
	AsMediaObject() (*MediaObject, bool)
	AsBasicMediaObject() (BasicMediaObject, bool)
	AsResponse() (*Response, bool)
}

// Response defines a response. All schemas that could be returned at the root of a response should inherit
// from this
type Response struct {
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeNewsArticle', 'TypeNews', 'TypeSearchResultsAnswer', 'TypeImageObject', 'TypeNewsTopic', 'TypeAnswer', 'TypeArticle', 'TypeThing', 'TypeResponse', 'TypeTrendingTopics', 'TypeVideoObject', 'TypeCreativeWork', 'TypeOrganization', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeMediaObject'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicResponse(body []byte) (BasicResponse, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeNewsArticle):
		var na NewsArticle
		err := json.Unmarshal(body, &na)
		return na, err
	case string(TypeNews):
		var n News
		err := json.Unmarshal(body, &n)
		return n, err
	case string(TypeSearchResultsAnswer):
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeNewsTopic):
		var nt NewsTopic
		err := json.Unmarshal(body, &nt)
		return nt, err
	case string(TypeAnswer):
		var a Answer
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeArticle):
		var a Article
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeThing):
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	case string(TypeTrendingTopics):
		var tt TrendingTopics
		err := json.Unmarshal(body, &tt)
		return tt, err
	case string(TypeVideoObject):
		var vo VideoObject
		err := json.Unmarshal(body, &vo)
		return vo, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	case string(TypeOrganization):
		var o Organization
		err := json.Unmarshal(body, &o)
		return o, err
	case string(TypeErrorResponse):
		var er ErrorResponse
		err := json.Unmarshal(body, &er)
		return er, err
	case string(TypeMediaObject):
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	default:
		var r Response
		err := json.Unmarshal(body, &r)
		return r, err
	}
}
func unmarshalBasicResponseArray(body []byte) ([]BasicResponse, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rArray := make([]BasicResponse, len(rawMessages))

	for index, rawMessage := range rawMessages {
		r, err := unmarshalBasicResponse(*rawMessage)
		if err != nil {
			return nil, err
		}
		rArray[index] = r
	}
	return rArray, nil
}

// MarshalJSON is the custom marshaler for Response.
func (r Response) MarshalJSON() ([]byte, error) {
	r.Type = TypeResponse
	objectMap := make(map[string]interface{})
	if r.WebSearchURL != nil {
		objectMap["webSearchUrl"] = r.WebSearchURL
	}
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	if r.Type != "" {
		objectMap["_type"] = r.Type
	}
	return json.Marshal(objectMap)
}

// AsNewsArticle is the BasicResponseBase implementation for Response.
func (r Response) AsNewsArticle() (*NewsArticle, bool) {
	return nil, false
}

// AsNews is the BasicResponseBase implementation for Response.
func (r Response) AsNews() (*News, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for Response.
func (r Response) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsNewsTopic is the BasicResponseBase implementation for Response.
func (r Response) AsNewsTopic() (*NewsTopic, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsArticle is the BasicResponseBase implementation for Response.
func (r Response) AsArticle() (*Article, bool) {
	return nil, false
}

// AsBasicArticle is the BasicResponseBase implementation for Response.
func (r Response) AsBasicArticle() (BasicArticle, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for Response.
func (r Response) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Response.
func (r Response) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Response.
func (r Response) AsResponse() (*Response, bool) {
	return &r, true
}

// AsBasicResponse is the BasicResponseBase implementation for Response.
func (r Response) AsBasicResponse() (BasicResponse, bool) {
	return &r, true
}

// AsTrendingTopics is the BasicResponseBase implementation for Response.
func (r Response) AsTrendingTopics() (*TrendingTopics, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for Response.
func (r Response) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Response.
func (r Response) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Response.
func (r Response) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for Response.
func (r Response) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Response.
func (r Response) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Response.
func (r Response) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &r, true
}

// AsErrorResponse is the BasicResponseBase implementation for Response.
func (r Response) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Response.
func (r Response) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Response.
func (r Response) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Response.
func (r Response) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Response.
func (r Response) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &r, true
}

// BasicResponseBase response base
type BasicResponseBase interface {
	AsNewsArticle() (*NewsArticle, bool)
	AsNews() (*News, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
	AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool)
	AsImageObject() (*ImageObject, bool)
	AsNewsTopic() (*NewsTopic, bool)
	AsAnswer() (*Answer, bool)
	AsBasicAnswer() (BasicAnswer, bool)
	AsArticle() (*Article, bool)
	AsBasicArticle() (BasicArticle, bool)
	AsThing() (*Thing, bool)
	AsBasicThing() (BasicThing, bool)
	AsResponse() (*Response, bool)
	AsBasicResponse() (BasicResponse, bool)
	AsTrendingTopics() (*TrendingTopics, bool)
	AsVideoObject() (*VideoObject, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsOrganization() (*Organization, bool)
	AsIdentifiable() (*Identifiable, bool)
	AsBasicIdentifiable() (BasicIdentifiable, bool)
	AsErrorResponse() (*ErrorResponse, bool)
	AsMediaObject() (*MediaObject, bool)
	AsBasicMediaObject() (BasicMediaObject, bool)
	AsResponseBase() (*ResponseBase, bool)
}

// ResponseBase response base
type ResponseBase struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeNewsArticle', 'TypeNews', 'TypeSearchResultsAnswer', 'TypeImageObject', 'TypeNewsTopic', 'TypeAnswer', 'TypeArticle', 'TypeThing', 'TypeResponse', 'TypeTrendingTopics', 'TypeVideoObject', 'TypeCreativeWork', 'TypeOrganization', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeMediaObject'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicResponseBase(body []byte) (BasicResponseBase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeNewsArticle):
		var na NewsArticle
		err := json.Unmarshal(body, &na)
		return na, err
	case string(TypeNews):
		var n News
		err := json.Unmarshal(body, &n)
		return n, err
	case string(TypeSearchResultsAnswer):
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeNewsTopic):
		var nt NewsTopic
		err := json.Unmarshal(body, &nt)
		return nt, err
	case string(TypeAnswer):
		var a Answer
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeArticle):
		var a Article
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeThing):
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	case string(TypeResponse):
		var r Response
		err := json.Unmarshal(body, &r)
		return r, err
	case string(TypeTrendingTopics):
		var tt TrendingTopics
		err := json.Unmarshal(body, &tt)
		return tt, err
	case string(TypeVideoObject):
		var vo VideoObject
		err := json.Unmarshal(body, &vo)
		return vo, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	case string(TypeOrganization):
		var o Organization
		err := json.Unmarshal(body, &o)
		return o, err
	case string(TypeIdentifiable):
		var i Identifiable
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeErrorResponse):
		var er ErrorResponse
		err := json.Unmarshal(body, &er)
		return er, err
	case string(TypeMediaObject):
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	default:
		var rb ResponseBase
		err := json.Unmarshal(body, &rb)
		return rb, err
	}
}
func unmarshalBasicResponseBaseArray(body []byte) ([]BasicResponseBase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rbArray := make([]BasicResponseBase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rb, err := unmarshalBasicResponseBase(*rawMessage)
		if err != nil {
			return nil, err
		}
		rbArray[index] = rb
	}
	return rbArray, nil
}

// MarshalJSON is the custom marshaler for ResponseBase.
func (rb ResponseBase) MarshalJSON() ([]byte, error) {
	rb.Type = TypeResponseBase
	objectMap := make(map[string]interface{})
	if rb.Type != "" {
		objectMap["_type"] = rb.Type
	}
	return json.Marshal(objectMap)
}

// AsNewsArticle is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsNewsArticle() (*NewsArticle, bool) {
	return nil, false
}

// AsNews is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsNews() (*News, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsNewsTopic is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsNewsTopic() (*NewsTopic, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsArticle is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsArticle() (*Article, bool) {
	return nil, false
}

// AsBasicArticle is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicArticle() (BasicArticle, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicResponse() (BasicResponse, bool) {
	return nil, false
}

// AsTrendingTopics is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsTrendingTopics() (*TrendingTopics, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsResponseBase() (*ResponseBase, bool) {
	return &rb, true
}

// AsBasicResponseBase is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &rb, true
}

// BasicSearchResultsAnswer defines a search result answer.
type BasicSearchResultsAnswer interface {
	AsNews() (*News, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
}

// SearchResultsAnswer defines a search result answer.
type SearchResultsAnswer struct {
	// TotalEstimatedMatches - The estimated number of webpages that are relevant to the query. Use this number along with the count and offset query parameters to page the results.
	TotalEstimatedMatches *int64   `json:"totalEstimatedMatches,omitempty"`
	FollowUpQueries       *[]Query `json:"followUpQueries,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeNewsArticle', 'TypeNews', 'TypeSearchResultsAnswer', 'TypeImageObject', 'TypeNewsTopic', 'TypeAnswer', 'TypeArticle', 'TypeThing', 'TypeResponse', 'TypeTrendingTopics', 'TypeVideoObject', 'TypeCreativeWork', 'TypeOrganization', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeMediaObject'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicSearchResultsAnswer(body []byte) (BasicSearchResultsAnswer, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeNews):
		var n News
		err := json.Unmarshal(body, &n)
		return n, err
	default:
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	}
}
func unmarshalBasicSearchResultsAnswerArray(body []byte) ([]BasicSearchResultsAnswer, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	sraArray := make([]BasicSearchResultsAnswer, len(rawMessages))

	for index, rawMessage := range rawMessages {
		sra, err := unmarshalBasicSearchResultsAnswer(*rawMessage)
		if err != nil {
			return nil, err
		}
		sraArray[index] = sra
	}
	return sraArray, nil
}

// MarshalJSON is the custom marshaler for SearchResultsAnswer.
func (sra SearchResultsAnswer) MarshalJSON() ([]byte, error) {
	sra.Type = TypeSearchResultsAnswer
	objectMap := make(map[string]interface{})
	if sra.TotalEstimatedMatches != nil {
		objectMap["totalEstimatedMatches"] = sra.TotalEstimatedMatches
	}
	if sra.FollowUpQueries != nil {
		objectMap["followUpQueries"] = sra.FollowUpQueries
	}
	if sra.WebSearchURL != nil {
		objectMap["webSearchUrl"] = sra.WebSearchURL
	}
	if sra.ID != nil {
		objectMap["id"] = sra.ID
	}
	if sra.Type != "" {
		objectMap["_type"] = sra.Type
	}
	return json.Marshal(objectMap)
}

// AsNewsArticle is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsNewsArticle() (*NewsArticle, bool) {
	return nil, false
}

// AsNews is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsNews() (*News, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return &sra, true
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return &sra, true
}

// AsImageObject is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsNewsTopic is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsNewsTopic() (*NewsTopic, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicAnswer() (BasicAnswer, bool) {
	return &sra, true
}

// AsArticle is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsArticle() (*Article, bool) {
	return nil, false
}

// AsBasicArticle is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicArticle() (BasicArticle, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicResponse() (BasicResponse, bool) {
	return &sra, true
}

// AsTrendingTopics is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsTrendingTopics() (*TrendingTopics, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &sra, true
}

// AsErrorResponse is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &sra, true
}

// BasicThing defines a thing.
type BasicThing interface {
	AsNewsArticle() (*NewsArticle, bool)
	AsImageObject() (*ImageObject, bool)
	AsNewsTopic() (*NewsTopic, bool)
	AsArticle() (*Article, bool)
	AsBasicArticle() (BasicArticle, bool)
	AsVideoObject() (*VideoObject, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsOrganization() (*Organization, bool)
	AsMediaObject() (*MediaObject, bool)
	AsBasicMediaObject() (BasicMediaObject, bool)
	AsThing() (*Thing, bool)
}

// Thing defines a thing.
type Thing struct {
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeNewsArticle', 'TypeNews', 'TypeSearchResultsAnswer', 'TypeImageObject', 'TypeNewsTopic', 'TypeAnswer', 'TypeArticle', 'TypeThing', 'TypeResponse', 'TypeTrendingTopics', 'TypeVideoObject', 'TypeCreativeWork', 'TypeOrganization', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeMediaObject'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicThing(body []byte) (BasicThing, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeNewsArticle):
		var na NewsArticle
		err := json.Unmarshal(body, &na)
		return na, err
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeNewsTopic):
		var nt NewsTopic
		err := json.Unmarshal(body, &nt)
		return nt, err
	case string(TypeArticle):
		var a Article
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeVideoObject):
		var vo VideoObject
		err := json.Unmarshal(body, &vo)
		return vo, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	case string(TypeOrganization):
		var o Organization
		err := json.Unmarshal(body, &o)
		return o, err
	case string(TypeMediaObject):
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	default:
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	}
}
func unmarshalBasicThingArray(body []byte) ([]BasicThing, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	tArray := make([]BasicThing, len(rawMessages))

	for index, rawMessage := range rawMessages {
		t, err := unmarshalBasicThing(*rawMessage)
		if err != nil {
			return nil, err
		}
		tArray[index] = t
	}
	return tArray, nil
}

// MarshalJSON is the custom marshaler for Thing.
func (t Thing) MarshalJSON() ([]byte, error) {
	t.Type = TypeThing
	objectMap := make(map[string]interface{})
	if t.Name != nil {
		objectMap["name"] = t.Name
	}
	if t.URL != nil {
		objectMap["url"] = t.URL
	}
	if t.Image != nil {
		objectMap["image"] = t.Image
	}
	if t.Description != nil {
		objectMap["description"] = t.Description
	}
	if t.AlternateName != nil {
		objectMap["alternateName"] = t.AlternateName
	}
	if t.BingID != nil {
		objectMap["bingId"] = t.BingID
	}
	if t.WebSearchURL != nil {
		objectMap["webSearchUrl"] = t.WebSearchURL
	}
	if t.ID != nil {
		objectMap["id"] = t.ID
	}
	if t.Type != "" {
		objectMap["_type"] = t.Type
	}
	return json.Marshal(objectMap)
}

// AsNewsArticle is the BasicResponseBase implementation for Thing.
func (t Thing) AsNewsArticle() (*NewsArticle, bool) {
	return nil, false
}

// AsNews is the BasicResponseBase implementation for Thing.
func (t Thing) AsNews() (*News, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for Thing.
func (t Thing) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsNewsTopic is the BasicResponseBase implementation for Thing.
func (t Thing) AsNewsTopic() (*NewsTopic, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsArticle is the BasicResponseBase implementation for Thing.
func (t Thing) AsArticle() (*Article, bool) {
	return nil, false
}

// AsBasicArticle is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicArticle() (BasicArticle, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for Thing.
func (t Thing) AsThing() (*Thing, bool) {
	return &t, true
}

// AsBasicThing is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicThing() (BasicThing, bool) {
	return &t, true
}

// AsResponse is the BasicResponseBase implementation for Thing.
func (t Thing) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicResponse() (BasicResponse, bool) {
	return &t, true
}

// AsTrendingTopics is the BasicResponseBase implementation for Thing.
func (t Thing) AsTrendingTopics() (*TrendingTopics, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for Thing.
func (t Thing) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Thing.
func (t Thing) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for Thing.
func (t Thing) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Thing.
func (t Thing) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &t, true
}

// AsErrorResponse is the BasicResponseBase implementation for Thing.
func (t Thing) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Thing.
func (t Thing) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Thing.
func (t Thing) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &t, true
}

// TrendingTopics ...
type TrendingTopics struct {
	autorest.Response `json:"-"`
	// Value - A list of trending news topics on Bing
	Value           *[]NewsTopic `json:"value,omitempty"`
	FollowUpQueries *[]Query     `json:"followUpQueries,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeNewsArticle', 'TypeNews', 'TypeSearchResultsAnswer', 'TypeImageObject', 'TypeNewsTopic', 'TypeAnswer', 'TypeArticle', 'TypeThing', 'TypeResponse', 'TypeTrendingTopics', 'TypeVideoObject', 'TypeCreativeWork', 'TypeOrganization', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeMediaObject'
	Type Type `json:"_type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrendingTopics.
func (tt TrendingTopics) MarshalJSON() ([]byte, error) {
	tt.Type = TypeTrendingTopics
	objectMap := make(map[string]interface{})
	if tt.Value != nil {
		objectMap["value"] = tt.Value
	}
	if tt.FollowUpQueries != nil {
		objectMap["followUpQueries"] = tt.FollowUpQueries
	}
	if tt.WebSearchURL != nil {
		objectMap["webSearchUrl"] = tt.WebSearchURL
	}
	if tt.ID != nil {
		objectMap["id"] = tt.ID
	}
	if tt.Type != "" {
		objectMap["_type"] = tt.Type
	}
	return json.Marshal(objectMap)
}

// AsNewsArticle is the BasicResponseBase implementation for TrendingTopics.
func (tt TrendingTopics) AsNewsArticle() (*NewsArticle, bool) {
	return nil, false
}

// AsNews is the BasicResponseBase implementation for TrendingTopics.
func (tt TrendingTopics) AsNews() (*News, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for TrendingTopics.
func (tt TrendingTopics) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for TrendingTopics.
func (tt TrendingTopics) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for TrendingTopics.
func (tt TrendingTopics) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsNewsTopic is the BasicResponseBase implementation for TrendingTopics.
func (tt TrendingTopics) AsNewsTopic() (*NewsTopic, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for TrendingTopics.
func (tt TrendingTopics) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for TrendingTopics.
func (tt TrendingTopics) AsBasicAnswer() (BasicAnswer, bool) {
	return &tt, true
}

// AsArticle is the BasicResponseBase implementation for TrendingTopics.
func (tt TrendingTopics) AsArticle() (*Article, bool) {
	return nil, false
}

// AsBasicArticle is the BasicResponseBase implementation for TrendingTopics.
func (tt TrendingTopics) AsBasicArticle() (BasicArticle, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for TrendingTopics.
func (tt TrendingTopics) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for TrendingTopics.
func (tt TrendingTopics) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for TrendingTopics.
func (tt TrendingTopics) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for TrendingTopics.
func (tt TrendingTopics) AsBasicResponse() (BasicResponse, bool) {
	return &tt, true
}

// AsTrendingTopics is the BasicResponseBase implementation for TrendingTopics.
func (tt TrendingTopics) AsTrendingTopics() (*TrendingTopics, bool) {
	return &tt, true
}

// AsVideoObject is the BasicResponseBase implementation for TrendingTopics.
func (tt TrendingTopics) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for TrendingTopics.
func (tt TrendingTopics) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for TrendingTopics.
func (tt TrendingTopics) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for TrendingTopics.
func (tt TrendingTopics) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for TrendingTopics.
func (tt TrendingTopics) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for TrendingTopics.
func (tt TrendingTopics) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &tt, true
}

// AsErrorResponse is the BasicResponseBase implementation for TrendingTopics.
func (tt TrendingTopics) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for TrendingTopics.
func (tt TrendingTopics) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for TrendingTopics.
func (tt TrendingTopics) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for TrendingTopics.
func (tt TrendingTopics) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for TrendingTopics.
func (tt TrendingTopics) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &tt, true
}

// VideoObject defines a video object that is relevant to the query.
type VideoObject struct {
	MotionThumbnailURL *string      `json:"motionThumbnailUrl,omitempty"`
	MotionThumbnailID  *string      `json:"motionThumbnailId,omitempty"`
	EmbedHTML          *string      `json:"embedHtml,omitempty"`
	AllowHTTPSEmbed    *bool        `json:"allowHttpsEmbed,omitempty"`
	ViewCount          *int32       `json:"viewCount,omitempty"`
	Thumbnail          *ImageObject `json:"thumbnail,omitempty"`
	VideoID            *string      `json:"videoId,omitempty"`
	AllowMobileEmbed   *bool        `json:"allowMobileEmbed,omitempty"`
	IsSuperfresh       *bool        `json:"isSuperfresh,omitempty"`
	// ContentURL - Original URL to retrieve the source (file) for the media object (e.g the source URL for the image).
	ContentURL *string `json:"contentUrl,omitempty"`
	// Width - The width of the source media object, in pixels.
	Width *int32 `json:"width,omitempty"`
	// Height - The height of the source media object, in pixels.
	Height *int32 `json:"height,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	// DatePublished - The date on which the CreativeWork was published.
	DatePublished *string `json:"datePublished,omitempty"`
	// Video - A video of the item.
	Video *VideoObject `json:"video,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeNewsArticle', 'TypeNews', 'TypeSearchResultsAnswer', 'TypeImageObject', 'TypeNewsTopic', 'TypeAnswer', 'TypeArticle', 'TypeThing', 'TypeResponse', 'TypeTrendingTopics', 'TypeVideoObject', 'TypeCreativeWork', 'TypeOrganization', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeMediaObject'
	Type Type `json:"_type,omitempty"`
}

// MarshalJSON is the custom marshaler for VideoObject.
func (vo VideoObject) MarshalJSON() ([]byte, error) {
	vo.Type = TypeVideoObject
	objectMap := make(map[string]interface{})
	if vo.MotionThumbnailURL != nil {
		objectMap["motionThumbnailUrl"] = vo.MotionThumbnailURL
	}
	if vo.MotionThumbnailID != nil {
		objectMap["motionThumbnailId"] = vo.MotionThumbnailID
	}
	if vo.EmbedHTML != nil {
		objectMap["embedHtml"] = vo.EmbedHTML
	}
	if vo.AllowHTTPSEmbed != nil {
		objectMap["allowHttpsEmbed"] = vo.AllowHTTPSEmbed
	}
	if vo.ViewCount != nil {
		objectMap["viewCount"] = vo.ViewCount
	}
	if vo.Thumbnail != nil {
		objectMap["thumbnail"] = vo.Thumbnail
	}
	if vo.VideoID != nil {
		objectMap["videoId"] = vo.VideoID
	}
	if vo.AllowMobileEmbed != nil {
		objectMap["allowMobileEmbed"] = vo.AllowMobileEmbed
	}
	if vo.IsSuperfresh != nil {
		objectMap["isSuperfresh"] = vo.IsSuperfresh
	}
	if vo.ContentURL != nil {
		objectMap["contentUrl"] = vo.ContentURL
	}
	if vo.Width != nil {
		objectMap["width"] = vo.Width
	}
	if vo.Height != nil {
		objectMap["height"] = vo.Height
	}
	if vo.ThumbnailURL != nil {
		objectMap["thumbnailUrl"] = vo.ThumbnailURL
	}
	if vo.Provider != nil {
		objectMap["provider"] = vo.Provider
	}
	if vo.DatePublished != nil {
		objectMap["datePublished"] = vo.DatePublished
	}
	if vo.Video != nil {
		objectMap["video"] = vo.Video
	}
	if vo.Name != nil {
		objectMap["name"] = vo.Name
	}
	if vo.URL != nil {
		objectMap["url"] = vo.URL
	}
	if vo.Image != nil {
		objectMap["image"] = vo.Image
	}
	if vo.Description != nil {
		objectMap["description"] = vo.Description
	}
	if vo.AlternateName != nil {
		objectMap["alternateName"] = vo.AlternateName
	}
	if vo.BingID != nil {
		objectMap["bingId"] = vo.BingID
	}
	if vo.WebSearchURL != nil {
		objectMap["webSearchUrl"] = vo.WebSearchURL
	}
	if vo.ID != nil {
		objectMap["id"] = vo.ID
	}
	if vo.Type != "" {
		objectMap["_type"] = vo.Type
	}
	return json.Marshal(objectMap)
}

// AsNewsArticle is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsNewsArticle() (*NewsArticle, bool) {
	return nil, false
}

// AsNews is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsNews() (*News, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsNewsTopic is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsNewsTopic() (*NewsTopic, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsArticle is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsArticle() (*Article, bool) {
	return nil, false
}

// AsBasicArticle is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsBasicArticle() (BasicArticle, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsBasicThing() (BasicThing, bool) {
	return &vo, true
}

// AsResponse is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsBasicResponse() (BasicResponse, bool) {
	return &vo, true
}

// AsTrendingTopics is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsTrendingTopics() (*TrendingTopics, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsVideoObject() (*VideoObject, bool) {
	return &vo, true
}

// AsCreativeWork is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &vo, true
}

// AsOrganization is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &vo, true
}

// AsErrorResponse is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsBasicMediaObject() (BasicMediaObject, bool) {
	return &vo, true
}

// AsResponseBase is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &vo, true
}

// UnmarshalJSON is the custom unmarshaler for VideoObject struct.
func (vo *VideoObject) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "motionThumbnailUrl":
			if v != nil {
				var motionThumbnailURL string
				err = json.Unmarshal(*v, &motionThumbnailURL)
				if err != nil {
					return err
				}
				vo.MotionThumbnailURL = &motionThumbnailURL
			}
		case "motionThumbnailId":
			if v != nil {
				var motionThumbnailID string
				err = json.Unmarshal(*v, &motionThumbnailID)
				if err != nil {
					return err
				}
				vo.MotionThumbnailID = &motionThumbnailID
			}
		case "embedHtml":
			if v != nil {
				var embedHTML string
				err = json.Unmarshal(*v, &embedHTML)
				if err != nil {
					return err
				}
				vo.EmbedHTML = &embedHTML
			}
		case "allowHttpsEmbed":
			if v != nil {
				var allowHTTPSEmbed bool
				err = json.Unmarshal(*v, &allowHTTPSEmbed)
				if err != nil {
					return err
				}
				vo.AllowHTTPSEmbed = &allowHTTPSEmbed
			}
		case "viewCount":
			if v != nil {
				var viewCount int32
				err = json.Unmarshal(*v, &viewCount)
				if err != nil {
					return err
				}
				vo.ViewCount = &viewCount
			}
		case "thumbnail":
			if v != nil {
				var thumbnail ImageObject
				err = json.Unmarshal(*v, &thumbnail)
				if err != nil {
					return err
				}
				vo.Thumbnail = &thumbnail
			}
		case "videoId":
			if v != nil {
				var videoID string
				err = json.Unmarshal(*v, &videoID)
				if err != nil {
					return err
				}
				vo.VideoID = &videoID
			}
		case "allowMobileEmbed":
			if v != nil {
				var allowMobileEmbed bool
				err = json.Unmarshal(*v, &allowMobileEmbed)
				if err != nil {
					return err
				}
				vo.AllowMobileEmbed = &allowMobileEmbed
			}
		case "isSuperfresh":
			if v != nil {
				var isSuperfresh bool
				err = json.Unmarshal(*v, &isSuperfresh)
				if err != nil {
					return err
				}
				vo.IsSuperfresh = &isSuperfresh
			}
		case "contentUrl":
			if v != nil {
				var contentURL string
				err = json.Unmarshal(*v, &contentURL)
				if err != nil {
					return err
				}
				vo.ContentURL = &contentURL
			}
		case "width":
			if v != nil {
				var width int32
				err = json.Unmarshal(*v, &width)
				if err != nil {
					return err
				}
				vo.Width = &width
			}
		case "height":
			if v != nil {
				var height int32
				err = json.Unmarshal(*v, &height)
				if err != nil {
					return err
				}
				vo.Height = &height
			}
		case "thumbnailUrl":
			if v != nil {
				var thumbnailURL string
				err = json.Unmarshal(*v, &thumbnailURL)
				if err != nil {
					return err
				}
				vo.ThumbnailURL = &thumbnailURL
			}
		case "provider":
			if v != nil {
				provider, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				vo.Provider = &provider
			}
		case "datePublished":
			if v != nil {
				var datePublished string
				err = json.Unmarshal(*v, &datePublished)
				if err != nil {
					return err
				}
				vo.DatePublished = &datePublished
			}
		case "video":
			if v != nil {
				var video VideoObject
				err = json.Unmarshal(*v, &video)
				if err != nil {
					return err
				}
				vo.Video = &video
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vo.Name = &name
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				vo.URL = &URL
			}
		case "image":
			if v != nil {
				var imageVar ImageObject
				err = json.Unmarshal(*v, &imageVar)
				if err != nil {
					return err
				}
				vo.Image = &imageVar
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				vo.Description = &description
			}
		case "alternateName":
			if v != nil {
				var alternateName string
				err = json.Unmarshal(*v, &alternateName)
				if err != nil {
					return err
				}
				vo.AlternateName = &alternateName
			}
		case "bingId":
			if v != nil {
				var bingID string
				err = json.Unmarshal(*v, &bingID)
				if err != nil {
					return err
				}
				vo.BingID = &bingID
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				vo.WebSearchURL = &webSearchURL
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vo.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar Type
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vo.Type = typeVar
			}
		}
	}

	return nil
}
