package catalog

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/satori/go.uuid"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/datalake/analytics/2016-11-01-preview/catalog"

// ACLType enumerates the values for acl type.
type ACLType string

const (
	// Group ...
	Group ACLType = "Group"
	// GroupObj ...
	GroupObj ACLType = "GroupObj"
	// Other ...
	Other ACLType = "Other"
	// User ...
	User ACLType = "User"
	// UserObj ...
	UserObj ACLType = "UserObj"
)

// PossibleACLTypeValues returns an array of possible values for the ACLType const type.
func PossibleACLTypeValues() []ACLType {
	return []ACLType{Group, GroupObj, Other, User, UserObj}
}

// FileType enumerates the values for file type.
type FileType string

const (
	// Assembly ...
	Assembly FileType = "Assembly"
	// Nodeploy ...
	Nodeploy FileType = "Nodeploy"
	// Resource ...
	Resource FileType = "Resource"
)

// PossibleFileTypeValues returns an array of possible values for the FileType const type.
func PossibleFileTypeValues() []FileType {
	return []FileType{Assembly, Nodeploy, Resource}
}

// PermissionType enumerates the values for permission type.
type PermissionType string

const (
	// All ...
	All PermissionType = "All"
	// Alter ...
	Alter PermissionType = "Alter"
	// Create ...
	Create PermissionType = "Create"
	// Drop ...
	Drop PermissionType = "Drop"
	// None ...
	None PermissionType = "None"
	// Use ...
	Use PermissionType = "Use"
	// Write ...
	Write PermissionType = "Write"
)

// PossiblePermissionTypeValues returns an array of possible values for the PermissionType const type.
func PossiblePermissionTypeValues() []PermissionType {
	return []PermissionType{All, Alter, Create, Drop, None, Use, Write}
}

// ACL a Data Lake Analytics catalog access control list (ACL) entry.
type ACL struct {
	// AceType - the access control list (ACL) entry type. UserObj and GroupObj denote the owning user and group, respectively. Possible values include: 'UserObj', 'GroupObj', 'Other', 'User', 'Group'
	AceType ACLType `json:"aceType,omitempty"`
	// PrincipalID - the Azure AD object ID of the user or group being specified in the access control list (ACL) entry.
	PrincipalID *uuid.UUID `json:"principalId,omitempty"`
	// Permission - the permission type of the access control list (ACL) entry. Possible values include: 'None', 'Use', 'Create', 'Drop', 'Alter', 'Write', 'All'
	Permission PermissionType `json:"permission,omitempty"`
}

// ACLCreateOrUpdateParameters the parameters used to create or update an access control list (ACL) entry.
type ACLCreateOrUpdateParameters struct {
	// AceType - the access control list (ACL) entry type. UserObj and GroupObj denote the owning user and group, respectively. Possible values include: 'UserObj', 'GroupObj', 'Other', 'User', 'Group'
	AceType ACLType `json:"aceType,omitempty"`
	// PrincipalID - the Azure AD object ID of the user or group being specified in the access control list (ACL) entry.
	PrincipalID *uuid.UUID `json:"principalId,omitempty"`
	// Permission - the permission type of the access control list (ACL) entry. Possible values include: 'None', 'Use', 'Create', 'Drop', 'Alter', 'Write', 'All'
	Permission PermissionType `json:"permission,omitempty"`
}

// ACLDeleteParameters the parameters used to delete an access control list (ACL) entry.
type ACLDeleteParameters struct {
	// AceType - the access control list (ACL) entry type. UserObj and GroupObj denote the owning user and group, respectively. Possible values include: 'UserObj', 'GroupObj', 'Other', 'User', 'Group'
	AceType ACLType `json:"aceType,omitempty"`
	// PrincipalID - the Azure AD object ID of the user or group being specified in the access control list (ACL) entry.
	PrincipalID *uuid.UUID `json:"principalId,omitempty"`
}

// ACLList a Data Lake Analytics catalog access control list (ACL).
type ACLList struct {
	autorest.Response `json:"-"`
	// Value - the access control list (ACL).
	Value *[]ACL `json:"value,omitempty"`
	// NextLink - the link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ACLListIterator provides access to a complete listing of ACL values.
type ACLListIterator struct {
	i    int
	page ACLListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ACLListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ACLListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ACLListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ACLListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ACLListIterator) Response() ACLList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ACLListIterator) Value() ACL {
	if !iter.page.NotDone() {
		return ACL{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ACLListIterator type.
func NewACLListIterator(page ACLListPage) ACLListIterator {
	return ACLListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (al ACLList) IsEmpty() bool {
	return al.Value == nil || len(*al.Value) == 0
}

// aCLListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (al ACLList) aCLListPreparer(ctx context.Context) (*http.Request, error) {
	if al.NextLink == nil || len(to.String(al.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(al.NextLink)))
}

// ACLListPage contains a page of ACL values.
type ACLListPage struct {
	fn func(context.Context, ACLList) (ACLList, error)
	al ACLList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ACLListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ACLListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.al)
	if err != nil {
		return err
	}
	page.al = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ACLListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ACLListPage) NotDone() bool {
	return !page.al.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ACLListPage) Response() ACLList {
	return page.al
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ACLListPage) Values() []ACL {
	if page.al.IsEmpty() {
		return nil
	}
	return *page.al.Value
}

// Creates a new instance of the ACLListPage type.
func NewACLListPage(getNextPage func(context.Context, ACLList) (ACLList, error)) ACLListPage {
	return ACLListPage{fn: getNextPage}
}

// DataLakeAnalyticsCatalogCredentialCreateParameters data Lake Analytics catalog credential creation
// parameters.
type DataLakeAnalyticsCatalogCredentialCreateParameters struct {
	// Password - the password for the credential and user with access to the data source.
	Password *string `json:"password,omitempty"`
	// URI - the URI identifier for the data source this credential can connect to in the format <hostname>:<port>
	URI *string `json:"uri,omitempty"`
	// UserID - the object identifier for the user associated with this credential with access to the data source.
	UserID *string `json:"userId,omitempty"`
}

// DataLakeAnalyticsCatalogCredentialDeleteParameters data Lake Analytics catalog credential deletion
// parameters.
type DataLakeAnalyticsCatalogCredentialDeleteParameters struct {
	// Password - the current password for the credential and user with access to the data source. This is required if the requester is not the account owner.
	Password *string `json:"password,omitempty"`
}

// DataLakeAnalyticsCatalogCredentialUpdateParameters data Lake Analytics catalog credential update
// parameters.
type DataLakeAnalyticsCatalogCredentialUpdateParameters struct {
	// Password - the current password for the credential and user with access to the data source. This is required if the requester is not the account owner.
	Password *string `json:"password,omitempty"`
	// NewPassword - the new password for the credential and user with access to the data source.
	NewPassword *string `json:"newPassword,omitempty"`
	// URI - the URI identifier for the data source this credential can connect to in the format <hostname>:<port>
	URI *string `json:"uri,omitempty"`
	// UserID - the object identifier for the user associated with this credential with access to the data source.
	UserID *string `json:"userId,omitempty"`
}

// DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters data Lake Analytics catalog secret creation and
// update parameters. This is deprecated and will be removed in the next release. Please use
// DataLakeAnalyticsCatalogCredentialCreateOrUpdateParameters instead.
type DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters struct {
	// Password - the password for the secret to pass in
	Password *string `json:"password,omitempty"`
	// URI - the URI identifier for the secret in the format <hostname>:<port>
	URI *string `json:"uri,omitempty"`
}

// DdlName a Data Lake Analytics DDL name item.
type DdlName struct {
	// FirstPart - the name of the table associated with this database and schema.
	FirstPart *string `json:"firstPart,omitempty"`
	// SecondPart - the name of the table associated with this database and schema.
	SecondPart *string `json:"secondPart,omitempty"`
	// ThirdPart - the name of the table associated with this database and schema.
	ThirdPart *string `json:"thirdPart,omitempty"`
	// Server - the name of the table associated with this database and schema.
	Server *string `json:"server,omitempty"`
}

// EntityID a Data Lake Analytics catalog entity identifier object.
type EntityID struct {
	// Name - the name of the external table associated with this database, schema and table.
	Name *DdlName `json:"name,omitempty"`
	// Version - the version of the external data source.
	Version *uuid.UUID `json:"version,omitempty"`
}

// ExternalTable a Data Lake Analytics catalog external table item.
type ExternalTable struct {
	// TableName - the name of the table associated with this database and schema.
	TableName *string `json:"tableName,omitempty"`
	// DataSource - the data source associated with this external table.
	DataSource *EntityID `json:"dataSource,omitempty"`
}

// Item a Data Lake Analytics catalog item.
type Item struct {
	// ComputeAccountName - the name of the Data Lake Analytics account.
	ComputeAccountName *string `json:"computeAccountName,omitempty"`
	// Version - the version of the catalog item.
	Version *uuid.UUID `json:"version,omitempty"`
}

// ItemList a Data Lake Analytics catalog item list.
type ItemList struct {
	// NextLink - the link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// TypeFieldInfo a Data Lake Analytics catalog type field information item.
type TypeFieldInfo struct {
	// Name - the name of the field associated with this type.
	Name *string `json:"name,omitempty"`
	// Type - the type of the field.
	Type *string `json:"type,omitempty"`
}

// USQLAssembly a Data Lake Analytics catalog U-SQL Assembly.
type USQLAssembly struct {
	autorest.Response `json:"-"`
	// DatabaseName - the name of the database.
	DatabaseName *string `json:"databaseName,omitempty"`
	// Name - the name of the assembly.
	Name *string `json:"assemblyName,omitempty"`
	// ClrName - the name of the CLR.
	ClrName *string `json:"clrName,omitempty"`
	// IsVisible - the switch indicating if this assembly is visible or not.
	IsVisible *bool `json:"isVisible,omitempty"`
	// IsUserDefined - the switch indicating if this assembly is user defined or not.
	IsUserDefined *bool `json:"isUserDefined,omitempty"`
	// Files - the list of files associated with the assembly
	Files *[]USQLAssemblyFileInfo `json:"files,omitempty"`
	// Dependencies - the list of dependencies associated with the assembly
	Dependencies *[]USQLAssemblyDependencyInfo `json:"dependencies,omitempty"`
	// ComputeAccountName - the name of the Data Lake Analytics account.
	ComputeAccountName *string `json:"computeAccountName,omitempty"`
	// Version - the version of the catalog item.
	Version *uuid.UUID `json:"version,omitempty"`
}

// USQLAssemblyClr a Data Lake Analytics catalog U-SQL assembly CLR item.
type USQLAssemblyClr struct {
	// DatabaseName - the name of the database.
	DatabaseName *string `json:"databaseName,omitempty"`
	// Name - the name of the assembly.
	Name *string `json:"assemblyClrName,omitempty"`
	// ClrName - the name of the CLR.
	ClrName *string `json:"clrName,omitempty"`
	// ComputeAccountName - the name of the Data Lake Analytics account.
	ComputeAccountName *string `json:"computeAccountName,omitempty"`
	// Version - the version of the catalog item.
	Version *uuid.UUID `json:"version,omitempty"`
}

// USQLAssemblyDependencyInfo a Data Lake Analytics catalog U-SQL dependency information item.
type USQLAssemblyDependencyInfo struct {
	// EntityID - the EntityId of the dependency.
	EntityID *EntityID `json:"entityId,omitempty"`
}

// USQLAssemblyFileInfo a Data Lake Analytics catalog U-SQL assembly file information item.
type USQLAssemblyFileInfo struct {
	// Type - the assembly file type. Possible values include: 'Assembly', 'Resource', 'Nodeploy'
	Type FileType `json:"type,omitempty"`
	// OriginalPath - the the original path to the assembly file.
	OriginalPath *string `json:"originalPath,omitempty"`
	// ContentPath - the the content path to the assembly file.
	ContentPath *string `json:"contentPath,omitempty"`
}

// USQLAssemblyList a Data Lake Analytics catalog U-SQL assembly CLR item list.
type USQLAssemblyList struct {
	autorest.Response `json:"-"`
	// Value - the list of assemblies in the database
	Value *[]USQLAssemblyClr `json:"value,omitempty"`
	// NextLink - the link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// USQLAssemblyListIterator provides access to a complete listing of USQLAssemblyClr values.
type USQLAssemblyListIterator struct {
	i    int
	page USQLAssemblyListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *USQLAssemblyListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLAssemblyListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *USQLAssemblyListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter USQLAssemblyListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter USQLAssemblyListIterator) Response() USQLAssemblyList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter USQLAssemblyListIterator) Value() USQLAssemblyClr {
	if !iter.page.NotDone() {
		return USQLAssemblyClr{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the USQLAssemblyListIterator type.
func NewUSQLAssemblyListIterator(page USQLAssemblyListPage) USQLAssemblyListIterator {
	return USQLAssemblyListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (usal USQLAssemblyList) IsEmpty() bool {
	return usal.Value == nil || len(*usal.Value) == 0
}

// uSQLAssemblyListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (usal USQLAssemblyList) uSQLAssemblyListPreparer(ctx context.Context) (*http.Request, error) {
	if usal.NextLink == nil || len(to.String(usal.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(usal.NextLink)))
}

// USQLAssemblyListPage contains a page of USQLAssemblyClr values.
type USQLAssemblyListPage struct {
	fn  func(context.Context, USQLAssemblyList) (USQLAssemblyList, error)
	ual USQLAssemblyList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *USQLAssemblyListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLAssemblyListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ual)
	if err != nil {
		return err
	}
	page.ual = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *USQLAssemblyListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page USQLAssemblyListPage) NotDone() bool {
	return !page.ual.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page USQLAssemblyListPage) Response() USQLAssemblyList {
	return page.ual
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page USQLAssemblyListPage) Values() []USQLAssemblyClr {
	if page.ual.IsEmpty() {
		return nil
	}
	return *page.ual.Value
}

// Creates a new instance of the USQLAssemblyListPage type.
func NewUSQLAssemblyListPage(getNextPage func(context.Context, USQLAssemblyList) (USQLAssemblyList, error)) USQLAssemblyListPage {
	return USQLAssemblyListPage{fn: getNextPage}
}

// USQLCredential a Data Lake Analytics catalog U-SQL credential item.
type USQLCredential struct {
	autorest.Response `json:"-"`
	// Name - the name of the credential.
	Name *string `json:"credentialName,omitempty"`
	// ComputeAccountName - the name of the Data Lake Analytics account.
	ComputeAccountName *string `json:"computeAccountName,omitempty"`
	// Version - the version of the catalog item.
	Version *uuid.UUID `json:"version,omitempty"`
}

// USQLCredentialList a Data Lake Analytics catalog U-SQL credential item list.
type USQLCredentialList struct {
	autorest.Response `json:"-"`
	// Value - the list of credentials in the database
	Value *[]USQLCredential `json:"value,omitempty"`
	// NextLink - the link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// USQLCredentialListIterator provides access to a complete listing of USQLCredential values.
type USQLCredentialListIterator struct {
	i    int
	page USQLCredentialListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *USQLCredentialListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLCredentialListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *USQLCredentialListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter USQLCredentialListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter USQLCredentialListIterator) Response() USQLCredentialList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter USQLCredentialListIterator) Value() USQLCredential {
	if !iter.page.NotDone() {
		return USQLCredential{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the USQLCredentialListIterator type.
func NewUSQLCredentialListIterator(page USQLCredentialListPage) USQLCredentialListIterator {
	return USQLCredentialListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (uscl USQLCredentialList) IsEmpty() bool {
	return uscl.Value == nil || len(*uscl.Value) == 0
}

// uSQLCredentialListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (uscl USQLCredentialList) uSQLCredentialListPreparer(ctx context.Context) (*http.Request, error) {
	if uscl.NextLink == nil || len(to.String(uscl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(uscl.NextLink)))
}

// USQLCredentialListPage contains a page of USQLCredential values.
type USQLCredentialListPage struct {
	fn  func(context.Context, USQLCredentialList) (USQLCredentialList, error)
	ucl USQLCredentialList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *USQLCredentialListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLCredentialListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ucl)
	if err != nil {
		return err
	}
	page.ucl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *USQLCredentialListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page USQLCredentialListPage) NotDone() bool {
	return !page.ucl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page USQLCredentialListPage) Response() USQLCredentialList {
	return page.ucl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page USQLCredentialListPage) Values() []USQLCredential {
	if page.ucl.IsEmpty() {
		return nil
	}
	return *page.ucl.Value
}

// Creates a new instance of the USQLCredentialListPage type.
func NewUSQLCredentialListPage(getNextPage func(context.Context, USQLCredentialList) (USQLCredentialList, error)) USQLCredentialListPage {
	return USQLCredentialListPage{fn: getNextPage}
}

// USQLDatabase a Data Lake Analytics catalog U-SQL database item.
type USQLDatabase struct {
	autorest.Response `json:"-"`
	// Name - the name of the database.
	Name *string `json:"databaseName,omitempty"`
	// ComputeAccountName - the name of the Data Lake Analytics account.
	ComputeAccountName *string `json:"computeAccountName,omitempty"`
	// Version - the version of the catalog item.
	Version *uuid.UUID `json:"version,omitempty"`
}

// USQLDatabaseList a Data Lake Analytics catalog U-SQL database item list.
type USQLDatabaseList struct {
	autorest.Response `json:"-"`
	// Value - the list of databases
	Value *[]USQLDatabase `json:"value,omitempty"`
	// NextLink - the link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// USQLDatabaseListIterator provides access to a complete listing of USQLDatabase values.
type USQLDatabaseListIterator struct {
	i    int
	page USQLDatabaseListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *USQLDatabaseListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLDatabaseListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *USQLDatabaseListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter USQLDatabaseListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter USQLDatabaseListIterator) Response() USQLDatabaseList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter USQLDatabaseListIterator) Value() USQLDatabase {
	if !iter.page.NotDone() {
		return USQLDatabase{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the USQLDatabaseListIterator type.
func NewUSQLDatabaseListIterator(page USQLDatabaseListPage) USQLDatabaseListIterator {
	return USQLDatabaseListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (usdl USQLDatabaseList) IsEmpty() bool {
	return usdl.Value == nil || len(*usdl.Value) == 0
}

// uSQLDatabaseListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (usdl USQLDatabaseList) uSQLDatabaseListPreparer(ctx context.Context) (*http.Request, error) {
	if usdl.NextLink == nil || len(to.String(usdl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(usdl.NextLink)))
}

// USQLDatabaseListPage contains a page of USQLDatabase values.
type USQLDatabaseListPage struct {
	fn  func(context.Context, USQLDatabaseList) (USQLDatabaseList, error)
	udl USQLDatabaseList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *USQLDatabaseListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLDatabaseListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.udl)
	if err != nil {
		return err
	}
	page.udl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *USQLDatabaseListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page USQLDatabaseListPage) NotDone() bool {
	return !page.udl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page USQLDatabaseListPage) Response() USQLDatabaseList {
	return page.udl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page USQLDatabaseListPage) Values() []USQLDatabase {
	if page.udl.IsEmpty() {
		return nil
	}
	return *page.udl.Value
}

// Creates a new instance of the USQLDatabaseListPage type.
func NewUSQLDatabaseListPage(getNextPage func(context.Context, USQLDatabaseList) (USQLDatabaseList, error)) USQLDatabaseListPage {
	return USQLDatabaseListPage{fn: getNextPage}
}

// USQLDirectedColumn a Data Lake Analytics catalog U-SQL directed column item.
type USQLDirectedColumn struct {
	// Name - the name of the index in the table.
	Name *string `json:"name,omitempty"`
	// Descending - the switch indicating if the index is descending or not.
	Descending *bool `json:"descending,omitempty"`
}

// USQLDistributionInfo a Data Lake Analytics catalog U-SQL distribution information object.
type USQLDistributionInfo struct {
	// Type - the type of this distribution.
	Type *int32 `json:"type,omitempty"`
	// Keys - the list of directed columns in the distribution
	Keys *[]USQLDirectedColumn `json:"keys,omitempty"`
	// Count - the count of indices using this distribution.
	Count *int32 `json:"count,omitempty"`
	// DynamicCount - the dynamic count of indices using this distribution.
	DynamicCount *int32 `json:"dynamicCount,omitempty"`
}

// USQLExternalDataSource a Data Lake Analytics catalog U-SQL external datasource item.
type USQLExternalDataSource struct {
	autorest.Response `json:"-"`
	// DatabaseName - the name of the database.
	DatabaseName *string `json:"databaseName,omitempty"`
	// Name - the name of the external data source.
	Name *string `json:"externalDataSourceName,omitempty"`
	// Provider - the name of the provider for the external data source.
	Provider *string `json:"provider,omitempty"`
	// ProviderString - the name of the provider string for the external data source.
	ProviderString *string `json:"providerString,omitempty"`
	// PushdownTypes - the list of types to push down from the external data source.
	PushdownTypes *[]string `json:"pushdownTypes,omitempty"`
	// ComputeAccountName - the name of the Data Lake Analytics account.
	ComputeAccountName *string `json:"computeAccountName,omitempty"`
	// Version - the version of the catalog item.
	Version *uuid.UUID `json:"version,omitempty"`
}

// USQLExternalDataSourceList a Data Lake Analytics catalog U-SQL external datasource item list.
type USQLExternalDataSourceList struct {
	autorest.Response `json:"-"`
	// Value - the list of external data sources in the database
	Value *[]USQLExternalDataSource `json:"value,omitempty"`
	// NextLink - the link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// USQLExternalDataSourceListIterator provides access to a complete listing of USQLExternalDataSource
// values.
type USQLExternalDataSourceListIterator struct {
	i    int
	page USQLExternalDataSourceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *USQLExternalDataSourceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLExternalDataSourceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *USQLExternalDataSourceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter USQLExternalDataSourceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter USQLExternalDataSourceListIterator) Response() USQLExternalDataSourceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter USQLExternalDataSourceListIterator) Value() USQLExternalDataSource {
	if !iter.page.NotDone() {
		return USQLExternalDataSource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the USQLExternalDataSourceListIterator type.
func NewUSQLExternalDataSourceListIterator(page USQLExternalDataSourceListPage) USQLExternalDataSourceListIterator {
	return USQLExternalDataSourceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (usedsl USQLExternalDataSourceList) IsEmpty() bool {
	return usedsl.Value == nil || len(*usedsl.Value) == 0
}

// uSQLExternalDataSourceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (usedsl USQLExternalDataSourceList) uSQLExternalDataSourceListPreparer(ctx context.Context) (*http.Request, error) {
	if usedsl.NextLink == nil || len(to.String(usedsl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(usedsl.NextLink)))
}

// USQLExternalDataSourceListPage contains a page of USQLExternalDataSource values.
type USQLExternalDataSourceListPage struct {
	fn    func(context.Context, USQLExternalDataSourceList) (USQLExternalDataSourceList, error)
	uedsl USQLExternalDataSourceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *USQLExternalDataSourceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLExternalDataSourceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.uedsl)
	if err != nil {
		return err
	}
	page.uedsl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *USQLExternalDataSourceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page USQLExternalDataSourceListPage) NotDone() bool {
	return !page.uedsl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page USQLExternalDataSourceListPage) Response() USQLExternalDataSourceList {
	return page.uedsl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page USQLExternalDataSourceListPage) Values() []USQLExternalDataSource {
	if page.uedsl.IsEmpty() {
		return nil
	}
	return *page.uedsl.Value
}

// Creates a new instance of the USQLExternalDataSourceListPage type.
func NewUSQLExternalDataSourceListPage(getNextPage func(context.Context, USQLExternalDataSourceList) (USQLExternalDataSourceList, error)) USQLExternalDataSourceListPage {
	return USQLExternalDataSourceListPage{fn: getNextPage}
}

// USQLIndex a Data Lake Analytics catalog U-SQL table index item.
type USQLIndex struct {
	// Name - the name of the index in the table.
	Name *string `json:"name,omitempty"`
	// IndexKeys - the list of directed columns in the index
	IndexKeys *[]USQLDirectedColumn `json:"indexKeys,omitempty"`
	// Columns - the list of columns in the index
	Columns *[]string `json:"columns,omitempty"`
	// DistributionInfo - the distributions info of the index
	DistributionInfo *USQLDistributionInfo `json:"distributionInfo,omitempty"`
	// PartitionFunction - partition function ID for the index.
	PartitionFunction *uuid.UUID `json:"partitionFunction,omitempty"`
	// PartitionKeyList - the list of partition keys in the index
	PartitionKeyList *[]string `json:"partitionKeyList,omitempty"`
	// StreamNames - the list of full paths to the streams that contain this index in the DataLake account.
	StreamNames *[]string `json:"streamNames,omitempty"`
	// IsColumnstore - the switch indicating if this index is a columnstore index.
	IsColumnstore *bool `json:"isColumnstore,omitempty"`
	// IndexID - the ID of this index within the table.
	IndexID *int32 `json:"indexId,omitempty"`
	// IsUnique - the switch indicating if this index is a unique index.
	IsUnique *bool `json:"isUnique,omitempty"`
}

// USQLPackage a Data Lake Analytics catalog U-SQL package item.
type USQLPackage struct {
	autorest.Response `json:"-"`
	// DatabaseName - the name of the database containing the package.
	DatabaseName *string `json:"databaseName,omitempty"`
	// SchemaName - the name of the schema associated with this package and database.
	SchemaName *string `json:"schemaName,omitempty"`
	// Name - the name of the package.
	Name *string `json:"packageName,omitempty"`
	// Definition - the definition of the package.
	Definition *string `json:"definition,omitempty"`
	// ComputeAccountName - the name of the Data Lake Analytics account.
	ComputeAccountName *string `json:"computeAccountName,omitempty"`
	// Version - the version of the catalog item.
	Version *uuid.UUID `json:"version,omitempty"`
}

// USQLPackageList a Data Lake Analytics catalog U-SQL package item list.
type USQLPackageList struct {
	autorest.Response `json:"-"`
	// Value - the list of packages in the database and schema combination
	Value *[]USQLPackage `json:"value,omitempty"`
	// NextLink - the link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// USQLPackageListIterator provides access to a complete listing of USQLPackage values.
type USQLPackageListIterator struct {
	i    int
	page USQLPackageListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *USQLPackageListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLPackageListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *USQLPackageListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter USQLPackageListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter USQLPackageListIterator) Response() USQLPackageList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter USQLPackageListIterator) Value() USQLPackage {
	if !iter.page.NotDone() {
		return USQLPackage{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the USQLPackageListIterator type.
func NewUSQLPackageListIterator(page USQLPackageListPage) USQLPackageListIterator {
	return USQLPackageListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (uspl USQLPackageList) IsEmpty() bool {
	return uspl.Value == nil || len(*uspl.Value) == 0
}

// uSQLPackageListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (uspl USQLPackageList) uSQLPackageListPreparer(ctx context.Context) (*http.Request, error) {
	if uspl.NextLink == nil || len(to.String(uspl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(uspl.NextLink)))
}

// USQLPackageListPage contains a page of USQLPackage values.
type USQLPackageListPage struct {
	fn  func(context.Context, USQLPackageList) (USQLPackageList, error)
	upl USQLPackageList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *USQLPackageListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLPackageListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.upl)
	if err != nil {
		return err
	}
	page.upl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *USQLPackageListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page USQLPackageListPage) NotDone() bool {
	return !page.upl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page USQLPackageListPage) Response() USQLPackageList {
	return page.upl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page USQLPackageListPage) Values() []USQLPackage {
	if page.upl.IsEmpty() {
		return nil
	}
	return *page.upl.Value
}

// Creates a new instance of the USQLPackageListPage type.
func NewUSQLPackageListPage(getNextPage func(context.Context, USQLPackageList) (USQLPackageList, error)) USQLPackageListPage {
	return USQLPackageListPage{fn: getNextPage}
}

// USQLProcedure a Data Lake Analytics catalog U-SQL procedure item.
type USQLProcedure struct {
	autorest.Response `json:"-"`
	// DatabaseName - the name of the database.
	DatabaseName *string `json:"databaseName,omitempty"`
	// SchemaName - the name of the schema associated with this procedure and database.
	SchemaName *string `json:"schemaName,omitempty"`
	// Name - the name of the procedure.
	Name *string `json:"procName,omitempty"`
	// Definition - the defined query of the procedure.
	Definition *string `json:"definition,omitempty"`
	// ComputeAccountName - the name of the Data Lake Analytics account.
	ComputeAccountName *string `json:"computeAccountName,omitempty"`
	// Version - the version of the catalog item.
	Version *uuid.UUID `json:"version,omitempty"`
}

// USQLProcedureList a Data Lake Analytics catalog U-SQL procedure item list.
type USQLProcedureList struct {
	autorest.Response `json:"-"`
	// Value - the list of procedure in the database and schema combination
	Value *[]USQLProcedure `json:"value,omitempty"`
	// NextLink - the link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// USQLProcedureListIterator provides access to a complete listing of USQLProcedure values.
type USQLProcedureListIterator struct {
	i    int
	page USQLProcedureListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *USQLProcedureListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLProcedureListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *USQLProcedureListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter USQLProcedureListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter USQLProcedureListIterator) Response() USQLProcedureList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter USQLProcedureListIterator) Value() USQLProcedure {
	if !iter.page.NotDone() {
		return USQLProcedure{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the USQLProcedureListIterator type.
func NewUSQLProcedureListIterator(page USQLProcedureListPage) USQLProcedureListIterator {
	return USQLProcedureListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (uspl USQLProcedureList) IsEmpty() bool {
	return uspl.Value == nil || len(*uspl.Value) == 0
}

// uSQLProcedureListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (uspl USQLProcedureList) uSQLProcedureListPreparer(ctx context.Context) (*http.Request, error) {
	if uspl.NextLink == nil || len(to.String(uspl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(uspl.NextLink)))
}

// USQLProcedureListPage contains a page of USQLProcedure values.
type USQLProcedureListPage struct {
	fn  func(context.Context, USQLProcedureList) (USQLProcedureList, error)
	upl USQLProcedureList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *USQLProcedureListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLProcedureListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.upl)
	if err != nil {
		return err
	}
	page.upl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *USQLProcedureListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page USQLProcedureListPage) NotDone() bool {
	return !page.upl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page USQLProcedureListPage) Response() USQLProcedureList {
	return page.upl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page USQLProcedureListPage) Values() []USQLProcedure {
	if page.upl.IsEmpty() {
		return nil
	}
	return *page.upl.Value
}

// Creates a new instance of the USQLProcedureListPage type.
func NewUSQLProcedureListPage(getNextPage func(context.Context, USQLProcedureList) (USQLProcedureList, error)) USQLProcedureListPage {
	return USQLProcedureListPage{fn: getNextPage}
}

// USQLSchema a Data Lake Analytics catalog U-SQL schema item.
type USQLSchema struct {
	autorest.Response `json:"-"`
	// DatabaseName - the name of the database.
	DatabaseName *string `json:"databaseName,omitempty"`
	// Name - the name of the schema.
	Name *string `json:"schemaName,omitempty"`
	// ComputeAccountName - the name of the Data Lake Analytics account.
	ComputeAccountName *string `json:"computeAccountName,omitempty"`
	// Version - the version of the catalog item.
	Version *uuid.UUID `json:"version,omitempty"`
}

// USQLSchemaList a Data Lake Analytics catalog U-SQL schema item list.
type USQLSchemaList struct {
	autorest.Response `json:"-"`
	// Value - the list of schemas in the database
	Value *[]USQLSchema `json:"value,omitempty"`
	// NextLink - the link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// USQLSchemaListIterator provides access to a complete listing of USQLSchema values.
type USQLSchemaListIterator struct {
	i    int
	page USQLSchemaListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *USQLSchemaListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLSchemaListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *USQLSchemaListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter USQLSchemaListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter USQLSchemaListIterator) Response() USQLSchemaList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter USQLSchemaListIterator) Value() USQLSchema {
	if !iter.page.NotDone() {
		return USQLSchema{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the USQLSchemaListIterator type.
func NewUSQLSchemaListIterator(page USQLSchemaListPage) USQLSchemaListIterator {
	return USQLSchemaListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ussl USQLSchemaList) IsEmpty() bool {
	return ussl.Value == nil || len(*ussl.Value) == 0
}

// uSQLSchemaListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ussl USQLSchemaList) uSQLSchemaListPreparer(ctx context.Context) (*http.Request, error) {
	if ussl.NextLink == nil || len(to.String(ussl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ussl.NextLink)))
}

// USQLSchemaListPage contains a page of USQLSchema values.
type USQLSchemaListPage struct {
	fn  func(context.Context, USQLSchemaList) (USQLSchemaList, error)
	usl USQLSchemaList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *USQLSchemaListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLSchemaListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.usl)
	if err != nil {
		return err
	}
	page.usl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *USQLSchemaListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page USQLSchemaListPage) NotDone() bool {
	return !page.usl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page USQLSchemaListPage) Response() USQLSchemaList {
	return page.usl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page USQLSchemaListPage) Values() []USQLSchema {
	if page.usl.IsEmpty() {
		return nil
	}
	return *page.usl.Value
}

// Creates a new instance of the USQLSchemaListPage type.
func NewUSQLSchemaListPage(getNextPage func(context.Context, USQLSchemaList) (USQLSchemaList, error)) USQLSchemaListPage {
	return USQLSchemaListPage{fn: getNextPage}
}

// USQLSecret a Data Lake Analytics catalog U-SQL secret item.
type USQLSecret struct {
	autorest.Response `json:"-"`
	// DatabaseName - the name of the database.
	DatabaseName *string `json:"databaseName,omitempty"`
	// Name - the name of the secret.
	Name *string `json:"secretName,omitempty"`
	// CreationTime - the creation time of the credential object. This is the only information returned about a secret from a GET.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// URI - the URI identifier for the secret in the format <hostname>:<port>
	URI *string `json:"uri,omitempty"`
	// Password - the password for the secret to pass in
	Password *string `json:"password,omitempty"`
	// ComputeAccountName - the name of the Data Lake Analytics account.
	ComputeAccountName *string `json:"computeAccountName,omitempty"`
	// Version - the version of the catalog item.
	Version *uuid.UUID `json:"version,omitempty"`
}

// USQLTable a Data Lake Analytics catalog U-SQL table item.
type USQLTable struct {
	autorest.Response `json:"-"`
	// DatabaseName - the name of the database.
	DatabaseName *string `json:"databaseName,omitempty"`
	// SchemaName - the name of the schema associated with this table and database.
	SchemaName *string `json:"schemaName,omitempty"`
	// Name - the name of the table.
	Name *string `json:"tableName,omitempty"`
	// ColumnList - the list of columns in this table
	ColumnList *[]USQLTableColumn `json:"columnList,omitempty"`
	// IndexList - the list of indices in this table
	IndexList *[]USQLIndex `json:"indexList,omitempty"`
	// PartitionKeyList - the list of partition keys in the table
	PartitionKeyList *[]string `json:"partitionKeyList,omitempty"`
	// ExternalTable - the external table associated with the table.
	ExternalTable *ExternalTable `json:"externalTable,omitempty"`
	// DistributionInfo - the distributions info of the table
	DistributionInfo *USQLDistributionInfo `json:"distributionInfo,omitempty"`
	// ComputeAccountName - the name of the Data Lake Analytics account.
	ComputeAccountName *string `json:"computeAccountName,omitempty"`
	// Version - the version of the catalog item.
	Version *uuid.UUID `json:"version,omitempty"`
}

// USQLTableColumn a Data Lake Analytics catalog U-SQL table column item.
type USQLTableColumn struct {
	// Name - the name of the column in the table.
	Name *string `json:"name,omitempty"`
	// Type - the object type of the specified column (such as System.String).
	Type *string `json:"type,omitempty"`
}

// USQLTableFragment a Data Lake Analytics catalog U-SQL table fragment item.
type USQLTableFragment struct {
	// ParentID - the parent object Id of the table fragment. The parent could be a table or table partition.
	ParentID *uuid.UUID `json:"parentId,omitempty"`
	// FragmentID - the version of the catalog item.
	FragmentID *uuid.UUID `json:"fragmentId,omitempty"`
	// IndexID - the ordinal of the index which contains the table fragment.
	IndexID *int32 `json:"indexId,omitempty"`
	// Size - the data size of the table fragment in bytes.
	Size *int64 `json:"size,omitempty"`
	// RowCount - the number of rows in the table fragment.
	RowCount *int64 `json:"rowCount,omitempty"`
	// CreateDate - the creation time of the table fragment.
	CreateDate *date.Time `json:"createDate,omitempty"`
}

// USQLTableFragmentList a Data Lake Analytics catalog U-SQL table fragment item list.
type USQLTableFragmentList struct {
	autorest.Response `json:"-"`
	// Value - the list of table fragments in the database, schema and table combination
	Value *[]USQLTableFragment `json:"value,omitempty"`
	// NextLink - the link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// USQLTableFragmentListIterator provides access to a complete listing of USQLTableFragment values.
type USQLTableFragmentListIterator struct {
	i    int
	page USQLTableFragmentListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *USQLTableFragmentListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLTableFragmentListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *USQLTableFragmentListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter USQLTableFragmentListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter USQLTableFragmentListIterator) Response() USQLTableFragmentList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter USQLTableFragmentListIterator) Value() USQLTableFragment {
	if !iter.page.NotDone() {
		return USQLTableFragment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the USQLTableFragmentListIterator type.
func NewUSQLTableFragmentListIterator(page USQLTableFragmentListPage) USQLTableFragmentListIterator {
	return USQLTableFragmentListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ustfl USQLTableFragmentList) IsEmpty() bool {
	return ustfl.Value == nil || len(*ustfl.Value) == 0
}

// uSQLTableFragmentListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ustfl USQLTableFragmentList) uSQLTableFragmentListPreparer(ctx context.Context) (*http.Request, error) {
	if ustfl.NextLink == nil || len(to.String(ustfl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ustfl.NextLink)))
}

// USQLTableFragmentListPage contains a page of USQLTableFragment values.
type USQLTableFragmentListPage struct {
	fn   func(context.Context, USQLTableFragmentList) (USQLTableFragmentList, error)
	utfl USQLTableFragmentList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *USQLTableFragmentListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLTableFragmentListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.utfl)
	if err != nil {
		return err
	}
	page.utfl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *USQLTableFragmentListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page USQLTableFragmentListPage) NotDone() bool {
	return !page.utfl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page USQLTableFragmentListPage) Response() USQLTableFragmentList {
	return page.utfl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page USQLTableFragmentListPage) Values() []USQLTableFragment {
	if page.utfl.IsEmpty() {
		return nil
	}
	return *page.utfl.Value
}

// Creates a new instance of the USQLTableFragmentListPage type.
func NewUSQLTableFragmentListPage(getNextPage func(context.Context, USQLTableFragmentList) (USQLTableFragmentList, error)) USQLTableFragmentListPage {
	return USQLTableFragmentListPage{fn: getNextPage}
}

// USQLTableList a Data Lake Analytics catalog U-SQL table item list.
type USQLTableList struct {
	autorest.Response `json:"-"`
	// Value - the list of tables in the database and schema combination
	Value *[]USQLTable `json:"value,omitempty"`
	// NextLink - the link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// USQLTableListIterator provides access to a complete listing of USQLTable values.
type USQLTableListIterator struct {
	i    int
	page USQLTableListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *USQLTableListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLTableListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *USQLTableListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter USQLTableListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter USQLTableListIterator) Response() USQLTableList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter USQLTableListIterator) Value() USQLTable {
	if !iter.page.NotDone() {
		return USQLTable{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the USQLTableListIterator type.
func NewUSQLTableListIterator(page USQLTableListPage) USQLTableListIterator {
	return USQLTableListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ustl USQLTableList) IsEmpty() bool {
	return ustl.Value == nil || len(*ustl.Value) == 0
}

// uSQLTableListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ustl USQLTableList) uSQLTableListPreparer(ctx context.Context) (*http.Request, error) {
	if ustl.NextLink == nil || len(to.String(ustl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ustl.NextLink)))
}

// USQLTableListPage contains a page of USQLTable values.
type USQLTableListPage struct {
	fn  func(context.Context, USQLTableList) (USQLTableList, error)
	utl USQLTableList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *USQLTableListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLTableListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.utl)
	if err != nil {
		return err
	}
	page.utl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *USQLTableListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page USQLTableListPage) NotDone() bool {
	return !page.utl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page USQLTableListPage) Response() USQLTableList {
	return page.utl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page USQLTableListPage) Values() []USQLTable {
	if page.utl.IsEmpty() {
		return nil
	}
	return *page.utl.Value
}

// Creates a new instance of the USQLTableListPage type.
func NewUSQLTableListPage(getNextPage func(context.Context, USQLTableList) (USQLTableList, error)) USQLTableListPage {
	return USQLTableListPage{fn: getNextPage}
}

// USQLTablePartition a Data Lake Analytics catalog U-SQL table partition item.
type USQLTablePartition struct {
	autorest.Response `json:"-"`
	// DatabaseName - the name of the database.
	DatabaseName *string `json:"databaseName,omitempty"`
	// SchemaName - the name of the schema associated with this table partition and database.
	SchemaName *string `json:"schemaName,omitempty"`
	// Name - the name of the table partition.
	Name *string `json:"partitionName,omitempty"`
	// ParentName - the Ddl object of the partition's parent.
	ParentName *DdlName `json:"parentName,omitempty"`
	// IndexID - the index ID for this partition.
	IndexID *int32 `json:"indexId,omitempty"`
	// Label - the list of labels associated with this partition.
	Label *[]string `json:"label,omitempty"`
	// CreateDate - the creation time of the partition
	CreateDate *date.Time `json:"createDate,omitempty"`
	// ComputeAccountName - the name of the Data Lake Analytics account.
	ComputeAccountName *string `json:"computeAccountName,omitempty"`
	// Version - the version of the catalog item.
	Version *uuid.UUID `json:"version,omitempty"`
}

// USQLTablePartitionList a Data Lake Analytics catalog U-SQL table partition item list.
type USQLTablePartitionList struct {
	autorest.Response `json:"-"`
	// Value - the list of table partitions in the database, schema and table combination
	Value *[]USQLTablePartition `json:"value,omitempty"`
	// NextLink - the link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// USQLTablePartitionListIterator provides access to a complete listing of USQLTablePartition values.
type USQLTablePartitionListIterator struct {
	i    int
	page USQLTablePartitionListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *USQLTablePartitionListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLTablePartitionListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *USQLTablePartitionListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter USQLTablePartitionListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter USQLTablePartitionListIterator) Response() USQLTablePartitionList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter USQLTablePartitionListIterator) Value() USQLTablePartition {
	if !iter.page.NotDone() {
		return USQLTablePartition{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the USQLTablePartitionListIterator type.
func NewUSQLTablePartitionListIterator(page USQLTablePartitionListPage) USQLTablePartitionListIterator {
	return USQLTablePartitionListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ustpl USQLTablePartitionList) IsEmpty() bool {
	return ustpl.Value == nil || len(*ustpl.Value) == 0
}

// uSQLTablePartitionListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ustpl USQLTablePartitionList) uSQLTablePartitionListPreparer(ctx context.Context) (*http.Request, error) {
	if ustpl.NextLink == nil || len(to.String(ustpl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ustpl.NextLink)))
}

// USQLTablePartitionListPage contains a page of USQLTablePartition values.
type USQLTablePartitionListPage struct {
	fn   func(context.Context, USQLTablePartitionList) (USQLTablePartitionList, error)
	utpl USQLTablePartitionList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *USQLTablePartitionListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLTablePartitionListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.utpl)
	if err != nil {
		return err
	}
	page.utpl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *USQLTablePartitionListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page USQLTablePartitionListPage) NotDone() bool {
	return !page.utpl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page USQLTablePartitionListPage) Response() USQLTablePartitionList {
	return page.utpl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page USQLTablePartitionListPage) Values() []USQLTablePartition {
	if page.utpl.IsEmpty() {
		return nil
	}
	return *page.utpl.Value
}

// Creates a new instance of the USQLTablePartitionListPage type.
func NewUSQLTablePartitionListPage(getNextPage func(context.Context, USQLTablePartitionList) (USQLTablePartitionList, error)) USQLTablePartitionListPage {
	return USQLTablePartitionListPage{fn: getNextPage}
}

// USQLTablePreview a Data Lake Analytics catalog table or partition preview rows item.
type USQLTablePreview struct {
	autorest.Response `json:"-"`
	// TotalRowCount - the total number of rows in the table or partition.
	TotalRowCount *int64 `json:"totalRowCount,omitempty"`
	// TotalColumnCount - the total number of columns in the table or partition.
	TotalColumnCount *int64 `json:"totalColumnCount,omitempty"`
	// Rows - the rows of the table or partition preview, where each row is an array of string representations the row's values. Note: Byte arrays will appear as base-64 encoded values, SqlMap and SqlArray objects will appear as escaped JSON objects, and DateTime objects will appear as ISO formatted UTC date-times.
	Rows *[][]string `json:"rows,omitempty"`
	// Truncated - true if the amount of data in the response is less than expected due to the preview operation's size limitations. This can occur if the requested rows or row counts are too large.
	Truncated *bool `json:"truncated,omitempty"`
	// Schema - the schema of the table or partition.
	Schema *[]USQLTableColumn `json:"schema,omitempty"`
}

// USQLTableStatistics a Data Lake Analytics catalog U-SQL table statistics item.
type USQLTableStatistics struct {
	autorest.Response `json:"-"`
	// DatabaseName - the name of the database.
	DatabaseName *string `json:"databaseName,omitempty"`
	// SchemaName - the name of the schema associated with this table and database.
	SchemaName *string `json:"schemaName,omitempty"`
	// TableName - the name of the table.
	TableName *string `json:"tableName,omitempty"`
	// Name - the name of the table statistics.
	Name *string `json:"statisticsName,omitempty"`
	// UserStatName - the name of the user statistics.
	UserStatName *string `json:"userStatName,omitempty"`
	// StatDataPath - the path to the statistics data.
	StatDataPath *string `json:"statDataPath,omitempty"`
	// CreateTime - the creation time of the statistics.
	CreateTime *date.Time `json:"createTime,omitempty"`
	// UpdateTime - the last time the statistics were updated.
	UpdateTime *date.Time `json:"updateTime,omitempty"`
	// IsUserCreated - the switch indicating if these statistics are user created.
	IsUserCreated *bool `json:"isUserCreated,omitempty"`
	// IsAutoCreated - the switch indicating if these statistics are automatically created.
	IsAutoCreated *bool `json:"isAutoCreated,omitempty"`
	// HasFilter - the switch indicating if these statistics have a filter.
	HasFilter *bool `json:"hasFilter,omitempty"`
	// FilterDefinition - the filter definition for the statistics.
	FilterDefinition *string `json:"filterDefinition,omitempty"`
	// ColNames - the list of column names associated with these statistics.
	ColNames *[]string `json:"colNames,omitempty"`
	// ComputeAccountName - the name of the Data Lake Analytics account.
	ComputeAccountName *string `json:"computeAccountName,omitempty"`
	// Version - the version of the catalog item.
	Version *uuid.UUID `json:"version,omitempty"`
}

// USQLTableStatisticsList a Data Lake Analytics catalog U-SQL table statistics item list.
type USQLTableStatisticsList struct {
	autorest.Response `json:"-"`
	// Value - the list of table statistics in the database, schema and table combination
	Value *[]USQLTableStatistics `json:"value,omitempty"`
	// NextLink - the link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// USQLTableStatisticsListIterator provides access to a complete listing of USQLTableStatistics values.
type USQLTableStatisticsListIterator struct {
	i    int
	page USQLTableStatisticsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *USQLTableStatisticsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLTableStatisticsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *USQLTableStatisticsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter USQLTableStatisticsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter USQLTableStatisticsListIterator) Response() USQLTableStatisticsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter USQLTableStatisticsListIterator) Value() USQLTableStatistics {
	if !iter.page.NotDone() {
		return USQLTableStatistics{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the USQLTableStatisticsListIterator type.
func NewUSQLTableStatisticsListIterator(page USQLTableStatisticsListPage) USQLTableStatisticsListIterator {
	return USQLTableStatisticsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ustsl USQLTableStatisticsList) IsEmpty() bool {
	return ustsl.Value == nil || len(*ustsl.Value) == 0
}

// uSQLTableStatisticsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ustsl USQLTableStatisticsList) uSQLTableStatisticsListPreparer(ctx context.Context) (*http.Request, error) {
	if ustsl.NextLink == nil || len(to.String(ustsl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ustsl.NextLink)))
}

// USQLTableStatisticsListPage contains a page of USQLTableStatistics values.
type USQLTableStatisticsListPage struct {
	fn   func(context.Context, USQLTableStatisticsList) (USQLTableStatisticsList, error)
	utsl USQLTableStatisticsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *USQLTableStatisticsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLTableStatisticsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.utsl)
	if err != nil {
		return err
	}
	page.utsl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *USQLTableStatisticsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page USQLTableStatisticsListPage) NotDone() bool {
	return !page.utsl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page USQLTableStatisticsListPage) Response() USQLTableStatisticsList {
	return page.utsl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page USQLTableStatisticsListPage) Values() []USQLTableStatistics {
	if page.utsl.IsEmpty() {
		return nil
	}
	return *page.utsl.Value
}

// Creates a new instance of the USQLTableStatisticsListPage type.
func NewUSQLTableStatisticsListPage(getNextPage func(context.Context, USQLTableStatisticsList) (USQLTableStatisticsList, error)) USQLTableStatisticsListPage {
	return USQLTableStatisticsListPage{fn: getNextPage}
}

// USQLTableType a Data Lake Analytics catalog U-SQL table type item.
type USQLTableType struct {
	autorest.Response `json:"-"`
	// Columns - the type field information associated with this table type.
	Columns *[]TypeFieldInfo `json:"columns,omitempty"`
	// DatabaseName - the name of the database.
	DatabaseName *string `json:"databaseName,omitempty"`
	// SchemaName - the name of the schema associated with this table and database.
	SchemaName *string `json:"schemaName,omitempty"`
	// Name - the name of type for this type.
	Name *string `json:"typeName,omitempty"`
	// TypeFamily - the type family for this type.
	TypeFamily *string `json:"typeFamily,omitempty"`
	// CSharpName - the C# name for this type.
	CSharpName *string `json:"cSharpName,omitempty"`
	// FullCSharpName - the fully qualified C# name for this type.
	FullCSharpName *string `json:"fullCSharpName,omitempty"`
	// SystemTypeID - the system type ID for this type.
	SystemTypeID *int32 `json:"systemTypeId,omitempty"`
	// UserTypeID - the user type ID for this type.
	UserTypeID *int32 `json:"userTypeId,omitempty"`
	// SchemaID - the schema ID for this type.
	SchemaID *int32 `json:"schemaId,omitempty"`
	// PrincipalID - the principal ID for this type.
	PrincipalID *int32 `json:"principalId,omitempty"`
	// IsNullable - the the switch indicating if this type is nullable.
	IsNullable *bool `json:"isNullable,omitempty"`
	// IsUserDefined - the the switch indicating if this type is user defined.
	IsUserDefined *bool `json:"isUserDefined,omitempty"`
	// IsAssemblyType - the the switch indicating if this type is an assembly type.
	IsAssemblyType *bool `json:"isAssemblyType,omitempty"`
	// IsTableType - the the switch indicating if this type is a table type.
	IsTableType *bool `json:"isTableType,omitempty"`
	// IsComplexType - the the switch indicating if this type is a complex type.
	IsComplexType *bool `json:"isComplexType,omitempty"`
	// ComputeAccountName - the name of the Data Lake Analytics account.
	ComputeAccountName *string `json:"computeAccountName,omitempty"`
	// Version - the version of the catalog item.
	Version *uuid.UUID `json:"version,omitempty"`
}

// USQLTableTypeList a Data Lake Analytics catalog U-SQL table type item list.
type USQLTableTypeList struct {
	autorest.Response `json:"-"`
	// Value - the list of table types in the database and schema combination
	Value *[]USQLTableType `json:"value,omitempty"`
	// NextLink - the link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// USQLTableTypeListIterator provides access to a complete listing of USQLTableType values.
type USQLTableTypeListIterator struct {
	i    int
	page USQLTableTypeListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *USQLTableTypeListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLTableTypeListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *USQLTableTypeListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter USQLTableTypeListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter USQLTableTypeListIterator) Response() USQLTableTypeList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter USQLTableTypeListIterator) Value() USQLTableType {
	if !iter.page.NotDone() {
		return USQLTableType{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the USQLTableTypeListIterator type.
func NewUSQLTableTypeListIterator(page USQLTableTypeListPage) USQLTableTypeListIterator {
	return USQLTableTypeListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (usttl USQLTableTypeList) IsEmpty() bool {
	return usttl.Value == nil || len(*usttl.Value) == 0
}

// uSQLTableTypeListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (usttl USQLTableTypeList) uSQLTableTypeListPreparer(ctx context.Context) (*http.Request, error) {
	if usttl.NextLink == nil || len(to.String(usttl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(usttl.NextLink)))
}

// USQLTableTypeListPage contains a page of USQLTableType values.
type USQLTableTypeListPage struct {
	fn   func(context.Context, USQLTableTypeList) (USQLTableTypeList, error)
	uttl USQLTableTypeList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *USQLTableTypeListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLTableTypeListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.uttl)
	if err != nil {
		return err
	}
	page.uttl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *USQLTableTypeListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page USQLTableTypeListPage) NotDone() bool {
	return !page.uttl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page USQLTableTypeListPage) Response() USQLTableTypeList {
	return page.uttl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page USQLTableTypeListPage) Values() []USQLTableType {
	if page.uttl.IsEmpty() {
		return nil
	}
	return *page.uttl.Value
}

// Creates a new instance of the USQLTableTypeListPage type.
func NewUSQLTableTypeListPage(getNextPage func(context.Context, USQLTableTypeList) (USQLTableTypeList, error)) USQLTableTypeListPage {
	return USQLTableTypeListPage{fn: getNextPage}
}

// USQLTableValuedFunction a Data Lake Analytics catalog U-SQL table valued function item.
type USQLTableValuedFunction struct {
	autorest.Response `json:"-"`
	// DatabaseName - the name of the database.
	DatabaseName *string `json:"databaseName,omitempty"`
	// SchemaName - the name of the schema associated with this database.
	SchemaName *string `json:"schemaName,omitempty"`
	// Name - the name of the table valued function.
	Name *string `json:"tvfName,omitempty"`
	// Definition - the definition of the table valued function.
	Definition *string `json:"definition,omitempty"`
	// ComputeAccountName - the name of the Data Lake Analytics account.
	ComputeAccountName *string `json:"computeAccountName,omitempty"`
	// Version - the version of the catalog item.
	Version *uuid.UUID `json:"version,omitempty"`
}

// USQLTableValuedFunctionList a Data Lake Analytics catalog U-SQL table valued function item list.
type USQLTableValuedFunctionList struct {
	autorest.Response `json:"-"`
	// Value - the list of table valued functions in the database and schema combination
	Value *[]USQLTableValuedFunction `json:"value,omitempty"`
	// NextLink - the link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// USQLTableValuedFunctionListIterator provides access to a complete listing of USQLTableValuedFunction
// values.
type USQLTableValuedFunctionListIterator struct {
	i    int
	page USQLTableValuedFunctionListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *USQLTableValuedFunctionListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLTableValuedFunctionListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *USQLTableValuedFunctionListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter USQLTableValuedFunctionListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter USQLTableValuedFunctionListIterator) Response() USQLTableValuedFunctionList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter USQLTableValuedFunctionListIterator) Value() USQLTableValuedFunction {
	if !iter.page.NotDone() {
		return USQLTableValuedFunction{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the USQLTableValuedFunctionListIterator type.
func NewUSQLTableValuedFunctionListIterator(page USQLTableValuedFunctionListPage) USQLTableValuedFunctionListIterator {
	return USQLTableValuedFunctionListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ustvfl USQLTableValuedFunctionList) IsEmpty() bool {
	return ustvfl.Value == nil || len(*ustvfl.Value) == 0
}

// uSQLTableValuedFunctionListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ustvfl USQLTableValuedFunctionList) uSQLTableValuedFunctionListPreparer(ctx context.Context) (*http.Request, error) {
	if ustvfl.NextLink == nil || len(to.String(ustvfl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ustvfl.NextLink)))
}

// USQLTableValuedFunctionListPage contains a page of USQLTableValuedFunction values.
type USQLTableValuedFunctionListPage struct {
	fn    func(context.Context, USQLTableValuedFunctionList) (USQLTableValuedFunctionList, error)
	utvfl USQLTableValuedFunctionList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *USQLTableValuedFunctionListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLTableValuedFunctionListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.utvfl)
	if err != nil {
		return err
	}
	page.utvfl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *USQLTableValuedFunctionListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page USQLTableValuedFunctionListPage) NotDone() bool {
	return !page.utvfl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page USQLTableValuedFunctionListPage) Response() USQLTableValuedFunctionList {
	return page.utvfl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page USQLTableValuedFunctionListPage) Values() []USQLTableValuedFunction {
	if page.utvfl.IsEmpty() {
		return nil
	}
	return *page.utvfl.Value
}

// Creates a new instance of the USQLTableValuedFunctionListPage type.
func NewUSQLTableValuedFunctionListPage(getNextPage func(context.Context, USQLTableValuedFunctionList) (USQLTableValuedFunctionList, error)) USQLTableValuedFunctionListPage {
	return USQLTableValuedFunctionListPage{fn: getNextPage}
}

// USQLType a Data Lake Analytics catalog U-SQL type item.
type USQLType struct {
	// DatabaseName - the name of the database.
	DatabaseName *string `json:"databaseName,omitempty"`
	// SchemaName - the name of the schema associated with this table and database.
	SchemaName *string `json:"schemaName,omitempty"`
	// Name - the name of type for this type.
	Name *string `json:"typeName,omitempty"`
	// TypeFamily - the type family for this type.
	TypeFamily *string `json:"typeFamily,omitempty"`
	// CSharpName - the C# name for this type.
	CSharpName *string `json:"cSharpName,omitempty"`
	// FullCSharpName - the fully qualified C# name for this type.
	FullCSharpName *string `json:"fullCSharpName,omitempty"`
	// SystemTypeID - the system type ID for this type.
	SystemTypeID *int32 `json:"systemTypeId,omitempty"`
	// UserTypeID - the user type ID for this type.
	UserTypeID *int32 `json:"userTypeId,omitempty"`
	// SchemaID - the schema ID for this type.
	SchemaID *int32 `json:"schemaId,omitempty"`
	// PrincipalID - the principal ID for this type.
	PrincipalID *int32 `json:"principalId,omitempty"`
	// IsNullable - the the switch indicating if this type is nullable.
	IsNullable *bool `json:"isNullable,omitempty"`
	// IsUserDefined - the the switch indicating if this type is user defined.
	IsUserDefined *bool `json:"isUserDefined,omitempty"`
	// IsAssemblyType - the the switch indicating if this type is an assembly type.
	IsAssemblyType *bool `json:"isAssemblyType,omitempty"`
	// IsTableType - the the switch indicating if this type is a table type.
	IsTableType *bool `json:"isTableType,omitempty"`
	// IsComplexType - the the switch indicating if this type is a complex type.
	IsComplexType *bool `json:"isComplexType,omitempty"`
	// ComputeAccountName - the name of the Data Lake Analytics account.
	ComputeAccountName *string `json:"computeAccountName,omitempty"`
	// Version - the version of the catalog item.
	Version *uuid.UUID `json:"version,omitempty"`
}

// USQLTypeList a Data Lake Analytics catalog U-SQL type item list.
type USQLTypeList struct {
	autorest.Response `json:"-"`
	// Value - the list of types in the database and schema combination
	Value *[]USQLType `json:"value,omitempty"`
	// NextLink - the link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// USQLTypeListIterator provides access to a complete listing of USQLType values.
type USQLTypeListIterator struct {
	i    int
	page USQLTypeListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *USQLTypeListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLTypeListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *USQLTypeListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter USQLTypeListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter USQLTypeListIterator) Response() USQLTypeList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter USQLTypeListIterator) Value() USQLType {
	if !iter.page.NotDone() {
		return USQLType{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the USQLTypeListIterator type.
func NewUSQLTypeListIterator(page USQLTypeListPage) USQLTypeListIterator {
	return USQLTypeListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ustl USQLTypeList) IsEmpty() bool {
	return ustl.Value == nil || len(*ustl.Value) == 0
}

// uSQLTypeListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ustl USQLTypeList) uSQLTypeListPreparer(ctx context.Context) (*http.Request, error) {
	if ustl.NextLink == nil || len(to.String(ustl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ustl.NextLink)))
}

// USQLTypeListPage contains a page of USQLType values.
type USQLTypeListPage struct {
	fn  func(context.Context, USQLTypeList) (USQLTypeList, error)
	utl USQLTypeList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *USQLTypeListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLTypeListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.utl)
	if err != nil {
		return err
	}
	page.utl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *USQLTypeListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page USQLTypeListPage) NotDone() bool {
	return !page.utl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page USQLTypeListPage) Response() USQLTypeList {
	return page.utl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page USQLTypeListPage) Values() []USQLType {
	if page.utl.IsEmpty() {
		return nil
	}
	return *page.utl.Value
}

// Creates a new instance of the USQLTypeListPage type.
func NewUSQLTypeListPage(getNextPage func(context.Context, USQLTypeList) (USQLTypeList, error)) USQLTypeListPage {
	return USQLTypeListPage{fn: getNextPage}
}

// USQLView a Data Lake Analytics catalog U-SQL view item.
type USQLView struct {
	autorest.Response `json:"-"`
	// DatabaseName - the name of the database.
	DatabaseName *string `json:"databaseName,omitempty"`
	// SchemaName - the name of the schema associated with this view and database.
	SchemaName *string `json:"schemaName,omitempty"`
	// Name - the name of the view.
	Name *string `json:"viewName,omitempty"`
	// Definition - the defined query of the view.
	Definition *string `json:"definition,omitempty"`
	// ComputeAccountName - the name of the Data Lake Analytics account.
	ComputeAccountName *string `json:"computeAccountName,omitempty"`
	// Version - the version of the catalog item.
	Version *uuid.UUID `json:"version,omitempty"`
}

// USQLViewList a Data Lake Analytics catalog U-SQL view item list.
type USQLViewList struct {
	autorest.Response `json:"-"`
	// Value - the list of view in the database and schema combination
	Value *[]USQLView `json:"value,omitempty"`
	// NextLink - the link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// USQLViewListIterator provides access to a complete listing of USQLView values.
type USQLViewListIterator struct {
	i    int
	page USQLViewListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *USQLViewListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLViewListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *USQLViewListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter USQLViewListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter USQLViewListIterator) Response() USQLViewList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter USQLViewListIterator) Value() USQLView {
	if !iter.page.NotDone() {
		return USQLView{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the USQLViewListIterator type.
func NewUSQLViewListIterator(page USQLViewListPage) USQLViewListIterator {
	return USQLViewListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (usvl USQLViewList) IsEmpty() bool {
	return usvl.Value == nil || len(*usvl.Value) == 0
}

// uSQLViewListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (usvl USQLViewList) uSQLViewListPreparer(ctx context.Context) (*http.Request, error) {
	if usvl.NextLink == nil || len(to.String(usvl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(usvl.NextLink)))
}

// USQLViewListPage contains a page of USQLView values.
type USQLViewListPage struct {
	fn  func(context.Context, USQLViewList) (USQLViewList, error)
	uvl USQLViewList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *USQLViewListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLViewListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.uvl)
	if err != nil {
		return err
	}
	page.uvl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *USQLViewListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page USQLViewListPage) NotDone() bool {
	return !page.uvl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page USQLViewListPage) Response() USQLViewList {
	return page.uvl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page USQLViewListPage) Values() []USQLView {
	if page.uvl.IsEmpty() {
		return nil
	}
	return *page.uvl.Value
}

// Creates a new instance of the USQLViewListPage type.
func NewUSQLViewListPage(getNextPage func(context.Context, USQLViewList) (USQLViewList, error)) USQLViewListPage {
	return USQLViewListPage{fn: getNextPage}
}
