package edgegateway

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/edgegateway/mgmt/2019-03-01/edgegateway"

// AccountType enumerates the values for account type.
type AccountType string

const (
	// BlobStorage ...
	BlobStorage AccountType = "BlobStorage"
	// GeneralPurposeStorage ...
	GeneralPurposeStorage AccountType = "GeneralPurposeStorage"
)

// PossibleAccountTypeValues returns an array of possible values for the AccountType const type.
func PossibleAccountTypeValues() []AccountType {
	return []AccountType{BlobStorage, GeneralPurposeStorage}
}

// AlertSeverity enumerates the values for alert severity.
type AlertSeverity string

const (
	// Critical ...
	Critical AlertSeverity = "Critical"
	// Informational ...
	Informational AlertSeverity = "Informational"
	// Warning ...
	Warning AlertSeverity = "Warning"
)

// PossibleAlertSeverityValues returns an array of possible values for the AlertSeverity const type.
func PossibleAlertSeverityValues() []AlertSeverity {
	return []AlertSeverity{Critical, Informational, Warning}
}

// AuthenticationType enumerates the values for authentication type.
type AuthenticationType string

const (
	// AzureActiveDirectory ...
	AzureActiveDirectory AuthenticationType = "AzureActiveDirectory"
	// Invalid ...
	Invalid AuthenticationType = "Invalid"
)

// PossibleAuthenticationTypeValues returns an array of possible values for the AuthenticationType const type.
func PossibleAuthenticationTypeValues() []AuthenticationType {
	return []AuthenticationType{AzureActiveDirectory, Invalid}
}

// AzureContainerDataFormat enumerates the values for azure container data format.
type AzureContainerDataFormat string

const (
	// AzureFile ...
	AzureFile AzureContainerDataFormat = "AzureFile"
	// BlockBlob ...
	BlockBlob AzureContainerDataFormat = "BlockBlob"
	// PageBlob ...
	PageBlob AzureContainerDataFormat = "PageBlob"
)

// PossibleAzureContainerDataFormatValues returns an array of possible values for the AzureContainerDataFormat const type.
func PossibleAzureContainerDataFormatValues() []AzureContainerDataFormat {
	return []AzureContainerDataFormat{AzureFile, BlockBlob, PageBlob}
}

// ClientPermissionType enumerates the values for client permission type.
type ClientPermissionType string

const (
	// NoAccess ...
	NoAccess ClientPermissionType = "NoAccess"
	// ReadOnly ...
	ReadOnly ClientPermissionType = "ReadOnly"
	// ReadWrite ...
	ReadWrite ClientPermissionType = "ReadWrite"
)

// PossibleClientPermissionTypeValues returns an array of possible values for the ClientPermissionType const type.
func PossibleClientPermissionTypeValues() []ClientPermissionType {
	return []ClientPermissionType{NoAccess, ReadOnly, ReadWrite}
}

// DataBoxEdgeDeviceStatus enumerates the values for data box edge device status.
type DataBoxEdgeDeviceStatus string

const (
	// Disconnected ...
	Disconnected DataBoxEdgeDeviceStatus = "Disconnected"
	// NeedsAttention ...
	NeedsAttention DataBoxEdgeDeviceStatus = "NeedsAttention"
	// Offline ...
	Offline DataBoxEdgeDeviceStatus = "Offline"
	// Online ...
	Online DataBoxEdgeDeviceStatus = "Online"
	// PartiallyDisconnected ...
	PartiallyDisconnected DataBoxEdgeDeviceStatus = "PartiallyDisconnected"
	// ReadyToSetup ...
	ReadyToSetup DataBoxEdgeDeviceStatus = "ReadyToSetup"
)

// PossibleDataBoxEdgeDeviceStatusValues returns an array of possible values for the DataBoxEdgeDeviceStatus const type.
func PossibleDataBoxEdgeDeviceStatusValues() []DataBoxEdgeDeviceStatus {
	return []DataBoxEdgeDeviceStatus{Disconnected, NeedsAttention, Offline, Online, PartiallyDisconnected, ReadyToSetup}
}

// DataPolicy enumerates the values for data policy.
type DataPolicy string

const (
	// Cloud ...
	Cloud DataPolicy = "Cloud"
	// Local ...
	Local DataPolicy = "Local"
)

// PossibleDataPolicyValues returns an array of possible values for the DataPolicy const type.
func PossibleDataPolicyValues() []DataPolicy {
	return []DataPolicy{Cloud, Local}
}

// DayOfWeek enumerates the values for day of week.
type DayOfWeek string

const (
	// Friday ...
	Friday DayOfWeek = "Friday"
	// Monday ...
	Monday DayOfWeek = "Monday"
	// Saturday ...
	Saturday DayOfWeek = "Saturday"
	// Sunday ...
	Sunday DayOfWeek = "Sunday"
	// Thursday ...
	Thursday DayOfWeek = "Thursday"
	// Tuesday ...
	Tuesday DayOfWeek = "Tuesday"
	// Wednesday ...
	Wednesday DayOfWeek = "Wednesday"
)

// PossibleDayOfWeekValues returns an array of possible values for the DayOfWeek const type.
func PossibleDayOfWeekValues() []DayOfWeek {
	return []DayOfWeek{Friday, Monday, Saturday, Sunday, Thursday, Tuesday, Wednesday}
}

// DeviceType enumerates the values for device type.
type DeviceType string

const (
	// DeviceTypeDataBoxEdgeDevice ...
	DeviceTypeDataBoxEdgeDevice DeviceType = "DataBoxEdgeDevice"
)

// PossibleDeviceTypeValues returns an array of possible values for the DeviceType const type.
func PossibleDeviceTypeValues() []DeviceType {
	return []DeviceType{DeviceTypeDataBoxEdgeDevice}
}

// DownloadPhase enumerates the values for download phase.
type DownloadPhase string

const (
	// Downloading ...
	Downloading DownloadPhase = "Downloading"
	// Initializing ...
	Initializing DownloadPhase = "Initializing"
	// Unknown ...
	Unknown DownloadPhase = "Unknown"
	// Verifying ...
	Verifying DownloadPhase = "Verifying"
)

// PossibleDownloadPhaseValues returns an array of possible values for the DownloadPhase const type.
func PossibleDownloadPhaseValues() []DownloadPhase {
	return []DownloadPhase{Downloading, Initializing, Unknown, Verifying}
}

// EncryptionAlgorithm enumerates the values for encryption algorithm.
type EncryptionAlgorithm string

const (
	// AES256 ...
	AES256 EncryptionAlgorithm = "AES256"
	// None ...
	None EncryptionAlgorithm = "None"
	// RSAESPKCS1V15 ...
	RSAESPKCS1V15 EncryptionAlgorithm = "RSAES_PKCS1_v_1_5"
)

// PossibleEncryptionAlgorithmValues returns an array of possible values for the EncryptionAlgorithm const type.
func PossibleEncryptionAlgorithmValues() []EncryptionAlgorithm {
	return []EncryptionAlgorithm{AES256, None, RSAESPKCS1V15}
}

// InstallRebootBehavior enumerates the values for install reboot behavior.
type InstallRebootBehavior string

const (
	// NeverReboots ...
	NeverReboots InstallRebootBehavior = "NeverReboots"
	// RequestReboot ...
	RequestReboot InstallRebootBehavior = "RequestReboot"
	// RequiresReboot ...
	RequiresReboot InstallRebootBehavior = "RequiresReboot"
)

// PossibleInstallRebootBehaviorValues returns an array of possible values for the InstallRebootBehavior const type.
func PossibleInstallRebootBehaviorValues() []InstallRebootBehavior {
	return []InstallRebootBehavior{NeverReboots, RequestReboot, RequiresReboot}
}

// JobStatus enumerates the values for job status.
type JobStatus string

const (
	// JobStatusCanceled ...
	JobStatusCanceled JobStatus = "Canceled"
	// JobStatusFailed ...
	JobStatusFailed JobStatus = "Failed"
	// JobStatusInvalid ...
	JobStatusInvalid JobStatus = "Invalid"
	// JobStatusPaused ...
	JobStatusPaused JobStatus = "Paused"
	// JobStatusRunning ...
	JobStatusRunning JobStatus = "Running"
	// JobStatusScheduled ...
	JobStatusScheduled JobStatus = "Scheduled"
	// JobStatusSucceeded ...
	JobStatusSucceeded JobStatus = "Succeeded"
)

// PossibleJobStatusValues returns an array of possible values for the JobStatus const type.
func PossibleJobStatusValues() []JobStatus {
	return []JobStatus{JobStatusCanceled, JobStatusFailed, JobStatusInvalid, JobStatusPaused, JobStatusRunning, JobStatusScheduled, JobStatusSucceeded}
}

// JobType enumerates the values for job type.
type JobType string

const (
	// JobTypeDownloadUpdates ...
	JobTypeDownloadUpdates JobType = "DownloadUpdates"
	// JobTypeInstallUpdates ...
	JobTypeInstallUpdates JobType = "InstallUpdates"
	// JobTypeInvalid ...
	JobTypeInvalid JobType = "Invalid"
	// JobTypeRefreshShare ...
	JobTypeRefreshShare JobType = "RefreshShare"
	// JobTypeScanForUpdates ...
	JobTypeScanForUpdates JobType = "ScanForUpdates"
)

// PossibleJobTypeValues returns an array of possible values for the JobType const type.
func PossibleJobTypeValues() []JobType {
	return []JobType{JobTypeDownloadUpdates, JobTypeInstallUpdates, JobTypeInvalid, JobTypeRefreshShare, JobTypeScanForUpdates}
}

// Kind enumerates the values for kind.
type Kind string

const (
	// KindIOT ...
	KindIOT Kind = "IOT"
	// KindRole ...
	KindRole Kind = "Role"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{KindIOT, KindRole}
}

// KindBasicTrigger enumerates the values for kind basic trigger.
type KindBasicTrigger string

const (
	// KindFileEvent ...
	KindFileEvent KindBasicTrigger = "FileEvent"
	// KindPeriodicTimerEvent ...
	KindPeriodicTimerEvent KindBasicTrigger = "PeriodicTimerEvent"
	// KindTrigger ...
	KindTrigger KindBasicTrigger = "Trigger"
)

// PossibleKindBasicTriggerValues returns an array of possible values for the KindBasicTrigger const type.
func PossibleKindBasicTriggerValues() []KindBasicTrigger {
	return []KindBasicTrigger{KindFileEvent, KindPeriodicTimerEvent, KindTrigger}
}

// MetricAggregationType enumerates the values for metric aggregation type.
type MetricAggregationType string

const (
	// MetricAggregationTypeAverage ...
	MetricAggregationTypeAverage MetricAggregationType = "Average"
	// MetricAggregationTypeCount ...
	MetricAggregationTypeCount MetricAggregationType = "Count"
	// MetricAggregationTypeMaximum ...
	MetricAggregationTypeMaximum MetricAggregationType = "Maximum"
	// MetricAggregationTypeMinimum ...
	MetricAggregationTypeMinimum MetricAggregationType = "Minimum"
	// MetricAggregationTypeNone ...
	MetricAggregationTypeNone MetricAggregationType = "None"
	// MetricAggregationTypeNotSpecified ...
	MetricAggregationTypeNotSpecified MetricAggregationType = "NotSpecified"
	// MetricAggregationTypeTotal ...
	MetricAggregationTypeTotal MetricAggregationType = "Total"
)

// PossibleMetricAggregationTypeValues returns an array of possible values for the MetricAggregationType const type.
func PossibleMetricAggregationTypeValues() []MetricAggregationType {
	return []MetricAggregationType{MetricAggregationTypeAverage, MetricAggregationTypeCount, MetricAggregationTypeMaximum, MetricAggregationTypeMinimum, MetricAggregationTypeNone, MetricAggregationTypeNotSpecified, MetricAggregationTypeTotal}
}

// MetricCategory enumerates the values for metric category.
type MetricCategory string

const (
	// Capacity ...
	Capacity MetricCategory = "Capacity"
	// Transaction ...
	Transaction MetricCategory = "Transaction"
)

// PossibleMetricCategoryValues returns an array of possible values for the MetricCategory const type.
func PossibleMetricCategoryValues() []MetricCategory {
	return []MetricCategory{Capacity, Transaction}
}

// MetricUnit enumerates the values for metric unit.
type MetricUnit string

const (
	// Bytes ...
	Bytes MetricUnit = "Bytes"
	// BytesPerSecond ...
	BytesPerSecond MetricUnit = "BytesPerSecond"
	// Count ...
	Count MetricUnit = "Count"
	// CountPerSecond ...
	CountPerSecond MetricUnit = "CountPerSecond"
	// Milliseconds ...
	Milliseconds MetricUnit = "Milliseconds"
	// NotSpecified ...
	NotSpecified MetricUnit = "NotSpecified"
	// Percent ...
	Percent MetricUnit = "Percent"
	// Seconds ...
	Seconds MetricUnit = "Seconds"
)

// PossibleMetricUnitValues returns an array of possible values for the MetricUnit const type.
func PossibleMetricUnitValues() []MetricUnit {
	return []MetricUnit{Bytes, BytesPerSecond, Count, CountPerSecond, Milliseconds, NotSpecified, Percent, Seconds}
}

// MonitoringStatus enumerates the values for monitoring status.
type MonitoringStatus string

const (
	// Disabled ...
	Disabled MonitoringStatus = "Disabled"
	// Enabled ...
	Enabled MonitoringStatus = "Enabled"
)

// PossibleMonitoringStatusValues returns an array of possible values for the MonitoringStatus const type.
func PossibleMonitoringStatusValues() []MonitoringStatus {
	return []MonitoringStatus{Disabled, Enabled}
}

// NetworkAdapterDHCPStatus enumerates the values for network adapter dhcp status.
type NetworkAdapterDHCPStatus string

const (
	// NetworkAdapterDHCPStatusDisabled ...
	NetworkAdapterDHCPStatusDisabled NetworkAdapterDHCPStatus = "Disabled"
	// NetworkAdapterDHCPStatusEnabled ...
	NetworkAdapterDHCPStatusEnabled NetworkAdapterDHCPStatus = "Enabled"
)

// PossibleNetworkAdapterDHCPStatusValues returns an array of possible values for the NetworkAdapterDHCPStatus const type.
func PossibleNetworkAdapterDHCPStatusValues() []NetworkAdapterDHCPStatus {
	return []NetworkAdapterDHCPStatus{NetworkAdapterDHCPStatusDisabled, NetworkAdapterDHCPStatusEnabled}
}

// NetworkAdapterRDMAStatus enumerates the values for network adapter rdma status.
type NetworkAdapterRDMAStatus string

const (
	// Capable ...
	Capable NetworkAdapterRDMAStatus = "Capable"
	// Incapable ...
	Incapable NetworkAdapterRDMAStatus = "Incapable"
)

// PossibleNetworkAdapterRDMAStatusValues returns an array of possible values for the NetworkAdapterRDMAStatus const type.
func PossibleNetworkAdapterRDMAStatusValues() []NetworkAdapterRDMAStatus {
	return []NetworkAdapterRDMAStatus{Capable, Incapable}
}

// NetworkAdapterStatus enumerates the values for network adapter status.
type NetworkAdapterStatus string

const (
	// Active ...
	Active NetworkAdapterStatus = "Active"
	// Inactive ...
	Inactive NetworkAdapterStatus = "Inactive"
)

// PossibleNetworkAdapterStatusValues returns an array of possible values for the NetworkAdapterStatus const type.
func PossibleNetworkAdapterStatusValues() []NetworkAdapterStatus {
	return []NetworkAdapterStatus{Active, Inactive}
}

// NetworkGroup enumerates the values for network group.
type NetworkGroup string

const (
	// NetworkGroupNone ...
	NetworkGroupNone NetworkGroup = "None"
	// NetworkGroupNonRDMA ...
	NetworkGroupNonRDMA NetworkGroup = "NonRDMA"
	// NetworkGroupRDMA ...
	NetworkGroupRDMA NetworkGroup = "RDMA"
)

// PossibleNetworkGroupValues returns an array of possible values for the NetworkGroup const type.
func PossibleNetworkGroupValues() []NetworkGroup {
	return []NetworkGroup{NetworkGroupNone, NetworkGroupNonRDMA, NetworkGroupRDMA}
}

// OrderState enumerates the values for order state.
type OrderState string

const (
	// Arriving ...
	Arriving OrderState = "Arriving"
	// AwaitingFulfilment ...
	AwaitingFulfilment OrderState = "AwaitingFulfilment"
	// AwaitingPreparation ...
	AwaitingPreparation OrderState = "AwaitingPreparation"
	// AwaitingReturnShipment ...
	AwaitingReturnShipment OrderState = "AwaitingReturnShipment"
	// AwaitingShipment ...
	AwaitingShipment OrderState = "AwaitingShipment"
	// CollectedAtMicrosoft ...
	CollectedAtMicrosoft OrderState = "CollectedAtMicrosoft"
	// Declined ...
	Declined OrderState = "Declined"
	// Delivered ...
	Delivered OrderState = "Delivered"
	// LostDevice ...
	LostDevice OrderState = "LostDevice"
	// ReplacementRequested ...
	ReplacementRequested OrderState = "ReplacementRequested"
	// ReturnInitiated ...
	ReturnInitiated OrderState = "ReturnInitiated"
	// Shipped ...
	Shipped OrderState = "Shipped"
	// ShippedBack ...
	ShippedBack OrderState = "ShippedBack"
	// Untracked ...
	Untracked OrderState = "Untracked"
)

// PossibleOrderStateValues returns an array of possible values for the OrderState const type.
func PossibleOrderStateValues() []OrderState {
	return []OrderState{Arriving, AwaitingFulfilment, AwaitingPreparation, AwaitingReturnShipment, AwaitingShipment, CollectedAtMicrosoft, Declined, Delivered, LostDevice, ReplacementRequested, ReturnInitiated, Shipped, ShippedBack, Untracked}
}

// PlatformType enumerates the values for platform type.
type PlatformType string

const (
	// Linux ...
	Linux PlatformType = "Linux"
	// Windows ...
	Windows PlatformType = "Windows"
)

// PossiblePlatformTypeValues returns an array of possible values for the PlatformType const type.
func PossiblePlatformTypeValues() []PlatformType {
	return []PlatformType{Linux, Windows}
}

// RoleStatus enumerates the values for role status.
type RoleStatus string

const (
	// RoleStatusDisabled ...
	RoleStatusDisabled RoleStatus = "Disabled"
	// RoleStatusEnabled ...
	RoleStatusEnabled RoleStatus = "Enabled"
)

// PossibleRoleStatusValues returns an array of possible values for the RoleStatus const type.
func PossibleRoleStatusValues() []RoleStatus {
	return []RoleStatus{RoleStatusDisabled, RoleStatusEnabled}
}

// RoleTypes enumerates the values for role types.
type RoleTypes string

const (
	// ASA ...
	ASA RoleTypes = "ASA"
	// Cognitive ...
	Cognitive RoleTypes = "Cognitive"
	// Functions ...
	Functions RoleTypes = "Functions"
	// IOT ...
	IOT RoleTypes = "IOT"
)

// PossibleRoleTypesValues returns an array of possible values for the RoleTypes const type.
func PossibleRoleTypesValues() []RoleTypes {
	return []RoleTypes{ASA, Cognitive, Functions, IOT}
}

// ShareAccessProtocol enumerates the values for share access protocol.
type ShareAccessProtocol string

const (
	// NFS ...
	NFS ShareAccessProtocol = "NFS"
	// SMB ...
	SMB ShareAccessProtocol = "SMB"
)

// PossibleShareAccessProtocolValues returns an array of possible values for the ShareAccessProtocol const type.
func PossibleShareAccessProtocolValues() []ShareAccessProtocol {
	return []ShareAccessProtocol{NFS, SMB}
}

// ShareAccessType enumerates the values for share access type.
type ShareAccessType string

const (
	// Change ...
	Change ShareAccessType = "Change"
	// Custom ...
	Custom ShareAccessType = "Custom"
	// Read ...
	Read ShareAccessType = "Read"
)

// PossibleShareAccessTypeValues returns an array of possible values for the ShareAccessType const type.
func PossibleShareAccessTypeValues() []ShareAccessType {
	return []ShareAccessType{Change, Custom, Read}
}

// ShareStatus enumerates the values for share status.
type ShareStatus string

const (
	// ShareStatusOffline ...
	ShareStatusOffline ShareStatus = "Offline"
	// ShareStatusOnline ...
	ShareStatusOnline ShareStatus = "Online"
)

// PossibleShareStatusValues returns an array of possible values for the ShareStatus const type.
func PossibleShareStatusValues() []ShareStatus {
	return []ShareStatus{ShareStatusOffline, ShareStatusOnline}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// Edge ...
	Edge SkuName = "Edge"
	// Gateway ...
	Gateway SkuName = "Gateway"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{Edge, Gateway}
}

// SkuTier enumerates the values for sku tier.
type SkuTier string

const (
	// Standard ...
	Standard SkuTier = "Standard"
)

// PossibleSkuTierValues returns an array of possible values for the SkuTier const type.
func PossibleSkuTierValues() []SkuTier {
	return []SkuTier{Standard}
}

// SSLStatus enumerates the values for ssl status.
type SSLStatus string

const (
	// SSLStatusDisabled ...
	SSLStatusDisabled SSLStatus = "Disabled"
	// SSLStatusEnabled ...
	SSLStatusEnabled SSLStatus = "Enabled"
)

// PossibleSSLStatusValues returns an array of possible values for the SSLStatus const type.
func PossibleSSLStatusValues() []SSLStatus {
	return []SSLStatus{SSLStatusDisabled, SSLStatusEnabled}
}

// TimeGrain enumerates the values for time grain.
type TimeGrain string

const (
	// PT12H ...
	PT12H TimeGrain = "PT12H"
	// PT15M ...
	PT15M TimeGrain = "PT15M"
	// PT1D ...
	PT1D TimeGrain = "PT1D"
	// PT1H ...
	PT1H TimeGrain = "PT1H"
	// PT1M ...
	PT1M TimeGrain = "PT1M"
	// PT30M ...
	PT30M TimeGrain = "PT30M"
	// PT5M ...
	PT5M TimeGrain = "PT5M"
	// PT6H ...
	PT6H TimeGrain = "PT6H"
)

// PossibleTimeGrainValues returns an array of possible values for the TimeGrain const type.
func PossibleTimeGrainValues() []TimeGrain {
	return []TimeGrain{PT12H, PT15M, PT1D, PT1H, PT1M, PT30M, PT5M, PT6H}
}

// UpdateOperation enumerates the values for update operation.
type UpdateOperation string

const (
	// UpdateOperationDownload ...
	UpdateOperationDownload UpdateOperation = "Download"
	// UpdateOperationInstall ...
	UpdateOperationInstall UpdateOperation = "Install"
	// UpdateOperationNone ...
	UpdateOperationNone UpdateOperation = "None"
	// UpdateOperationScan ...
	UpdateOperationScan UpdateOperation = "Scan"
)

// PossibleUpdateOperationValues returns an array of possible values for the UpdateOperation const type.
func PossibleUpdateOperationValues() []UpdateOperation {
	return []UpdateOperation{UpdateOperationDownload, UpdateOperationInstall, UpdateOperationNone, UpdateOperationScan}
}

// UpdateOperationStage enumerates the values for update operation stage.
type UpdateOperationStage string

const (
	// UpdateOperationStageDownloadComplete ...
	UpdateOperationStageDownloadComplete UpdateOperationStage = "DownloadComplete"
	// UpdateOperationStageDownloadFailed ...
	UpdateOperationStageDownloadFailed UpdateOperationStage = "DownloadFailed"
	// UpdateOperationStageDownloadStarted ...
	UpdateOperationStageDownloadStarted UpdateOperationStage = "DownloadStarted"
	// UpdateOperationStageFailure ...
	UpdateOperationStageFailure UpdateOperationStage = "Failure"
	// UpdateOperationStageInitial ...
	UpdateOperationStageInitial UpdateOperationStage = "Initial"
	// UpdateOperationStageInstallComplete ...
	UpdateOperationStageInstallComplete UpdateOperationStage = "InstallComplete"
	// UpdateOperationStageInstallFailed ...
	UpdateOperationStageInstallFailed UpdateOperationStage = "InstallFailed"
	// UpdateOperationStageInstallStarted ...
	UpdateOperationStageInstallStarted UpdateOperationStage = "InstallStarted"
	// UpdateOperationStageRebootInitiated ...
	UpdateOperationStageRebootInitiated UpdateOperationStage = "RebootInitiated"
	// UpdateOperationStageRescanComplete ...
	UpdateOperationStageRescanComplete UpdateOperationStage = "RescanComplete"
	// UpdateOperationStageRescanFailed ...
	UpdateOperationStageRescanFailed UpdateOperationStage = "RescanFailed"
	// UpdateOperationStageRescanStarted ...
	UpdateOperationStageRescanStarted UpdateOperationStage = "RescanStarted"
	// UpdateOperationStageScanComplete ...
	UpdateOperationStageScanComplete UpdateOperationStage = "ScanComplete"
	// UpdateOperationStageScanFailed ...
	UpdateOperationStageScanFailed UpdateOperationStage = "ScanFailed"
	// UpdateOperationStageScanStarted ...
	UpdateOperationStageScanStarted UpdateOperationStage = "ScanStarted"
	// UpdateOperationStageSuccess ...
	UpdateOperationStageSuccess UpdateOperationStage = "Success"
	// UpdateOperationStageUnknown ...
	UpdateOperationStageUnknown UpdateOperationStage = "Unknown"
)

// PossibleUpdateOperationStageValues returns an array of possible values for the UpdateOperationStage const type.
func PossibleUpdateOperationStageValues() []UpdateOperationStage {
	return []UpdateOperationStage{UpdateOperationStageDownloadComplete, UpdateOperationStageDownloadFailed, UpdateOperationStageDownloadStarted, UpdateOperationStageFailure, UpdateOperationStageInitial, UpdateOperationStageInstallComplete, UpdateOperationStageInstallFailed, UpdateOperationStageInstallStarted, UpdateOperationStageRebootInitiated, UpdateOperationStageRescanComplete, UpdateOperationStageRescanFailed, UpdateOperationStageRescanStarted, UpdateOperationStageScanComplete, UpdateOperationStageScanFailed, UpdateOperationStageScanStarted, UpdateOperationStageSuccess, UpdateOperationStageUnknown}
}

// Address the shipping address of the customer.
type Address struct {
	// AddressLine1 - The address line1.
	AddressLine1 *string `json:"addressLine1,omitempty"`
	// AddressLine2 - The address line2.
	AddressLine2 *string `json:"addressLine2,omitempty"`
	// AddressLine3 - The address line3.
	AddressLine3 *string `json:"addressLine3,omitempty"`
	// PostalCode - The postal code.
	PostalCode *string `json:"postalCode,omitempty"`
	// City - The city name.
	City *string `json:"city,omitempty"`
	// State - The state name.
	State *string `json:"state,omitempty"`
	// Country - The country name.
	Country *string `json:"country,omitempty"`
}

// Alert alert on the data box edge/gateway device.
type Alert struct {
	autorest.Response `json:"-"`
	// AlertProperties - Properties of alert.
	*AlertProperties `json:"properties,omitempty"`
	// ID - The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - The object name.
	Name *string `json:"name,omitempty"`
	// Type - The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Alert.
func (a Alert) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.AlertProperties != nil {
		objectMap["properties"] = a.AlertProperties
	}
	if a.ID != nil {
		objectMap["id"] = a.ID
	}
	if a.Name != nil {
		objectMap["name"] = a.Name
	}
	if a.Type != nil {
		objectMap["type"] = a.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Alert struct.
func (a *Alert) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var alertProperties AlertProperties
				err = json.Unmarshal(*v, &alertProperties)
				if err != nil {
					return err
				}
				a.AlertProperties = &alertProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		}
	}

	return nil
}

// AlertErrorDetails error details for the alert.
type AlertErrorDetails struct {
	// ErrorCode - Error code.
	ErrorCode *string `json:"errorCode,omitempty"`
	// ErrorMessage - Error Message.
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// Occurrences - Number of occurrences.
	Occurrences *int32 `json:"occurrences,omitempty"`
}

// AlertList collection of alerts.
type AlertList struct {
	autorest.Response `json:"-"`
	// Value - The value.
	Value *[]Alert `json:"value,omitempty"`
	// NextLink - Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// AlertListIterator provides access to a complete listing of Alert values.
type AlertListIterator struct {
	i    int
	page AlertListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AlertListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AlertListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AlertListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AlertListIterator) Response() AlertList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AlertListIterator) Value() Alert {
	if !iter.page.NotDone() {
		return Alert{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AlertListIterator type.
func NewAlertListIterator(page AlertListPage) AlertListIterator {
	return AlertListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (al AlertList) IsEmpty() bool {
	return al.Value == nil || len(*al.Value) == 0
}

// alertListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (al AlertList) alertListPreparer(ctx context.Context) (*http.Request, error) {
	if al.NextLink == nil || len(to.String(al.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(al.NextLink)))
}

// AlertListPage contains a page of Alert values.
type AlertListPage struct {
	fn func(context.Context, AlertList) (AlertList, error)
	al AlertList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AlertListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.al)
	if err != nil {
		return err
	}
	page.al = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AlertListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AlertListPage) NotDone() bool {
	return !page.al.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AlertListPage) Response() AlertList {
	return page.al
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AlertListPage) Values() []Alert {
	if page.al.IsEmpty() {
		return nil
	}
	return *page.al.Value
}

// Creates a new instance of the AlertListPage type.
func NewAlertListPage(getNextPage func(context.Context, AlertList) (AlertList, error)) AlertListPage {
	return AlertListPage{fn: getNextPage}
}

// AlertProperties properties of alert.
type AlertProperties struct {
	// Title - Alert title.
	Title *string `json:"title,omitempty"`
	// AlertType - Alert type.
	AlertType *string `json:"alertType,omitempty"`
	// AppearedAtDateTime - UTC time when the alert appeared.
	AppearedAtDateTime *date.Time `json:"appearedAtDateTime,omitempty"`
	// Recommendation - Alert recommendation.
	Recommendation *string `json:"recommendation,omitempty"`
	// Severity - Severity of the alert. Possible values include: 'Informational', 'Warning', 'Critical'
	Severity AlertSeverity `json:"severity,omitempty"`
	// ErrorDetails - Error details of the alert.
	ErrorDetails *AlertErrorDetails `json:"errorDetails,omitempty"`
	// DetailedInformation - Alert details.
	DetailedInformation map[string]*string `json:"detailedInformation"`
}

// MarshalJSON is the custom marshaler for AlertProperties.
func (ap AlertProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.Title != nil {
		objectMap["title"] = ap.Title
	}
	if ap.AlertType != nil {
		objectMap["alertType"] = ap.AlertType
	}
	if ap.AppearedAtDateTime != nil {
		objectMap["appearedAtDateTime"] = ap.AppearedAtDateTime
	}
	if ap.Recommendation != nil {
		objectMap["recommendation"] = ap.Recommendation
	}
	if ap.Severity != "" {
		objectMap["severity"] = ap.Severity
	}
	if ap.ErrorDetails != nil {
		objectMap["errorDetails"] = ap.ErrorDetails
	}
	if ap.DetailedInformation != nil {
		objectMap["detailedInformation"] = ap.DetailedInformation
	}
	return json.Marshal(objectMap)
}

// ARMBaseModel represents the base class for all object models.
type ARMBaseModel struct {
	// ID - The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - The object name.
	Name *string `json:"name,omitempty"`
	// Type - The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// AsymmetricEncryptedSecret represent the secrets intended for encryption with asymmetric key pair.
type AsymmetricEncryptedSecret struct {
	// Value - The value of the secret.
	Value *string `json:"value,omitempty"`
	// EncryptionCertThumbprint - Thumbprint certificate used to encrypt \"Value\". If the value is unencrypted, it will be null.
	EncryptionCertThumbprint *string `json:"encryptionCertThumbprint,omitempty"`
	// EncryptionAlgorithm - The algorithm used to encrypt "Value". Possible values include: 'None', 'AES256', 'RSAESPKCS1V15'
	EncryptionAlgorithm EncryptionAlgorithm `json:"encryptionAlgorithm,omitempty"`
}

// Authentication authentication mechanism for IoT devices.
type Authentication struct {
	// SymmetricKey - Symmetric key for authentication.
	SymmetricKey *SymmetricKey `json:"symmetricKey,omitempty"`
}

// AzureContainerInfo azure container mapping of the endpoint.
type AzureContainerInfo struct {
	// StorageAccountCredentialID - ID of the storage account credential used to access storage.
	StorageAccountCredentialID *string `json:"storageAccountCredentialId,omitempty"`
	// ContainerName - Container name (Based on the data format specified, this represents the name of Azure Files/Page blob/Block blob).
	ContainerName *string `json:"containerName,omitempty"`
	// DataFormat - Storage format used for the file represented by the share. Possible values include: 'BlockBlob', 'PageBlob', 'AzureFile'
	DataFormat AzureContainerDataFormat `json:"dataFormat,omitempty"`
}

// BandwidthSchedule the bandwidth schedule details.
type BandwidthSchedule struct {
	autorest.Response `json:"-"`
	// BandwidthScheduleProperties - The properties of the bandwidth schedule.
	*BandwidthScheduleProperties `json:"properties,omitempty"`
	// ID - The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - The object name.
	Name *string `json:"name,omitempty"`
	// Type - The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for BandwidthSchedule.
func (bs BandwidthSchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bs.BandwidthScheduleProperties != nil {
		objectMap["properties"] = bs.BandwidthScheduleProperties
	}
	if bs.ID != nil {
		objectMap["id"] = bs.ID
	}
	if bs.Name != nil {
		objectMap["name"] = bs.Name
	}
	if bs.Type != nil {
		objectMap["type"] = bs.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BandwidthSchedule struct.
func (bs *BandwidthSchedule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var bandwidthScheduleProperties BandwidthScheduleProperties
				err = json.Unmarshal(*v, &bandwidthScheduleProperties)
				if err != nil {
					return err
				}
				bs.BandwidthScheduleProperties = &bandwidthScheduleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bs.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bs.Type = &typeVar
			}
		}
	}

	return nil
}

// BandwidthScheduleProperties the properties of the bandwidth schedule.
type BandwidthScheduleProperties struct {
	// Start - The start time of the schedule in UTC.
	Start *string `json:"start,omitempty"`
	// Stop - The stop time of the schedule in UTC.
	Stop *string `json:"stop,omitempty"`
	// RateInMbps - The bandwidth rate in Mbps.
	RateInMbps *int32 `json:"rateInMbps,omitempty"`
	// Days - The days of the week when this schedule is applicable.
	Days *[]DayOfWeek `json:"days,omitempty"`
}

// BandwidthSchedulesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type BandwidthSchedulesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *BandwidthSchedulesCreateOrUpdateFuture) Result(client BandwidthSchedulesClient) (bs BandwidthSchedule, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgegateway.BandwidthSchedulesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("edgegateway.BandwidthSchedulesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if bs.Response.Response, err = future.GetResult(sender); err == nil && bs.Response.Response.StatusCode != http.StatusNoContent {
		bs, err = client.CreateOrUpdateResponder(bs.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "edgegateway.BandwidthSchedulesCreateOrUpdateFuture", "Result", bs.Response.Response, "Failure responding to request")
		}
	}
	return
}

// BandwidthSchedulesDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type BandwidthSchedulesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *BandwidthSchedulesDeleteFuture) Result(client BandwidthSchedulesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgegateway.BandwidthSchedulesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("edgegateway.BandwidthSchedulesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// BandwidthSchedulesList the collection of bandwidth schedules.
type BandwidthSchedulesList struct {
	autorest.Response `json:"-"`
	// Value - The list of bandwidth schedules.
	Value *[]BandwidthSchedule `json:"value,omitempty"`
	// NextLink - Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// BandwidthSchedulesListIterator provides access to a complete listing of BandwidthSchedule values.
type BandwidthSchedulesListIterator struct {
	i    int
	page BandwidthSchedulesListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BandwidthSchedulesListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BandwidthSchedulesListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BandwidthSchedulesListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BandwidthSchedulesListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BandwidthSchedulesListIterator) Response() BandwidthSchedulesList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BandwidthSchedulesListIterator) Value() BandwidthSchedule {
	if !iter.page.NotDone() {
		return BandwidthSchedule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BandwidthSchedulesListIterator type.
func NewBandwidthSchedulesListIterator(page BandwidthSchedulesListPage) BandwidthSchedulesListIterator {
	return BandwidthSchedulesListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (bsl BandwidthSchedulesList) IsEmpty() bool {
	return bsl.Value == nil || len(*bsl.Value) == 0
}

// bandwidthSchedulesListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (bsl BandwidthSchedulesList) bandwidthSchedulesListPreparer(ctx context.Context) (*http.Request, error) {
	if bsl.NextLink == nil || len(to.String(bsl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(bsl.NextLink)))
}

// BandwidthSchedulesListPage contains a page of BandwidthSchedule values.
type BandwidthSchedulesListPage struct {
	fn  func(context.Context, BandwidthSchedulesList) (BandwidthSchedulesList, error)
	bsl BandwidthSchedulesList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BandwidthSchedulesListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BandwidthSchedulesListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.bsl)
	if err != nil {
		return err
	}
	page.bsl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BandwidthSchedulesListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BandwidthSchedulesListPage) NotDone() bool {
	return !page.bsl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BandwidthSchedulesListPage) Response() BandwidthSchedulesList {
	return page.bsl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BandwidthSchedulesListPage) Values() []BandwidthSchedule {
	if page.bsl.IsEmpty() {
		return nil
	}
	return *page.bsl.Value
}

// Creates a new instance of the BandwidthSchedulesListPage type.
func NewBandwidthSchedulesListPage(getNextPage func(context.Context, BandwidthSchedulesList) (BandwidthSchedulesList, error)) BandwidthSchedulesListPage {
	return BandwidthSchedulesListPage{fn: getNextPage}
}

// ClientAccessRight the mapping between a particular client IP and the type of access client has on the
// NFS share.
type ClientAccessRight struct {
	// Client - IP of the client.
	Client *string `json:"client,omitempty"`
	// AccessPermission - Type of access to be allowed for the client. Possible values include: 'NoAccess', 'ReadOnly', 'ReadWrite'
	AccessPermission ClientPermissionType `json:"accessPermission,omitempty"`
}

// CloudError an error response from the service.
type CloudError struct {
	// Error - The error details.
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody an error response from the service.
type CloudErrorBody struct {
	// Code - An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
	// Details - A list of additional details about the error.
	Details *[]CloudErrorBody `json:"details,omitempty"`
}

// ContactDetails contains all the contact details of the customer.
type ContactDetails struct {
	// ContactPerson - The contact person name.
	ContactPerson *string `json:"contactPerson,omitempty"`
	// CompanyName - The name of the company.
	CompanyName *string `json:"companyName,omitempty"`
	// Phone - The phone number.
	Phone *string `json:"phone,omitempty"`
	// EmailList - The email list.
	EmailList *[]string `json:"emailList,omitempty"`
}

// DataBoxEdgeDevice the Data Box Edge/Gateway device.
type DataBoxEdgeDevice struct {
	autorest.Response `json:"-"`
	// Location - The location of the device. This is a supported and registered Azure geographical region (for example, West US, East US, or Southeast Asia). The geographical region of a device cannot be changed once it is created, but if an identical geographical region is specified on update, the request will succeed.
	Location *string `json:"location,omitempty"`
	// Tags - The list of tags that describe the device. These tags can be used to view and group this device (across resource groups).
	Tags map[string]*string `json:"tags"`
	// Sku - The SKU type.
	Sku *Sku `json:"sku,omitempty"`
	// Etag - The etag for the devices.
	Etag *string `json:"etag,omitempty"`
	// DataBoxEdgeDeviceProperties - The properties of the Data Box Edge/Gateway device.
	*DataBoxEdgeDeviceProperties `json:"properties,omitempty"`
	// ID - The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - The object name.
	Name *string `json:"name,omitempty"`
	// Type - The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DataBoxEdgeDevice.
func (dbed DataBoxEdgeDevice) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dbed.Location != nil {
		objectMap["location"] = dbed.Location
	}
	if dbed.Tags != nil {
		objectMap["tags"] = dbed.Tags
	}
	if dbed.Sku != nil {
		objectMap["sku"] = dbed.Sku
	}
	if dbed.Etag != nil {
		objectMap["etag"] = dbed.Etag
	}
	if dbed.DataBoxEdgeDeviceProperties != nil {
		objectMap["properties"] = dbed.DataBoxEdgeDeviceProperties
	}
	if dbed.ID != nil {
		objectMap["id"] = dbed.ID
	}
	if dbed.Name != nil {
		objectMap["name"] = dbed.Name
	}
	if dbed.Type != nil {
		objectMap["type"] = dbed.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DataBoxEdgeDevice struct.
func (dbed *DataBoxEdgeDevice) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dbed.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dbed.Tags = tags
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				dbed.Sku = &sku
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				dbed.Etag = &etag
			}
		case "properties":
			if v != nil {
				var dataBoxEdgeDeviceProperties DataBoxEdgeDeviceProperties
				err = json.Unmarshal(*v, &dataBoxEdgeDeviceProperties)
				if err != nil {
					return err
				}
				dbed.DataBoxEdgeDeviceProperties = &dataBoxEdgeDeviceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dbed.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dbed.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dbed.Type = &typeVar
			}
		}
	}

	return nil
}

// DataBoxEdgeDeviceExtendedInfo the extended Info of the Data Box Edge/Gateway device.
type DataBoxEdgeDeviceExtendedInfo struct {
	autorest.Response `json:"-"`
	// DataBoxEdgeDeviceExtendedInfoProperties - The extended info properties.
	*DataBoxEdgeDeviceExtendedInfoProperties `json:"properties,omitempty"`
	// ID - The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - The object name.
	Name *string `json:"name,omitempty"`
	// Type - The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DataBoxEdgeDeviceExtendedInfo.
func (dbedei DataBoxEdgeDeviceExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dbedei.DataBoxEdgeDeviceExtendedInfoProperties != nil {
		objectMap["properties"] = dbedei.DataBoxEdgeDeviceExtendedInfoProperties
	}
	if dbedei.ID != nil {
		objectMap["id"] = dbedei.ID
	}
	if dbedei.Name != nil {
		objectMap["name"] = dbedei.Name
	}
	if dbedei.Type != nil {
		objectMap["type"] = dbedei.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DataBoxEdgeDeviceExtendedInfo struct.
func (dbedei *DataBoxEdgeDeviceExtendedInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dataBoxEdgeDeviceExtendedInfoProperties DataBoxEdgeDeviceExtendedInfoProperties
				err = json.Unmarshal(*v, &dataBoxEdgeDeviceExtendedInfoProperties)
				if err != nil {
					return err
				}
				dbedei.DataBoxEdgeDeviceExtendedInfoProperties = &dataBoxEdgeDeviceExtendedInfoProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dbedei.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dbedei.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dbedei.Type = &typeVar
			}
		}
	}

	return nil
}

// DataBoxEdgeDeviceExtendedInfoProperties the properties of the Data Box Edge/Gateway device extended
// info.
type DataBoxEdgeDeviceExtendedInfoProperties struct {
	// IntegrityKey - The Channel Integrity Key (CIK) of the device.
	IntegrityKey *string `json:"integrityKey,omitempty"`
	// EncryptionKeyThumbprint - The certificate thumbprint that was used to encrypt the Channel Integrity Key (CIK).
	EncryptionKeyThumbprint *string `json:"encryptionKeyThumbprint,omitempty"`
	// EncryptionKey - The Channel Integrity Key (CIK) of the device.
	EncryptionKey *string `json:"encryptionKey,omitempty"`
	// ResourceKey - The Resource ID of the Resource.
	ResourceKey *string `json:"resourceKey,omitempty"`
}

// DataBoxEdgeDeviceList the collection of Data Box Edge/Gateway devices.
type DataBoxEdgeDeviceList struct {
	autorest.Response `json:"-"`
	// Value - The list of Data Box Edge/Gateway devices.
	Value *[]DataBoxEdgeDevice `json:"value,omitempty"`
	// NextLink - Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// DataBoxEdgeDeviceListIterator provides access to a complete listing of DataBoxEdgeDevice values.
type DataBoxEdgeDeviceListIterator struct {
	i    int
	page DataBoxEdgeDeviceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DataBoxEdgeDeviceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataBoxEdgeDeviceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DataBoxEdgeDeviceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DataBoxEdgeDeviceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DataBoxEdgeDeviceListIterator) Response() DataBoxEdgeDeviceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DataBoxEdgeDeviceListIterator) Value() DataBoxEdgeDevice {
	if !iter.page.NotDone() {
		return DataBoxEdgeDevice{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DataBoxEdgeDeviceListIterator type.
func NewDataBoxEdgeDeviceListIterator(page DataBoxEdgeDeviceListPage) DataBoxEdgeDeviceListIterator {
	return DataBoxEdgeDeviceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dbedl DataBoxEdgeDeviceList) IsEmpty() bool {
	return dbedl.Value == nil || len(*dbedl.Value) == 0
}

// dataBoxEdgeDeviceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dbedl DataBoxEdgeDeviceList) dataBoxEdgeDeviceListPreparer(ctx context.Context) (*http.Request, error) {
	if dbedl.NextLink == nil || len(to.String(dbedl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dbedl.NextLink)))
}

// DataBoxEdgeDeviceListPage contains a page of DataBoxEdgeDevice values.
type DataBoxEdgeDeviceListPage struct {
	fn    func(context.Context, DataBoxEdgeDeviceList) (DataBoxEdgeDeviceList, error)
	dbedl DataBoxEdgeDeviceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DataBoxEdgeDeviceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataBoxEdgeDeviceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.dbedl)
	if err != nil {
		return err
	}
	page.dbedl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DataBoxEdgeDeviceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DataBoxEdgeDeviceListPage) NotDone() bool {
	return !page.dbedl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DataBoxEdgeDeviceListPage) Response() DataBoxEdgeDeviceList {
	return page.dbedl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DataBoxEdgeDeviceListPage) Values() []DataBoxEdgeDevice {
	if page.dbedl.IsEmpty() {
		return nil
	}
	return *page.dbedl.Value
}

// Creates a new instance of the DataBoxEdgeDeviceListPage type.
func NewDataBoxEdgeDeviceListPage(getNextPage func(context.Context, DataBoxEdgeDeviceList) (DataBoxEdgeDeviceList, error)) DataBoxEdgeDeviceListPage {
	return DataBoxEdgeDeviceListPage{fn: getNextPage}
}

// DataBoxEdgeDevicePatch the Data Box Edge/Gateway device patch.
type DataBoxEdgeDevicePatch struct {
	// Tags - The tags attached to the Data Box Edge/Gateway resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DataBoxEdgeDevicePatch.
func (dbedp DataBoxEdgeDevicePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dbedp.Tags != nil {
		objectMap["tags"] = dbedp.Tags
	}
	return json.Marshal(objectMap)
}

// DataBoxEdgeDeviceProperties the properties of the Data Box Edge/Gateway device.
type DataBoxEdgeDeviceProperties struct {
	// DataBoxEdgeDeviceStatus - The status of the Data Box Edge/Gateway device. Possible values include: 'ReadyToSetup', 'Online', 'Offline', 'NeedsAttention', 'Disconnected', 'PartiallyDisconnected'
	DataBoxEdgeDeviceStatus DataBoxEdgeDeviceStatus `json:"dataBoxEdgeDeviceStatus,omitempty"`
	// SerialNumber - The Serial Number of Data Box Edge/Gateway device.
	SerialNumber *string `json:"serialNumber,omitempty"`
	// Description - The Description of the Data Box Edge/Gateway device.
	Description *string `json:"description,omitempty"`
	// ModelDescription - The description of the Data Box Edge/Gateway device model.
	ModelDescription *string `json:"modelDescription,omitempty"`
	// DeviceType - The type of the Data Box Edge/Gateway device. Possible values include: 'DeviceTypeDataBoxEdgeDevice'
	DeviceType DeviceType `json:"deviceType,omitempty"`
	// FriendlyName - The Data Box Edge/Gateway device name.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// Culture - The Data Box Edge/Gateway device culture.
	Culture *string `json:"culture,omitempty"`
	// DeviceModel - The Data Box Edge/Gateway device model.
	DeviceModel *string `json:"deviceModel,omitempty"`
	// DeviceSoftwareVersion - The Data Box Edge/Gateway device software version.
	DeviceSoftwareVersion *string `json:"deviceSoftwareVersion,omitempty"`
	// DeviceLocalCapacity - The Data Box Edge/Gateway device local capacity in MB.
	DeviceLocalCapacity *int64 `json:"deviceLocalCapacity,omitempty"`
	// TimeZone - The Data Box Edge/Gateway device timezone.
	TimeZone *string `json:"timeZone,omitempty"`
	// DeviceHcsVersion - The device software version number of the device (eg: 1.2.18105.6).
	DeviceHcsVersion *string `json:"deviceHcsVersion,omitempty"`
	// ConfiguredRoleTypes - Type of compute roles configured.
	ConfiguredRoleTypes *[]RoleTypes `json:"configuredRoleTypes,omitempty"`
}

// DevicesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DevicesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DevicesCreateOrUpdateFuture) Result(client DevicesClient) (dbed DataBoxEdgeDevice, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgegateway.DevicesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("edgegateway.DevicesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if dbed.Response.Response, err = future.GetResult(sender); err == nil && dbed.Response.Response.StatusCode != http.StatusNoContent {
		dbed, err = client.CreateOrUpdateResponder(dbed.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "edgegateway.DevicesCreateOrUpdateFuture", "Result", dbed.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DevicesCreateOrUpdateSecuritySettingsFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type DevicesCreateOrUpdateSecuritySettingsFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DevicesCreateOrUpdateSecuritySettingsFuture) Result(client DevicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgegateway.DevicesCreateOrUpdateSecuritySettingsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("edgegateway.DevicesCreateOrUpdateSecuritySettingsFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DevicesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DevicesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DevicesDeleteFuture) Result(client DevicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgegateway.DevicesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("edgegateway.DevicesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DevicesDownloadUpdatesFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DevicesDownloadUpdatesFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DevicesDownloadUpdatesFuture) Result(client DevicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgegateway.DevicesDownloadUpdatesFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("edgegateway.DevicesDownloadUpdatesFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DevicesInstallUpdatesFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DevicesInstallUpdatesFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DevicesInstallUpdatesFuture) Result(client DevicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgegateway.DevicesInstallUpdatesFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("edgegateway.DevicesInstallUpdatesFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DevicesScanForUpdatesFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DevicesScanForUpdatesFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DevicesScanForUpdatesFuture) Result(client DevicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgegateway.DevicesScanForUpdatesFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("edgegateway.DevicesScanForUpdatesFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// FileEventTrigger trigger details.
type FileEventTrigger struct {
	// FileTriggerProperties - File trigger properties.
	*FileTriggerProperties `json:"properties,omitempty"`
	// ID - The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - The object name.
	Name *string `json:"name,omitempty"`
	// Type - The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindTrigger', 'KindFileEvent', 'KindPeriodicTimerEvent'
	Kind KindBasicTrigger `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for FileEventTrigger.
func (fet FileEventTrigger) MarshalJSON() ([]byte, error) {
	fet.Kind = KindFileEvent
	objectMap := make(map[string]interface{})
	if fet.FileTriggerProperties != nil {
		objectMap["properties"] = fet.FileTriggerProperties
	}
	if fet.Kind != "" {
		objectMap["kind"] = fet.Kind
	}
	if fet.ID != nil {
		objectMap["id"] = fet.ID
	}
	if fet.Name != nil {
		objectMap["name"] = fet.Name
	}
	if fet.Type != nil {
		objectMap["type"] = fet.Type
	}
	return json.Marshal(objectMap)
}

// AsFileEventTrigger is the BasicTrigger implementation for FileEventTrigger.
func (fet FileEventTrigger) AsFileEventTrigger() (*FileEventTrigger, bool) {
	return &fet, true
}

// AsPeriodicTimerEventTrigger is the BasicTrigger implementation for FileEventTrigger.
func (fet FileEventTrigger) AsPeriodicTimerEventTrigger() (*PeriodicTimerEventTrigger, bool) {
	return nil, false
}

// AsTrigger is the BasicTrigger implementation for FileEventTrigger.
func (fet FileEventTrigger) AsTrigger() (*Trigger, bool) {
	return nil, false
}

// AsBasicTrigger is the BasicTrigger implementation for FileEventTrigger.
func (fet FileEventTrigger) AsBasicTrigger() (BasicTrigger, bool) {
	return &fet, true
}

// UnmarshalJSON is the custom unmarshaler for FileEventTrigger struct.
func (fet *FileEventTrigger) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var fileTriggerProperties FileTriggerProperties
				err = json.Unmarshal(*v, &fileTriggerProperties)
				if err != nil {
					return err
				}
				fet.FileTriggerProperties = &fileTriggerProperties
			}
		case "kind":
			if v != nil {
				var kind KindBasicTrigger
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				fet.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fet.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fet.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fet.Type = &typeVar
			}
		}
	}

	return nil
}

// FileSourceInfo file source details.
type FileSourceInfo struct {
	// ShareID - File share ID.
	ShareID *string `json:"shareId,omitempty"`
}

// FileTriggerProperties file trigger properties.
type FileTriggerProperties struct {
	// SourceInfo - File event source details.
	SourceInfo *FileSourceInfo `json:"sourceInfo,omitempty"`
	// SinkInfo - Role sink info.
	SinkInfo *RoleSinkInfo `json:"sinkInfo,omitempty"`
	// CustomContextTag - A custom context tag typically used to correlate the trigger against its usage. For example, if a periodic timer trigger is intended for certain specific IoT modules in the device, the tag can be the name or the image URL of the module.
	CustomContextTag *string `json:"customContextTag,omitempty"`
}

// IoTDeviceInfo metadata of IoT device/IoT Edge device to be configured.
type IoTDeviceInfo struct {
	// DeviceID - ID of the IoT device/edge device.
	DeviceID *string `json:"deviceId,omitempty"`
	// IoTHostHub - Host name for the IoT hub associated to the device.
	IoTHostHub *string `json:"ioTHostHub,omitempty"`
	// Authentication - IoT device authentication info.
	Authentication *Authentication `json:"authentication,omitempty"`
}

// IoTRole compute role.
type IoTRole struct {
	// IoTRoleProperties - Properties specific to IoT role.
	*IoTRoleProperties `json:"properties,omitempty"`
	// ID - The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - The object name.
	Name *string `json:"name,omitempty"`
	// Type - The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindRole', 'KindIOT'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for IoTRole.
func (itr IoTRole) MarshalJSON() ([]byte, error) {
	itr.Kind = KindIOT
	objectMap := make(map[string]interface{})
	if itr.IoTRoleProperties != nil {
		objectMap["properties"] = itr.IoTRoleProperties
	}
	if itr.Kind != "" {
		objectMap["kind"] = itr.Kind
	}
	if itr.ID != nil {
		objectMap["id"] = itr.ID
	}
	if itr.Name != nil {
		objectMap["name"] = itr.Name
	}
	if itr.Type != nil {
		objectMap["type"] = itr.Type
	}
	return json.Marshal(objectMap)
}

// AsIoTRole is the BasicRole implementation for IoTRole.
func (itr IoTRole) AsIoTRole() (*IoTRole, bool) {
	return &itr, true
}

// AsRole is the BasicRole implementation for IoTRole.
func (itr IoTRole) AsRole() (*Role, bool) {
	return nil, false
}

// AsBasicRole is the BasicRole implementation for IoTRole.
func (itr IoTRole) AsBasicRole() (BasicRole, bool) {
	return &itr, true
}

// UnmarshalJSON is the custom unmarshaler for IoTRole struct.
func (itr *IoTRole) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var ioTRoleProperties IoTRoleProperties
				err = json.Unmarshal(*v, &ioTRoleProperties)
				if err != nil {
					return err
				}
				itr.IoTRoleProperties = &ioTRoleProperties
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				itr.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				itr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				itr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				itr.Type = &typeVar
			}
		}
	}

	return nil
}

// IoTRoleProperties ioT role properties.
type IoTRoleProperties struct {
	// HostPlatform - Host OS supported by the IoT role. Possible values include: 'Windows', 'Linux'
	HostPlatform PlatformType `json:"hostPlatform,omitempty"`
	// IoTDeviceDetails - IoT device metadata to which data box edge device needs to be connected.
	IoTDeviceDetails *IoTDeviceInfo `json:"ioTDeviceDetails,omitempty"`
	// IoTEdgeDeviceDetails - IoT edge device to which the IoT role needs to be configured.
	IoTEdgeDeviceDetails *IoTDeviceInfo `json:"ioTEdgeDeviceDetails,omitempty"`
	// ShareMappings - Mount points of shares in role(s).
	ShareMappings *[]MountPointMap `json:"shareMappings,omitempty"`
	// RoleStatus - Role status. Possible values include: 'RoleStatusEnabled', 'RoleStatusDisabled'
	RoleStatus RoleStatus `json:"roleStatus,omitempty"`
}

// Ipv4Config details related to the IPv4 address configuration.
type Ipv4Config struct {
	// IPAddress - The IPv4 address of the network adapter.
	IPAddress *string `json:"ipAddress,omitempty"`
	// Subnet - The IPv4 subnet of the network adapter.
	Subnet *string `json:"subnet,omitempty"`
	// Gateway - The IPv4 gateway of the network adapter.
	Gateway *string `json:"gateway,omitempty"`
}

// Ipv6Config details related to the IPv6 address configuration.
type Ipv6Config struct {
	// IPAddress - The IPv6 address of the network adapter.
	IPAddress *string `json:"ipAddress,omitempty"`
	// PrefixLength - The IPv6 prefix of the network adapter.
	PrefixLength *int32 `json:"prefixLength,omitempty"`
	// Gateway - The IPv6 gateway of the network adapter.
	Gateway *string `json:"gateway,omitempty"`
}

// Job a device job.
type Job struct {
	autorest.Response `json:"-"`
	// ID - The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - The name of the object.
	Name *string `json:"name,omitempty"`
	// Type - The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
	// Status - The current status of the job. Possible values include: 'JobStatusInvalid', 'JobStatusRunning', 'JobStatusSucceeded', 'JobStatusFailed', 'JobStatusCanceled', 'JobStatusPaused', 'JobStatusScheduled'
	Status JobStatus `json:"status,omitempty"`
	// StartTime - The UTC date and time at which the job started.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The UTC date and time at which the job completed.
	EndTime *date.Time `json:"endTime,omitempty"`
	// PercentComplete - The percentage of the job that is complete.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// Error - The error details.
	Error *JobErrorDetails `json:"error,omitempty"`
	// JobProperties - The properties of the job.
	*JobProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Job.
func (j Job) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if j.ID != nil {
		objectMap["id"] = j.ID
	}
	if j.Name != nil {
		objectMap["name"] = j.Name
	}
	if j.Type != nil {
		objectMap["type"] = j.Type
	}
	if j.Status != "" {
		objectMap["status"] = j.Status
	}
	if j.StartTime != nil {
		objectMap["startTime"] = j.StartTime
	}
	if j.EndTime != nil {
		objectMap["endTime"] = j.EndTime
	}
	if j.PercentComplete != nil {
		objectMap["percentComplete"] = j.PercentComplete
	}
	if j.Error != nil {
		objectMap["error"] = j.Error
	}
	if j.JobProperties != nil {
		objectMap["properties"] = j.JobProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Job struct.
func (j *Job) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				j.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				j.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				j.Type = &typeVar
			}
		case "status":
			if v != nil {
				var status JobStatus
				err = json.Unmarshal(*v, &status)
				if err != nil {
					return err
				}
				j.Status = status
			}
		case "startTime":
			if v != nil {
				var startTime date.Time
				err = json.Unmarshal(*v, &startTime)
				if err != nil {
					return err
				}
				j.StartTime = &startTime
			}
		case "endTime":
			if v != nil {
				var endTime date.Time
				err = json.Unmarshal(*v, &endTime)
				if err != nil {
					return err
				}
				j.EndTime = &endTime
			}
		case "percentComplete":
			if v != nil {
				var percentComplete int32
				err = json.Unmarshal(*v, &percentComplete)
				if err != nil {
					return err
				}
				j.PercentComplete = &percentComplete
			}
		case "error":
			if v != nil {
				var errorVar JobErrorDetails
				err = json.Unmarshal(*v, &errorVar)
				if err != nil {
					return err
				}
				j.Error = &errorVar
			}
		case "properties":
			if v != nil {
				var jobProperties JobProperties
				err = json.Unmarshal(*v, &jobProperties)
				if err != nil {
					return err
				}
				j.JobProperties = &jobProperties
			}
		}
	}

	return nil
}

// JobErrorDetails the job error information containing the list of job errors.
type JobErrorDetails struct {
	// ErrorDetails - The error details.
	ErrorDetails *[]JobErrorItem `json:"errorDetails,omitempty"`
	// Code - The code intended for programmatic access.
	Code *string `json:"code,omitempty"`
	// Message - The message that describes the error in detail.
	Message *string `json:"message,omitempty"`
}

// JobErrorItem the job error items.
type JobErrorItem struct {
	// Recommendations - The recommended actions.
	Recommendations *[]string `json:"recommendations,omitempty"`
	// Code - The code intended for programmatic access.
	Code *string `json:"code,omitempty"`
	// Message - The message that describes the error in detail.
	Message *string `json:"message,omitempty"`
}

// JobProperties the properties for the job.
type JobProperties struct {
	// JobType - The type of the job. Possible values include: 'JobTypeInvalid', 'JobTypeScanForUpdates', 'JobTypeDownloadUpdates', 'JobTypeInstallUpdates', 'JobTypeRefreshShare'
	JobType JobType `json:"jobType,omitempty"`
	// CurrentStage - Current stage of the update operation. Possible values include: 'UpdateOperationStageUnknown', 'UpdateOperationStageInitial', 'UpdateOperationStageScanStarted', 'UpdateOperationStageScanComplete', 'UpdateOperationStageScanFailed', 'UpdateOperationStageDownloadStarted', 'UpdateOperationStageDownloadComplete', 'UpdateOperationStageDownloadFailed', 'UpdateOperationStageInstallStarted', 'UpdateOperationStageInstallComplete', 'UpdateOperationStageInstallFailed', 'UpdateOperationStageRebootInitiated', 'UpdateOperationStageSuccess', 'UpdateOperationStageFailure', 'UpdateOperationStageRescanStarted', 'UpdateOperationStageRescanComplete', 'UpdateOperationStageRescanFailed'
	CurrentStage UpdateOperationStage `json:"currentStage,omitempty"`
	// DownloadProgress - The download progress.
	DownloadProgress *UpdateDownloadProgress `json:"downloadProgress,omitempty"`
	// InstallProgress - The install progress.
	InstallProgress *UpdateInstallProgress `json:"installProgress,omitempty"`
	// TotalRefreshErrors - Total number of errors encountered during the refresh process.
	TotalRefreshErrors *int32 `json:"totalRefreshErrors,omitempty"`
	// ErrorManifestFile - Local share/remote container relative path to the error manifest file of the refresh.
	ErrorManifestFile *string `json:"errorManifestFile,omitempty"`
	// ShareID - ARM ID of the share that was refreshed.
	ShareID *string `json:"shareId,omitempty"`
	// Folder - If only subfolders need to be refreshed, then the subfolder path inside the share. (The path is empty if there are no subfolders.)
	Folder *string `json:"folder,omitempty"`
}

// MetricDimensionV1 metric Dimension v1.
type MetricDimensionV1 struct {
	// Name - Name of the metrics dimension.
	Name *string `json:"name,omitempty"`
	// DisplayName - Display name of the metrics dimension.
	DisplayName *string `json:"displayName,omitempty"`
	// ToBeExportedForShoebox - To be exported to shoe box.
	ToBeExportedForShoebox *bool `json:"toBeExportedForShoebox,omitempty"`
}

// MetricSpecificationV1 metric specification version 1.
type MetricSpecificationV1 struct {
	// Name - Name of the metric.
	Name *string `json:"name,omitempty"`
	// DisplayName - Display name of the metric.
	DisplayName *string `json:"displayName,omitempty"`
	// DisplayDescription - Description of the metric to be displayed.
	DisplayDescription *string `json:"displayDescription,omitempty"`
	// Unit - Metric units. Possible values include: 'NotSpecified', 'Percent', 'Count', 'Seconds', 'Milliseconds', 'Bytes', 'BytesPerSecond', 'CountPerSecond'
	Unit MetricUnit `json:"unit,omitempty"`
	// AggregationType - Metric aggregation type. Possible values include: 'MetricAggregationTypeNotSpecified', 'MetricAggregationTypeNone', 'MetricAggregationTypeAverage', 'MetricAggregationTypeMinimum', 'MetricAggregationTypeMaximum', 'MetricAggregationTypeTotal', 'MetricAggregationTypeCount'
	AggregationType MetricAggregationType `json:"aggregationType,omitempty"`
	// Dimensions - Metric dimensions, other than default dimension which is resource.
	Dimensions *[]MetricDimensionV1 `json:"dimensions,omitempty"`
	// FillGapWithZero - Set true to fill the gaps with zero.
	FillGapWithZero *bool `json:"fillGapWithZero,omitempty"`
	// Category - Metric category. Possible values include: 'Capacity', 'Transaction'
	Category MetricCategory `json:"category,omitempty"`
	// ResourceIDDimensionNameOverride - Resource name override.
	ResourceIDDimensionNameOverride *string `json:"resourceIdDimensionNameOverride,omitempty"`
	// SupportedTimeGrainTypes - Support granularity of metrics.
	SupportedTimeGrainTypes *[]TimeGrain `json:"supportedTimeGrainTypes,omitempty"`
	// SupportedAggregationTypes - Support metric aggregation type.
	SupportedAggregationTypes *[]MetricAggregationType `json:"supportedAggregationTypes,omitempty"`
}

// MountPointMap the share mount point.
type MountPointMap struct {
	// ShareID - ID of the share mounted to the role VM.
	ShareID *string `json:"shareId,omitempty"`
	// RoleID - ID of the role to which share is mounted.
	RoleID *string `json:"roleId,omitempty"`
	// MountPoint - Mount point for the share.
	MountPoint *string `json:"mountPoint,omitempty"`
	// RoleType - Role type. Possible values include: 'IOT', 'ASA', 'Functions', 'Cognitive'
	RoleType RoleTypes `json:"roleType,omitempty"`
}

// NetworkAdapter represents the networkAdapter on a device.
type NetworkAdapter struct {
	// AdapterID - Instance ID of network adapter.
	AdapterID *string `json:"adapterId,omitempty"`
	// AdapterPosition - Hardware position of network adapter.
	AdapterPosition *NetworkAdapterPosition `json:"adapterPosition,omitempty"`
	// Index - Logical index of the adapter.
	Index *int32 `json:"index,omitempty"`
	// NodeID - Node ID of the network adapter.
	NodeID *string `json:"nodeId,omitempty"`
	// NetworkAdapterName - Network adapter name.
	NetworkAdapterName *string `json:"networkAdapterName,omitempty"`
	// Label - Hardware label for the adapter.
	Label *string `json:"label,omitempty"`
	// MacAddress - MAC address.
	MacAddress *string `json:"macAddress,omitempty"`
	// LinkSpeed - Link speed.
	LinkSpeed *int64 `json:"linkSpeed,omitempty"`
	// Status - Value indicating whether this adapter is valid. Possible values include: 'Inactive', 'Active'
	Status NetworkAdapterStatus `json:"status,omitempty"`
	// RdmaStatus - Value indicating whether this adapter is RDMA capable. Possible values include: 'Incapable', 'Capable'
	RdmaStatus NetworkAdapterRDMAStatus `json:"rdmaStatus,omitempty"`
	// DhcpStatus - Value indicating whether this adapter has DHCP enabled. Possible values include: 'NetworkAdapterDHCPStatusDisabled', 'NetworkAdapterDHCPStatusEnabled'
	DhcpStatus NetworkAdapterDHCPStatus `json:"dhcpStatus,omitempty"`
	// Ipv4Configuration - The IPv4 configuration of the network adapter.
	Ipv4Configuration *Ipv4Config `json:"ipv4Configuration,omitempty"`
	// Ipv6Configuration - The IPv6 configuration of the network adapter.
	Ipv6Configuration *Ipv6Config `json:"ipv6Configuration,omitempty"`
	// Ipv6LinkLocalAddress - The IPv6 local address.
	Ipv6LinkLocalAddress *string `json:"ipv6LinkLocalAddress,omitempty"`
	// DNSServers - The list of DNS Servers of the device.
	DNSServers *[]string `json:"dnsServers,omitempty"`
}

// NetworkAdapterPosition the network adapter position.
type NetworkAdapterPosition struct {
	// NetworkGroup - The network group. Possible values include: 'NetworkGroupNone', 'NetworkGroupNonRDMA', 'NetworkGroupRDMA'
	NetworkGroup NetworkGroup `json:"networkGroup,omitempty"`
	// Port - The port.
	Port *int32 `json:"port,omitempty"`
}

// NetworkSettings the network settings of a device.
type NetworkSettings struct {
	autorest.Response `json:"-"`
	// NetworkSettingsProperties - The properties of network settings of a device.
	*NetworkSettingsProperties `json:"properties,omitempty"`
	// ID - The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - The object name.
	Name *string `json:"name,omitempty"`
	// Type - The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for NetworkSettings.
func (ns NetworkSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ns.NetworkSettingsProperties != nil {
		objectMap["properties"] = ns.NetworkSettingsProperties
	}
	if ns.ID != nil {
		objectMap["id"] = ns.ID
	}
	if ns.Name != nil {
		objectMap["name"] = ns.Name
	}
	if ns.Type != nil {
		objectMap["type"] = ns.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for NetworkSettings struct.
func (ns *NetworkSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var networkSettingsProperties NetworkSettingsProperties
				err = json.Unmarshal(*v, &networkSettingsProperties)
				if err != nil {
					return err
				}
				ns.NetworkSettingsProperties = &networkSettingsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ns.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ns.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ns.Type = &typeVar
			}
		}
	}

	return nil
}

// NetworkSettingsProperties the properties of network settings.
type NetworkSettingsProperties struct {
	// NetworkAdapters - The network adapter list on the device.
	NetworkAdapters *[]NetworkAdapter `json:"networkAdapters,omitempty"`
}

// Operation operations.
type Operation struct {
	// Name - Name of the operation.
	Name *string `json:"name,omitempty"`
	// Display - Properties displayed for the operation.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - Origin of the operation.
	Origin *string `json:"origin,omitempty"`
	// OperationProperties - Operation properties.
	*OperationProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Name != nil {
		objectMap["name"] = o.Name
	}
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	if o.Origin != nil {
		objectMap["origin"] = o.Origin
	}
	if o.OperationProperties != nil {
		objectMap["properties"] = o.OperationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Operation struct.
func (o *Operation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				o.Name = &name
			}
		case "display":
			if v != nil {
				var display OperationDisplay
				err = json.Unmarshal(*v, &display)
				if err != nil {
					return err
				}
				o.Display = &display
			}
		case "origin":
			if v != nil {
				var origin string
				err = json.Unmarshal(*v, &origin)
				if err != nil {
					return err
				}
				o.Origin = &origin
			}
		case "properties":
			if v != nil {
				var operationProperties OperationProperties
				err = json.Unmarshal(*v, &operationProperties)
				if err != nil {
					return err
				}
				o.OperationProperties = &operationProperties
			}
		}
	}

	return nil
}

// OperationDisplay operation display properties.
type OperationDisplay struct {
	// Provider - Provider name.
	Provider *string `json:"provider,omitempty"`
	// Resource - The type of resource in which the operation is performed.
	Resource *string `json:"resource,omitempty"`
	// Operation - Operation to be performed on the resource.
	Operation *string `json:"operation,omitempty"`
	// Description - Description of the operation to be performed.
	Description *string `json:"description,omitempty"`
}

// OperationProperties operation properties.
type OperationProperties struct {
	// ServiceSpecification - Service specification.
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// OperationsList the list of operations used for the discovery of available provider operations.
type OperationsList struct {
	autorest.Response `json:"-"`
	// Value - The value.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationsListIterator provides access to a complete listing of Operation values.
type OperationsListIterator struct {
	i    int
	page OperationsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationsListIterator) Response() OperationsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationsListIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationsListIterator type.
func NewOperationsListIterator(page OperationsListPage) OperationsListIterator {
	return OperationsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ol OperationsList) IsEmpty() bool {
	return ol.Value == nil || len(*ol.Value) == 0
}

// operationsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ol OperationsList) operationsListPreparer(ctx context.Context) (*http.Request, error) {
	if ol.NextLink == nil || len(to.String(ol.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ol.NextLink)))
}

// OperationsListPage contains a page of Operation values.
type OperationsListPage struct {
	fn func(context.Context, OperationsList) (OperationsList, error)
	ol OperationsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ol)
	if err != nil {
		return err
	}
	page.ol = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationsListPage) NotDone() bool {
	return !page.ol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationsListPage) Response() OperationsList {
	return page.ol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationsListPage) Values() []Operation {
	if page.ol.IsEmpty() {
		return nil
	}
	return *page.ol.Value
}

// Creates a new instance of the OperationsListPage type.
func NewOperationsListPage(getNextPage func(context.Context, OperationsList) (OperationsList, error)) OperationsListPage {
	return OperationsListPage{fn: getNextPage}
}

// Order the order details.
type Order struct {
	autorest.Response `json:"-"`
	// OrderProperties - The order properties.
	*OrderProperties `json:"properties,omitempty"`
	// ID - The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - The object name.
	Name *string `json:"name,omitempty"`
	// Type - The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Order.
func (o Order) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.OrderProperties != nil {
		objectMap["properties"] = o.OrderProperties
	}
	if o.ID != nil {
		objectMap["id"] = o.ID
	}
	if o.Name != nil {
		objectMap["name"] = o.Name
	}
	if o.Type != nil {
		objectMap["type"] = o.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Order struct.
func (o *Order) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var orderProperties OrderProperties
				err = json.Unmarshal(*v, &orderProperties)
				if err != nil {
					return err
				}
				o.OrderProperties = &orderProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				o.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				o.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				o.Type = &typeVar
			}
		}
	}

	return nil
}

// OrderList list of order entities.
type OrderList struct {
	autorest.Response `json:"-"`
	// Value - The list of orders.
	Value *[]Order `json:"value,omitempty"`
	// NextLink - Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// OrderListIterator provides access to a complete listing of Order values.
type OrderListIterator struct {
	i    int
	page OrderListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OrderListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OrderListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OrderListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OrderListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OrderListIterator) Response() OrderList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OrderListIterator) Value() Order {
	if !iter.page.NotDone() {
		return Order{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OrderListIterator type.
func NewOrderListIterator(page OrderListPage) OrderListIterator {
	return OrderListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ol OrderList) IsEmpty() bool {
	return ol.Value == nil || len(*ol.Value) == 0
}

// orderListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ol OrderList) orderListPreparer(ctx context.Context) (*http.Request, error) {
	if ol.NextLink == nil || len(to.String(ol.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ol.NextLink)))
}

// OrderListPage contains a page of Order values.
type OrderListPage struct {
	fn func(context.Context, OrderList) (OrderList, error)
	ol OrderList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OrderListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OrderListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ol)
	if err != nil {
		return err
	}
	page.ol = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OrderListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OrderListPage) NotDone() bool {
	return !page.ol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OrderListPage) Response() OrderList {
	return page.ol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OrderListPage) Values() []Order {
	if page.ol.IsEmpty() {
		return nil
	}
	return *page.ol.Value
}

// Creates a new instance of the OrderListPage type.
func NewOrderListPage(getNextPage func(context.Context, OrderList) (OrderList, error)) OrderListPage {
	return OrderListPage{fn: getNextPage}
}

// OrderProperties order properties.
type OrderProperties struct {
	// ContactInformation - The contact details.
	ContactInformation *ContactDetails `json:"contactInformation,omitempty"`
	// ShippingAddress - The shipping address.
	ShippingAddress *Address `json:"shippingAddress,omitempty"`
	// CurrentStatus - Current status of the order.
	CurrentStatus *OrderStatus `json:"currentStatus,omitempty"`
	// OrderHistory - List of status changes in the order.
	OrderHistory *[]OrderStatus `json:"orderHistory,omitempty"`
	// SerialNumber - Serial number of the device.
	SerialNumber *string `json:"serialNumber,omitempty"`
	// DeliveryTrackingInfo - Tracking information for the package delivered to the customer whether it has an original or a replacement device.
	DeliveryTrackingInfo *[]TrackingInfo `json:"deliveryTrackingInfo,omitempty"`
	// ReturnTrackingInfo - Tracking information for the package returned from the customer whether it has an original or a replacement device.
	ReturnTrackingInfo *[]TrackingInfo `json:"returnTrackingInfo,omitempty"`
}

// OrdersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type OrdersCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *OrdersCreateOrUpdateFuture) Result(client OrdersClient) (o Order, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgegateway.OrdersCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("edgegateway.OrdersCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if o.Response.Response, err = future.GetResult(sender); err == nil && o.Response.Response.StatusCode != http.StatusNoContent {
		o, err = client.CreateOrUpdateResponder(o.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "edgegateway.OrdersCreateOrUpdateFuture", "Result", o.Response.Response, "Failure responding to request")
		}
	}
	return
}

// OrdersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type OrdersDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *OrdersDeleteFuture) Result(client OrdersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgegateway.OrdersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("edgegateway.OrdersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// OrderStatus represents a single status change.
type OrderStatus struct {
	// Status - Status of the order as per the allowed status types. Possible values include: 'Untracked', 'AwaitingFulfilment', 'AwaitingPreparation', 'AwaitingShipment', 'Shipped', 'Arriving', 'Delivered', 'ReplacementRequested', 'LostDevice', 'Declined', 'ReturnInitiated', 'AwaitingReturnShipment', 'ShippedBack', 'CollectedAtMicrosoft'
	Status OrderState `json:"status,omitempty"`
	// UpdateDateTime - Time of status update.
	UpdateDateTime *date.Time `json:"updateDateTime,omitempty"`
	// Comments - Comments related to this status change.
	Comments *string `json:"comments,omitempty"`
}

// PeriodicTimerEventTrigger trigger details.
type PeriodicTimerEventTrigger struct {
	// PeriodicTimerProperties - Periodic timer trigger properties.
	*PeriodicTimerProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindTrigger', 'KindFileEvent', 'KindPeriodicTimerEvent'
	Kind KindBasicTrigger `json:"kind,omitempty"`
	// ID - The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - The object name.
	Name *string `json:"name,omitempty"`
	// Type - The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PeriodicTimerEventTrigger.
func (ptet PeriodicTimerEventTrigger) MarshalJSON() ([]byte, error) {
	ptet.Kind = KindPeriodicTimerEvent
	objectMap := make(map[string]interface{})
	if ptet.PeriodicTimerProperties != nil {
		objectMap["properties"] = ptet.PeriodicTimerProperties
	}
	if ptet.Kind != "" {
		objectMap["kind"] = ptet.Kind
	}
	if ptet.ID != nil {
		objectMap["id"] = ptet.ID
	}
	if ptet.Name != nil {
		objectMap["name"] = ptet.Name
	}
	if ptet.Type != nil {
		objectMap["type"] = ptet.Type
	}
	return json.Marshal(objectMap)
}

// AsFileEventTrigger is the BasicTrigger implementation for PeriodicTimerEventTrigger.
func (ptet PeriodicTimerEventTrigger) AsFileEventTrigger() (*FileEventTrigger, bool) {
	return nil, false
}

// AsPeriodicTimerEventTrigger is the BasicTrigger implementation for PeriodicTimerEventTrigger.
func (ptet PeriodicTimerEventTrigger) AsPeriodicTimerEventTrigger() (*PeriodicTimerEventTrigger, bool) {
	return &ptet, true
}

// AsTrigger is the BasicTrigger implementation for PeriodicTimerEventTrigger.
func (ptet PeriodicTimerEventTrigger) AsTrigger() (*Trigger, bool) {
	return nil, false
}

// AsBasicTrigger is the BasicTrigger implementation for PeriodicTimerEventTrigger.
func (ptet PeriodicTimerEventTrigger) AsBasicTrigger() (BasicTrigger, bool) {
	return &ptet, true
}

// UnmarshalJSON is the custom unmarshaler for PeriodicTimerEventTrigger struct.
func (ptet *PeriodicTimerEventTrigger) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var periodicTimerProperties PeriodicTimerProperties
				err = json.Unmarshal(*v, &periodicTimerProperties)
				if err != nil {
					return err
				}
				ptet.PeriodicTimerProperties = &periodicTimerProperties
			}
		case "kind":
			if v != nil {
				var kind KindBasicTrigger
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ptet.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ptet.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ptet.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ptet.Type = &typeVar
			}
		}
	}

	return nil
}

// PeriodicTimerProperties periodic timer trigger properties.
type PeriodicTimerProperties struct {
	// SourceInfo - Periodic timer details.
	SourceInfo *PeriodicTimerSourceInfo `json:"sourceInfo,omitempty"`
	// SinkInfo - Role Sink information.
	SinkInfo *RoleSinkInfo `json:"sinkInfo,omitempty"`
	// CustomContextTag - A custom context tag typically used to correlate the trigger against its usage. For example, if a periodic timer trigger is intended for certain specific IoT modules in the device, the tag can be the name or the image URL of the module.
	CustomContextTag *string `json:"customContextTag,omitempty"`
}

// PeriodicTimerSourceInfo periodic timer event source.
type PeriodicTimerSourceInfo struct {
	// StartTime - The time of the day that results in a valid trigger. Schedule is computed with reference to the time specified.
	StartTime *date.Time `json:"startTime,omitempty"`
	// Schedule - Periodic frequency at which timer event needs to be raised. Supports daily, hourly, minutes, and seconds.
	Schedule *string `json:"schedule,omitempty"`
	// Topic - Topic where periodic events are published to IoT device.
	Topic *string `json:"topic,omitempty"`
}

// RawCertificateData raw Certificate Data.
type RawCertificateData struct {
	// AuthenticationType - The authentication type. Possible values include: 'Invalid', 'AzureActiveDirectory'
	AuthenticationType AuthenticationType `json:"authenticationType,omitempty"`
	// Certificate - The base64 encoded certificate raw data.
	Certificate *string `json:"certificate,omitempty"`
}

// RefreshDetails fields for tracking refresh job on the share.
type RefreshDetails struct {
	// InProgressRefreshJobID - If a refresh share job is currently in progress on this share, this field indicates the ARM resource ID of that job. The field is empty if no job is in progress.
	InProgressRefreshJobID *string `json:"inProgressRefreshJobId,omitempty"`
	// LastCompletedRefreshJobTimeInUTC - Indicates the completed time for the last refresh job on this particular share, if any.This could be a failed job or a successful job.
	LastCompletedRefreshJobTimeInUTC *date.Time `json:"lastCompletedRefreshJobTimeInUTC,omitempty"`
	// ErrorManifestFile - Indicates the relative path of the error xml for the last refresh job on this particular share, if any. This could be a failed job or a successful job.
	ErrorManifestFile *string `json:"errorManifestFile,omitempty"`
	// LastJob - Indicates the id of the last refresh job on this particular share,if any. This could be a failed job or a successful job.
	LastJob *string `json:"lastJob,omitempty"`
}

// BasicRole compute role.
type BasicRole interface {
	AsIoTRole() (*IoTRole, bool)
	AsRole() (*Role, bool)
}

// Role compute role.
type Role struct {
	autorest.Response `json:"-"`
	// Kind - Possible values include: 'KindRole', 'KindIOT'
	Kind Kind `json:"kind,omitempty"`
	// ID - The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - The object name.
	Name *string `json:"name,omitempty"`
	// Type - The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

func unmarshalBasicRole(body []byte) (BasicRole, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindIOT):
		var itr IoTRole
		err := json.Unmarshal(body, &itr)
		return itr, err
	default:
		var r Role
		err := json.Unmarshal(body, &r)
		return r, err
	}
}
func unmarshalBasicRoleArray(body []byte) ([]BasicRole, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rArray := make([]BasicRole, len(rawMessages))

	for index, rawMessage := range rawMessages {
		r, err := unmarshalBasicRole(*rawMessage)
		if err != nil {
			return nil, err
		}
		rArray[index] = r
	}
	return rArray, nil
}

// MarshalJSON is the custom marshaler for Role.
func (r Role) MarshalJSON() ([]byte, error) {
	r.Kind = KindRole
	objectMap := make(map[string]interface{})
	if r.Kind != "" {
		objectMap["kind"] = r.Kind
	}
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	if r.Name != nil {
		objectMap["name"] = r.Name
	}
	if r.Type != nil {
		objectMap["type"] = r.Type
	}
	return json.Marshal(objectMap)
}

// AsIoTRole is the BasicRole implementation for Role.
func (r Role) AsIoTRole() (*IoTRole, bool) {
	return nil, false
}

// AsRole is the BasicRole implementation for Role.
func (r Role) AsRole() (*Role, bool) {
	return &r, true
}

// AsBasicRole is the BasicRole implementation for Role.
func (r Role) AsBasicRole() (BasicRole, bool) {
	return &r, true
}

// RoleList collection of all the roles on the Data Box Edge device.
type RoleList struct {
	autorest.Response `json:"-"`
	// Value - The Value.
	Value *[]BasicRole `json:"value,omitempty"`
	// NextLink - Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for RoleList struct.
func (rl *RoleList) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "value":
			if v != nil {
				value, err := unmarshalBasicRoleArray(*v)
				if err != nil {
					return err
				}
				rl.Value = &value
			}
		case "nextLink":
			if v != nil {
				var nextLink string
				err = json.Unmarshal(*v, &nextLink)
				if err != nil {
					return err
				}
				rl.NextLink = &nextLink
			}
		}
	}

	return nil
}

// RoleListIterator provides access to a complete listing of Role values.
type RoleListIterator struct {
	i    int
	page RoleListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RoleListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RoleListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RoleListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RoleListIterator) Response() RoleList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RoleListIterator) Value() BasicRole {
	if !iter.page.NotDone() {
		return Role{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RoleListIterator type.
func NewRoleListIterator(page RoleListPage) RoleListIterator {
	return RoleListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rl RoleList) IsEmpty() bool {
	return rl.Value == nil || len(*rl.Value) == 0
}

// roleListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rl RoleList) roleListPreparer(ctx context.Context) (*http.Request, error) {
	if rl.NextLink == nil || len(to.String(rl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rl.NextLink)))
}

// RoleListPage contains a page of BasicRole values.
type RoleListPage struct {
	fn func(context.Context, RoleList) (RoleList, error)
	rl RoleList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RoleListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.rl)
	if err != nil {
		return err
	}
	page.rl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RoleListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RoleListPage) NotDone() bool {
	return !page.rl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RoleListPage) Response() RoleList {
	return page.rl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RoleListPage) Values() []BasicRole {
	if page.rl.IsEmpty() {
		return nil
	}
	return *page.rl.Value
}

// Creates a new instance of the RoleListPage type.
func NewRoleListPage(getNextPage func(context.Context, RoleList) (RoleList, error)) RoleListPage {
	return RoleListPage{fn: getNextPage}
}

// RoleModel ...
type RoleModel struct {
	autorest.Response `json:"-"`
	Value             BasicRole `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for RoleModel struct.
func (rm *RoleModel) UnmarshalJSON(body []byte) error {
	r, err := unmarshalBasicRole(body)
	if err != nil {
		return err
	}
	rm.Value = r

	return nil
}

// RolesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RolesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *RolesCreateOrUpdateFuture) Result(client RolesClient) (rm RoleModel, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgegateway.RolesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("edgegateway.RolesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rm.Response.Response, err = future.GetResult(sender); err == nil && rm.Response.Response.StatusCode != http.StatusNoContent {
		rm, err = client.CreateOrUpdateResponder(rm.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "edgegateway.RolesCreateOrUpdateFuture", "Result", rm.Response.Response, "Failure responding to request")
		}
	}
	return
}

// RolesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type RolesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *RolesDeleteFuture) Result(client RolesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgegateway.RolesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("edgegateway.RolesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// RoleSinkInfo compute role against which events will be raised.
type RoleSinkInfo struct {
	// RoleID - Compute role ID.
	RoleID *string `json:"roleId,omitempty"`
}

// SecuritySettings the security settings of a device.
type SecuritySettings struct {
	// SecuritySettingsProperties - Properties of the security settings.
	*SecuritySettingsProperties `json:"properties,omitempty"`
	// ID - The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - The object name.
	Name *string `json:"name,omitempty"`
	// Type - The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SecuritySettings.
func (ss SecuritySettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ss.SecuritySettingsProperties != nil {
		objectMap["properties"] = ss.SecuritySettingsProperties
	}
	if ss.ID != nil {
		objectMap["id"] = ss.ID
	}
	if ss.Name != nil {
		objectMap["name"] = ss.Name
	}
	if ss.Type != nil {
		objectMap["type"] = ss.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SecuritySettings struct.
func (ss *SecuritySettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var securitySettingsProperties SecuritySettingsProperties
				err = json.Unmarshal(*v, &securitySettingsProperties)
				if err != nil {
					return err
				}
				ss.SecuritySettingsProperties = &securitySettingsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ss.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ss.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ss.Type = &typeVar
			}
		}
	}

	return nil
}

// SecuritySettingsProperties the properties of security settings.
type SecuritySettingsProperties struct {
	// DeviceAdminPassword - Device administrator password as an encrypted string (encrypted using RSA PKCS #1) is used to sign into the  local web UI of the device. The Actual password should have at least 8 characters that are a combination of  uppercase, lowercase, numeric, and special characters.
	DeviceAdminPassword *AsymmetricEncryptedSecret `json:"deviceAdminPassword,omitempty"`
}

// ServiceSpecification service specification.
type ServiceSpecification struct {
	// MetricSpecifications - Metric specification as defined by shoebox.
	MetricSpecifications *[]MetricSpecificationV1 `json:"metricSpecifications,omitempty"`
}

// Share represents a share on the  Data Box Edge/Gateway device.
type Share struct {
	autorest.Response `json:"-"`
	// ShareProperties - The share properties.
	*ShareProperties `json:"properties,omitempty"`
	// ID - The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - The object name.
	Name *string `json:"name,omitempty"`
	// Type - The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Share.
func (s Share) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.ShareProperties != nil {
		objectMap["properties"] = s.ShareProperties
	}
	if s.ID != nil {
		objectMap["id"] = s.ID
	}
	if s.Name != nil {
		objectMap["name"] = s.Name
	}
	if s.Type != nil {
		objectMap["type"] = s.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Share struct.
func (s *Share) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var shareProperties ShareProperties
				err = json.Unmarshal(*v, &shareProperties)
				if err != nil {
					return err
				}
				s.ShareProperties = &shareProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				s.Type = &typeVar
			}
		}
	}

	return nil
}

// ShareAccessRight specifies the mapping between this particular user and the type of access he has on
// shares on this device.
type ShareAccessRight struct {
	// ShareID - The share ID.
	ShareID *string `json:"shareId,omitempty"`
	// AccessType - Type of access to be allowed on the share for this user. Possible values include: 'Change', 'Read', 'Custom'
	AccessType ShareAccessType `json:"accessType,omitempty"`
}

// ShareList collection of all the shares on the Data Box Edge/Gateway device.
type ShareList struct {
	autorest.Response `json:"-"`
	// Value - The list of shares.
	Value *[]Share `json:"value,omitempty"`
	// NextLink - Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ShareListIterator provides access to a complete listing of Share values.
type ShareListIterator struct {
	i    int
	page ShareListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ShareListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ShareListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ShareListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ShareListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ShareListIterator) Response() ShareList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ShareListIterator) Value() Share {
	if !iter.page.NotDone() {
		return Share{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ShareListIterator type.
func NewShareListIterator(page ShareListPage) ShareListIterator {
	return ShareListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sl ShareList) IsEmpty() bool {
	return sl.Value == nil || len(*sl.Value) == 0
}

// shareListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sl ShareList) shareListPreparer(ctx context.Context) (*http.Request, error) {
	if sl.NextLink == nil || len(to.String(sl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sl.NextLink)))
}

// ShareListPage contains a page of Share values.
type ShareListPage struct {
	fn func(context.Context, ShareList) (ShareList, error)
	sl ShareList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ShareListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ShareListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.sl)
	if err != nil {
		return err
	}
	page.sl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ShareListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ShareListPage) NotDone() bool {
	return !page.sl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ShareListPage) Response() ShareList {
	return page.sl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ShareListPage) Values() []Share {
	if page.sl.IsEmpty() {
		return nil
	}
	return *page.sl.Value
}

// Creates a new instance of the ShareListPage type.
func NewShareListPage(getNextPage func(context.Context, ShareList) (ShareList, error)) ShareListPage {
	return ShareListPage{fn: getNextPage}
}

// ShareProperties the share properties.
type ShareProperties struct {
	// Description - Description for the share.
	Description *string `json:"description,omitempty"`
	// ShareStatus - Current status of the share. Possible values include: 'ShareStatusOnline', 'ShareStatusOffline'
	ShareStatus ShareStatus `json:"shareStatus,omitempty"`
	// MonitoringStatus - Current monitoring status of the share. Possible values include: 'Enabled', 'Disabled'
	MonitoringStatus MonitoringStatus `json:"monitoringStatus,omitempty"`
	// AzureContainerInfo - Azure container mapping for the share.
	AzureContainerInfo *AzureContainerInfo `json:"azureContainerInfo,omitempty"`
	// AccessProtocol - Access protocol to be used by the share. Possible values include: 'SMB', 'NFS'
	AccessProtocol ShareAccessProtocol `json:"accessProtocol,omitempty"`
	// UserAccessRights - Mapping of users and corresponding access rights on the share (required for SMB protocol).
	UserAccessRights *[]UserAccessRight `json:"userAccessRights,omitempty"`
	// ClientAccessRights - List of IP addresses and corresponding access rights on the share(required for NFS protocol).
	ClientAccessRights *[]ClientAccessRight `json:"clientAccessRights,omitempty"`
	// RefreshDetails - Details of the refresh job on this share.
	RefreshDetails *RefreshDetails `json:"refreshDetails,omitempty"`
	// ShareMappings - Share mount point to the role.
	ShareMappings *[]MountPointMap `json:"shareMappings,omitempty"`
	// DataPolicy - Data policy of the share. Possible values include: 'Cloud', 'Local'
	DataPolicy DataPolicy `json:"dataPolicy,omitempty"`
}

// SharesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SharesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SharesCreateOrUpdateFuture) Result(client SharesClient) (s Share, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgegateway.SharesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("edgegateway.SharesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if s.Response.Response, err = future.GetResult(sender); err == nil && s.Response.Response.StatusCode != http.StatusNoContent {
		s, err = client.CreateOrUpdateResponder(s.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "edgegateway.SharesCreateOrUpdateFuture", "Result", s.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SharesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type SharesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SharesDeleteFuture) Result(client SharesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgegateway.SharesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("edgegateway.SharesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SharesRefreshFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SharesRefreshFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SharesRefreshFuture) Result(client SharesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgegateway.SharesRefreshFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("edgegateway.SharesRefreshFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Sku the SKU type.
type Sku struct {
	// Name - SKU name. Possible values include: 'Gateway', 'Edge'
	Name SkuName `json:"name,omitempty"`
	// Tier - The SKU tier. This is based on the SKU name. Possible values include: 'Standard'
	Tier SkuTier `json:"tier,omitempty"`
}

// StorageAccountCredential the storage account credential.
type StorageAccountCredential struct {
	autorest.Response `json:"-"`
	// StorageAccountCredentialProperties - The storage account credential properties.
	*StorageAccountCredentialProperties `json:"properties,omitempty"`
	// ID - The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - The object name.
	Name *string `json:"name,omitempty"`
	// Type - The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for StorageAccountCredential.
func (sac StorageAccountCredential) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sac.StorageAccountCredentialProperties != nil {
		objectMap["properties"] = sac.StorageAccountCredentialProperties
	}
	if sac.ID != nil {
		objectMap["id"] = sac.ID
	}
	if sac.Name != nil {
		objectMap["name"] = sac.Name
	}
	if sac.Type != nil {
		objectMap["type"] = sac.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for StorageAccountCredential struct.
func (sac *StorageAccountCredential) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var storageAccountCredentialProperties StorageAccountCredentialProperties
				err = json.Unmarshal(*v, &storageAccountCredentialProperties)
				if err != nil {
					return err
				}
				sac.StorageAccountCredentialProperties = &storageAccountCredentialProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sac.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sac.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sac.Type = &typeVar
			}
		}
	}

	return nil
}

// StorageAccountCredentialList the collection of storage account credentials.
type StorageAccountCredentialList struct {
	autorest.Response `json:"-"`
	// Value - The value.
	Value *[]StorageAccountCredential `json:"value,omitempty"`
	// NextLink - Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// StorageAccountCredentialListIterator provides access to a complete listing of StorageAccountCredential
// values.
type StorageAccountCredentialListIterator struct {
	i    int
	page StorageAccountCredentialListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *StorageAccountCredentialListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StorageAccountCredentialListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *StorageAccountCredentialListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter StorageAccountCredentialListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter StorageAccountCredentialListIterator) Response() StorageAccountCredentialList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter StorageAccountCredentialListIterator) Value() StorageAccountCredential {
	if !iter.page.NotDone() {
		return StorageAccountCredential{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the StorageAccountCredentialListIterator type.
func NewStorageAccountCredentialListIterator(page StorageAccountCredentialListPage) StorageAccountCredentialListIterator {
	return StorageAccountCredentialListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sacl StorageAccountCredentialList) IsEmpty() bool {
	return sacl.Value == nil || len(*sacl.Value) == 0
}

// storageAccountCredentialListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sacl StorageAccountCredentialList) storageAccountCredentialListPreparer(ctx context.Context) (*http.Request, error) {
	if sacl.NextLink == nil || len(to.String(sacl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sacl.NextLink)))
}

// StorageAccountCredentialListPage contains a page of StorageAccountCredential values.
type StorageAccountCredentialListPage struct {
	fn   func(context.Context, StorageAccountCredentialList) (StorageAccountCredentialList, error)
	sacl StorageAccountCredentialList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *StorageAccountCredentialListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StorageAccountCredentialListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.sacl)
	if err != nil {
		return err
	}
	page.sacl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *StorageAccountCredentialListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page StorageAccountCredentialListPage) NotDone() bool {
	return !page.sacl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page StorageAccountCredentialListPage) Response() StorageAccountCredentialList {
	return page.sacl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page StorageAccountCredentialListPage) Values() []StorageAccountCredential {
	if page.sacl.IsEmpty() {
		return nil
	}
	return *page.sacl.Value
}

// Creates a new instance of the StorageAccountCredentialListPage type.
func NewStorageAccountCredentialListPage(getNextPage func(context.Context, StorageAccountCredentialList) (StorageAccountCredentialList, error)) StorageAccountCredentialListPage {
	return StorageAccountCredentialListPage{fn: getNextPage}
}

// StorageAccountCredentialProperties the storage account credential properties.
type StorageAccountCredentialProperties struct {
	// Alias - Alias for the storage account.
	Alias *string `json:"alias,omitempty"`
	// UserName - Username for the storage account.
	UserName *string `json:"userName,omitempty"`
	// AccountKey - Encrypted storage key.
	AccountKey *AsymmetricEncryptedSecret `json:"accountKey,omitempty"`
	// ConnectionString - Connection string for the storage account. Use this string if username and account key are not specified.
	ConnectionString *string `json:"connectionString,omitempty"`
	// SslStatus - Signifies whether SSL needs to be enabled or not. Possible values include: 'SSLStatusEnabled', 'SSLStatusDisabled'
	SslStatus SSLStatus `json:"sslStatus,omitempty"`
	// BlobDomainName - Blob end point for private clouds.
	BlobDomainName *string `json:"blobDomainName,omitempty"`
	// AccountType - Type of storage accessed on the storage account. Possible values include: 'GeneralPurposeStorage', 'BlobStorage'
	AccountType AccountType `json:"accountType,omitempty"`
}

// StorageAccountCredentialsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type StorageAccountCredentialsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *StorageAccountCredentialsCreateOrUpdateFuture) Result(client StorageAccountCredentialsClient) (sac StorageAccountCredential, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgegateway.StorageAccountCredentialsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("edgegateway.StorageAccountCredentialsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sac.Response.Response, err = future.GetResult(sender); err == nil && sac.Response.Response.StatusCode != http.StatusNoContent {
		sac, err = client.CreateOrUpdateResponder(sac.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "edgegateway.StorageAccountCredentialsCreateOrUpdateFuture", "Result", sac.Response.Response, "Failure responding to request")
		}
	}
	return
}

// StorageAccountCredentialsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type StorageAccountCredentialsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *StorageAccountCredentialsDeleteFuture) Result(client StorageAccountCredentialsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgegateway.StorageAccountCredentialsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("edgegateway.StorageAccountCredentialsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SymmetricKey symmetric key for authentication.
type SymmetricKey struct {
	// ConnectionString - Connection string based on the symmetric key.
	ConnectionString *AsymmetricEncryptedSecret `json:"connectionString,omitempty"`
}

// TrackingInfo tracking courier information.
type TrackingInfo struct {
	// SerialNumber - Serial number of the device being tracked.
	SerialNumber *string `json:"serialNumber,omitempty"`
	// CarrierName - Name of the carrier used in the delivery.
	CarrierName *string `json:"carrierName,omitempty"`
	// TrackingID - Tracking ID of the shipment.
	TrackingID *string `json:"trackingId,omitempty"`
	// TrackingURL - Tracking URL of the shipment.
	TrackingURL *string `json:"trackingUrl,omitempty"`
}

// BasicTrigger trigger details.
type BasicTrigger interface {
	AsFileEventTrigger() (*FileEventTrigger, bool)
	AsPeriodicTimerEventTrigger() (*PeriodicTimerEventTrigger, bool)
	AsTrigger() (*Trigger, bool)
}

// Trigger trigger details.
type Trigger struct {
	autorest.Response `json:"-"`
	// Kind - Possible values include: 'KindTrigger', 'KindFileEvent', 'KindPeriodicTimerEvent'
	Kind KindBasicTrigger `json:"kind,omitempty"`
	// ID - The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - The object name.
	Name *string `json:"name,omitempty"`
	// Type - The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

func unmarshalBasicTrigger(body []byte) (BasicTrigger, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindFileEvent):
		var fet FileEventTrigger
		err := json.Unmarshal(body, &fet)
		return fet, err
	case string(KindPeriodicTimerEvent):
		var ptet PeriodicTimerEventTrigger
		err := json.Unmarshal(body, &ptet)
		return ptet, err
	default:
		var t Trigger
		err := json.Unmarshal(body, &t)
		return t, err
	}
}
func unmarshalBasicTriggerArray(body []byte) ([]BasicTrigger, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	tArray := make([]BasicTrigger, len(rawMessages))

	for index, rawMessage := range rawMessages {
		t, err := unmarshalBasicTrigger(*rawMessage)
		if err != nil {
			return nil, err
		}
		tArray[index] = t
	}
	return tArray, nil
}

// MarshalJSON is the custom marshaler for Trigger.
func (t Trigger) MarshalJSON() ([]byte, error) {
	t.Kind = KindTrigger
	objectMap := make(map[string]interface{})
	if t.Kind != "" {
		objectMap["kind"] = t.Kind
	}
	if t.ID != nil {
		objectMap["id"] = t.ID
	}
	if t.Name != nil {
		objectMap["name"] = t.Name
	}
	if t.Type != nil {
		objectMap["type"] = t.Type
	}
	return json.Marshal(objectMap)
}

// AsFileEventTrigger is the BasicTrigger implementation for Trigger.
func (t Trigger) AsFileEventTrigger() (*FileEventTrigger, bool) {
	return nil, false
}

// AsPeriodicTimerEventTrigger is the BasicTrigger implementation for Trigger.
func (t Trigger) AsPeriodicTimerEventTrigger() (*PeriodicTimerEventTrigger, bool) {
	return nil, false
}

// AsTrigger is the BasicTrigger implementation for Trigger.
func (t Trigger) AsTrigger() (*Trigger, bool) {
	return &t, true
}

// AsBasicTrigger is the BasicTrigger implementation for Trigger.
func (t Trigger) AsBasicTrigger() (BasicTrigger, bool) {
	return &t, true
}

// TriggerList collection of all trigger on the data box edge device.
type TriggerList struct {
	autorest.Response `json:"-"`
	// Value - The list of triggers.
	Value *[]BasicTrigger `json:"value,omitempty"`
	// NextLink - Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for TriggerList struct.
func (tl *TriggerList) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "value":
			if v != nil {
				value, err := unmarshalBasicTriggerArray(*v)
				if err != nil {
					return err
				}
				tl.Value = &value
			}
		case "nextLink":
			if v != nil {
				var nextLink string
				err = json.Unmarshal(*v, &nextLink)
				if err != nil {
					return err
				}
				tl.NextLink = &nextLink
			}
		}
	}

	return nil
}

// TriggerListIterator provides access to a complete listing of Trigger values.
type TriggerListIterator struct {
	i    int
	page TriggerListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TriggerListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TriggerListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TriggerListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TriggerListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TriggerListIterator) Response() TriggerList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TriggerListIterator) Value() BasicTrigger {
	if !iter.page.NotDone() {
		return Trigger{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TriggerListIterator type.
func NewTriggerListIterator(page TriggerListPage) TriggerListIterator {
	return TriggerListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tl TriggerList) IsEmpty() bool {
	return tl.Value == nil || len(*tl.Value) == 0
}

// triggerListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tl TriggerList) triggerListPreparer(ctx context.Context) (*http.Request, error) {
	if tl.NextLink == nil || len(to.String(tl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tl.NextLink)))
}

// TriggerListPage contains a page of BasicTrigger values.
type TriggerListPage struct {
	fn func(context.Context, TriggerList) (TriggerList, error)
	tl TriggerList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TriggerListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TriggerListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.tl)
	if err != nil {
		return err
	}
	page.tl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TriggerListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TriggerListPage) NotDone() bool {
	return !page.tl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TriggerListPage) Response() TriggerList {
	return page.tl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TriggerListPage) Values() []BasicTrigger {
	if page.tl.IsEmpty() {
		return nil
	}
	return *page.tl.Value
}

// Creates a new instance of the TriggerListPage type.
func NewTriggerListPage(getNextPage func(context.Context, TriggerList) (TriggerList, error)) TriggerListPage {
	return TriggerListPage{fn: getNextPage}
}

// TriggerModel ...
type TriggerModel struct {
	autorest.Response `json:"-"`
	Value             BasicTrigger `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for TriggerModel struct.
func (tm *TriggerModel) UnmarshalJSON(body []byte) error {
	t, err := unmarshalBasicTrigger(body)
	if err != nil {
		return err
	}
	tm.Value = t

	return nil
}

// TriggersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type TriggersCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *TriggersCreateOrUpdateFuture) Result(client TriggersClient) (tm TriggerModel, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgegateway.TriggersCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("edgegateway.TriggersCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if tm.Response.Response, err = future.GetResult(sender); err == nil && tm.Response.Response.StatusCode != http.StatusNoContent {
		tm, err = client.CreateOrUpdateResponder(tm.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "edgegateway.TriggersCreateOrUpdateFuture", "Result", tm.Response.Response, "Failure responding to request")
		}
	}
	return
}

// TriggersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type TriggersDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *TriggersDeleteFuture) Result(client TriggersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgegateway.TriggersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("edgegateway.TriggersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// UpdateDownloadProgress details about the download progress of update.
type UpdateDownloadProgress struct {
	// DownloadPhase - The download phase. Possible values include: 'Unknown', 'Initializing', 'Downloading', 'Verifying'
	DownloadPhase DownloadPhase `json:"downloadPhase,omitempty"`
	// PercentComplete - Percentage of completion.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// TotalBytesToDownload - Total bytes to download.
	TotalBytesToDownload *float64 `json:"totalBytesToDownload,omitempty"`
	// TotalBytesDownloaded - Total bytes downloaded.
	TotalBytesDownloaded *float64 `json:"totalBytesDownloaded,omitempty"`
	// NumberOfUpdatesToDownload - Number of updates to download.
	NumberOfUpdatesToDownload *int32 `json:"numberOfUpdatesToDownload,omitempty"`
	// NumberOfUpdatesDownloaded - Number of updates downloaded.
	NumberOfUpdatesDownloaded *int32 `json:"numberOfUpdatesDownloaded,omitempty"`
}

// UpdateInstallProgress progress details during installation of updates.
type UpdateInstallProgress struct {
	// PercentComplete - Percentage completed.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// NumberOfUpdatesToInstall - Number of updates to install.
	NumberOfUpdatesToInstall *int32 `json:"numberOfUpdatesToInstall,omitempty"`
	// NumberOfUpdatesInstalled - Number of updates installed.
	NumberOfUpdatesInstalled *int32 `json:"numberOfUpdatesInstalled,omitempty"`
}

// UpdateSummary details about ongoing updates and availability of updates on the device.
type UpdateSummary struct {
	autorest.Response `json:"-"`
	// UpdateSummaryProperties - The device update information summary.
	*UpdateSummaryProperties `json:"properties,omitempty"`
	// ID - The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - The object name.
	Name *string `json:"name,omitempty"`
	// Type - The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for UpdateSummary.
func (us UpdateSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if us.UpdateSummaryProperties != nil {
		objectMap["properties"] = us.UpdateSummaryProperties
	}
	if us.ID != nil {
		objectMap["id"] = us.ID
	}
	if us.Name != nil {
		objectMap["name"] = us.Name
	}
	if us.Type != nil {
		objectMap["type"] = us.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UpdateSummary struct.
func (us *UpdateSummary) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var updateSummaryProperties UpdateSummaryProperties
				err = json.Unmarshal(*v, &updateSummaryProperties)
				if err != nil {
					return err
				}
				us.UpdateSummaryProperties = &updateSummaryProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				us.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				us.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				us.Type = &typeVar
			}
		}
	}

	return nil
}

// UpdateSummaryProperties the device update information summary.
type UpdateSummaryProperties struct {
	// DeviceVersionNumber - The current version of the device in format: 1.2.17312.13.",
	DeviceVersionNumber *string `json:"deviceVersionNumber,omitempty"`
	// FriendlyDeviceVersionName - The current version of the device in text format.
	FriendlyDeviceVersionName *string `json:"friendlyDeviceVersionName,omitempty"`
	// DeviceLastScannedDateTime - The last time when a scan was done on the device.
	DeviceLastScannedDateTime *date.Time `json:"deviceLastScannedDateTime,omitempty"`
	// LastCompletedScanJobDateTime - The time when the last scan job was completed (success/cancelled/failed) on the appliance.
	LastCompletedScanJobDateTime *date.Time `json:"lastCompletedScanJobDateTime,omitempty"`
	// LastCompletedDownloadJobDateTime - The time when the last Download job was completed (success/cancelled/failed) on the appliance.
	LastCompletedDownloadJobDateTime *date.Time `json:"lastCompletedDownloadJobDateTime,omitempty"`
	// LastCompletedInstallJobDateTime - The time when the last Install job was completed (success/cancelled/failed) on the appliance.
	LastCompletedInstallJobDateTime *date.Time `json:"lastCompletedInstallJobDateTime,omitempty"`
	// TotalNumberOfUpdatesAvailable - The number of updates available for the current device version as per the last device scan.
	TotalNumberOfUpdatesAvailable *int32 `json:"totalNumberOfUpdatesAvailable,omitempty"`
	// TotalNumberOfUpdatesPendingDownload - The total number of items pending download.
	TotalNumberOfUpdatesPendingDownload *int32 `json:"totalNumberOfUpdatesPendingDownload,omitempty"`
	// TotalNumberOfUpdatesPendingInstall - The total number of items pending install.
	TotalNumberOfUpdatesPendingInstall *int32 `json:"totalNumberOfUpdatesPendingInstall,omitempty"`
	// RebootBehavior - Indicates if updates are available and at least one of the updates needs a reboot. Possible values include: 'NeverReboots', 'RequiresReboot', 'RequestReboot'
	RebootBehavior InstallRebootBehavior `json:"rebootBehavior,omitempty"`
	// OngoingUpdateOperation - The current update operation. Possible values include: 'UpdateOperationNone', 'UpdateOperationScan', 'UpdateOperationDownload', 'UpdateOperationInstall'
	OngoingUpdateOperation UpdateOperation `json:"ongoingUpdateOperation,omitempty"`
	// InProgressDownloadJobID - The job ID of the download job in progress.
	InProgressDownloadJobID *string `json:"inProgressDownloadJobId,omitempty"`
	// InProgressInstallJobID - The job ID of the install job in progress.
	InProgressInstallJobID *string `json:"inProgressInstallJobId,omitempty"`
	// InProgressDownloadJobStartedDateTime - The time when the currently running download (if any) started.
	InProgressDownloadJobStartedDateTime *date.Time `json:"inProgressDownloadJobStartedDateTime,omitempty"`
	// InProgressInstallJobStartedDateTime - The time when the currently running install (if any) started.
	InProgressInstallJobStartedDateTime *date.Time `json:"inProgressInstallJobStartedDateTime,omitempty"`
	// UpdateTitles - The list of updates available for install.
	UpdateTitles *[]string `json:"updateTitles,omitempty"`
	// TotalUpdateSizeInBytes - The total size of updates available for download in bytes.
	TotalUpdateSizeInBytes *float64 `json:"totalUpdateSizeInBytes,omitempty"`
}

// UploadCertificateRequest the upload certificate request.
type UploadCertificateRequest struct {
	// RawCertificateData - The Base 64 encoded certificate raw data.
	*RawCertificateData `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for UploadCertificateRequest.
func (ucr UploadCertificateRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ucr.RawCertificateData != nil {
		objectMap["properties"] = ucr.RawCertificateData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UploadCertificateRequest struct.
func (ucr *UploadCertificateRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var rawCertificateData RawCertificateData
				err = json.Unmarshal(*v, &rawCertificateData)
				if err != nil {
					return err
				}
				ucr.RawCertificateData = &rawCertificateData
			}
		}
	}

	return nil
}

// UploadCertificateResponse the upload registration certificate response.
type UploadCertificateResponse struct {
	autorest.Response `json:"-"`
	// AuthType - Specifies authentication type. Possible values include: 'Invalid', 'AzureActiveDirectory'
	AuthType AuthenticationType `json:"authType,omitempty"`
	// ResourceID - The resource ID of the Data Box Edge/Gateway device.
	ResourceID *string `json:"resourceId,omitempty"`
	// AadAuthority - Azure Active Directory tenant authority.
	AadAuthority *string `json:"aadAuthority,omitempty"`
	// AadTenantID - Azure Active Directory tenant ID.
	AadTenantID *string `json:"aadTenantId,omitempty"`
	// ServicePrincipalClientID - Azure Active Directory service principal client ID.
	ServicePrincipalClientID *string `json:"servicePrincipalClientId,omitempty"`
	// ServicePrincipalObjectID - Azure Active Directory service principal object ID.
	ServicePrincipalObjectID *string `json:"servicePrincipalObjectId,omitempty"`
	// AzureManagementEndpointAudience - The azure management endpoint audience.
	AzureManagementEndpointAudience *string `json:"azureManagementEndpointAudience,omitempty"`
}

// User represents a user who has access to one or more shares on the Data Box Edge/Gateway device.
type User struct {
	autorest.Response `json:"-"`
	// UserProperties - The storage account credential properties.
	*UserProperties `json:"properties,omitempty"`
	// ID - The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - The object name.
	Name *string `json:"name,omitempty"`
	// Type - The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for User.
func (u User) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if u.UserProperties != nil {
		objectMap["properties"] = u.UserProperties
	}
	if u.ID != nil {
		objectMap["id"] = u.ID
	}
	if u.Name != nil {
		objectMap["name"] = u.Name
	}
	if u.Type != nil {
		objectMap["type"] = u.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for User struct.
func (u *User) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var userProperties UserProperties
				err = json.Unmarshal(*v, &userProperties)
				if err != nil {
					return err
				}
				u.UserProperties = &userProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				u.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				u.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				u.Type = &typeVar
			}
		}
	}

	return nil
}

// UserAccessRight the mapping between a particular user and the access type on the SMB share.
type UserAccessRight struct {
	// UserID - User ID (already existing in the device).
	UserID *string `json:"userId,omitempty"`
	// AccessType - Type of access to be allowed for the user. Possible values include: 'Change', 'Read', 'Custom'
	AccessType ShareAccessType `json:"accessType,omitempty"`
}

// UserList collection of users.
type UserList struct {
	autorest.Response `json:"-"`
	// Value - The list of users.
	Value *[]User `json:"value,omitempty"`
	// NextLink - Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// UserListIterator provides access to a complete listing of User values.
type UserListIterator struct {
	i    int
	page UserListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *UserListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UserListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *UserListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter UserListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter UserListIterator) Response() UserList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter UserListIterator) Value() User {
	if !iter.page.NotDone() {
		return User{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the UserListIterator type.
func NewUserListIterator(page UserListPage) UserListIterator {
	return UserListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ul UserList) IsEmpty() bool {
	return ul.Value == nil || len(*ul.Value) == 0
}

// userListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ul UserList) userListPreparer(ctx context.Context) (*http.Request, error) {
	if ul.NextLink == nil || len(to.String(ul.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ul.NextLink)))
}

// UserListPage contains a page of User values.
type UserListPage struct {
	fn func(context.Context, UserList) (UserList, error)
	ul UserList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *UserListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UserListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ul)
	if err != nil {
		return err
	}
	page.ul = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *UserListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page UserListPage) NotDone() bool {
	return !page.ul.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page UserListPage) Response() UserList {
	return page.ul
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page UserListPage) Values() []User {
	if page.ul.IsEmpty() {
		return nil
	}
	return *page.ul.Value
}

// Creates a new instance of the UserListPage type.
func NewUserListPage(getNextPage func(context.Context, UserList) (UserList, error)) UserListPage {
	return UserListPage{fn: getNextPage}
}

// UserProperties the user properties.
type UserProperties struct {
	// EncryptedPassword - The password details.
	EncryptedPassword *AsymmetricEncryptedSecret `json:"encryptedPassword,omitempty"`
	// ShareAccessRights - List of shares that the user has rights on. This field should not be specified during user creation.
	ShareAccessRights *[]ShareAccessRight `json:"shareAccessRights,omitempty"`
}

// UsersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type UsersCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *UsersCreateOrUpdateFuture) Result(client UsersClient) (u User, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgegateway.UsersCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("edgegateway.UsersCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if u.Response.Response, err = future.GetResult(sender); err == nil && u.Response.Response.StatusCode != http.StatusNoContent {
		u, err = client.CreateOrUpdateResponder(u.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "edgegateway.UsersCreateOrUpdateFuture", "Result", u.Response.Response, "Failure responding to request")
		}
	}
	return
}

// UsersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type UsersDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *UsersDeleteFuture) Result(client UsersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgegateway.UsersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("edgegateway.UsersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}
