package logic

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/logic/mgmt/2015-08-01-preview/logic"

// AgreementType enumerates the values for agreement type.
type AgreementType string

const (
	// AS2 ...
	AS2 AgreementType = "AS2"
	// Edifact ...
	Edifact AgreementType = "Edifact"
	// NotSpecified ...
	NotSpecified AgreementType = "NotSpecified"
	// X12 ...
	X12 AgreementType = "X12"
)

// PossibleAgreementTypeValues returns an array of possible values for the AgreementType const type.
func PossibleAgreementTypeValues() []AgreementType {
	return []AgreementType{AS2, Edifact, NotSpecified, X12}
}

// EdifactCharacterSet enumerates the values for edifact character set.
type EdifactCharacterSet string

const (
	// EdifactCharacterSetKECA ...
	EdifactCharacterSetKECA EdifactCharacterSet = "KECA"
	// EdifactCharacterSetNotSpecified ...
	EdifactCharacterSetNotSpecified EdifactCharacterSet = "NotSpecified"
	// EdifactCharacterSetUNOA ...
	EdifactCharacterSetUNOA EdifactCharacterSet = "UNOA"
	// EdifactCharacterSetUNOB ...
	EdifactCharacterSetUNOB EdifactCharacterSet = "UNOB"
	// EdifactCharacterSetUNOC ...
	EdifactCharacterSetUNOC EdifactCharacterSet = "UNOC"
	// EdifactCharacterSetUNOD ...
	EdifactCharacterSetUNOD EdifactCharacterSet = "UNOD"
	// EdifactCharacterSetUNOE ...
	EdifactCharacterSetUNOE EdifactCharacterSet = "UNOE"
	// EdifactCharacterSetUNOF ...
	EdifactCharacterSetUNOF EdifactCharacterSet = "UNOF"
	// EdifactCharacterSetUNOG ...
	EdifactCharacterSetUNOG EdifactCharacterSet = "UNOG"
	// EdifactCharacterSetUNOH ...
	EdifactCharacterSetUNOH EdifactCharacterSet = "UNOH"
	// EdifactCharacterSetUNOI ...
	EdifactCharacterSetUNOI EdifactCharacterSet = "UNOI"
	// EdifactCharacterSetUNOJ ...
	EdifactCharacterSetUNOJ EdifactCharacterSet = "UNOJ"
	// EdifactCharacterSetUNOK ...
	EdifactCharacterSetUNOK EdifactCharacterSet = "UNOK"
	// EdifactCharacterSetUNOX ...
	EdifactCharacterSetUNOX EdifactCharacterSet = "UNOX"
	// EdifactCharacterSetUNOY ...
	EdifactCharacterSetUNOY EdifactCharacterSet = "UNOY"
)

// PossibleEdifactCharacterSetValues returns an array of possible values for the EdifactCharacterSet const type.
func PossibleEdifactCharacterSetValues() []EdifactCharacterSet {
	return []EdifactCharacterSet{EdifactCharacterSetKECA, EdifactCharacterSetNotSpecified, EdifactCharacterSetUNOA, EdifactCharacterSetUNOB, EdifactCharacterSetUNOC, EdifactCharacterSetUNOD, EdifactCharacterSetUNOE, EdifactCharacterSetUNOF, EdifactCharacterSetUNOG, EdifactCharacterSetUNOH, EdifactCharacterSetUNOI, EdifactCharacterSetUNOJ, EdifactCharacterSetUNOK, EdifactCharacterSetUNOX, EdifactCharacterSetUNOY}
}

// EdifactDecimalIndicator enumerates the values for edifact decimal indicator.
type EdifactDecimalIndicator string

const (
	// EdifactDecimalIndicatorComma ...
	EdifactDecimalIndicatorComma EdifactDecimalIndicator = "Comma"
	// EdifactDecimalIndicatorDecimal ...
	EdifactDecimalIndicatorDecimal EdifactDecimalIndicator = "Decimal"
	// EdifactDecimalIndicatorNotSpecified ...
	EdifactDecimalIndicatorNotSpecified EdifactDecimalIndicator = "NotSpecified"
)

// PossibleEdifactDecimalIndicatorValues returns an array of possible values for the EdifactDecimalIndicator const type.
func PossibleEdifactDecimalIndicatorValues() []EdifactDecimalIndicator {
	return []EdifactDecimalIndicator{EdifactDecimalIndicatorComma, EdifactDecimalIndicatorDecimal, EdifactDecimalIndicatorNotSpecified}
}

// EncryptionAlgorithm enumerates the values for encryption algorithm.
type EncryptionAlgorithm string

const (
	// EncryptionAlgorithmAES128 ...
	EncryptionAlgorithmAES128 EncryptionAlgorithm = "AES128"
	// EncryptionAlgorithmAES192 ...
	EncryptionAlgorithmAES192 EncryptionAlgorithm = "AES192"
	// EncryptionAlgorithmAES256 ...
	EncryptionAlgorithmAES256 EncryptionAlgorithm = "AES256"
	// EncryptionAlgorithmDES3 ...
	EncryptionAlgorithmDES3 EncryptionAlgorithm = "DES3"
	// EncryptionAlgorithmNone ...
	EncryptionAlgorithmNone EncryptionAlgorithm = "None"
	// EncryptionAlgorithmNotSpecified ...
	EncryptionAlgorithmNotSpecified EncryptionAlgorithm = "NotSpecified"
	// EncryptionAlgorithmRC2 ...
	EncryptionAlgorithmRC2 EncryptionAlgorithm = "RC2"
)

// PossibleEncryptionAlgorithmValues returns an array of possible values for the EncryptionAlgorithm const type.
func PossibleEncryptionAlgorithmValues() []EncryptionAlgorithm {
	return []EncryptionAlgorithm{EncryptionAlgorithmAES128, EncryptionAlgorithmAES192, EncryptionAlgorithmAES256, EncryptionAlgorithmDES3, EncryptionAlgorithmNone, EncryptionAlgorithmNotSpecified, EncryptionAlgorithmRC2}
}

// HashingAlgorithm enumerates the values for hashing algorithm.
type HashingAlgorithm string

const (
	// HashingAlgorithmNone ...
	HashingAlgorithmNone HashingAlgorithm = "None"
	// HashingAlgorithmNotSpecified ...
	HashingAlgorithmNotSpecified HashingAlgorithm = "NotSpecified"
	// HashingAlgorithmSHA2256 ...
	HashingAlgorithmSHA2256 HashingAlgorithm = "SHA2256"
	// HashingAlgorithmSHA2384 ...
	HashingAlgorithmSHA2384 HashingAlgorithm = "SHA2384"
	// HashingAlgorithmSHA2512 ...
	HashingAlgorithmSHA2512 HashingAlgorithm = "SHA2512"
)

// PossibleHashingAlgorithmValues returns an array of possible values for the HashingAlgorithm const type.
func PossibleHashingAlgorithmValues() []HashingAlgorithm {
	return []HashingAlgorithm{HashingAlgorithmNone, HashingAlgorithmNotSpecified, HashingAlgorithmSHA2256, HashingAlgorithmSHA2384, HashingAlgorithmSHA2512}
}

// MapType enumerates the values for map type.
type MapType string

const (
	// MapTypeNotSpecified ...
	MapTypeNotSpecified MapType = "NotSpecified"
	// MapTypeXslt ...
	MapTypeXslt MapType = "Xslt"
)

// PossibleMapTypeValues returns an array of possible values for the MapType const type.
func PossibleMapTypeValues() []MapType {
	return []MapType{MapTypeNotSpecified, MapTypeXslt}
}

// MessageFilterType enumerates the values for message filter type.
type MessageFilterType string

const (
	// MessageFilterTypeExclude ...
	MessageFilterTypeExclude MessageFilterType = "Exclude"
	// MessageFilterTypeInclude ...
	MessageFilterTypeInclude MessageFilterType = "Include"
	// MessageFilterTypeNotSpecified ...
	MessageFilterTypeNotSpecified MessageFilterType = "NotSpecified"
)

// PossibleMessageFilterTypeValues returns an array of possible values for the MessageFilterType const type.
func PossibleMessageFilterTypeValues() []MessageFilterType {
	return []MessageFilterType{MessageFilterTypeExclude, MessageFilterTypeInclude, MessageFilterTypeNotSpecified}
}

// PartnerType enumerates the values for partner type.
type PartnerType string

const (
	// PartnerTypeB2B ...
	PartnerTypeB2B PartnerType = "B2B"
	// PartnerTypeNotSpecified ...
	PartnerTypeNotSpecified PartnerType = "NotSpecified"
)

// PossiblePartnerTypeValues returns an array of possible values for the PartnerType const type.
func PossiblePartnerTypeValues() []PartnerType {
	return []PartnerType{PartnerTypeB2B, PartnerTypeNotSpecified}
}

// SchemaType enumerates the values for schema type.
type SchemaType string

const (
	// SchemaTypeNotSpecified ...
	SchemaTypeNotSpecified SchemaType = "NotSpecified"
	// SchemaTypeXML ...
	SchemaTypeXML SchemaType = "Xml"
)

// PossibleSchemaTypeValues returns an array of possible values for the SchemaType const type.
func PossibleSchemaTypeValues() []SchemaType {
	return []SchemaType{SchemaTypeNotSpecified, SchemaTypeXML}
}

// SegmentTerminatorSuffix enumerates the values for segment terminator suffix.
type SegmentTerminatorSuffix string

const (
	// SegmentTerminatorSuffixCR ...
	SegmentTerminatorSuffixCR SegmentTerminatorSuffix = "CR"
	// SegmentTerminatorSuffixCRLF ...
	SegmentTerminatorSuffixCRLF SegmentTerminatorSuffix = "CRLF"
	// SegmentTerminatorSuffixLF ...
	SegmentTerminatorSuffixLF SegmentTerminatorSuffix = "LF"
	// SegmentTerminatorSuffixNone ...
	SegmentTerminatorSuffixNone SegmentTerminatorSuffix = "None"
	// SegmentTerminatorSuffixNotSpecified ...
	SegmentTerminatorSuffixNotSpecified SegmentTerminatorSuffix = "NotSpecified"
)

// PossibleSegmentTerminatorSuffixValues returns an array of possible values for the SegmentTerminatorSuffix const type.
func PossibleSegmentTerminatorSuffixValues() []SegmentTerminatorSuffix {
	return []SegmentTerminatorSuffix{SegmentTerminatorSuffixCR, SegmentTerminatorSuffixCRLF, SegmentTerminatorSuffixLF, SegmentTerminatorSuffixNone, SegmentTerminatorSuffixNotSpecified}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// SkuNameBasic ...
	SkuNameBasic SkuName = "Basic"
	// SkuNameFree ...
	SkuNameFree SkuName = "Free"
	// SkuNameNotSpecified ...
	SkuNameNotSpecified SkuName = "NotSpecified"
	// SkuNamePremium ...
	SkuNamePremium SkuName = "Premium"
	// SkuNameShared ...
	SkuNameShared SkuName = "Shared"
	// SkuNameStandard ...
	SkuNameStandard SkuName = "Standard"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{SkuNameBasic, SkuNameFree, SkuNameNotSpecified, SkuNamePremium, SkuNameShared, SkuNameStandard}
}

// TrailingSeparatorPolicy enumerates the values for trailing separator policy.
type TrailingSeparatorPolicy string

const (
	// TrailingSeparatorPolicyMandatory ...
	TrailingSeparatorPolicyMandatory TrailingSeparatorPolicy = "Mandatory"
	// TrailingSeparatorPolicyNotAllowed ...
	TrailingSeparatorPolicyNotAllowed TrailingSeparatorPolicy = "NotAllowed"
	// TrailingSeparatorPolicyNotSpecified ...
	TrailingSeparatorPolicyNotSpecified TrailingSeparatorPolicy = "NotSpecified"
	// TrailingSeparatorPolicyOptional ...
	TrailingSeparatorPolicyOptional TrailingSeparatorPolicy = "Optional"
)

// PossibleTrailingSeparatorPolicyValues returns an array of possible values for the TrailingSeparatorPolicy const type.
func PossibleTrailingSeparatorPolicyValues() []TrailingSeparatorPolicy {
	return []TrailingSeparatorPolicy{TrailingSeparatorPolicyMandatory, TrailingSeparatorPolicyNotAllowed, TrailingSeparatorPolicyNotSpecified, TrailingSeparatorPolicyOptional}
}

// UsageIndicator enumerates the values for usage indicator.
type UsageIndicator string

const (
	// UsageIndicatorInformation ...
	UsageIndicatorInformation UsageIndicator = "Information"
	// UsageIndicatorNotSpecified ...
	UsageIndicatorNotSpecified UsageIndicator = "NotSpecified"
	// UsageIndicatorProduction ...
	UsageIndicatorProduction UsageIndicator = "Production"
	// UsageIndicatorTest ...
	UsageIndicatorTest UsageIndicator = "Test"
)

// PossibleUsageIndicatorValues returns an array of possible values for the UsageIndicator const type.
func PossibleUsageIndicatorValues() []UsageIndicator {
	return []UsageIndicator{UsageIndicatorInformation, UsageIndicatorNotSpecified, UsageIndicatorProduction, UsageIndicatorTest}
}

// X12CharacterSet enumerates the values for x12 character set.
type X12CharacterSet string

const (
	// X12CharacterSetBasic ...
	X12CharacterSetBasic X12CharacterSet = "Basic"
	// X12CharacterSetExtended ...
	X12CharacterSetExtended X12CharacterSet = "Extended"
	// X12CharacterSetNotSpecified ...
	X12CharacterSetNotSpecified X12CharacterSet = "NotSpecified"
	// X12CharacterSetUTF8 ...
	X12CharacterSetUTF8 X12CharacterSet = "UTF8"
)

// PossibleX12CharacterSetValues returns an array of possible values for the X12CharacterSet const type.
func PossibleX12CharacterSetValues() []X12CharacterSet {
	return []X12CharacterSet{X12CharacterSetBasic, X12CharacterSetExtended, X12CharacterSetNotSpecified, X12CharacterSetUTF8}
}

// X12DateFormat enumerates the values for x12 date format.
type X12DateFormat string

const (
	// X12DateFormatCCYYMMDD ...
	X12DateFormatCCYYMMDD X12DateFormat = "CCYYMMDD"
	// X12DateFormatNotSpecified ...
	X12DateFormatNotSpecified X12DateFormat = "NotSpecified"
	// X12DateFormatYYMMDD ...
	X12DateFormatYYMMDD X12DateFormat = "YYMMDD"
)

// PossibleX12DateFormatValues returns an array of possible values for the X12DateFormat const type.
func PossibleX12DateFormatValues() []X12DateFormat {
	return []X12DateFormat{X12DateFormatCCYYMMDD, X12DateFormatNotSpecified, X12DateFormatYYMMDD}
}

// X12TimeFormat enumerates the values for x12 time format.
type X12TimeFormat string

const (
	// X12TimeFormatHHMM ...
	X12TimeFormatHHMM X12TimeFormat = "HHMM"
	// X12TimeFormatHHMMSS ...
	X12TimeFormatHHMMSS X12TimeFormat = "HHMMSS"
	// X12TimeFormatHHMMSSd ...
	X12TimeFormatHHMMSSd X12TimeFormat = "HHMMSSd"
	// X12TimeFormatHHMMSSdd ...
	X12TimeFormatHHMMSSdd X12TimeFormat = "HHMMSSdd"
	// X12TimeFormatNotSpecified ...
	X12TimeFormatNotSpecified X12TimeFormat = "NotSpecified"
)

// PossibleX12TimeFormatValues returns an array of possible values for the X12TimeFormat const type.
func PossibleX12TimeFormatValues() []X12TimeFormat {
	return []X12TimeFormat{X12TimeFormatHHMM, X12TimeFormatHHMMSS, X12TimeFormatHHMMSSd, X12TimeFormatHHMMSSdd, X12TimeFormatNotSpecified}
}

// AgreementContent ...
type AgreementContent struct {
	// AS2 - The AS2 agreement content.
	AS2 *AS2AgreementContent `json:"AS2,omitempty"`
	// X12 - The X12 agreement content.
	X12 *X12AgreementContent `json:"X12,omitempty"`
	// Edifact - The EDIFACT agreement content.
	Edifact *EdifactAgreementContent `json:"Edifact,omitempty"`
}

// AS2AcknowledgementConnectionSettings ...
type AS2AcknowledgementConnectionSettings struct {
	// IgnoreCertificateNameMismatch - The value indicating whether to ignore mismatch in certificate name.
	IgnoreCertificateNameMismatch *bool `json:"ignoreCertificateNameMismatch,omitempty"`
	// SupportHTTPStatusCodeContinue - The value indicating whether to support HTTP status code 'CONTINUE'.
	SupportHTTPStatusCodeContinue *bool `json:"supportHttpStatusCodeContinue,omitempty"`
	// KeepHTTPConnectionAlive - The value indicating whether to keep the connection alive.
	KeepHTTPConnectionAlive *bool `json:"keepHttpConnectionAlive,omitempty"`
	// UnfoldHTTPHeaders - The value indicating whether to unfold the HTTP headers.
	UnfoldHTTPHeaders *bool `json:"unfoldHttpHeaders,omitempty"`
}

// AS2AgreementContent ...
type AS2AgreementContent struct {
	// ReceiveAgreement - The AS2 one-way receive agreement.
	ReceiveAgreement *AS2OneWayAgreement `json:"receiveAgreement,omitempty"`
	// SendAgreement - The AS2 one-way send agreement.
	SendAgreement *AS2OneWayAgreement `json:"sendAgreement,omitempty"`
}

// AS2EnvelopeSettings ...
type AS2EnvelopeSettings struct {
	// MessageContentType - The message content type.
	MessageContentType *string `json:"messageContentType,omitempty"`
	// TransmitFileNameInMimeHeader - The value indicating whether to transmit file name in mime header.
	TransmitFileNameInMimeHeader *bool `json:"transmitFileNameInMimeHeader,omitempty"`
	// FileNameTemplate - The template for file name.
	FileNameTemplate *string `json:"fileNameTemplate,omitempty"`
	// SuspendMessageOnFileNameGenerationError - The value indicating whether to suspend message on file name generation error.
	SuspendMessageOnFileNameGenerationError *bool `json:"SuspendMessageOnFileNameGenerationError,omitempty"`
	// AutogenerateFileName - The value indicating whether to auto generate file name.
	AutogenerateFileName *bool `json:"AutogenerateFileName,omitempty"`
}

// AS2ErrorSettings ...
type AS2ErrorSettings struct {
	// SuspendDuplicateMessage - The value indicating whether to suspend duplicate message.
	SuspendDuplicateMessage *bool `json:"SuspendDuplicateMessage,omitempty"`
	// ResendIfMdnNotReceived - The value indicating whether to resend message If MDN is not received.
	ResendIfMdnNotReceived *bool `json:"ResendIfMdnNotReceived,omitempty"`
}

// AS2MdnSettings ...
type AS2MdnSettings struct {
	// NeedMdn - The value indicating whether to send or request a MDN.
	NeedMdn *bool `json:"needMdn,omitempty"`
	// SignMdn - The value indicating whether the MDN needs to be signed or not.
	SignMdn *bool `json:"signMdn,omitempty"`
	// SendMdnAsynchronously - The value indicating whether to send the asynchronous MDN.
	SendMdnAsynchronously *bool `json:"sendMdnAsynchronously,omitempty"`
	// ReceiptDeliveryURL - The receipt delivery URL.
	ReceiptDeliveryURL *string `json:"receiptDeliveryUrl,omitempty"`
	// DispositionNotificationTo - The disposition notification to header value.
	DispositionNotificationTo *string `json:"dispositionNotificationTo,omitempty"`
	// SignOutboundMdnIfOptional - The value indicating whether to sign the outbound MDN if optional.
	SignOutboundMdnIfOptional *bool `json:"signOutboundMdnIfOptional,omitempty"`
	// MdnText - The MDN text.
	MdnText *string `json:"mdnText,omitempty"`
	// SendInboundMdnToMessageBox - The value indicating whether to send inbound MDN to message box.
	SendInboundMdnToMessageBox *bool `json:"sendInboundMdnToMessageBox,omitempty"`
	// MicHashingAlgorithm - The signing or hashing algorithm. Possible values include: 'HashingAlgorithmNotSpecified', 'HashingAlgorithmNone', 'HashingAlgorithmSHA2256', 'HashingAlgorithmSHA2384', 'HashingAlgorithmSHA2512'
	MicHashingAlgorithm HashingAlgorithm `json:"micHashingAlgorithm,omitempty"`
}

// AS2MessageConnectionSettings ...
type AS2MessageConnectionSettings struct {
	// IgnoreCertificateNameMismatch - The value indicating whether to ignore mismatch in certificate name.
	IgnoreCertificateNameMismatch *bool `json:"ignoreCertificateNameMismatch,omitempty"`
	// SupportHTTPStatusCodeContinue - The value indicating whether to support HTTP status code 'CONTINUE'.
	SupportHTTPStatusCodeContinue *bool `json:"supportHttpStatusCodeContinue,omitempty"`
	// KeepHTTPConnectionAlive - The value indicating whether to keep the connection alive.
	KeepHTTPConnectionAlive *bool `json:"keepHttpConnectionAlive,omitempty"`
	// UnfoldHTTPHeaders - The value indicating whether to unfold the HTTP headers.
	UnfoldHTTPHeaders *bool `json:"unfoldHttpHeaders,omitempty"`
}

// AS2OneWayAgreement ...
type AS2OneWayAgreement struct {
	// SenderBusinessIdentity - The sender business identity
	SenderBusinessIdentity *BusinessIdentity `json:"senderBusinessIdentity,omitempty"`
	// ReceiverBusinessIdentity - The receiver business identity
	ReceiverBusinessIdentity *BusinessIdentity `json:"receiverBusinessIdentity,omitempty"`
	// ProtocolSettings - The AS2 protocol settings.
	ProtocolSettings *AS2ProtocolSettings `json:"protocolSettings,omitempty"`
}

// AS2ProtocolSettings ...
type AS2ProtocolSettings struct {
	// MessageConnectionSettings - The message connection settings.
	MessageConnectionSettings *AS2MessageConnectionSettings `json:"messageConnectionSettings,omitempty"`
	// AcknowledgementConnectionSettings - The acknowledgement connection settings.
	AcknowledgementConnectionSettings *AS2AcknowledgementConnectionSettings `json:"acknowledgementConnectionSettings,omitempty"`
	// MdnSettings - The MDN settings.
	MdnSettings *AS2MdnSettings `json:"mdnSettings,omitempty"`
	// SecuritySettings - The security settings.
	SecuritySettings *AS2SecuritySettings `json:"securitySettings,omitempty"`
	// ValidationSettings - The validation settings.
	ValidationSettings *AS2ValidationSettings `json:"validationSettings,omitempty"`
	// EnvelopeSettings - The envelope settings.
	EnvelopeSettings *AS2EnvelopeSettings `json:"envelopeSettings,omitempty"`
	// ErrorSettings - The error settings.
	ErrorSettings *AS2ErrorSettings `json:"errorSettings,omitempty"`
}

// AS2SecuritySettings ...
type AS2SecuritySettings struct {
	// OverrideGroupSigningCertificate - The value indicating whether to send or request a MDN.
	OverrideGroupSigningCertificate *bool `json:"overrideGroupSigningCertificate,omitempty"`
	// SigningCertificateName - The name of the signing certificate.
	SigningCertificateName *string `json:"signingCertificateName,omitempty"`
	// EncryptionCertificateName - The name of the encryption certificate.
	EncryptionCertificateName *string `json:"encryptionCertificateName,omitempty"`
	// EnableNrrForInboundEncodedMessages - The value indicating whether to enable NRR for inbound encoded messages.
	EnableNrrForInboundEncodedMessages *bool `json:"enableNrrForInboundEncodedMessages,omitempty"`
	// EnableNrrForInboundDecodedMessages - The value indicating whether to enable NRR for inbound decoded messages.
	EnableNrrForInboundDecodedMessages *bool `json:"enableNrrForInboundDecodedMessages,omitempty"`
	// EnableNrrForOutboundMdn - The value indicating whether to enable NRR for outbound MDN.
	EnableNrrForOutboundMdn *bool `json:"enableNrrForOutboundMdn,omitempty"`
	// EnableNrrForOutboundEncodedMessages - The value indicating whether to enable NRR for outbound encoded messages.
	EnableNrrForOutboundEncodedMessages *bool `json:"enableNrrForOutboundEncodedMessages,omitempty"`
	// EnableNrrForOutboundDecodedMessages - The value indicating whether to enable NRR for outbound decoded messages.
	EnableNrrForOutboundDecodedMessages *bool `json:"enableNrrForOutboundDecodedMessages,omitempty"`
	// EnableNrrForInboundMdn - The value indicating whether to enable NRR for inbound MDN.
	EnableNrrForInboundMdn *bool `json:"enableNrrForInboundMdn,omitempty"`
}

// AS2ValidationSettings ...
type AS2ValidationSettings struct {
	// OverrideMessageProperties - The value indicating whether to override incoming message properties with those in agreement.
	OverrideMessageProperties *bool `json:"overrideMessageProperties,omitempty"`
	// EncryptMessage - The value indicating whether the message has to be encrypted.
	EncryptMessage *bool `json:"encryptMessage,omitempty"`
	// SignMessage - The value indicating whether the message has to be signed.
	SignMessage *bool `json:"signMessage,omitempty"`
	// CompressMessage - The value indicating whether the message has to be compressed.
	CompressMessage *bool `json:"compressMessage,omitempty"`
	// CheckDuplicateMessage - The value indicating whether to check for duplicate message.
	CheckDuplicateMessage *bool `json:"checkDuplicateMessage,omitempty"`
	// InterchangeDuplicatesValidityDays - The number of days to look back for duplicate interchange.
	InterchangeDuplicatesValidityDays *int32 `json:"interchangeDuplicatesValidityDays,omitempty"`
	// CheckCertificateRevocationListOnSend - The value indicating whether to check for certificate revocation list on send.
	CheckCertificateRevocationListOnSend *bool `json:"checkCertificateRevocationListOnSend,omitempty"`
	// CheckCertificateRevocationListOnReceive - The value indicating whether to check for certificate revocation list on receive.
	CheckCertificateRevocationListOnReceive *bool `json:"checkCertificateRevocationListOnReceive,omitempty"`
	// EncryptionAlgorithm - The encryption algorithm. Possible values include: 'EncryptionAlgorithmNotSpecified', 'EncryptionAlgorithmNone', 'EncryptionAlgorithmDES3', 'EncryptionAlgorithmRC2', 'EncryptionAlgorithmAES128', 'EncryptionAlgorithmAES192', 'EncryptionAlgorithmAES256'
	EncryptionAlgorithm EncryptionAlgorithm `json:"encryptionAlgorithm,omitempty"`
}

// B2BPartnerContent ...
type B2BPartnerContent struct {
	// BusinessIdentities - The list of partner business identities.
	BusinessIdentities *[]BusinessIdentity `json:"businessIdentities,omitempty"`
}

// BusinessIdentity ...
type BusinessIdentity struct {
	// Qualifier - The business identity qualifier.
	Qualifier *string `json:"Qualifier,omitempty"`
	// Value - The business identity value.
	Value *string `json:"Value,omitempty"`
}

// CallbackURL ...
type CallbackURL struct {
	autorest.Response `json:"-"`
	// Value - The URL value.
	Value *string `json:"value,omitempty"`
}

// EdifactAcknowledgementSettings ...
type EdifactAcknowledgementSettings struct {
	// NeedTechnicalAcknowledgement - The value indicating whether technical acknowledgement is needed.
	NeedTechnicalAcknowledgement *bool `json:"needTechnicalAcknowledgement,omitempty"`
	// BatchTechnicalAcknowledgements - The value indicating whether to batch the technical acknowledgements.
	BatchTechnicalAcknowledgements *bool `json:"batchTechnicalAcknowledgements,omitempty"`
	// NeedFunctionalAcknowledgement - The value indicating whether functional acknowledgement is needed.
	NeedFunctionalAcknowledgement *bool `json:"needFunctionalAcknowledgement,omitempty"`
	// BatchFunctionalAcknowledgements - The value indicating whether to batch functional acknowledgements.
	BatchFunctionalAcknowledgements *bool `json:"batchFunctionalAcknowledgements,omitempty"`
	// NeedLoopForValidMessages - The value indicating whether a loop is needed for valid messages.
	NeedLoopForValidMessages *bool `json:"needLoopForValidMessages,omitempty"`
	// SendSynchronousAcknowledgement - The value indicating whether to send synchronous acknowledgement.
	SendSynchronousAcknowledgement *bool `json:"sendSynchronousAcknowledgement,omitempty"`
	// AcknowledgementControlNumberPrefix - The acknowledgement control number prefix.
	AcknowledgementControlNumberPrefix *string `json:"acknowledgementControlNumberPrefix,omitempty"`
	// AcknowledgementControlNumberSuffix - The acknowledgement control number suffix.
	AcknowledgementControlNumberSuffix *string `json:"acknowledgementControlNumberSuffix,omitempty"`
	// AcknowledgementControlNumberLowerBound - The acknowledgement control number lower bound.
	AcknowledgementControlNumberLowerBound *int32 `json:"acknowledgementControlNumberLowerBound,omitempty"`
	// AcknowledgementControlNumberUpperBound - The acknowledgement control number upper bound.
	AcknowledgementControlNumberUpperBound *int32 `json:"acknowledgementControlNumberUpperBound,omitempty"`
	// RolloverAcknowledgementControlNumber - The value indicating whether to rollover acknowledgement control number.
	RolloverAcknowledgementControlNumber *bool `json:"rolloverAcknowledgementControlNumber,omitempty"`
}

// EdifactAgreementContent ...
type EdifactAgreementContent struct {
	// ReceiveAgreement - The EDIFACT one-way receive agreement.
	ReceiveAgreement *EdifactOneWayAgreement `json:"receiveAgreement,omitempty"`
	// SendAgreement - The EDIFACT one-way send agreement.
	SendAgreement *EdifactOneWayAgreement `json:"sendAgreement,omitempty"`
}

// EdifactDelimiterOverride ...
type EdifactDelimiterOverride struct {
	// MessageID - The message id.
	MessageID *string `json:"messageId,omitempty"`
	// MessageVersion - The message version.
	MessageVersion *string `json:"messageVersion,omitempty"`
	// MessageRelease - The message release version.
	MessageRelease *string `json:"messageRelease,omitempty"`
	// DataElementSeparator - The data element separator.
	DataElementSeparator *int32 `json:"dataElementSeparator,omitempty"`
	// ComponentSeparator - The component separator.
	ComponentSeparator *int32 `json:"componentSeparator,omitempty"`
	// SegmentTerminator - The segment terminator.
	SegmentTerminator *int32 `json:"segmentTerminator,omitempty"`
	// RepetitionSeparator - The repetition separator.
	RepetitionSeparator *int32 `json:"repetitionSeparator,omitempty"`
	// SegmentTerminatorSuffix - The segment terminator suffix. Possible values include: 'SegmentTerminatorSuffixNotSpecified', 'SegmentTerminatorSuffixNone', 'SegmentTerminatorSuffixCR', 'SegmentTerminatorSuffixLF', 'SegmentTerminatorSuffixCRLF'
	SegmentTerminatorSuffix SegmentTerminatorSuffix `json:"segmentTerminatorSuffix,omitempty"`
	// DecimalPointIndicator - The decimal point indicator. Possible values include: 'EdifactDecimalIndicatorNotSpecified', 'EdifactDecimalIndicatorComma', 'EdifactDecimalIndicatorDecimal'
	DecimalPointIndicator EdifactDecimalIndicator `json:"decimalPointIndicator,omitempty"`
	// ReleaseIndicator - The release indicator.
	ReleaseIndicator *int32 `json:"releaseIndicator,omitempty"`
	// MessageAssociationAssignedCode - The message association assigned code.
	MessageAssociationAssignedCode *string `json:"messageAssociationAssignedCode,omitempty"`
	// TargetNamespace - The target namespace on which this delimiter settings has to be applied.
	TargetNamespace *string `json:"targetNamespace,omitempty"`
}

// EdifactEnvelopeOverride ...
type EdifactEnvelopeOverride struct {
	// MessageID - The message id on which this envelope settings has to be applied.
	MessageID *string `json:"messageId,omitempty"`
	// MessageVersion - The message version on which this envelope settings has to be applied.
	MessageVersion *string `json:"messageVersion,omitempty"`
	// MessageRelease - The message release version on which this envelope settings has to be applied.
	MessageRelease *string `json:"messageRelease,omitempty"`
	// MessageAssociationAssignedCode - The message association assigned code.
	MessageAssociationAssignedCode *string `json:"messageAssociationAssignedCode,omitempty"`
	// TargetNamespace - The target namespace on which this envelope settings has to be applied.
	TargetNamespace *string `json:"targetNamespace,omitempty"`
	// FunctionalGroupID - The functional group id.
	FunctionalGroupID *string `json:"functionalGroupId,omitempty"`
	// SenderApplicationQualifier - The sender application qualifier.
	SenderApplicationQualifier *string `json:"senderApplicationQualifier,omitempty"`
	// SenderApplicationID - The sender application id.
	SenderApplicationID *string `json:"senderApplicationId,omitempty"`
	// ReceiverApplicationQualifier - The receiver application qualifier.
	ReceiverApplicationQualifier *string `json:"receiverApplicationQualifier,omitempty"`
	// ReceiverApplicationID - The receiver application id.
	ReceiverApplicationID *string `json:"receiverApplicationId,omitempty"`
	// ControllingAgencyCode - The controlling agency code.
	ControllingAgencyCode *string `json:"controllingAgencyCode,omitempty"`
	// GroupHeaderMessageVersion - The group header message version.
	GroupHeaderMessageVersion *string `json:"groupHeaderMessageVersion,omitempty"`
	// GroupHeaderMessageRelease - The group header message release.
	GroupHeaderMessageRelease *string `json:"groupHeaderMessageRelease,omitempty"`
	// AssociationAssignedCode - The association assigned code.
	AssociationAssignedCode *string `json:"associationAssignedCode,omitempty"`
	// ApplicationPassword - The application password.
	ApplicationPassword *string `json:"applicationPassword,omitempty"`
}

// EdifactEnvelopeSettings ...
type EdifactEnvelopeSettings struct {
	// GroupAssociationAssignedCode - The group association assigned code.
	GroupAssociationAssignedCode *string `json:"groupAssociationAssignedCode,omitempty"`
	// CommunicationAgreementID - The communication agreement id.
	CommunicationAgreementID *string `json:"communicationAgreementId,omitempty"`
	// ApplyDelimiterStringAdvice - The value indicating whether to apply delimiter string advice.
	ApplyDelimiterStringAdvice *bool `json:"applyDelimiterStringAdvice,omitempty"`
	// CreateGroupingSegments - The value indicating whether to create grouping segments.
	CreateGroupingSegments *bool `json:"createGroupingSegments,omitempty"`
	// EnableDefaultGroupHeaders - The value indicating whether to enable default group headers.
	EnableDefaultGroupHeaders *bool `json:"enableDefaultGroupHeaders,omitempty"`
	// RecipientReferencePasswordValue - The recipient reference password value.
	RecipientReferencePasswordValue *string `json:"recipientReferencePasswordValue,omitempty"`
	// RecipientReferencePasswordQualifier - The recipient reference password qualifier.
	RecipientReferencePasswordQualifier *string `json:"recipientReferencePasswordQualifier,omitempty"`
	// ApplicationReferenceID - The application reference id.
	ApplicationReferenceID *string `json:"applicationReferenceId,omitempty"`
	// ProcessingPriorityCode - The processing priority code.
	ProcessingPriorityCode *string `json:"processingPriorityCode,omitempty"`
	// InterchangeControlNumberLowerBound - The interchange control number lower bound.
	InterchangeControlNumberLowerBound *int64 `json:"interchangeControlNumberLowerBound,omitempty"`
	// InterchangeControlNumberUpperBound - The interchange control number upper bound.
	InterchangeControlNumberUpperBound *int64 `json:"interchangeControlNumberUpperBound,omitempty"`
	// RolloverInterchangeControlNumber - The value indicating whether to rollover interchange control number.
	RolloverInterchangeControlNumber *bool `json:"rolloverInterchangeControlNumber,omitempty"`
	// InterchangeControlNumberPrefix - The interchange control number prefix.
	InterchangeControlNumberPrefix *string `json:"interchangeControlNumberPrefix,omitempty"`
	// InterchangeControlNumberSuffix - The interchange control number suffix.
	InterchangeControlNumberSuffix *string `json:"interchangeControlNumberSuffix,omitempty"`
	// SenderReverseRoutingAddress - The sender reverse routing address.
	SenderReverseRoutingAddress *string `json:"senderReverseRoutingAddress,omitempty"`
	// ReceiverReverseRoutingAddress - The receiver reverse routing address.
	ReceiverReverseRoutingAddress *string `json:"receiverReverseRoutingAddress,omitempty"`
	// FunctionalGroupID - The functional group id.
	FunctionalGroupID *string `json:"functionalGroupId,omitempty"`
	// GroupControllingAgencyCode - The group controlling agency code.
	GroupControllingAgencyCode *string `json:"groupControllingAgencyCode,omitempty"`
	// GroupMessageVersion - The group message version.
	GroupMessageVersion *string `json:"groupMessageVersion,omitempty"`
	// GroupMessageRelease - The group message release.
	GroupMessageRelease *string `json:"groupMessageRelease,omitempty"`
	// GroupControlNumberLowerBound - The group control number lower bound.
	GroupControlNumberLowerBound *int64 `json:"groupControlNumberLowerBound,omitempty"`
	// GroupControlNumberUpperBound - The group control number upper bound.
	GroupControlNumberUpperBound *int64 `json:"groupControlNumberUpperBound,omitempty"`
	// RolloverGroupControlNumber - The value indicating whether to rollover group control number.
	RolloverGroupControlNumber *bool `json:"rolloverGroupControlNumber,omitempty"`
	// GroupControlNumberPrefix - The group control number prefix.
	GroupControlNumberPrefix *string `json:"groupControlNumberPrefix,omitempty"`
	// GroupControlNumberSuffix - The group control number suffix.
	GroupControlNumberSuffix *string `json:"groupControlNumberSuffix,omitempty"`
	// GroupApplicationReceiverQualifier - The group application receiver qualifier.
	GroupApplicationReceiverQualifier *string `json:"groupApplicationReceiverQualifier,omitempty"`
	// GroupApplicationReceiverID - The group application receiver id.
	GroupApplicationReceiverID *string `json:"groupApplicationReceiverId,omitempty"`
	// GroupApplicationSenderQualifier - The group application sender qualifier.
	GroupApplicationSenderQualifier *string `json:"groupApplicationSenderQualifier,omitempty"`
	// GroupApplicationSenderID - The group application sender id.
	GroupApplicationSenderID *string `json:"groupApplicationSenderId,omitempty"`
	// GroupApplicationPassword - The group application password.
	GroupApplicationPassword *string `json:"groupApplicationPassword,omitempty"`
	// OverwriteExistingTransactionSetControlNumber - The value indicating whether to overwrite existing transaction set control number.
	OverwriteExistingTransactionSetControlNumber *bool `json:"overwriteExistingTransactionSetControlNumber,omitempty"`
	// TransactionSetControlNumberPrefix - The transaction set control number prefix.
	TransactionSetControlNumberPrefix *string `json:"transactionSetControlNumberPrefix,omitempty"`
	// TransactionSetControlNumberSuffix - The transaction set control number suffix.
	TransactionSetControlNumberSuffix *string `json:"transactionSetControlNumberSuffix,omitempty"`
	// TransactionSetControlNumberLowerBound - The transaction set control number lower bound.
	TransactionSetControlNumberLowerBound *int64 `json:"transactionSetControlNumberLowerBound,omitempty"`
	// TransactionSetControlNumberUpperBound - The transaction set control number upper bound.
	TransactionSetControlNumberUpperBound *int64 `json:"transactionSetControlNumberUpperBound,omitempty"`
	// RolloverTransactionSetControlNumber - The value indicating whether to rollover transaction set control number.
	RolloverTransactionSetControlNumber *bool `json:"rolloverTransactionSetControlNumber,omitempty"`
	// IsTestInterchange - The value indicating whether the message is a test interchange.
	IsTestInterchange *bool `json:"isTestInterchange,omitempty"`
	// SenderInternalIdentification - The sender internal identification.
	SenderInternalIdentification *string `json:"senderInternalIdentification,omitempty"`
	// SenderInternalSubIdentification - The sender internal sub identification.
	SenderInternalSubIdentification *string `json:"senderInternalSubIdentification,omitempty"`
	// ReceiverInternalIdentification - The receiver internal identification.
	ReceiverInternalIdentification *string `json:"receiverInternalIdentification,omitempty"`
	// ReceiverInternalSubIdentification - The receiver internal sub identification.
	ReceiverInternalSubIdentification *string `json:"receiverInternalSubIdentification,omitempty"`
}

// EdifactFramingSettings ...
type EdifactFramingSettings struct {
	// ServiceCodeListDirectoryVersion - The service code list directory version.
	ServiceCodeListDirectoryVersion *string `json:"serviceCodeListDirectoryVersion,omitempty"`
	// CharacterEncoding - The character encoding.
	CharacterEncoding *string `json:"characterEncoding,omitempty"`
	// ProtocolVersion - The protocol version.
	ProtocolVersion *int32 `json:"protocolVersion,omitempty"`
	// DataElementSeparator - The data element separator.
	DataElementSeparator *int32 `json:"dataElementSeparator,omitempty"`
	// ComponentSeparator - The component separator.
	ComponentSeparator *int32 `json:"componentSeparator,omitempty"`
	// SegmentTerminator - The segment terminator.
	SegmentTerminator *int32 `json:"segmentTerminator,omitempty"`
	// ReleaseIndicator - The release indicator.
	ReleaseIndicator *int32 `json:"releaseIndicator,omitempty"`
	// RepetitionSeparator - The repetition separator.
	RepetitionSeparator *int32 `json:"repetitionSeparator,omitempty"`
	// CharacterSet - The EDIFACT frame setting characterSet. Possible values include: 'EdifactCharacterSetNotSpecified', 'EdifactCharacterSetUNOB', 'EdifactCharacterSetUNOA', 'EdifactCharacterSetUNOC', 'EdifactCharacterSetUNOD', 'EdifactCharacterSetUNOE', 'EdifactCharacterSetUNOF', 'EdifactCharacterSetUNOG', 'EdifactCharacterSetUNOH', 'EdifactCharacterSetUNOI', 'EdifactCharacterSetUNOJ', 'EdifactCharacterSetUNOK', 'EdifactCharacterSetUNOX', 'EdifactCharacterSetUNOY', 'EdifactCharacterSetKECA'
	CharacterSet EdifactCharacterSet `json:"characterSet,omitempty"`
	// DecimalPointIndicator - The EDIFACT frame setting decimal indicator. Possible values include: 'EdifactDecimalIndicatorNotSpecified', 'EdifactDecimalIndicatorComma', 'EdifactDecimalIndicatorDecimal'
	DecimalPointIndicator EdifactDecimalIndicator `json:"decimalPointIndicator,omitempty"`
	// SegmentTerminatorSuffix - The EDIFACT frame setting segment terminator suffix. Possible values include: 'SegmentTerminatorSuffixNotSpecified', 'SegmentTerminatorSuffixNone', 'SegmentTerminatorSuffixCR', 'SegmentTerminatorSuffixLF', 'SegmentTerminatorSuffixCRLF'
	SegmentTerminatorSuffix SegmentTerminatorSuffix `json:"segmentTerminatorSuffix,omitempty"`
}

// EdifactMessageFilter ...
type EdifactMessageFilter struct {
	// MessageFilterType - The message filter type. Possible values include: 'MessageFilterTypeNotSpecified', 'MessageFilterTypeInclude', 'MessageFilterTypeExclude'
	MessageFilterType MessageFilterType `json:"messageFilterType,omitempty"`
}

// EdifactMessageIdentifier ...
type EdifactMessageIdentifier struct {
	// MessageID - The message id on which this envelope settings has to be applied.
	MessageID *string `json:"messageId,omitempty"`
}

// EdifactOneWayAgreement ...
type EdifactOneWayAgreement struct {
	// SenderBusinessIdentity - The sender business identity
	SenderBusinessIdentity *BusinessIdentity `json:"senderBusinessIdentity,omitempty"`
	// ReceiverBusinessIdentity - The receiver business identity
	ReceiverBusinessIdentity *BusinessIdentity `json:"receiverBusinessIdentity,omitempty"`
	// ProtocolSettings - The EDIFACT protocol settings.
	ProtocolSettings *EdifactProtocolSettings `json:"protocolSettings,omitempty"`
}

// EdifactProcessingSettings ...
type EdifactProcessingSettings struct {
	// MaskSecurityInfo - The value indicating whether to mask security information.
	MaskSecurityInfo *bool `json:"maskSecurityInfo,omitempty"`
	// PreserveInterchange - The value indicating whether to preserve interchange.
	PreserveInterchange *bool `json:"preserveInterchange,omitempty"`
	// SuspendInterchangeOnError - The value indicating whether to suspend interchange on error.
	SuspendInterchangeOnError *bool `json:"suspendInterchangeOnError,omitempty"`
	// CreateEmptyXMLTagsForTrailingSeparators - The value indicating whether to create empty xml tags for trailing separators.
	CreateEmptyXMLTagsForTrailingSeparators *bool `json:"createEmptyXmlTagsForTrailingSeparators,omitempty"`
	// UseDotAsDecimalSeparator - The value indicating whether to use dot as decimal separator.
	UseDotAsDecimalSeparator *bool `json:"useDotAsDecimalSeparator,omitempty"`
}

// EdifactProtocolSettings ...
type EdifactProtocolSettings struct {
	// ValidationSettings - The EDIFACT validation settings.
	ValidationSettings *EdifactValidationSettings `json:"validationSettings,omitempty"`
	// FramingSettings - The EDIFACT framing settings.
	FramingSettings *EdifactFramingSettings `json:"framingSettings,omitempty"`
	// EnvelopeSettings - The EDIFACT envelope settings.
	EnvelopeSettings *EdifactEnvelopeSettings `json:"envelopeSettings,omitempty"`
	// AcknowledgementSettings - The EDIFACT acknowledgement settings.
	AcknowledgementSettings *EdifactAcknowledgementSettings `json:"acknowledgementSettings,omitempty"`
	// MessageFilter - The EDIFACT message filter.
	MessageFilter *EdifactMessageFilter `json:"messageFilter,omitempty"`
	// ProcessingSettings - The EDIFACT processing Settings.
	ProcessingSettings *EdifactProcessingSettings `json:"processingSettings,omitempty"`
	// EnvelopeOverrides - The EDIFACT envelope override settings.
	EnvelopeOverrides *[]EdifactEnvelopeOverride `json:"envelopeOverrides,omitempty"`
	// MessageFilterList - The EDIFACT message filter list.
	MessageFilterList *[]EdifactMessageIdentifier `json:"messageFilterList,omitempty"`
	// SchemaReferences - The EDIFACT schema references.
	SchemaReferences *[]EdifactSchemaReference `json:"schemaReferences,omitempty"`
	// ValidationOverrides - The EDIFACT validation override settings.
	ValidationOverrides *[]EdifactValidationOverride `json:"validationOverrides,omitempty"`
	// EdifactDelimiterOverrides - The EDIFACT delimiter override settings.
	EdifactDelimiterOverrides *[]EdifactDelimiterOverride `json:"edifactDelimiterOverrides,omitempty"`
}

// EdifactSchemaReference ...
type EdifactSchemaReference struct {
	// MessageID - The message id.
	MessageID *string `json:"messageId,omitempty"`
	// MessageVersion - The message version.
	MessageVersion *string `json:"messageVersion,omitempty"`
	// MessageRelease - The message release version.
	MessageRelease *string `json:"messageRelease,omitempty"`
	// SenderApplicationID - The sender application id.
	SenderApplicationID *string `json:"senderApplicationId,omitempty"`
	// SenderApplicationQualifier - The sender application qualifier.
	SenderApplicationQualifier *string `json:"senderApplicationQualifier,omitempty"`
	// AssociationAssignedCode - The association assigned code.
	AssociationAssignedCode *string `json:"associationAssignedCode,omitempty"`
	// SchemaName - The schema name.
	SchemaName *string `json:"schemaName,omitempty"`
}

// EdifactValidationOverride ...
type EdifactValidationOverride struct {
	// MessageID - The message id on which the validation settings has to be applied.
	MessageID *string `json:"messageId,omitempty"`
	// EnforceCharacterSet - The value indicating whether to validate character Set.
	EnforceCharacterSet *bool `json:"enforceCharacterSet,omitempty"`
	// ValidateEDITypes - The value indicating whether to validate EDI types.
	ValidateEDITypes *bool `json:"validateEDITypes,omitempty"`
	// ValidateXSDTypes - The value indicating whether to validate XSD types.
	ValidateXSDTypes *bool `json:"validateXSDTypes,omitempty"`
	// AllowLeadingAndTrailingSpacesAndZeroes - The value indicating whether to allow leading and trailing spaces and zeroes.
	AllowLeadingAndTrailingSpacesAndZeroes *bool `json:"allowLeadingAndTrailingSpacesAndZeroes,omitempty"`
	// TrailingSeparatorPolicy - The trailing separator policy. Possible values include: 'TrailingSeparatorPolicyNotSpecified', 'TrailingSeparatorPolicyNotAllowed', 'TrailingSeparatorPolicyOptional', 'TrailingSeparatorPolicyMandatory'
	TrailingSeparatorPolicy TrailingSeparatorPolicy `json:"trailingSeparatorPolicy,omitempty"`
	// TrimLeadingAndTrailingSpacesAndZeroes - The value indicating whether to trim leading and trailing spaces and zeroes.
	TrimLeadingAndTrailingSpacesAndZeroes *bool `json:"trimLeadingAndTrailingSpacesAndZeroes,omitempty"`
}

// EdifactValidationSettings ...
type EdifactValidationSettings struct {
	// ValidateCharacterSet - The value indicating whether to validate character set in the message.
	ValidateCharacterSet *bool `json:"validateCharacterSet,omitempty"`
	// CheckDuplicateInterchangeControlNumber - The value indicating whether to check for duplicate interchange control number.
	CheckDuplicateInterchangeControlNumber *bool `json:"checkDuplicateInterchangeControlNumber,omitempty"`
	// InterchangeControlNumberValidityDays - The validity period of interchange control number.
	InterchangeControlNumberValidityDays *int32 `json:"interchangeControlNumberValidityDays,omitempty"`
	// CheckDuplicateGroupControlNumber - The value indicating whether to check for duplicate group control number.
	CheckDuplicateGroupControlNumber *bool `json:"checkDuplicateGroupControlNumber,omitempty"`
	// CheckDuplicateTransactionSetControlNumber - The value indicating whether to check for duplicate transaction set control number.
	CheckDuplicateTransactionSetControlNumber *bool `json:"checkDuplicateTransactionSetControlNumber,omitempty"`
	// ValidateEDITypes - The value indicating whether to Whether to validate EDI types.
	ValidateEDITypes *bool `json:"validateEDITypes,omitempty"`
	// ValidateXSDTypes - The value indicating whether to Whether to validate XSD types.
	ValidateXSDTypes *bool `json:"validateXSDTypes,omitempty"`
	// AllowLeadingAndTrailingSpacesAndZeroes - The value indicating whether to allow leading and trailing spaces and zeroes.
	AllowLeadingAndTrailingSpacesAndZeroes *bool `json:"allowLeadingAndTrailingSpacesAndZeroes,omitempty"`
	// TrimLeadingAndTrailingSpacesAndZeroes - The value indicating whether to trim leading and trailing spaces and zeroes.
	TrimLeadingAndTrailingSpacesAndZeroes *bool `json:"trimLeadingAndTrailingSpacesAndZeroes,omitempty"`
	// TrailingSeparatorPolicy - The trailing separator policy. Possible values include: 'TrailingSeparatorPolicyNotSpecified', 'TrailingSeparatorPolicyNotAllowed', 'TrailingSeparatorPolicyOptional', 'TrailingSeparatorPolicyMandatory'
	TrailingSeparatorPolicy TrailingSeparatorPolicy `json:"trailingSeparatorPolicy,omitempty"`
}

// IntegrationAccount ...
type IntegrationAccount struct {
	autorest.Response `json:"-"`
	// Properties - The integration account properties.
	Properties interface{} `json:"properties,omitempty"`
	// Sku - The sku.
	Sku *IntegrationAccountSku `json:"sku,omitempty"`
	// ID - The resource id.
	ID *string `json:"id,omitempty"`
	// Name - The resource name.
	Name *string `json:"name,omitempty"`
	// Type - The resource type.
	Type *string `json:"type,omitempty"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for IntegrationAccount.
func (ia IntegrationAccount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ia.Properties != nil {
		objectMap["properties"] = ia.Properties
	}
	if ia.Sku != nil {
		objectMap["sku"] = ia.Sku
	}
	if ia.ID != nil {
		objectMap["id"] = ia.ID
	}
	if ia.Name != nil {
		objectMap["name"] = ia.Name
	}
	if ia.Type != nil {
		objectMap["type"] = ia.Type
	}
	if ia.Location != nil {
		objectMap["location"] = ia.Location
	}
	if ia.Tags != nil {
		objectMap["tags"] = ia.Tags
	}
	return json.Marshal(objectMap)
}

// IntegrationAccountAgreement ...
type IntegrationAccountAgreement struct {
	autorest.Response `json:"-"`
	// IntegrationAccountAgreementProperties - The integration account agreement properties.
	*IntegrationAccountAgreementProperties `json:"properties,omitempty"`
	// ID - The resource id.
	ID *string `json:"id,omitempty"`
	// Name - The resource name.
	Name *string `json:"name,omitempty"`
	// Type - The resource type.
	Type *string `json:"type,omitempty"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for IntegrationAccountAgreement.
func (iaa IntegrationAccountAgreement) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if iaa.IntegrationAccountAgreementProperties != nil {
		objectMap["properties"] = iaa.IntegrationAccountAgreementProperties
	}
	if iaa.ID != nil {
		objectMap["id"] = iaa.ID
	}
	if iaa.Name != nil {
		objectMap["name"] = iaa.Name
	}
	if iaa.Type != nil {
		objectMap["type"] = iaa.Type
	}
	if iaa.Location != nil {
		objectMap["location"] = iaa.Location
	}
	if iaa.Tags != nil {
		objectMap["tags"] = iaa.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IntegrationAccountAgreement struct.
func (iaa *IntegrationAccountAgreement) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var integrationAccountAgreementProperties IntegrationAccountAgreementProperties
				err = json.Unmarshal(*v, &integrationAccountAgreementProperties)
				if err != nil {
					return err
				}
				iaa.IntegrationAccountAgreementProperties = &integrationAccountAgreementProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				iaa.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				iaa.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				iaa.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				iaa.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				iaa.Tags = tags
			}
		}
	}

	return nil
}

// IntegrationAccountAgreementFilter ...
type IntegrationAccountAgreementFilter struct {
	// AgreementType - The agreement type of integration account agreement. Possible values include: 'NotSpecified', 'AS2', 'X12', 'Edifact'
	AgreementType AgreementType `json:"agreementType,omitempty"`
}

// IntegrationAccountAgreementListResult ...
type IntegrationAccountAgreementListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of integration account agreements.
	Value *[]IntegrationAccountAgreement `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// IntegrationAccountAgreementListResultIterator provides access to a complete listing of
// IntegrationAccountAgreement values.
type IntegrationAccountAgreementListResultIterator struct {
	i    int
	page IntegrationAccountAgreementListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IntegrationAccountAgreementListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IntegrationAccountAgreementListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IntegrationAccountAgreementListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IntegrationAccountAgreementListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IntegrationAccountAgreementListResultIterator) Response() IntegrationAccountAgreementListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IntegrationAccountAgreementListResultIterator) Value() IntegrationAccountAgreement {
	if !iter.page.NotDone() {
		return IntegrationAccountAgreement{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IntegrationAccountAgreementListResultIterator type.
func NewIntegrationAccountAgreementListResultIterator(page IntegrationAccountAgreementListResultPage) IntegrationAccountAgreementListResultIterator {
	return IntegrationAccountAgreementListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (iaalr IntegrationAccountAgreementListResult) IsEmpty() bool {
	return iaalr.Value == nil || len(*iaalr.Value) == 0
}

// integrationAccountAgreementListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (iaalr IntegrationAccountAgreementListResult) integrationAccountAgreementListResultPreparer(ctx context.Context) (*http.Request, error) {
	if iaalr.NextLink == nil || len(to.String(iaalr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(iaalr.NextLink)))
}

// IntegrationAccountAgreementListResultPage contains a page of IntegrationAccountAgreement values.
type IntegrationAccountAgreementListResultPage struct {
	fn    func(context.Context, IntegrationAccountAgreementListResult) (IntegrationAccountAgreementListResult, error)
	iaalr IntegrationAccountAgreementListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IntegrationAccountAgreementListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IntegrationAccountAgreementListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.iaalr)
	if err != nil {
		return err
	}
	page.iaalr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IntegrationAccountAgreementListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IntegrationAccountAgreementListResultPage) NotDone() bool {
	return !page.iaalr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IntegrationAccountAgreementListResultPage) Response() IntegrationAccountAgreementListResult {
	return page.iaalr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IntegrationAccountAgreementListResultPage) Values() []IntegrationAccountAgreement {
	if page.iaalr.IsEmpty() {
		return nil
	}
	return *page.iaalr.Value
}

// Creates a new instance of the IntegrationAccountAgreementListResultPage type.
func NewIntegrationAccountAgreementListResultPage(getNextPage func(context.Context, IntegrationAccountAgreementListResult) (IntegrationAccountAgreementListResult, error)) IntegrationAccountAgreementListResultPage {
	return IntegrationAccountAgreementListResultPage{fn: getNextPage}
}

// IntegrationAccountAgreementProperties ...
type IntegrationAccountAgreementProperties struct {
	// CreatedTime - The created time.
	CreatedTime *date.Time `json:"createdTime,omitempty"`
	// ChangedTime - The changed time.
	ChangedTime *date.Time `json:"changedTime,omitempty"`
	// Metadata - The metadata.
	Metadata interface{} `json:"metadata,omitempty"`
	// AgreementType - The agreement type. Possible values include: 'NotSpecified', 'AS2', 'X12', 'Edifact'
	AgreementType AgreementType `json:"agreementType,omitempty"`
	// HostPartner - The host partner.
	HostPartner *string `json:"hostPartner,omitempty"`
	// GuestPartner - The guest partner.
	GuestPartner *string `json:"guestPartner,omitempty"`
	// HostIdentity - The host identity.
	HostIdentity *BusinessIdentity `json:"hostIdentity,omitempty"`
	// GuestIdentity - The guest identity.
	GuestIdentity *BusinessIdentity `json:"guestIdentity,omitempty"`
	// Content - The agreement content.
	Content *AgreementContent `json:"content,omitempty"`
}

// IntegrationAccountCertificate ...
type IntegrationAccountCertificate struct {
	autorest.Response `json:"-"`
	// IntegrationAccountCertificateProperties - The integration account certificate properties.
	*IntegrationAccountCertificateProperties `json:"properties,omitempty"`
	// ID - The resource id.
	ID *string `json:"id,omitempty"`
	// Name - The resource name.
	Name *string `json:"name,omitempty"`
	// Type - The resource type.
	Type *string `json:"type,omitempty"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for IntegrationAccountCertificate.
func (iac IntegrationAccountCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if iac.IntegrationAccountCertificateProperties != nil {
		objectMap["properties"] = iac.IntegrationAccountCertificateProperties
	}
	if iac.ID != nil {
		objectMap["id"] = iac.ID
	}
	if iac.Name != nil {
		objectMap["name"] = iac.Name
	}
	if iac.Type != nil {
		objectMap["type"] = iac.Type
	}
	if iac.Location != nil {
		objectMap["location"] = iac.Location
	}
	if iac.Tags != nil {
		objectMap["tags"] = iac.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IntegrationAccountCertificate struct.
func (iac *IntegrationAccountCertificate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var integrationAccountCertificateProperties IntegrationAccountCertificateProperties
				err = json.Unmarshal(*v, &integrationAccountCertificateProperties)
				if err != nil {
					return err
				}
				iac.IntegrationAccountCertificateProperties = &integrationAccountCertificateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				iac.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				iac.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				iac.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				iac.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				iac.Tags = tags
			}
		}
	}

	return nil
}

// IntegrationAccountCertificateListResult ...
type IntegrationAccountCertificateListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of integration account certificates.
	Value *[]IntegrationAccountCertificate `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// IntegrationAccountCertificateListResultIterator provides access to a complete listing of
// IntegrationAccountCertificate values.
type IntegrationAccountCertificateListResultIterator struct {
	i    int
	page IntegrationAccountCertificateListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IntegrationAccountCertificateListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IntegrationAccountCertificateListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IntegrationAccountCertificateListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IntegrationAccountCertificateListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IntegrationAccountCertificateListResultIterator) Response() IntegrationAccountCertificateListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IntegrationAccountCertificateListResultIterator) Value() IntegrationAccountCertificate {
	if !iter.page.NotDone() {
		return IntegrationAccountCertificate{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IntegrationAccountCertificateListResultIterator type.
func NewIntegrationAccountCertificateListResultIterator(page IntegrationAccountCertificateListResultPage) IntegrationAccountCertificateListResultIterator {
	return IntegrationAccountCertificateListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (iaclr IntegrationAccountCertificateListResult) IsEmpty() bool {
	return iaclr.Value == nil || len(*iaclr.Value) == 0
}

// integrationAccountCertificateListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (iaclr IntegrationAccountCertificateListResult) integrationAccountCertificateListResultPreparer(ctx context.Context) (*http.Request, error) {
	if iaclr.NextLink == nil || len(to.String(iaclr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(iaclr.NextLink)))
}

// IntegrationAccountCertificateListResultPage contains a page of IntegrationAccountCertificate values.
type IntegrationAccountCertificateListResultPage struct {
	fn    func(context.Context, IntegrationAccountCertificateListResult) (IntegrationAccountCertificateListResult, error)
	iaclr IntegrationAccountCertificateListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IntegrationAccountCertificateListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IntegrationAccountCertificateListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.iaclr)
	if err != nil {
		return err
	}
	page.iaclr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IntegrationAccountCertificateListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IntegrationAccountCertificateListResultPage) NotDone() bool {
	return !page.iaclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IntegrationAccountCertificateListResultPage) Response() IntegrationAccountCertificateListResult {
	return page.iaclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IntegrationAccountCertificateListResultPage) Values() []IntegrationAccountCertificate {
	if page.iaclr.IsEmpty() {
		return nil
	}
	return *page.iaclr.Value
}

// Creates a new instance of the IntegrationAccountCertificateListResultPage type.
func NewIntegrationAccountCertificateListResultPage(getNextPage func(context.Context, IntegrationAccountCertificateListResult) (IntegrationAccountCertificateListResult, error)) IntegrationAccountCertificateListResultPage {
	return IntegrationAccountCertificateListResultPage{fn: getNextPage}
}

// IntegrationAccountCertificateProperties ...
type IntegrationAccountCertificateProperties struct {
	// CreatedTime - The created time.
	CreatedTime *date.Time `json:"createdTime,omitempty"`
	// ChangedTime - The changed time.
	ChangedTime *date.Time `json:"changedTime,omitempty"`
	// Metadata - The metadata.
	Metadata interface{} `json:"metadata,omitempty"`
	// Key - The key details in the key vault.
	Key *KeyVaultKeyReference `json:"key,omitempty"`
	// PublicCertificate - The public certificate.
	PublicCertificate *string `json:"publicCertificate,omitempty"`
}

// IntegrationAccountContentHash ...
type IntegrationAccountContentHash struct {
	// Algorithm - The content hash algorithm.
	Algorithm *string `json:"algorithm,omitempty"`
	// Value - The content hash value.
	Value *string `json:"value,omitempty"`
}

// IntegrationAccountContentLink ...
type IntegrationAccountContentLink struct {
	// URI - The content link URI.
	URI *string `json:"uri,omitempty"`
	// ContentVersion - The content version.
	ContentVersion *string `json:"contentVersion,omitempty"`
	// ContentSize - The content size.
	ContentSize *int64 `json:"contentSize,omitempty"`
	// ContentHash - The content hash.
	ContentHash *IntegrationAccountContentHash `json:"contentHash,omitempty"`
	// Metadata - The metadata.
	Metadata interface{} `json:"metadata,omitempty"`
}

// IntegrationAccountListResult ...
type IntegrationAccountListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of integration accounts.
	Value *[]IntegrationAccount `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// IntegrationAccountListResultIterator provides access to a complete listing of IntegrationAccount values.
type IntegrationAccountListResultIterator struct {
	i    int
	page IntegrationAccountListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IntegrationAccountListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IntegrationAccountListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IntegrationAccountListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IntegrationAccountListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IntegrationAccountListResultIterator) Response() IntegrationAccountListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IntegrationAccountListResultIterator) Value() IntegrationAccount {
	if !iter.page.NotDone() {
		return IntegrationAccount{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IntegrationAccountListResultIterator type.
func NewIntegrationAccountListResultIterator(page IntegrationAccountListResultPage) IntegrationAccountListResultIterator {
	return IntegrationAccountListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ialr IntegrationAccountListResult) IsEmpty() bool {
	return ialr.Value == nil || len(*ialr.Value) == 0
}

// integrationAccountListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ialr IntegrationAccountListResult) integrationAccountListResultPreparer(ctx context.Context) (*http.Request, error) {
	if ialr.NextLink == nil || len(to.String(ialr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ialr.NextLink)))
}

// IntegrationAccountListResultPage contains a page of IntegrationAccount values.
type IntegrationAccountListResultPage struct {
	fn   func(context.Context, IntegrationAccountListResult) (IntegrationAccountListResult, error)
	ialr IntegrationAccountListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IntegrationAccountListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IntegrationAccountListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ialr)
	if err != nil {
		return err
	}
	page.ialr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IntegrationAccountListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IntegrationAccountListResultPage) NotDone() bool {
	return !page.ialr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IntegrationAccountListResultPage) Response() IntegrationAccountListResult {
	return page.ialr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IntegrationAccountListResultPage) Values() []IntegrationAccount {
	if page.ialr.IsEmpty() {
		return nil
	}
	return *page.ialr.Value
}

// Creates a new instance of the IntegrationAccountListResultPage type.
func NewIntegrationAccountListResultPage(getNextPage func(context.Context, IntegrationAccountListResult) (IntegrationAccountListResult, error)) IntegrationAccountListResultPage {
	return IntegrationAccountListResultPage{fn: getNextPage}
}

// IntegrationAccountMap ...
type IntegrationAccountMap struct {
	autorest.Response `json:"-"`
	// IntegrationAccountMapProperties - The integration account map properties.
	*IntegrationAccountMapProperties `json:"properties,omitempty"`
	// ID - The resource id.
	ID *string `json:"id,omitempty"`
	// Name - The resource name.
	Name *string `json:"name,omitempty"`
	// Type - The resource type.
	Type *string `json:"type,omitempty"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for IntegrationAccountMap.
func (iam IntegrationAccountMap) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if iam.IntegrationAccountMapProperties != nil {
		objectMap["properties"] = iam.IntegrationAccountMapProperties
	}
	if iam.ID != nil {
		objectMap["id"] = iam.ID
	}
	if iam.Name != nil {
		objectMap["name"] = iam.Name
	}
	if iam.Type != nil {
		objectMap["type"] = iam.Type
	}
	if iam.Location != nil {
		objectMap["location"] = iam.Location
	}
	if iam.Tags != nil {
		objectMap["tags"] = iam.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IntegrationAccountMap struct.
func (iam *IntegrationAccountMap) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var integrationAccountMapProperties IntegrationAccountMapProperties
				err = json.Unmarshal(*v, &integrationAccountMapProperties)
				if err != nil {
					return err
				}
				iam.IntegrationAccountMapProperties = &integrationAccountMapProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				iam.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				iam.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				iam.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				iam.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				iam.Tags = tags
			}
		}
	}

	return nil
}

// IntegrationAccountMapFilter ...
type IntegrationAccountMapFilter struct {
	// SchemaType - The map type of integration account map. Possible values include: 'MapTypeNotSpecified', 'MapTypeXslt'
	SchemaType MapType `json:"schemaType,omitempty"`
}

// IntegrationAccountMapListResult ...
type IntegrationAccountMapListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of integration account maps.
	Value *[]IntegrationAccountMap `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// IntegrationAccountMapListResultIterator provides access to a complete listing of IntegrationAccountMap
// values.
type IntegrationAccountMapListResultIterator struct {
	i    int
	page IntegrationAccountMapListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IntegrationAccountMapListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IntegrationAccountMapListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IntegrationAccountMapListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IntegrationAccountMapListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IntegrationAccountMapListResultIterator) Response() IntegrationAccountMapListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IntegrationAccountMapListResultIterator) Value() IntegrationAccountMap {
	if !iter.page.NotDone() {
		return IntegrationAccountMap{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IntegrationAccountMapListResultIterator type.
func NewIntegrationAccountMapListResultIterator(page IntegrationAccountMapListResultPage) IntegrationAccountMapListResultIterator {
	return IntegrationAccountMapListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (iamlr IntegrationAccountMapListResult) IsEmpty() bool {
	return iamlr.Value == nil || len(*iamlr.Value) == 0
}

// integrationAccountMapListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (iamlr IntegrationAccountMapListResult) integrationAccountMapListResultPreparer(ctx context.Context) (*http.Request, error) {
	if iamlr.NextLink == nil || len(to.String(iamlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(iamlr.NextLink)))
}

// IntegrationAccountMapListResultPage contains a page of IntegrationAccountMap values.
type IntegrationAccountMapListResultPage struct {
	fn    func(context.Context, IntegrationAccountMapListResult) (IntegrationAccountMapListResult, error)
	iamlr IntegrationAccountMapListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IntegrationAccountMapListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IntegrationAccountMapListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.iamlr)
	if err != nil {
		return err
	}
	page.iamlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IntegrationAccountMapListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IntegrationAccountMapListResultPage) NotDone() bool {
	return !page.iamlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IntegrationAccountMapListResultPage) Response() IntegrationAccountMapListResult {
	return page.iamlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IntegrationAccountMapListResultPage) Values() []IntegrationAccountMap {
	if page.iamlr.IsEmpty() {
		return nil
	}
	return *page.iamlr.Value
}

// Creates a new instance of the IntegrationAccountMapListResultPage type.
func NewIntegrationAccountMapListResultPage(getNextPage func(context.Context, IntegrationAccountMapListResult) (IntegrationAccountMapListResult, error)) IntegrationAccountMapListResultPage {
	return IntegrationAccountMapListResultPage{fn: getNextPage}
}

// IntegrationAccountMapProperties ...
type IntegrationAccountMapProperties struct {
	// MapType - The map type. Possible values include: 'MapTypeNotSpecified', 'MapTypeXslt'
	MapType MapType `json:"mapType,omitempty"`
	// CreatedTime - The created time.
	CreatedTime *date.Time `json:"createdTime,omitempty"`
	// ChangedTime - The changed time.
	ChangedTime *date.Time `json:"changedTime,omitempty"`
	// Content - The content.
	Content interface{} `json:"content,omitempty"`
	// ContentType - The content type.
	ContentType *string `json:"contentType,omitempty"`
	// ContentLink - The content link.
	ContentLink *IntegrationAccountContentLink `json:"contentLink,omitempty"`
	// Metadata - The metadata.
	Metadata interface{} `json:"metadata,omitempty"`
}

// IntegrationAccountPartner ...
type IntegrationAccountPartner struct {
	autorest.Response `json:"-"`
	// IntegrationAccountPartnerProperties - The integration account partner properties.
	*IntegrationAccountPartnerProperties `json:"properties,omitempty"`
	// ID - The resource id.
	ID *string `json:"id,omitempty"`
	// Name - The resource name.
	Name *string `json:"name,omitempty"`
	// Type - The resource type.
	Type *string `json:"type,omitempty"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for IntegrationAccountPartner.
func (iap IntegrationAccountPartner) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if iap.IntegrationAccountPartnerProperties != nil {
		objectMap["properties"] = iap.IntegrationAccountPartnerProperties
	}
	if iap.ID != nil {
		objectMap["id"] = iap.ID
	}
	if iap.Name != nil {
		objectMap["name"] = iap.Name
	}
	if iap.Type != nil {
		objectMap["type"] = iap.Type
	}
	if iap.Location != nil {
		objectMap["location"] = iap.Location
	}
	if iap.Tags != nil {
		objectMap["tags"] = iap.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IntegrationAccountPartner struct.
func (iap *IntegrationAccountPartner) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var integrationAccountPartnerProperties IntegrationAccountPartnerProperties
				err = json.Unmarshal(*v, &integrationAccountPartnerProperties)
				if err != nil {
					return err
				}
				iap.IntegrationAccountPartnerProperties = &integrationAccountPartnerProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				iap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				iap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				iap.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				iap.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				iap.Tags = tags
			}
		}
	}

	return nil
}

// IntegrationAccountPartnerFilter ...
type IntegrationAccountPartnerFilter struct {
	// PartnerType - The partner type of integration account partner. Possible values include: 'PartnerTypeNotSpecified', 'PartnerTypeB2B'
	PartnerType PartnerType `json:"partnerType,omitempty"`
}

// IntegrationAccountPartnerListResult ...
type IntegrationAccountPartnerListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of integration account partners.
	Value *[]IntegrationAccountPartner `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// IntegrationAccountPartnerListResultIterator provides access to a complete listing of
// IntegrationAccountPartner values.
type IntegrationAccountPartnerListResultIterator struct {
	i    int
	page IntegrationAccountPartnerListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IntegrationAccountPartnerListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IntegrationAccountPartnerListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IntegrationAccountPartnerListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IntegrationAccountPartnerListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IntegrationAccountPartnerListResultIterator) Response() IntegrationAccountPartnerListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IntegrationAccountPartnerListResultIterator) Value() IntegrationAccountPartner {
	if !iter.page.NotDone() {
		return IntegrationAccountPartner{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IntegrationAccountPartnerListResultIterator type.
func NewIntegrationAccountPartnerListResultIterator(page IntegrationAccountPartnerListResultPage) IntegrationAccountPartnerListResultIterator {
	return IntegrationAccountPartnerListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (iaplr IntegrationAccountPartnerListResult) IsEmpty() bool {
	return iaplr.Value == nil || len(*iaplr.Value) == 0
}

// integrationAccountPartnerListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (iaplr IntegrationAccountPartnerListResult) integrationAccountPartnerListResultPreparer(ctx context.Context) (*http.Request, error) {
	if iaplr.NextLink == nil || len(to.String(iaplr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(iaplr.NextLink)))
}

// IntegrationAccountPartnerListResultPage contains a page of IntegrationAccountPartner values.
type IntegrationAccountPartnerListResultPage struct {
	fn    func(context.Context, IntegrationAccountPartnerListResult) (IntegrationAccountPartnerListResult, error)
	iaplr IntegrationAccountPartnerListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IntegrationAccountPartnerListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IntegrationAccountPartnerListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.iaplr)
	if err != nil {
		return err
	}
	page.iaplr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IntegrationAccountPartnerListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IntegrationAccountPartnerListResultPage) NotDone() bool {
	return !page.iaplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IntegrationAccountPartnerListResultPage) Response() IntegrationAccountPartnerListResult {
	return page.iaplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IntegrationAccountPartnerListResultPage) Values() []IntegrationAccountPartner {
	if page.iaplr.IsEmpty() {
		return nil
	}
	return *page.iaplr.Value
}

// Creates a new instance of the IntegrationAccountPartnerListResultPage type.
func NewIntegrationAccountPartnerListResultPage(getNextPage func(context.Context, IntegrationAccountPartnerListResult) (IntegrationAccountPartnerListResult, error)) IntegrationAccountPartnerListResultPage {
	return IntegrationAccountPartnerListResultPage{fn: getNextPage}
}

// IntegrationAccountPartnerProperties ...
type IntegrationAccountPartnerProperties struct {
	// PartnerType - The partner type. Possible values include: 'PartnerTypeNotSpecified', 'PartnerTypeB2B'
	PartnerType PartnerType `json:"partnerType,omitempty"`
	// CreatedTime - The created time.
	CreatedTime *date.Time `json:"createdTime,omitempty"`
	// ChangedTime - The changed time.
	ChangedTime *date.Time `json:"changedTime,omitempty"`
	// Metadata - The metadata.
	Metadata interface{} `json:"metadata,omitempty"`
	// Content - The partner content.
	Content *PartnerContent `json:"content,omitempty"`
}

// IntegrationAccountResource ...
type IntegrationAccountResource struct {
	// ID - The resource id.
	ID *string `json:"id,omitempty"`
	// Name - The resource name.
	Name *string `json:"name,omitempty"`
	// Type - The resource type.
	Type *string `json:"type,omitempty"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for IntegrationAccountResource.
func (iar IntegrationAccountResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if iar.ID != nil {
		objectMap["id"] = iar.ID
	}
	if iar.Name != nil {
		objectMap["name"] = iar.Name
	}
	if iar.Type != nil {
		objectMap["type"] = iar.Type
	}
	if iar.Location != nil {
		objectMap["location"] = iar.Location
	}
	if iar.Tags != nil {
		objectMap["tags"] = iar.Tags
	}
	return json.Marshal(objectMap)
}

// IntegrationAccountSchema ...
type IntegrationAccountSchema struct {
	autorest.Response `json:"-"`
	// IntegrationAccountSchemaProperties - The integration account schema properties.
	*IntegrationAccountSchemaProperties `json:"properties,omitempty"`
	// ID - The resource id.
	ID *string `json:"id,omitempty"`
	// Name - The resource name.
	Name *string `json:"name,omitempty"`
	// Type - The resource type.
	Type *string `json:"type,omitempty"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for IntegrationAccountSchema.
func (ias IntegrationAccountSchema) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ias.IntegrationAccountSchemaProperties != nil {
		objectMap["properties"] = ias.IntegrationAccountSchemaProperties
	}
	if ias.ID != nil {
		objectMap["id"] = ias.ID
	}
	if ias.Name != nil {
		objectMap["name"] = ias.Name
	}
	if ias.Type != nil {
		objectMap["type"] = ias.Type
	}
	if ias.Location != nil {
		objectMap["location"] = ias.Location
	}
	if ias.Tags != nil {
		objectMap["tags"] = ias.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IntegrationAccountSchema struct.
func (ias *IntegrationAccountSchema) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var integrationAccountSchemaProperties IntegrationAccountSchemaProperties
				err = json.Unmarshal(*v, &integrationAccountSchemaProperties)
				if err != nil {
					return err
				}
				ias.IntegrationAccountSchemaProperties = &integrationAccountSchemaProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ias.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ias.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ias.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ias.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ias.Tags = tags
			}
		}
	}

	return nil
}

// IntegrationAccountSchemaFilter ...
type IntegrationAccountSchemaFilter struct {
	// SchemaType - The schema type of integration account schema. Possible values include: 'SchemaTypeNotSpecified', 'SchemaTypeXML'
	SchemaType SchemaType `json:"schemaType,omitempty"`
}

// IntegrationAccountSchemaListResult ...
type IntegrationAccountSchemaListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of integration account schemas.
	Value *[]IntegrationAccountSchema `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// IntegrationAccountSchemaListResultIterator provides access to a complete listing of
// IntegrationAccountSchema values.
type IntegrationAccountSchemaListResultIterator struct {
	i    int
	page IntegrationAccountSchemaListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IntegrationAccountSchemaListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IntegrationAccountSchemaListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IntegrationAccountSchemaListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IntegrationAccountSchemaListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IntegrationAccountSchemaListResultIterator) Response() IntegrationAccountSchemaListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IntegrationAccountSchemaListResultIterator) Value() IntegrationAccountSchema {
	if !iter.page.NotDone() {
		return IntegrationAccountSchema{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IntegrationAccountSchemaListResultIterator type.
func NewIntegrationAccountSchemaListResultIterator(page IntegrationAccountSchemaListResultPage) IntegrationAccountSchemaListResultIterator {
	return IntegrationAccountSchemaListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (iaslr IntegrationAccountSchemaListResult) IsEmpty() bool {
	return iaslr.Value == nil || len(*iaslr.Value) == 0
}

// integrationAccountSchemaListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (iaslr IntegrationAccountSchemaListResult) integrationAccountSchemaListResultPreparer(ctx context.Context) (*http.Request, error) {
	if iaslr.NextLink == nil || len(to.String(iaslr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(iaslr.NextLink)))
}

// IntegrationAccountSchemaListResultPage contains a page of IntegrationAccountSchema values.
type IntegrationAccountSchemaListResultPage struct {
	fn    func(context.Context, IntegrationAccountSchemaListResult) (IntegrationAccountSchemaListResult, error)
	iaslr IntegrationAccountSchemaListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IntegrationAccountSchemaListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IntegrationAccountSchemaListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.iaslr)
	if err != nil {
		return err
	}
	page.iaslr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IntegrationAccountSchemaListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IntegrationAccountSchemaListResultPage) NotDone() bool {
	return !page.iaslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IntegrationAccountSchemaListResultPage) Response() IntegrationAccountSchemaListResult {
	return page.iaslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IntegrationAccountSchemaListResultPage) Values() []IntegrationAccountSchema {
	if page.iaslr.IsEmpty() {
		return nil
	}
	return *page.iaslr.Value
}

// Creates a new instance of the IntegrationAccountSchemaListResultPage type.
func NewIntegrationAccountSchemaListResultPage(getNextPage func(context.Context, IntegrationAccountSchemaListResult) (IntegrationAccountSchemaListResult, error)) IntegrationAccountSchemaListResultPage {
	return IntegrationAccountSchemaListResultPage{fn: getNextPage}
}

// IntegrationAccountSchemaProperties ...
type IntegrationAccountSchemaProperties struct {
	// SchemaType - The schema type. Possible values include: 'SchemaTypeNotSpecified', 'SchemaTypeXML'
	SchemaType SchemaType `json:"schemaType,omitempty"`
	// TargetNamespace - The target namespace.
	TargetNamespace *string `json:"targetNamespace,omitempty"`
	// CreatedTime - The created time.
	CreatedTime *date.Time `json:"createdTime,omitempty"`
	// ChangedTime - The changed time.
	ChangedTime *date.Time `json:"changedTime,omitempty"`
	// Content - The content.
	Content interface{} `json:"content,omitempty"`
	// ContentType - The content type.
	ContentType *string `json:"contentType,omitempty"`
	// ContentLink - The content link.
	ContentLink *IntegrationAccountContentLink `json:"contentLink,omitempty"`
	// Metadata - The metadata.
	Metadata interface{} `json:"metadata,omitempty"`
}

// IntegrationAccountSku ...
type IntegrationAccountSku struct {
	// Name - The sku name. Possible values include: 'SkuNameNotSpecified', 'SkuNameFree', 'SkuNameShared', 'SkuNameBasic', 'SkuNameStandard', 'SkuNamePremium'
	Name SkuName `json:"name,omitempty"`
}

// KeyVaultKeyReference ...
type KeyVaultKeyReference struct {
	// KeyVault - The key vault reference.
	KeyVault *KeyVaultKeyReferenceKeyVault `json:"keyVault,omitempty"`
	// KeyName - The private key name in key vault.
	KeyName *string `json:"keyName,omitempty"`
	// KeyVersion - The private key version in key vault.
	KeyVersion *string `json:"keyVersion,omitempty"`
}

// KeyVaultKeyReferenceKeyVault the key vault reference.
type KeyVaultKeyReferenceKeyVault struct {
	// ID - The resource id.
	ID *string `json:"id,omitempty"`
	// Name - The resource name.
	Name *string `json:"name,omitempty"`
	// Type - The resource type.
	Type *string `json:"type,omitempty"`
}

// ListCallbackURLParameters ...
type ListCallbackURLParameters struct {
	// NotAfter - The expiry time.
	NotAfter *date.Time `json:"NotAfter,omitempty"`
}

// PartnerContent ...
type PartnerContent struct {
	// B2b - The B2B partner content.
	B2b *B2BPartnerContent `json:"b2b,omitempty"`
}

// X12AcknowledgementSettings ...
type X12AcknowledgementSettings struct {
	// NeedTechnicalAcknowledgement - The value indicating whether technical acknowledgement is needed.
	NeedTechnicalAcknowledgement *bool `json:"needTechnicalAcknowledgement,omitempty"`
	// BatchTechnicalAcknowledgements - The value indicating whether to batch the technical acknowledgements.
	BatchTechnicalAcknowledgements *bool `json:"batchTechnicalAcknowledgements,omitempty"`
	// NeedFunctionalAcknowledgement - The value indicating whether functional acknowledgement is needed.
	NeedFunctionalAcknowledgement *bool `json:"needFunctionalAcknowledgement,omitempty"`
	// FunctionalAcknowledgementVersion - The functional acknowledgement version.
	FunctionalAcknowledgementVersion *string `json:"functionalAcknowledgementVersion,omitempty"`
	// BatchFunctionalAcknowledgements - The value indicating whether to batch functional acknowledgements.
	BatchFunctionalAcknowledgements *bool `json:"batchFunctionalAcknowledgements,omitempty"`
	// NeedImplementationAcknowledgement - The value indicating whether implementation acknowledgement is needed.
	NeedImplementationAcknowledgement *bool `json:"needImplementationAcknowledgement,omitempty"`
	// ImplementationAcknowledgementVersion - The implementation acknowledgement version.
	ImplementationAcknowledgementVersion *string `json:"implementationAcknowledgementVersion,omitempty"`
	// BatchImplementationAcknowledgements - The value indicating whether to batch implementation acknowledgements.
	BatchImplementationAcknowledgements *bool `json:"batchImplementationAcknowledgements,omitempty"`
	// NeedLoopForValidMessages - The value indicating whether a loop is needed for valid messages.
	NeedLoopForValidMessages *bool `json:"needLoopForValidMessages,omitempty"`
	// SendSynchronousAcknowledgement - The value indicating whether to send synchronous acknowledgement.
	SendSynchronousAcknowledgement *bool `json:"sendSynchronousAcknowledgement,omitempty"`
	// AcknowledgementControlNumberPrefix - The acknowledgement control number prefix.
	AcknowledgementControlNumberPrefix *string `json:"acknowledgementControlNumberPrefix,omitempty"`
	// AcknowledgementControlNumberSuffix - The acknowledgement control number suffix.
	AcknowledgementControlNumberSuffix *string `json:"acknowledgementControlNumberSuffix,omitempty"`
	// AcknowledgementControlNumberLowerBound - The acknowledgement control number lower bound.
	AcknowledgementControlNumberLowerBound *int32 `json:"acknowledgementControlNumberLowerBound,omitempty"`
	// AcknowledgementControlNumberUpperBound - The acknowledgement control number upper bound.
	AcknowledgementControlNumberUpperBound *int32 `json:"acknowledgementControlNumberUpperBound,omitempty"`
	// RolloverAcknowledgementControlNumber - The value indicating whether to rollover acknowledgement control number.
	RolloverAcknowledgementControlNumber *bool `json:"rolloverAcknowledgementControlNumber,omitempty"`
}

// X12AgreementContent ...
type X12AgreementContent struct {
	// ReceiveAgreement - The X12 one-way receive agreement.
	ReceiveAgreement *X12OneWayAgreement `json:"receiveAgreement,omitempty"`
	// SendAgreement - The X12 one-way send agreement.
	SendAgreement *X12OneWayAgreement `json:"sendAgreement,omitempty"`
}

// X12DelimiterOverrides ...
type X12DelimiterOverrides struct {
	// ProtocolVersion - The protocol version.
	ProtocolVersion *string `json:"protocolVersion,omitempty"`
	// MessageID - The message id.
	MessageID *string `json:"messageId,omitempty"`
	// DataElementSeparator - The data element separator.
	DataElementSeparator *int32 `json:"dataElementSeparator,omitempty"`
	// ComponentSeparator - The component separator.
	ComponentSeparator *int32 `json:"componentSeparator,omitempty"`
	// SegmentTerminator - The segment terminator.
	SegmentTerminator *int32 `json:"segmentTerminator,omitempty"`
	// SegmentTerminatorSuffix - The segment terminator suffix. Possible values include: 'SegmentTerminatorSuffixNotSpecified', 'SegmentTerminatorSuffixNone', 'SegmentTerminatorSuffixCR', 'SegmentTerminatorSuffixLF', 'SegmentTerminatorSuffixCRLF'
	SegmentTerminatorSuffix SegmentTerminatorSuffix `json:"segmentTerminatorSuffix,omitempty"`
	// ReplaceCharacter - The replacement character.
	ReplaceCharacter *int32 `json:"replaceCharacter,omitempty"`
	// ReplaceSeparatorsInPayload - The value indicating whether to replace separators in payload.
	ReplaceSeparatorsInPayload *bool `json:"replaceSeparatorsInPayload,omitempty"`
	// TargetNamespace - The target namespace on which this delimiter settings has to be applied.
	TargetNamespace *string `json:"targetNamespace,omitempty"`
}

// X12EnvelopeOverride ...
type X12EnvelopeOverride struct {
	// TargetNamespace - The target namespace on which this envelope settings has to be applied.
	TargetNamespace *string `json:"targetNamespace,omitempty"`
	// ProtocolVersion - The protocol version on which this envelope settings has to be applied.
	ProtocolVersion *string `json:"protocolVersion,omitempty"`
	// MessageID - The message id on which this envelope settings has to be applied.
	MessageID *string `json:"messageId,omitempty"`
	// ResponsibleAgencyCode - The responsible agency code.
	ResponsibleAgencyCode *int32 `json:"responsibleAgencyCode,omitempty"`
	// HeaderVersion - The header version.
	HeaderVersion *string `json:"headerVersion,omitempty"`
	// SenderApplicationID - The sender application id.
	SenderApplicationID *string `json:"senderApplicationId,omitempty"`
	// ReceiverApplicationID - The receiver application id.
	ReceiverApplicationID *string `json:"receiverApplicationId,omitempty"`
	// FunctionalIdentifierCode - The functional identifier code.
	FunctionalIdentifierCode *string `json:"functionalIdentifierCode,omitempty"`
	// DateFormat - The date format. Possible values include: 'X12DateFormatNotSpecified', 'X12DateFormatCCYYMMDD', 'X12DateFormatYYMMDD'
	DateFormat X12DateFormat `json:"dateFormat,omitempty"`
	// TimeFormat - The time format. Possible values include: 'X12TimeFormatNotSpecified', 'X12TimeFormatHHMM', 'X12TimeFormatHHMMSS', 'X12TimeFormatHHMMSSdd', 'X12TimeFormatHHMMSSd'
	TimeFormat X12TimeFormat `json:"timeFormat,omitempty"`
}

// X12EnvelopeSettings ...
type X12EnvelopeSettings struct {
	// ControlStandardsID - The controls standards id.
	ControlStandardsID *int32 `json:"controlStandardsId,omitempty"`
	// UseControlStandardsIDAsRepetitionCharacter - The value indicating whether to use control standards id as repetition character.
	UseControlStandardsIDAsRepetitionCharacter *bool `json:"useControlStandardsIdAsRepetitionCharacter,omitempty"`
	// SenderApplicationID - The sender application id.
	SenderApplicationID *string `json:"senderApplicationId,omitempty"`
	// ReceiverApplicationID - The receiver application id.
	ReceiverApplicationID *string `json:"receiverApplicationId,omitempty"`
	// ControlVersionNumber - The control version number.
	ControlVersionNumber *string `json:"controlVersionNumber,omitempty"`
	// InterchangeControlNumberLowerBound - The interchange  control number lower bound.
	InterchangeControlNumberLowerBound *int32 `json:"interchangeControlNumberLowerBound,omitempty"`
	// InterchangeControlNumberUpperBound - The interchange  control number upper bound.
	InterchangeControlNumberUpperBound *int32 `json:"interchangeControlNumberUpperBound,omitempty"`
	// RolloverInterchangeControlNumber - The value indicating whether to rollover interchange control number.
	RolloverInterchangeControlNumber *bool `json:"rolloverInterchangeControlNumber,omitempty"`
	// EnableDefaultGroupHeaders - The value indicating whether to enable default group headers.
	EnableDefaultGroupHeaders *bool `json:"enableDefaultGroupHeaders,omitempty"`
	// FunctionalGroupID - The functional group id.
	FunctionalGroupID *string `json:"functionalGroupId,omitempty"`
	// GroupControlNumberLowerBound - The group control number lower bound.
	GroupControlNumberLowerBound *int32 `json:"groupControlNumberLowerBound,omitempty"`
	// GroupControlNumberUpperBound - The group control number upper bound.
	GroupControlNumberUpperBound *int32 `json:"groupControlNumberUpperBound,omitempty"`
	// RolloverGroupControlNumber - The value indicating whether to rollover group control number.
	RolloverGroupControlNumber *bool `json:"rolloverGroupControlNumber,omitempty"`
	// GroupHeaderAgencyCode - The group header agency code.
	GroupHeaderAgencyCode *string `json:"groupHeaderAgencyCode,omitempty"`
	// GroupHeaderVersion - The group header version.
	GroupHeaderVersion *string `json:"groupHeaderVersion,omitempty"`
	// TransactionSetControlNumberLowerBound - The transaction set control number lower bound.
	TransactionSetControlNumberLowerBound *int32 `json:"transactionSetControlNumberLowerBound,omitempty"`
	// TransactionSetControlNumberUpperBound - The transaction set control number upper bound.
	TransactionSetControlNumberUpperBound *int32 `json:"transactionSetControlNumberUpperBound,omitempty"`
	// RolloverTransactionSetControlNumber - The value indicating whether to rollover transaction set control number.
	RolloverTransactionSetControlNumber *bool `json:"rolloverTransactionSetControlNumber,omitempty"`
	// TransactionSetControlNumberPrefix - The transaction set control number prefix.
	TransactionSetControlNumberPrefix *string `json:"transactionSetControlNumberPrefix,omitempty"`
	// TransactionSetControlNumberSuffix - The transaction set control number suffix.
	TransactionSetControlNumberSuffix *string `json:"transactionSetControlNumberSuffix,omitempty"`
	// OverwriteExistingTransactionSetControlNumber - The value indicating whether to overwrite existing transaction set control number.
	OverwriteExistingTransactionSetControlNumber *bool `json:"overwriteExistingTransactionSetControlNumber,omitempty"`
	// GroupHeaderDateFormat - The group header date format. Possible values include: 'X12DateFormatNotSpecified', 'X12DateFormatCCYYMMDD', 'X12DateFormatYYMMDD'
	GroupHeaderDateFormat X12DateFormat `json:"groupHeaderDateFormat,omitempty"`
	// GroupHeaderTimeFormat - The group header time format. Possible values include: 'X12TimeFormatNotSpecified', 'X12TimeFormatHHMM', 'X12TimeFormatHHMMSS', 'X12TimeFormatHHMMSSdd', 'X12TimeFormatHHMMSSd'
	GroupHeaderTimeFormat X12TimeFormat `json:"groupHeaderTimeFormat,omitempty"`
	// UsageIndicator - The usage indicator. Possible values include: 'UsageIndicatorNotSpecified', 'UsageIndicatorTest', 'UsageIndicatorInformation', 'UsageIndicatorProduction'
	UsageIndicator UsageIndicator `json:"usageIndicator,omitempty"`
}

// X12FramingSettings ...
type X12FramingSettings struct {
	// DataElementSeparator - The data element separator.
	DataElementSeparator *int32 `json:"dataElementSeparator,omitempty"`
	// ComponentSeparator - The component separator.
	ComponentSeparator *int32 `json:"componentSeparator,omitempty"`
	// ReplaceSeparatorsInPayload - The value indicating whether to replace separators in payload.
	ReplaceSeparatorsInPayload *bool `json:"replaceSeparatorsInPayload,omitempty"`
	// ReplaceCharacter - The replacement character.
	ReplaceCharacter *int32 `json:"replaceCharacter,omitempty"`
	// SegmentTerminator - The segment terminator.
	SegmentTerminator *int32 `json:"segmentTerminator,omitempty"`
	// CharacterSet - The X12 character set. Possible values include: 'X12CharacterSetNotSpecified', 'X12CharacterSetBasic', 'X12CharacterSetExtended', 'X12CharacterSetUTF8'
	CharacterSet X12CharacterSet `json:"characterSet,omitempty"`
	// SegmentTerminatorSuffix - The segment terminator suffix. Possible values include: 'SegmentTerminatorSuffixNotSpecified', 'SegmentTerminatorSuffixNone', 'SegmentTerminatorSuffixCR', 'SegmentTerminatorSuffixLF', 'SegmentTerminatorSuffixCRLF'
	SegmentTerminatorSuffix SegmentTerminatorSuffix `json:"segmentTerminatorSuffix,omitempty"`
}

// X12MessageFilter ...
type X12MessageFilter struct {
	// MessageFilterType - The message filter type. Possible values include: 'MessageFilterTypeNotSpecified', 'MessageFilterTypeInclude', 'MessageFilterTypeExclude'
	MessageFilterType MessageFilterType `json:"messageFilterType,omitempty"`
}

// X12MessageIdentifier ...
type X12MessageIdentifier struct {
	// MessageID - The message id.
	MessageID *string `json:"messageId,omitempty"`
}

// X12OneWayAgreement ...
type X12OneWayAgreement struct {
	// SenderBusinessIdentity - The sender business identity
	SenderBusinessIdentity *BusinessIdentity `json:"senderBusinessIdentity,omitempty"`
	// ReceiverBusinessIdentity - The receiver business identity
	ReceiverBusinessIdentity *BusinessIdentity `json:"receiverBusinessIdentity,omitempty"`
	// ProtocolSettings - The X12 protocol settings.
	ProtocolSettings *X12ProtocolSettings `json:"protocolSettings,omitempty"`
}

// X12ProcessingSettings ...
type X12ProcessingSettings struct {
	// MaskSecurityInfo - The value indicating whether to mask security information.
	MaskSecurityInfo *bool `json:"maskSecurityInfo,omitempty"`
	// ConvertImpliedDecimal - The value indicating whether to convert numerical type to implied decimal.
	ConvertImpliedDecimal *bool `json:"convertImpliedDecimal,omitempty"`
	// PreserveInterchange - The value indicating whether to preserve interchange.
	PreserveInterchange *bool `json:"preserveInterchange,omitempty"`
	// SuspendInterchangeOnError - The value indicating whether to suspend interchange on error.
	SuspendInterchangeOnError *bool `json:"suspendInterchangeOnError,omitempty"`
	// CreateEmptyXMLTagsForTrailingSeparators - The value indicating whether to create empty xml tags for trailing separators.
	CreateEmptyXMLTagsForTrailingSeparators *bool `json:"createEmptyXmlTagsForTrailingSeparators,omitempty"`
	// UseDotAsDecimalSeparator - The value indicating whether to use dot as decimal separator.
	UseDotAsDecimalSeparator *bool `json:"useDotAsDecimalSeparator,omitempty"`
}

// X12ProtocolSettings ...
type X12ProtocolSettings struct {
	// ValidationSettings - The X12 validation settings.
	ValidationSettings *X12ValidationSettings `json:"validationSettings,omitempty"`
	// FramingSettings - The X12 framing settings.
	FramingSettings *X12FramingSettings `json:"framingSettings,omitempty"`
	// EnvelopeSettings - The X12 envelope settings.
	EnvelopeSettings *X12EnvelopeSettings `json:"envelopeSettings,omitempty"`
	// AcknowledgementSettings - The X12 acknowledgment settings.
	AcknowledgementSettings *X12AcknowledgementSettings `json:"acknowledgementSettings,omitempty"`
	// MessageFilter - The X12 message filter.
	MessageFilter *X12MessageFilter `json:"messageFilter,omitempty"`
	// SecuritySettings - The X12 security settings.
	SecuritySettings *X12SecuritySettings `json:"securitySettings,omitempty"`
	// ProcessingSettings - The X12 processing settings.
	ProcessingSettings *X12ProcessingSettings `json:"processingSettings,omitempty"`
	// EnvelopeOverrides - The X12 envelope override settings.
	EnvelopeOverrides *[]X12EnvelopeOverride `json:"envelopeOverrides,omitempty"`
	// ValidationOverrides - The X12 validation override settings.
	ValidationOverrides *[]X12ValidationOverride `json:"validationOverrides,omitempty"`
	// MessageFilterList - The X12 message filter list.
	MessageFilterList *[]X12MessageIdentifier `json:"messageFilterList,omitempty"`
	// SchemaReferences - The X12 schema references.
	SchemaReferences *[]X12SchemaReference `json:"schemaReferences,omitempty"`
	// X12DelimiterOverrides - The X12 delimiter override settings.
	X12DelimiterOverrides *[]X12DelimiterOverrides `json:"x12DelimiterOverrides,omitempty"`
}

// X12SchemaReference ...
type X12SchemaReference struct {
	// MessageID - The message id.
	MessageID *string `json:"messageId,omitempty"`
	// SenderApplicationID - The sender application id.
	SenderApplicationID *string `json:"senderApplicationId,omitempty"`
	// SchemaVersion - The schema version.
	SchemaVersion *string `json:"schemaVersion,omitempty"`
	// SchemaName - The schema name.
	SchemaName *string `json:"schemaName,omitempty"`
}

// X12SecuritySettings ...
type X12SecuritySettings struct {
	// AuthorizationQualifier - The authorization qualifier.
	AuthorizationQualifier *string `json:"authorizationQualifier,omitempty"`
	// AuthorizationValue - The authorization value.
	AuthorizationValue *string `json:"authorizationValue,omitempty"`
	// SecurityQualifier - The security qualifier.
	SecurityQualifier *string `json:"securityQualifier,omitempty"`
	// PasswordValue - The password value.
	PasswordValue *string `json:"passwordValue,omitempty"`
}

// X12ValidationOverride ...
type X12ValidationOverride struct {
	// MessageID - The message id on which the validation settings has to be applied.
	MessageID *string `json:"messageId,omitempty"`
	// ValidateEDITypes - The value indicating whether to validate EDI types.
	ValidateEDITypes *bool `json:"validateEDITypes,omitempty"`
	// ValidateXSDTypes - The value indicating whether to validate XSD types.
	ValidateXSDTypes *bool `json:"validateXSDTypes,omitempty"`
	// AllowLeadingAndTrailingSpacesAndZeroes - The value indicating whether to allow leading and trailing spaces and zeroes.
	AllowLeadingAndTrailingSpacesAndZeroes *bool `json:"allowLeadingAndTrailingSpacesAndZeroes,omitempty"`
	// ValidateCharacterSet - The value indicating whether to validate character Set.
	ValidateCharacterSet *bool `json:"validateCharacterSet,omitempty"`
	// TrimLeadingAndTrailingSpacesAndZeroes - The value indicating whether to trim leading and trailing spaces and zeroes.
	TrimLeadingAndTrailingSpacesAndZeroes *bool `json:"trimLeadingAndTrailingSpacesAndZeroes,omitempty"`
	// TrailingSeparatorPolicy - The trailing separator policy. Possible values include: 'TrailingSeparatorPolicyNotSpecified', 'TrailingSeparatorPolicyNotAllowed', 'TrailingSeparatorPolicyOptional', 'TrailingSeparatorPolicyMandatory'
	TrailingSeparatorPolicy TrailingSeparatorPolicy `json:"trailingSeparatorPolicy,omitempty"`
}

// X12ValidationSettings ...
type X12ValidationSettings struct {
	// ValidateCharacterSet - The value indicating whether to validate character set in the message.
	ValidateCharacterSet *bool `json:"validateCharacterSet,omitempty"`
	// CheckDuplicateInterchangeControlNumber - The value indicating whether to check for duplicate interchange control number.
	CheckDuplicateInterchangeControlNumber *bool `json:"checkDuplicateInterchangeControlNumber,omitempty"`
	// InterchangeControlNumberValidityDays - The validity period of interchange control number.
	InterchangeControlNumberValidityDays *int32 `json:"interchangeControlNumberValidityDays,omitempty"`
	// CheckDuplicateGroupControlNumber - The value indicating whether to check for duplicate group control number.
	CheckDuplicateGroupControlNumber *bool `json:"checkDuplicateGroupControlNumber,omitempty"`
	// CheckDuplicateTransactionSetControlNumber - The value indicating whether to check for duplicate transaction set control number.
	CheckDuplicateTransactionSetControlNumber *bool `json:"checkDuplicateTransactionSetControlNumber,omitempty"`
	// ValidateEDITypes - The value indicating whether to Whether to validate EDI types.
	ValidateEDITypes *bool `json:"validateEDITypes,omitempty"`
	// ValidateXSDTypes - The value indicating whether to Whether to validate XSD types.
	ValidateXSDTypes *bool `json:"validateXSDTypes,omitempty"`
	// AllowLeadingAndTrailingSpacesAndZeroes - The value indicating whether to allow leading and trailing spaces and zeroes.
	AllowLeadingAndTrailingSpacesAndZeroes *bool `json:"allowLeadingAndTrailingSpacesAndZeroes,omitempty"`
	// TrimLeadingAndTrailingSpacesAndZeroes - The value indicating whether to trim leading and trailing spaces and zeroes.
	TrimLeadingAndTrailingSpacesAndZeroes *bool `json:"trimLeadingAndTrailingSpacesAndZeroes,omitempty"`
	// TrailingSeparatorPolicy - The trailing separator policy. Possible values include: 'TrailingSeparatorPolicyNotSpecified', 'TrailingSeparatorPolicyNotAllowed', 'TrailingSeparatorPolicyOptional', 'TrailingSeparatorPolicyMandatory'
	TrailingSeparatorPolicy TrailingSeparatorPolicy `json:"trailingSeparatorPolicy,omitempty"`
}
