package security

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/satori/go.uuid"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/security/mgmt/v2.0/security"

// AadConnectivityState enumerates the values for aad connectivity state.
type AadConnectivityState string

const (
	// Connected ...
	Connected AadConnectivityState = "Connected"
	// Discovered ...
	Discovered AadConnectivityState = "Discovered"
	// NotLicensed ...
	NotLicensed AadConnectivityState = "NotLicensed"
)

// PossibleAadConnectivityStateValues returns an array of possible values for the AadConnectivityState const type.
func PossibleAadConnectivityStateValues() []AadConnectivityState {
	return []AadConnectivityState{Connected, Discovered, NotLicensed}
}

// AlertNotifications enumerates the values for alert notifications.
type AlertNotifications string

const (
	// Off Don't get notifications on new alerts
	Off AlertNotifications = "Off"
	// On Get notifications on new alerts
	On AlertNotifications = "On"
)

// PossibleAlertNotificationsValues returns an array of possible values for the AlertNotifications const type.
func PossibleAlertNotificationsValues() []AlertNotifications {
	return []AlertNotifications{Off, On}
}

// AlertsToAdmins enumerates the values for alerts to admins.
type AlertsToAdmins string

const (
	// AlertsToAdminsOff Don't send notification on new alerts to the subscription's admins
	AlertsToAdminsOff AlertsToAdmins = "Off"
	// AlertsToAdminsOn Send notification on new alerts to the subscription's admins
	AlertsToAdminsOn AlertsToAdmins = "On"
)

// PossibleAlertsToAdminsValues returns an array of possible values for the AlertsToAdmins const type.
func PossibleAlertsToAdminsValues() []AlertsToAdmins {
	return []AlertsToAdmins{AlertsToAdminsOff, AlertsToAdminsOn}
}

// AutoProvision enumerates the values for auto provision.
type AutoProvision string

const (
	// AutoProvisionOff Do not install security agent on the VMs automatically
	AutoProvisionOff AutoProvision = "Off"
	// AutoProvisionOn Install missing security agent on VMs automatically
	AutoProvisionOn AutoProvision = "On"
)

// PossibleAutoProvisionValues returns an array of possible values for the AutoProvision const type.
func PossibleAutoProvisionValues() []AutoProvision {
	return []AutoProvision{AutoProvisionOff, AutoProvisionOn}
}

// ConnectionType enumerates the values for connection type.
type ConnectionType string

const (
	// External ...
	External ConnectionType = "External"
	// Internal ...
	Internal ConnectionType = "Internal"
)

// PossibleConnectionTypeValues returns an array of possible values for the ConnectionType const type.
func PossibleConnectionTypeValues() []ConnectionType {
	return []ConnectionType{External, Internal}
}

// ExternalSecuritySolutionKind enumerates the values for external security solution kind.
type ExternalSecuritySolutionKind string

const (
	// AAD ...
	AAD ExternalSecuritySolutionKind = "AAD"
	// ATA ...
	ATA ExternalSecuritySolutionKind = "ATA"
	// CEF ...
	CEF ExternalSecuritySolutionKind = "CEF"
)

// PossibleExternalSecuritySolutionKindValues returns an array of possible values for the ExternalSecuritySolutionKind const type.
func PossibleExternalSecuritySolutionKindValues() []ExternalSecuritySolutionKind {
	return []ExternalSecuritySolutionKind{AAD, ATA, CEF}
}

// Family enumerates the values for family.
type Family string

const (
	// Ngfw ...
	Ngfw Family = "Ngfw"
	// SaasWaf ...
	SaasWaf Family = "SaasWaf"
	// Va ...
	Va Family = "Va"
	// Waf ...
	Waf Family = "Waf"
)

// PossibleFamilyValues returns an array of possible values for the Family const type.
func PossibleFamilyValues() []Family {
	return []Family{Ngfw, SaasWaf, Va, Waf}
}

// KindEnum enumerates the values for kind enum.
type KindEnum string

const (
	// KindAAD ...
	KindAAD KindEnum = "AAD"
	// KindATA ...
	KindATA KindEnum = "ATA"
	// KindCEF ...
	KindCEF KindEnum = "CEF"
	// KindExternalSecuritySolution ...
	KindExternalSecuritySolution KindEnum = "ExternalSecuritySolution"
)

// PossibleKindEnumValues returns an array of possible values for the KindEnum const type.
func PossibleKindEnumValues() []KindEnum {
	return []KindEnum{KindAAD, KindATA, KindCEF, KindExternalSecuritySolution}
}

// PricingTier enumerates the values for pricing tier.
type PricingTier string

const (
	// Free Get free Azure security center experience with basic security features
	Free PricingTier = "Free"
	// Standard Get the standard Azure security center experience with advanced security features
	Standard PricingTier = "Standard"
)

// PossiblePricingTierValues returns an array of possible values for the PricingTier const type.
func PossiblePricingTierValues() []PricingTier {
	return []PricingTier{Free, Standard}
}

// Protocol enumerates the values for protocol.
type Protocol string

const (
	// All ...
	All Protocol = "*"
	// TCP ...
	TCP Protocol = "TCP"
	// UDP ...
	UDP Protocol = "UDP"
)

// PossibleProtocolValues returns an array of possible values for the Protocol const type.
func PossibleProtocolValues() []Protocol {
	return []Protocol{All, TCP, UDP}
}

// ReportedSeverity enumerates the values for reported severity.
type ReportedSeverity string

const (
	// High ...
	High ReportedSeverity = "High"
	// Informational ...
	Informational ReportedSeverity = "Informational"
	// Low ...
	Low ReportedSeverity = "Low"
	// Medium ...
	Medium ReportedSeverity = "Medium"
)

// PossibleReportedSeverityValues returns an array of possible values for the ReportedSeverity const type.
func PossibleReportedSeverityValues() []ReportedSeverity {
	return []ReportedSeverity{High, Informational, Low, Medium}
}

// SettingKind enumerates the values for setting kind.
type SettingKind string

const (
	// SettingKindAlertSuppressionSetting ...
	SettingKindAlertSuppressionSetting SettingKind = "AlertSuppressionSetting"
	// SettingKindDataExportSetting ...
	SettingKindDataExportSetting SettingKind = "DataExportSetting"
)

// PossibleSettingKindValues returns an array of possible values for the SettingKind const type.
func PossibleSettingKindValues() []SettingKind {
	return []SettingKind{SettingKindAlertSuppressionSetting, SettingKindDataExportSetting}
}

// Status enumerates the values for status.
type Status string

const (
	// Initiated ...
	Initiated Status = "Initiated"
	// Revoked ...
	Revoked Status = "Revoked"
)

// PossibleStatusValues returns an array of possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{Initiated, Revoked}
}

// StatusReason enumerates the values for status reason.
type StatusReason string

const (
	// Expired ...
	Expired StatusReason = "Expired"
	// NewerRequestInitiated ...
	NewerRequestInitiated StatusReason = "NewerRequestInitiated"
	// UserRequested ...
	UserRequested StatusReason = "UserRequested"
)

// PossibleStatusReasonValues returns an array of possible values for the StatusReason const type.
func PossibleStatusReasonValues() []StatusReason {
	return []StatusReason{Expired, NewerRequestInitiated, UserRequested}
}

// AadConnectivityState1 describes an Azure resource with kind
type AadConnectivityState1 struct {
	// ConnectivityState - Possible values include: 'Discovered', 'NotLicensed', 'Connected'
	ConnectivityState AadConnectivityState `json:"connectivityState,omitempty"`
}

// AadExternalSecuritySolution represents an AAD identity protection solution which sends logs to an OMS
// workspace.
type AadExternalSecuritySolution struct {
	Properties *AadSolutionProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Location where the resource is stored
	Location *string `json:"location,omitempty"`
	// Kind - Possible values include: 'KindExternalSecuritySolution', 'KindCEF', 'KindATA', 'KindAAD'
	Kind KindEnum `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AadExternalSecuritySolution.
func (aess AadExternalSecuritySolution) MarshalJSON() ([]byte, error) {
	aess.Kind = KindAAD
	objectMap := make(map[string]interface{})
	if aess.Properties != nil {
		objectMap["properties"] = aess.Properties
	}
	if aess.ID != nil {
		objectMap["id"] = aess.ID
	}
	if aess.Name != nil {
		objectMap["name"] = aess.Name
	}
	if aess.Type != nil {
		objectMap["type"] = aess.Type
	}
	if aess.Location != nil {
		objectMap["location"] = aess.Location
	}
	if aess.Kind != "" {
		objectMap["kind"] = aess.Kind
	}
	return json.Marshal(objectMap)
}

// AsCefExternalSecuritySolution is the BasicExternalSecuritySolution implementation for AadExternalSecuritySolution.
func (aess AadExternalSecuritySolution) AsCefExternalSecuritySolution() (*CefExternalSecuritySolution, bool) {
	return nil, false
}

// AsAtaExternalSecuritySolution is the BasicExternalSecuritySolution implementation for AadExternalSecuritySolution.
func (aess AadExternalSecuritySolution) AsAtaExternalSecuritySolution() (*AtaExternalSecuritySolution, bool) {
	return nil, false
}

// AsAadExternalSecuritySolution is the BasicExternalSecuritySolution implementation for AadExternalSecuritySolution.
func (aess AadExternalSecuritySolution) AsAadExternalSecuritySolution() (*AadExternalSecuritySolution, bool) {
	return &aess, true
}

// AsExternalSecuritySolution is the BasicExternalSecuritySolution implementation for AadExternalSecuritySolution.
func (aess AadExternalSecuritySolution) AsExternalSecuritySolution() (*ExternalSecuritySolution, bool) {
	return nil, false
}

// AsBasicExternalSecuritySolution is the BasicExternalSecuritySolution implementation for AadExternalSecuritySolution.
func (aess AadExternalSecuritySolution) AsBasicExternalSecuritySolution() (BasicExternalSecuritySolution, bool) {
	return &aess, true
}

// AadSolutionProperties ...
type AadSolutionProperties struct {
	DeviceVendor *string             `json:"deviceVendor,omitempty"`
	DeviceType   *string             `json:"deviceType,omitempty"`
	Workspace    *ConnectedWorkspace `json:"workspace,omitempty"`
	// ConnectivityState - Possible values include: 'Discovered', 'NotLicensed', 'Connected'
	ConnectivityState AadConnectivityState `json:"connectivityState,omitempty"`
}

// AdvancedThreatProtectionProperties the Advanced Threat Protection settings.
type AdvancedThreatProtectionProperties struct {
	// IsEnabled - Indicates whether Advanced Threat Protection is enabled.
	IsEnabled *bool `json:"isEnabled,omitempty"`
}

// AdvancedThreatProtectionSetting the Advanced Threat Protection resource.
type AdvancedThreatProtectionSetting struct {
	autorest.Response                   `json:"-"`
	*AdvancedThreatProtectionProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AdvancedThreatProtectionSetting.
func (atps AdvancedThreatProtectionSetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if atps.AdvancedThreatProtectionProperties != nil {
		objectMap["properties"] = atps.AdvancedThreatProtectionProperties
	}
	if atps.ID != nil {
		objectMap["id"] = atps.ID
	}
	if atps.Name != nil {
		objectMap["name"] = atps.Name
	}
	if atps.Type != nil {
		objectMap["type"] = atps.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AdvancedThreatProtectionSetting struct.
func (atps *AdvancedThreatProtectionSetting) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var advancedThreatProtectionProperties AdvancedThreatProtectionProperties
				err = json.Unmarshal(*v, &advancedThreatProtectionProperties)
				if err != nil {
					return err
				}
				atps.AdvancedThreatProtectionProperties = &advancedThreatProtectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				atps.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				atps.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				atps.Type = &typeVar
			}
		}
	}

	return nil
}

// Alert security alert
type Alert struct {
	autorest.Response `json:"-"`
	*AlertProperties  `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Alert.
func (a Alert) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.AlertProperties != nil {
		objectMap["properties"] = a.AlertProperties
	}
	if a.ID != nil {
		objectMap["id"] = a.ID
	}
	if a.Name != nil {
		objectMap["name"] = a.Name
	}
	if a.Type != nil {
		objectMap["type"] = a.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Alert struct.
func (a *Alert) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var alertProperties AlertProperties
				err = json.Unmarshal(*v, &alertProperties)
				if err != nil {
					return err
				}
				a.AlertProperties = &alertProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		}
	}

	return nil
}

// AlertConfidenceReason factors that increase our confidence that the alert is a true positive
type AlertConfidenceReason struct {
	// Type - Type of confidence factor
	Type *string `json:"type,omitempty"`
	// Reason - description of the confidence reason
	Reason *string `json:"reason,omitempty"`
}

// AlertEntity changing set of properties depending on the entity type.
type AlertEntity struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Type - Type of entity
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AlertEntity.
func (ae AlertEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ae.Type != nil {
		objectMap["type"] = ae.Type
	}
	for k, v := range ae.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AlertEntity struct.
func (ae *AlertEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ae.AdditionalProperties == nil {
					ae.AdditionalProperties = make(map[string]interface{})
				}
				ae.AdditionalProperties[k] = additionalProperties
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ae.Type = &typeVar
			}
		}
	}

	return nil
}

// AlertList list of security alerts
type AlertList struct {
	autorest.Response `json:"-"`
	Value             *[]Alert `json:"value,omitempty"`
	// NextLink - The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// AlertListIterator provides access to a complete listing of Alert values.
type AlertListIterator struct {
	i    int
	page AlertListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AlertListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AlertListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AlertListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AlertListIterator) Response() AlertList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AlertListIterator) Value() Alert {
	if !iter.page.NotDone() {
		return Alert{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AlertListIterator type.
func NewAlertListIterator(page AlertListPage) AlertListIterator {
	return AlertListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (al AlertList) IsEmpty() bool {
	return al.Value == nil || len(*al.Value) == 0
}

// alertListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (al AlertList) alertListPreparer(ctx context.Context) (*http.Request, error) {
	if al.NextLink == nil || len(to.String(al.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(al.NextLink)))
}

// AlertListPage contains a page of Alert values.
type AlertListPage struct {
	fn func(context.Context, AlertList) (AlertList, error)
	al AlertList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AlertListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.al)
	if err != nil {
		return err
	}
	page.al = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AlertListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AlertListPage) NotDone() bool {
	return !page.al.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AlertListPage) Response() AlertList {
	return page.al
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AlertListPage) Values() []Alert {
	if page.al.IsEmpty() {
		return nil
	}
	return *page.al.Value
}

// Creates a new instance of the AlertListPage type.
func NewAlertListPage(getNextPage func(context.Context, AlertList) (AlertList, error)) AlertListPage {
	return AlertListPage{fn: getNextPage}
}

// AlertProperties describes security alert properties.
type AlertProperties struct {
	// State - State of the alert (Active, Dismissed etc.)
	State *string `json:"state,omitempty"`
	// ReportedTimeUtc - The time the incident was reported to Microsoft.Security in UTC
	ReportedTimeUtc *date.Time `json:"reportedTimeUtc,omitempty"`
	// VendorName - Name of the vendor that discovered the incident
	VendorName *string `json:"vendorName,omitempty"`
	// AlertName - Name of the alert type
	AlertName *string `json:"alertName,omitempty"`
	// AlertDisplayName - Display name of the alert type
	AlertDisplayName *string `json:"alertDisplayName,omitempty"`
	// DetectedTimeUtc - The time the incident was detected by the vendor
	DetectedTimeUtc *date.Time `json:"detectedTimeUtc,omitempty"`
	// Description - Description of the incident and what it means
	Description *string `json:"description,omitempty"`
	// RemediationSteps - Recommended steps to reradiate the incident
	RemediationSteps *string `json:"remediationSteps,omitempty"`
	// ActionTaken - The action that was taken as a response to the alert (Active, Blocked etc.)
	ActionTaken *string `json:"actionTaken,omitempty"`
	// ReportedSeverity - Estimated severity of this alert. Possible values include: 'Informational', 'Low', 'Medium', 'High'
	ReportedSeverity ReportedSeverity `json:"reportedSeverity,omitempty"`
	// CompromisedEntity - The entity that the incident happened on
	CompromisedEntity *string `json:"compromisedEntity,omitempty"`
	// AssociatedResource - Azure resource ID of the associated resource
	AssociatedResource *string                `json:"associatedResource,omitempty"`
	ExtendedProperties map[string]interface{} `json:"extendedProperties"`
	// SystemSource - The type of the alerted resource (Azure, Non-Azure)
	SystemSource *string `json:"systemSource,omitempty"`
	// CanBeInvestigated - Whether this alert can be investigated with Azure Security Center
	CanBeInvestigated *bool `json:"canBeInvestigated,omitempty"`
	// IsIncident - Whether this alert is for incident type or not (otherwise - single alert)
	IsIncident *bool `json:"isIncident,omitempty"`
	// Entities - objects that are related to this alerts
	Entities *[]AlertEntity `json:"entities,omitempty"`
	// ConfidenceScore - level of confidence we have on the alert
	ConfidenceScore *float64 `json:"confidenceScore,omitempty"`
	// ConfidenceReasons - reasons the alert got the confidenceScore value
	ConfidenceReasons *[]AlertConfidenceReason `json:"confidenceReasons,omitempty"`
	// SubscriptionID - Azure subscription ID of the resource that had the security alert or the subscription ID of the workspace that this resource reports to
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// InstanceID - Instance ID of the alert.
	InstanceID *string `json:"instanceId,omitempty"`
	// WorkspaceArmID - Azure resource ID of the workspace that the alert was reported to.
	WorkspaceArmID *string `json:"workspaceArmId,omitempty"`
}

// MarshalJSON is the custom marshaler for AlertProperties.
func (ap AlertProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.State != nil {
		objectMap["state"] = ap.State
	}
	if ap.ReportedTimeUtc != nil {
		objectMap["reportedTimeUtc"] = ap.ReportedTimeUtc
	}
	if ap.VendorName != nil {
		objectMap["vendorName"] = ap.VendorName
	}
	if ap.AlertName != nil {
		objectMap["alertName"] = ap.AlertName
	}
	if ap.AlertDisplayName != nil {
		objectMap["alertDisplayName"] = ap.AlertDisplayName
	}
	if ap.DetectedTimeUtc != nil {
		objectMap["detectedTimeUtc"] = ap.DetectedTimeUtc
	}
	if ap.Description != nil {
		objectMap["description"] = ap.Description
	}
	if ap.RemediationSteps != nil {
		objectMap["remediationSteps"] = ap.RemediationSteps
	}
	if ap.ActionTaken != nil {
		objectMap["actionTaken"] = ap.ActionTaken
	}
	if ap.ReportedSeverity != "" {
		objectMap["reportedSeverity"] = ap.ReportedSeverity
	}
	if ap.CompromisedEntity != nil {
		objectMap["compromisedEntity"] = ap.CompromisedEntity
	}
	if ap.AssociatedResource != nil {
		objectMap["associatedResource"] = ap.AssociatedResource
	}
	if ap.ExtendedProperties != nil {
		objectMap["extendedProperties"] = ap.ExtendedProperties
	}
	if ap.SystemSource != nil {
		objectMap["systemSource"] = ap.SystemSource
	}
	if ap.CanBeInvestigated != nil {
		objectMap["canBeInvestigated"] = ap.CanBeInvestigated
	}
	if ap.IsIncident != nil {
		objectMap["isIncident"] = ap.IsIncident
	}
	if ap.Entities != nil {
		objectMap["entities"] = ap.Entities
	}
	if ap.ConfidenceScore != nil {
		objectMap["confidenceScore"] = ap.ConfidenceScore
	}
	if ap.ConfidenceReasons != nil {
		objectMap["confidenceReasons"] = ap.ConfidenceReasons
	}
	if ap.SubscriptionID != nil {
		objectMap["subscriptionId"] = ap.SubscriptionID
	}
	if ap.InstanceID != nil {
		objectMap["instanceId"] = ap.InstanceID
	}
	if ap.WorkspaceArmID != nil {
		objectMap["workspaceArmId"] = ap.WorkspaceArmID
	}
	return json.Marshal(objectMap)
}

// AllowedConnectionsList list of all possible traffic between Azure resources
type AllowedConnectionsList struct {
	autorest.Response `json:"-"`
	Value             *[]AllowedConnectionsResource `json:"value,omitempty"`
	// NextLink - The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// AllowedConnectionsListIterator provides access to a complete listing of AllowedConnectionsResource
// values.
type AllowedConnectionsListIterator struct {
	i    int
	page AllowedConnectionsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AllowedConnectionsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AllowedConnectionsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AllowedConnectionsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AllowedConnectionsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AllowedConnectionsListIterator) Response() AllowedConnectionsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AllowedConnectionsListIterator) Value() AllowedConnectionsResource {
	if !iter.page.NotDone() {
		return AllowedConnectionsResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AllowedConnectionsListIterator type.
func NewAllowedConnectionsListIterator(page AllowedConnectionsListPage) AllowedConnectionsListIterator {
	return AllowedConnectionsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ACL AllowedConnectionsList) IsEmpty() bool {
	return ACL.Value == nil || len(*ACL.Value) == 0
}

// allowedConnectionsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ACL AllowedConnectionsList) allowedConnectionsListPreparer(ctx context.Context) (*http.Request, error) {
	if ACL.NextLink == nil || len(to.String(ACL.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ACL.NextLink)))
}

// AllowedConnectionsListPage contains a page of AllowedConnectionsResource values.
type AllowedConnectionsListPage struct {
	fn  func(context.Context, AllowedConnectionsList) (AllowedConnectionsList, error)
	ACL AllowedConnectionsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AllowedConnectionsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AllowedConnectionsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ACL)
	if err != nil {
		return err
	}
	page.ACL = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AllowedConnectionsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AllowedConnectionsListPage) NotDone() bool {
	return !page.ACL.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AllowedConnectionsListPage) Response() AllowedConnectionsList {
	return page.ACL
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AllowedConnectionsListPage) Values() []AllowedConnectionsResource {
	if page.ACL.IsEmpty() {
		return nil
	}
	return *page.ACL.Value
}

// Creates a new instance of the AllowedConnectionsListPage type.
func NewAllowedConnectionsListPage(getNextPage func(context.Context, AllowedConnectionsList) (AllowedConnectionsList, error)) AllowedConnectionsListPage {
	return AllowedConnectionsListPage{fn: getNextPage}
}

// AllowedConnectionsResource the resource whose properties describes the allowed traffic between Azure
// resources
type AllowedConnectionsResource struct {
	autorest.Response `json:"-"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Location where the resource is stored
	Location                              *string `json:"location,omitempty"`
	*AllowedConnectionsResourceProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AllowedConnectionsResource.
func (acr AllowedConnectionsResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if acr.ID != nil {
		objectMap["id"] = acr.ID
	}
	if acr.Name != nil {
		objectMap["name"] = acr.Name
	}
	if acr.Type != nil {
		objectMap["type"] = acr.Type
	}
	if acr.Location != nil {
		objectMap["location"] = acr.Location
	}
	if acr.AllowedConnectionsResourceProperties != nil {
		objectMap["properties"] = acr.AllowedConnectionsResourceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AllowedConnectionsResource struct.
func (acr *AllowedConnectionsResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				acr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				acr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				acr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				acr.Location = &location
			}
		case "properties":
			if v != nil {
				var allowedConnectionsResourceProperties AllowedConnectionsResourceProperties
				err = json.Unmarshal(*v, &allowedConnectionsResourceProperties)
				if err != nil {
					return err
				}
				acr.AllowedConnectionsResourceProperties = &allowedConnectionsResourceProperties
			}
		}
	}

	return nil
}

// AllowedConnectionsResourceProperties describes the allowed traffic between Azure resources
type AllowedConnectionsResourceProperties struct {
	// CalculatedDateTime - The UTC time on which the allowed connections resource was calculated
	CalculatedDateTime *date.Time `json:"calculatedDateTime,omitempty"`
	// ConnectableResources - List of connectable resources
	ConnectableResources *[]ConnectableResource `json:"connectableResources,omitempty"`
}

// AscLocation the ASC location of the subscription is in the "name" field
type AscLocation struct {
	autorest.Response `json:"-"`
	Properties        interface{} `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// AscLocationList list of locations where ASC saves your data
type AscLocationList struct {
	autorest.Response `json:"-"`
	Value             *[]AscLocation `json:"value,omitempty"`
	// NextLink - The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// AscLocationListIterator provides access to a complete listing of AscLocation values.
type AscLocationListIterator struct {
	i    int
	page AscLocationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AscLocationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AscLocationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AscLocationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AscLocationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AscLocationListIterator) Response() AscLocationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AscLocationListIterator) Value() AscLocation {
	if !iter.page.NotDone() {
		return AscLocation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AscLocationListIterator type.
func NewAscLocationListIterator(page AscLocationListPage) AscLocationListIterator {
	return AscLocationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (all AscLocationList) IsEmpty() bool {
	return all.Value == nil || len(*all.Value) == 0
}

// ascLocationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (all AscLocationList) ascLocationListPreparer(ctx context.Context) (*http.Request, error) {
	if all.NextLink == nil || len(to.String(all.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(all.NextLink)))
}

// AscLocationListPage contains a page of AscLocation values.
type AscLocationListPage struct {
	fn  func(context.Context, AscLocationList) (AscLocationList, error)
	all AscLocationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AscLocationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AscLocationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.all)
	if err != nil {
		return err
	}
	page.all = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AscLocationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AscLocationListPage) NotDone() bool {
	return !page.all.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AscLocationListPage) Response() AscLocationList {
	return page.all
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AscLocationListPage) Values() []AscLocation {
	if page.all.IsEmpty() {
		return nil
	}
	return *page.all.Value
}

// Creates a new instance of the AscLocationListPage type.
func NewAscLocationListPage(getNextPage func(context.Context, AscLocationList) (AscLocationList, error)) AscLocationListPage {
	return AscLocationListPage{fn: getNextPage}
}

// AtaExternalSecuritySolution represents an ATA security solution which sends logs to an OMS workspace
type AtaExternalSecuritySolution struct {
	Properties *AtaSolutionProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Location where the resource is stored
	Location *string `json:"location,omitempty"`
	// Kind - Possible values include: 'KindExternalSecuritySolution', 'KindCEF', 'KindATA', 'KindAAD'
	Kind KindEnum `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AtaExternalSecuritySolution.
func (aess AtaExternalSecuritySolution) MarshalJSON() ([]byte, error) {
	aess.Kind = KindATA
	objectMap := make(map[string]interface{})
	if aess.Properties != nil {
		objectMap["properties"] = aess.Properties
	}
	if aess.ID != nil {
		objectMap["id"] = aess.ID
	}
	if aess.Name != nil {
		objectMap["name"] = aess.Name
	}
	if aess.Type != nil {
		objectMap["type"] = aess.Type
	}
	if aess.Location != nil {
		objectMap["location"] = aess.Location
	}
	if aess.Kind != "" {
		objectMap["kind"] = aess.Kind
	}
	return json.Marshal(objectMap)
}

// AsCefExternalSecuritySolution is the BasicExternalSecuritySolution implementation for AtaExternalSecuritySolution.
func (aess AtaExternalSecuritySolution) AsCefExternalSecuritySolution() (*CefExternalSecuritySolution, bool) {
	return nil, false
}

// AsAtaExternalSecuritySolution is the BasicExternalSecuritySolution implementation for AtaExternalSecuritySolution.
func (aess AtaExternalSecuritySolution) AsAtaExternalSecuritySolution() (*AtaExternalSecuritySolution, bool) {
	return &aess, true
}

// AsAadExternalSecuritySolution is the BasicExternalSecuritySolution implementation for AtaExternalSecuritySolution.
func (aess AtaExternalSecuritySolution) AsAadExternalSecuritySolution() (*AadExternalSecuritySolution, bool) {
	return nil, false
}

// AsExternalSecuritySolution is the BasicExternalSecuritySolution implementation for AtaExternalSecuritySolution.
func (aess AtaExternalSecuritySolution) AsExternalSecuritySolution() (*ExternalSecuritySolution, bool) {
	return nil, false
}

// AsBasicExternalSecuritySolution is the BasicExternalSecuritySolution implementation for AtaExternalSecuritySolution.
func (aess AtaExternalSecuritySolution) AsBasicExternalSecuritySolution() (BasicExternalSecuritySolution, bool) {
	return &aess, true
}

// AtaSolutionProperties ...
type AtaSolutionProperties struct {
	LastEventReceived *string `json:"lastEventReceived,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	DeviceVendor         *string                `json:"deviceVendor,omitempty"`
	DeviceType           *string                `json:"deviceType,omitempty"`
	Workspace            *ConnectedWorkspace    `json:"workspace,omitempty"`
}

// MarshalJSON is the custom marshaler for AtaSolutionProperties.
func (asp AtaSolutionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asp.LastEventReceived != nil {
		objectMap["lastEventReceived"] = asp.LastEventReceived
	}
	if asp.DeviceVendor != nil {
		objectMap["deviceVendor"] = asp.DeviceVendor
	}
	if asp.DeviceType != nil {
		objectMap["deviceType"] = asp.DeviceType
	}
	if asp.Workspace != nil {
		objectMap["workspace"] = asp.Workspace
	}
	for k, v := range asp.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AtaSolutionProperties struct.
func (asp *AtaSolutionProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "lastEventReceived":
			if v != nil {
				var lastEventReceived string
				err = json.Unmarshal(*v, &lastEventReceived)
				if err != nil {
					return err
				}
				asp.LastEventReceived = &lastEventReceived
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if asp.AdditionalProperties == nil {
					asp.AdditionalProperties = make(map[string]interface{})
				}
				asp.AdditionalProperties[k] = additionalProperties
			}
		case "deviceVendor":
			if v != nil {
				var deviceVendor string
				err = json.Unmarshal(*v, &deviceVendor)
				if err != nil {
					return err
				}
				asp.DeviceVendor = &deviceVendor
			}
		case "deviceType":
			if v != nil {
				var deviceType string
				err = json.Unmarshal(*v, &deviceType)
				if err != nil {
					return err
				}
				asp.DeviceType = &deviceType
			}
		case "workspace":
			if v != nil {
				var workspace ConnectedWorkspace
				err = json.Unmarshal(*v, &workspace)
				if err != nil {
					return err
				}
				asp.Workspace = &workspace
			}
		}
	}

	return nil
}

// AutoProvisioningSetting auto provisioning setting
type AutoProvisioningSetting struct {
	autorest.Response `json:"-"`
	// AutoProvisioningSettingProperties - Auto provisioning setting data
	*AutoProvisioningSettingProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AutoProvisioningSetting.
func (aps AutoProvisioningSetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aps.AutoProvisioningSettingProperties != nil {
		objectMap["properties"] = aps.AutoProvisioningSettingProperties
	}
	if aps.ID != nil {
		objectMap["id"] = aps.ID
	}
	if aps.Name != nil {
		objectMap["name"] = aps.Name
	}
	if aps.Type != nil {
		objectMap["type"] = aps.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AutoProvisioningSetting struct.
func (aps *AutoProvisioningSetting) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var autoProvisioningSettingProperties AutoProvisioningSettingProperties
				err = json.Unmarshal(*v, &autoProvisioningSettingProperties)
				if err != nil {
					return err
				}
				aps.AutoProvisioningSettingProperties = &autoProvisioningSettingProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				aps.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				aps.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				aps.Type = &typeVar
			}
		}
	}

	return nil
}

// AutoProvisioningSettingList list of all the auto provisioning settings response
type AutoProvisioningSettingList struct {
	autorest.Response `json:"-"`
	// Value - List of all the auto provisioning settings
	Value *[]AutoProvisioningSetting `json:"value,omitempty"`
	// NextLink - The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// AutoProvisioningSettingListIterator provides access to a complete listing of AutoProvisioningSetting
// values.
type AutoProvisioningSettingListIterator struct {
	i    int
	page AutoProvisioningSettingListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AutoProvisioningSettingListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AutoProvisioningSettingListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AutoProvisioningSettingListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AutoProvisioningSettingListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AutoProvisioningSettingListIterator) Response() AutoProvisioningSettingList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AutoProvisioningSettingListIterator) Value() AutoProvisioningSetting {
	if !iter.page.NotDone() {
		return AutoProvisioningSetting{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AutoProvisioningSettingListIterator type.
func NewAutoProvisioningSettingListIterator(page AutoProvisioningSettingListPage) AutoProvisioningSettingListIterator {
	return AutoProvisioningSettingListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (apsl AutoProvisioningSettingList) IsEmpty() bool {
	return apsl.Value == nil || len(*apsl.Value) == 0
}

// autoProvisioningSettingListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (apsl AutoProvisioningSettingList) autoProvisioningSettingListPreparer(ctx context.Context) (*http.Request, error) {
	if apsl.NextLink == nil || len(to.String(apsl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(apsl.NextLink)))
}

// AutoProvisioningSettingListPage contains a page of AutoProvisioningSetting values.
type AutoProvisioningSettingListPage struct {
	fn   func(context.Context, AutoProvisioningSettingList) (AutoProvisioningSettingList, error)
	apsl AutoProvisioningSettingList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AutoProvisioningSettingListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AutoProvisioningSettingListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.apsl)
	if err != nil {
		return err
	}
	page.apsl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AutoProvisioningSettingListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AutoProvisioningSettingListPage) NotDone() bool {
	return !page.apsl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AutoProvisioningSettingListPage) Response() AutoProvisioningSettingList {
	return page.apsl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AutoProvisioningSettingListPage) Values() []AutoProvisioningSetting {
	if page.apsl.IsEmpty() {
		return nil
	}
	return *page.apsl.Value
}

// Creates a new instance of the AutoProvisioningSettingListPage type.
func NewAutoProvisioningSettingListPage(getNextPage func(context.Context, AutoProvisioningSettingList) (AutoProvisioningSettingList, error)) AutoProvisioningSettingListPage {
	return AutoProvisioningSettingListPage{fn: getNextPage}
}

// AutoProvisioningSettingProperties describes properties of an auto provisioning setting
type AutoProvisioningSettingProperties struct {
	// AutoProvision - Describes what kind of security agent provisioning action to take. Possible values include: 'AutoProvisionOn', 'AutoProvisionOff'
	AutoProvision AutoProvision `json:"autoProvision,omitempty"`
}

// CefExternalSecuritySolution represents a security solution which sends CEF logs to an OMS workspace
type CefExternalSecuritySolution struct {
	Properties *CefSolutionProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Location where the resource is stored
	Location *string `json:"location,omitempty"`
	// Kind - Possible values include: 'KindExternalSecuritySolution', 'KindCEF', 'KindATA', 'KindAAD'
	Kind KindEnum `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for CefExternalSecuritySolution.
func (cess CefExternalSecuritySolution) MarshalJSON() ([]byte, error) {
	cess.Kind = KindCEF
	objectMap := make(map[string]interface{})
	if cess.Properties != nil {
		objectMap["properties"] = cess.Properties
	}
	if cess.ID != nil {
		objectMap["id"] = cess.ID
	}
	if cess.Name != nil {
		objectMap["name"] = cess.Name
	}
	if cess.Type != nil {
		objectMap["type"] = cess.Type
	}
	if cess.Location != nil {
		objectMap["location"] = cess.Location
	}
	if cess.Kind != "" {
		objectMap["kind"] = cess.Kind
	}
	return json.Marshal(objectMap)
}

// AsCefExternalSecuritySolution is the BasicExternalSecuritySolution implementation for CefExternalSecuritySolution.
func (cess CefExternalSecuritySolution) AsCefExternalSecuritySolution() (*CefExternalSecuritySolution, bool) {
	return &cess, true
}

// AsAtaExternalSecuritySolution is the BasicExternalSecuritySolution implementation for CefExternalSecuritySolution.
func (cess CefExternalSecuritySolution) AsAtaExternalSecuritySolution() (*AtaExternalSecuritySolution, bool) {
	return nil, false
}

// AsAadExternalSecuritySolution is the BasicExternalSecuritySolution implementation for CefExternalSecuritySolution.
func (cess CefExternalSecuritySolution) AsAadExternalSecuritySolution() (*AadExternalSecuritySolution, bool) {
	return nil, false
}

// AsExternalSecuritySolution is the BasicExternalSecuritySolution implementation for CefExternalSecuritySolution.
func (cess CefExternalSecuritySolution) AsExternalSecuritySolution() (*ExternalSecuritySolution, bool) {
	return nil, false
}

// AsBasicExternalSecuritySolution is the BasicExternalSecuritySolution implementation for CefExternalSecuritySolution.
func (cess CefExternalSecuritySolution) AsBasicExternalSecuritySolution() (BasicExternalSecuritySolution, bool) {
	return &cess, true
}

// CefSolutionProperties ...
type CefSolutionProperties struct {
	Hostname          *string `json:"hostname,omitempty"`
	Agent             *string `json:"agent,omitempty"`
	LastEventReceived *string `json:"lastEventReceived,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	DeviceVendor         *string                `json:"deviceVendor,omitempty"`
	DeviceType           *string                `json:"deviceType,omitempty"`
	Workspace            *ConnectedWorkspace    `json:"workspace,omitempty"`
}

// MarshalJSON is the custom marshaler for CefSolutionProperties.
func (csp CefSolutionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if csp.Hostname != nil {
		objectMap["hostname"] = csp.Hostname
	}
	if csp.Agent != nil {
		objectMap["agent"] = csp.Agent
	}
	if csp.LastEventReceived != nil {
		objectMap["lastEventReceived"] = csp.LastEventReceived
	}
	if csp.DeviceVendor != nil {
		objectMap["deviceVendor"] = csp.DeviceVendor
	}
	if csp.DeviceType != nil {
		objectMap["deviceType"] = csp.DeviceType
	}
	if csp.Workspace != nil {
		objectMap["workspace"] = csp.Workspace
	}
	for k, v := range csp.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CefSolutionProperties struct.
func (csp *CefSolutionProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "hostname":
			if v != nil {
				var hostname string
				err = json.Unmarshal(*v, &hostname)
				if err != nil {
					return err
				}
				csp.Hostname = &hostname
			}
		case "agent":
			if v != nil {
				var agent string
				err = json.Unmarshal(*v, &agent)
				if err != nil {
					return err
				}
				csp.Agent = &agent
			}
		case "lastEventReceived":
			if v != nil {
				var lastEventReceived string
				err = json.Unmarshal(*v, &lastEventReceived)
				if err != nil {
					return err
				}
				csp.LastEventReceived = &lastEventReceived
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if csp.AdditionalProperties == nil {
					csp.AdditionalProperties = make(map[string]interface{})
				}
				csp.AdditionalProperties[k] = additionalProperties
			}
		case "deviceVendor":
			if v != nil {
				var deviceVendor string
				err = json.Unmarshal(*v, &deviceVendor)
				if err != nil {
					return err
				}
				csp.DeviceVendor = &deviceVendor
			}
		case "deviceType":
			if v != nil {
				var deviceType string
				err = json.Unmarshal(*v, &deviceType)
				if err != nil {
					return err
				}
				csp.DeviceType = &deviceType
			}
		case "workspace":
			if v != nil {
				var workspace ConnectedWorkspace
				err = json.Unmarshal(*v, &workspace)
				if err != nil {
					return err
				}
				csp.Workspace = &workspace
			}
		}
	}

	return nil
}

// CloudError error response structure.
type CloudError struct {
	// CloudErrorBody - Error data
	*CloudErrorBody `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for CloudError.
func (ce CloudError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ce.CloudErrorBody != nil {
		objectMap["error"] = ce.CloudErrorBody
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CloudError struct.
func (ce *CloudError) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "error":
			if v != nil {
				var cloudErrorBody CloudErrorBody
				err = json.Unmarshal(*v, &cloudErrorBody)
				if err != nil {
					return err
				}
				ce.CloudErrorBody = &cloudErrorBody
			}
		}
	}

	return nil
}

// CloudErrorBody error details.
type CloudErrorBody struct {
	// Code - An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
}

// Compliance compliance of a scope
type Compliance struct {
	autorest.Response `json:"-"`
	// ComplianceProperties - Compliance data
	*ComplianceProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Compliance.
func (c Compliance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.ComplianceProperties != nil {
		objectMap["properties"] = c.ComplianceProperties
	}
	if c.ID != nil {
		objectMap["id"] = c.ID
	}
	if c.Name != nil {
		objectMap["name"] = c.Name
	}
	if c.Type != nil {
		objectMap["type"] = c.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Compliance struct.
func (c *Compliance) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var complianceProperties ComplianceProperties
				err = json.Unmarshal(*v, &complianceProperties)
				if err != nil {
					return err
				}
				c.ComplianceProperties = &complianceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		}
	}

	return nil
}

// ComplianceList list of Compliance objects response
type ComplianceList struct {
	autorest.Response `json:"-"`
	// Value - List of Compliance objects
	Value *[]Compliance `json:"value,omitempty"`
	// NextLink - The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// ComplianceListIterator provides access to a complete listing of Compliance values.
type ComplianceListIterator struct {
	i    int
	page ComplianceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ComplianceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ComplianceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ComplianceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ComplianceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ComplianceListIterator) Response() ComplianceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ComplianceListIterator) Value() Compliance {
	if !iter.page.NotDone() {
		return Compliance{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ComplianceListIterator type.
func NewComplianceListIterator(page ComplianceListPage) ComplianceListIterator {
	return ComplianceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cl ComplianceList) IsEmpty() bool {
	return cl.Value == nil || len(*cl.Value) == 0
}

// complianceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cl ComplianceList) complianceListPreparer(ctx context.Context) (*http.Request, error) {
	if cl.NextLink == nil || len(to.String(cl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cl.NextLink)))
}

// ComplianceListPage contains a page of Compliance values.
type ComplianceListPage struct {
	fn func(context.Context, ComplianceList) (ComplianceList, error)
	cl ComplianceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ComplianceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ComplianceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.cl)
	if err != nil {
		return err
	}
	page.cl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ComplianceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ComplianceListPage) NotDone() bool {
	return !page.cl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ComplianceListPage) Response() ComplianceList {
	return page.cl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ComplianceListPage) Values() []Compliance {
	if page.cl.IsEmpty() {
		return nil
	}
	return *page.cl.Value
}

// Creates a new instance of the ComplianceListPage type.
func NewComplianceListPage(getNextPage func(context.Context, ComplianceList) (ComplianceList, error)) ComplianceListPage {
	return ComplianceListPage{fn: getNextPage}
}

// ComplianceProperties the Compliance score (percentage) of a Subscription is a sum of all Resources'
// Compliances under the given Subscription. A Resource Compliance is defined as the compliant ('healthy')
// Policy Definitions out of all Policy Definitions applicable to a given resource.
type ComplianceProperties struct {
	// AssessmentTimestampUtcDate - The timestamp when the Compliance calculation was conducted.
	AssessmentTimestampUtcDate *date.Time `json:"assessmentTimestampUtcDate,omitempty"`
	// ResourceCount - The resource count of the given subscription for which the Compliance calculation was conducted (needed for Management Group Compliance calculation).
	ResourceCount *int32 `json:"resourceCount,omitempty"`
	// AssessmentResult - An array of segment, which is the actually the compliance assessment.
	AssessmentResult *[]ComplianceSegment `json:"assessmentResult,omitempty"`
}

// ComplianceSegment a segment of a compliance assessment.
type ComplianceSegment struct {
	// SegmentType - The segment type, e.g. compliant, non-compliance, insufficient coverage, N/A, etc.
	SegmentType *string `json:"segmentType,omitempty"`
	// Percentage - The size (%) of the segment.
	Percentage *float64 `json:"percentage,omitempty"`
}

// ConnectableResource describes the allowed inbound and outbound traffic of an Azure resource
type ConnectableResource struct {
	// ID - The Azure resource id
	ID *string `json:"id,omitempty"`
	// InboundConnectedResources - The list of Azure resources that the resource has inbound allowed connection from
	InboundConnectedResources *[]ConnectedResource `json:"inboundConnectedResources,omitempty"`
	// OutboundConnectedResources - The list of Azure resources that the resource has outbound allowed connection to
	OutboundConnectedResources *[]ConnectedResource `json:"outboundConnectedResources,omitempty"`
}

// ConnectedResource describes properties of a connected resource
type ConnectedResource struct {
	// ConnectedResourceID - The Azure resource id of the connected resource
	ConnectedResourceID *string `json:"connectedResourceId,omitempty"`
	// TCPPorts - The allowed tcp ports
	TCPPorts *string `json:"tcpPorts,omitempty"`
	// UDPPorts - The allowed udp ports
	UDPPorts *string `json:"udpPorts,omitempty"`
}

// ConnectedWorkspace ...
type ConnectedWorkspace struct {
	// ID - Azure resource ID of the connected OMS workspace
	ID *string `json:"id,omitempty"`
}

// Contact contact details for security issues
type Contact struct {
	autorest.Response `json:"-"`
	// ContactProperties - Security contact data
	*ContactProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Contact.
func (c Contact) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.ContactProperties != nil {
		objectMap["properties"] = c.ContactProperties
	}
	if c.ID != nil {
		objectMap["id"] = c.ID
	}
	if c.Name != nil {
		objectMap["name"] = c.Name
	}
	if c.Type != nil {
		objectMap["type"] = c.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Contact struct.
func (c *Contact) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var contactProperties ContactProperties
				err = json.Unmarshal(*v, &contactProperties)
				if err != nil {
					return err
				}
				c.ContactProperties = &contactProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		}
	}

	return nil
}

// ContactList list of security contacts response
type ContactList struct {
	autorest.Response `json:"-"`
	// Value - List of security contacts
	Value *[]Contact `json:"value,omitempty"`
	// NextLink - The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// ContactListIterator provides access to a complete listing of Contact values.
type ContactListIterator struct {
	i    int
	page ContactListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ContactListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ContactListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ContactListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ContactListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ContactListIterator) Response() ContactList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ContactListIterator) Value() Contact {
	if !iter.page.NotDone() {
		return Contact{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ContactListIterator type.
func NewContactListIterator(page ContactListPage) ContactListIterator {
	return ContactListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cl ContactList) IsEmpty() bool {
	return cl.Value == nil || len(*cl.Value) == 0
}

// contactListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cl ContactList) contactListPreparer(ctx context.Context) (*http.Request, error) {
	if cl.NextLink == nil || len(to.String(cl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cl.NextLink)))
}

// ContactListPage contains a page of Contact values.
type ContactListPage struct {
	fn func(context.Context, ContactList) (ContactList, error)
	cl ContactList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ContactListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ContactListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.cl)
	if err != nil {
		return err
	}
	page.cl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ContactListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ContactListPage) NotDone() bool {
	return !page.cl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ContactListPage) Response() ContactList {
	return page.cl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ContactListPage) Values() []Contact {
	if page.cl.IsEmpty() {
		return nil
	}
	return *page.cl.Value
}

// Creates a new instance of the ContactListPage type.
func NewContactListPage(getNextPage func(context.Context, ContactList) (ContactList, error)) ContactListPage {
	return ContactListPage{fn: getNextPage}
}

// ContactProperties describes security contact properties
type ContactProperties struct {
	// Email - The email of this security contact
	Email *string `json:"email,omitempty"`
	// Phone - The phone number of this security contact
	Phone *string `json:"phone,omitempty"`
	// AlertNotifications - Whether to send security alerts notifications to the security contact. Possible values include: 'On', 'Off'
	AlertNotifications AlertNotifications `json:"alertNotifications,omitempty"`
	// AlertsToAdmins - Whether to send security alerts notifications to subscription admins. Possible values include: 'AlertsToAdminsOn', 'AlertsToAdminsOff'
	AlertsToAdmins AlertsToAdmins `json:"alertsToAdmins,omitempty"`
}

// DataExportSetting represents a data export setting
type DataExportSetting struct {
	// DataExportSettingProperties - Data export setting data
	*DataExportSettingProperties `json:"properties,omitempty"`
	// Kind - the kind of the settings string (DataExportSetting). Possible values include: 'SettingKindDataExportSetting', 'SettingKindAlertSuppressionSetting'
	Kind SettingKind `json:"kind,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DataExportSetting.
func (desVar DataExportSetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if desVar.DataExportSettingProperties != nil {
		objectMap["properties"] = desVar.DataExportSettingProperties
	}
	if desVar.Kind != "" {
		objectMap["kind"] = desVar.Kind
	}
	if desVar.ID != nil {
		objectMap["id"] = desVar.ID
	}
	if desVar.Name != nil {
		objectMap["name"] = desVar.Name
	}
	if desVar.Type != nil {
		objectMap["type"] = desVar.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DataExportSetting struct.
func (desVar *DataExportSetting) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dataExportSettingProperties DataExportSettingProperties
				err = json.Unmarshal(*v, &dataExportSettingProperties)
				if err != nil {
					return err
				}
				desVar.DataExportSettingProperties = &dataExportSettingProperties
			}
		case "kind":
			if v != nil {
				var kind SettingKind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				desVar.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				desVar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				desVar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				desVar.Type = &typeVar
			}
		}
	}

	return nil
}

// DataExportSettingProperties the data export setting properties
type DataExportSettingProperties struct {
	// Enabled - Is the data export setting is enabled
	Enabled *bool `json:"enabled,omitempty"`
}

// DiscoveredSecuritySolution ...
type DiscoveredSecuritySolution struct {
	autorest.Response `json:"-"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Location where the resource is stored
	Location                              *string `json:"location,omitempty"`
	*DiscoveredSecuritySolutionProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for DiscoveredSecuritySolution.
func (dss DiscoveredSecuritySolution) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dss.ID != nil {
		objectMap["id"] = dss.ID
	}
	if dss.Name != nil {
		objectMap["name"] = dss.Name
	}
	if dss.Type != nil {
		objectMap["type"] = dss.Type
	}
	if dss.Location != nil {
		objectMap["location"] = dss.Location
	}
	if dss.DiscoveredSecuritySolutionProperties != nil {
		objectMap["properties"] = dss.DiscoveredSecuritySolutionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DiscoveredSecuritySolution struct.
func (dss *DiscoveredSecuritySolution) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dss.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dss.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dss.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dss.Location = &location
			}
		case "properties":
			if v != nil {
				var discoveredSecuritySolutionProperties DiscoveredSecuritySolutionProperties
				err = json.Unmarshal(*v, &discoveredSecuritySolutionProperties)
				if err != nil {
					return err
				}
				dss.DiscoveredSecuritySolutionProperties = &discoveredSecuritySolutionProperties
			}
		}
	}

	return nil
}

// DiscoveredSecuritySolutionList ...
type DiscoveredSecuritySolutionList struct {
	autorest.Response `json:"-"`
	Value             *[]DiscoveredSecuritySolution `json:"value,omitempty"`
	// NextLink - The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// DiscoveredSecuritySolutionListIterator provides access to a complete listing of
// DiscoveredSecuritySolution values.
type DiscoveredSecuritySolutionListIterator struct {
	i    int
	page DiscoveredSecuritySolutionListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DiscoveredSecuritySolutionListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiscoveredSecuritySolutionListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DiscoveredSecuritySolutionListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DiscoveredSecuritySolutionListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DiscoveredSecuritySolutionListIterator) Response() DiscoveredSecuritySolutionList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DiscoveredSecuritySolutionListIterator) Value() DiscoveredSecuritySolution {
	if !iter.page.NotDone() {
		return DiscoveredSecuritySolution{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DiscoveredSecuritySolutionListIterator type.
func NewDiscoveredSecuritySolutionListIterator(page DiscoveredSecuritySolutionListPage) DiscoveredSecuritySolutionListIterator {
	return DiscoveredSecuritySolutionListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dssl DiscoveredSecuritySolutionList) IsEmpty() bool {
	return dssl.Value == nil || len(*dssl.Value) == 0
}

// discoveredSecuritySolutionListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dssl DiscoveredSecuritySolutionList) discoveredSecuritySolutionListPreparer(ctx context.Context) (*http.Request, error) {
	if dssl.NextLink == nil || len(to.String(dssl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dssl.NextLink)))
}

// DiscoveredSecuritySolutionListPage contains a page of DiscoveredSecuritySolution values.
type DiscoveredSecuritySolutionListPage struct {
	fn   func(context.Context, DiscoveredSecuritySolutionList) (DiscoveredSecuritySolutionList, error)
	dssl DiscoveredSecuritySolutionList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DiscoveredSecuritySolutionListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiscoveredSecuritySolutionListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.dssl)
	if err != nil {
		return err
	}
	page.dssl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DiscoveredSecuritySolutionListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DiscoveredSecuritySolutionListPage) NotDone() bool {
	return !page.dssl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DiscoveredSecuritySolutionListPage) Response() DiscoveredSecuritySolutionList {
	return page.dssl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DiscoveredSecuritySolutionListPage) Values() []DiscoveredSecuritySolution {
	if page.dssl.IsEmpty() {
		return nil
	}
	return *page.dssl.Value
}

// Creates a new instance of the DiscoveredSecuritySolutionListPage type.
func NewDiscoveredSecuritySolutionListPage(getNextPage func(context.Context, DiscoveredSecuritySolutionList) (DiscoveredSecuritySolutionList, error)) DiscoveredSecuritySolutionListPage {
	return DiscoveredSecuritySolutionListPage{fn: getNextPage}
}

// DiscoveredSecuritySolutionProperties ...
type DiscoveredSecuritySolutionProperties struct {
	// SecurityFamily - The security family of the discovered solution. Possible values include: 'Waf', 'Ngfw', 'SaasWaf', 'Va'
	SecurityFamily Family `json:"securityFamily,omitempty"`
	// Offer - The security solutions' image offer
	Offer *string `json:"offer,omitempty"`
	// Publisher - The security solutions' image publisher
	Publisher *string `json:"publisher,omitempty"`
	// Sku - The security solutions' image sku
	Sku *string `json:"sku,omitempty"`
}

// BasicExternalSecuritySolution represents a security solution external to Azure Security Center which sends
// information to an OMS workspace and whose data is displayed by Azure Security Center.
type BasicExternalSecuritySolution interface {
	AsCefExternalSecuritySolution() (*CefExternalSecuritySolution, bool)
	AsAtaExternalSecuritySolution() (*AtaExternalSecuritySolution, bool)
	AsAadExternalSecuritySolution() (*AadExternalSecuritySolution, bool)
	AsExternalSecuritySolution() (*ExternalSecuritySolution, bool)
}

// ExternalSecuritySolution represents a security solution external to Azure Security Center which sends
// information to an OMS workspace and whose data is displayed by Azure Security Center.
type ExternalSecuritySolution struct {
	autorest.Response `json:"-"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Location where the resource is stored
	Location *string `json:"location,omitempty"`
	// Kind - Possible values include: 'KindExternalSecuritySolution', 'KindCEF', 'KindATA', 'KindAAD'
	Kind KindEnum `json:"kind,omitempty"`
}

func unmarshalBasicExternalSecuritySolution(body []byte) (BasicExternalSecuritySolution, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindCEF):
		var cess CefExternalSecuritySolution
		err := json.Unmarshal(body, &cess)
		return cess, err
	case string(KindATA):
		var aess AtaExternalSecuritySolution
		err := json.Unmarshal(body, &aess)
		return aess, err
	case string(KindAAD):
		var aess AadExternalSecuritySolution
		err := json.Unmarshal(body, &aess)
		return aess, err
	default:
		var ess ExternalSecuritySolution
		err := json.Unmarshal(body, &ess)
		return ess, err
	}
}
func unmarshalBasicExternalSecuritySolutionArray(body []byte) ([]BasicExternalSecuritySolution, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	essArray := make([]BasicExternalSecuritySolution, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ess, err := unmarshalBasicExternalSecuritySolution(*rawMessage)
		if err != nil {
			return nil, err
		}
		essArray[index] = ess
	}
	return essArray, nil
}

// MarshalJSON is the custom marshaler for ExternalSecuritySolution.
func (ess ExternalSecuritySolution) MarshalJSON() ([]byte, error) {
	ess.Kind = KindExternalSecuritySolution
	objectMap := make(map[string]interface{})
	if ess.ID != nil {
		objectMap["id"] = ess.ID
	}
	if ess.Name != nil {
		objectMap["name"] = ess.Name
	}
	if ess.Type != nil {
		objectMap["type"] = ess.Type
	}
	if ess.Location != nil {
		objectMap["location"] = ess.Location
	}
	if ess.Kind != "" {
		objectMap["kind"] = ess.Kind
	}
	return json.Marshal(objectMap)
}

// AsCefExternalSecuritySolution is the BasicExternalSecuritySolution implementation for ExternalSecuritySolution.
func (ess ExternalSecuritySolution) AsCefExternalSecuritySolution() (*CefExternalSecuritySolution, bool) {
	return nil, false
}

// AsAtaExternalSecuritySolution is the BasicExternalSecuritySolution implementation for ExternalSecuritySolution.
func (ess ExternalSecuritySolution) AsAtaExternalSecuritySolution() (*AtaExternalSecuritySolution, bool) {
	return nil, false
}

// AsAadExternalSecuritySolution is the BasicExternalSecuritySolution implementation for ExternalSecuritySolution.
func (ess ExternalSecuritySolution) AsAadExternalSecuritySolution() (*AadExternalSecuritySolution, bool) {
	return nil, false
}

// AsExternalSecuritySolution is the BasicExternalSecuritySolution implementation for ExternalSecuritySolution.
func (ess ExternalSecuritySolution) AsExternalSecuritySolution() (*ExternalSecuritySolution, bool) {
	return &ess, true
}

// AsBasicExternalSecuritySolution is the BasicExternalSecuritySolution implementation for ExternalSecuritySolution.
func (ess ExternalSecuritySolution) AsBasicExternalSecuritySolution() (BasicExternalSecuritySolution, bool) {
	return &ess, true
}

// ExternalSecuritySolutionKind1 describes an Azure resource with kind
type ExternalSecuritySolutionKind1 struct {
	// Kind - The kind of the external solution. Possible values include: 'CEF', 'ATA', 'AAD'
	Kind ExternalSecuritySolutionKind `json:"kind,omitempty"`
}

// ExternalSecuritySolutionList ...
type ExternalSecuritySolutionList struct {
	autorest.Response `json:"-"`
	Value             *[]BasicExternalSecuritySolution `json:"value,omitempty"`
	// NextLink - The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ExternalSecuritySolutionList struct.
func (essl *ExternalSecuritySolutionList) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "value":
			if v != nil {
				value, err := unmarshalBasicExternalSecuritySolutionArray(*v)
				if err != nil {
					return err
				}
				essl.Value = &value
			}
		case "nextLink":
			if v != nil {
				var nextLink string
				err = json.Unmarshal(*v, &nextLink)
				if err != nil {
					return err
				}
				essl.NextLink = &nextLink
			}
		}
	}

	return nil
}

// ExternalSecuritySolutionListIterator provides access to a complete listing of ExternalSecuritySolution
// values.
type ExternalSecuritySolutionListIterator struct {
	i    int
	page ExternalSecuritySolutionListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExternalSecuritySolutionListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExternalSecuritySolutionListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExternalSecuritySolutionListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExternalSecuritySolutionListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExternalSecuritySolutionListIterator) Response() ExternalSecuritySolutionList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExternalSecuritySolutionListIterator) Value() BasicExternalSecuritySolution {
	if !iter.page.NotDone() {
		return ExternalSecuritySolution{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExternalSecuritySolutionListIterator type.
func NewExternalSecuritySolutionListIterator(page ExternalSecuritySolutionListPage) ExternalSecuritySolutionListIterator {
	return ExternalSecuritySolutionListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (essl ExternalSecuritySolutionList) IsEmpty() bool {
	return essl.Value == nil || len(*essl.Value) == 0
}

// externalSecuritySolutionListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (essl ExternalSecuritySolutionList) externalSecuritySolutionListPreparer(ctx context.Context) (*http.Request, error) {
	if essl.NextLink == nil || len(to.String(essl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(essl.NextLink)))
}

// ExternalSecuritySolutionListPage contains a page of BasicExternalSecuritySolution values.
type ExternalSecuritySolutionListPage struct {
	fn   func(context.Context, ExternalSecuritySolutionList) (ExternalSecuritySolutionList, error)
	essl ExternalSecuritySolutionList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExternalSecuritySolutionListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExternalSecuritySolutionListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.essl)
	if err != nil {
		return err
	}
	page.essl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExternalSecuritySolutionListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExternalSecuritySolutionListPage) NotDone() bool {
	return !page.essl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExternalSecuritySolutionListPage) Response() ExternalSecuritySolutionList {
	return page.essl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExternalSecuritySolutionListPage) Values() []BasicExternalSecuritySolution {
	if page.essl.IsEmpty() {
		return nil
	}
	return *page.essl.Value
}

// Creates a new instance of the ExternalSecuritySolutionListPage type.
func NewExternalSecuritySolutionListPage(getNextPage func(context.Context, ExternalSecuritySolutionList) (ExternalSecuritySolutionList, error)) ExternalSecuritySolutionListPage {
	return ExternalSecuritySolutionListPage{fn: getNextPage}
}

// ExternalSecuritySolutionModel ...
type ExternalSecuritySolutionModel struct {
	autorest.Response `json:"-"`
	Value             BasicExternalSecuritySolution `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ExternalSecuritySolutionModel struct.
func (essm *ExternalSecuritySolutionModel) UnmarshalJSON(body []byte) error {
	ess, err := unmarshalBasicExternalSecuritySolution(body)
	if err != nil {
		return err
	}
	essm.Value = ess

	return nil
}

// ExternalSecuritySolutionProperties the solution properties (correspond to the solution kind)
type ExternalSecuritySolutionProperties struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	DeviceVendor         *string                `json:"deviceVendor,omitempty"`
	DeviceType           *string                `json:"deviceType,omitempty"`
	Workspace            *ConnectedWorkspace    `json:"workspace,omitempty"`
}

// MarshalJSON is the custom marshaler for ExternalSecuritySolutionProperties.
func (essp ExternalSecuritySolutionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if essp.DeviceVendor != nil {
		objectMap["deviceVendor"] = essp.DeviceVendor
	}
	if essp.DeviceType != nil {
		objectMap["deviceType"] = essp.DeviceType
	}
	if essp.Workspace != nil {
		objectMap["workspace"] = essp.Workspace
	}
	for k, v := range essp.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExternalSecuritySolutionProperties struct.
func (essp *ExternalSecuritySolutionProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if essp.AdditionalProperties == nil {
					essp.AdditionalProperties = make(map[string]interface{})
				}
				essp.AdditionalProperties[k] = additionalProperties
			}
		case "deviceVendor":
			if v != nil {
				var deviceVendor string
				err = json.Unmarshal(*v, &deviceVendor)
				if err != nil {
					return err
				}
				essp.DeviceVendor = &deviceVendor
			}
		case "deviceType":
			if v != nil {
				var deviceType string
				err = json.Unmarshal(*v, &deviceType)
				if err != nil {
					return err
				}
				essp.DeviceType = &deviceType
			}
		case "workspace":
			if v != nil {
				var workspace ConnectedWorkspace
				err = json.Unmarshal(*v, &workspace)
				if err != nil {
					return err
				}
				essp.Workspace = &workspace
			}
		}
	}

	return nil
}

// InformationProtectionKeyword the information type keyword.
type InformationProtectionKeyword struct {
	// Pattern - The keyword pattern.
	Pattern *string `json:"pattern,omitempty"`
	// Custom - Indicates whether the keyword is custom or not.
	Custom *bool `json:"custom,omitempty"`
	// CanBeNumeric - Indicates whether the keyword can be applied on numeric types or not.
	CanBeNumeric *bool `json:"canBeNumeric,omitempty"`
	// Excluded - Indicates whether the keyword is excluded or not.
	Excluded *bool `json:"excluded,omitempty"`
}

// InformationProtectionPolicy information protection policy.
type InformationProtectionPolicy struct {
	autorest.Response `json:"-"`
	// InformationProtectionPolicyProperties - Information protection policy data
	*InformationProtectionPolicyProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for InformationProtectionPolicy.
func (ipp InformationProtectionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ipp.InformationProtectionPolicyProperties != nil {
		objectMap["properties"] = ipp.InformationProtectionPolicyProperties
	}
	if ipp.ID != nil {
		objectMap["id"] = ipp.ID
	}
	if ipp.Name != nil {
		objectMap["name"] = ipp.Name
	}
	if ipp.Type != nil {
		objectMap["type"] = ipp.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for InformationProtectionPolicy struct.
func (ipp *InformationProtectionPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var informationProtectionPolicyProperties InformationProtectionPolicyProperties
				err = json.Unmarshal(*v, &informationProtectionPolicyProperties)
				if err != nil {
					return err
				}
				ipp.InformationProtectionPolicyProperties = &informationProtectionPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ipp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ipp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ipp.Type = &typeVar
			}
		}
	}

	return nil
}

// InformationProtectionPolicyList information protection policies response.
type InformationProtectionPolicyList struct {
	autorest.Response `json:"-"`
	// Value - List of information protection policies.
	Value *[]InformationProtectionPolicy `json:"value,omitempty"`
	// NextLink - The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// InformationProtectionPolicyListIterator provides access to a complete listing of
// InformationProtectionPolicy values.
type InformationProtectionPolicyListIterator struct {
	i    int
	page InformationProtectionPolicyListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *InformationProtectionPolicyListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InformationProtectionPolicyListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *InformationProtectionPolicyListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter InformationProtectionPolicyListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter InformationProtectionPolicyListIterator) Response() InformationProtectionPolicyList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter InformationProtectionPolicyListIterator) Value() InformationProtectionPolicy {
	if !iter.page.NotDone() {
		return InformationProtectionPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the InformationProtectionPolicyListIterator type.
func NewInformationProtectionPolicyListIterator(page InformationProtectionPolicyListPage) InformationProtectionPolicyListIterator {
	return InformationProtectionPolicyListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ippl InformationProtectionPolicyList) IsEmpty() bool {
	return ippl.Value == nil || len(*ippl.Value) == 0
}

// informationProtectionPolicyListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ippl InformationProtectionPolicyList) informationProtectionPolicyListPreparer(ctx context.Context) (*http.Request, error) {
	if ippl.NextLink == nil || len(to.String(ippl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ippl.NextLink)))
}

// InformationProtectionPolicyListPage contains a page of InformationProtectionPolicy values.
type InformationProtectionPolicyListPage struct {
	fn   func(context.Context, InformationProtectionPolicyList) (InformationProtectionPolicyList, error)
	ippl InformationProtectionPolicyList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *InformationProtectionPolicyListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InformationProtectionPolicyListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ippl)
	if err != nil {
		return err
	}
	page.ippl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *InformationProtectionPolicyListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page InformationProtectionPolicyListPage) NotDone() bool {
	return !page.ippl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page InformationProtectionPolicyListPage) Response() InformationProtectionPolicyList {
	return page.ippl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page InformationProtectionPolicyListPage) Values() []InformationProtectionPolicy {
	if page.ippl.IsEmpty() {
		return nil
	}
	return *page.ippl.Value
}

// Creates a new instance of the InformationProtectionPolicyListPage type.
func NewInformationProtectionPolicyListPage(getNextPage func(context.Context, InformationProtectionPolicyList) (InformationProtectionPolicyList, error)) InformationProtectionPolicyListPage {
	return InformationProtectionPolicyListPage{fn: getNextPage}
}

// InformationProtectionPolicyProperties describes properties of an information protection policy.
type InformationProtectionPolicyProperties struct {
	// LastModifiedUtc - Describes the last UTC time the policy was modified.
	LastModifiedUtc *date.Time `json:"lastModifiedUtc,omitempty"`
	// Labels - Dictionary of sensitivity labels.
	Labels map[string]*SensitivityLabel `json:"labels"`
	// InformationTypes - The sensitivity information types.
	InformationTypes map[string]*InformationType `json:"informationTypes"`
}

// MarshalJSON is the custom marshaler for InformationProtectionPolicyProperties.
func (ippp InformationProtectionPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ippp.LastModifiedUtc != nil {
		objectMap["lastModifiedUtc"] = ippp.LastModifiedUtc
	}
	if ippp.Labels != nil {
		objectMap["labels"] = ippp.Labels
	}
	if ippp.InformationTypes != nil {
		objectMap["informationTypes"] = ippp.InformationTypes
	}
	return json.Marshal(objectMap)
}

// InformationType the information type.
type InformationType struct {
	// DisplayName - The name of the information type.
	DisplayName *string `json:"displayName,omitempty"`
	// Order - The order of the information type.
	Order *float64 `json:"order,omitempty"`
	// RecommendedLabelID - The recommended label id to be associated with this information type.
	RecommendedLabelID *uuid.UUID `json:"recommendedLabelId,omitempty"`
	// Enabled - Indicates whether the information type is enabled or not.
	Enabled *bool `json:"enabled,omitempty"`
	// Custom - Indicates whether the information type is custom or not.
	Custom *bool `json:"custom,omitempty"`
	// Keywords - The information type keywords.
	Keywords *[]InformationProtectionKeyword `json:"keywords,omitempty"`
}

// JitNetworkAccessPoliciesList ...
type JitNetworkAccessPoliciesList struct {
	autorest.Response `json:"-"`
	Value             *[]JitNetworkAccessPolicy `json:"value,omitempty"`
	// NextLink - The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// JitNetworkAccessPoliciesListIterator provides access to a complete listing of JitNetworkAccessPolicy
// values.
type JitNetworkAccessPoliciesListIterator struct {
	i    int
	page JitNetworkAccessPoliciesListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JitNetworkAccessPoliciesListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JitNetworkAccessPoliciesListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JitNetworkAccessPoliciesListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JitNetworkAccessPoliciesListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JitNetworkAccessPoliciesListIterator) Response() JitNetworkAccessPoliciesList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JitNetworkAccessPoliciesListIterator) Value() JitNetworkAccessPolicy {
	if !iter.page.NotDone() {
		return JitNetworkAccessPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JitNetworkAccessPoliciesListIterator type.
func NewJitNetworkAccessPoliciesListIterator(page JitNetworkAccessPoliciesListPage) JitNetworkAccessPoliciesListIterator {
	return JitNetworkAccessPoliciesListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jnapl JitNetworkAccessPoliciesList) IsEmpty() bool {
	return jnapl.Value == nil || len(*jnapl.Value) == 0
}

// jitNetworkAccessPoliciesListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jnapl JitNetworkAccessPoliciesList) jitNetworkAccessPoliciesListPreparer(ctx context.Context) (*http.Request, error) {
	if jnapl.NextLink == nil || len(to.String(jnapl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jnapl.NextLink)))
}

// JitNetworkAccessPoliciesListPage contains a page of JitNetworkAccessPolicy values.
type JitNetworkAccessPoliciesListPage struct {
	fn    func(context.Context, JitNetworkAccessPoliciesList) (JitNetworkAccessPoliciesList, error)
	jnapl JitNetworkAccessPoliciesList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JitNetworkAccessPoliciesListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JitNetworkAccessPoliciesListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.jnapl)
	if err != nil {
		return err
	}
	page.jnapl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JitNetworkAccessPoliciesListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JitNetworkAccessPoliciesListPage) NotDone() bool {
	return !page.jnapl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JitNetworkAccessPoliciesListPage) Response() JitNetworkAccessPoliciesList {
	return page.jnapl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JitNetworkAccessPoliciesListPage) Values() []JitNetworkAccessPolicy {
	if page.jnapl.IsEmpty() {
		return nil
	}
	return *page.jnapl.Value
}

// Creates a new instance of the JitNetworkAccessPoliciesListPage type.
func NewJitNetworkAccessPoliciesListPage(getNextPage func(context.Context, JitNetworkAccessPoliciesList) (JitNetworkAccessPoliciesList, error)) JitNetworkAccessPoliciesListPage {
	return JitNetworkAccessPoliciesListPage{fn: getNextPage}
}

// JitNetworkAccessPolicy ...
type JitNetworkAccessPolicy struct {
	autorest.Response `json:"-"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Kind - Kind of the resource
	Kind *string `json:"kind,omitempty"`
	// Location - Location where the resource is stored
	Location                          *string `json:"location,omitempty"`
	*JitNetworkAccessPolicyProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for JitNetworkAccessPolicy.
func (jnap JitNetworkAccessPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jnap.ID != nil {
		objectMap["id"] = jnap.ID
	}
	if jnap.Name != nil {
		objectMap["name"] = jnap.Name
	}
	if jnap.Type != nil {
		objectMap["type"] = jnap.Type
	}
	if jnap.Kind != nil {
		objectMap["kind"] = jnap.Kind
	}
	if jnap.Location != nil {
		objectMap["location"] = jnap.Location
	}
	if jnap.JitNetworkAccessPolicyProperties != nil {
		objectMap["properties"] = jnap.JitNetworkAccessPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JitNetworkAccessPolicy struct.
func (jnap *JitNetworkAccessPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				jnap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				jnap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				jnap.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				jnap.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				jnap.Location = &location
			}
		case "properties":
			if v != nil {
				var jitNetworkAccessPolicyProperties JitNetworkAccessPolicyProperties
				err = json.Unmarshal(*v, &jitNetworkAccessPolicyProperties)
				if err != nil {
					return err
				}
				jnap.JitNetworkAccessPolicyProperties = &jitNetworkAccessPolicyProperties
			}
		}
	}

	return nil
}

// JitNetworkAccessPolicyInitiatePort ...
type JitNetworkAccessPolicyInitiatePort struct {
	Number *int32 `json:"number,omitempty"`
	// AllowedSourceAddressPrefix - Source of the allowed traffic. If omitted, the request will be for the source IP address of the initiate request.
	AllowedSourceAddressPrefix *string `json:"allowedSourceAddressPrefix,omitempty"`
	// EndTimeUtc - The time to close the request in UTC
	EndTimeUtc *date.Time `json:"endTimeUtc,omitempty"`
}

// JitNetworkAccessPolicyInitiateRequest ...
type JitNetworkAccessPolicyInitiateRequest struct {
	// VirtualMachines - A list of virtual machines & ports to open access for
	VirtualMachines *[]JitNetworkAccessPolicyInitiateVirtualMachine `json:"virtualMachines,omitempty"`
}

// JitNetworkAccessPolicyInitiateVirtualMachine ...
type JitNetworkAccessPolicyInitiateVirtualMachine struct {
	// ID - Resource ID of the virtual machine that is linked to this policy
	ID *string `json:"id,omitempty"`
	// Ports - The ports to open for the resource with the `id`
	Ports *[]JitNetworkAccessPolicyInitiatePort `json:"ports,omitempty"`
}

// JitNetworkAccessPolicyProperties ...
type JitNetworkAccessPolicyProperties struct {
	// VirtualMachines - Configurations for Microsoft.Compute/virtualMachines resource type.
	VirtualMachines *[]JitNetworkAccessPolicyVirtualMachine `json:"virtualMachines,omitempty"`
	Requests        *[]JitNetworkAccessRequest              `json:"requests,omitempty"`
	// ProvisioningState - Gets the provisioning state of the Just-in-Time policy.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// JitNetworkAccessPolicyVirtualMachine ...
type JitNetworkAccessPolicyVirtualMachine struct {
	// ID - Resource ID of the virtual machine that is linked to this policy
	ID *string `json:"id,omitempty"`
	// Ports - Port configurations for the virtual machine
	Ports *[]JitNetworkAccessPortRule `json:"ports,omitempty"`
}

// JitNetworkAccessPortRule ...
type JitNetworkAccessPortRule struct {
	Number *int32 `json:"number,omitempty"`
	// Protocol - Possible values include: 'TCP', 'UDP', 'All'
	Protocol Protocol `json:"protocol,omitempty"`
	// AllowedSourceAddressPrefix - Mutually exclusive with the "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example "192.168.0.3" or "192.168.0.0/16".
	AllowedSourceAddressPrefix *string `json:"allowedSourceAddressPrefix,omitempty"`
	// AllowedSourceAddressPrefixes - Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
	AllowedSourceAddressPrefixes *[]string `json:"allowedSourceAddressPrefixes,omitempty"`
	// MaxRequestAccessDuration - Maximum duration requests can be made for. In ISO 8601 duration format. Minimum 5 minutes, maximum 1 day
	MaxRequestAccessDuration *string `json:"maxRequestAccessDuration,omitempty"`
}

// JitNetworkAccessRequest ...
type JitNetworkAccessRequest struct {
	autorest.Response `json:"-"`
	VirtualMachines   *[]JitNetworkAccessRequestVirtualMachine `json:"virtualMachines,omitempty"`
	// StartTimeUtc - The start time of the request in UTC
	StartTimeUtc *date.Time `json:"startTimeUtc,omitempty"`
	// Requestor - The identity of the person who made the request
	Requestor *string `json:"requestor,omitempty"`
}

// JitNetworkAccessRequestPort ...
type JitNetworkAccessRequestPort struct {
	Number *int32 `json:"number,omitempty"`
	// AllowedSourceAddressPrefix - Mutually exclusive with the "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example "192.168.0.3" or "192.168.0.0/16".
	AllowedSourceAddressPrefix *string `json:"allowedSourceAddressPrefix,omitempty"`
	// AllowedSourceAddressPrefixes - Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
	AllowedSourceAddressPrefixes *[]string `json:"allowedSourceAddressPrefixes,omitempty"`
	// EndTimeUtc - The date & time at which the request ends in UTC
	EndTimeUtc *date.Time `json:"endTimeUtc,omitempty"`
	// Status - The status of the port. Possible values include: 'Revoked', 'Initiated'
	Status Status `json:"status,omitempty"`
	// StatusReason - A description of why the `status` has its value. Possible values include: 'Expired', 'UserRequested', 'NewerRequestInitiated'
	StatusReason StatusReason `json:"statusReason,omitempty"`
}

// JitNetworkAccessRequestVirtualMachine ...
type JitNetworkAccessRequestVirtualMachine struct {
	// ID - Resource ID of the virtual machine that is linked to this policy
	ID *string `json:"id,omitempty"`
	// Ports - The ports that were opened for the virtual machine
	Ports *[]JitNetworkAccessRequestPort `json:"ports,omitempty"`
}

// Kind describes an Azure resource with kind
type Kind struct {
	// Kind - Kind of the resource
	Kind *string `json:"kind,omitempty"`
}

// Location describes an Azure resource with location
type Location struct {
	// Location - Location where the resource is stored
	Location *string `json:"location,omitempty"`
}

// Operation possible operation in the REST API of Microsoft.Security
type Operation struct {
	// Name - Name of the operation
	Name *string `json:"name,omitempty"`
	// Origin - Where the operation is originated
	Origin  *string           `json:"origin,omitempty"`
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay security operation display
type OperationDisplay struct {
	// Provider - The resource provider for the operation.
	Provider *string `json:"provider,omitempty"`
	// Resource - The display name of the resource the operation applies to.
	Resource *string `json:"resource,omitempty"`
	// Operation - The display name of the security operation.
	Operation *string `json:"operation,omitempty"`
	// Description - The description of the operation.
	Description *string `json:"description,omitempty"`
}

// OperationList list of possible operations for Microsoft.Security resource provider
type OperationList struct {
	autorest.Response `json:"-"`
	// Value - List of Security operations
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListIterator provides access to a complete listing of Operation values.
type OperationListIterator struct {
	i    int
	page OperationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListIterator) Response() OperationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListIterator type.
func NewOperationListIterator(page OperationListPage) OperationListIterator {
	return OperationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ol OperationList) IsEmpty() bool {
	return ol.Value == nil || len(*ol.Value) == 0
}

// operationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ol OperationList) operationListPreparer(ctx context.Context) (*http.Request, error) {
	if ol.NextLink == nil || len(to.String(ol.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ol.NextLink)))
}

// OperationListPage contains a page of Operation values.
type OperationListPage struct {
	fn func(context.Context, OperationList) (OperationList, error)
	ol OperationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ol)
	if err != nil {
		return err
	}
	page.ol = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListPage) NotDone() bool {
	return !page.ol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListPage) Response() OperationList {
	return page.ol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListPage) Values() []Operation {
	if page.ol.IsEmpty() {
		return nil
	}
	return *page.ol.Value
}

// Creates a new instance of the OperationListPage type.
func NewOperationListPage(getNextPage func(context.Context, OperationList) (OperationList, error)) OperationListPage {
	return OperationListPage{fn: getNextPage}
}

// Pricing pricing tier will be applied for the scope based on the resource ID
type Pricing struct {
	autorest.Response `json:"-"`
	// PricingProperties - Pricing data
	*PricingProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Pricing.
func (p Pricing) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.PricingProperties != nil {
		objectMap["properties"] = p.PricingProperties
	}
	if p.ID != nil {
		objectMap["id"] = p.ID
	}
	if p.Name != nil {
		objectMap["name"] = p.Name
	}
	if p.Type != nil {
		objectMap["type"] = p.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Pricing struct.
func (p *Pricing) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var pricingProperties PricingProperties
				err = json.Unmarshal(*v, &pricingProperties)
				if err != nil {
					return err
				}
				p.PricingProperties = &pricingProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				p.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				p.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				p.Type = &typeVar
			}
		}
	}

	return nil
}

// PricingList list of pricing configurations response
type PricingList struct {
	autorest.Response `json:"-"`
	// Value - List of pricing configurations
	Value *[]Pricing `json:"value,omitempty"`
}

// PricingProperties pricing properties for the relevant scope
type PricingProperties struct {
	// PricingTier - The pricing tier value. Possible values include: 'Free', 'Standard'
	PricingTier PricingTier `json:"pricingTier,omitempty"`
	// FreeTrialRemainingTime - The duration left for the subscriptions free trial period - in ISO 8601 format (e.g. P3Y6M4DT12H30M5S).
	FreeTrialRemainingTime *string `json:"freeTrialRemainingTime,omitempty"`
}

// Resource describes an Azure resource.
type Resource struct {
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// SensitivityLabel the sensitivity label.
type SensitivityLabel struct {
	// DisplayName - The name of the sensitivity label.
	DisplayName *string `json:"displayName,omitempty"`
	// Order - The order of the sensitivity label.
	Order *float64 `json:"order,omitempty"`
	// Enabled - Indicates whether the label is enabled or not.
	Enabled *bool `json:"enabled,omitempty"`
}

// Setting represents a security setting in Azure Security Center.
type Setting struct {
	autorest.Response `json:"-"`
	// Kind - the kind of the settings string (DataExportSetting). Possible values include: 'SettingKindDataExportSetting', 'SettingKindAlertSuppressionSetting'
	Kind SettingKind `json:"kind,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// SettingResource the kind of the security setting
type SettingResource struct {
	// Kind - the kind of the settings string (DataExportSetting). Possible values include: 'SettingKindDataExportSetting', 'SettingKindAlertSuppressionSetting'
	Kind SettingKind `json:"kind,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// SettingsList subscription settings list.
type SettingsList struct {
	autorest.Response `json:"-"`
	// Value - The settings list.
	Value *[]Setting `json:"value,omitempty"`
	// NextLink - The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// SettingsListIterator provides access to a complete listing of Setting values.
type SettingsListIterator struct {
	i    int
	page SettingsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SettingsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SettingsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SettingsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SettingsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SettingsListIterator) Response() SettingsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SettingsListIterator) Value() Setting {
	if !iter.page.NotDone() {
		return Setting{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SettingsListIterator type.
func NewSettingsListIterator(page SettingsListPage) SettingsListIterator {
	return SettingsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sl SettingsList) IsEmpty() bool {
	return sl.Value == nil || len(*sl.Value) == 0
}

// settingsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sl SettingsList) settingsListPreparer(ctx context.Context) (*http.Request, error) {
	if sl.NextLink == nil || len(to.String(sl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sl.NextLink)))
}

// SettingsListPage contains a page of Setting values.
type SettingsListPage struct {
	fn func(context.Context, SettingsList) (SettingsList, error)
	sl SettingsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SettingsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SettingsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.sl)
	if err != nil {
		return err
	}
	page.sl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SettingsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SettingsListPage) NotDone() bool {
	return !page.sl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SettingsListPage) Response() SettingsList {
	return page.sl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SettingsListPage) Values() []Setting {
	if page.sl.IsEmpty() {
		return nil
	}
	return *page.sl.Value
}

// Creates a new instance of the SettingsListPage type.
func NewSettingsListPage(getNextPage func(context.Context, SettingsList) (SettingsList, error)) SettingsListPage {
	return SettingsListPage{fn: getNextPage}
}

// Task security task that we recommend to do in order to strengthen security
type Task struct {
	autorest.Response `json:"-"`
	*TaskProperties   `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Task.
func (t Task) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if t.TaskProperties != nil {
		objectMap["properties"] = t.TaskProperties
	}
	if t.ID != nil {
		objectMap["id"] = t.ID
	}
	if t.Name != nil {
		objectMap["name"] = t.Name
	}
	if t.Type != nil {
		objectMap["type"] = t.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Task struct.
func (t *Task) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var taskProperties TaskProperties
				err = json.Unmarshal(*v, &taskProperties)
				if err != nil {
					return err
				}
				t.TaskProperties = &taskProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				t.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				t.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				t.Type = &typeVar
			}
		}
	}

	return nil
}

// TaskList list of security task recommendations
type TaskList struct {
	autorest.Response `json:"-"`
	Value             *[]Task `json:"value,omitempty"`
	// NextLink - The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// TaskListIterator provides access to a complete listing of Task values.
type TaskListIterator struct {
	i    int
	page TaskListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TaskListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TaskListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TaskListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TaskListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TaskListIterator) Response() TaskList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TaskListIterator) Value() Task {
	if !iter.page.NotDone() {
		return Task{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TaskListIterator type.
func NewTaskListIterator(page TaskListPage) TaskListIterator {
	return TaskListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tl TaskList) IsEmpty() bool {
	return tl.Value == nil || len(*tl.Value) == 0
}

// taskListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tl TaskList) taskListPreparer(ctx context.Context) (*http.Request, error) {
	if tl.NextLink == nil || len(to.String(tl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tl.NextLink)))
}

// TaskListPage contains a page of Task values.
type TaskListPage struct {
	fn func(context.Context, TaskList) (TaskList, error)
	tl TaskList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TaskListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TaskListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.tl)
	if err != nil {
		return err
	}
	page.tl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TaskListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TaskListPage) NotDone() bool {
	return !page.tl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TaskListPage) Response() TaskList {
	return page.tl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TaskListPage) Values() []Task {
	if page.tl.IsEmpty() {
		return nil
	}
	return *page.tl.Value
}

// Creates a new instance of the TaskListPage type.
func NewTaskListPage(getNextPage func(context.Context, TaskList) (TaskList, error)) TaskListPage {
	return TaskListPage{fn: getNextPage}
}

// TaskParameters changing set of properties, depending on the task type that is derived from the name
// field
type TaskParameters struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Name - Name of the task type
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for TaskParameters.
func (tp TaskParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tp.Name != nil {
		objectMap["name"] = tp.Name
	}
	for k, v := range tp.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TaskParameters struct.
func (tp *TaskParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if tp.AdditionalProperties == nil {
					tp.AdditionalProperties = make(map[string]interface{})
				}
				tp.AdditionalProperties[k] = additionalProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tp.Name = &name
			}
		}
	}

	return nil
}

// TaskProperties describes properties of a task.
type TaskProperties struct {
	// State - State of the task (Active, Resolved etc.)
	State *string `json:"state,omitempty"`
	// CreationTimeUtc - The time this task was discovered in UTC
	CreationTimeUtc        *date.Time      `json:"creationTimeUtc,omitempty"`
	SecurityTaskParameters *TaskParameters `json:"securityTaskParameters,omitempty"`
	// LastStateChangeTimeUtc - The time this task's details were last changed in UTC
	LastStateChangeTimeUtc *date.Time `json:"lastStateChangeTimeUtc,omitempty"`
	// SubState - Additional data on the state of the task
	SubState *string `json:"subState,omitempty"`
}

// TopologyList ...
type TopologyList struct {
	autorest.Response `json:"-"`
	Value             *[]TopologyResource `json:"value,omitempty"`
	// NextLink - The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// TopologyListIterator provides access to a complete listing of TopologyResource values.
type TopologyListIterator struct {
	i    int
	page TopologyListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TopologyListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TopologyListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TopologyListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TopologyListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TopologyListIterator) Response() TopologyList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TopologyListIterator) Value() TopologyResource {
	if !iter.page.NotDone() {
		return TopologyResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TopologyListIterator type.
func NewTopologyListIterator(page TopologyListPage) TopologyListIterator {
	return TopologyListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tl TopologyList) IsEmpty() bool {
	return tl.Value == nil || len(*tl.Value) == 0
}

// topologyListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tl TopologyList) topologyListPreparer(ctx context.Context) (*http.Request, error) {
	if tl.NextLink == nil || len(to.String(tl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tl.NextLink)))
}

// TopologyListPage contains a page of TopologyResource values.
type TopologyListPage struct {
	fn func(context.Context, TopologyList) (TopologyList, error)
	tl TopologyList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TopologyListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TopologyListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.tl)
	if err != nil {
		return err
	}
	page.tl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TopologyListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TopologyListPage) NotDone() bool {
	return !page.tl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TopologyListPage) Response() TopologyList {
	return page.tl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TopologyListPage) Values() []TopologyResource {
	if page.tl.IsEmpty() {
		return nil
	}
	return *page.tl.Value
}

// Creates a new instance of the TopologyListPage type.
func NewTopologyListPage(getNextPage func(context.Context, TopologyList) (TopologyList, error)) TopologyListPage {
	return TopologyListPage{fn: getNextPage}
}

// TopologyResource ...
type TopologyResource struct {
	autorest.Response `json:"-"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Location where the resource is stored
	Location                    *string `json:"location,omitempty"`
	*TopologyResourceProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for TopologyResource.
func (tr TopologyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.ID != nil {
		objectMap["id"] = tr.ID
	}
	if tr.Name != nil {
		objectMap["name"] = tr.Name
	}
	if tr.Type != nil {
		objectMap["type"] = tr.Type
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	if tr.TopologyResourceProperties != nil {
		objectMap["properties"] = tr.TopologyResourceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TopologyResource struct.
func (tr *TopologyResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				tr.Location = &location
			}
		case "properties":
			if v != nil {
				var topologyResourceProperties TopologyResourceProperties
				err = json.Unmarshal(*v, &topologyResourceProperties)
				if err != nil {
					return err
				}
				tr.TopologyResourceProperties = &topologyResourceProperties
			}
		}
	}

	return nil
}

// TopologyResourceProperties ...
type TopologyResourceProperties struct {
	// CalculatedDateTime - The UTC time on which the topology was calculated
	CalculatedDateTime *date.Time `json:"calculatedDateTime,omitempty"`
	// TopologyResources - Azure resources which are part of this topology resource
	TopologyResources *[]TopologySingleResource `json:"topologyResources,omitempty"`
}

// TopologySingleResource ...
type TopologySingleResource struct {
	// ResourceID - Azure resource id
	ResourceID *string `json:"resourceId,omitempty"`
	// Severity - The security severity of the resource
	Severity *string `json:"severity,omitempty"`
	// RecommendationsExist - Indicates if the resource has security recommendations
	RecommendationsExist *bool `json:"recommendationsExist,omitempty"`
	// NetworkZones - Indicates the resource connectivity level to the Internet (InternetFacing, Internal ,etc.)
	NetworkZones *string `json:"networkZones,omitempty"`
	// TopologyScore - Score of the resource based on its security severity
	TopologyScore *int32 `json:"topologyScore,omitempty"`
	// Location - The location of this resource
	Location *string `json:"location,omitempty"`
	// Parents - Azure resources connected to this resource which are in higher level in the topology view
	Parents *[]TopologySingleResourceParent `json:"parents,omitempty"`
	// Children - Azure resources connected to this resource which are in lower level in the topology view
	Children *[]TopologySingleResourceChild `json:"children,omitempty"`
}

// TopologySingleResourceChild ...
type TopologySingleResourceChild struct {
	// ResourceID - Azure resource id which serves as child resource in topology view
	ResourceID *string `json:"resourceId,omitempty"`
}

// TopologySingleResourceParent ...
type TopologySingleResourceParent struct {
	// ResourceID - Azure resource id which serves as parent resource in topology view
	ResourceID *string `json:"resourceId,omitempty"`
}

// WorkspaceSetting configures where to store the OMS agent data for workspaces under a scope
type WorkspaceSetting struct {
	autorest.Response `json:"-"`
	// WorkspaceSettingProperties - Workspace setting data
	*WorkspaceSettingProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkspaceSetting.
func (ws WorkspaceSetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ws.WorkspaceSettingProperties != nil {
		objectMap["properties"] = ws.WorkspaceSettingProperties
	}
	if ws.ID != nil {
		objectMap["id"] = ws.ID
	}
	if ws.Name != nil {
		objectMap["name"] = ws.Name
	}
	if ws.Type != nil {
		objectMap["type"] = ws.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkspaceSetting struct.
func (ws *WorkspaceSetting) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workspaceSettingProperties WorkspaceSettingProperties
				err = json.Unmarshal(*v, &workspaceSettingProperties)
				if err != nil {
					return err
				}
				ws.WorkspaceSettingProperties = &workspaceSettingProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ws.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ws.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ws.Type = &typeVar
			}
		}
	}

	return nil
}

// WorkspaceSettingList list of workspace settings response
type WorkspaceSettingList struct {
	autorest.Response `json:"-"`
	// Value - List of workspace settings
	Value *[]WorkspaceSetting `json:"value,omitempty"`
	// NextLink - The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// WorkspaceSettingListIterator provides access to a complete listing of WorkspaceSetting values.
type WorkspaceSettingListIterator struct {
	i    int
	page WorkspaceSettingListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkspaceSettingListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkspaceSettingListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkspaceSettingListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkspaceSettingListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkspaceSettingListIterator) Response() WorkspaceSettingList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkspaceSettingListIterator) Value() WorkspaceSetting {
	if !iter.page.NotDone() {
		return WorkspaceSetting{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkspaceSettingListIterator type.
func NewWorkspaceSettingListIterator(page WorkspaceSettingListPage) WorkspaceSettingListIterator {
	return WorkspaceSettingListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wsl WorkspaceSettingList) IsEmpty() bool {
	return wsl.Value == nil || len(*wsl.Value) == 0
}

// workspaceSettingListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wsl WorkspaceSettingList) workspaceSettingListPreparer(ctx context.Context) (*http.Request, error) {
	if wsl.NextLink == nil || len(to.String(wsl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wsl.NextLink)))
}

// WorkspaceSettingListPage contains a page of WorkspaceSetting values.
type WorkspaceSettingListPage struct {
	fn  func(context.Context, WorkspaceSettingList) (WorkspaceSettingList, error)
	wsl WorkspaceSettingList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkspaceSettingListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkspaceSettingListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.wsl)
	if err != nil {
		return err
	}
	page.wsl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkspaceSettingListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkspaceSettingListPage) NotDone() bool {
	return !page.wsl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkspaceSettingListPage) Response() WorkspaceSettingList {
	return page.wsl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkspaceSettingListPage) Values() []WorkspaceSetting {
	if page.wsl.IsEmpty() {
		return nil
	}
	return *page.wsl.Value
}

// Creates a new instance of the WorkspaceSettingListPage type.
func NewWorkspaceSettingListPage(getNextPage func(context.Context, WorkspaceSettingList) (WorkspaceSettingList, error)) WorkspaceSettingListPage {
	return WorkspaceSettingListPage{fn: getNextPage}
}

// WorkspaceSettingProperties workspace setting data
type WorkspaceSettingProperties struct {
	// WorkspaceID - The full Azure ID of the workspace to save the data in
	WorkspaceID *string `json:"workspaceId,omitempty"`
	// Scope - All the VMs in this scope will send their security data to the mentioned workspace unless overridden by a setting with more specific scope
	Scope *string `json:"scope,omitempty"`
}
