package servicefabric

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/satori/go.uuid"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/servicefabric/6.3/servicefabric"

// ApplicationDefinitionKind enumerates the values for application definition kind.
type ApplicationDefinitionKind string

const (
	// Compose Indicates the application is defined by compose file(s). The value is 1.
	Compose ApplicationDefinitionKind = "Compose"
	// Invalid Indicates the application definition kind is invalid. All Service Fabric enumerations have the
	// invalid type. The value is 65535.
	Invalid ApplicationDefinitionKind = "Invalid"
	// ServiceFabricApplicationDescription Indicates the application is defined by a Service Fabric application
	// description. The value is 0.
	ServiceFabricApplicationDescription ApplicationDefinitionKind = "ServiceFabricApplicationDescription"
)

// PossibleApplicationDefinitionKindValues returns an array of possible values for the ApplicationDefinitionKind const type.
func PossibleApplicationDefinitionKindValues() []ApplicationDefinitionKind {
	return []ApplicationDefinitionKind{Compose, Invalid, ServiceFabricApplicationDescription}
}

// ApplicationPackageCleanupPolicy enumerates the values for application package cleanup policy.
type ApplicationPackageCleanupPolicy string

const (
	// ApplicationPackageCleanupPolicyAutomatic Indicates that the service fabric runtime determines when to do
	// the application package cleanup. By default, cleanup is done on successful provision. The value is 2.
	ApplicationPackageCleanupPolicyAutomatic ApplicationPackageCleanupPolicy = "Automatic"
	// ApplicationPackageCleanupPolicyDefault Indicates that the cleanup policy of application packages is
	// based on the cluster setting "CleanupApplicationPackageOnProvisionSuccess." The value is 1.
	ApplicationPackageCleanupPolicyDefault ApplicationPackageCleanupPolicy = "Default"
	// ApplicationPackageCleanupPolicyInvalid Indicates that the application package cleanup policy is invalid.
	// This value is default. The value is zero.
	ApplicationPackageCleanupPolicyInvalid ApplicationPackageCleanupPolicy = "Invalid"
	// ApplicationPackageCleanupPolicyManual Indicates that the user has to explicitly clean up the application
	// package. The value is 3.
	ApplicationPackageCleanupPolicyManual ApplicationPackageCleanupPolicy = "Manual"
)

// PossibleApplicationPackageCleanupPolicyValues returns an array of possible values for the ApplicationPackageCleanupPolicy const type.
func PossibleApplicationPackageCleanupPolicyValues() []ApplicationPackageCleanupPolicy {
	return []ApplicationPackageCleanupPolicy{ApplicationPackageCleanupPolicyAutomatic, ApplicationPackageCleanupPolicyDefault, ApplicationPackageCleanupPolicyInvalid, ApplicationPackageCleanupPolicyManual}
}

// ApplicationResourceStatus enumerates the values for application resource status.
type ApplicationResourceStatus string

const (
	// ApplicationResourceStatusCreating ...
	ApplicationResourceStatusCreating ApplicationResourceStatus = "Creating"
	// ApplicationResourceStatusDeleting ...
	ApplicationResourceStatusDeleting ApplicationResourceStatus = "Deleting"
	// ApplicationResourceStatusFailed ...
	ApplicationResourceStatusFailed ApplicationResourceStatus = "Failed"
	// ApplicationResourceStatusInvalid ...
	ApplicationResourceStatusInvalid ApplicationResourceStatus = "Invalid"
	// ApplicationResourceStatusReady ...
	ApplicationResourceStatusReady ApplicationResourceStatus = "Ready"
	// ApplicationResourceStatusUpgrading ...
	ApplicationResourceStatusUpgrading ApplicationResourceStatus = "Upgrading"
)

// PossibleApplicationResourceStatusValues returns an array of possible values for the ApplicationResourceStatus const type.
func PossibleApplicationResourceStatusValues() []ApplicationResourceStatus {
	return []ApplicationResourceStatus{ApplicationResourceStatusCreating, ApplicationResourceStatusDeleting, ApplicationResourceStatusFailed, ApplicationResourceStatusInvalid, ApplicationResourceStatusReady, ApplicationResourceStatusUpgrading}
}

// ApplicationStatus enumerates the values for application status.
type ApplicationStatus string

const (
	// ApplicationStatusCreating Indicates the application status is creating. The value is 3.
	ApplicationStatusCreating ApplicationStatus = "Creating"
	// ApplicationStatusDeleting Indicates the application status is deleting. The value is 4.
	ApplicationStatusDeleting ApplicationStatus = "Deleting"
	// ApplicationStatusFailed Indicates the creation or deletion of application was terminated due to
	// persistent failures. Another create/delete request can be accepted to resume a failed application. The
	// value is 5.
	ApplicationStatusFailed ApplicationStatus = "Failed"
	// ApplicationStatusInvalid Indicates the application status is invalid. All Service Fabric enumerations
	// have the invalid type. The value is zero.
	ApplicationStatusInvalid ApplicationStatus = "Invalid"
	// ApplicationStatusReady Indicates the application status is ready. The value is 1.
	ApplicationStatusReady ApplicationStatus = "Ready"
	// ApplicationStatusUpgrading Indicates the application status is upgrading. The value is 2.
	ApplicationStatusUpgrading ApplicationStatus = "Upgrading"
)

// PossibleApplicationStatusValues returns an array of possible values for the ApplicationStatus const type.
func PossibleApplicationStatusValues() []ApplicationStatus {
	return []ApplicationStatus{ApplicationStatusCreating, ApplicationStatusDeleting, ApplicationStatusFailed, ApplicationStatusInvalid, ApplicationStatusReady, ApplicationStatusUpgrading}
}

// ApplicationTypeDefinitionKind enumerates the values for application type definition kind.
type ApplicationTypeDefinitionKind string

const (
	// ApplicationTypeDefinitionKindCompose Indicates the application type is defined and created implicitly as
	// part of a compose deployment. The value is 2.
	ApplicationTypeDefinitionKindCompose ApplicationTypeDefinitionKind = "Compose"
	// ApplicationTypeDefinitionKindInvalid Indicates the application type definition kind is invalid. All
	// Service Fabric enumerations have the invalid type. The value is 0.
	ApplicationTypeDefinitionKindInvalid ApplicationTypeDefinitionKind = "Invalid"
	// ApplicationTypeDefinitionKindServiceFabricApplicationPackage Indicates the application type is defined
	// and created by a Service Fabric application package provided by the user. The value is 1.
	ApplicationTypeDefinitionKindServiceFabricApplicationPackage ApplicationTypeDefinitionKind = "ServiceFabricApplicationPackage"
)

// PossibleApplicationTypeDefinitionKindValues returns an array of possible values for the ApplicationTypeDefinitionKind const type.
func PossibleApplicationTypeDefinitionKindValues() []ApplicationTypeDefinitionKind {
	return []ApplicationTypeDefinitionKind{ApplicationTypeDefinitionKindCompose, ApplicationTypeDefinitionKindInvalid, ApplicationTypeDefinitionKindServiceFabricApplicationPackage}
}

// ApplicationTypeStatus enumerates the values for application type status.
type ApplicationTypeStatus string

const (
	// ApplicationTypeStatusAvailable Indicates that the application type is fully provisioned and is available
	// for use. An application of this type and version can be created. The value is 2.
	ApplicationTypeStatusAvailable ApplicationTypeStatus = "Available"
	// ApplicationTypeStatusFailed Indicates that the application type provisioning failed and it is
	// unavailable for use. The failure details can be obtained from the application type information query.
	// The failed application type information remains in the cluster until it is unprovisioned or
	// reprovisioned successfully. The value is 4.
	ApplicationTypeStatusFailed ApplicationTypeStatus = "Failed"
	// ApplicationTypeStatusInvalid Indicates the application type status is invalid. All Service Fabric
	// enumerations have the invalid type. The value is zero.
	ApplicationTypeStatusInvalid ApplicationTypeStatus = "Invalid"
	// ApplicationTypeStatusProvisioning Indicates that the application type is being provisioned in the
	// cluster. The value is 1.
	ApplicationTypeStatusProvisioning ApplicationTypeStatus = "Provisioning"
	// ApplicationTypeStatusUnprovisioning Indicates that the application type is in process of being
	// unprovisioned from the cluster. The value is 3.
	ApplicationTypeStatusUnprovisioning ApplicationTypeStatus = "Unprovisioning"
)

// PossibleApplicationTypeStatusValues returns an array of possible values for the ApplicationTypeStatus const type.
func PossibleApplicationTypeStatusValues() []ApplicationTypeStatus {
	return []ApplicationTypeStatus{ApplicationTypeStatusAvailable, ApplicationTypeStatusFailed, ApplicationTypeStatusInvalid, ApplicationTypeStatusProvisioning, ApplicationTypeStatusUnprovisioning}
}

// BackupEntityKind enumerates the values for backup entity kind.
type BackupEntityKind string

const (
	// BackupEntityKindApplication Indicates the entity is a Service Fabric application.
	BackupEntityKindApplication BackupEntityKind = "Application"
	// BackupEntityKindInvalid Indicates an invalid entity kind. All Service Fabric enumerations have the
	// invalid type.
	BackupEntityKindInvalid BackupEntityKind = "Invalid"
	// BackupEntityKindPartition Indicates the entity is a Service Fabric partition.
	BackupEntityKindPartition BackupEntityKind = "Partition"
	// BackupEntityKindService Indicates the entity is a Service Fabric service.
	BackupEntityKindService BackupEntityKind = "Service"
)

// PossibleBackupEntityKindValues returns an array of possible values for the BackupEntityKind const type.
func PossibleBackupEntityKindValues() []BackupEntityKind {
	return []BackupEntityKind{BackupEntityKindApplication, BackupEntityKindInvalid, BackupEntityKindPartition, BackupEntityKindService}
}

// BackupPolicyScope enumerates the values for backup policy scope.
type BackupPolicyScope string

const (
	// BackupPolicyScopeApplication Indicates the backup policy is applied at application level. All services
	// and partitions of the application inherit this policy unless explicitly overridden at service or
	// partition level.
	BackupPolicyScopeApplication BackupPolicyScope = "Application"
	// BackupPolicyScopeInvalid Indicates an invalid backup policy scope type. All Service Fabric enumerations
	// have the invalid type.
	BackupPolicyScopeInvalid BackupPolicyScope = "Invalid"
	// BackupPolicyScopePartition Indicates the backup policy is applied at partition level. Hence overriding
	// any policy which may have applied at partition's service or application level.
	BackupPolicyScopePartition BackupPolicyScope = "Partition"
	// BackupPolicyScopeService Indicates the backup policy is applied at service level. All partitions of the
	// service inherit this policy unless explicitly overridden at partition level.
	BackupPolicyScopeService BackupPolicyScope = "Service"
)

// PossibleBackupPolicyScopeValues returns an array of possible values for the BackupPolicyScope const type.
func PossibleBackupPolicyScopeValues() []BackupPolicyScope {
	return []BackupPolicyScope{BackupPolicyScopeApplication, BackupPolicyScopeInvalid, BackupPolicyScopePartition, BackupPolicyScopeService}
}

// BackupScheduleFrequencyType enumerates the values for backup schedule frequency type.
type BackupScheduleFrequencyType string

const (
	// BackupScheduleFrequencyTypeDaily Indicates that the time based backup schedule is repeated at a daily
	// frequency.
	BackupScheduleFrequencyTypeDaily BackupScheduleFrequencyType = "Daily"
	// BackupScheduleFrequencyTypeInvalid Indicates an invalid backup schedule frequency type. All Service
	// Fabric enumerations have the invalid type.
	BackupScheduleFrequencyTypeInvalid BackupScheduleFrequencyType = "Invalid"
	// BackupScheduleFrequencyTypeWeekly Indicates that the time based backup schedule is repeated at a weekly
	// frequency.
	BackupScheduleFrequencyTypeWeekly BackupScheduleFrequencyType = "Weekly"
)

// PossibleBackupScheduleFrequencyTypeValues returns an array of possible values for the BackupScheduleFrequencyType const type.
func PossibleBackupScheduleFrequencyTypeValues() []BackupScheduleFrequencyType {
	return []BackupScheduleFrequencyType{BackupScheduleFrequencyTypeDaily, BackupScheduleFrequencyTypeInvalid, BackupScheduleFrequencyTypeWeekly}
}

// BackupScheduleKind enumerates the values for backup schedule kind.
type BackupScheduleKind string

const (
	// BackupScheduleKindFrequencyBased Indicates a frequency-based backup schedule.
	BackupScheduleKindFrequencyBased BackupScheduleKind = "FrequencyBased"
	// BackupScheduleKindInvalid Indicates an invalid backup schedule kind. All Service Fabric enumerations
	// have the invalid type.
	BackupScheduleKindInvalid BackupScheduleKind = "Invalid"
	// BackupScheduleKindTimeBased Indicates a time-based backup schedule.
	BackupScheduleKindTimeBased BackupScheduleKind = "TimeBased"
)

// PossibleBackupScheduleKindValues returns an array of possible values for the BackupScheduleKind const type.
func PossibleBackupScheduleKindValues() []BackupScheduleKind {
	return []BackupScheduleKind{BackupScheduleKindFrequencyBased, BackupScheduleKindInvalid, BackupScheduleKindTimeBased}
}

// BackupState enumerates the values for backup state.
type BackupState string

const (
	// BackupStateAccepted Operation has been validated and accepted. Backup is yet to be triggered.
	BackupStateAccepted BackupState = "Accepted"
	// BackupStateBackupInProgress Backup operation has been triggered and is under process.
	BackupStateBackupInProgress BackupState = "BackupInProgress"
	// BackupStateFailure Operation completed with failure.
	BackupStateFailure BackupState = "Failure"
	// BackupStateInvalid Indicates an invalid backup state. All Service Fabric enumerations have the invalid
	// type.
	BackupStateInvalid BackupState = "Invalid"
	// BackupStateSuccess Operation completed with success.
	BackupStateSuccess BackupState = "Success"
	// BackupStateTimeout Operation timed out.
	BackupStateTimeout BackupState = "Timeout"
)

// PossibleBackupStateValues returns an array of possible values for the BackupState const type.
func PossibleBackupStateValues() []BackupState {
	return []BackupState{BackupStateAccepted, BackupStateBackupInProgress, BackupStateFailure, BackupStateInvalid, BackupStateSuccess, BackupStateTimeout}
}

// BackupStorageKind enumerates the values for backup storage kind.
type BackupStorageKind string

const (
	// BackupStorageKindAzureBlobStore Indicates Azure blob store to be used as backup storage.
	BackupStorageKindAzureBlobStore BackupStorageKind = "AzureBlobStore"
	// BackupStorageKindFileShare Indicates file/ SMB share to be used as backup storage.
	BackupStorageKindFileShare BackupStorageKind = "FileShare"
	// BackupStorageKindInvalid Indicates an invalid backup storage kind. All Service Fabric enumerations have
	// the invalid type.
	BackupStorageKindInvalid BackupStorageKind = "Invalid"
)

// PossibleBackupStorageKindValues returns an array of possible values for the BackupStorageKind const type.
func PossibleBackupStorageKindValues() []BackupStorageKind {
	return []BackupStorageKind{BackupStorageKindAzureBlobStore, BackupStorageKindFileShare, BackupStorageKindInvalid}
}

// BackupSuspensionScope enumerates the values for backup suspension scope.
type BackupSuspensionScope string

const (
	// BackupSuspensionScopeApplication Indicates the backup suspension is applied at application level. All
	// services and partitions of the application are hence suspended for backup.
	BackupSuspensionScopeApplication BackupSuspensionScope = "Application"
	// BackupSuspensionScopeInvalid Indicates an invalid backup suspension scope type also indicating entity is
	// not suspended. All Service Fabric enumerations have the invalid type.
	BackupSuspensionScopeInvalid BackupSuspensionScope = "Invalid"
	// BackupSuspensionScopePartition Indicates the backup suspension is applied at partition level.
	BackupSuspensionScopePartition BackupSuspensionScope = "Partition"
	// BackupSuspensionScopeService Indicates the backup suspension is applied at service level. All partitions
	// of the service are hence suspended for backup.
	BackupSuspensionScopeService BackupSuspensionScope = "Service"
)

// PossibleBackupSuspensionScopeValues returns an array of possible values for the BackupSuspensionScope const type.
func PossibleBackupSuspensionScopeValues() []BackupSuspensionScope {
	return []BackupSuspensionScope{BackupSuspensionScopeApplication, BackupSuspensionScopeInvalid, BackupSuspensionScopePartition, BackupSuspensionScopeService}
}

// BackupType enumerates the values for backup type.
type BackupType string

const (
	// BackupTypeFull Indicates a full backup.
	BackupTypeFull BackupType = "Full"
	// BackupTypeIncremental Indicates an incremental backup. A backup chain is comprised of a full backup
	// followed by 0 or more incremental backups.
	BackupTypeIncremental BackupType = "Incremental"
	// BackupTypeInvalid Indicates an invalid backup type. All Service Fabric enumerations have the invalid
	// type.
	BackupTypeInvalid BackupType = "Invalid"
)

// PossibleBackupTypeValues returns an array of possible values for the BackupType const type.
func PossibleBackupTypeValues() []BackupType {
	return []BackupType{BackupTypeFull, BackupTypeIncremental, BackupTypeInvalid}
}

// ChaosEventKind enumerates the values for chaos event kind.
type ChaosEventKind string

const (
	// ChaosEventKindExecutingFaults Indicates a Chaos event that gets generated when Chaos has decided on the
	// faults for an iteration. This Chaos event contains the details of the faults as a list of strings.
	ChaosEventKindExecutingFaults ChaosEventKind = "ExecutingFaults"
	// ChaosEventKindInvalid Indicates an invalid Chaos event kind. All Service Fabric enumerations have the
	// invalid type.
	ChaosEventKindInvalid ChaosEventKind = "Invalid"
	// ChaosEventKindStarted Indicates a Chaos event that gets generated when Chaos is started.
	ChaosEventKindStarted ChaosEventKind = "Started"
	// ChaosEventKindStopped Indicates a Chaos event that gets generated when Chaos stops because either the
	// user issued a stop or the time to run was up.
	ChaosEventKindStopped ChaosEventKind = "Stopped"
	// ChaosEventKindTestError Indicates a Chaos event that gets generated when an unexpected event has
	// occurred in the Chaos engine, for example, due to the cluster snapshot being inconsistent, while
	// faulting a faultable entity Chaos found that the entity was already faulted.
	ChaosEventKindTestError ChaosEventKind = "TestError"
	// ChaosEventKindValidationFailed Indicates a Chaos event that gets generated when the cluster entities do
	// not become stable and healthy within ChaosParameters.MaxClusterStabilizationTimeoutInSeconds.
	ChaosEventKindValidationFailed ChaosEventKind = "ValidationFailed"
	// ChaosEventKindWaiting Indicates a Chaos event that gets generated when Chaos is waiting for the cluster
	// to become ready for faulting, for example, Chaos may be waiting for the on-going upgrade to finish.
	ChaosEventKindWaiting ChaosEventKind = "Waiting"
)

// PossibleChaosEventKindValues returns an array of possible values for the ChaosEventKind const type.
func PossibleChaosEventKindValues() []ChaosEventKind {
	return []ChaosEventKind{ChaosEventKindExecutingFaults, ChaosEventKindInvalid, ChaosEventKindStarted, ChaosEventKindStopped, ChaosEventKindTestError, ChaosEventKindValidationFailed, ChaosEventKindWaiting}
}

// ChaosScheduleStatus enumerates the values for chaos schedule status.
type ChaosScheduleStatus string

const (
	// ChaosScheduleStatusActive Indicates that the schedule is active and is being used to schedule runs of
	// Chaos. The value is two.
	ChaosScheduleStatusActive ChaosScheduleStatus = "Active"
	// ChaosScheduleStatusExpired Indicates that the schedule is expired and will no longer be used to schedule
	// runs of Chaos. The value is three.
	ChaosScheduleStatusExpired ChaosScheduleStatus = "Expired"
	// ChaosScheduleStatusInvalid Indicates an invalid Chaos Schedule status. All Service Fabric enumerations
	// have the invalid type. The value is zero.
	ChaosScheduleStatusInvalid ChaosScheduleStatus = "Invalid"
	// ChaosScheduleStatusPending Indicates that the schedule is pending and is not yet being used to schedule
	// runs of Chaos but will be used when the start time is passed. The value is four.
	ChaosScheduleStatusPending ChaosScheduleStatus = "Pending"
	// ChaosScheduleStatusStopped Indicates that the schedule is stopped and not being used to schedule runs of
	// chaos. The value is one.
	ChaosScheduleStatusStopped ChaosScheduleStatus = "Stopped"
)

// PossibleChaosScheduleStatusValues returns an array of possible values for the ChaosScheduleStatus const type.
func PossibleChaosScheduleStatusValues() []ChaosScheduleStatus {
	return []ChaosScheduleStatus{ChaosScheduleStatusActive, ChaosScheduleStatusExpired, ChaosScheduleStatusInvalid, ChaosScheduleStatusPending, ChaosScheduleStatusStopped}
}

// ChaosStatus enumerates the values for chaos status.
type ChaosStatus string

const (
	// ChaosStatusInvalid Indicates an invalid Chaos status. All Service Fabric enumerations have the invalid
	// type. The value is zero.
	ChaosStatusInvalid ChaosStatus = "Invalid"
	// ChaosStatusRunning Indicates that Chaos is not stopped. The value is one.
	ChaosStatusRunning ChaosStatus = "Running"
	// ChaosStatusStopped Indicates that Chaos is not scheduling further faults. The value is two.
	ChaosStatusStopped ChaosStatus = "Stopped"
)

// PossibleChaosStatusValues returns an array of possible values for the ChaosStatus const type.
func PossibleChaosStatusValues() []ChaosStatus {
	return []ChaosStatus{ChaosStatusInvalid, ChaosStatusRunning, ChaosStatusStopped}
}

// ComposeDeploymentStatus enumerates the values for compose deployment status.
type ComposeDeploymentStatus string

const (
	// ComposeDeploymentStatusCreating Indicates that the compose deployment is being created in background.
	// The value is 2.
	ComposeDeploymentStatusCreating ComposeDeploymentStatus = "Creating"
	// ComposeDeploymentStatusDeleting Indicates that the compose deployment is being deleted in background.
	// The value is 5.
	ComposeDeploymentStatusDeleting ComposeDeploymentStatus = "Deleting"
	// ComposeDeploymentStatusFailed Indicates that the compose deployment was terminated due to persistent
	// failures. The value is 6.
	ComposeDeploymentStatusFailed ComposeDeploymentStatus = "Failed"
	// ComposeDeploymentStatusInvalid Indicates that the compose deployment status is invalid. The value is
	// zero.
	ComposeDeploymentStatusInvalid ComposeDeploymentStatus = "Invalid"
	// ComposeDeploymentStatusProvisioning Indicates that the compose deployment is being provisioned in
	// background. The value is 1.
	ComposeDeploymentStatusProvisioning ComposeDeploymentStatus = "Provisioning"
	// ComposeDeploymentStatusReady Indicates that the compose deployment has been successfully created or
	// upgraded. The value is 3.
	ComposeDeploymentStatusReady ComposeDeploymentStatus = "Ready"
	// ComposeDeploymentStatusUnprovisioning Indicates that the compose deployment is being unprovisioned in
	// background. The value is 4.
	ComposeDeploymentStatusUnprovisioning ComposeDeploymentStatus = "Unprovisioning"
	// ComposeDeploymentStatusUpgrading Indicates that the compose deployment is being upgraded in the
	// background. The value is 7.
	ComposeDeploymentStatusUpgrading ComposeDeploymentStatus = "Upgrading"
)

// PossibleComposeDeploymentStatusValues returns an array of possible values for the ComposeDeploymentStatus const type.
func PossibleComposeDeploymentStatusValues() []ComposeDeploymentStatus {
	return []ComposeDeploymentStatus{ComposeDeploymentStatusCreating, ComposeDeploymentStatusDeleting, ComposeDeploymentStatusFailed, ComposeDeploymentStatusInvalid, ComposeDeploymentStatusProvisioning, ComposeDeploymentStatusReady, ComposeDeploymentStatusUnprovisioning, ComposeDeploymentStatusUpgrading}
}

// ComposeDeploymentUpgradeState enumerates the values for compose deployment upgrade state.
type ComposeDeploymentUpgradeState string

const (
	// ComposeDeploymentUpgradeStateFailed The upgrade has failed and is unable to execute FailureAction. The
	// value is 9.
	ComposeDeploymentUpgradeStateFailed ComposeDeploymentUpgradeState = "Failed"
	// ComposeDeploymentUpgradeStateInvalid Indicates the upgrade state is invalid. All Service Fabric
	// enumerations have the invalid type. The value is zero.
	ComposeDeploymentUpgradeStateInvalid ComposeDeploymentUpgradeState = "Invalid"
	// ComposeDeploymentUpgradeStateProvisioningTarget The upgrade is in the progress of provisioning target
	// application type version. The value is 1.
	ComposeDeploymentUpgradeStateProvisioningTarget ComposeDeploymentUpgradeState = "ProvisioningTarget"
	// ComposeDeploymentUpgradeStateRollingBackCompleted The upgrade has finished rolling back. The value is 8.
	ComposeDeploymentUpgradeStateRollingBackCompleted ComposeDeploymentUpgradeState = "RollingBackCompleted"
	// ComposeDeploymentUpgradeStateRollingBackInProgress The upgrade is rolling back to the previous version
	// but is not complete yet. The value is 6.
	ComposeDeploymentUpgradeStateRollingBackInProgress ComposeDeploymentUpgradeState = "RollingBackInProgress"
	// ComposeDeploymentUpgradeStateRollingForwardCompleted The upgrade has finished rolling forward. The value
	// is 5.
	ComposeDeploymentUpgradeStateRollingForwardCompleted ComposeDeploymentUpgradeState = "RollingForwardCompleted"
	// ComposeDeploymentUpgradeStateRollingForwardInProgress The upgrade is rolling forward to the target
	// version but is not complete yet. The value is 2.
	ComposeDeploymentUpgradeStateRollingForwardInProgress ComposeDeploymentUpgradeState = "RollingForwardInProgress"
	// ComposeDeploymentUpgradeStateRollingForwardPending The current upgrade domain has finished upgrading.
	// The overall upgrade is waiting for an explicit move next request in UnmonitoredManual mode or performing
	// health checks in Monitored mode. The value is 3
	ComposeDeploymentUpgradeStateRollingForwardPending ComposeDeploymentUpgradeState = "RollingForwardPending"
	// ComposeDeploymentUpgradeStateUnprovisioningCurrent The upgrade is in the progress of unprovisioning
	// current application type version and rolling forward to the target version is completed. The value is 4.
	ComposeDeploymentUpgradeStateUnprovisioningCurrent ComposeDeploymentUpgradeState = "UnprovisioningCurrent"
	// ComposeDeploymentUpgradeStateUnprovisioningTarget The upgrade is in the progress of unprovisioning
	// target application type version and rolling back to the current version is completed. The value is 7.
	ComposeDeploymentUpgradeStateUnprovisioningTarget ComposeDeploymentUpgradeState = "UnprovisioningTarget"
)

// PossibleComposeDeploymentUpgradeStateValues returns an array of possible values for the ComposeDeploymentUpgradeState const type.
func PossibleComposeDeploymentUpgradeStateValues() []ComposeDeploymentUpgradeState {
	return []ComposeDeploymentUpgradeState{ComposeDeploymentUpgradeStateFailed, ComposeDeploymentUpgradeStateInvalid, ComposeDeploymentUpgradeStateProvisioningTarget, ComposeDeploymentUpgradeStateRollingBackCompleted, ComposeDeploymentUpgradeStateRollingBackInProgress, ComposeDeploymentUpgradeStateRollingForwardCompleted, ComposeDeploymentUpgradeStateRollingForwardInProgress, ComposeDeploymentUpgradeStateRollingForwardPending, ComposeDeploymentUpgradeStateUnprovisioningCurrent, ComposeDeploymentUpgradeStateUnprovisioningTarget}
}

// CreateFabricDump enumerates the values for create fabric dump.
type CreateFabricDump string

const (
	// False ...
	False CreateFabricDump = "False"
	// True ...
	True CreateFabricDump = "True"
)

// PossibleCreateFabricDumpValues returns an array of possible values for the CreateFabricDump const type.
func PossibleCreateFabricDumpValues() []CreateFabricDump {
	return []CreateFabricDump{False, True}
}

// DataLossMode enumerates the values for data loss mode.
type DataLossMode string

const (
	// DataLossModeFullDataLoss FullDataLoss option will drop all the replicas which means that all the data
	// will be lost.
	DataLossModeFullDataLoss DataLossMode = "FullDataLoss"
	// DataLossModeInvalid Reserved.  Do not pass into API.
	DataLossModeInvalid DataLossMode = "Invalid"
	// DataLossModePartialDataLoss PartialDataLoss option will cause a quorum of replicas to go down,
	// triggering an OnDataLoss event in the system for the given partition.
	DataLossModePartialDataLoss DataLossMode = "PartialDataLoss"
)

// PossibleDataLossModeValues returns an array of possible values for the DataLossMode const type.
func PossibleDataLossModeValues() []DataLossMode {
	return []DataLossMode{DataLossModeFullDataLoss, DataLossModeInvalid, DataLossModePartialDataLoss}
}

// DayOfWeek enumerates the values for day of week.
type DayOfWeek string

const (
	// Friday Indicates the Day referred is Friday.
	Friday DayOfWeek = "Friday"
	// Monday Indicates the Day referred is Monday.
	Monday DayOfWeek = "Monday"
	// Saturday Indicates the Day referred is Saturday.
	Saturday DayOfWeek = "Saturday"
	// Sunday Indicates the Day referred is Sunday.
	Sunday DayOfWeek = "Sunday"
	// Thursday Indicates the Day referred is Thursday.
	Thursday DayOfWeek = "Thursday"
	// Tuesday Indicates the Day referred is Tuesday.
	Tuesday DayOfWeek = "Tuesday"
	// Wednesday Indicates the Day referred is Wednesday.
	Wednesday DayOfWeek = "Wednesday"
)

// PossibleDayOfWeekValues returns an array of possible values for the DayOfWeek const type.
func PossibleDayOfWeekValues() []DayOfWeek {
	return []DayOfWeek{Friday, Monday, Saturday, Sunday, Thursday, Tuesday, Wednesday}
}

// DeactivationIntent enumerates the values for deactivation intent.
type DeactivationIntent string

const (
	// Pause Indicates that the node should be paused. The value is 1.
	Pause DeactivationIntent = "Pause"
	// RemoveData Indicates the intent is for the node to remove data. The value is 3.
	RemoveData DeactivationIntent = "RemoveData"
	// Restart Indicates that the intent is for the node to be restarted after a short period of time. The
	// value is 2.
	Restart DeactivationIntent = "Restart"
)

// PossibleDeactivationIntentValues returns an array of possible values for the DeactivationIntent const type.
func PossibleDeactivationIntentValues() []DeactivationIntent {
	return []DeactivationIntent{Pause, RemoveData, Restart}
}

// DeployedApplicationStatus enumerates the values for deployed application status.
type DeployedApplicationStatus string

const (
	// DeployedApplicationStatusActivating Indicates that the package is activating. The value is 2.
	DeployedApplicationStatusActivating DeployedApplicationStatus = "Activating"
	// DeployedApplicationStatusActive Indicates that the package is active. The value is 3.
	DeployedApplicationStatusActive DeployedApplicationStatus = "Active"
	// DeployedApplicationStatusDeactivating Indicates that the package is deactivating. The value is 5.
	DeployedApplicationStatusDeactivating DeployedApplicationStatus = "Deactivating"
	// DeployedApplicationStatusDownloading Indicates that the package is downloading from the ImageStore. The
	// value is 1.
	DeployedApplicationStatusDownloading DeployedApplicationStatus = "Downloading"
	// DeployedApplicationStatusInvalid Indicates that deployment status is not valid. All Service Fabric
	// enumerations have the invalid type. The value is zero.
	DeployedApplicationStatusInvalid DeployedApplicationStatus = "Invalid"
	// DeployedApplicationStatusUpgrading Indicates that the package is upgrading. The value is 4.
	DeployedApplicationStatusUpgrading DeployedApplicationStatus = "Upgrading"
)

// PossibleDeployedApplicationStatusValues returns an array of possible values for the DeployedApplicationStatus const type.
func PossibleDeployedApplicationStatusValues() []DeployedApplicationStatus {
	return []DeployedApplicationStatus{DeployedApplicationStatusActivating, DeployedApplicationStatusActive, DeployedApplicationStatusDeactivating, DeployedApplicationStatusDownloading, DeployedApplicationStatusInvalid, DeployedApplicationStatusUpgrading}
}

// DeploymentStatus enumerates the values for deployment status.
type DeploymentStatus string

const (
	// DeploymentStatusActivating Indicates the application or service package is being activated. The value is
	// 2.
	DeploymentStatusActivating DeploymentStatus = "Activating"
	// DeploymentStatusActive Indicates the application or service package is active the node. The value is 3.
	DeploymentStatusActive DeploymentStatus = "Active"
	// DeploymentStatusDeactivating Indicates the application or service package is being deactivated. The
	// value is 5.
	DeploymentStatusDeactivating DeploymentStatus = "Deactivating"
	// DeploymentStatusDownloading Indicates the application or service package is being downloaded to the node
	// from the ImageStore. The value is 1.
	DeploymentStatusDownloading DeploymentStatus = "Downloading"
	// DeploymentStatusInvalid Indicates status of the application or service package is not known or invalid.
	// The value is 0.
	DeploymentStatusInvalid DeploymentStatus = "Invalid"
	// DeploymentStatusUpgrading Indicates the application or service package is being upgraded. The value is
	// 4.
	DeploymentStatusUpgrading DeploymentStatus = "Upgrading"
)

// PossibleDeploymentStatusValues returns an array of possible values for the DeploymentStatus const type.
func PossibleDeploymentStatusValues() []DeploymentStatus {
	return []DeploymentStatus{DeploymentStatusActivating, DeploymentStatusActive, DeploymentStatusDeactivating, DeploymentStatusDownloading, DeploymentStatusInvalid, DeploymentStatusUpgrading}
}

// DiagnosticsSinkKind enumerates the values for diagnostics sink kind.
type DiagnosticsSinkKind string

const (
	// DiagnosticsSinkKindAzureInternalMonitoringPipeline Diagnostics settings for Geneva.
	DiagnosticsSinkKindAzureInternalMonitoringPipeline DiagnosticsSinkKind = "AzureInternalMonitoringPipeline"
	// DiagnosticsSinkKindInvalid Indicates an invalid sink kind. All Service Fabric enumerations have the
	// invalid type.
	DiagnosticsSinkKindInvalid DiagnosticsSinkKind = "Invalid"
)

// PossibleDiagnosticsSinkKindValues returns an array of possible values for the DiagnosticsSinkKind const type.
func PossibleDiagnosticsSinkKindValues() []DiagnosticsSinkKind {
	return []DiagnosticsSinkKind{DiagnosticsSinkKindAzureInternalMonitoringPipeline, DiagnosticsSinkKindInvalid}
}

// EntityKind enumerates the values for entity kind.
type EntityKind string

const (
	// EntityKindApplication Indicates the entity is a Service Fabric application. The value is 4.
	EntityKindApplication EntityKind = "Application"
	// EntityKindCluster Indicates the entity is a Service Fabric cluster. The value is 8.
	EntityKindCluster EntityKind = "Cluster"
	// EntityKindDeployedApplication Indicates the entity is a Service Fabric deployed application. The value
	// is 6.
	EntityKindDeployedApplication EntityKind = "DeployedApplication"
	// EntityKindDeployedServicePackage Indicates the entity is a Service Fabric deployed service package. The
	// value is 7.
	EntityKindDeployedServicePackage EntityKind = "DeployedServicePackage"
	// EntityKindInvalid Indicates an invalid entity kind. All Service Fabric enumerations have the invalid
	// type. The value is zero.
	EntityKindInvalid EntityKind = "Invalid"
	// EntityKindNode Indicates the entity is a Service Fabric node. The value is 1.
	EntityKindNode EntityKind = "Node"
	// EntityKindPartition Indicates the entity is a Service Fabric partition. The value is 2.
	EntityKindPartition EntityKind = "Partition"
	// EntityKindReplica Indicates the entity is a Service Fabric replica. The value is 5.
	EntityKindReplica EntityKind = "Replica"
	// EntityKindService Indicates the entity is a Service Fabric service. The value is 3.
	EntityKindService EntityKind = "Service"
)

// PossibleEntityKindValues returns an array of possible values for the EntityKind const type.
func PossibleEntityKindValues() []EntityKind {
	return []EntityKind{EntityKindApplication, EntityKindCluster, EntityKindDeployedApplication, EntityKindDeployedServicePackage, EntityKindInvalid, EntityKindNode, EntityKindPartition, EntityKindReplica, EntityKindService}
}

// EntityKindBasicBackupEntity enumerates the values for entity kind basic backup entity.
type EntityKindBasicBackupEntity string

const (
	// EntityKindApplication1 ...
	EntityKindApplication1 EntityKindBasicBackupEntity = "Application"
	// EntityKindBackupEntity ...
	EntityKindBackupEntity EntityKindBasicBackupEntity = "BackupEntity"
	// EntityKindPartition1 ...
	EntityKindPartition1 EntityKindBasicBackupEntity = "Partition"
	// EntityKindService1 ...
	EntityKindService1 EntityKindBasicBackupEntity = "Service"
)

// PossibleEntityKindBasicBackupEntityValues returns an array of possible values for the EntityKindBasicBackupEntity const type.
func PossibleEntityKindBasicBackupEntityValues() []EntityKindBasicBackupEntity {
	return []EntityKindBasicBackupEntity{EntityKindApplication1, EntityKindBackupEntity, EntityKindPartition1, EntityKindService1}
}

// EntryPointStatus enumerates the values for entry point status.
type EntryPointStatus string

const (
	// EntryPointStatusInvalid Indicates status of entry point is not known or invalid. The value is 0.
	EntryPointStatusInvalid EntryPointStatus = "Invalid"
	// EntryPointStatusPending Indicates the entry point is scheduled to be started. The value is 1.
	EntryPointStatusPending EntryPointStatus = "Pending"
	// EntryPointStatusStarted Indicates the entry point was started successfully and is running. The value is
	// 3.
	EntryPointStatusStarted EntryPointStatus = "Started"
	// EntryPointStatusStarting Indicates the entry point is being started. The value is 2.
	EntryPointStatusStarting EntryPointStatus = "Starting"
	// EntryPointStatusStopped Indicates the entry point is not running. The value is 5.
	EntryPointStatusStopped EntryPointStatus = "Stopped"
	// EntryPointStatusStopping Indicates the entry point is being stopped. The value is 4.
	EntryPointStatusStopping EntryPointStatus = "Stopping"
)

// PossibleEntryPointStatusValues returns an array of possible values for the EntryPointStatus const type.
func PossibleEntryPointStatusValues() []EntryPointStatus {
	return []EntryPointStatus{EntryPointStatusInvalid, EntryPointStatusPending, EntryPointStatusStarted, EntryPointStatusStarting, EntryPointStatusStopped, EntryPointStatusStopping}
}

// FabricErrorCodes enumerates the values for fabric error codes.
type FabricErrorCodes string

const (
	// EABORT ...
	EABORT FabricErrorCodes = "E_ABORT"
	// EFAIL ...
	EFAIL FabricErrorCodes = "E_FAIL"
	// EINVALIDARG ...
	EINVALIDARG FabricErrorCodes = "E_INVALIDARG"
	// FABRICEAPPLICATIONALREADYEXISTS ...
	FABRICEAPPLICATIONALREADYEXISTS FabricErrorCodes = "FABRIC_E_APPLICATION_ALREADY_EXISTS"
	// FABRICEAPPLICATIONALREADYINTARGETVERSION ...
	FABRICEAPPLICATIONALREADYINTARGETVERSION FabricErrorCodes = "FABRIC_E_APPLICATION_ALREADY_IN_TARGET_VERSION"
	// FABRICEAPPLICATIONNOTFOUND ...
	FABRICEAPPLICATIONNOTFOUND FabricErrorCodes = "FABRIC_E_APPLICATION_NOT_FOUND"
	// FABRICEAPPLICATIONNOTUPGRADING ...
	FABRICEAPPLICATIONNOTUPGRADING FabricErrorCodes = "FABRIC_E_APPLICATION_NOT_UPGRADING"
	// FABRICEAPPLICATIONTYPEALREADYEXISTS ...
	FABRICEAPPLICATIONTYPEALREADYEXISTS FabricErrorCodes = "FABRIC_E_APPLICATION_TYPE_ALREADY_EXISTS"
	// FABRICEAPPLICATIONTYPEINUSE ...
	FABRICEAPPLICATIONTYPEINUSE FabricErrorCodes = "FABRIC_E_APPLICATION_TYPE_IN_USE"
	// FABRICEAPPLICATIONTYPENOTFOUND ...
	FABRICEAPPLICATIONTYPENOTFOUND FabricErrorCodes = "FABRIC_E_APPLICATION_TYPE_NOT_FOUND"
	// FABRICEAPPLICATIONTYPEPROVISIONINPROGRESS ...
	FABRICEAPPLICATIONTYPEPROVISIONINPROGRESS FabricErrorCodes = "FABRIC_E_APPLICATION_TYPE_PROVISION_IN_PROGRESS"
	// FABRICEAPPLICATIONUPGRADEINPROGRESS ...
	FABRICEAPPLICATIONUPGRADEINPROGRESS FabricErrorCodes = "FABRIC_E_APPLICATION_UPGRADE_IN_PROGRESS"
	// FABRICEAPPLICATIONUPGRADEVALIDATIONERROR ...
	FABRICEAPPLICATIONUPGRADEVALIDATIONERROR FabricErrorCodes = "FABRIC_E_APPLICATION_UPGRADE_VALIDATION_ERROR"
	// FABRICEBACKUPINPROGRESS ...
	FABRICEBACKUPINPROGRESS FabricErrorCodes = "FABRIC_E_BACKUP_IN_PROGRESS"
	// FABRICEBACKUPISENABLED ...
	FABRICEBACKUPISENABLED FabricErrorCodes = "FABRIC_E_BACKUP_IS_ENABLED"
	// FABRICEBACKUPNOTENABLED ...
	FABRICEBACKUPNOTENABLED FabricErrorCodes = "FABRIC_E_BACKUP_NOT_ENABLED"
	// FABRICEBACKUPPOLICYALREADYEXISTING ...
	FABRICEBACKUPPOLICYALREADYEXISTING FabricErrorCodes = "FABRIC_E_BACKUP_POLICY_ALREADY_EXISTING"
	// FABRICEBACKUPPOLICYNOTEXISTING ...
	FABRICEBACKUPPOLICYNOTEXISTING FabricErrorCodes = "FABRIC_E_BACKUP_POLICY_NOT_EXISTING"
	// FABRICECOMMUNICATIONERROR ...
	FABRICECOMMUNICATIONERROR FabricErrorCodes = "FABRIC_E_COMMUNICATION_ERROR"
	// FABRICECONFIGURATIONPARAMETERNOTFOUND ...
	FABRICECONFIGURATIONPARAMETERNOTFOUND FabricErrorCodes = "FABRIC_E_CONFIGURATION_PARAMETER_NOT_FOUND"
	// FABRICECONFIGURATIONSECTIONNOTFOUND ...
	FABRICECONFIGURATIONSECTIONNOTFOUND FabricErrorCodes = "FABRIC_E_CONFIGURATION_SECTION_NOT_FOUND"
	// FABRICEDIRECTORYNOTFOUND ...
	FABRICEDIRECTORYNOTFOUND FabricErrorCodes = "FABRIC_E_DIRECTORY_NOT_FOUND"
	// FABRICEENUMERATIONCOMPLETED ...
	FABRICEENUMERATIONCOMPLETED FabricErrorCodes = "FABRIC_E_ENUMERATION_COMPLETED"
	// FABRICEFABRICALREADYINTARGETVERSION ...
	FABRICEFABRICALREADYINTARGETVERSION FabricErrorCodes = "FABRIC_E_FABRIC_ALREADY_IN_TARGET_VERSION"
	// FABRICEFABRICNOTUPGRADING ...
	FABRICEFABRICNOTUPGRADING FabricErrorCodes = "FABRIC_E_FABRIC_NOT_UPGRADING"
	// FABRICEFABRICUPGRADEINPROGRESS ...
	FABRICEFABRICUPGRADEINPROGRESS FabricErrorCodes = "FABRIC_E_FABRIC_UPGRADE_IN_PROGRESS"
	// FABRICEFABRICUPGRADEVALIDATIONERROR ...
	FABRICEFABRICUPGRADEVALIDATIONERROR FabricErrorCodes = "FABRIC_E_FABRIC_UPGRADE_VALIDATION_ERROR"
	// FABRICEFABRICVERSIONALREADYEXISTS ...
	FABRICEFABRICVERSIONALREADYEXISTS FabricErrorCodes = "FABRIC_E_FABRIC_VERSION_ALREADY_EXISTS"
	// FABRICEFABRICVERSIONINUSE ...
	FABRICEFABRICVERSIONINUSE FabricErrorCodes = "FABRIC_E_FABRIC_VERSION_IN_USE"
	// FABRICEFABRICVERSIONNOTFOUND ...
	FABRICEFABRICVERSIONNOTFOUND FabricErrorCodes = "FABRIC_E_FABRIC_VERSION_NOT_FOUND"
	// FABRICEFAULTANALYSISSERVICENOTEXISTING ...
	FABRICEFAULTANALYSISSERVICENOTEXISTING FabricErrorCodes = "FABRIC_E_FAULT_ANALYSIS_SERVICE_NOT_EXISTING"
	// FABRICEFILENOTFOUND ...
	FABRICEFILENOTFOUND FabricErrorCodes = "FABRIC_E_FILE_NOT_FOUND"
	// FABRICEHEALTHENTITYNOTFOUND ...
	FABRICEHEALTHENTITYNOTFOUND FabricErrorCodes = "FABRIC_E_HEALTH_ENTITY_NOT_FOUND"
	// FABRICEHEALTHSTALEREPORT ...
	FABRICEHEALTHSTALEREPORT FabricErrorCodes = "FABRIC_E_HEALTH_STALE_REPORT"
	// FABRICEIMAGEBUILDERVALIDATIONERROR ...
	FABRICEIMAGEBUILDERVALIDATIONERROR FabricErrorCodes = "FABRIC_E_IMAGEBUILDER_VALIDATION_ERROR"
	// FABRICEINSTANCEIDMISMATCH ...
	FABRICEINSTANCEIDMISMATCH FabricErrorCodes = "FABRIC_E_INSTANCE_ID_MISMATCH"
	// FABRICEINVALIDADDRESS ...
	FABRICEINVALIDADDRESS FabricErrorCodes = "FABRIC_E_INVALID_ADDRESS"
	// FABRICEINVALIDATOMICGROUP ...
	FABRICEINVALIDATOMICGROUP FabricErrorCodes = "FABRIC_E_INVALID_ATOMIC_GROUP"
	// FABRICEINVALIDCONFIGURATION ...
	FABRICEINVALIDCONFIGURATION FabricErrorCodes = "FABRIC_E_INVALID_CONFIGURATION"
	// FABRICEINVALIDFORSTATELESSSERVICES ...
	FABRICEINVALIDFORSTATELESSSERVICES FabricErrorCodes = "FABRIC_E_INVALID_FOR_STATELESS_SERVICES"
	// FABRICEINVALIDNAMEURI ...
	FABRICEINVALIDNAMEURI FabricErrorCodes = "FABRIC_E_INVALID_NAME_URI"
	// FABRICEINVALIDPARTITIONKEY ...
	FABRICEINVALIDPARTITIONKEY FabricErrorCodes = "FABRIC_E_INVALID_PARTITION_KEY"
	// FABRICEINVALIDSERVICESCALINGPOLICY ...
	FABRICEINVALIDSERVICESCALINGPOLICY FabricErrorCodes = "FABRIC_E_INVALID_SERVICE_SCALING_POLICY"
	// FABRICEKEYNOTFOUND ...
	FABRICEKEYNOTFOUND FabricErrorCodes = "FABRIC_E_KEY_NOT_FOUND"
	// FABRICEKEYTOOLARGE ...
	FABRICEKEYTOOLARGE FabricErrorCodes = "FABRIC_E_KEY_TOO_LARGE"
	// FABRICENAMEALREADYEXISTS ...
	FABRICENAMEALREADYEXISTS FabricErrorCodes = "FABRIC_E_NAME_ALREADY_EXISTS"
	// FABRICENAMEDOESNOTEXIST ...
	FABRICENAMEDOESNOTEXIST FabricErrorCodes = "FABRIC_E_NAME_DOES_NOT_EXIST"
	// FABRICENAMENOTEMPTY ...
	FABRICENAMENOTEMPTY FabricErrorCodes = "FABRIC_E_NAME_NOT_EMPTY"
	// FABRICENODEHASNOTSTOPPEDYET ...
	FABRICENODEHASNOTSTOPPEDYET FabricErrorCodes = "FABRIC_E_NODE_HAS_NOT_STOPPED_YET"
	// FABRICENODEISUP ...
	FABRICENODEISUP FabricErrorCodes = "FABRIC_E_NODE_IS_UP"
	// FABRICENODENOTFOUND ...
	FABRICENODENOTFOUND FabricErrorCodes = "FABRIC_E_NODE_NOT_FOUND"
	// FABRICENOTPRIMARY ...
	FABRICENOTPRIMARY FabricErrorCodes = "FABRIC_E_NOT_PRIMARY"
	// FABRICENOTREADY ...
	FABRICENOTREADY FabricErrorCodes = "FABRIC_E_NOT_READY"
	// FABRICENOWRITEQUORUM ...
	FABRICENOWRITEQUORUM FabricErrorCodes = "FABRIC_E_NO_WRITE_QUORUM"
	// FABRICEOPERATIONNOTCOMPLETE ...
	FABRICEOPERATIONNOTCOMPLETE FabricErrorCodes = "FABRIC_E_OPERATION_NOT_COMPLETE"
	// FABRICEPARTITIONNOTFOUND ...
	FABRICEPARTITIONNOTFOUND FabricErrorCodes = "FABRIC_E_PARTITION_NOT_FOUND"
	// FABRICEPATHTOOLONG ...
	FABRICEPATHTOOLONG FabricErrorCodes = "FABRIC_E_PATH_TOO_LONG"
	// FABRICEPROPERTYCHECKFAILED ...
	FABRICEPROPERTYCHECKFAILED FabricErrorCodes = "FABRIC_E_PROPERTY_CHECK_FAILED"
	// FABRICEPROPERTYDOESNOTEXIST ...
	FABRICEPROPERTYDOESNOTEXIST FabricErrorCodes = "FABRIC_E_PROPERTY_DOES_NOT_EXIST"
	// FABRICERECONFIGURATIONPENDING ...
	FABRICERECONFIGURATIONPENDING FabricErrorCodes = "FABRIC_E_RECONFIGURATION_PENDING"
	// FABRICEREPLICADOESNOTEXIST ...
	FABRICEREPLICADOESNOTEXIST FabricErrorCodes = "FABRIC_E_REPLICA_DOES_NOT_EXIST"
	// FABRICERESTOREINPROGRESS ...
	FABRICERESTOREINPROGRESS FabricErrorCodes = "FABRIC_E_RESTORE_IN_PROGRESS"
	// FABRICERESTORESOURCETARGETPARTITIONMISMATCH ...
	FABRICERESTORESOURCETARGETPARTITIONMISMATCH FabricErrorCodes = "FABRIC_E_RESTORE_SOURCE_TARGET_PARTITION_MISMATCH"
	// FABRICESEQUENCENUMBERCHECKFAILED ...
	FABRICESEQUENCENUMBERCHECKFAILED FabricErrorCodes = "FABRIC_E_SEQUENCE_NUMBER_CHECK_FAILED"
	// FABRICESERVICEAFFINITYCHAINNOTSUPPORTED ...
	FABRICESERVICEAFFINITYCHAINNOTSUPPORTED FabricErrorCodes = "FABRIC_E_SERVICE_AFFINITY_CHAIN_NOT_SUPPORTED"
	// FABRICESERVICEALREADYEXISTS ...
	FABRICESERVICEALREADYEXISTS FabricErrorCodes = "FABRIC_E_SERVICE_ALREADY_EXISTS"
	// FABRICESERVICEDOESNOTEXIST ...
	FABRICESERVICEDOESNOTEXIST FabricErrorCodes = "FABRIC_E_SERVICE_DOES_NOT_EXIST"
	// FABRICESERVICEGROUPALREADYEXISTS ...
	FABRICESERVICEGROUPALREADYEXISTS FabricErrorCodes = "FABRIC_E_SERVICE_GROUP_ALREADY_EXISTS"
	// FABRICESERVICEGROUPDOESNOTEXIST ...
	FABRICESERVICEGROUPDOESNOTEXIST FabricErrorCodes = "FABRIC_E_SERVICE_GROUP_DOES_NOT_EXIST"
	// FABRICESERVICEMANIFESTNOTFOUND ...
	FABRICESERVICEMANIFESTNOTFOUND FabricErrorCodes = "FABRIC_E_SERVICE_MANIFEST_NOT_FOUND"
	// FABRICESERVICEMETADATAMISMATCH ...
	FABRICESERVICEMETADATAMISMATCH FabricErrorCodes = "FABRIC_E_SERVICE_METADATA_MISMATCH"
	// FABRICESERVICEOFFLINE ...
	FABRICESERVICEOFFLINE FabricErrorCodes = "FABRIC_E_SERVICE_OFFLINE"
	// FABRICESERVICETYPEMISMATCH ...
	FABRICESERVICETYPEMISMATCH FabricErrorCodes = "FABRIC_E_SERVICE_TYPE_MISMATCH"
	// FABRICESERVICETYPENOTFOUND ...
	FABRICESERVICETYPENOTFOUND FabricErrorCodes = "FABRIC_E_SERVICE_TYPE_NOT_FOUND"
	// FABRICESERVICETYPETEMPLATENOTFOUND ...
	FABRICESERVICETYPETEMPLATENOTFOUND FabricErrorCodes = "FABRIC_E_SERVICE_TYPE_TEMPLATE_NOT_FOUND"
	// FABRICESINGLEINSTANCEAPPLICATIONALREADYEXISTS ...
	FABRICESINGLEINSTANCEAPPLICATIONALREADYEXISTS FabricErrorCodes = "FABRIC_E_SINGLE_INSTANCE_APPLICATION_ALREADY_EXISTS"
	// FABRICESINGLEINSTANCEAPPLICATIONNOTFOUND ...
	FABRICESINGLEINSTANCEAPPLICATIONNOTFOUND FabricErrorCodes = "FABRIC_E_SINGLE_INSTANCE_APPLICATION_NOT_FOUND"
	// FABRICETIMEOUT ...
	FABRICETIMEOUT FabricErrorCodes = "FABRIC_E_TIMEOUT"
	// FABRICEVALUEEMPTY ...
	FABRICEVALUEEMPTY FabricErrorCodes = "FABRIC_E_VALUE_EMPTY"
	// FABRICEVALUETOOLARGE ...
	FABRICEVALUETOOLARGE FabricErrorCodes = "FABRIC_E_VALUE_TOO_LARGE"
	// FABRICEVOLUMEALREADYEXISTS ...
	FABRICEVOLUMEALREADYEXISTS FabricErrorCodes = "FABRIC_E_VOLUME_ALREADY_EXISTS"
	// FABRICEVOLUMENOTFOUND ...
	FABRICEVOLUMENOTFOUND FabricErrorCodes = "FABRIC_E_VOLUME_NOT_FOUND"
	// SerializationError ...
	SerializationError FabricErrorCodes = "SerializationError"
)

// PossibleFabricErrorCodesValues returns an array of possible values for the FabricErrorCodes const type.
func PossibleFabricErrorCodesValues() []FabricErrorCodes {
	return []FabricErrorCodes{EABORT, EFAIL, EINVALIDARG, FABRICEAPPLICATIONALREADYEXISTS, FABRICEAPPLICATIONALREADYINTARGETVERSION, FABRICEAPPLICATIONNOTFOUND, FABRICEAPPLICATIONNOTUPGRADING, FABRICEAPPLICATIONTYPEALREADYEXISTS, FABRICEAPPLICATIONTYPEINUSE, FABRICEAPPLICATIONTYPENOTFOUND, FABRICEAPPLICATIONTYPEPROVISIONINPROGRESS, FABRICEAPPLICATIONUPGRADEINPROGRESS, FABRICEAPPLICATIONUPGRADEVALIDATIONERROR, FABRICEBACKUPINPROGRESS, FABRICEBACKUPISENABLED, FABRICEBACKUPNOTENABLED, FABRICEBACKUPPOLICYALREADYEXISTING, FABRICEBACKUPPOLICYNOTEXISTING, FABRICECOMMUNICATIONERROR, FABRICECONFIGURATIONPARAMETERNOTFOUND, FABRICECONFIGURATIONSECTIONNOTFOUND, FABRICEDIRECTORYNOTFOUND, FABRICEENUMERATIONCOMPLETED, FABRICEFABRICALREADYINTARGETVERSION, FABRICEFABRICNOTUPGRADING, FABRICEFABRICUPGRADEINPROGRESS, FABRICEFABRICUPGRADEVALIDATIONERROR, FABRICEFABRICVERSIONALREADYEXISTS, FABRICEFABRICVERSIONINUSE, FABRICEFABRICVERSIONNOTFOUND, FABRICEFAULTANALYSISSERVICENOTEXISTING, FABRICEFILENOTFOUND, FABRICEHEALTHENTITYNOTFOUND, FABRICEHEALTHSTALEREPORT, FABRICEIMAGEBUILDERVALIDATIONERROR, FABRICEINSTANCEIDMISMATCH, FABRICEINVALIDADDRESS, FABRICEINVALIDATOMICGROUP, FABRICEINVALIDCONFIGURATION, FABRICEINVALIDFORSTATELESSSERVICES, FABRICEINVALIDNAMEURI, FABRICEINVALIDPARTITIONKEY, FABRICEINVALIDSERVICESCALINGPOLICY, FABRICEKEYNOTFOUND, FABRICEKEYTOOLARGE, FABRICENAMEALREADYEXISTS, FABRICENAMEDOESNOTEXIST, FABRICENAMENOTEMPTY, FABRICENODEHASNOTSTOPPEDYET, FABRICENODEISUP, FABRICENODENOTFOUND, FABRICENOTPRIMARY, FABRICENOTREADY, FABRICENOWRITEQUORUM, FABRICEOPERATIONNOTCOMPLETE, FABRICEPARTITIONNOTFOUND, FABRICEPATHTOOLONG, FABRICEPROPERTYCHECKFAILED, FABRICEPROPERTYDOESNOTEXIST, FABRICERECONFIGURATIONPENDING, FABRICEREPLICADOESNOTEXIST, FABRICERESTOREINPROGRESS, FABRICERESTORESOURCETARGETPARTITIONMISMATCH, FABRICESEQUENCENUMBERCHECKFAILED, FABRICESERVICEAFFINITYCHAINNOTSUPPORTED, FABRICESERVICEALREADYEXISTS, FABRICESERVICEDOESNOTEXIST, FABRICESERVICEGROUPALREADYEXISTS, FABRICESERVICEGROUPDOESNOTEXIST, FABRICESERVICEMANIFESTNOTFOUND, FABRICESERVICEMETADATAMISMATCH, FABRICESERVICEOFFLINE, FABRICESERVICETYPEMISMATCH, FABRICESERVICETYPENOTFOUND, FABRICESERVICETYPETEMPLATENOTFOUND, FABRICESINGLEINSTANCEAPPLICATIONALREADYEXISTS, FABRICESINGLEINSTANCEAPPLICATIONNOTFOUND, FABRICETIMEOUT, FABRICEVALUEEMPTY, FABRICEVALUETOOLARGE, FABRICEVOLUMEALREADYEXISTS, FABRICEVOLUMENOTFOUND, SerializationError}
}

// FabricEventKind enumerates the values for fabric event kind.
type FabricEventKind string

const (
	// FabricEventKindApplicationCreated ...
	FabricEventKindApplicationCreated FabricEventKind = "ApplicationCreated"
	// FabricEventKindApplicationDeleted ...
	FabricEventKindApplicationDeleted FabricEventKind = "ApplicationDeleted"
	// FabricEventKindApplicationEvent ...
	FabricEventKindApplicationEvent FabricEventKind = "ApplicationEvent"
	// FabricEventKindApplicationHealthReportCreated ...
	FabricEventKindApplicationHealthReportCreated FabricEventKind = "ApplicationHealthReportCreated"
	// FabricEventKindApplicationHealthReportExpired ...
	FabricEventKindApplicationHealthReportExpired FabricEventKind = "ApplicationHealthReportExpired"
	// FabricEventKindApplicationUpgradeComplete ...
	FabricEventKindApplicationUpgradeComplete FabricEventKind = "ApplicationUpgradeComplete"
	// FabricEventKindApplicationUpgradeDomainComplete ...
	FabricEventKindApplicationUpgradeDomainComplete FabricEventKind = "ApplicationUpgradeDomainComplete"
	// FabricEventKindApplicationUpgradeRollbackComplete ...
	FabricEventKindApplicationUpgradeRollbackComplete FabricEventKind = "ApplicationUpgradeRollbackComplete"
	// FabricEventKindApplicationUpgradeRollbackStart ...
	FabricEventKindApplicationUpgradeRollbackStart FabricEventKind = "ApplicationUpgradeRollbackStart"
	// FabricEventKindApplicationUpgradeStart ...
	FabricEventKindApplicationUpgradeStart FabricEventKind = "ApplicationUpgradeStart"
	// FabricEventKindChaosMovePrimaryFaultScheduled ...
	FabricEventKindChaosMovePrimaryFaultScheduled FabricEventKind = "ChaosMovePrimaryFaultScheduled"
	// FabricEventKindChaosMoveSecondaryFaultScheduled ...
	FabricEventKindChaosMoveSecondaryFaultScheduled FabricEventKind = "ChaosMoveSecondaryFaultScheduled"
	// FabricEventKindChaosRemoveReplicaFaultCompleted ...
	FabricEventKindChaosRemoveReplicaFaultCompleted FabricEventKind = "ChaosRemoveReplicaFaultCompleted"
	// FabricEventKindChaosRemoveReplicaFaultScheduled ...
	FabricEventKindChaosRemoveReplicaFaultScheduled FabricEventKind = "ChaosRemoveReplicaFaultScheduled"
	// FabricEventKindChaosRestartCodePackageFaultCompleted ...
	FabricEventKindChaosRestartCodePackageFaultCompleted FabricEventKind = "ChaosRestartCodePackageFaultCompleted"
	// FabricEventKindChaosRestartCodePackageFaultScheduled ...
	FabricEventKindChaosRestartCodePackageFaultScheduled FabricEventKind = "ChaosRestartCodePackageFaultScheduled"
	// FabricEventKindChaosRestartNodeFaultCompleted ...
	FabricEventKindChaosRestartNodeFaultCompleted FabricEventKind = "ChaosRestartNodeFaultCompleted"
	// FabricEventKindChaosRestartNodeFaultScheduled ...
	FabricEventKindChaosRestartNodeFaultScheduled FabricEventKind = "ChaosRestartNodeFaultScheduled"
	// FabricEventKindChaosRestartReplicaFaultScheduled ...
	FabricEventKindChaosRestartReplicaFaultScheduled FabricEventKind = "ChaosRestartReplicaFaultScheduled"
	// FabricEventKindChaosStarted ...
	FabricEventKindChaosStarted FabricEventKind = "ChaosStarted"
	// FabricEventKindChaosStopped ...
	FabricEventKindChaosStopped FabricEventKind = "ChaosStopped"
	// FabricEventKindClusterEvent ...
	FabricEventKindClusterEvent FabricEventKind = "ClusterEvent"
	// FabricEventKindClusterHealthReportCreated ...
	FabricEventKindClusterHealthReportCreated FabricEventKind = "ClusterHealthReportCreated"
	// FabricEventKindClusterHealthReportExpired ...
	FabricEventKindClusterHealthReportExpired FabricEventKind = "ClusterHealthReportExpired"
	// FabricEventKindClusterUpgradeComplete ...
	FabricEventKindClusterUpgradeComplete FabricEventKind = "ClusterUpgradeComplete"
	// FabricEventKindClusterUpgradeDomainComplete ...
	FabricEventKindClusterUpgradeDomainComplete FabricEventKind = "ClusterUpgradeDomainComplete"
	// FabricEventKindClusterUpgradeRollbackComplete ...
	FabricEventKindClusterUpgradeRollbackComplete FabricEventKind = "ClusterUpgradeRollbackComplete"
	// FabricEventKindClusterUpgradeRollbackStart ...
	FabricEventKindClusterUpgradeRollbackStart FabricEventKind = "ClusterUpgradeRollbackStart"
	// FabricEventKindClusterUpgradeStart ...
	FabricEventKindClusterUpgradeStart FabricEventKind = "ClusterUpgradeStart"
	// FabricEventKindContainerDeactivated ...
	FabricEventKindContainerDeactivated FabricEventKind = "ContainerDeactivated"
	// FabricEventKindContainerInstanceEvent ...
	FabricEventKindContainerInstanceEvent FabricEventKind = "ContainerInstanceEvent"
	// FabricEventKindDeployedApplicationHealthReportCreated ...
	FabricEventKindDeployedApplicationHealthReportCreated FabricEventKind = "DeployedApplicationHealthReportCreated"
	// FabricEventKindDeployedApplicationHealthReportExpired ...
	FabricEventKindDeployedApplicationHealthReportExpired FabricEventKind = "DeployedApplicationHealthReportExpired"
	// FabricEventKindDeployedServiceHealthReportCreated ...
	FabricEventKindDeployedServiceHealthReportCreated FabricEventKind = "DeployedServiceHealthReportCreated"
	// FabricEventKindDeployedServiceHealthReportExpired ...
	FabricEventKindDeployedServiceHealthReportExpired FabricEventKind = "DeployedServiceHealthReportExpired"
	// FabricEventKindNodeAborted ...
	FabricEventKindNodeAborted FabricEventKind = "NodeAborted"
	// FabricEventKindNodeAborting ...
	FabricEventKindNodeAborting FabricEventKind = "NodeAborting"
	// FabricEventKindNodeAdded ...
	FabricEventKindNodeAdded FabricEventKind = "NodeAdded"
	// FabricEventKindNodeClose ...
	FabricEventKindNodeClose FabricEventKind = "NodeClose"
	// FabricEventKindNodeClosing ...
	FabricEventKindNodeClosing FabricEventKind = "NodeClosing"
	// FabricEventKindNodeDeactivateComplete ...
	FabricEventKindNodeDeactivateComplete FabricEventKind = "NodeDeactivateComplete"
	// FabricEventKindNodeDeactivateStart ...
	FabricEventKindNodeDeactivateStart FabricEventKind = "NodeDeactivateStart"
	// FabricEventKindNodeDown ...
	FabricEventKindNodeDown FabricEventKind = "NodeDown"
	// FabricEventKindNodeEvent ...
	FabricEventKindNodeEvent FabricEventKind = "NodeEvent"
	// FabricEventKindNodeHealthReportCreated ...
	FabricEventKindNodeHealthReportCreated FabricEventKind = "NodeHealthReportCreated"
	// FabricEventKindNodeHealthReportExpired ...
	FabricEventKindNodeHealthReportExpired FabricEventKind = "NodeHealthReportExpired"
	// FabricEventKindNodeOpenedSuccess ...
	FabricEventKindNodeOpenedSuccess FabricEventKind = "NodeOpenedSuccess"
	// FabricEventKindNodeOpenFailed ...
	FabricEventKindNodeOpenFailed FabricEventKind = "NodeOpenFailed"
	// FabricEventKindNodeOpening ...
	FabricEventKindNodeOpening FabricEventKind = "NodeOpening"
	// FabricEventKindNodeRemoved ...
	FabricEventKindNodeRemoved FabricEventKind = "NodeRemoved"
	// FabricEventKindNodeUp ...
	FabricEventKindNodeUp FabricEventKind = "NodeUp"
	// FabricEventKindPartitionAnalysisEvent ...
	FabricEventKindPartitionAnalysisEvent FabricEventKind = "PartitionAnalysisEvent"
	// FabricEventKindPartitionEvent ...
	FabricEventKindPartitionEvent FabricEventKind = "PartitionEvent"
	// FabricEventKindPartitionHealthReportCreated ...
	FabricEventKindPartitionHealthReportCreated FabricEventKind = "PartitionHealthReportCreated"
	// FabricEventKindPartitionHealthReportExpired ...
	FabricEventKindPartitionHealthReportExpired FabricEventKind = "PartitionHealthReportExpired"
	// FabricEventKindPartitionPrimaryMoveAnalysis ...
	FabricEventKindPartitionPrimaryMoveAnalysis FabricEventKind = "PartitionPrimaryMoveAnalysis"
	// FabricEventKindPartitionReconfigurationCompleted ...
	FabricEventKindPartitionReconfigurationCompleted FabricEventKind = "PartitionReconfigurationCompleted"
	// FabricEventKindProcessDeactivated ...
	FabricEventKindProcessDeactivated FabricEventKind = "ProcessDeactivated"
	// FabricEventKindReplicaEvent ...
	FabricEventKindReplicaEvent FabricEventKind = "ReplicaEvent"
	// FabricEventKindServiceCreated ...
	FabricEventKindServiceCreated FabricEventKind = "ServiceCreated"
	// FabricEventKindServiceDeleted ...
	FabricEventKindServiceDeleted FabricEventKind = "ServiceDeleted"
	// FabricEventKindServiceEvent ...
	FabricEventKindServiceEvent FabricEventKind = "ServiceEvent"
	// FabricEventKindServiceHealthReportCreated ...
	FabricEventKindServiceHealthReportCreated FabricEventKind = "ServiceHealthReportCreated"
	// FabricEventKindServiceHealthReportExpired ...
	FabricEventKindServiceHealthReportExpired FabricEventKind = "ServiceHealthReportExpired"
	// FabricEventKindStatefulReplicaHealthReportCreated ...
	FabricEventKindStatefulReplicaHealthReportCreated FabricEventKind = "StatefulReplicaHealthReportCreated"
	// FabricEventKindStatefulReplicaHealthReportExpired ...
	FabricEventKindStatefulReplicaHealthReportExpired FabricEventKind = "StatefulReplicaHealthReportExpired"
	// FabricEventKindStatelessReplicaHealthReportCreated ...
	FabricEventKindStatelessReplicaHealthReportCreated FabricEventKind = "StatelessReplicaHealthReportCreated"
	// FabricEventKindStatelessReplicaHealthReportExpired ...
	FabricEventKindStatelessReplicaHealthReportExpired FabricEventKind = "StatelessReplicaHealthReportExpired"
)

// PossibleFabricEventKindValues returns an array of possible values for the FabricEventKind const type.
func PossibleFabricEventKindValues() []FabricEventKind {
	return []FabricEventKind{FabricEventKindApplicationCreated, FabricEventKindApplicationDeleted, FabricEventKindApplicationEvent, FabricEventKindApplicationHealthReportCreated, FabricEventKindApplicationHealthReportExpired, FabricEventKindApplicationUpgradeComplete, FabricEventKindApplicationUpgradeDomainComplete, FabricEventKindApplicationUpgradeRollbackComplete, FabricEventKindApplicationUpgradeRollbackStart, FabricEventKindApplicationUpgradeStart, FabricEventKindChaosMovePrimaryFaultScheduled, FabricEventKindChaosMoveSecondaryFaultScheduled, FabricEventKindChaosRemoveReplicaFaultCompleted, FabricEventKindChaosRemoveReplicaFaultScheduled, FabricEventKindChaosRestartCodePackageFaultCompleted, FabricEventKindChaosRestartCodePackageFaultScheduled, FabricEventKindChaosRestartNodeFaultCompleted, FabricEventKindChaosRestartNodeFaultScheduled, FabricEventKindChaosRestartReplicaFaultScheduled, FabricEventKindChaosStarted, FabricEventKindChaosStopped, FabricEventKindClusterEvent, FabricEventKindClusterHealthReportCreated, FabricEventKindClusterHealthReportExpired, FabricEventKindClusterUpgradeComplete, FabricEventKindClusterUpgradeDomainComplete, FabricEventKindClusterUpgradeRollbackComplete, FabricEventKindClusterUpgradeRollbackStart, FabricEventKindClusterUpgradeStart, FabricEventKindContainerDeactivated, FabricEventKindContainerInstanceEvent, FabricEventKindDeployedApplicationHealthReportCreated, FabricEventKindDeployedApplicationHealthReportExpired, FabricEventKindDeployedServiceHealthReportCreated, FabricEventKindDeployedServiceHealthReportExpired, FabricEventKindNodeAborted, FabricEventKindNodeAborting, FabricEventKindNodeAdded, FabricEventKindNodeClose, FabricEventKindNodeClosing, FabricEventKindNodeDeactivateComplete, FabricEventKindNodeDeactivateStart, FabricEventKindNodeDown, FabricEventKindNodeEvent, FabricEventKindNodeHealthReportCreated, FabricEventKindNodeHealthReportExpired, FabricEventKindNodeOpenedSuccess, FabricEventKindNodeOpenFailed, FabricEventKindNodeOpening, FabricEventKindNodeRemoved, FabricEventKindNodeUp, FabricEventKindPartitionAnalysisEvent, FabricEventKindPartitionEvent, FabricEventKindPartitionHealthReportCreated, FabricEventKindPartitionHealthReportExpired, FabricEventKindPartitionPrimaryMoveAnalysis, FabricEventKindPartitionReconfigurationCompleted, FabricEventKindProcessDeactivated, FabricEventKindReplicaEvent, FabricEventKindServiceCreated, FabricEventKindServiceDeleted, FabricEventKindServiceEvent, FabricEventKindServiceHealthReportCreated, FabricEventKindServiceHealthReportExpired, FabricEventKindStatefulReplicaHealthReportCreated, FabricEventKindStatefulReplicaHealthReportExpired, FabricEventKindStatelessReplicaHealthReportCreated, FabricEventKindStatelessReplicaHealthReportExpired}
}

// FabricReplicaStatus enumerates the values for fabric replica status.
type FabricReplicaStatus string

const (
	// FabricReplicaStatusDown Indicates that the replica is down.
	FabricReplicaStatusDown FabricReplicaStatus = "Down"
	// FabricReplicaStatusInvalid Indicates that the read or write operation access status is not valid. This
	// value is not returned to the caller.
	FabricReplicaStatusInvalid FabricReplicaStatus = "Invalid"
	// FabricReplicaStatusUp Indicates that the replica is up.
	FabricReplicaStatusUp FabricReplicaStatus = "Up"
)

// PossibleFabricReplicaStatusValues returns an array of possible values for the FabricReplicaStatus const type.
func PossibleFabricReplicaStatusValues() []FabricReplicaStatus {
	return []FabricReplicaStatus{FabricReplicaStatusDown, FabricReplicaStatusInvalid, FabricReplicaStatusUp}
}

// FailureAction enumerates the values for failure action.
type FailureAction string

const (
	// FailureActionInvalid Indicates the failure action is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	FailureActionInvalid FailureAction = "Invalid"
	// FailureActionManual The upgrade will switch to UnmonitoredManual upgrade mode. The value is 2
	FailureActionManual FailureAction = "Manual"
	// FailureActionRollback The upgrade will start rolling back automatically. The value is 1
	FailureActionRollback FailureAction = "Rollback"
)

// PossibleFailureActionValues returns an array of possible values for the FailureAction const type.
func PossibleFailureActionValues() []FailureAction {
	return []FailureAction{FailureActionInvalid, FailureActionManual, FailureActionRollback}
}

// FailureReason enumerates the values for failure reason.
type FailureReason string

const (
	// HealthCheck The upgrade failed due to health policy violations. The value is 2
	HealthCheck FailureReason = "HealthCheck"
	// Interrupted There was an external request to roll back the upgrade. The value is 1
	Interrupted FailureReason = "Interrupted"
	// None Indicates the reason is invalid or unknown. All Service Fabric enumerations have the invalid type.
	// The value is zero.
	None FailureReason = "None"
	// OverallUpgradeTimeout The overall upgrade took longer than the allowed upgrade timeout to process. The
	// value is 4
	OverallUpgradeTimeout FailureReason = "OverallUpgradeTimeout"
	// UpgradeDomainTimeout An upgrade domain took longer than the allowed upgrade domain timeout to process.
	// The value is 3
	UpgradeDomainTimeout FailureReason = "UpgradeDomainTimeout"
)

// PossibleFailureReasonValues returns an array of possible values for the FailureReason const type.
func PossibleFailureReasonValues() []FailureReason {
	return []FailureReason{HealthCheck, Interrupted, None, OverallUpgradeTimeout, UpgradeDomainTimeout}
}

// HealthEvaluationKind enumerates the values for health evaluation kind.
type HealthEvaluationKind string

const (
	// HealthEvaluationKindApplication Indicates that the health evaluation is for an application. The value is
	// 18.
	HealthEvaluationKindApplication HealthEvaluationKind = "Application"
	// HealthEvaluationKindApplications Indicates that the health evaluation is for the cluster applications.
	// The value is 8.
	HealthEvaluationKindApplications HealthEvaluationKind = "Applications"
	// HealthEvaluationKindApplicationTypeApplications – Indicates that the health evaluation is for
	// applications of an application type. The value is 21.
	HealthEvaluationKindApplicationTypeApplications HealthEvaluationKind = "ApplicationTypeApplications"
	// HealthEvaluationKindDeltaNodesCheck Indicates that the health evaluation is for the delta of unhealthy
	// cluster nodes. The value is 19.
	HealthEvaluationKindDeltaNodesCheck HealthEvaluationKind = "DeltaNodesCheck"
	// HealthEvaluationKindDeployedApplication Indicates that the health evaluation is for a deployed
	// application. The value is 17.
	HealthEvaluationKindDeployedApplication HealthEvaluationKind = "DeployedApplication"
	// HealthEvaluationKindDeployedApplications Indicates that the health evaluation is for the deployed
	// applications of an application. The value is 5.
	HealthEvaluationKindDeployedApplications HealthEvaluationKind = "DeployedApplications"
	// HealthEvaluationKindDeployedServicePackage Indicates that the health evaluation is for a deployed
	// service package. The value is 16.
	HealthEvaluationKindDeployedServicePackage HealthEvaluationKind = "DeployedServicePackage"
	// HealthEvaluationKindDeployedServicePackages Indicates that the health evaluation is for the deployed
	// service packages of a deployed application. The value is 4.
	HealthEvaluationKindDeployedServicePackages HealthEvaluationKind = "DeployedServicePackages"
	// HealthEvaluationKindEvent Indicates that the health evaluation is for a health event. The value is 1.
	HealthEvaluationKindEvent HealthEvaluationKind = "Event"
	// HealthEvaluationKindInvalid Indicates that the health evaluation is invalid. The value is zero.
	HealthEvaluationKindInvalid HealthEvaluationKind = "Invalid"
	// HealthEvaluationKindNode Indicates that the health evaluation is for a node. The value is 12.
	HealthEvaluationKindNode HealthEvaluationKind = "Node"
	// HealthEvaluationKindNodes Indicates that the health evaluation is for the cluster nodes. The value is 7.
	HealthEvaluationKindNodes HealthEvaluationKind = "Nodes"
	// HealthEvaluationKindPartition Indicates that the health evaluation is for a partition. The value is 14.
	HealthEvaluationKindPartition HealthEvaluationKind = "Partition"
	// HealthEvaluationKindPartitions Indicates that the health evaluation is for the partitions of a service.
	// The value is 3.
	HealthEvaluationKindPartitions HealthEvaluationKind = "Partitions"
	// HealthEvaluationKindReplica Indicates that the health evaluation is for a replica. The value is 13.
	HealthEvaluationKindReplica HealthEvaluationKind = "Replica"
	// HealthEvaluationKindReplicas Indicates that the health evaluation is for the replicas of a partition.
	// The value is 2.
	HealthEvaluationKindReplicas HealthEvaluationKind = "Replicas"
	// HealthEvaluationKindService Indicates that the health evaluation is for a service. The value is 15.
	HealthEvaluationKindService HealthEvaluationKind = "Service"
	// HealthEvaluationKindServices Indicates that the health evaluation is for services of an application. The
	// value is 6.
	HealthEvaluationKindServices HealthEvaluationKind = "Services"
	// HealthEvaluationKindSystemApplication Indicates that the health evaluation is for the system
	// application. The value is 9.
	HealthEvaluationKindSystemApplication HealthEvaluationKind = "SystemApplication"
	// HealthEvaluationKindUpgradeDomainDeltaNodesCheck Indicates that the health evaluation is for the delta
	// of unhealthy upgrade domain cluster nodes. The value is 20.
	HealthEvaluationKindUpgradeDomainDeltaNodesCheck HealthEvaluationKind = "UpgradeDomainDeltaNodesCheck"
	// HealthEvaluationKindUpgradeDomainDeployedApplications Indicates that the health evaluation is for the
	// deployed applications of an application in an upgrade domain. The value is 10.
	HealthEvaluationKindUpgradeDomainDeployedApplications HealthEvaluationKind = "UpgradeDomainDeployedApplications"
	// HealthEvaluationKindUpgradeDomainNodes Indicates that the health evaluation is for the cluster nodes in
	// an upgrade domain. The value is 11.
	HealthEvaluationKindUpgradeDomainNodes HealthEvaluationKind = "UpgradeDomainNodes"
)

// PossibleHealthEvaluationKindValues returns an array of possible values for the HealthEvaluationKind const type.
func PossibleHealthEvaluationKindValues() []HealthEvaluationKind {
	return []HealthEvaluationKind{HealthEvaluationKindApplication, HealthEvaluationKindApplications, HealthEvaluationKindApplicationTypeApplications, HealthEvaluationKindDeltaNodesCheck, HealthEvaluationKindDeployedApplication, HealthEvaluationKindDeployedApplications, HealthEvaluationKindDeployedServicePackage, HealthEvaluationKindDeployedServicePackages, HealthEvaluationKindEvent, HealthEvaluationKindInvalid, HealthEvaluationKindNode, HealthEvaluationKindNodes, HealthEvaluationKindPartition, HealthEvaluationKindPartitions, HealthEvaluationKindReplica, HealthEvaluationKindReplicas, HealthEvaluationKindService, HealthEvaluationKindServices, HealthEvaluationKindSystemApplication, HealthEvaluationKindUpgradeDomainDeltaNodesCheck, HealthEvaluationKindUpgradeDomainDeployedApplications, HealthEvaluationKindUpgradeDomainNodes}
}

// HealthState enumerates the values for health state.
type HealthState string

const (
	// HealthStateError Indicates the health state is at an error level. Error health state should be
	// investigated, as they can impact the correct functionality of the cluster. The value is 3.
	HealthStateError HealthState = "Error"
	// HealthStateInvalid Indicates an invalid health state. All Service Fabric enumerations have the invalid
	// type. The value is zero.
	HealthStateInvalid HealthState = "Invalid"
	// HealthStateOk Indicates the health state is okay. The value is 1.
	HealthStateOk HealthState = "Ok"
	// HealthStateUnknown Indicates an unknown health status. The value is 65535.
	HealthStateUnknown HealthState = "Unknown"
	// HealthStateWarning Indicates the health state is at a warning level. The value is 2.
	HealthStateWarning HealthState = "Warning"
)

// PossibleHealthStateValues returns an array of possible values for the HealthState const type.
func PossibleHealthStateValues() []HealthState {
	return []HealthState{HealthStateError, HealthStateInvalid, HealthStateOk, HealthStateUnknown, HealthStateWarning}
}

// HostIsolationMode enumerates the values for host isolation mode.
type HostIsolationMode string

const (
	// HostIsolationModeHyperV Indicates the ContainerHost is a Hyper-V container. This applies to only Windows
	// containers. The value is 2.
	HostIsolationModeHyperV HostIsolationMode = "HyperV"
	// HostIsolationModeNone Indicates the isolation mode is not applicable for given HostType. The value is 0.
	HostIsolationModeNone HostIsolationMode = "None"
	// HostIsolationModeProcess This is the default isolation mode for a ContainerHost. The value is 1.
	HostIsolationModeProcess HostIsolationMode = "Process"
)

// PossibleHostIsolationModeValues returns an array of possible values for the HostIsolationMode const type.
func PossibleHostIsolationModeValues() []HostIsolationMode {
	return []HostIsolationMode{HostIsolationModeHyperV, HostIsolationModeNone, HostIsolationModeProcess}
}

// HostType enumerates the values for host type.
type HostType string

const (
	// HostTypeContainerHost Indicates the host is a container. The value is 2.
	HostTypeContainerHost HostType = "ContainerHost"
	// HostTypeExeHost Indicates the host is an executable. The value is 1.
	HostTypeExeHost HostType = "ExeHost"
	// HostTypeInvalid Indicates the type of host is not known or invalid. The value is 0.
	HostTypeInvalid HostType = "Invalid"
)

// PossibleHostTypeValues returns an array of possible values for the HostType const type.
func PossibleHostTypeValues() []HostType {
	return []HostType{HostTypeContainerHost, HostTypeExeHost, HostTypeInvalid}
}

// ImpactLevel enumerates the values for impact level.
type ImpactLevel string

const (
	// ImpactLevelInvalid ...
	ImpactLevelInvalid ImpactLevel = "Invalid"
	// ImpactLevelNone ...
	ImpactLevelNone ImpactLevel = "None"
	// ImpactLevelRemoveData ...
	ImpactLevelRemoveData ImpactLevel = "RemoveData"
	// ImpactLevelRemoveNode ...
	ImpactLevelRemoveNode ImpactLevel = "RemoveNode"
	// ImpactLevelRestart ...
	ImpactLevelRestart ImpactLevel = "Restart"
)

// PossibleImpactLevelValues returns an array of possible values for the ImpactLevel const type.
func PossibleImpactLevelValues() []ImpactLevel {
	return []ImpactLevel{ImpactLevelInvalid, ImpactLevelNone, ImpactLevelRemoveData, ImpactLevelRemoveNode, ImpactLevelRestart}
}

// Kind enumerates the values for kind.
type Kind string

const (
	// KindApplication ...
	KindApplication Kind = "Application"
	// KindApplications ...
	KindApplications Kind = "Applications"
	// KindApplicationTypeApplications ...
	KindApplicationTypeApplications Kind = "ApplicationTypeApplications"
	// KindDeltaNodesCheck ...
	KindDeltaNodesCheck Kind = "DeltaNodesCheck"
	// KindDeployedApplication ...
	KindDeployedApplication Kind = "DeployedApplication"
	// KindDeployedApplications ...
	KindDeployedApplications Kind = "DeployedApplications"
	// KindDeployedServicePackage ...
	KindDeployedServicePackage Kind = "DeployedServicePackage"
	// KindDeployedServicePackages ...
	KindDeployedServicePackages Kind = "DeployedServicePackages"
	// KindEvent ...
	KindEvent Kind = "Event"
	// KindHealthEvaluation ...
	KindHealthEvaluation Kind = "HealthEvaluation"
	// KindNode ...
	KindNode Kind = "Node"
	// KindNodes ...
	KindNodes Kind = "Nodes"
	// KindPartition ...
	KindPartition Kind = "Partition"
	// KindPartitions ...
	KindPartitions Kind = "Partitions"
	// KindReplica ...
	KindReplica Kind = "Replica"
	// KindReplicas ...
	KindReplicas Kind = "Replicas"
	// KindService ...
	KindService Kind = "Service"
	// KindServices ...
	KindServices Kind = "Services"
	// KindSystemApplication ...
	KindSystemApplication Kind = "SystemApplication"
	// KindUpgradeDomainDeltaNodesCheck ...
	KindUpgradeDomainDeltaNodesCheck Kind = "UpgradeDomainDeltaNodesCheck"
	// KindUpgradeDomainNodes ...
	KindUpgradeDomainNodes Kind = "UpgradeDomainNodes"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{KindApplication, KindApplications, KindApplicationTypeApplications, KindDeltaNodesCheck, KindDeployedApplication, KindDeployedApplications, KindDeployedServicePackage, KindDeployedServicePackages, KindEvent, KindHealthEvaluation, KindNode, KindNodes, KindPartition, KindPartitions, KindReplica, KindReplicas, KindService, KindServices, KindSystemApplication, KindUpgradeDomainDeltaNodesCheck, KindUpgradeDomainNodes}
}

// KindBasicBackupConfigurationInfo enumerates the values for kind basic backup configuration info.
type KindBasicBackupConfigurationInfo string

const (
	// KindBasicBackupConfigurationInfoKindApplication ...
	KindBasicBackupConfigurationInfoKindApplication KindBasicBackupConfigurationInfo = "Application"
	// KindBasicBackupConfigurationInfoKindBackupConfigurationInfo ...
	KindBasicBackupConfigurationInfoKindBackupConfigurationInfo KindBasicBackupConfigurationInfo = "BackupConfigurationInfo"
	// KindBasicBackupConfigurationInfoKindPartition ...
	KindBasicBackupConfigurationInfoKindPartition KindBasicBackupConfigurationInfo = "Partition"
	// KindBasicBackupConfigurationInfoKindService ...
	KindBasicBackupConfigurationInfoKindService KindBasicBackupConfigurationInfo = "Service"
)

// PossibleKindBasicBackupConfigurationInfoValues returns an array of possible values for the KindBasicBackupConfigurationInfo const type.
func PossibleKindBasicBackupConfigurationInfoValues() []KindBasicBackupConfigurationInfo {
	return []KindBasicBackupConfigurationInfo{KindBasicBackupConfigurationInfoKindApplication, KindBasicBackupConfigurationInfoKindBackupConfigurationInfo, KindBasicBackupConfigurationInfoKindPartition, KindBasicBackupConfigurationInfoKindService}
}

// KindBasicChaosEvent enumerates the values for kind basic chaos event.
type KindBasicChaosEvent string

const (
	// KindChaosEvent ...
	KindChaosEvent KindBasicChaosEvent = "ChaosEvent"
	// KindExecutingFaults ...
	KindExecutingFaults KindBasicChaosEvent = "ExecutingFaults"
	// KindStarted ...
	KindStarted KindBasicChaosEvent = "Started"
	// KindStopped ...
	KindStopped KindBasicChaosEvent = "Stopped"
	// KindTestError ...
	KindTestError KindBasicChaosEvent = "TestError"
	// KindValidationFailed ...
	KindValidationFailed KindBasicChaosEvent = "ValidationFailed"
	// KindWaiting ...
	KindWaiting KindBasicChaosEvent = "Waiting"
)

// PossibleKindBasicChaosEventValues returns an array of possible values for the KindBasicChaosEvent const type.
func PossibleKindBasicChaosEventValues() []KindBasicChaosEvent {
	return []KindBasicChaosEvent{KindChaosEvent, KindExecutingFaults, KindStarted, KindStopped, KindTestError, KindValidationFailed, KindWaiting}
}

// KindBasicDiagnosticsSinkProperties enumerates the values for kind basic diagnostics sink properties.
type KindBasicDiagnosticsSinkProperties string

const (
	// KindDiagnosticsSinkProperties ...
	KindDiagnosticsSinkProperties KindBasicDiagnosticsSinkProperties = "DiagnosticsSinkProperties"
)

// PossibleKindBasicDiagnosticsSinkPropertiesValues returns an array of possible values for the KindBasicDiagnosticsSinkProperties const type.
func PossibleKindBasicDiagnosticsSinkPropertiesValues() []KindBasicDiagnosticsSinkProperties {
	return []KindBasicDiagnosticsSinkProperties{KindDiagnosticsSinkProperties}
}

// KindBasicFabricEvent enumerates the values for kind basic fabric event.
type KindBasicFabricEvent string

const (
	// KindApplicationCreated ...
	KindApplicationCreated KindBasicFabricEvent = "ApplicationCreated"
	// KindApplicationDeleted ...
	KindApplicationDeleted KindBasicFabricEvent = "ApplicationDeleted"
	// KindApplicationEvent ...
	KindApplicationEvent KindBasicFabricEvent = "ApplicationEvent"
	// KindApplicationHealthReportCreated ...
	KindApplicationHealthReportCreated KindBasicFabricEvent = "ApplicationHealthReportCreated"
	// KindApplicationHealthReportExpired ...
	KindApplicationHealthReportExpired KindBasicFabricEvent = "ApplicationHealthReportExpired"
	// KindApplicationUpgradeComplete ...
	KindApplicationUpgradeComplete KindBasicFabricEvent = "ApplicationUpgradeComplete"
	// KindApplicationUpgradeDomainComplete ...
	KindApplicationUpgradeDomainComplete KindBasicFabricEvent = "ApplicationUpgradeDomainComplete"
	// KindApplicationUpgradeRollbackComplete ...
	KindApplicationUpgradeRollbackComplete KindBasicFabricEvent = "ApplicationUpgradeRollbackComplete"
	// KindApplicationUpgradeRollbackStart ...
	KindApplicationUpgradeRollbackStart KindBasicFabricEvent = "ApplicationUpgradeRollbackStart"
	// KindApplicationUpgradeStart ...
	KindApplicationUpgradeStart KindBasicFabricEvent = "ApplicationUpgradeStart"
	// KindChaosMovePrimaryFaultScheduled ...
	KindChaosMovePrimaryFaultScheduled KindBasicFabricEvent = "ChaosMovePrimaryFaultScheduled"
	// KindChaosMoveSecondaryFaultScheduled ...
	KindChaosMoveSecondaryFaultScheduled KindBasicFabricEvent = "ChaosMoveSecondaryFaultScheduled"
	// KindChaosRemoveReplicaFaultCompleted ...
	KindChaosRemoveReplicaFaultCompleted KindBasicFabricEvent = "ChaosRemoveReplicaFaultCompleted"
	// KindChaosRemoveReplicaFaultScheduled ...
	KindChaosRemoveReplicaFaultScheduled KindBasicFabricEvent = "ChaosRemoveReplicaFaultScheduled"
	// KindChaosRestartCodePackageFaultCompleted ...
	KindChaosRestartCodePackageFaultCompleted KindBasicFabricEvent = "ChaosRestartCodePackageFaultCompleted"
	// KindChaosRestartCodePackageFaultScheduled ...
	KindChaosRestartCodePackageFaultScheduled KindBasicFabricEvent = "ChaosRestartCodePackageFaultScheduled"
	// KindChaosRestartNodeFaultCompleted ...
	KindChaosRestartNodeFaultCompleted KindBasicFabricEvent = "ChaosRestartNodeFaultCompleted"
	// KindChaosRestartNodeFaultScheduled ...
	KindChaosRestartNodeFaultScheduled KindBasicFabricEvent = "ChaosRestartNodeFaultScheduled"
	// KindChaosRestartReplicaFaultScheduled ...
	KindChaosRestartReplicaFaultScheduled KindBasicFabricEvent = "ChaosRestartReplicaFaultScheduled"
	// KindChaosStarted ...
	KindChaosStarted KindBasicFabricEvent = "ChaosStarted"
	// KindChaosStopped ...
	KindChaosStopped KindBasicFabricEvent = "ChaosStopped"
	// KindClusterEvent ...
	KindClusterEvent KindBasicFabricEvent = "ClusterEvent"
	// KindClusterHealthReportCreated ...
	KindClusterHealthReportCreated KindBasicFabricEvent = "ClusterHealthReportCreated"
	// KindClusterHealthReportExpired ...
	KindClusterHealthReportExpired KindBasicFabricEvent = "ClusterHealthReportExpired"
	// KindClusterUpgradeComplete ...
	KindClusterUpgradeComplete KindBasicFabricEvent = "ClusterUpgradeComplete"
	// KindClusterUpgradeDomainComplete ...
	KindClusterUpgradeDomainComplete KindBasicFabricEvent = "ClusterUpgradeDomainComplete"
	// KindClusterUpgradeRollbackComplete ...
	KindClusterUpgradeRollbackComplete KindBasicFabricEvent = "ClusterUpgradeRollbackComplete"
	// KindClusterUpgradeRollbackStart ...
	KindClusterUpgradeRollbackStart KindBasicFabricEvent = "ClusterUpgradeRollbackStart"
	// KindClusterUpgradeStart ...
	KindClusterUpgradeStart KindBasicFabricEvent = "ClusterUpgradeStart"
	// KindContainerDeactivated ...
	KindContainerDeactivated KindBasicFabricEvent = "ContainerDeactivated"
	// KindContainerInstanceEvent ...
	KindContainerInstanceEvent KindBasicFabricEvent = "ContainerInstanceEvent"
	// KindDeployedApplicationHealthReportCreated ...
	KindDeployedApplicationHealthReportCreated KindBasicFabricEvent = "DeployedApplicationHealthReportCreated"
	// KindDeployedApplicationHealthReportExpired ...
	KindDeployedApplicationHealthReportExpired KindBasicFabricEvent = "DeployedApplicationHealthReportExpired"
	// KindDeployedServiceHealthReportCreated ...
	KindDeployedServiceHealthReportCreated KindBasicFabricEvent = "DeployedServiceHealthReportCreated"
	// KindDeployedServiceHealthReportExpired ...
	KindDeployedServiceHealthReportExpired KindBasicFabricEvent = "DeployedServiceHealthReportExpired"
	// KindFabricEvent ...
	KindFabricEvent KindBasicFabricEvent = "FabricEvent"
	// KindNodeAborted ...
	KindNodeAborted KindBasicFabricEvent = "NodeAborted"
	// KindNodeAborting ...
	KindNodeAborting KindBasicFabricEvent = "NodeAborting"
	// KindNodeAdded ...
	KindNodeAdded KindBasicFabricEvent = "NodeAdded"
	// KindNodeClose ...
	KindNodeClose KindBasicFabricEvent = "NodeClose"
	// KindNodeClosing ...
	KindNodeClosing KindBasicFabricEvent = "NodeClosing"
	// KindNodeDeactivateComplete ...
	KindNodeDeactivateComplete KindBasicFabricEvent = "NodeDeactivateComplete"
	// KindNodeDeactivateStart ...
	KindNodeDeactivateStart KindBasicFabricEvent = "NodeDeactivateStart"
	// KindNodeDown ...
	KindNodeDown KindBasicFabricEvent = "NodeDown"
	// KindNodeEvent ...
	KindNodeEvent KindBasicFabricEvent = "NodeEvent"
	// KindNodeHealthReportCreated ...
	KindNodeHealthReportCreated KindBasicFabricEvent = "NodeHealthReportCreated"
	// KindNodeHealthReportExpired ...
	KindNodeHealthReportExpired KindBasicFabricEvent = "NodeHealthReportExpired"
	// KindNodeOpenedSuccess ...
	KindNodeOpenedSuccess KindBasicFabricEvent = "NodeOpenedSuccess"
	// KindNodeOpenFailed ...
	KindNodeOpenFailed KindBasicFabricEvent = "NodeOpenFailed"
	// KindNodeOpening ...
	KindNodeOpening KindBasicFabricEvent = "NodeOpening"
	// KindNodeRemoved ...
	KindNodeRemoved KindBasicFabricEvent = "NodeRemoved"
	// KindNodeUp ...
	KindNodeUp KindBasicFabricEvent = "NodeUp"
	// KindPartitionAnalysisEvent ...
	KindPartitionAnalysisEvent KindBasicFabricEvent = "PartitionAnalysisEvent"
	// KindPartitionEvent ...
	KindPartitionEvent KindBasicFabricEvent = "PartitionEvent"
	// KindPartitionHealthReportCreated ...
	KindPartitionHealthReportCreated KindBasicFabricEvent = "PartitionHealthReportCreated"
	// KindPartitionHealthReportExpired ...
	KindPartitionHealthReportExpired KindBasicFabricEvent = "PartitionHealthReportExpired"
	// KindPartitionPrimaryMoveAnalysis ...
	KindPartitionPrimaryMoveAnalysis KindBasicFabricEvent = "PartitionPrimaryMoveAnalysis"
	// KindPartitionReconfigurationCompleted ...
	KindPartitionReconfigurationCompleted KindBasicFabricEvent = "PartitionReconfigurationCompleted"
	// KindProcessDeactivated ...
	KindProcessDeactivated KindBasicFabricEvent = "ProcessDeactivated"
	// KindReplicaEvent ...
	KindReplicaEvent KindBasicFabricEvent = "ReplicaEvent"
	// KindServiceCreated ...
	KindServiceCreated KindBasicFabricEvent = "ServiceCreated"
	// KindServiceDeleted ...
	KindServiceDeleted KindBasicFabricEvent = "ServiceDeleted"
	// KindServiceEvent ...
	KindServiceEvent KindBasicFabricEvent = "ServiceEvent"
	// KindServiceHealthReportCreated ...
	KindServiceHealthReportCreated KindBasicFabricEvent = "ServiceHealthReportCreated"
	// KindServiceHealthReportExpired ...
	KindServiceHealthReportExpired KindBasicFabricEvent = "ServiceHealthReportExpired"
	// KindStatefulReplicaHealthReportCreated ...
	KindStatefulReplicaHealthReportCreated KindBasicFabricEvent = "StatefulReplicaHealthReportCreated"
	// KindStatefulReplicaHealthReportExpired ...
	KindStatefulReplicaHealthReportExpired KindBasicFabricEvent = "StatefulReplicaHealthReportExpired"
	// KindStatelessReplicaHealthReportCreated ...
	KindStatelessReplicaHealthReportCreated KindBasicFabricEvent = "StatelessReplicaHealthReportCreated"
	// KindStatelessReplicaHealthReportExpired ...
	KindStatelessReplicaHealthReportExpired KindBasicFabricEvent = "StatelessReplicaHealthReportExpired"
)

// PossibleKindBasicFabricEventValues returns an array of possible values for the KindBasicFabricEvent const type.
func PossibleKindBasicFabricEventValues() []KindBasicFabricEvent {
	return []KindBasicFabricEvent{KindApplicationCreated, KindApplicationDeleted, KindApplicationEvent, KindApplicationHealthReportCreated, KindApplicationHealthReportExpired, KindApplicationUpgradeComplete, KindApplicationUpgradeDomainComplete, KindApplicationUpgradeRollbackComplete, KindApplicationUpgradeRollbackStart, KindApplicationUpgradeStart, KindChaosMovePrimaryFaultScheduled, KindChaosMoveSecondaryFaultScheduled, KindChaosRemoveReplicaFaultCompleted, KindChaosRemoveReplicaFaultScheduled, KindChaosRestartCodePackageFaultCompleted, KindChaosRestartCodePackageFaultScheduled, KindChaosRestartNodeFaultCompleted, KindChaosRestartNodeFaultScheduled, KindChaosRestartReplicaFaultScheduled, KindChaosStarted, KindChaosStopped, KindClusterEvent, KindClusterHealthReportCreated, KindClusterHealthReportExpired, KindClusterUpgradeComplete, KindClusterUpgradeDomainComplete, KindClusterUpgradeRollbackComplete, KindClusterUpgradeRollbackStart, KindClusterUpgradeStart, KindContainerDeactivated, KindContainerInstanceEvent, KindDeployedApplicationHealthReportCreated, KindDeployedApplicationHealthReportExpired, KindDeployedServiceHealthReportCreated, KindDeployedServiceHealthReportExpired, KindFabricEvent, KindNodeAborted, KindNodeAborting, KindNodeAdded, KindNodeClose, KindNodeClosing, KindNodeDeactivateComplete, KindNodeDeactivateStart, KindNodeDown, KindNodeEvent, KindNodeHealthReportCreated, KindNodeHealthReportExpired, KindNodeOpenedSuccess, KindNodeOpenFailed, KindNodeOpening, KindNodeRemoved, KindNodeUp, KindPartitionAnalysisEvent, KindPartitionEvent, KindPartitionHealthReportCreated, KindPartitionHealthReportExpired, KindPartitionPrimaryMoveAnalysis, KindPartitionReconfigurationCompleted, KindProcessDeactivated, KindReplicaEvent, KindServiceCreated, KindServiceDeleted, KindServiceEvent, KindServiceHealthReportCreated, KindServiceHealthReportExpired, KindStatefulReplicaHealthReportCreated, KindStatefulReplicaHealthReportExpired, KindStatelessReplicaHealthReportCreated, KindStatelessReplicaHealthReportExpired}
}

// KindBasicPropertyBatchInfo enumerates the values for kind basic property batch info.
type KindBasicPropertyBatchInfo string

const (
	// KindFailed ...
	KindFailed KindBasicPropertyBatchInfo = "Failed"
	// KindPropertyBatchInfo ...
	KindPropertyBatchInfo KindBasicPropertyBatchInfo = "PropertyBatchInfo"
	// KindSuccessful ...
	KindSuccessful KindBasicPropertyBatchInfo = "Successful"
)

// PossibleKindBasicPropertyBatchInfoValues returns an array of possible values for the KindBasicPropertyBatchInfo const type.
func PossibleKindBasicPropertyBatchInfoValues() []KindBasicPropertyBatchInfo {
	return []KindBasicPropertyBatchInfo{KindFailed, KindPropertyBatchInfo, KindSuccessful}
}

// KindBasicPropertyBatchOperation enumerates the values for kind basic property batch operation.
type KindBasicPropertyBatchOperation string

const (
	// KindCheckExists ...
	KindCheckExists KindBasicPropertyBatchOperation = "CheckExists"
	// KindCheckSequence ...
	KindCheckSequence KindBasicPropertyBatchOperation = "CheckSequence"
	// KindCheckValue ...
	KindCheckValue KindBasicPropertyBatchOperation = "CheckValue"
	// KindDelete ...
	KindDelete KindBasicPropertyBatchOperation = "Delete"
	// KindGet ...
	KindGet KindBasicPropertyBatchOperation = "Get"
	// KindPropertyBatchOperation ...
	KindPropertyBatchOperation KindBasicPropertyBatchOperation = "PropertyBatchOperation"
	// KindPut ...
	KindPut KindBasicPropertyBatchOperation = "Put"
)

// PossibleKindBasicPropertyBatchOperationValues returns an array of possible values for the KindBasicPropertyBatchOperation const type.
func PossibleKindBasicPropertyBatchOperationValues() []KindBasicPropertyBatchOperation {
	return []KindBasicPropertyBatchOperation{KindCheckExists, KindCheckSequence, KindCheckValue, KindDelete, KindGet, KindPropertyBatchOperation, KindPut}
}

// KindBasicPropertyValue enumerates the values for kind basic property value.
type KindBasicPropertyValue string

const (
	// KindBinary ...
	KindBinary KindBasicPropertyValue = "Binary"
	// KindDouble ...
	KindDouble KindBasicPropertyValue = "Double"
	// KindGUID ...
	KindGUID KindBasicPropertyValue = "Guid"
	// KindInt64 ...
	KindInt64 KindBasicPropertyValue = "Int64"
	// KindPropertyValue ...
	KindPropertyValue KindBasicPropertyValue = "PropertyValue"
	// KindString ...
	KindString KindBasicPropertyValue = "String"
)

// PossibleKindBasicPropertyValueValues returns an array of possible values for the KindBasicPropertyValue const type.
func PossibleKindBasicPropertyValueValues() []KindBasicPropertyValue {
	return []KindBasicPropertyValue{KindBinary, KindDouble, KindGUID, KindInt64, KindPropertyValue, KindString}
}

// KindBasicProvisionApplicationTypeDescriptionBase enumerates the values for kind basic provision application
// type description base.
type KindBasicProvisionApplicationTypeDescriptionBase string

const (
	// KindExternalStore ...
	KindExternalStore KindBasicProvisionApplicationTypeDescriptionBase = "ExternalStore"
	// KindImageStorePath ...
	KindImageStorePath KindBasicProvisionApplicationTypeDescriptionBase = "ImageStorePath"
	// KindProvisionApplicationTypeDescriptionBase ...
	KindProvisionApplicationTypeDescriptionBase KindBasicProvisionApplicationTypeDescriptionBase = "ProvisionApplicationTypeDescriptionBase"
)

// PossibleKindBasicProvisionApplicationTypeDescriptionBaseValues returns an array of possible values for the KindBasicProvisionApplicationTypeDescriptionBase const type.
func PossibleKindBasicProvisionApplicationTypeDescriptionBaseValues() []KindBasicProvisionApplicationTypeDescriptionBase {
	return []KindBasicProvisionApplicationTypeDescriptionBase{KindExternalStore, KindImageStorePath, KindProvisionApplicationTypeDescriptionBase}
}

// KindBasicRepairImpactDescriptionBase enumerates the values for kind basic repair impact description base.
type KindBasicRepairImpactDescriptionBase string

const (
	// KindBasicRepairImpactDescriptionBaseKindNode ...
	KindBasicRepairImpactDescriptionBaseKindNode KindBasicRepairImpactDescriptionBase = "Node"
	// KindBasicRepairImpactDescriptionBaseKindRepairImpactDescriptionBase ...
	KindBasicRepairImpactDescriptionBaseKindRepairImpactDescriptionBase KindBasicRepairImpactDescriptionBase = "RepairImpactDescriptionBase"
)

// PossibleKindBasicRepairImpactDescriptionBaseValues returns an array of possible values for the KindBasicRepairImpactDescriptionBase const type.
func PossibleKindBasicRepairImpactDescriptionBaseValues() []KindBasicRepairImpactDescriptionBase {
	return []KindBasicRepairImpactDescriptionBase{KindBasicRepairImpactDescriptionBaseKindNode, KindBasicRepairImpactDescriptionBaseKindRepairImpactDescriptionBase}
}

// KindBasicRepairTargetDescriptionBase enumerates the values for kind basic repair target description base.
type KindBasicRepairTargetDescriptionBase string

const (
	// KindBasicRepairTargetDescriptionBaseKindNode ...
	KindBasicRepairTargetDescriptionBaseKindNode KindBasicRepairTargetDescriptionBase = "Node"
	// KindBasicRepairTargetDescriptionBaseKindRepairTargetDescriptionBase ...
	KindBasicRepairTargetDescriptionBaseKindRepairTargetDescriptionBase KindBasicRepairTargetDescriptionBase = "RepairTargetDescriptionBase"
)

// PossibleKindBasicRepairTargetDescriptionBaseValues returns an array of possible values for the KindBasicRepairTargetDescriptionBase const type.
func PossibleKindBasicRepairTargetDescriptionBaseValues() []KindBasicRepairTargetDescriptionBase {
	return []KindBasicRepairTargetDescriptionBase{KindBasicRepairTargetDescriptionBaseKindNode, KindBasicRepairTargetDescriptionBaseKindRepairTargetDescriptionBase}
}

// KindBasicReplicaStatusBase enumerates the values for kind basic replica status base.
type KindBasicReplicaStatusBase string

const (
	// KindKeyValueStore ...
	KindKeyValueStore KindBasicReplicaStatusBase = "KeyValueStore"
	// KindReplicaStatusBase ...
	KindReplicaStatusBase KindBasicReplicaStatusBase = "ReplicaStatusBase"
)

// PossibleKindBasicReplicaStatusBaseValues returns an array of possible values for the KindBasicReplicaStatusBase const type.
func PossibleKindBasicReplicaStatusBaseValues() []KindBasicReplicaStatusBase {
	return []KindBasicReplicaStatusBase{KindKeyValueStore, KindReplicaStatusBase}
}

// KindBasicReplicatorStatus enumerates the values for kind basic replicator status.
type KindBasicReplicatorStatus string

const (
	// KindActiveSecondary ...
	KindActiveSecondary KindBasicReplicatorStatus = "ActiveSecondary"
	// KindIdleSecondary ...
	KindIdleSecondary KindBasicReplicatorStatus = "IdleSecondary"
	// KindPrimary ...
	KindPrimary KindBasicReplicatorStatus = "Primary"
	// KindReplicatorStatus ...
	KindReplicatorStatus KindBasicReplicatorStatus = "ReplicatorStatus"
	// KindSecondaryReplicatorStatus ...
	KindSecondaryReplicatorStatus KindBasicReplicatorStatus = "SecondaryReplicatorStatus"
)

// PossibleKindBasicReplicatorStatusValues returns an array of possible values for the KindBasicReplicatorStatus const type.
func PossibleKindBasicReplicatorStatusValues() []KindBasicReplicatorStatus {
	return []KindBasicReplicatorStatus{KindActiveSecondary, KindIdleSecondary, KindPrimary, KindReplicatorStatus, KindSecondaryReplicatorStatus}
}

// KindBasicSafetyCheck enumerates the values for kind basic safety check.
type KindBasicSafetyCheck string

const (
	// KindEnsureAvailability ...
	KindEnsureAvailability KindBasicSafetyCheck = "EnsureAvailability"
	// KindEnsurePartitionQuorum ...
	KindEnsurePartitionQuorum KindBasicSafetyCheck = "EnsurePartitionQuorum"
	// KindEnsureSeedNodeQuorum ...
	KindEnsureSeedNodeQuorum KindBasicSafetyCheck = "EnsureSeedNodeQuorum"
	// KindPartitionSafetyCheck ...
	KindPartitionSafetyCheck KindBasicSafetyCheck = "PartitionSafetyCheck"
	// KindSafetyCheck ...
	KindSafetyCheck KindBasicSafetyCheck = "SafetyCheck"
	// KindWaitForInbuildReplica ...
	KindWaitForInbuildReplica KindBasicSafetyCheck = "WaitForInbuildReplica"
	// KindWaitForPrimaryPlacement ...
	KindWaitForPrimaryPlacement KindBasicSafetyCheck = "WaitForPrimaryPlacement"
	// KindWaitForPrimarySwap ...
	KindWaitForPrimarySwap KindBasicSafetyCheck = "WaitForPrimarySwap"
	// KindWaitForReconfiguration ...
	KindWaitForReconfiguration KindBasicSafetyCheck = "WaitForReconfiguration"
)

// PossibleKindBasicSafetyCheckValues returns an array of possible values for the KindBasicSafetyCheck const type.
func PossibleKindBasicSafetyCheckValues() []KindBasicSafetyCheck {
	return []KindBasicSafetyCheck{KindEnsureAvailability, KindEnsurePartitionQuorum, KindEnsureSeedNodeQuorum, KindPartitionSafetyCheck, KindSafetyCheck, KindWaitForInbuildReplica, KindWaitForPrimaryPlacement, KindWaitForPrimarySwap, KindWaitForReconfiguration}
}

// KindBasicScalingMechanismDescription enumerates the values for kind basic scaling mechanism description.
type KindBasicScalingMechanismDescription string

const (
	// KindAddRemoveIncrementalNamedPartition ...
	KindAddRemoveIncrementalNamedPartition KindBasicScalingMechanismDescription = "AddRemoveIncrementalNamedPartition"
	// KindPartitionInstanceCount ...
	KindPartitionInstanceCount KindBasicScalingMechanismDescription = "PartitionInstanceCount"
	// KindScalingMechanismDescription ...
	KindScalingMechanismDescription KindBasicScalingMechanismDescription = "ScalingMechanismDescription"
)

// PossibleKindBasicScalingMechanismDescriptionValues returns an array of possible values for the KindBasicScalingMechanismDescription const type.
func PossibleKindBasicScalingMechanismDescriptionValues() []KindBasicScalingMechanismDescription {
	return []KindBasicScalingMechanismDescription{KindAddRemoveIncrementalNamedPartition, KindPartitionInstanceCount, KindScalingMechanismDescription}
}

// KindBasicScalingTriggerDescription enumerates the values for kind basic scaling trigger description.
type KindBasicScalingTriggerDescription string

const (
	// KindAveragePartitionLoad ...
	KindAveragePartitionLoad KindBasicScalingTriggerDescription = "AveragePartitionLoad"
	// KindAverageServiceLoad ...
	KindAverageServiceLoad KindBasicScalingTriggerDescription = "AverageServiceLoad"
	// KindScalingTriggerDescription ...
	KindScalingTriggerDescription KindBasicScalingTriggerDescription = "ScalingTriggerDescription"
)

// PossibleKindBasicScalingTriggerDescriptionValues returns an array of possible values for the KindBasicScalingTriggerDescription const type.
func PossibleKindBasicScalingTriggerDescriptionValues() []KindBasicScalingTriggerDescription {
	return []KindBasicScalingTriggerDescription{KindAveragePartitionLoad, KindAverageServiceLoad, KindScalingTriggerDescription}
}

// KindBasicServiceTypeDescription enumerates the values for kind basic service type description.
type KindBasicServiceTypeDescription string

const (
	// KindServiceTypeDescription ...
	KindServiceTypeDescription KindBasicServiceTypeDescription = "ServiceTypeDescription"
	// KindStateful ...
	KindStateful KindBasicServiceTypeDescription = "Stateful"
	// KindStateless ...
	KindStateless KindBasicServiceTypeDescription = "Stateless"
)

// PossibleKindBasicServiceTypeDescriptionValues returns an array of possible values for the KindBasicServiceTypeDescription const type.
func PossibleKindBasicServiceTypeDescriptionValues() []KindBasicServiceTypeDescription {
	return []KindBasicServiceTypeDescription{KindServiceTypeDescription, KindStateful, KindStateless}
}

// MoveCost enumerates the values for move cost.
type MoveCost string

const (
	// High Specifies the move cost of the service as High. The value is 3.
	High MoveCost = "High"
	// Low Specifies the move cost of the service as Low. The value is 1.
	Low MoveCost = "Low"
	// Medium Specifies the move cost of the service as Medium. The value is 2.
	Medium MoveCost = "Medium"
	// Zero Zero move cost. This value is zero.
	Zero MoveCost = "Zero"
)

// PossibleMoveCostValues returns an array of possible values for the MoveCost const type.
func PossibleMoveCostValues() []MoveCost {
	return []MoveCost{High, Low, Medium, Zero}
}

// NodeDeactivationIntent enumerates the values for node deactivation intent.
type NodeDeactivationIntent string

const (
	// NodeDeactivationIntentInvalid Indicates the node deactivation intent is invalid. All Service Fabric
	// enumerations have the invalid type. The value is zero. This value is not used.
	NodeDeactivationIntentInvalid NodeDeactivationIntent = "Invalid"
	// NodeDeactivationIntentPause Indicates that the node should be paused. The value is 1.
	NodeDeactivationIntentPause NodeDeactivationIntent = "Pause"
	// NodeDeactivationIntentRemoveData Indicates that the intent is to reimage the node. Service Fabric does
	// not reimage the node, this action is done outside of Service Fabric. The value is 3.
	NodeDeactivationIntentRemoveData NodeDeactivationIntent = "RemoveData"
	// NodeDeactivationIntentRemoveNode Indicates that the node is being decommissioned and is not expected to
	// return. Service Fabric does not decommission the node, this action is done outside of Service Fabric.
	// The value is 4.
	NodeDeactivationIntentRemoveNode NodeDeactivationIntent = "RemoveNode"
	// NodeDeactivationIntentRestart Indicates that the intent is for the node to be restarted after a short
	// period of time. Service Fabric does not restart the node, this action is done outside of Service Fabric.
	// The value is 2.
	NodeDeactivationIntentRestart NodeDeactivationIntent = "Restart"
)

// PossibleNodeDeactivationIntentValues returns an array of possible values for the NodeDeactivationIntent const type.
func PossibleNodeDeactivationIntentValues() []NodeDeactivationIntent {
	return []NodeDeactivationIntent{NodeDeactivationIntentInvalid, NodeDeactivationIntentPause, NodeDeactivationIntentRemoveData, NodeDeactivationIntentRemoveNode, NodeDeactivationIntentRestart}
}

// NodeDeactivationStatus enumerates the values for node deactivation status.
type NodeDeactivationStatus string

const (
	// NodeDeactivationStatusCompleted The task is completed. The value is 3.
	NodeDeactivationStatusCompleted NodeDeactivationStatus = "Completed"
	// NodeDeactivationStatusNone No status is associated with the task. The value is zero.
	NodeDeactivationStatusNone NodeDeactivationStatus = "None"
	// NodeDeactivationStatusSafetyCheckComplete When a node is deactivated Service Fabric performs checks to
	// ensure that the operation is safe to proceed to ensure availability of the service and reliability of
	// the state. This value indicates that all safety checks have been completed. The value is 2.
	NodeDeactivationStatusSafetyCheckComplete NodeDeactivationStatus = "SafetyCheckComplete"
	// NodeDeactivationStatusSafetyCheckInProgress When a node is deactivated Service Fabric performs checks to
	// ensure that the operation is safe to proceed to ensure availability of the service and reliability of
	// the state. This value indicates that one or more safety checks are in progress. The value is 1.
	NodeDeactivationStatusSafetyCheckInProgress NodeDeactivationStatus = "SafetyCheckInProgress"
)

// PossibleNodeDeactivationStatusValues returns an array of possible values for the NodeDeactivationStatus const type.
func PossibleNodeDeactivationStatusValues() []NodeDeactivationStatus {
	return []NodeDeactivationStatus{NodeDeactivationStatusCompleted, NodeDeactivationStatusNone, NodeDeactivationStatusSafetyCheckComplete, NodeDeactivationStatusSafetyCheckInProgress}
}

// NodeDeactivationTaskType enumerates the values for node deactivation task type.
type NodeDeactivationTaskType string

const (
	// NodeDeactivationTaskTypeClient Specifies that the task was created by using the public API. The value is
	// 3.
	NodeDeactivationTaskTypeClient NodeDeactivationTaskType = "Client"
	// NodeDeactivationTaskTypeInfrastructure Specifies the task created by Infrastructure hosting the nodes.
	// The value is 1.
	NodeDeactivationTaskTypeInfrastructure NodeDeactivationTaskType = "Infrastructure"
	// NodeDeactivationTaskTypeInvalid Indicates the node deactivation task type is invalid. All Service Fabric
	// enumerations have the invalid type. The value is zero. This value is not used.
	NodeDeactivationTaskTypeInvalid NodeDeactivationTaskType = "Invalid"
	// NodeDeactivationTaskTypeRepair Specifies the task that was created by the Repair Manager service. The
	// value is 2.
	NodeDeactivationTaskTypeRepair NodeDeactivationTaskType = "Repair"
)

// PossibleNodeDeactivationTaskTypeValues returns an array of possible values for the NodeDeactivationTaskType const type.
func PossibleNodeDeactivationTaskTypeValues() []NodeDeactivationTaskType {
	return []NodeDeactivationTaskType{NodeDeactivationTaskTypeClient, NodeDeactivationTaskTypeInfrastructure, NodeDeactivationTaskTypeInvalid, NodeDeactivationTaskTypeRepair}
}

// NodeStatus enumerates the values for node status.
type NodeStatus string

const (
	// NodeStatusDisabled Indicates the node is disabled. The value is 5.
	NodeStatusDisabled NodeStatus = "Disabled"
	// NodeStatusDisabling Indicates the node is in the process of being disabled. The value is 4.
	NodeStatusDisabling NodeStatus = "Disabling"
	// NodeStatusDown Indicates the node is down. The value is 2.
	NodeStatusDown NodeStatus = "Down"
	// NodeStatusEnabling Indicates the node is in process of being enabled. The value is 3.
	NodeStatusEnabling NodeStatus = "Enabling"
	// NodeStatusInvalid Indicates the node status is invalid. All Service Fabric enumerations have the invalid
	// type. The value is zero.
	NodeStatusInvalid NodeStatus = "Invalid"
	// NodeStatusRemoved Indicates the node is removed. A node would be in Removed state if NodeStateRemoved
	// API has been called for this node. In other words, Service Fabric has been informed that the persisted
	// state on the node has been permanently lost. The value is 7.
	NodeStatusRemoved NodeStatus = "Removed"
	// NodeStatusUnknown Indicates the node is unknown. A node would be in Unknown state if Service Fabric does
	// not have authoritative information about that node. This can happen if the system learns about a node at
	// runtime.The value is 6.
	NodeStatusUnknown NodeStatus = "Unknown"
	// NodeStatusUp Indicates the node is up. The value is 1.
	NodeStatusUp NodeStatus = "Up"
)

// PossibleNodeStatusValues returns an array of possible values for the NodeStatus const type.
func PossibleNodeStatusValues() []NodeStatus {
	return []NodeStatus{NodeStatusDisabled, NodeStatusDisabling, NodeStatusDown, NodeStatusEnabling, NodeStatusInvalid, NodeStatusRemoved, NodeStatusUnknown, NodeStatusUp}
}

// NodeStatusFilter enumerates the values for node status filter.
type NodeStatusFilter string

const (
	// All This filter value will match all of the nodes.
	All NodeStatusFilter = "all"
	// Default This filter value will match all of the nodes excepts the ones with status as Unknown or
	// Removed.
	Default NodeStatusFilter = "default"
	// Disabled This filter value will match nodes that are Disabled.
	Disabled NodeStatusFilter = "disabled"
	// Disabling This filter value will match nodes that are in the process of being disabled with status as
	// Disabling.
	Disabling NodeStatusFilter = "disabling"
	// Down This filter value will match nodes that are Down.
	Down NodeStatusFilter = "down"
	// Enabling This filter value will match nodes that are in the process of being enabled with status as
	// Enabling.
	Enabling NodeStatusFilter = "enabling"
	// Removed This filter value will match nodes whose status is Removed. These are the nodes that are removed
	// from the cluster using the RemoveNodeState API.
	Removed NodeStatusFilter = "removed"
	// Unknown This filter value will match nodes whose status is Unknown. A node would be in Unknown state if
	// Service Fabric does not have authoritative information about that node. This can happen if the system
	// learns about a node at runtime.
	Unknown NodeStatusFilter = "unknown"
	// Up This filter value will match nodes that are Up.
	Up NodeStatusFilter = "up"
)

// PossibleNodeStatusFilterValues returns an array of possible values for the NodeStatusFilter const type.
func PossibleNodeStatusFilterValues() []NodeStatusFilter {
	return []NodeStatusFilter{All, Default, Disabled, Disabling, Down, Enabling, Removed, Unknown, Up}
}

// NodeTransitionType enumerates the values for node transition type.
type NodeTransitionType string

const (
	// NodeTransitionTypeInvalid Reserved.  Do not pass into API.
	NodeTransitionTypeInvalid NodeTransitionType = "Invalid"
	// NodeTransitionTypeStart Transition a stopped node to up.
	NodeTransitionTypeStart NodeTransitionType = "Start"
	// NodeTransitionTypeStop Transition an up node to stopped.
	NodeTransitionTypeStop NodeTransitionType = "Stop"
)

// PossibleNodeTransitionTypeValues returns an array of possible values for the NodeTransitionType const type.
func PossibleNodeTransitionTypeValues() []NodeTransitionType {
	return []NodeTransitionType{NodeTransitionTypeInvalid, NodeTransitionTypeStart, NodeTransitionTypeStop}
}

// NodeUpgradePhase enumerates the values for node upgrade phase.
type NodeUpgradePhase string

const (
	// NodeUpgradePhaseInvalid Indicates the upgrade state is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	NodeUpgradePhaseInvalid NodeUpgradePhase = "Invalid"
	// NodeUpgradePhasePostUpgradeSafetyCheck The upgrade has completed and post upgrade safety checks are
	// being performed. The value is 3
	NodeUpgradePhasePostUpgradeSafetyCheck NodeUpgradePhase = "PostUpgradeSafetyCheck"
	// NodeUpgradePhasePreUpgradeSafetyCheck The upgrade has not started yet due to pending safety checks. The
	// value is 1
	NodeUpgradePhasePreUpgradeSafetyCheck NodeUpgradePhase = "PreUpgradeSafetyCheck"
	// NodeUpgradePhaseUpgrading The upgrade is in progress. The value is 2
	NodeUpgradePhaseUpgrading NodeUpgradePhase = "Upgrading"
)

// PossibleNodeUpgradePhaseValues returns an array of possible values for the NodeUpgradePhase const type.
func PossibleNodeUpgradePhaseValues() []NodeUpgradePhase {
	return []NodeUpgradePhase{NodeUpgradePhaseInvalid, NodeUpgradePhasePostUpgradeSafetyCheck, NodeUpgradePhasePreUpgradeSafetyCheck, NodeUpgradePhaseUpgrading}
}

// OperatingSystemTypes enumerates the values for operating system types.
type OperatingSystemTypes string

const (
	// Linux ...
	Linux OperatingSystemTypes = "Linux"
	// Windows ...
	Windows OperatingSystemTypes = "Windows"
)

// PossibleOperatingSystemTypesValues returns an array of possible values for the OperatingSystemTypes const type.
func PossibleOperatingSystemTypesValues() []OperatingSystemTypes {
	return []OperatingSystemTypes{Linux, Windows}
}

// OperationState enumerates the values for operation state.
type OperationState string

const (
	// OperationStateCancelled The operation was cancelled by the user using CancelOperation, and is no longer
	// running.
	OperationStateCancelled OperationState = "Cancelled"
	// OperationStateCompleted The operation has completed successfully and is no longer running.
	OperationStateCompleted OperationState = "Completed"
	// OperationStateFaulted The operation has failed and is no longer running.
	OperationStateFaulted OperationState = "Faulted"
	// OperationStateForceCancelled The operation was cancelled by the user using CancelOperation, with the
	// force parameter set to true.  It is no longer running.  Refer to CancelOperation for more details.
	OperationStateForceCancelled OperationState = "ForceCancelled"
	// OperationStateInvalid The operation state is invalid.
	OperationStateInvalid OperationState = "Invalid"
	// OperationStateRollingBack The operation is rolling back internal system state because it encountered a
	// fatal error or was cancelled by the user.  "RollingBack"     does not refer to user state.  For example,
	// if CancelOperation is called on a command of type PartitionDataLoss, state of "RollingBack" does not
	// mean service data is being restored (assuming the command has progressed far enough to cause data loss).
	// It means the system is rolling back/cleaning up internal system state associated with the command.
	OperationStateRollingBack OperationState = "RollingBack"
	// OperationStateRunning The operation is in progress.
	OperationStateRunning OperationState = "Running"
)

// PossibleOperationStateValues returns an array of possible values for the OperationState const type.
func PossibleOperationStateValues() []OperationState {
	return []OperationState{OperationStateCancelled, OperationStateCompleted, OperationStateFaulted, OperationStateForceCancelled, OperationStateInvalid, OperationStateRollingBack, OperationStateRunning}
}

// OperationType enumerates the values for operation type.
type OperationType string

const (
	// OperationTypeInvalid The operation state is invalid.
	OperationTypeInvalid OperationType = "Invalid"
	// OperationTypeNodeTransition An operation started using the StartNodeTransition API.
	OperationTypeNodeTransition OperationType = "NodeTransition"
	// OperationTypePartitionDataLoss An operation started using the StartDataLoss API.
	OperationTypePartitionDataLoss OperationType = "PartitionDataLoss"
	// OperationTypePartitionQuorumLoss An operation started using the StartQuorumLoss API.
	OperationTypePartitionQuorumLoss OperationType = "PartitionQuorumLoss"
	// OperationTypePartitionRestart An operation started using the StartPartitionRestart API.
	OperationTypePartitionRestart OperationType = "PartitionRestart"
)

// PossibleOperationTypeValues returns an array of possible values for the OperationType const type.
func PossibleOperationTypeValues() []OperationType {
	return []OperationType{OperationTypeInvalid, OperationTypeNodeTransition, OperationTypePartitionDataLoss, OperationTypePartitionQuorumLoss, OperationTypePartitionRestart}
}

// PackageSharingPolicyScope enumerates the values for package sharing policy scope.
type PackageSharingPolicyScope string

const (
	// PackageSharingPolicyScopeAll Share all code, config and data packages from corresponding service
	// manifest. The value is 1.
	PackageSharingPolicyScopeAll PackageSharingPolicyScope = "All"
	// PackageSharingPolicyScopeCode Share all code packages from corresponding service manifest. The value is
	// 2.
	PackageSharingPolicyScopeCode PackageSharingPolicyScope = "Code"
	// PackageSharingPolicyScopeConfig Share all config packages from corresponding service manifest. The value
	// is 3.
	PackageSharingPolicyScopeConfig PackageSharingPolicyScope = "Config"
	// PackageSharingPolicyScopeData Share all data packages from corresponding service manifest. The value is
	// 4.
	PackageSharingPolicyScopeData PackageSharingPolicyScope = "Data"
	// PackageSharingPolicyScopeNone No package sharing policy scope. The value is 0.
	PackageSharingPolicyScopeNone PackageSharingPolicyScope = "None"
)

// PossiblePackageSharingPolicyScopeValues returns an array of possible values for the PackageSharingPolicyScope const type.
func PossiblePackageSharingPolicyScopeValues() []PackageSharingPolicyScope {
	return []PackageSharingPolicyScope{PackageSharingPolicyScopeAll, PackageSharingPolicyScopeCode, PackageSharingPolicyScopeConfig, PackageSharingPolicyScopeData, PackageSharingPolicyScopeNone}
}

// PartitionAccessStatus enumerates the values for partition access status.
type PartitionAccessStatus string

const (
	// PartitionAccessStatusGranted Indicates that the read or write operation access is granted and the
	// operation is allowed.
	PartitionAccessStatusGranted PartitionAccessStatus = "Granted"
	// PartitionAccessStatusInvalid Indicates that the read or write operation access status is not valid. This
	// value is not returned to the caller.
	PartitionAccessStatusInvalid PartitionAccessStatus = "Invalid"
	// PartitionAccessStatusNotPrimary Indicates that this client request was received by a replica that is not
	// a Primary replica.
	PartitionAccessStatusNotPrimary PartitionAccessStatus = "NotPrimary"
	// PartitionAccessStatusNoWriteQuorum Indicates that no write quorum is available and, therefore, no write
	// operation can be accepted.
	PartitionAccessStatusNoWriteQuorum PartitionAccessStatus = "NoWriteQuorum"
	// PartitionAccessStatusReconfigurationPending Indicates that the client should try again later, because a
	// reconfiguration is in progress.
	PartitionAccessStatusReconfigurationPending PartitionAccessStatus = "ReconfigurationPending"
)

// PossiblePartitionAccessStatusValues returns an array of possible values for the PartitionAccessStatus const type.
func PossiblePartitionAccessStatusValues() []PartitionAccessStatus {
	return []PartitionAccessStatus{PartitionAccessStatusGranted, PartitionAccessStatusInvalid, PartitionAccessStatusNotPrimary, PartitionAccessStatusNoWriteQuorum, PartitionAccessStatusReconfigurationPending}
}

// PartitionScheme enumerates the values for partition scheme.
type PartitionScheme string

const (
	// PartitionSchemeInvalid Indicates the partition kind is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	PartitionSchemeInvalid PartitionScheme = "Invalid"
	// PartitionSchemeNamed Indicates that the partition is based on string names, and is a
	// NamedPartitionSchemeDescription object. The value is 3
	PartitionSchemeNamed PartitionScheme = "Named"
	// PartitionSchemeSingleton Indicates that the partition is based on string names, and is a
	// SingletonPartitionSchemeDescription object, The value is 1.
	PartitionSchemeSingleton PartitionScheme = "Singleton"
	// PartitionSchemeUniformInt64Range Indicates that the partition is based on Int64 key ranges, and is a
	// UniformInt64RangePartitionSchemeDescription object. The value is 2.
	PartitionSchemeUniformInt64Range PartitionScheme = "UniformInt64Range"
)

// PossiblePartitionSchemeValues returns an array of possible values for the PartitionScheme const type.
func PossiblePartitionSchemeValues() []PartitionScheme {
	return []PartitionScheme{PartitionSchemeInvalid, PartitionSchemeNamed, PartitionSchemeSingleton, PartitionSchemeUniformInt64Range}
}

// PartitionSchemeBasicPartitionSchemeDescription enumerates the values for partition scheme basic partition
// scheme description.
type PartitionSchemeBasicPartitionSchemeDescription string

const (
	// PartitionSchemeNamed1 ...
	PartitionSchemeNamed1 PartitionSchemeBasicPartitionSchemeDescription = "Named"
	// PartitionSchemePartitionSchemeDescription ...
	PartitionSchemePartitionSchemeDescription PartitionSchemeBasicPartitionSchemeDescription = "PartitionSchemeDescription"
	// PartitionSchemeSingleton1 ...
	PartitionSchemeSingleton1 PartitionSchemeBasicPartitionSchemeDescription = "Singleton"
	// PartitionSchemeUniformInt64Range1 ...
	PartitionSchemeUniformInt64Range1 PartitionSchemeBasicPartitionSchemeDescription = "UniformInt64Range"
)

// PossiblePartitionSchemeBasicPartitionSchemeDescriptionValues returns an array of possible values for the PartitionSchemeBasicPartitionSchemeDescription const type.
func PossiblePartitionSchemeBasicPartitionSchemeDescriptionValues() []PartitionSchemeBasicPartitionSchemeDescription {
	return []PartitionSchemeBasicPartitionSchemeDescription{PartitionSchemeNamed1, PartitionSchemePartitionSchemeDescription, PartitionSchemeSingleton1, PartitionSchemeUniformInt64Range1}
}

// PropertyBatchInfoKind enumerates the values for property batch info kind.
type PropertyBatchInfoKind string

const (
	// PropertyBatchInfoKindFailed The property batch failed.
	PropertyBatchInfoKindFailed PropertyBatchInfoKind = "Failed"
	// PropertyBatchInfoKindInvalid Indicates the property batch info is invalid. All Service Fabric
	// enumerations have the invalid type.
	PropertyBatchInfoKindInvalid PropertyBatchInfoKind = "Invalid"
	// PropertyBatchInfoKindSuccessful The property batch succeeded.
	PropertyBatchInfoKindSuccessful PropertyBatchInfoKind = "Successful"
)

// PossiblePropertyBatchInfoKindValues returns an array of possible values for the PropertyBatchInfoKind const type.
func PossiblePropertyBatchInfoKindValues() []PropertyBatchInfoKind {
	return []PropertyBatchInfoKind{PropertyBatchInfoKindFailed, PropertyBatchInfoKindInvalid, PropertyBatchInfoKindSuccessful}
}

// PropertyBatchOperationKind enumerates the values for property batch operation kind.
type PropertyBatchOperationKind string

const (
	// PropertyBatchOperationKindCheckExists The operation will check that a property exists or doesn't exists,
	// depending on the provided value. The value is 3.
	PropertyBatchOperationKindCheckExists PropertyBatchOperationKind = "CheckExists"
	// PropertyBatchOperationKindCheckSequence The operation will ensure that the sequence number is equal to
	// the provided value. The value is 4.
	PropertyBatchOperationKindCheckSequence PropertyBatchOperationKind = "CheckSequence"
	// PropertyBatchOperationKindCheckValue The operation will ensure that the value of a property is equal to
	// the provided value. The value is 7.
	PropertyBatchOperationKindCheckValue PropertyBatchOperationKind = "CheckValue"
	// PropertyBatchOperationKindDelete The operation will delete a property. The value is 5.
	PropertyBatchOperationKindDelete PropertyBatchOperationKind = "Delete"
	// PropertyBatchOperationKindGet The operation will get a property. The value is 2.
	PropertyBatchOperationKindGet PropertyBatchOperationKind = "Get"
	// PropertyBatchOperationKindInvalid Indicates the property operation is invalid. All Service Fabric
	// enumerations have the invalid type. The value is zero.
	PropertyBatchOperationKindInvalid PropertyBatchOperationKind = "Invalid"
	// PropertyBatchOperationKindPut The operation will create or edit a property. The value is 1.
	PropertyBatchOperationKindPut PropertyBatchOperationKind = "Put"
)

// PossiblePropertyBatchOperationKindValues returns an array of possible values for the PropertyBatchOperationKind const type.
func PossiblePropertyBatchOperationKindValues() []PropertyBatchOperationKind {
	return []PropertyBatchOperationKind{PropertyBatchOperationKindCheckExists, PropertyBatchOperationKindCheckSequence, PropertyBatchOperationKindCheckValue, PropertyBatchOperationKindDelete, PropertyBatchOperationKindGet, PropertyBatchOperationKindInvalid, PropertyBatchOperationKindPut}
}

// PropertyValueKind enumerates the values for property value kind.
type PropertyValueKind string

const (
	// PropertyValueKindBinary The data inside the property is a binary blob. The value is 1.
	PropertyValueKindBinary PropertyValueKind = "Binary"
	// PropertyValueKindDouble The data inside the property is a double. The value is 3.
	PropertyValueKindDouble PropertyValueKind = "Double"
	// PropertyValueKindGUID The data inside the property is a guid. The value is 5.
	PropertyValueKindGUID PropertyValueKind = "Guid"
	// PropertyValueKindInt64 The data inside the property is an int64. The value is 2.
	PropertyValueKindInt64 PropertyValueKind = "Int64"
	// PropertyValueKindInvalid Indicates the property is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	PropertyValueKindInvalid PropertyValueKind = "Invalid"
	// PropertyValueKindString The data inside the property is a string. The value is 4.
	PropertyValueKindString PropertyValueKind = "String"
)

// PossiblePropertyValueKindValues returns an array of possible values for the PropertyValueKind const type.
func PossiblePropertyValueKindValues() []PropertyValueKind {
	return []PropertyValueKind{PropertyValueKindBinary, PropertyValueKindDouble, PropertyValueKindGUID, PropertyValueKindInt64, PropertyValueKindInvalid, PropertyValueKindString}
}

// ProvisionApplicationTypeKind enumerates the values for provision application type kind.
type ProvisionApplicationTypeKind string

const (
	// ProvisionApplicationTypeKindExternalStore Indicates that the provision is for an application package
	// that was previously uploaded to an external store. The application package ends with the extension
	// *.sfpkg. The value is 2.
	ProvisionApplicationTypeKindExternalStore ProvisionApplicationTypeKind = "ExternalStore"
	// ProvisionApplicationTypeKindImageStorePath Indicates that the provision is for a package that was
	// previously uploaded to the image store. The value is 1.
	ProvisionApplicationTypeKindImageStorePath ProvisionApplicationTypeKind = "ImageStorePath"
	// ProvisionApplicationTypeKindInvalid Indicates that the provision kind is invalid. This value is default
	// and should not be used. The value is zero.
	ProvisionApplicationTypeKindInvalid ProvisionApplicationTypeKind = "Invalid"
)

// PossibleProvisionApplicationTypeKindValues returns an array of possible values for the ProvisionApplicationTypeKind const type.
func PossibleProvisionApplicationTypeKindValues() []ProvisionApplicationTypeKind {
	return []ProvisionApplicationTypeKind{ProvisionApplicationTypeKindExternalStore, ProvisionApplicationTypeKindImageStorePath, ProvisionApplicationTypeKindInvalid}
}

// QuorumLossMode enumerates the values for quorum loss mode.
type QuorumLossMode string

const (
	// QuorumLossModeAllReplicas ...
	QuorumLossModeAllReplicas QuorumLossMode = "AllReplicas"
	// QuorumLossModeInvalid Reserved.  Do not pass into API.
	QuorumLossModeInvalid QuorumLossMode = "Invalid"
	// QuorumLossModeQuorumReplicas Partial Quorum loss mode : Minimum number of replicas for a partition will
	// be down that will cause a quorum loss.
	QuorumLossModeQuorumReplicas QuorumLossMode = "QuorumReplicas"
)

// PossibleQuorumLossModeValues returns an array of possible values for the QuorumLossMode const type.
func PossibleQuorumLossModeValues() []QuorumLossMode {
	return []QuorumLossMode{QuorumLossModeAllReplicas, QuorumLossModeInvalid, QuorumLossModeQuorumReplicas}
}

// ReconfigurationPhase enumerates the values for reconfiguration phase.
type ReconfigurationPhase string

const (
	// ReconfigurationPhaseAbortPhaseZero This phase is for internal use only.
	ReconfigurationPhaseAbortPhaseZero ReconfigurationPhase = "AbortPhaseZero"
	// ReconfigurationPhaseNone Specifies that there is no reconfiguration in progress.
	ReconfigurationPhaseNone ReconfigurationPhase = "None"
	// ReconfigurationPhasePhase0 Refers to the phase where the reconfiguration is transferring data from the
	// previous primary to the new primary.
	ReconfigurationPhasePhase0 ReconfigurationPhase = "Phase0"
	// ReconfigurationPhasePhase1 Refers to the phase where the reconfiguration is querying the replica set for
	// the progress.
	ReconfigurationPhasePhase1 ReconfigurationPhase = "Phase1"
	// ReconfigurationPhasePhase2 Refers to the phase where the reconfiguration is ensuring that data from the
	// current primary is present in a majority of the replica set.
	ReconfigurationPhasePhase2 ReconfigurationPhase = "Phase2"
	// ReconfigurationPhasePhase3 This phase is for internal use only.
	ReconfigurationPhasePhase3 ReconfigurationPhase = "Phase3"
	// ReconfigurationPhasePhase4 This phase is for internal use only.
	ReconfigurationPhasePhase4 ReconfigurationPhase = "Phase4"
	// ReconfigurationPhaseUnknown Indicates the invalid reconfiguration phase.
	ReconfigurationPhaseUnknown ReconfigurationPhase = "Unknown"
)

// PossibleReconfigurationPhaseValues returns an array of possible values for the ReconfigurationPhase const type.
func PossibleReconfigurationPhaseValues() []ReconfigurationPhase {
	return []ReconfigurationPhase{ReconfigurationPhaseAbortPhaseZero, ReconfigurationPhaseNone, ReconfigurationPhasePhase0, ReconfigurationPhasePhase1, ReconfigurationPhasePhase2, ReconfigurationPhasePhase3, ReconfigurationPhasePhase4, ReconfigurationPhaseUnknown}
}

// ReconfigurationType enumerates the values for reconfiguration type.
type ReconfigurationType string

const (
	// ReconfigurationTypeFailover Reconfiguration triggered in response to a primary going down. This could be
	// due to many reasons such as primary replica crashing etc.
	ReconfigurationTypeFailover ReconfigurationType = "Failover"
	// ReconfigurationTypeOther Reconfigurations where the primary replica is not changing.
	ReconfigurationTypeOther ReconfigurationType = "Other"
	// ReconfigurationTypeSwapPrimary Specifies that the primary replica is being swapped with a different
	// replica.
	ReconfigurationTypeSwapPrimary ReconfigurationType = "SwapPrimary"
	// ReconfigurationTypeUnknown Indicates the invalid reconfiguration type.
	ReconfigurationTypeUnknown ReconfigurationType = "Unknown"
)

// PossibleReconfigurationTypeValues returns an array of possible values for the ReconfigurationType const type.
func PossibleReconfigurationTypeValues() []ReconfigurationType {
	return []ReconfigurationType{ReconfigurationTypeFailover, ReconfigurationTypeOther, ReconfigurationTypeSwapPrimary, ReconfigurationTypeUnknown}
}

// RepairImpactKind enumerates the values for repair impact kind.
type RepairImpactKind string

const (
	// RepairImpactKindInvalid The repair impact is not valid or is of an unknown type.
	RepairImpactKindInvalid RepairImpactKind = "Invalid"
	// RepairImpactKindNode The repair impact affects a set of Service Fabric nodes.
	RepairImpactKindNode RepairImpactKind = "Node"
)

// PossibleRepairImpactKindValues returns an array of possible values for the RepairImpactKind const type.
func PossibleRepairImpactKindValues() []RepairImpactKind {
	return []RepairImpactKind{RepairImpactKindInvalid, RepairImpactKindNode}
}

// RepairTargetKind enumerates the values for repair target kind.
type RepairTargetKind string

const (
	// RepairTargetKindInvalid The repair target is not valid or is of an unknown type.
	RepairTargetKindInvalid RepairTargetKind = "Invalid"
	// RepairTargetKindNode The repair target is a set of Service Fabric nodes.
	RepairTargetKindNode RepairTargetKind = "Node"
)

// PossibleRepairTargetKindValues returns an array of possible values for the RepairTargetKind const type.
func PossibleRepairTargetKindValues() []RepairTargetKind {
	return []RepairTargetKind{RepairTargetKindInvalid, RepairTargetKindNode}
}

// RepairTaskHealthCheckState enumerates the values for repair task health check state.
type RepairTaskHealthCheckState string

const (
	// InProgress Indicates that the health check is in progress.
	InProgress RepairTaskHealthCheckState = "InProgress"
	// NotStarted Indicates that the health check has not started.
	NotStarted RepairTaskHealthCheckState = "NotStarted"
	// Skipped Indicates that the health check was skipped.
	Skipped RepairTaskHealthCheckState = "Skipped"
	// Succeeded Indicates that the health check succeeded.
	Succeeded RepairTaskHealthCheckState = "Succeeded"
	// TimedOut Indicates that the health check timed out.
	TimedOut RepairTaskHealthCheckState = "TimedOut"
)

// PossibleRepairTaskHealthCheckStateValues returns an array of possible values for the RepairTaskHealthCheckState const type.
func PossibleRepairTaskHealthCheckStateValues() []RepairTaskHealthCheckState {
	return []RepairTaskHealthCheckState{InProgress, NotStarted, Skipped, Succeeded, TimedOut}
}

// ReplicaHealthReportServiceKind enumerates the values for replica health report service kind.
type ReplicaHealthReportServiceKind string

const (
	// Stateful Uses Service Fabric to make its state or part of its state highly available and reliable. The
	// value is 2.
	Stateful ReplicaHealthReportServiceKind = "Stateful"
	// Stateless Does not use Service Fabric to make its state highly available or reliable. The value is 1
	Stateless ReplicaHealthReportServiceKind = "Stateless"
)

// PossibleReplicaHealthReportServiceKindValues returns an array of possible values for the ReplicaHealthReportServiceKind const type.
func PossibleReplicaHealthReportServiceKindValues() []ReplicaHealthReportServiceKind {
	return []ReplicaHealthReportServiceKind{Stateful, Stateless}
}

// ReplicaKind enumerates the values for replica kind.
type ReplicaKind string

const (
	// ReplicaKindInvalid Represents an invalid replica kind. The value is zero.
	ReplicaKindInvalid ReplicaKind = "Invalid"
	// ReplicaKindKeyValueStore Represents a key value store replica. The value is 1
	ReplicaKindKeyValueStore ReplicaKind = "KeyValueStore"
)

// PossibleReplicaKindValues returns an array of possible values for the ReplicaKind const type.
func PossibleReplicaKindValues() []ReplicaKind {
	return []ReplicaKind{ReplicaKindInvalid, ReplicaKindKeyValueStore}
}

// ReplicaRole enumerates the values for replica role.
type ReplicaRole string

const (
	// ReplicaRoleActiveSecondary Refers to a replica in the set that receives state updates from the Primary
	// replica, applies them, and sends acknowledgements back. Secondary replicas must participate in the write
	// quorum for a replica set. There can be multiple active Secondary replicas in a replica set at a time.
	// The number of active Secondary replicas is configurable that the reliability subsystem should maintain.
	// The value is 4.
	ReplicaRoleActiveSecondary ReplicaRole = "ActiveSecondary"
	// ReplicaRoleIdleSecondary Refers to a replica in the set that receives a state transfer from the Primary
	// replica to prepare for becoming an active Secondary replica. There can be multiple Idle Secondary
	// replicas in a replica set at a time. Idle Secondary replicas do not count as a part of a write quorum.
	// The value is 3.
	ReplicaRoleIdleSecondary ReplicaRole = "IdleSecondary"
	// ReplicaRoleNone Specifies that the replica has no responsibility in regard to the replica set. The value
	// is 1
	ReplicaRoleNone ReplicaRole = "None"
	// ReplicaRolePrimary Refers to the replica in the set on which all read and write operations are complete
	// in order to enforce strong consistency semantics. Read operations are handled directly by the Primary
	// replica, while write operations must be acknowledged by a quorum of the replicas in the replica set.
	// There can only be one Primary replica in a replica set at a time. The value is 2.
	ReplicaRolePrimary ReplicaRole = "Primary"
	// ReplicaRoleUnknown Indicates the initial role that a replica is created in. The value is zero.
	ReplicaRoleUnknown ReplicaRole = "Unknown"
)

// PossibleReplicaRoleValues returns an array of possible values for the ReplicaRole const type.
func PossibleReplicaRoleValues() []ReplicaRole {
	return []ReplicaRole{ReplicaRoleActiveSecondary, ReplicaRoleIdleSecondary, ReplicaRoleNone, ReplicaRolePrimary, ReplicaRoleUnknown}
}

// ReplicaStatus enumerates the values for replica status.
type ReplicaStatus string

const (
	// ReplicaStatusDown The replica is down. The value is 4.
	ReplicaStatusDown ReplicaStatus = "Down"
	// ReplicaStatusDropped Replica is dropped. This means that the replica has been removed from the replica
	// set. If it is persisted, its state has been deleted. The value is 5.
	ReplicaStatusDropped ReplicaStatus = "Dropped"
	// ReplicaStatusInBuild The replica is being built. This means that a primary replica is seeding this
	// replica. The value is 1.
	ReplicaStatusInBuild ReplicaStatus = "InBuild"
	// ReplicaStatusInvalid Indicates the replica status is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	ReplicaStatusInvalid ReplicaStatus = "Invalid"
	// ReplicaStatusReady The replica is ready. The value is 3.
	ReplicaStatusReady ReplicaStatus = "Ready"
	// ReplicaStatusStandby The replica is in standby. The value is 2.
	ReplicaStatusStandby ReplicaStatus = "Standby"
)

// PossibleReplicaStatusValues returns an array of possible values for the ReplicaStatus const type.
func PossibleReplicaStatusValues() []ReplicaStatus {
	return []ReplicaStatus{ReplicaStatusDown, ReplicaStatusDropped, ReplicaStatusInBuild, ReplicaStatusInvalid, ReplicaStatusReady, ReplicaStatusStandby}
}

// ReplicatorOperationName enumerates the values for replicator operation name.
type ReplicatorOperationName string

const (
	// ReplicatorOperationNameAbort Replicator is being aborted.
	ReplicatorOperationNameAbort ReplicatorOperationName = "Abort"
	// ReplicatorOperationNameBuild Replicator is in the process of building one or more replicas.
	ReplicatorOperationNameBuild ReplicatorOperationName = "Build"
	// ReplicatorOperationNameChangeRole Replicator is in the process of changing its role.
	ReplicatorOperationNameChangeRole ReplicatorOperationName = "ChangeRole"
	// ReplicatorOperationNameClose Replicator is closing.
	ReplicatorOperationNameClose ReplicatorOperationName = "Close"
	// ReplicatorOperationNameInvalid Default value if the replicator is not yet ready.
	ReplicatorOperationNameInvalid ReplicatorOperationName = "Invalid"
	// ReplicatorOperationNameNone Replicator is not running any operation from Service Fabric perspective.
	ReplicatorOperationNameNone ReplicatorOperationName = "None"
	// ReplicatorOperationNameOnDataLoss Replicator is handling the data loss condition, where the user service
	// may potentially be recovering state from an external source.
	ReplicatorOperationNameOnDataLoss ReplicatorOperationName = "OnDataLoss"
	// ReplicatorOperationNameOpen Replicator is opening.
	ReplicatorOperationNameOpen ReplicatorOperationName = "Open"
	// ReplicatorOperationNameUpdateEpoch Due to a change in the replica set, replicator is being updated with
	// its Epoch.
	ReplicatorOperationNameUpdateEpoch ReplicatorOperationName = "UpdateEpoch"
	// ReplicatorOperationNameWaitForCatchup Replicator is waiting for a quorum of replicas to be caught up to
	// the latest state.
	ReplicatorOperationNameWaitForCatchup ReplicatorOperationName = "WaitForCatchup"
)

// PossibleReplicatorOperationNameValues returns an array of possible values for the ReplicatorOperationName const type.
func PossibleReplicatorOperationNameValues() []ReplicatorOperationName {
	return []ReplicatorOperationName{ReplicatorOperationNameAbort, ReplicatorOperationNameBuild, ReplicatorOperationNameChangeRole, ReplicatorOperationNameClose, ReplicatorOperationNameInvalid, ReplicatorOperationNameNone, ReplicatorOperationNameOnDataLoss, ReplicatorOperationNameOpen, ReplicatorOperationNameUpdateEpoch, ReplicatorOperationNameWaitForCatchup}
}

// RestartPartitionMode enumerates the values for restart partition mode.
type RestartPartitionMode string

const (
	// RestartPartitionModeAllReplicasOrInstances All replicas or instances in the partition are restarted at
	// once.
	RestartPartitionModeAllReplicasOrInstances RestartPartitionMode = "AllReplicasOrInstances"
	// RestartPartitionModeInvalid Reserved.  Do not pass into API.
	RestartPartitionModeInvalid RestartPartitionMode = "Invalid"
	// RestartPartitionModeOnlyActiveSecondaries Only the secondary replicas are restarted.
	RestartPartitionModeOnlyActiveSecondaries RestartPartitionMode = "OnlyActiveSecondaries"
)

// PossibleRestartPartitionModeValues returns an array of possible values for the RestartPartitionMode const type.
func PossibleRestartPartitionModeValues() []RestartPartitionMode {
	return []RestartPartitionMode{RestartPartitionModeAllReplicasOrInstances, RestartPartitionModeInvalid, RestartPartitionModeOnlyActiveSecondaries}
}

// RestoreState enumerates the values for restore state.
type RestoreState string

const (
	// RestoreStateAccepted Operation has been validated and accepted. Restore is yet to be triggered.
	RestoreStateAccepted RestoreState = "Accepted"
	// RestoreStateFailure Operation completed with failure.
	RestoreStateFailure RestoreState = "Failure"
	// RestoreStateInvalid Indicates an invalid restore state. All Service Fabric enumerations have the invalid
	// type.
	RestoreStateInvalid RestoreState = "Invalid"
	// RestoreStateRestoreInProgress Restore operation has been triggered and is under process.
	RestoreStateRestoreInProgress RestoreState = "RestoreInProgress"
	// RestoreStateSuccess Operation completed with success.
	RestoreStateSuccess RestoreState = "Success"
	// RestoreStateTimeout Operation timed out.
	RestoreStateTimeout RestoreState = "Timeout"
)

// PossibleRestoreStateValues returns an array of possible values for the RestoreState const type.
func PossibleRestoreStateValues() []RestoreState {
	return []RestoreState{RestoreStateAccepted, RestoreStateFailure, RestoreStateInvalid, RestoreStateRestoreInProgress, RestoreStateSuccess, RestoreStateTimeout}
}

// ResultStatus enumerates the values for result status.
type ResultStatus string

const (
	// ResultStatusCancelled Indicates that the repair task was cancelled prior to execution.
	ResultStatusCancelled ResultStatus = "Cancelled"
	// ResultStatusFailed Indicates that there was a failure during execution of the repair task. Some work may
	// have been performed.
	ResultStatusFailed ResultStatus = "Failed"
	// ResultStatusInterrupted Indicates that execution of the repair task was interrupted by a cancellation
	// request after some work had already been performed.
	ResultStatusInterrupted ResultStatus = "Interrupted"
	// ResultStatusInvalid Indicates that the repair task result is invalid. All Service Fabric enumerations
	// have the invalid value.
	ResultStatusInvalid ResultStatus = "Invalid"
	// ResultStatusPending Indicates that the repair task result is not yet available, because the repair task
	// has not finished executing.
	ResultStatusPending ResultStatus = "Pending"
	// ResultStatusSucceeded Indicates that the repair task completed execution successfully.
	ResultStatusSucceeded ResultStatus = "Succeeded"
)

// PossibleResultStatusValues returns an array of possible values for the ResultStatus const type.
func PossibleResultStatusValues() []ResultStatus {
	return []ResultStatus{ResultStatusCancelled, ResultStatusFailed, ResultStatusInterrupted, ResultStatusInvalid, ResultStatusPending, ResultStatusSucceeded}
}

// SafetyCheckKind enumerates the values for safety check kind.
type SafetyCheckKind string

const (
	// SafetyCheckKindEnsureAvailability Indicates that there is either a stateless service partition on the
	// node having exactly one instance, or there is a primary replica on the node for which the partition is
	// quorum loss. In both cases, bringing down the replicas due to upgrade will result in loss of
	// availability. The value is 7.
	SafetyCheckKindEnsureAvailability SafetyCheckKind = "EnsureAvailability"
	// SafetyCheckKindEnsurePartitionQuorum Indicates that there is some partition for which if we bring down
	// the replica on the node, it will result in quorum loss for that partition. The value is 2.
	SafetyCheckKindEnsurePartitionQuorum SafetyCheckKind = "EnsurePartitionQuorum"
	// SafetyCheckKindEnsureSeedNodeQuorum Indicates that if we bring down the node then this will result in
	// global seed node quorum loss. The value is 1.
	SafetyCheckKindEnsureSeedNodeQuorum SafetyCheckKind = "EnsureSeedNodeQuorum"
	// SafetyCheckKindInvalid Indicates that the upgrade safety check kind is invalid. All Service Fabric
	// enumerations have the invalid type. The value is zero.
	SafetyCheckKindInvalid SafetyCheckKind = "Invalid"
	// SafetyCheckKindWaitForInbuildReplica Indicates that there is either a replica on the node that is going
	// through copy, or there is a primary replica on the node that is copying data to some other replica. In
	// both cases, bringing down the replica on the node due to upgrade will abort the copy. The value is 6.
	SafetyCheckKindWaitForInbuildReplica SafetyCheckKind = "WaitForInbuildReplica"
	// SafetyCheckKindWaitForPrimaryPlacement Indicates that there is some replica on the node that was moved
	// out of this node due to upgrade. Service Fabric is now waiting for the primary to be moved back to this
	// node. The value is 3.
	SafetyCheckKindWaitForPrimaryPlacement SafetyCheckKind = "WaitForPrimaryPlacement"
	// SafetyCheckKindWaitForPrimarySwap Indicates that Service Fabric is waiting for a primary replica to be
	// moved out of the node before starting upgrade on that node. The value is 4.
	SafetyCheckKindWaitForPrimarySwap SafetyCheckKind = "WaitForPrimarySwap"
	// SafetyCheckKindWaitForReconfiguration Indicates that there is some replica on the node that is involved
	// in a reconfiguration. Service Fabric is waiting for the reconfiguration to be complete before staring
	// upgrade on that node. The value is 5.
	SafetyCheckKindWaitForReconfiguration SafetyCheckKind = "WaitForReconfiguration"
)

// PossibleSafetyCheckKindValues returns an array of possible values for the SafetyCheckKind const type.
func PossibleSafetyCheckKindValues() []SafetyCheckKind {
	return []SafetyCheckKind{SafetyCheckKindEnsureAvailability, SafetyCheckKindEnsurePartitionQuorum, SafetyCheckKindEnsureSeedNodeQuorum, SafetyCheckKindInvalid, SafetyCheckKindWaitForInbuildReplica, SafetyCheckKindWaitForPrimaryPlacement, SafetyCheckKindWaitForPrimarySwap, SafetyCheckKindWaitForReconfiguration}
}

// ScalingMechanismKind enumerates the values for scaling mechanism kind.
type ScalingMechanismKind string

const (
	// ScalingMechanismKindAddRemoveIncrementalNamedPartition Indicates a mechanism for scaling where new named
	// partitions are added or removed from a service. The value is 2.
	ScalingMechanismKindAddRemoveIncrementalNamedPartition ScalingMechanismKind = "AddRemoveIncrementalNamedPartition"
	// ScalingMechanismKindInvalid Indicates the scaling mechanism is invalid. All Service Fabric enumerations
	// have the invalid type. The value is zero.
	ScalingMechanismKindInvalid ScalingMechanismKind = "Invalid"
	// ScalingMechanismKindPartitionInstanceCount Indicates a mechanism for scaling where new instances are
	// added or removed from a partition. The value is 1.
	ScalingMechanismKindPartitionInstanceCount ScalingMechanismKind = "PartitionInstanceCount"
)

// PossibleScalingMechanismKindValues returns an array of possible values for the ScalingMechanismKind const type.
func PossibleScalingMechanismKindValues() []ScalingMechanismKind {
	return []ScalingMechanismKind{ScalingMechanismKindAddRemoveIncrementalNamedPartition, ScalingMechanismKindInvalid, ScalingMechanismKindPartitionInstanceCount}
}

// ScalingTriggerKind enumerates the values for scaling trigger kind.
type ScalingTriggerKind string

const (
	// ScalingTriggerKindAveragePartitionLoad Indicates a trigger where scaling decisions are made based on
	// average load of a partition. The value is 1.
	ScalingTriggerKindAveragePartitionLoad ScalingTriggerKind = "AveragePartitionLoad"
	// ScalingTriggerKindAverageServiceLoad Indicates a trigger where scaling decisions are made based on
	// average load of a service. The value is 2.
	ScalingTriggerKindAverageServiceLoad ScalingTriggerKind = "AverageServiceLoad"
	// ScalingTriggerKindInvalid Indicates the scaling trigger is invalid. All Service Fabric enumerations have
	// the invalid type. The value is zero.
	ScalingTriggerKindInvalid ScalingTriggerKind = "Invalid"
)

// PossibleScalingTriggerKindValues returns an array of possible values for the ScalingTriggerKind const type.
func PossibleScalingTriggerKindValues() []ScalingTriggerKind {
	return []ScalingTriggerKind{ScalingTriggerKindAveragePartitionLoad, ScalingTriggerKindAverageServiceLoad, ScalingTriggerKindInvalid}
}

// ScheduleKind enumerates the values for schedule kind.
type ScheduleKind string

const (
	// ScheduleKindBackupScheduleDescription ...
	ScheduleKindBackupScheduleDescription ScheduleKind = "BackupScheduleDescription"
	// ScheduleKindFrequencyBased ...
	ScheduleKindFrequencyBased ScheduleKind = "FrequencyBased"
	// ScheduleKindTimeBased ...
	ScheduleKindTimeBased ScheduleKind = "TimeBased"
)

// PossibleScheduleKindValues returns an array of possible values for the ScheduleKind const type.
func PossibleScheduleKindValues() []ScheduleKind {
	return []ScheduleKind{ScheduleKindBackupScheduleDescription, ScheduleKindFrequencyBased, ScheduleKindTimeBased}
}

// ServiceCorrelationScheme enumerates the values for service correlation scheme.
type ServiceCorrelationScheme string

const (
	// ServiceCorrelationSchemeAffinity Indicates that this service has an affinity relationship with another
	// service. Provided for backwards compatibility, consider preferring the Aligned or NonAlignedAffinity
	// options. The value is 1.
	ServiceCorrelationSchemeAffinity ServiceCorrelationScheme = "Affinity"
	// ServiceCorrelationSchemeAlignedAffinity Aligned affinity ensures that the primaries of the partitions of
	// the affinitized services are collocated on the same nodes. This is the default and is the same as
	// selecting the Affinity scheme. The value is 2.
	ServiceCorrelationSchemeAlignedAffinity ServiceCorrelationScheme = "AlignedAffinity"
	// ServiceCorrelationSchemeInvalid An invalid correlation scheme. Cannot be used. The value is zero.
	ServiceCorrelationSchemeInvalid ServiceCorrelationScheme = "Invalid"
	// ServiceCorrelationSchemeNonAlignedAffinity Non-Aligned affinity guarantees that all replicas of each
	// service will be placed on the same nodes. Unlike Aligned Affinity, this does not guarantee that replicas
	// of particular role will be collocated. The value is 3.
	ServiceCorrelationSchemeNonAlignedAffinity ServiceCorrelationScheme = "NonAlignedAffinity"
)

// PossibleServiceCorrelationSchemeValues returns an array of possible values for the ServiceCorrelationScheme const type.
func PossibleServiceCorrelationSchemeValues() []ServiceCorrelationScheme {
	return []ServiceCorrelationScheme{ServiceCorrelationSchemeAffinity, ServiceCorrelationSchemeAlignedAffinity, ServiceCorrelationSchemeInvalid, ServiceCorrelationSchemeNonAlignedAffinity}
}

// ServiceEndpointRole enumerates the values for service endpoint role.
type ServiceEndpointRole string

const (
	// ServiceEndpointRoleInvalid Indicates the service endpoint role is invalid. All Service Fabric
	// enumerations have the invalid type. The value is zero.
	ServiceEndpointRoleInvalid ServiceEndpointRole = "Invalid"
	// ServiceEndpointRoleStatefulPrimary Indicates that the service endpoint is of a primary replica of a
	// stateful service. The value is 2.
	ServiceEndpointRoleStatefulPrimary ServiceEndpointRole = "StatefulPrimary"
	// ServiceEndpointRoleStatefulSecondary Indicates that the service endpoint is of a secondary replica of a
	// stateful service. The value is 3.
	ServiceEndpointRoleStatefulSecondary ServiceEndpointRole = "StatefulSecondary"
	// ServiceEndpointRoleStateless Indicates that the service endpoint is of a stateless service. The value is
	// 1.
	ServiceEndpointRoleStateless ServiceEndpointRole = "Stateless"
)

// PossibleServiceEndpointRoleValues returns an array of possible values for the ServiceEndpointRole const type.
func PossibleServiceEndpointRoleValues() []ServiceEndpointRole {
	return []ServiceEndpointRole{ServiceEndpointRoleInvalid, ServiceEndpointRoleStatefulPrimary, ServiceEndpointRoleStatefulSecondary, ServiceEndpointRoleStateless}
}

// ServiceKind enumerates the values for service kind.
type ServiceKind string

const (
	// ServiceKindInvalid Indicates the service kind is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	ServiceKindInvalid ServiceKind = "Invalid"
	// ServiceKindStateful Uses Service Fabric to make its state or part of its state highly available and
	// reliable. The value is 2.
	ServiceKindStateful ServiceKind = "Stateful"
	// ServiceKindStateless Does not use Service Fabric to make its state highly available or reliable. The
	// value is 1.
	ServiceKindStateless ServiceKind = "Stateless"
)

// PossibleServiceKindValues returns an array of possible values for the ServiceKind const type.
func PossibleServiceKindValues() []ServiceKind {
	return []ServiceKind{ServiceKindInvalid, ServiceKindStateful, ServiceKindStateless}
}

// ServiceKindBasicDeployedServiceReplicaDetailInfo enumerates the values for service kind basic deployed
// service replica detail info.
type ServiceKindBasicDeployedServiceReplicaDetailInfo string

const (
	// ServiceKindDeployedServiceReplicaDetailInfo ...
	ServiceKindDeployedServiceReplicaDetailInfo ServiceKindBasicDeployedServiceReplicaDetailInfo = "DeployedServiceReplicaDetailInfo"
	// ServiceKindStateful1 ...
	ServiceKindStateful1 ServiceKindBasicDeployedServiceReplicaDetailInfo = "Stateful"
	// ServiceKindStateless1 ...
	ServiceKindStateless1 ServiceKindBasicDeployedServiceReplicaDetailInfo = "Stateless"
)

// PossibleServiceKindBasicDeployedServiceReplicaDetailInfoValues returns an array of possible values for the ServiceKindBasicDeployedServiceReplicaDetailInfo const type.
func PossibleServiceKindBasicDeployedServiceReplicaDetailInfoValues() []ServiceKindBasicDeployedServiceReplicaDetailInfo {
	return []ServiceKindBasicDeployedServiceReplicaDetailInfo{ServiceKindDeployedServiceReplicaDetailInfo, ServiceKindStateful1, ServiceKindStateless1}
}

// ServiceKindBasicDeployedServiceReplicaInfo enumerates the values for service kind basic deployed service
// replica info.
type ServiceKindBasicDeployedServiceReplicaInfo string

const (
	// ServiceKindBasicDeployedServiceReplicaInfoServiceKindDeployedServiceReplicaInfo ...
	ServiceKindBasicDeployedServiceReplicaInfoServiceKindDeployedServiceReplicaInfo ServiceKindBasicDeployedServiceReplicaInfo = "DeployedServiceReplicaInfo"
	// ServiceKindBasicDeployedServiceReplicaInfoServiceKindStateful ...
	ServiceKindBasicDeployedServiceReplicaInfoServiceKindStateful ServiceKindBasicDeployedServiceReplicaInfo = "Stateful"
	// ServiceKindBasicDeployedServiceReplicaInfoServiceKindStateless ...
	ServiceKindBasicDeployedServiceReplicaInfoServiceKindStateless ServiceKindBasicDeployedServiceReplicaInfo = "Stateless"
)

// PossibleServiceKindBasicDeployedServiceReplicaInfoValues returns an array of possible values for the ServiceKindBasicDeployedServiceReplicaInfo const type.
func PossibleServiceKindBasicDeployedServiceReplicaInfoValues() []ServiceKindBasicDeployedServiceReplicaInfo {
	return []ServiceKindBasicDeployedServiceReplicaInfo{ServiceKindBasicDeployedServiceReplicaInfoServiceKindDeployedServiceReplicaInfo, ServiceKindBasicDeployedServiceReplicaInfoServiceKindStateful, ServiceKindBasicDeployedServiceReplicaInfoServiceKindStateless}
}

// ServiceKindBasicReplicaHealth enumerates the values for service kind basic replica health.
type ServiceKindBasicReplicaHealth string

const (
	// ServiceKindBasicReplicaHealthServiceKindReplicaHealth ...
	ServiceKindBasicReplicaHealthServiceKindReplicaHealth ServiceKindBasicReplicaHealth = "ReplicaHealth"
	// ServiceKindBasicReplicaHealthServiceKindStateful ...
	ServiceKindBasicReplicaHealthServiceKindStateful ServiceKindBasicReplicaHealth = "Stateful"
	// ServiceKindBasicReplicaHealthServiceKindStateless ...
	ServiceKindBasicReplicaHealthServiceKindStateless ServiceKindBasicReplicaHealth = "Stateless"
)

// PossibleServiceKindBasicReplicaHealthValues returns an array of possible values for the ServiceKindBasicReplicaHealth const type.
func PossibleServiceKindBasicReplicaHealthValues() []ServiceKindBasicReplicaHealth {
	return []ServiceKindBasicReplicaHealth{ServiceKindBasicReplicaHealthServiceKindReplicaHealth, ServiceKindBasicReplicaHealthServiceKindStateful, ServiceKindBasicReplicaHealthServiceKindStateless}
}

// ServiceKindBasicReplicaHealthState enumerates the values for service kind basic replica health state.
type ServiceKindBasicReplicaHealthState string

const (
	// ServiceKindBasicReplicaHealthStateServiceKindReplicaHealthState ...
	ServiceKindBasicReplicaHealthStateServiceKindReplicaHealthState ServiceKindBasicReplicaHealthState = "ReplicaHealthState"
	// ServiceKindBasicReplicaHealthStateServiceKindStateful ...
	ServiceKindBasicReplicaHealthStateServiceKindStateful ServiceKindBasicReplicaHealthState = "Stateful"
	// ServiceKindBasicReplicaHealthStateServiceKindStateless ...
	ServiceKindBasicReplicaHealthStateServiceKindStateless ServiceKindBasicReplicaHealthState = "Stateless"
)

// PossibleServiceKindBasicReplicaHealthStateValues returns an array of possible values for the ServiceKindBasicReplicaHealthState const type.
func PossibleServiceKindBasicReplicaHealthStateValues() []ServiceKindBasicReplicaHealthState {
	return []ServiceKindBasicReplicaHealthState{ServiceKindBasicReplicaHealthStateServiceKindReplicaHealthState, ServiceKindBasicReplicaHealthStateServiceKindStateful, ServiceKindBasicReplicaHealthStateServiceKindStateless}
}

// ServiceKindBasicReplicaInfo enumerates the values for service kind basic replica info.
type ServiceKindBasicReplicaInfo string

const (
	// ServiceKindBasicReplicaInfoServiceKindReplicaInfo ...
	ServiceKindBasicReplicaInfoServiceKindReplicaInfo ServiceKindBasicReplicaInfo = "ReplicaInfo"
	// ServiceKindBasicReplicaInfoServiceKindStateful ...
	ServiceKindBasicReplicaInfoServiceKindStateful ServiceKindBasicReplicaInfo = "Stateful"
	// ServiceKindBasicReplicaInfoServiceKindStateless ...
	ServiceKindBasicReplicaInfoServiceKindStateless ServiceKindBasicReplicaInfo = "Stateless"
)

// PossibleServiceKindBasicReplicaInfoValues returns an array of possible values for the ServiceKindBasicReplicaInfo const type.
func PossibleServiceKindBasicReplicaInfoValues() []ServiceKindBasicReplicaInfo {
	return []ServiceKindBasicReplicaInfo{ServiceKindBasicReplicaInfoServiceKindReplicaInfo, ServiceKindBasicReplicaInfoServiceKindStateful, ServiceKindBasicReplicaInfoServiceKindStateless}
}

// ServiceKindBasicServiceDescription enumerates the values for service kind basic service description.
type ServiceKindBasicServiceDescription string

const (
	// ServiceKindBasicServiceDescriptionServiceKindServiceDescription ...
	ServiceKindBasicServiceDescriptionServiceKindServiceDescription ServiceKindBasicServiceDescription = "ServiceDescription"
	// ServiceKindBasicServiceDescriptionServiceKindStateful ...
	ServiceKindBasicServiceDescriptionServiceKindStateful ServiceKindBasicServiceDescription = "Stateful"
	// ServiceKindBasicServiceDescriptionServiceKindStateless ...
	ServiceKindBasicServiceDescriptionServiceKindStateless ServiceKindBasicServiceDescription = "Stateless"
)

// PossibleServiceKindBasicServiceDescriptionValues returns an array of possible values for the ServiceKindBasicServiceDescription const type.
func PossibleServiceKindBasicServiceDescriptionValues() []ServiceKindBasicServiceDescription {
	return []ServiceKindBasicServiceDescription{ServiceKindBasicServiceDescriptionServiceKindServiceDescription, ServiceKindBasicServiceDescriptionServiceKindStateful, ServiceKindBasicServiceDescriptionServiceKindStateless}
}

// ServiceKindBasicServiceInfo enumerates the values for service kind basic service info.
type ServiceKindBasicServiceInfo string

const (
	// ServiceKindBasicServiceInfoServiceKindServiceInfo ...
	ServiceKindBasicServiceInfoServiceKindServiceInfo ServiceKindBasicServiceInfo = "ServiceInfo"
	// ServiceKindBasicServiceInfoServiceKindStateful ...
	ServiceKindBasicServiceInfoServiceKindStateful ServiceKindBasicServiceInfo = "Stateful"
	// ServiceKindBasicServiceInfoServiceKindStateless ...
	ServiceKindBasicServiceInfoServiceKindStateless ServiceKindBasicServiceInfo = "Stateless"
)

// PossibleServiceKindBasicServiceInfoValues returns an array of possible values for the ServiceKindBasicServiceInfo const type.
func PossibleServiceKindBasicServiceInfoValues() []ServiceKindBasicServiceInfo {
	return []ServiceKindBasicServiceInfo{ServiceKindBasicServiceInfoServiceKindServiceInfo, ServiceKindBasicServiceInfoServiceKindStateful, ServiceKindBasicServiceInfoServiceKindStateless}
}

// ServiceKindBasicServicePartitionInfo enumerates the values for service kind basic service partition info.
type ServiceKindBasicServicePartitionInfo string

const (
	// ServiceKindBasicServicePartitionInfoServiceKindServicePartitionInfo ...
	ServiceKindBasicServicePartitionInfoServiceKindServicePartitionInfo ServiceKindBasicServicePartitionInfo = "ServicePartitionInfo"
	// ServiceKindBasicServicePartitionInfoServiceKindStateful ...
	ServiceKindBasicServicePartitionInfoServiceKindStateful ServiceKindBasicServicePartitionInfo = "Stateful"
	// ServiceKindBasicServicePartitionInfoServiceKindStateless ...
	ServiceKindBasicServicePartitionInfoServiceKindStateless ServiceKindBasicServicePartitionInfo = "Stateless"
)

// PossibleServiceKindBasicServicePartitionInfoValues returns an array of possible values for the ServiceKindBasicServicePartitionInfo const type.
func PossibleServiceKindBasicServicePartitionInfoValues() []ServiceKindBasicServicePartitionInfo {
	return []ServiceKindBasicServicePartitionInfo{ServiceKindBasicServicePartitionInfoServiceKindServicePartitionInfo, ServiceKindBasicServicePartitionInfoServiceKindStateful, ServiceKindBasicServicePartitionInfoServiceKindStateless}
}

// ServiceKindBasicServiceUpdateDescription enumerates the values for service kind basic service update
// description.
type ServiceKindBasicServiceUpdateDescription string

const (
	// ServiceKindBasicServiceUpdateDescriptionServiceKindServiceUpdateDescription ...
	ServiceKindBasicServiceUpdateDescriptionServiceKindServiceUpdateDescription ServiceKindBasicServiceUpdateDescription = "ServiceUpdateDescription"
	// ServiceKindBasicServiceUpdateDescriptionServiceKindStateful ...
	ServiceKindBasicServiceUpdateDescriptionServiceKindStateful ServiceKindBasicServiceUpdateDescription = "Stateful"
	// ServiceKindBasicServiceUpdateDescriptionServiceKindStateless ...
	ServiceKindBasicServiceUpdateDescriptionServiceKindStateless ServiceKindBasicServiceUpdateDescription = "Stateless"
)

// PossibleServiceKindBasicServiceUpdateDescriptionValues returns an array of possible values for the ServiceKindBasicServiceUpdateDescription const type.
func PossibleServiceKindBasicServiceUpdateDescriptionValues() []ServiceKindBasicServiceUpdateDescription {
	return []ServiceKindBasicServiceUpdateDescription{ServiceKindBasicServiceUpdateDescriptionServiceKindServiceUpdateDescription, ServiceKindBasicServiceUpdateDescriptionServiceKindStateful, ServiceKindBasicServiceUpdateDescriptionServiceKindStateless}
}

// ServiceLoadMetricWeight enumerates the values for service load metric weight.
type ServiceLoadMetricWeight string

const (
	// ServiceLoadMetricWeightHigh Specifies the metric weight of the service load as High. The value is 3.
	ServiceLoadMetricWeightHigh ServiceLoadMetricWeight = "High"
	// ServiceLoadMetricWeightLow Specifies the metric weight of the service load as Low. The value is 1.
	ServiceLoadMetricWeightLow ServiceLoadMetricWeight = "Low"
	// ServiceLoadMetricWeightMedium Specifies the metric weight of the service load as Medium. The value is 2.
	ServiceLoadMetricWeightMedium ServiceLoadMetricWeight = "Medium"
	// ServiceLoadMetricWeightZero Disables resource balancing for this metric. This value is zero.
	ServiceLoadMetricWeightZero ServiceLoadMetricWeight = "Zero"
)

// PossibleServiceLoadMetricWeightValues returns an array of possible values for the ServiceLoadMetricWeight const type.
func PossibleServiceLoadMetricWeightValues() []ServiceLoadMetricWeight {
	return []ServiceLoadMetricWeight{ServiceLoadMetricWeightHigh, ServiceLoadMetricWeightLow, ServiceLoadMetricWeightMedium, ServiceLoadMetricWeightZero}
}

// ServiceOperationName enumerates the values for service operation name.
type ServiceOperationName string

const (
	// ServiceOperationNameAbort The service replica or instance is being aborted.
	ServiceOperationNameAbort ServiceOperationName = "Abort"
	// ServiceOperationNameChangeRole The service replica is changing roles.
	ServiceOperationNameChangeRole ServiceOperationName = "ChangeRole"
	// ServiceOperationNameClose The service replica or instance is being closed.
	ServiceOperationNameClose ServiceOperationName = "Close"
	// ServiceOperationNameNone The service replica or instance is not going through any life-cycle changes.
	ServiceOperationNameNone ServiceOperationName = "None"
	// ServiceOperationNameOpen The service replica or instance is being opened.
	ServiceOperationNameOpen ServiceOperationName = "Open"
	// ServiceOperationNameUnknown Reserved for future use.
	ServiceOperationNameUnknown ServiceOperationName = "Unknown"
)

// PossibleServiceOperationNameValues returns an array of possible values for the ServiceOperationName const type.
func PossibleServiceOperationNameValues() []ServiceOperationName {
	return []ServiceOperationName{ServiceOperationNameAbort, ServiceOperationNameChangeRole, ServiceOperationNameClose, ServiceOperationNameNone, ServiceOperationNameOpen, ServiceOperationNameUnknown}
}

// ServicePackageActivationMode enumerates the values for service package activation mode.
type ServicePackageActivationMode string

const (
	// ExclusiveProcess With this activation mode, each replica or instance of service, on a given node, will
	// have its own dedicated activation of service package on a node. The value is 1.
	ExclusiveProcess ServicePackageActivationMode = "ExclusiveProcess"
	// SharedProcess This is the default activation mode. With this activation mode, replicas or instances from
	// different partition(s) of service, on a given node, will share same activation of service package on a
	// node. The value is zero.
	SharedProcess ServicePackageActivationMode = "SharedProcess"
)

// PossibleServicePackageActivationModeValues returns an array of possible values for the ServicePackageActivationMode const type.
func PossibleServicePackageActivationModeValues() []ServicePackageActivationMode {
	return []ServicePackageActivationMode{ExclusiveProcess, SharedProcess}
}

// ServicePartitionKind enumerates the values for service partition kind.
type ServicePartitionKind string

const (
	// ServicePartitionKindInt64Range Indicates that the partition is based on Int64 key ranges, and
	// UniformInt64RangePartitionSchemeDescription was specified while creating the service. The value is 2.
	ServicePartitionKindInt64Range ServicePartitionKind = "Int64Range"
	// ServicePartitionKindInvalid Indicates the partition kind is invalid. All Service Fabric enumerations
	// have the invalid type. The value is zero.
	ServicePartitionKindInvalid ServicePartitionKind = "Invalid"
	// ServicePartitionKindNamed Indicates that the partition is based on string names, and
	// NamedPartitionInformation  was specified while creating the service. The value is 3.
	ServicePartitionKindNamed ServicePartitionKind = "Named"
	// ServicePartitionKindSingleton Indicates that there is only one partition, and
	// SingletonPartitionSchemeDescription was specified while creating the service. The value is 1.
	ServicePartitionKindSingleton ServicePartitionKind = "Singleton"
)

// PossibleServicePartitionKindValues returns an array of possible values for the ServicePartitionKind const type.
func PossibleServicePartitionKindValues() []ServicePartitionKind {
	return []ServicePartitionKind{ServicePartitionKindInt64Range, ServicePartitionKindInvalid, ServicePartitionKindNamed, ServicePartitionKindSingleton}
}

// ServicePartitionKindBasicPartitionInformation enumerates the values for service partition kind basic
// partition information.
type ServicePartitionKindBasicPartitionInformation string

const (
	// ServicePartitionKindInt64Range1 ...
	ServicePartitionKindInt64Range1 ServicePartitionKindBasicPartitionInformation = "Int64Range"
	// ServicePartitionKindNamed1 ...
	ServicePartitionKindNamed1 ServicePartitionKindBasicPartitionInformation = "Named"
	// ServicePartitionKindPartitionInformation ...
	ServicePartitionKindPartitionInformation ServicePartitionKindBasicPartitionInformation = "PartitionInformation"
	// ServicePartitionKindSingleton1 ...
	ServicePartitionKindSingleton1 ServicePartitionKindBasicPartitionInformation = "Singleton"
)

// PossibleServicePartitionKindBasicPartitionInformationValues returns an array of possible values for the ServicePartitionKindBasicPartitionInformation const type.
func PossibleServicePartitionKindBasicPartitionInformationValues() []ServicePartitionKindBasicPartitionInformation {
	return []ServicePartitionKindBasicPartitionInformation{ServicePartitionKindInt64Range1, ServicePartitionKindNamed1, ServicePartitionKindPartitionInformation, ServicePartitionKindSingleton1}
}

// ServicePartitionStatus enumerates the values for service partition status.
type ServicePartitionStatus string

const (
	// ServicePartitionStatusDeleting Indicates that the partition is being deleted. The value is 5.
	ServicePartitionStatusDeleting ServicePartitionStatus = "Deleting"
	// ServicePartitionStatusInQuorumLoss Indicates that the partition is in quorum loss. This means that
	// number of replicas that are up and participating in a replica set is less than MinReplicaSetSize for
	// this partition. The value is 3.
	ServicePartitionStatusInQuorumLoss ServicePartitionStatus = "InQuorumLoss"
	// ServicePartitionStatusInvalid Indicates the partition status is invalid. All Service Fabric enumerations
	// have the invalid type. The value is zero.
	ServicePartitionStatusInvalid ServicePartitionStatus = "Invalid"
	// ServicePartitionStatusNotReady Indicates that the partition is not ready. This status is returned when
	// none of the other states apply. The value is 2.
	ServicePartitionStatusNotReady ServicePartitionStatus = "NotReady"
	// ServicePartitionStatusReady Indicates that the partition is ready. This means that for a stateless
	// service partition there is at least one instance that is up and for a stateful service partition the
	// number of ready replicas is greater than or equal to the MinReplicaSetSize. The value is 1.
	ServicePartitionStatusReady ServicePartitionStatus = "Ready"
	// ServicePartitionStatusReconfiguring Indicates that the partition is undergoing reconfiguration of its
	// replica sets. This can happen due to failover, upgrade, load balancing or addition or removal of
	// replicas from the replica set. The value is 4.
	ServicePartitionStatusReconfiguring ServicePartitionStatus = "Reconfiguring"
)

// PossibleServicePartitionStatusValues returns an array of possible values for the ServicePartitionStatus const type.
func PossibleServicePartitionStatusValues() []ServicePartitionStatus {
	return []ServicePartitionStatus{ServicePartitionStatusDeleting, ServicePartitionStatusInQuorumLoss, ServicePartitionStatusInvalid, ServicePartitionStatusNotReady, ServicePartitionStatusReady, ServicePartitionStatusReconfiguring}
}

// ServicePlacementPolicyType enumerates the values for service placement policy type.
type ServicePlacementPolicyType string

const (
	// ServicePlacementPolicyTypeInvalid Indicates the type of the placement policy is invalid. All Service
	// Fabric enumerations have the invalid type. The value is zero.
	ServicePlacementPolicyTypeInvalid ServicePlacementPolicyType = "Invalid"
	// ServicePlacementPolicyTypeInvalidDomain Indicates that the ServicePlacementPolicyDescription is of type
	// ServicePlacementInvalidDomainPolicyDescription, which indicates that a particular fault or upgrade
	// domain cannot be used for placement of this service. The value is 1.
	ServicePlacementPolicyTypeInvalidDomain ServicePlacementPolicyType = "InvalidDomain"
	// ServicePlacementPolicyTypeNonPartiallyPlaceService Indicates that the ServicePlacementPolicyDescription
	// is of type ServicePlacementNonPartiallyPlaceServicePolicyDescription, which indicates that if possible
	// all replicas of a particular partition of the service should be placed atomically. The value is 5.
	ServicePlacementPolicyTypeNonPartiallyPlaceService ServicePlacementPolicyType = "NonPartiallyPlaceService"
	// ServicePlacementPolicyTypePreferredPrimaryDomain Indicates that the ServicePlacementPolicyDescription is
	// of type ServicePlacementPreferPrimaryDomainPolicyDescription, which indicates that if possible the
	// Primary replica for the partitions of the service should be located in a particular domain as an
	// optimization. The value is 3.
	ServicePlacementPolicyTypePreferredPrimaryDomain ServicePlacementPolicyType = "PreferredPrimaryDomain"
	// ServicePlacementPolicyTypeRequiredDomain Indicates that the ServicePlacementPolicyDescription is of type
	// ServicePlacementRequireDomainDistributionPolicyDescription indicating that the replicas of the service
	// must be placed in a specific domain. The value is 2.
	ServicePlacementPolicyTypeRequiredDomain ServicePlacementPolicyType = "RequiredDomain"
	// ServicePlacementPolicyTypeRequiredDomainDistribution Indicates that the
	// ServicePlacementPolicyDescription is of type ServicePlacementRequireDomainDistributionPolicyDescription,
	// indicating that the system will disallow placement of any two replicas from the same partition in the
	// same domain at any time. The value is 4.
	ServicePlacementPolicyTypeRequiredDomainDistribution ServicePlacementPolicyType = "RequiredDomainDistribution"
)

// PossibleServicePlacementPolicyTypeValues returns an array of possible values for the ServicePlacementPolicyType const type.
func PossibleServicePlacementPolicyTypeValues() []ServicePlacementPolicyType {
	return []ServicePlacementPolicyType{ServicePlacementPolicyTypeInvalid, ServicePlacementPolicyTypeInvalidDomain, ServicePlacementPolicyTypeNonPartiallyPlaceService, ServicePlacementPolicyTypePreferredPrimaryDomain, ServicePlacementPolicyTypeRequiredDomain, ServicePlacementPolicyTypeRequiredDomainDistribution}
}

// ServiceResourceStatus enumerates the values for service resource status.
type ServiceResourceStatus string

const (
	// ServiceResourceStatusActive ...
	ServiceResourceStatusActive ServiceResourceStatus = "Active"
	// ServiceResourceStatusCreating ...
	ServiceResourceStatusCreating ServiceResourceStatus = "Creating"
	// ServiceResourceStatusDeleting ...
	ServiceResourceStatusDeleting ServiceResourceStatus = "Deleting"
	// ServiceResourceStatusFailed ...
	ServiceResourceStatusFailed ServiceResourceStatus = "Failed"
	// ServiceResourceStatusUnknown ...
	ServiceResourceStatusUnknown ServiceResourceStatus = "Unknown"
	// ServiceResourceStatusUpgrading ...
	ServiceResourceStatusUpgrading ServiceResourceStatus = "Upgrading"
)

// PossibleServiceResourceStatusValues returns an array of possible values for the ServiceResourceStatus const type.
func PossibleServiceResourceStatusValues() []ServiceResourceStatus {
	return []ServiceResourceStatus{ServiceResourceStatusActive, ServiceResourceStatusCreating, ServiceResourceStatusDeleting, ServiceResourceStatusFailed, ServiceResourceStatusUnknown, ServiceResourceStatusUpgrading}
}

// ServiceStatus enumerates the values for service status.
type ServiceStatus string

const (
	// ServiceStatusActive Indicates the service status is active. The value is 1.
	ServiceStatusActive ServiceStatus = "Active"
	// ServiceStatusCreating Indicates the service is being created. The value is 4.
	ServiceStatusCreating ServiceStatus = "Creating"
	// ServiceStatusDeleting Indicates the service is being deleted. The value is 3.
	ServiceStatusDeleting ServiceStatus = "Deleting"
	// ServiceStatusFailed Indicates creation or deletion was terminated due to persistent failures. Another
	// create/delete request can be accepted. The value is 5.
	ServiceStatusFailed ServiceStatus = "Failed"
	// ServiceStatusUnknown Indicates the service status is unknown. The value is zero.
	ServiceStatusUnknown ServiceStatus = "Unknown"
	// ServiceStatusUpgrading Indicates the service is upgrading. The value is 2.
	ServiceStatusUpgrading ServiceStatus = "Upgrading"
)

// PossibleServiceStatusValues returns an array of possible values for the ServiceStatus const type.
func PossibleServiceStatusValues() []ServiceStatus {
	return []ServiceStatus{ServiceStatusActive, ServiceStatusCreating, ServiceStatusDeleting, ServiceStatusFailed, ServiceStatusUnknown, ServiceStatusUpgrading}
}

// ServiceTypeRegistrationStatus enumerates the values for service type registration status.
type ServiceTypeRegistrationStatus string

const (
	// ServiceTypeRegistrationStatusDisabled Indicates that the service type is disabled on this node. A type
	// gets disabled when there are too many failures of the code package hosting the service type. If the
	// service type is disabled, new replicas of that service type will not be placed on the node until it is
	// enabled again. The service type is enabled again after the process hosting it comes up and re-registers
	// the type or a preconfigured time interval has passed. The value is 1.
	ServiceTypeRegistrationStatusDisabled ServiceTypeRegistrationStatus = "Disabled"
	// ServiceTypeRegistrationStatusEnabled Indicates that the service type is enabled on this node. Replicas
	// of this service type can be placed on this node when the code package registers the service type. The
	// value is 2.
	ServiceTypeRegistrationStatusEnabled ServiceTypeRegistrationStatus = "Enabled"
	// ServiceTypeRegistrationStatusInvalid Indicates the registration status is invalid. All Service Fabric
	// enumerations have the invalid type. The value is zero.
	ServiceTypeRegistrationStatusInvalid ServiceTypeRegistrationStatus = "Invalid"
	// ServiceTypeRegistrationStatusRegistered Indicates that the service type is enabled and registered on the
	// node by a code package. Replicas of this service type can now be placed on this node. The value is 3.
	ServiceTypeRegistrationStatusRegistered ServiceTypeRegistrationStatus = "Registered"
)

// PossibleServiceTypeRegistrationStatusValues returns an array of possible values for the ServiceTypeRegistrationStatus const type.
func PossibleServiceTypeRegistrationStatusValues() []ServiceTypeRegistrationStatus {
	return []ServiceTypeRegistrationStatus{ServiceTypeRegistrationStatusDisabled, ServiceTypeRegistrationStatusEnabled, ServiceTypeRegistrationStatusInvalid, ServiceTypeRegistrationStatusRegistered}
}

// State enumerates the values for state.
type State string

const (
	// StateApproved Indicates that the repair task has been approved by the Repair Manager and is safe to
	// execute.
	StateApproved State = "Approved"
	// StateClaimed Indicates that the repair task has been claimed by a repair executor.
	StateClaimed State = "Claimed"
	// StateCompleted Indicates that the repair task has completed, and no further state changes will occur.
	StateCompleted State = "Completed"
	// StateCreated Indicates that the repair task has been created.
	StateCreated State = "Created"
	// StateExecuting Indicates that execution of the repair task is in progress.
	StateExecuting State = "Executing"
	// StateInvalid Indicates that the repair task state is invalid. All Service Fabric enumerations have the
	// invalid value.
	StateInvalid State = "Invalid"
	// StatePreparing Indicates that the Repair Manager is preparing the system to handle the impact of the
	// repair task, usually by taking resources offline gracefully.
	StatePreparing State = "Preparing"
	// StateRestoring Indicates that the Repair Manager is restoring the system to its pre-repair state,
	// usually by bringing resources back online.
	StateRestoring State = "Restoring"
)

// PossibleStateValues returns an array of possible values for the State const type.
func PossibleStateValues() []State {
	return []State{StateApproved, StateClaimed, StateCompleted, StateCreated, StateExecuting, StateInvalid, StatePreparing, StateRestoring}
}

// StorageKind enumerates the values for storage kind.
type StorageKind string

const (
	// StorageKindAzureBlobStore ...
	StorageKindAzureBlobStore StorageKind = "AzureBlobStore"
	// StorageKindBackupStorageDescription ...
	StorageKindBackupStorageDescription StorageKind = "BackupStorageDescription"
	// StorageKindFileShare ...
	StorageKindFileShare StorageKind = "FileShare"
)

// PossibleStorageKindValues returns an array of possible values for the StorageKind const type.
func PossibleStorageKindValues() []StorageKind {
	return []StorageKind{StorageKindAzureBlobStore, StorageKindBackupStorageDescription, StorageKindFileShare}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeInvalidDomain ...
	TypeInvalidDomain Type = "InvalidDomain"
	// TypeNonPartiallyPlaceService ...
	TypeNonPartiallyPlaceService Type = "NonPartiallyPlaceService"
	// TypePreferredPrimaryDomain ...
	TypePreferredPrimaryDomain Type = "PreferredPrimaryDomain"
	// TypeRequiredDomain ...
	TypeRequiredDomain Type = "RequiredDomain"
	// TypeRequiredDomainDistribution ...
	TypeRequiredDomainDistribution Type = "RequiredDomainDistribution"
	// TypeServicePlacementPolicyDescription ...
	TypeServicePlacementPolicyDescription Type = "ServicePlacementPolicyDescription"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeInvalidDomain, TypeNonPartiallyPlaceService, TypePreferredPrimaryDomain, TypeRequiredDomain, TypeRequiredDomainDistribution, TypeServicePlacementPolicyDescription}
}

// UpgradeDomainState enumerates the values for upgrade domain state.
type UpgradeDomainState string

const (
	// UpgradeDomainStateCompleted The upgrade domain has completed upgrade. The value is 3
	UpgradeDomainStateCompleted UpgradeDomainState = "Completed"
	// UpgradeDomainStateInProgress The upgrade domain is being upgraded but not complete yet. The value is 2
	UpgradeDomainStateInProgress UpgradeDomainState = "InProgress"
	// UpgradeDomainStateInvalid Indicates the upgrade domain state is invalid. All Service Fabric enumerations
	// have the invalid type. The value is zero.
	UpgradeDomainStateInvalid UpgradeDomainState = "Invalid"
	// UpgradeDomainStatePending The upgrade domain has not started upgrading yet. The value is 1
	UpgradeDomainStatePending UpgradeDomainState = "Pending"
)

// PossibleUpgradeDomainStateValues returns an array of possible values for the UpgradeDomainState const type.
func PossibleUpgradeDomainStateValues() []UpgradeDomainState {
	return []UpgradeDomainState{UpgradeDomainStateCompleted, UpgradeDomainStateInProgress, UpgradeDomainStateInvalid, UpgradeDomainStatePending}
}

// UpgradeKind enumerates the values for upgrade kind.
type UpgradeKind string

const (
	// UpgradeKindInvalid Indicates the upgrade kind is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	UpgradeKindInvalid UpgradeKind = "Invalid"
	// UpgradeKindRolling The upgrade progresses one upgrade domain at a time. The value is 1
	UpgradeKindRolling UpgradeKind = "Rolling"
)

// PossibleUpgradeKindValues returns an array of possible values for the UpgradeKind const type.
func PossibleUpgradeKindValues() []UpgradeKind {
	return []UpgradeKind{UpgradeKindInvalid, UpgradeKindRolling}
}

// UpgradeMode enumerates the values for upgrade mode.
type UpgradeMode string

const (
	// UpgradeModeInvalid Indicates the upgrade mode is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	UpgradeModeInvalid UpgradeMode = "Invalid"
	// UpgradeModeMonitored The upgrade will stop after completing each upgrade domain and automatically
	// monitor health before proceeding. The value is 3
	UpgradeModeMonitored UpgradeMode = "Monitored"
	// UpgradeModeUnmonitoredAuto The upgrade will proceed automatically without performing any health
	// monitoring. The value is 1
	UpgradeModeUnmonitoredAuto UpgradeMode = "UnmonitoredAuto"
	// UpgradeModeUnmonitoredManual The upgrade will stop after completing each upgrade domain, giving the
	// opportunity to manually monitor health before proceeding. The value is 2
	UpgradeModeUnmonitoredManual UpgradeMode = "UnmonitoredManual"
)

// PossibleUpgradeModeValues returns an array of possible values for the UpgradeMode const type.
func PossibleUpgradeModeValues() []UpgradeMode {
	return []UpgradeMode{UpgradeModeInvalid, UpgradeModeMonitored, UpgradeModeUnmonitoredAuto, UpgradeModeUnmonitoredManual}
}

// UpgradeState enumerates the values for upgrade state.
type UpgradeState string

const (
	// UpgradeStateFailed The upgrade has failed and is unable to execute FailureAction. The value is 6
	UpgradeStateFailed UpgradeState = "Failed"
	// UpgradeStateInvalid Indicates the upgrade state is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	UpgradeStateInvalid UpgradeState = "Invalid"
	// UpgradeStateRollingBackCompleted The upgrade has finished rolling back. The value is 2
	UpgradeStateRollingBackCompleted UpgradeState = "RollingBackCompleted"
	// UpgradeStateRollingBackInProgress The upgrade is rolling back to the previous version but is not
	// complete yet. The value is 1
	UpgradeStateRollingBackInProgress UpgradeState = "RollingBackInProgress"
	// UpgradeStateRollingForwardCompleted The upgrade has finished rolling forward. The value is 5
	UpgradeStateRollingForwardCompleted UpgradeState = "RollingForwardCompleted"
	// UpgradeStateRollingForwardInProgress The upgrade is rolling forward to the target version but is not
	// complete yet. The value is 4
	UpgradeStateRollingForwardInProgress UpgradeState = "RollingForwardInProgress"
	// UpgradeStateRollingForwardPending The current upgrade domain has finished upgrading. The overall upgrade
	// is waiting for an explicit move next request in UnmonitoredManual mode or performing health checks in
	// Monitored mode. The value is 3
	UpgradeStateRollingForwardPending UpgradeState = "RollingForwardPending"
)

// PossibleUpgradeStateValues returns an array of possible values for the UpgradeState const type.
func PossibleUpgradeStateValues() []UpgradeState {
	return []UpgradeState{UpgradeStateFailed, UpgradeStateInvalid, UpgradeStateRollingBackCompleted, UpgradeStateRollingBackInProgress, UpgradeStateRollingForwardCompleted, UpgradeStateRollingForwardInProgress, UpgradeStateRollingForwardPending}
}

// UpgradeType enumerates the values for upgrade type.
type UpgradeType string

const (
	// UpgradeTypeInvalid Indicates the upgrade kind is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	UpgradeTypeInvalid UpgradeType = "Invalid"
	// UpgradeTypeRolling The upgrade progresses one upgrade domain at a time. The value is 1.
	UpgradeTypeRolling UpgradeType = "Rolling"
	// UpgradeTypeRollingForceRestart The upgrade gets restarted by force. The value is 2.
	UpgradeTypeRollingForceRestart UpgradeType = "Rolling_ForceRestart"
)

// PossibleUpgradeTypeValues returns an array of possible values for the UpgradeType const type.
func PossibleUpgradeTypeValues() []UpgradeType {
	return []UpgradeType{UpgradeTypeInvalid, UpgradeTypeRolling, UpgradeTypeRollingForceRestart}
}

// AadMetadata azure Active Directory metadata used for secured connection to cluster.
type AadMetadata struct {
	// Authority - The AAD authority url.
	Authority *string `json:"authority,omitempty"`
	// Client - The AAD client application Id.
	Client *string `json:"client,omitempty"`
	// Cluster - The AAD cluster application Id.
	Cluster *string `json:"cluster,omitempty"`
	// Login - The AAD login url.
	Login *string `json:"login,omitempty"`
	// Redirect - The client application redirect address.
	Redirect *string `json:"redirect,omitempty"`
	// Tenant - The AAD tenant Id.
	Tenant *string `json:"tenant,omitempty"`
}

// AadMetadataObject azure Active Directory metadata object used for secured connection to cluster.
type AadMetadataObject struct {
	autorest.Response `json:"-"`
	// Type - The client authentication method.
	Type *string `json:"type,omitempty"`
	// Metadata - Azure Active Directory metadata used for secured connection to cluster.
	Metadata *AadMetadata `json:"metadata,omitempty"`
}

// AddRemoveIncrementalNamedPartitionScalingMechanism represents a scaling mechanism for adding or removing
// named partitions of a stateless service. Partition names are in the format '0','1''N-1'
type AddRemoveIncrementalNamedPartitionScalingMechanism struct {
	// MinPartitionCount - Minimum number of named partitions of the service.
	MinPartitionCount *int32 `json:"MinPartitionCount,omitempty"`
	// MaxPartitionCount - Maximum number of named partitions of the service.
	MaxPartitionCount *int32 `json:"MaxPartitionCount,omitempty"`
	// ScaleIncrement - The number of instances to add or remove during a scaling operation.
	ScaleIncrement *int32 `json:"ScaleIncrement,omitempty"`
	// Kind - Possible values include: 'KindScalingMechanismDescription', 'KindPartitionInstanceCount', 'KindAddRemoveIncrementalNamedPartition'
	Kind KindBasicScalingMechanismDescription `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AddRemoveIncrementalNamedPartitionScalingMechanism.
func (arinpsm AddRemoveIncrementalNamedPartitionScalingMechanism) MarshalJSON() ([]byte, error) {
	arinpsm.Kind = KindAddRemoveIncrementalNamedPartition
	objectMap := make(map[string]interface{})
	if arinpsm.MinPartitionCount != nil {
		objectMap["MinPartitionCount"] = arinpsm.MinPartitionCount
	}
	if arinpsm.MaxPartitionCount != nil {
		objectMap["MaxPartitionCount"] = arinpsm.MaxPartitionCount
	}
	if arinpsm.ScaleIncrement != nil {
		objectMap["ScaleIncrement"] = arinpsm.ScaleIncrement
	}
	if arinpsm.Kind != "" {
		objectMap["Kind"] = arinpsm.Kind
	}
	return json.Marshal(objectMap)
}

// AsPartitionInstanceCountScaleMechanism is the BasicScalingMechanismDescription implementation for AddRemoveIncrementalNamedPartitionScalingMechanism.
func (arinpsm AddRemoveIncrementalNamedPartitionScalingMechanism) AsPartitionInstanceCountScaleMechanism() (*PartitionInstanceCountScaleMechanism, bool) {
	return nil, false
}

// AsAddRemoveIncrementalNamedPartitionScalingMechanism is the BasicScalingMechanismDescription implementation for AddRemoveIncrementalNamedPartitionScalingMechanism.
func (arinpsm AddRemoveIncrementalNamedPartitionScalingMechanism) AsAddRemoveIncrementalNamedPartitionScalingMechanism() (*AddRemoveIncrementalNamedPartitionScalingMechanism, bool) {
	return &arinpsm, true
}

// AsScalingMechanismDescription is the BasicScalingMechanismDescription implementation for AddRemoveIncrementalNamedPartitionScalingMechanism.
func (arinpsm AddRemoveIncrementalNamedPartitionScalingMechanism) AsScalingMechanismDescription() (*ScalingMechanismDescription, bool) {
	return nil, false
}

// AsBasicScalingMechanismDescription is the BasicScalingMechanismDescription implementation for AddRemoveIncrementalNamedPartitionScalingMechanism.
func (arinpsm AddRemoveIncrementalNamedPartitionScalingMechanism) AsBasicScalingMechanismDescription() (BasicScalingMechanismDescription, bool) {
	return &arinpsm, true
}

// AnalysisEventMetadata metadata about an Analysis Event.
type AnalysisEventMetadata struct {
	// Delay - The analysis delay.
	Delay *string `json:"Delay,omitempty"`
	// Duration - The duration of analysis.
	Duration *string `json:"Duration,omitempty"`
}

// ApplicationBackupConfigurationInfo backup configuration information for a specific Service Fabric
// application specifying what backup policy is being applied and suspend description, if any.
type ApplicationBackupConfigurationInfo struct {
	// ApplicationName - The name of the application, including the 'fabric:' URI scheme.
	ApplicationName *string `json:"ApplicationName,omitempty"`
	// PolicyName - The name of the backup policy which is applicable to this Service Fabric application or service or partition.
	PolicyName *string `json:"PolicyName,omitempty"`
	// PolicyInheritedFrom - Specifies the scope at which the backup policy is applied. Possible values include: 'BackupPolicyScopeInvalid', 'BackupPolicyScopePartition', 'BackupPolicyScopeService', 'BackupPolicyScopeApplication'
	PolicyInheritedFrom BackupPolicyScope `json:"PolicyInheritedFrom,omitempty"`
	// SuspensionInfo - Describes the backup suspension details.
	SuspensionInfo *BackupSuspensionInfo `json:"SuspensionInfo,omitempty"`
	// Kind - Possible values include: 'KindBasicBackupConfigurationInfoKindBackupConfigurationInfo', 'KindBasicBackupConfigurationInfoKindApplication', 'KindBasicBackupConfigurationInfoKindService', 'KindBasicBackupConfigurationInfoKindPartition'
	Kind KindBasicBackupConfigurationInfo `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationBackupConfigurationInfo.
func (abci ApplicationBackupConfigurationInfo) MarshalJSON() ([]byte, error) {
	abci.Kind = KindBasicBackupConfigurationInfoKindApplication
	objectMap := make(map[string]interface{})
	if abci.ApplicationName != nil {
		objectMap["ApplicationName"] = abci.ApplicationName
	}
	if abci.PolicyName != nil {
		objectMap["PolicyName"] = abci.PolicyName
	}
	if abci.PolicyInheritedFrom != "" {
		objectMap["PolicyInheritedFrom"] = abci.PolicyInheritedFrom
	}
	if abci.SuspensionInfo != nil {
		objectMap["SuspensionInfo"] = abci.SuspensionInfo
	}
	if abci.Kind != "" {
		objectMap["Kind"] = abci.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationBackupConfigurationInfo is the BasicBackupConfigurationInfo implementation for ApplicationBackupConfigurationInfo.
func (abci ApplicationBackupConfigurationInfo) AsApplicationBackupConfigurationInfo() (*ApplicationBackupConfigurationInfo, bool) {
	return &abci, true
}

// AsServiceBackupConfigurationInfo is the BasicBackupConfigurationInfo implementation for ApplicationBackupConfigurationInfo.
func (abci ApplicationBackupConfigurationInfo) AsServiceBackupConfigurationInfo() (*ServiceBackupConfigurationInfo, bool) {
	return nil, false
}

// AsPartitionBackupConfigurationInfo is the BasicBackupConfigurationInfo implementation for ApplicationBackupConfigurationInfo.
func (abci ApplicationBackupConfigurationInfo) AsPartitionBackupConfigurationInfo() (*PartitionBackupConfigurationInfo, bool) {
	return nil, false
}

// AsBackupConfigurationInfo is the BasicBackupConfigurationInfo implementation for ApplicationBackupConfigurationInfo.
func (abci ApplicationBackupConfigurationInfo) AsBackupConfigurationInfo() (*BackupConfigurationInfo, bool) {
	return nil, false
}

// AsBasicBackupConfigurationInfo is the BasicBackupConfigurationInfo implementation for ApplicationBackupConfigurationInfo.
func (abci ApplicationBackupConfigurationInfo) AsBasicBackupConfigurationInfo() (BasicBackupConfigurationInfo, bool) {
	return &abci, true
}

// ApplicationBackupEntity identifies the Service Fabric application which is being backed up.
type ApplicationBackupEntity struct {
	// ApplicationName - The name of the application, including the 'fabric:' URI scheme.
	ApplicationName *string `json:"ApplicationName,omitempty"`
	// EntityKind - Possible values include: 'EntityKindBackupEntity', 'EntityKindApplication1', 'EntityKindService1', 'EntityKindPartition1'
	EntityKind EntityKindBasicBackupEntity `json:"EntityKind,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationBackupEntity.
func (abe ApplicationBackupEntity) MarshalJSON() ([]byte, error) {
	abe.EntityKind = EntityKindApplication1
	objectMap := make(map[string]interface{})
	if abe.ApplicationName != nil {
		objectMap["ApplicationName"] = abe.ApplicationName
	}
	if abe.EntityKind != "" {
		objectMap["EntityKind"] = abe.EntityKind
	}
	return json.Marshal(objectMap)
}

// AsApplicationBackupEntity is the BasicBackupEntity implementation for ApplicationBackupEntity.
func (abe ApplicationBackupEntity) AsApplicationBackupEntity() (*ApplicationBackupEntity, bool) {
	return &abe, true
}

// AsServiceBackupEntity is the BasicBackupEntity implementation for ApplicationBackupEntity.
func (abe ApplicationBackupEntity) AsServiceBackupEntity() (*ServiceBackupEntity, bool) {
	return nil, false
}

// AsPartitionBackupEntity is the BasicBackupEntity implementation for ApplicationBackupEntity.
func (abe ApplicationBackupEntity) AsPartitionBackupEntity() (*PartitionBackupEntity, bool) {
	return nil, false
}

// AsBackupEntity is the BasicBackupEntity implementation for ApplicationBackupEntity.
func (abe ApplicationBackupEntity) AsBackupEntity() (*BackupEntity, bool) {
	return nil, false
}

// AsBasicBackupEntity is the BasicBackupEntity implementation for ApplicationBackupEntity.
func (abe ApplicationBackupEntity) AsBasicBackupEntity() (BasicBackupEntity, bool) {
	return &abe, true
}

// ApplicationCapacityDescription describes capacity information for services of this application. This
// description can be used for describing the following.
// - Reserving the capacity for the services on the nodes
// - Limiting the total number of nodes that services of this application can run on
// - Limiting the custom capacity metrics to limit the total consumption of this metric by the services of
// this application
type ApplicationCapacityDescription struct {
	// MinimumNodes - The minimum number of nodes where Service Fabric will reserve capacity for this application. Note that this does not mean that the services of this application will be placed on all of those nodes. If this property is set to zero, no capacity will be reserved. The value of this property cannot be more than the value of the MaximumNodes property.
	MinimumNodes *int64 `json:"MinimumNodes,omitempty"`
	// MaximumNodes - The maximum number of nodes where Service Fabric will reserve capacity for this application. Note that this does not mean that the services of this application will be placed on all of those nodes. By default, the value of this property is zero and it means that the services can be placed on any node.
	MaximumNodes *int64 `json:"MaximumNodes,omitempty"`
	// ApplicationMetrics - List of application capacity metric description.
	ApplicationMetrics *[]ApplicationMetricDescription `json:"ApplicationMetrics,omitempty"`
}

// ApplicationCreatedEvent application Created event.
type ApplicationCreatedEvent struct {
	// ApplicationTypeName - Application type name.
	ApplicationTypeName *string `json:"ApplicationTypeName,omitempty"`
	// ApplicationTypeVersion - Application type version.
	ApplicationTypeVersion *string `json:"ApplicationTypeVersion,omitempty"`
	// ApplicationDefinitionKind - Application definition kind.
	ApplicationDefinitionKind *string `json:"ApplicationDefinitionKind,omitempty"`
	// ApplicationID - The identity of the application. This is an encoded representation of the application name. This is used in the REST APIs to identify the application resource.
	// Starting in version 6.0, hierarchical names are delimited with the "\~" character. For example, if the application name is "fabric:/myapp/app1",
	// the application identity would be "myapp\~app1" in 6.0+ and "myapp/app1" in previous versions.
	ApplicationID *string `json:"ApplicationId,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationHealthReportCreated', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeComplete', 'KindApplicationUpgradeDomainComplete', 'KindApplicationUpgradeRollbackComplete', 'KindApplicationUpgradeRollbackStart', 'KindApplicationUpgradeStart', 'KindDeployedApplicationHealthReportCreated', 'KindDeployedApplicationHealthReportExpired', 'KindProcessDeactivated', 'KindContainerDeactivated', 'KindNodeAborted', 'KindNodeAborting', 'KindNodeAdded', 'KindNodeClose', 'KindNodeClosing', 'KindNodeDeactivateComplete', 'KindNodeDeactivateStart', 'KindNodeDown', 'KindNodeHealthReportCreated', 'KindNodeHealthReportExpired', 'KindNodeOpenedSuccess', 'KindNodeOpenFailed', 'KindNodeOpening', 'KindNodeRemoved', 'KindNodeUp', 'KindPartitionHealthReportCreated', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigurationCompleted', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceHealthReportCreated', 'KindServiceHealthReportExpired', 'KindDeployedServiceHealthReportCreated', 'KindDeployedServiceHealthReportExpired', 'KindStatefulReplicaHealthReportCreated', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaHealthReportCreated', 'KindStatelessReplicaHealthReportExpired', 'KindClusterHealthReportCreated', 'KindClusterHealthReportExpired', 'KindClusterUpgradeComplete', 'KindClusterUpgradeDomainComplete', 'KindClusterUpgradeRollbackComplete', 'KindClusterUpgradeRollbackStart', 'KindClusterUpgradeStart', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosRestartNodeFaultCompleted', 'KindChaosRestartCodePackageFaultScheduled', 'KindChaosRestartCodePackageFaultCompleted', 'KindChaosRemoveReplicaFaultScheduled', 'KindChaosRemoveReplicaFaultCompleted', 'KindChaosMoveSecondaryFaultScheduled', 'KindChaosMovePrimaryFaultScheduled', 'KindChaosRestartReplicaFaultScheduled', 'KindChaosRestartNodeFaultScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) MarshalJSON() ([]byte, error) {
	ace.Kind = KindApplicationCreated
	objectMap := make(map[string]interface{})
	if ace.ApplicationTypeName != nil {
		objectMap["ApplicationTypeName"] = ace.ApplicationTypeName
	}
	if ace.ApplicationTypeVersion != nil {
		objectMap["ApplicationTypeVersion"] = ace.ApplicationTypeVersion
	}
	if ace.ApplicationDefinitionKind != nil {
		objectMap["ApplicationDefinitionKind"] = ace.ApplicationDefinitionKind
	}
	if ace.ApplicationID != nil {
		objectMap["ApplicationId"] = ace.ApplicationID
	}
	if ace.EventInstanceID != nil {
		objectMap["EventInstanceId"] = ace.EventInstanceID
	}
	if ace.TimeStamp != nil {
		objectMap["TimeStamp"] = ace.TimeStamp
	}
	if ace.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = ace.HasCorrelatedEvents
	}
	if ace.Kind != "" {
		objectMap["Kind"] = ace.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return &ace, true
}

// AsClusterEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return nil, false
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return &ace, true
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsApplicationHealthReportCreatedEvent() (*ApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompleteEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsApplicationUpgradeCompleteEvent() (*ApplicationUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsApplicationUpgradeDomainCompleteEvent() (*ApplicationUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsApplicationUpgradeRollbackCompleteEvent() (*ApplicationUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsApplicationUpgradeRollbackStartEvent() (*ApplicationUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsApplicationUpgradeStartEvent() (*ApplicationUpgradeStartEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsDeployedApplicationHealthReportCreatedEvent() (*DeployedApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsProcessDeactivatedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsProcessDeactivatedEvent() (*ProcessDeactivatedEvent, bool) {
	return nil, false
}

// AsContainerDeactivatedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsContainerDeactivatedEvent() (*ContainerDeactivatedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAbortingEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsNodeAbortingEvent() (*NodeAbortingEvent, bool) {
	return nil, false
}

// AsNodeAddedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsNodeAddedEvent() (*NodeAddedEvent, bool) {
	return nil, false
}

// AsNodeCloseEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsNodeCloseEvent() (*NodeCloseEvent, bool) {
	return nil, false
}

// AsNodeClosingEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsNodeClosingEvent() (*NodeClosingEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompleteEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsNodeDeactivateCompleteEvent() (*NodeDeactivateCompleteEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsNodeDeactivateStartEvent() (*NodeDeactivateStartEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsNodeHealthReportCreatedEvent() (*NodeHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenedSuccessEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsNodeOpenedSuccessEvent() (*NodeOpenedSuccessEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeOpeningEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsNodeOpeningEvent() (*NodeOpeningEvent, bool) {
	return nil, false
}

// AsNodeRemovedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsNodeRemovedEvent() (*NodeRemovedEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsPartitionHealthReportCreatedEvent() (*PartitionHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfigurationCompletedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsPartitionReconfigurationCompletedEvent() (*PartitionReconfigurationCompletedEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsServiceHealthReportCreatedEvent() (*ServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsDeployedServiceHealthReportCreatedEvent() (*DeployedServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsDeployedServiceHealthReportExpiredEvent() (*DeployedServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsStatefulReplicaHealthReportCreatedEvent() (*StatefulReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsStatelessReplicaHealthReportCreatedEvent() (*StatelessReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsClusterHealthReportCreatedEvent() (*ClusterHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompleteEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsClusterUpgradeCompleteEvent() (*ClusterUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsClusterUpgradeDomainCompleteEvent() (*ClusterUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsClusterUpgradeRollbackCompleteEvent() (*ClusterUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsClusterUpgradeRollbackStartEvent() (*ClusterUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsClusterUpgradeStartEvent() (*ClusterUpgradeStartEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultCompletedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsChaosRestartNodeFaultCompletedEvent() (*ChaosRestartNodeFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsChaosRestartCodePackageFaultScheduledEvent() (*ChaosRestartCodePackageFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultCompletedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsChaosRestartCodePackageFaultCompletedEvent() (*ChaosRestartCodePackageFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsChaosRemoveReplicaFaultScheduledEvent() (*ChaosRemoveReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultCompletedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsChaosRemoveReplicaFaultCompletedEvent() (*ChaosRemoveReplicaFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosMoveSecondaryFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsChaosMoveSecondaryFaultScheduledEvent() (*ChaosMoveSecondaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosMovePrimaryFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsChaosMovePrimaryFaultScheduledEvent() (*ChaosMovePrimaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsChaosRestartReplicaFaultScheduledEvent() (*ChaosRestartReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsChaosRestartNodeFaultScheduledEvent() (*ChaosRestartNodeFaultScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &ace, true
}

// ApplicationDeletedEvent application Deleted event.
type ApplicationDeletedEvent struct {
	// ApplicationTypeName - Application type name.
	ApplicationTypeName *string `json:"ApplicationTypeName,omitempty"`
	// ApplicationTypeVersion - Application type version.
	ApplicationTypeVersion *string `json:"ApplicationTypeVersion,omitempty"`
	// ApplicationID - The identity of the application. This is an encoded representation of the application name. This is used in the REST APIs to identify the application resource.
	// Starting in version 6.0, hierarchical names are delimited with the "\~" character. For example, if the application name is "fabric:/myapp/app1",
	// the application identity would be "myapp\~app1" in 6.0+ and "myapp/app1" in previous versions.
	ApplicationID *string `json:"ApplicationId,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationHealthReportCreated', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeComplete', 'KindApplicationUpgradeDomainComplete', 'KindApplicationUpgradeRollbackComplete', 'KindApplicationUpgradeRollbackStart', 'KindApplicationUpgradeStart', 'KindDeployedApplicationHealthReportCreated', 'KindDeployedApplicationHealthReportExpired', 'KindProcessDeactivated', 'KindContainerDeactivated', 'KindNodeAborted', 'KindNodeAborting', 'KindNodeAdded', 'KindNodeClose', 'KindNodeClosing', 'KindNodeDeactivateComplete', 'KindNodeDeactivateStart', 'KindNodeDown', 'KindNodeHealthReportCreated', 'KindNodeHealthReportExpired', 'KindNodeOpenedSuccess', 'KindNodeOpenFailed', 'KindNodeOpening', 'KindNodeRemoved', 'KindNodeUp', 'KindPartitionHealthReportCreated', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigurationCompleted', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceHealthReportCreated', 'KindServiceHealthReportExpired', 'KindDeployedServiceHealthReportCreated', 'KindDeployedServiceHealthReportExpired', 'KindStatefulReplicaHealthReportCreated', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaHealthReportCreated', 'KindStatelessReplicaHealthReportExpired', 'KindClusterHealthReportCreated', 'KindClusterHealthReportExpired', 'KindClusterUpgradeComplete', 'KindClusterUpgradeDomainComplete', 'KindClusterUpgradeRollbackComplete', 'KindClusterUpgradeRollbackStart', 'KindClusterUpgradeStart', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosRestartNodeFaultCompleted', 'KindChaosRestartCodePackageFaultScheduled', 'KindChaosRestartCodePackageFaultCompleted', 'KindChaosRemoveReplicaFaultScheduled', 'KindChaosRemoveReplicaFaultCompleted', 'KindChaosMoveSecondaryFaultScheduled', 'KindChaosMovePrimaryFaultScheduled', 'KindChaosRestartReplicaFaultScheduled', 'KindChaosRestartNodeFaultScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) MarshalJSON() ([]byte, error) {
	ade.Kind = KindApplicationDeleted
	objectMap := make(map[string]interface{})
	if ade.ApplicationTypeName != nil {
		objectMap["ApplicationTypeName"] = ade.ApplicationTypeName
	}
	if ade.ApplicationTypeVersion != nil {
		objectMap["ApplicationTypeVersion"] = ade.ApplicationTypeVersion
	}
	if ade.ApplicationID != nil {
		objectMap["ApplicationId"] = ade.ApplicationID
	}
	if ade.EventInstanceID != nil {
		objectMap["EventInstanceId"] = ade.EventInstanceID
	}
	if ade.TimeStamp != nil {
		objectMap["TimeStamp"] = ade.TimeStamp
	}
	if ade.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = ade.HasCorrelatedEvents
	}
	if ade.Kind != "" {
		objectMap["Kind"] = ade.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return &ade, true
}

// AsClusterEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return nil, false
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return &ade, true
}

// AsApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsApplicationHealthReportCreatedEvent() (*ApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompleteEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsApplicationUpgradeCompleteEvent() (*ApplicationUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsApplicationUpgradeDomainCompleteEvent() (*ApplicationUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsApplicationUpgradeRollbackCompleteEvent() (*ApplicationUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsApplicationUpgradeRollbackStartEvent() (*ApplicationUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsApplicationUpgradeStartEvent() (*ApplicationUpgradeStartEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsDeployedApplicationHealthReportCreatedEvent() (*DeployedApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsProcessDeactivatedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsProcessDeactivatedEvent() (*ProcessDeactivatedEvent, bool) {
	return nil, false
}

// AsContainerDeactivatedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsContainerDeactivatedEvent() (*ContainerDeactivatedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAbortingEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsNodeAbortingEvent() (*NodeAbortingEvent, bool) {
	return nil, false
}

// AsNodeAddedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsNodeAddedEvent() (*NodeAddedEvent, bool) {
	return nil, false
}

// AsNodeCloseEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsNodeCloseEvent() (*NodeCloseEvent, bool) {
	return nil, false
}

// AsNodeClosingEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsNodeClosingEvent() (*NodeClosingEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompleteEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsNodeDeactivateCompleteEvent() (*NodeDeactivateCompleteEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsNodeDeactivateStartEvent() (*NodeDeactivateStartEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsNodeHealthReportCreatedEvent() (*NodeHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenedSuccessEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsNodeOpenedSuccessEvent() (*NodeOpenedSuccessEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeOpeningEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsNodeOpeningEvent() (*NodeOpeningEvent, bool) {
	return nil, false
}

// AsNodeRemovedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsNodeRemovedEvent() (*NodeRemovedEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsPartitionHealthReportCreatedEvent() (*PartitionHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfigurationCompletedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsPartitionReconfigurationCompletedEvent() (*PartitionReconfigurationCompletedEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsServiceHealthReportCreatedEvent() (*ServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsDeployedServiceHealthReportCreatedEvent() (*DeployedServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsDeployedServiceHealthReportExpiredEvent() (*DeployedServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsStatefulReplicaHealthReportCreatedEvent() (*StatefulReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsStatelessReplicaHealthReportCreatedEvent() (*StatelessReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsClusterHealthReportCreatedEvent() (*ClusterHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompleteEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsClusterUpgradeCompleteEvent() (*ClusterUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsClusterUpgradeDomainCompleteEvent() (*ClusterUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsClusterUpgradeRollbackCompleteEvent() (*ClusterUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsClusterUpgradeRollbackStartEvent() (*ClusterUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsClusterUpgradeStartEvent() (*ClusterUpgradeStartEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultCompletedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsChaosRestartNodeFaultCompletedEvent() (*ChaosRestartNodeFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsChaosRestartCodePackageFaultScheduledEvent() (*ChaosRestartCodePackageFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultCompletedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsChaosRestartCodePackageFaultCompletedEvent() (*ChaosRestartCodePackageFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsChaosRemoveReplicaFaultScheduledEvent() (*ChaosRemoveReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultCompletedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsChaosRemoveReplicaFaultCompletedEvent() (*ChaosRemoveReplicaFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosMoveSecondaryFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsChaosMoveSecondaryFaultScheduledEvent() (*ChaosMoveSecondaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosMovePrimaryFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsChaosMovePrimaryFaultScheduledEvent() (*ChaosMovePrimaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsChaosRestartReplicaFaultScheduledEvent() (*ChaosRestartReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsChaosRestartNodeFaultScheduledEvent() (*ChaosRestartNodeFaultScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &ade, true
}

// ApplicationDescription describes a Service Fabric application.
type ApplicationDescription struct {
	// Name - The name of the application, including the 'fabric:' URI scheme.
	Name *string `json:"Name,omitempty"`
	// TypeName - The application type name as defined in the application manifest.
	TypeName *string `json:"TypeName,omitempty"`
	// TypeVersion - The version of the application type as defined in the application manifest.
	TypeVersion *string `json:"TypeVersion,omitempty"`
	// ParameterList - List of application parameters with overridden values from their default values specified in the application manifest.
	ParameterList *[]ApplicationParameter `json:"ParameterList,omitempty"`
	// ApplicationCapacity - Describes capacity information for services of this application. This description can be used for describing the following.
	// - Reserving the capacity for the services on the nodes
	// - Limiting the total number of nodes that services of this application can run on
	// - Limiting the custom capacity metrics to limit the total consumption of this metric by the services of this application
	ApplicationCapacity *ApplicationCapacityDescription `json:"ApplicationCapacity,omitempty"`
}

// BasicApplicationEvent represents the base for all Application Events.
type BasicApplicationEvent interface {
	AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool)
	AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool)
	AsApplicationHealthReportCreatedEvent() (*ApplicationHealthReportCreatedEvent, bool)
	AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool)
	AsApplicationUpgradeCompleteEvent() (*ApplicationUpgradeCompleteEvent, bool)
	AsApplicationUpgradeDomainCompleteEvent() (*ApplicationUpgradeDomainCompleteEvent, bool)
	AsApplicationUpgradeRollbackCompleteEvent() (*ApplicationUpgradeRollbackCompleteEvent, bool)
	AsApplicationUpgradeRollbackStartEvent() (*ApplicationUpgradeRollbackStartEvent, bool)
	AsApplicationUpgradeStartEvent() (*ApplicationUpgradeStartEvent, bool)
	AsDeployedApplicationHealthReportCreatedEvent() (*DeployedApplicationHealthReportCreatedEvent, bool)
	AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool)
	AsProcessDeactivatedEvent() (*ProcessDeactivatedEvent, bool)
	AsContainerDeactivatedEvent() (*ContainerDeactivatedEvent, bool)
	AsDeployedServiceHealthReportCreatedEvent() (*DeployedServiceHealthReportCreatedEvent, bool)
	AsDeployedServiceHealthReportExpiredEvent() (*DeployedServiceHealthReportExpiredEvent, bool)
	AsChaosRestartCodePackageFaultScheduledEvent() (*ChaosRestartCodePackageFaultScheduledEvent, bool)
	AsChaosRestartCodePackageFaultCompletedEvent() (*ChaosRestartCodePackageFaultCompletedEvent, bool)
	AsApplicationEvent() (*ApplicationEvent, bool)
}

// ApplicationEvent represents the base for all Application Events.
type ApplicationEvent struct {
	// ApplicationID - The identity of the application. This is an encoded representation of the application name. This is used in the REST APIs to identify the application resource.
	// Starting in version 6.0, hierarchical names are delimited with the "\~" character. For example, if the application name is "fabric:/myapp/app1",
	// the application identity would be "myapp\~app1" in 6.0+ and "myapp/app1" in previous versions.
	ApplicationID *string `json:"ApplicationId,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationHealthReportCreated', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeComplete', 'KindApplicationUpgradeDomainComplete', 'KindApplicationUpgradeRollbackComplete', 'KindApplicationUpgradeRollbackStart', 'KindApplicationUpgradeStart', 'KindDeployedApplicationHealthReportCreated', 'KindDeployedApplicationHealthReportExpired', 'KindProcessDeactivated', 'KindContainerDeactivated', 'KindNodeAborted', 'KindNodeAborting', 'KindNodeAdded', 'KindNodeClose', 'KindNodeClosing', 'KindNodeDeactivateComplete', 'KindNodeDeactivateStart', 'KindNodeDown', 'KindNodeHealthReportCreated', 'KindNodeHealthReportExpired', 'KindNodeOpenedSuccess', 'KindNodeOpenFailed', 'KindNodeOpening', 'KindNodeRemoved', 'KindNodeUp', 'KindPartitionHealthReportCreated', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigurationCompleted', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceHealthReportCreated', 'KindServiceHealthReportExpired', 'KindDeployedServiceHealthReportCreated', 'KindDeployedServiceHealthReportExpired', 'KindStatefulReplicaHealthReportCreated', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaHealthReportCreated', 'KindStatelessReplicaHealthReportExpired', 'KindClusterHealthReportCreated', 'KindClusterHealthReportExpired', 'KindClusterUpgradeComplete', 'KindClusterUpgradeDomainComplete', 'KindClusterUpgradeRollbackComplete', 'KindClusterUpgradeRollbackStart', 'KindClusterUpgradeStart', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosRestartNodeFaultCompleted', 'KindChaosRestartCodePackageFaultScheduled', 'KindChaosRestartCodePackageFaultCompleted', 'KindChaosRemoveReplicaFaultScheduled', 'KindChaosRemoveReplicaFaultCompleted', 'KindChaosMoveSecondaryFaultScheduled', 'KindChaosMovePrimaryFaultScheduled', 'KindChaosRestartReplicaFaultScheduled', 'KindChaosRestartNodeFaultScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

func unmarshalBasicApplicationEvent(body []byte) (BasicApplicationEvent, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["Kind"] {
	case string(KindApplicationCreated):
		var ace ApplicationCreatedEvent
		err := json.Unmarshal(body, &ace)
		return ace, err
	case string(KindApplicationDeleted):
		var ade ApplicationDeletedEvent
		err := json.Unmarshal(body, &ade)
		return ade, err
	case string(KindApplicationHealthReportCreated):
		var ahrce ApplicationHealthReportCreatedEvent
		err := json.Unmarshal(body, &ahrce)
		return ahrce, err
	case string(KindApplicationHealthReportExpired):
		var ahree ApplicationHealthReportExpiredEvent
		err := json.Unmarshal(body, &ahree)
		return ahree, err
	case string(KindApplicationUpgradeComplete):
		var auce ApplicationUpgradeCompleteEvent
		err := json.Unmarshal(body, &auce)
		return auce, err
	case string(KindApplicationUpgradeDomainComplete):
		var audce ApplicationUpgradeDomainCompleteEvent
		err := json.Unmarshal(body, &audce)
		return audce, err
	case string(KindApplicationUpgradeRollbackComplete):
		var aurce ApplicationUpgradeRollbackCompleteEvent
		err := json.Unmarshal(body, &aurce)
		return aurce, err
	case string(KindApplicationUpgradeRollbackStart):
		var aurse ApplicationUpgradeRollbackStartEvent
		err := json.Unmarshal(body, &aurse)
		return aurse, err
	case string(KindApplicationUpgradeStart):
		var ause ApplicationUpgradeStartEvent
		err := json.Unmarshal(body, &ause)
		return ause, err
	case string(KindDeployedApplicationHealthReportCreated):
		var dahrce DeployedApplicationHealthReportCreatedEvent
		err := json.Unmarshal(body, &dahrce)
		return dahrce, err
	case string(KindDeployedApplicationHealthReportExpired):
		var dahree DeployedApplicationHealthReportExpiredEvent
		err := json.Unmarshal(body, &dahree)
		return dahree, err
	case string(KindProcessDeactivated):
		var pde ProcessDeactivatedEvent
		err := json.Unmarshal(body, &pde)
		return pde, err
	case string(KindContainerDeactivated):
		var cde ContainerDeactivatedEvent
		err := json.Unmarshal(body, &cde)
		return cde, err
	case string(KindDeployedServiceHealthReportCreated):
		var dshrce DeployedServiceHealthReportCreatedEvent
		err := json.Unmarshal(body, &dshrce)
		return dshrce, err
	case string(KindDeployedServiceHealthReportExpired):
		var dshree DeployedServiceHealthReportExpiredEvent
		err := json.Unmarshal(body, &dshree)
		return dshree, err
	case string(KindChaosRestartCodePackageFaultScheduled):
		var crcpfse ChaosRestartCodePackageFaultScheduledEvent
		err := json.Unmarshal(body, &crcpfse)
		return crcpfse, err
	case string(KindChaosRestartCodePackageFaultCompleted):
		var crcpfce ChaosRestartCodePackageFaultCompletedEvent
		err := json.Unmarshal(body, &crcpfce)
		return crcpfce, err
	default:
		var ae ApplicationEvent
		err := json.Unmarshal(body, &ae)
		return ae, err
	}
}
func unmarshalBasicApplicationEventArray(body []byte) ([]BasicApplicationEvent, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	aeArray := make([]BasicApplicationEvent, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ae, err := unmarshalBasicApplicationEvent(*rawMessage)
		if err != nil {
			return nil, err
		}
		aeArray[index] = ae
	}
	return aeArray, nil
}

// MarshalJSON is the custom marshaler for ApplicationEvent.
func (ae ApplicationEvent) MarshalJSON() ([]byte, error) {
	ae.Kind = KindApplicationEvent
	objectMap := make(map[string]interface{})
	if ae.ApplicationID != nil {
		objectMap["ApplicationId"] = ae.ApplicationID
	}
	if ae.EventInstanceID != nil {
		objectMap["EventInstanceId"] = ae.EventInstanceID
	}
	if ae.TimeStamp != nil {
		objectMap["TimeStamp"] = ae.TimeStamp
	}
	if ae.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = ae.HasCorrelatedEvents
	}
	if ae.Kind != "" {
		objectMap["Kind"] = ae.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return &ae, true
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return &ae, true
}

// AsClusterEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return nil, false
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsApplicationHealthReportCreatedEvent() (*ApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompleteEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsApplicationUpgradeCompleteEvent() (*ApplicationUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsApplicationUpgradeDomainCompleteEvent() (*ApplicationUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsApplicationUpgradeRollbackCompleteEvent() (*ApplicationUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsApplicationUpgradeRollbackStartEvent() (*ApplicationUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsApplicationUpgradeStartEvent() (*ApplicationUpgradeStartEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsDeployedApplicationHealthReportCreatedEvent() (*DeployedApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsProcessDeactivatedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsProcessDeactivatedEvent() (*ProcessDeactivatedEvent, bool) {
	return nil, false
}

// AsContainerDeactivatedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsContainerDeactivatedEvent() (*ContainerDeactivatedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAbortingEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsNodeAbortingEvent() (*NodeAbortingEvent, bool) {
	return nil, false
}

// AsNodeAddedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsNodeAddedEvent() (*NodeAddedEvent, bool) {
	return nil, false
}

// AsNodeCloseEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsNodeCloseEvent() (*NodeCloseEvent, bool) {
	return nil, false
}

// AsNodeClosingEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsNodeClosingEvent() (*NodeClosingEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompleteEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsNodeDeactivateCompleteEvent() (*NodeDeactivateCompleteEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsNodeDeactivateStartEvent() (*NodeDeactivateStartEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsNodeHealthReportCreatedEvent() (*NodeHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenedSuccessEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsNodeOpenedSuccessEvent() (*NodeOpenedSuccessEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeOpeningEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsNodeOpeningEvent() (*NodeOpeningEvent, bool) {
	return nil, false
}

// AsNodeRemovedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsNodeRemovedEvent() (*NodeRemovedEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsPartitionHealthReportCreatedEvent() (*PartitionHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfigurationCompletedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsPartitionReconfigurationCompletedEvent() (*PartitionReconfigurationCompletedEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsServiceHealthReportCreatedEvent() (*ServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsDeployedServiceHealthReportCreatedEvent() (*DeployedServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsDeployedServiceHealthReportExpiredEvent() (*DeployedServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsStatefulReplicaHealthReportCreatedEvent() (*StatefulReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsStatelessReplicaHealthReportCreatedEvent() (*StatelessReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsClusterHealthReportCreatedEvent() (*ClusterHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompleteEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsClusterUpgradeCompleteEvent() (*ClusterUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsClusterUpgradeDomainCompleteEvent() (*ClusterUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsClusterUpgradeRollbackCompleteEvent() (*ClusterUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsClusterUpgradeRollbackStartEvent() (*ClusterUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsClusterUpgradeStartEvent() (*ClusterUpgradeStartEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultCompletedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsChaosRestartNodeFaultCompletedEvent() (*ChaosRestartNodeFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsChaosRestartCodePackageFaultScheduledEvent() (*ChaosRestartCodePackageFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultCompletedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsChaosRestartCodePackageFaultCompletedEvent() (*ChaosRestartCodePackageFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsChaosRemoveReplicaFaultScheduledEvent() (*ChaosRemoveReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultCompletedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsChaosRemoveReplicaFaultCompletedEvent() (*ChaosRemoveReplicaFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosMoveSecondaryFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsChaosMoveSecondaryFaultScheduledEvent() (*ChaosMoveSecondaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosMovePrimaryFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsChaosMovePrimaryFaultScheduledEvent() (*ChaosMovePrimaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsChaosRestartReplicaFaultScheduledEvent() (*ChaosRestartReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsChaosRestartNodeFaultScheduledEvent() (*ChaosRestartNodeFaultScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &ae, true
}

// ApplicationHealth represents the health of the application. Contains the application aggregated health
// state and the service and deployed application health states.
type ApplicationHealth struct {
	autorest.Response `json:"-"`
	// Name - The name of the application, including the 'fabric:' URI scheme.
	Name *string `json:"Name,omitempty"`
	// ServiceHealthStates - Service health states as found in the health store.
	ServiceHealthStates *[]ServiceHealthState `json:"ServiceHealthStates,omitempty"`
	// DeployedApplicationHealthStates - Deployed application health states as found in the health store.
	DeployedApplicationHealthStates *[]DeployedApplicationHealthState `json:"DeployedApplicationHealthStates,omitempty"`
	// AggregatedHealthState - The HealthState representing the aggregated health state of the entity computed by Health Manager.
	// The health evaluation of the entity reflects all events reported on the entity and its children (if any).
	// The aggregation is done by applying the desired health policy. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
	// HealthEvents - The list of health events reported on the entity.
	HealthEvents *[]HealthEvent `json:"HealthEvents,omitempty"`
	// UnhealthyEvaluations - The unhealthy evaluations that show why the current aggregated health state was returned by Health Manager.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// HealthStatistics - Shows the health statistics for all children types of the queried entity.
	HealthStatistics *HealthStatistics `json:"HealthStatistics,omitempty"`
}

// ApplicationHealthEvaluation represents health evaluation for an application, containing information
// about the data and the algorithm used by the health store to evaluate health.
type ApplicationHealthEvaluation struct {
	// ApplicationName - The name of the application, including the 'fabric:' URI scheme.
	ApplicationName *string `json:"ApplicationName,omitempty"`
	// UnhealthyEvaluations - List of unhealthy evaluations that led to the current aggregated health state of the application. The types of the unhealthy evaluations can be DeployedApplicationsHealthEvaluation, ServicesHealthEvaluation or EventHealthEvaluation.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// AggregatedHealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
	// Description - Description of the health evaluation, which represents a summary of the evaluation process.
	Description *string `json:"Description,omitempty"`
	// Kind - Possible values include: 'KindHealthEvaluation', 'KindApplication', 'KindApplications', 'KindApplicationTypeApplications', 'KindDeltaNodesCheck', 'KindDeployedApplication', 'KindDeployedApplications', 'KindDeployedServicePackage', 'KindDeployedServicePackages', 'KindEvent', 'KindNode', 'KindNodes', 'KindPartition', 'KindPartitions', 'KindReplica', 'KindReplicas', 'KindService', 'KindServices', 'KindSystemApplication', 'KindUpgradeDomainDeltaNodesCheck', 'KindUpgradeDomainNodes'
	Kind Kind `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) MarshalJSON() ([]byte, error) {
	ahe.Kind = KindApplication
	objectMap := make(map[string]interface{})
	if ahe.ApplicationName != nil {
		objectMap["ApplicationName"] = ahe.ApplicationName
	}
	if ahe.UnhealthyEvaluations != nil {
		objectMap["UnhealthyEvaluations"] = ahe.UnhealthyEvaluations
	}
	if ahe.AggregatedHealthState != "" {
		objectMap["AggregatedHealthState"] = ahe.AggregatedHealthState
	}
	if ahe.Description != nil {
		objectMap["Description"] = ahe.Description
	}
	if ahe.Kind != "" {
		objectMap["Kind"] = ahe.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsApplicationHealthEvaluation() (*ApplicationHealthEvaluation, bool) {
	return &ahe, true
}

// AsApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsApplicationsHealthEvaluation() (*ApplicationsHealthEvaluation, bool) {
	return nil, false
}

// AsApplicationTypeApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsApplicationTypeApplicationsHealthEvaluation() (*ApplicationTypeApplicationsHealthEvaluation, bool) {
	return nil, false
}

// AsDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsDeltaNodesCheckHealthEvaluation() (*DeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// AsDeployedApplicationHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsDeployedApplicationHealthEvaluation() (*DeployedApplicationHealthEvaluation, bool) {
	return nil, false
}

// AsDeployedApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsDeployedApplicationsHealthEvaluation() (*DeployedApplicationsHealthEvaluation, bool) {
	return nil, false
}

// AsDeployedServicePackageHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsDeployedServicePackageHealthEvaluation() (*DeployedServicePackageHealthEvaluation, bool) {
	return nil, false
}

// AsDeployedServicePackagesHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsDeployedServicePackagesHealthEvaluation() (*DeployedServicePackagesHealthEvaluation, bool) {
	return nil, false
}

// AsEventHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsEventHealthEvaluation() (*EventHealthEvaluation, bool) {
	return nil, false
}

// AsNodeHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsNodeHealthEvaluation() (*NodeHealthEvaluation, bool) {
	return nil, false
}

// AsNodesHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsNodesHealthEvaluation() (*NodesHealthEvaluation, bool) {
	return nil, false
}

// AsPartitionHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsPartitionHealthEvaluation() (*PartitionHealthEvaluation, bool) {
	return nil, false
}

// AsPartitionsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsPartitionsHealthEvaluation() (*PartitionsHealthEvaluation, bool) {
	return nil, false
}

// AsReplicaHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsReplicaHealthEvaluation() (*ReplicaHealthEvaluation, bool) {
	return nil, false
}

// AsReplicasHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsReplicasHealthEvaluation() (*ReplicasHealthEvaluation, bool) {
	return nil, false
}

// AsServiceHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsServiceHealthEvaluation() (*ServiceHealthEvaluation, bool) {
	return nil, false
}

// AsServicesHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsServicesHealthEvaluation() (*ServicesHealthEvaluation, bool) {
	return nil, false
}

// AsSystemApplicationHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsSystemApplicationHealthEvaluation() (*SystemApplicationHealthEvaluation, bool) {
	return nil, false
}

// AsUpgradeDomainDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsUpgradeDomainDeltaNodesCheckHealthEvaluation() (*UpgradeDomainDeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// AsUpgradeDomainNodesHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsUpgradeDomainNodesHealthEvaluation() (*UpgradeDomainNodesHealthEvaluation, bool) {
	return nil, false
}

// AsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsHealthEvaluation() (*HealthEvaluation, bool) {
	return nil, false
}

// AsBasicHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsBasicHealthEvaluation() (BasicHealthEvaluation, bool) {
	return &ahe, true
}

// ApplicationHealthPolicies defines the application health policy map used to evaluate the health of an
// application or one of its children entities.
type ApplicationHealthPolicies struct {
	// ApplicationHealthPolicyMap - The wrapper that contains the map with application health policies used to evaluate specific applications in the cluster.
	ApplicationHealthPolicyMap *[]ApplicationHealthPolicyMapItem `json:"ApplicationHealthPolicyMap,omitempty"`
}

// ApplicationHealthPolicy defines a health policy used to evaluate the health of an application or one of
// its children entities.
type ApplicationHealthPolicy struct {
	// ConsiderWarningAsError - Indicates whether warnings are treated with the same severity as errors.
	ConsiderWarningAsError *bool `json:"ConsiderWarningAsError,omitempty"`
	// MaxPercentUnhealthyDeployedApplications - The maximum allowed percentage of unhealthy deployed applications. Allowed values are Byte values from zero to 100.
	// The percentage represents the maximum tolerated percentage of deployed applications that can be unhealthy before the application is considered in error.
	// This is calculated by dividing the number of unhealthy deployed applications over the number of nodes where the application is currently deployed on in the cluster.
	// The computation rounds up to tolerate one failure on small numbers of nodes. Default percentage is zero.
	MaxPercentUnhealthyDeployedApplications *int32 `json:"MaxPercentUnhealthyDeployedApplications,omitempty"`
	// DefaultServiceTypeHealthPolicy - The health policy used by default to evaluate the health of a service type.
	DefaultServiceTypeHealthPolicy *ServiceTypeHealthPolicy `json:"DefaultServiceTypeHealthPolicy,omitempty"`
	// ServiceTypeHealthPolicyMap - The map with service type health policy per service type name. The map is empty by default.
	ServiceTypeHealthPolicyMap *[]ServiceTypeHealthPolicyMapItem `json:"ServiceTypeHealthPolicyMap,omitempty"`
}

// ApplicationHealthPolicyMapItem defines an item in ApplicationHealthPolicyMap.
type ApplicationHealthPolicyMapItem struct {
	// Key - The key of the application health policy map item. This is the name of the application.
	Key *string `json:"Key,omitempty"`
	// Value - The value of the application health policy map item. This is the ApplicationHealthPolicy for this application.
	Value *ApplicationHealthPolicy `json:"Value,omitempty"`
}

// ApplicationHealthReportCreatedEvent application Health Report Created event.
type ApplicationHealthReportCreatedEvent struct {
	// ApplicationInstanceID - Id of Application instance.
	ApplicationInstanceID *int64 `json:"ApplicationInstanceId,omitempty"`
	// SourceID - Id of report source.
	SourceID *string `json:"SourceId,omitempty"`
	// Property - Describes the property.
	Property *string `json:"Property,omitempty"`
	// HealthState - Describes the property health state.
	HealthState *string `json:"HealthState,omitempty"`
	// TimeToLiveMs - Time to live in milli-seconds.
	TimeToLiveMs *int64 `json:"TimeToLiveMs,omitempty"`
	// SequenceNumber - Sequence number of report.
	SequenceNumber *int64 `json:"SequenceNumber,omitempty"`
	// Description - Description of report.
	Description *string `json:"Description,omitempty"`
	// RemoveWhenExpired - Indicates the removal when it expires.
	RemoveWhenExpired *bool `json:"RemoveWhenExpired,omitempty"`
	// SourceUtcTimestamp - Source time.
	SourceUtcTimestamp *date.Time `json:"SourceUtcTimestamp,omitempty"`
	// ApplicationID - The identity of the application. This is an encoded representation of the application name. This is used in the REST APIs to identify the application resource.
	// Starting in version 6.0, hierarchical names are delimited with the "\~" character. For example, if the application name is "fabric:/myapp/app1",
	// the application identity would be "myapp\~app1" in 6.0+ and "myapp/app1" in previous versions.
	ApplicationID *string `json:"ApplicationId,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationHealthReportCreated', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeComplete', 'KindApplicationUpgradeDomainComplete', 'KindApplicationUpgradeRollbackComplete', 'KindApplicationUpgradeRollbackStart', 'KindApplicationUpgradeStart', 'KindDeployedApplicationHealthReportCreated', 'KindDeployedApplicationHealthReportExpired', 'KindProcessDeactivated', 'KindContainerDeactivated', 'KindNodeAborted', 'KindNodeAborting', 'KindNodeAdded', 'KindNodeClose', 'KindNodeClosing', 'KindNodeDeactivateComplete', 'KindNodeDeactivateStart', 'KindNodeDown', 'KindNodeHealthReportCreated', 'KindNodeHealthReportExpired', 'KindNodeOpenedSuccess', 'KindNodeOpenFailed', 'KindNodeOpening', 'KindNodeRemoved', 'KindNodeUp', 'KindPartitionHealthReportCreated', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigurationCompleted', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceHealthReportCreated', 'KindServiceHealthReportExpired', 'KindDeployedServiceHealthReportCreated', 'KindDeployedServiceHealthReportExpired', 'KindStatefulReplicaHealthReportCreated', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaHealthReportCreated', 'KindStatelessReplicaHealthReportExpired', 'KindClusterHealthReportCreated', 'KindClusterHealthReportExpired', 'KindClusterUpgradeComplete', 'KindClusterUpgradeDomainComplete', 'KindClusterUpgradeRollbackComplete', 'KindClusterUpgradeRollbackStart', 'KindClusterUpgradeStart', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosRestartNodeFaultCompleted', 'KindChaosRestartCodePackageFaultScheduled', 'KindChaosRestartCodePackageFaultCompleted', 'KindChaosRemoveReplicaFaultScheduled', 'KindChaosRemoveReplicaFaultCompleted', 'KindChaosMoveSecondaryFaultScheduled', 'KindChaosMovePrimaryFaultScheduled', 'KindChaosRestartReplicaFaultScheduled', 'KindChaosRestartNodeFaultScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) MarshalJSON() ([]byte, error) {
	ahrce.Kind = KindApplicationHealthReportCreated
	objectMap := make(map[string]interface{})
	if ahrce.ApplicationInstanceID != nil {
		objectMap["ApplicationInstanceId"] = ahrce.ApplicationInstanceID
	}
	if ahrce.SourceID != nil {
		objectMap["SourceId"] = ahrce.SourceID
	}
	if ahrce.Property != nil {
		objectMap["Property"] = ahrce.Property
	}
	if ahrce.HealthState != nil {
		objectMap["HealthState"] = ahrce.HealthState
	}
	if ahrce.TimeToLiveMs != nil {
		objectMap["TimeToLiveMs"] = ahrce.TimeToLiveMs
	}
	if ahrce.SequenceNumber != nil {
		objectMap["SequenceNumber"] = ahrce.SequenceNumber
	}
	if ahrce.Description != nil {
		objectMap["Description"] = ahrce.Description
	}
	if ahrce.RemoveWhenExpired != nil {
		objectMap["RemoveWhenExpired"] = ahrce.RemoveWhenExpired
	}
	if ahrce.SourceUtcTimestamp != nil {
		objectMap["SourceUtcTimestamp"] = ahrce.SourceUtcTimestamp
	}
	if ahrce.ApplicationID != nil {
		objectMap["ApplicationId"] = ahrce.ApplicationID
	}
	if ahrce.EventInstanceID != nil {
		objectMap["EventInstanceId"] = ahrce.EventInstanceID
	}
	if ahrce.TimeStamp != nil {
		objectMap["TimeStamp"] = ahrce.TimeStamp
	}
	if ahrce.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = ahrce.HasCorrelatedEvents
	}
	if ahrce.Kind != "" {
		objectMap["Kind"] = ahrce.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return &ahrce, true
}

// AsClusterEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return nil, false
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsApplicationHealthReportCreatedEvent() (*ApplicationHealthReportCreatedEvent, bool) {
	return &ahrce, true
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompleteEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsApplicationUpgradeCompleteEvent() (*ApplicationUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsApplicationUpgradeDomainCompleteEvent() (*ApplicationUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsApplicationUpgradeRollbackCompleteEvent() (*ApplicationUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsApplicationUpgradeRollbackStartEvent() (*ApplicationUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsApplicationUpgradeStartEvent() (*ApplicationUpgradeStartEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsDeployedApplicationHealthReportCreatedEvent() (*DeployedApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsProcessDeactivatedEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsProcessDeactivatedEvent() (*ProcessDeactivatedEvent, bool) {
	return nil, false
}

// AsContainerDeactivatedEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsContainerDeactivatedEvent() (*ContainerDeactivatedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAbortingEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsNodeAbortingEvent() (*NodeAbortingEvent, bool) {
	return nil, false
}

// AsNodeAddedEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsNodeAddedEvent() (*NodeAddedEvent, bool) {
	return nil, false
}

// AsNodeCloseEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsNodeCloseEvent() (*NodeCloseEvent, bool) {
	return nil, false
}

// AsNodeClosingEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsNodeClosingEvent() (*NodeClosingEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompleteEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsNodeDeactivateCompleteEvent() (*NodeDeactivateCompleteEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsNodeDeactivateStartEvent() (*NodeDeactivateStartEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsNodeHealthReportCreatedEvent() (*NodeHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenedSuccessEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsNodeOpenedSuccessEvent() (*NodeOpenedSuccessEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeOpeningEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsNodeOpeningEvent() (*NodeOpeningEvent, bool) {
	return nil, false
}

// AsNodeRemovedEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsNodeRemovedEvent() (*NodeRemovedEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsPartitionHealthReportCreatedEvent() (*PartitionHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfigurationCompletedEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsPartitionReconfigurationCompletedEvent() (*PartitionReconfigurationCompletedEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsServiceHealthReportCreatedEvent() (*ServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsDeployedServiceHealthReportCreatedEvent() (*DeployedServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsDeployedServiceHealthReportExpiredEvent() (*DeployedServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsStatefulReplicaHealthReportCreatedEvent() (*StatefulReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsStatelessReplicaHealthReportCreatedEvent() (*StatelessReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsClusterHealthReportCreatedEvent() (*ClusterHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompleteEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsClusterUpgradeCompleteEvent() (*ClusterUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsClusterUpgradeDomainCompleteEvent() (*ClusterUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsClusterUpgradeRollbackCompleteEvent() (*ClusterUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsClusterUpgradeRollbackStartEvent() (*ClusterUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsClusterUpgradeStartEvent() (*ClusterUpgradeStartEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultCompletedEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsChaosRestartNodeFaultCompletedEvent() (*ChaosRestartNodeFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsChaosRestartCodePackageFaultScheduledEvent() (*ChaosRestartCodePackageFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultCompletedEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsChaosRestartCodePackageFaultCompletedEvent() (*ChaosRestartCodePackageFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsChaosRemoveReplicaFaultScheduledEvent() (*ChaosRemoveReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultCompletedEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsChaosRemoveReplicaFaultCompletedEvent() (*ChaosRemoveReplicaFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosMoveSecondaryFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsChaosMoveSecondaryFaultScheduledEvent() (*ChaosMoveSecondaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosMovePrimaryFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsChaosMovePrimaryFaultScheduledEvent() (*ChaosMovePrimaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsChaosRestartReplicaFaultScheduledEvent() (*ChaosRestartReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsChaosRestartNodeFaultScheduledEvent() (*ChaosRestartNodeFaultScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ApplicationHealthReportCreatedEvent.
func (ahrce ApplicationHealthReportCreatedEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &ahrce, true
}

// ApplicationHealthReportExpiredEvent application Health Report Expired event.
type ApplicationHealthReportExpiredEvent struct {
	// ApplicationInstanceID - Id of Application instance.
	ApplicationInstanceID *int64 `json:"ApplicationInstanceId,omitempty"`
	// SourceID - Id of report source.
	SourceID *string `json:"SourceId,omitempty"`
	// Property - Describes the property.
	Property *string `json:"Property,omitempty"`
	// HealthState - Describes the property health state.
	HealthState *string `json:"HealthState,omitempty"`
	// TimeToLiveMs - Time to live in milli-seconds.
	TimeToLiveMs *int64 `json:"TimeToLiveMs,omitempty"`
	// SequenceNumber - Sequence number of report.
	SequenceNumber *int64 `json:"SequenceNumber,omitempty"`
	// Description - Description of report.
	Description *string `json:"Description,omitempty"`
	// RemoveWhenExpired - Indicates the removal when it expires.
	RemoveWhenExpired *bool `json:"RemoveWhenExpired,omitempty"`
	// SourceUtcTimestamp - Source time.
	SourceUtcTimestamp *date.Time `json:"SourceUtcTimestamp,omitempty"`
	// ApplicationID - The identity of the application. This is an encoded representation of the application name. This is used in the REST APIs to identify the application resource.
	// Starting in version 6.0, hierarchical names are delimited with the "\~" character. For example, if the application name is "fabric:/myapp/app1",
	// the application identity would be "myapp\~app1" in 6.0+ and "myapp/app1" in previous versions.
	ApplicationID *string `json:"ApplicationId,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationHealthReportCreated', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeComplete', 'KindApplicationUpgradeDomainComplete', 'KindApplicationUpgradeRollbackComplete', 'KindApplicationUpgradeRollbackStart', 'KindApplicationUpgradeStart', 'KindDeployedApplicationHealthReportCreated', 'KindDeployedApplicationHealthReportExpired', 'KindProcessDeactivated', 'KindContainerDeactivated', 'KindNodeAborted', 'KindNodeAborting', 'KindNodeAdded', 'KindNodeClose', 'KindNodeClosing', 'KindNodeDeactivateComplete', 'KindNodeDeactivateStart', 'KindNodeDown', 'KindNodeHealthReportCreated', 'KindNodeHealthReportExpired', 'KindNodeOpenedSuccess', 'KindNodeOpenFailed', 'KindNodeOpening', 'KindNodeRemoved', 'KindNodeUp', 'KindPartitionHealthReportCreated', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigurationCompleted', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceHealthReportCreated', 'KindServiceHealthReportExpired', 'KindDeployedServiceHealthReportCreated', 'KindDeployedServiceHealthReportExpired', 'KindStatefulReplicaHealthReportCreated', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaHealthReportCreated', 'KindStatelessReplicaHealthReportExpired', 'KindClusterHealthReportCreated', 'KindClusterHealthReportExpired', 'KindClusterUpgradeComplete', 'KindClusterUpgradeDomainComplete', 'KindClusterUpgradeRollbackComplete', 'KindClusterUpgradeRollbackStart', 'KindClusterUpgradeStart', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosRestartNodeFaultCompleted', 'KindChaosRestartCodePackageFaultScheduled', 'KindChaosRestartCodePackageFaultCompleted', 'KindChaosRemoveReplicaFaultScheduled', 'KindChaosRemoveReplicaFaultCompleted', 'KindChaosMoveSecondaryFaultScheduled', 'KindChaosMovePrimaryFaultScheduled', 'KindChaosRestartReplicaFaultScheduled', 'KindChaosRestartNodeFaultScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) MarshalJSON() ([]byte, error) {
	ahree.Kind = KindApplicationHealthReportExpired
	objectMap := make(map[string]interface{})
	if ahree.ApplicationInstanceID != nil {
		objectMap["ApplicationInstanceId"] = ahree.ApplicationInstanceID
	}
	if ahree.SourceID != nil {
		objectMap["SourceId"] = ahree.SourceID
	}
	if ahree.Property != nil {
		objectMap["Property"] = ahree.Property
	}
	if ahree.HealthState != nil {
		objectMap["HealthState"] = ahree.HealthState
	}
	if ahree.TimeToLiveMs != nil {
		objectMap["TimeToLiveMs"] = ahree.TimeToLiveMs
	}
	if ahree.SequenceNumber != nil {
		objectMap["SequenceNumber"] = ahree.SequenceNumber
	}
	if ahree.Description != nil {
		objectMap["Description"] = ahree.Description
	}
	if ahree.RemoveWhenExpired != nil {
		objectMap["RemoveWhenExpired"] = ahree.RemoveWhenExpired
	}
	if ahree.SourceUtcTimestamp != nil {
		objectMap["SourceUtcTimestamp"] = ahree.SourceUtcTimestamp
	}
	if ahree.ApplicationID != nil {
		objectMap["ApplicationId"] = ahree.ApplicationID
	}
	if ahree.EventInstanceID != nil {
		objectMap["EventInstanceId"] = ahree.EventInstanceID
	}
	if ahree.TimeStamp != nil {
		objectMap["TimeStamp"] = ahree.TimeStamp
	}
	if ahree.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = ahree.HasCorrelatedEvents
	}
	if ahree.Kind != "" {
		objectMap["Kind"] = ahree.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return &ahree, true
}

// AsClusterEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return nil, false
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsApplicationHealthReportCreatedEvent() (*ApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return &ahree, true
}

// AsApplicationUpgradeCompleteEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsApplicationUpgradeCompleteEvent() (*ApplicationUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsApplicationUpgradeDomainCompleteEvent() (*ApplicationUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsApplicationUpgradeRollbackCompleteEvent() (*ApplicationUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsApplicationUpgradeRollbackStartEvent() (*ApplicationUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsApplicationUpgradeStartEvent() (*ApplicationUpgradeStartEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsDeployedApplicationHealthReportCreatedEvent() (*DeployedApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsProcessDeactivatedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsProcessDeactivatedEvent() (*ProcessDeactivatedEvent, bool) {
	return nil, false
}

// AsContainerDeactivatedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsContainerDeactivatedEvent() (*ContainerDeactivatedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAbortingEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsNodeAbortingEvent() (*NodeAbortingEvent, bool) {
	return nil, false
}

// AsNodeAddedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsNodeAddedEvent() (*NodeAddedEvent, bool) {
	return nil, false
}

// AsNodeCloseEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsNodeCloseEvent() (*NodeCloseEvent, bool) {
	return nil, false
}

// AsNodeClosingEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsNodeClosingEvent() (*NodeClosingEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompleteEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsNodeDeactivateCompleteEvent() (*NodeDeactivateCompleteEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsNodeDeactivateStartEvent() (*NodeDeactivateStartEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsNodeHealthReportCreatedEvent() (*NodeHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenedSuccessEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsNodeOpenedSuccessEvent() (*NodeOpenedSuccessEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeOpeningEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsNodeOpeningEvent() (*NodeOpeningEvent, bool) {
	return nil, false
}

// AsNodeRemovedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsNodeRemovedEvent() (*NodeRemovedEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsPartitionHealthReportCreatedEvent() (*PartitionHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfigurationCompletedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsPartitionReconfigurationCompletedEvent() (*PartitionReconfigurationCompletedEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsServiceHealthReportCreatedEvent() (*ServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsDeployedServiceHealthReportCreatedEvent() (*DeployedServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsDeployedServiceHealthReportExpiredEvent() (*DeployedServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsStatefulReplicaHealthReportCreatedEvent() (*StatefulReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsStatelessReplicaHealthReportCreatedEvent() (*StatelessReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsClusterHealthReportCreatedEvent() (*ClusterHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompleteEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsClusterUpgradeCompleteEvent() (*ClusterUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsClusterUpgradeDomainCompleteEvent() (*ClusterUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsClusterUpgradeRollbackCompleteEvent() (*ClusterUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsClusterUpgradeRollbackStartEvent() (*ClusterUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsClusterUpgradeStartEvent() (*ClusterUpgradeStartEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultCompletedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsChaosRestartNodeFaultCompletedEvent() (*ChaosRestartNodeFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsChaosRestartCodePackageFaultScheduledEvent() (*ChaosRestartCodePackageFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultCompletedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsChaosRestartCodePackageFaultCompletedEvent() (*ChaosRestartCodePackageFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsChaosRemoveReplicaFaultScheduledEvent() (*ChaosRemoveReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultCompletedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsChaosRemoveReplicaFaultCompletedEvent() (*ChaosRemoveReplicaFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosMoveSecondaryFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsChaosMoveSecondaryFaultScheduledEvent() (*ChaosMoveSecondaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosMovePrimaryFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsChaosMovePrimaryFaultScheduledEvent() (*ChaosMovePrimaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsChaosRestartReplicaFaultScheduledEvent() (*ChaosRestartReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsChaosRestartNodeFaultScheduledEvent() (*ChaosRestartNodeFaultScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &ahree, true
}

// ApplicationHealthState represents the health state of an application, which contains the application
// identifier and the aggregated health state.
type ApplicationHealthState struct {
	// Name - The name of the application, including the 'fabric:' URI scheme.
	Name *string `json:"Name,omitempty"`
	// AggregatedHealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
}

// ApplicationHealthStateChunk represents the health state chunk of a application.
// The application health state chunk contains the application name, its aggregated health state and any
// children services and deployed applications that respect the filters in cluster health chunk query
// description.
type ApplicationHealthStateChunk struct {
	// ApplicationName - The name of the application, including the 'fabric:' URI scheme.
	ApplicationName *string `json:"ApplicationName,omitempty"`
	// ApplicationTypeName - The application type name as defined in the application manifest.
	ApplicationTypeName *string `json:"ApplicationTypeName,omitempty"`
	// ServiceHealthStateChunks - The list of service health state chunks in the cluster that respect the filters in the cluster health chunk query description.
	ServiceHealthStateChunks *ServiceHealthStateChunkList `json:"ServiceHealthStateChunks,omitempty"`
	// DeployedApplicationHealthStateChunks - The list of deployed application health state chunks in the cluster that respect the filters in the cluster health chunk query description.
	DeployedApplicationHealthStateChunks *DeployedApplicationHealthStateChunkList `json:"DeployedApplicationHealthStateChunks,omitempty"`
	// HealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	HealthState HealthState `json:"HealthState,omitempty"`
}

// ApplicationHealthStateChunkList the list of application health state chunks in the cluster that respect
// the input filters in the chunk query. Returned by get cluster health state chunks query.
type ApplicationHealthStateChunkList struct {
	// Items - The list of application health state chunks that respect the input filters in the chunk query.
	Items *[]ApplicationHealthStateChunk `json:"Items,omitempty"`
	// TotalCount - Total number of entity health state objects that match the specified filters from the cluster health chunk query description.
	TotalCount *int64 `json:"TotalCount,omitempty"`
}

// ApplicationHealthStateFilter defines matching criteria to determine whether a application should be
// included in the cluster health chunk.
// One filter can match zero, one or multiple applications, depending on its properties.
type ApplicationHealthStateFilter struct {
	// ApplicationNameFilter - The name of the application that matches the filter, as a fabric uri. The filter is applied only to the specified application, if it exists.
	// If the application doesn't exist, no application is returned in the cluster health chunk based on this filter.
	// If the application exists, it is included in the cluster health chunk if it respects the other filter properties.
	// If not specified, all applications are matched against the other filter members, like health state filter.
	ApplicationNameFilter *string `json:"ApplicationNameFilter,omitempty"`
	// ApplicationTypeNameFilter - The name of the application type that matches the filter.
	// If specified, the filter is applied only to applications of the selected application type, if any exists.
	// If no applications of the specified application type exists, no application is returned in the cluster health chunk based on this filter.
	// Each application of the specified application type is included in the cluster health chunk if it respects the other filter properties.
	// If not specified, all applications are matched against the other filter members, like health state filter.
	ApplicationTypeNameFilter *string `json:"ApplicationTypeNameFilter,omitempty"`
	// HealthStateFilter - The filter for the health state of the applications. It allows selecting applications if they match the desired health states.
	// The possible values are integer value of one of the following health states. Only applications that match the filter are returned. All applications are used to evaluate the cluster aggregated health state.
	// If not specified, default value is None, unless the application name or the application type name are specified. If the filter has default value and application name is specified, the matching application is returned.
	// The state values are flag-based enumeration, so the value could be a combination of these values obtained using bitwise 'OR' operator.
	// For example, if the provided value is 6, it matches applications with HealthState value of OK (2) and Warning (4).
	// - Default - Default value. Matches any HealthState. The value is zero.
	// - None - Filter that doesn't match any HealthState value. Used in order to return no results on a given collection of states. The value is 1.
	// - Ok - Filter that matches input with HealthState value Ok. The value is 2.
	// - Warning - Filter that matches input with HealthState value Warning. The value is 4.
	// - Error - Filter that matches input with HealthState value Error. The value is 8.
	// - All - Filter that matches input with any HealthState value. The value is 65535.
	HealthStateFilter *int32 `json:"HealthStateFilter,omitempty"`
	// ServiceFilters - Defines a list of filters that specify which services to be included in the returned cluster health chunk as children of the application. The services are returned only if the parent application matches a filter.
	// If the list is empty, no services are returned. All the services are used to evaluate the parent application aggregated health state, regardless of the input filters.
	// The application filter may specify multiple service filters.
	// For example, it can specify a filter to return all services with health state Error and another filter to always include a service identified by its service name.
	ServiceFilters *[]ServiceHealthStateFilter `json:"ServiceFilters,omitempty"`
	// DeployedApplicationFilters - Defines a list of filters that specify which deployed applications to be included in the returned cluster health chunk as children of the application. The deployed applications are returned only if the parent application matches a filter.
	// If the list is empty, no deployed applications are returned. All the deployed applications are used to evaluate the parent application aggregated health state, regardless of the input filters.
	// The application filter may specify multiple deployed application filters.
	// For example, it can specify a filter to return all deployed applications with health state Error and another filter to always include a deployed application on a specified node.
	DeployedApplicationFilters *[]DeployedApplicationHealthStateFilter `json:"DeployedApplicationFilters,omitempty"`
}

// ApplicationInfo information about a Service Fabric application.
type ApplicationInfo struct {
	autorest.Response `json:"-"`
	// ID - The identity of the application. This is an encoded representation of the application name. This is used in the REST APIs to identify the application resource.
	// Starting in version 6.0, hierarchical names are delimited with the "\~" character. For example, if the application name is "fabric:/myapp/app1",
	// the application identity would be "myapp\~app1" in 6.0+ and "myapp/app1" in previous versions.
	ID *string `json:"Id,omitempty"`
	// Name - The name of the application, including the 'fabric:' URI scheme.
	Name *string `json:"Name,omitempty"`
	// TypeName - The application type name as defined in the application manifest.
	TypeName *string `json:"TypeName,omitempty"`
	// TypeVersion - The version of the application type as defined in the application manifest.
	TypeVersion *string `json:"TypeVersion,omitempty"`
	// Status - The status of the application. Possible values include: 'ApplicationStatusInvalid', 'ApplicationStatusReady', 'ApplicationStatusUpgrading', 'ApplicationStatusCreating', 'ApplicationStatusDeleting', 'ApplicationStatusFailed'
	Status ApplicationStatus `json:"Status,omitempty"`
	// Parameters - List of application parameters with overridden values from their default values specified in the application manifest.
	Parameters *[]ApplicationParameter `json:"Parameters,omitempty"`
	// HealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	HealthState HealthState `json:"HealthState,omitempty"`
	// ApplicationDefinitionKind - The mechanism used to define a Service Fabric application. Possible values include: 'Invalid', 'ServiceFabricApplicationDescription', 'Compose'
	ApplicationDefinitionKind ApplicationDefinitionKind `json:"ApplicationDefinitionKind,omitempty"`
}

// ApplicationLoadInfo load Information about a Service Fabric application.
type ApplicationLoadInfo struct {
	autorest.Response `json:"-"`
	// ID - The identity of the application. This is an encoded representation of the application name. This is used in the REST APIs to identify the application resource.
	// Starting in version 6.0, hierarchical names are delimited with the "\~" character. For example, if the application name is "fabric:/myapp/app1",
	// the application identity would be "myapp\~app1" in 6.0+ and "myapp/app1" in previous versions.
	ID *string `json:"Id,omitempty"`
	// MinimumNodes - The minimum number of nodes for this application.
	// It is the number of nodes where Service Fabric will reserve Capacity in the cluster which equals to ReservedLoad * MinimumNodes for this Application instance.
	// For applications that do not have application capacity defined this value will be zero.
	MinimumNodes *int64 `json:"MinimumNodes,omitempty"`
	// MaximumNodes - The maximum number of nodes where this application can be instantiated.
	// It is the number of nodes this application is allowed to span.
	// For applications that do not have application capacity defined this value will be zero.
	MaximumNodes *int64 `json:"MaximumNodes,omitempty"`
	// NodeCount - The number of nodes on which this application is instantiated.
	// For applications that do not have application capacity defined this value will be zero.
	NodeCount *int64 `json:"NodeCount,omitempty"`
	// ApplicationLoadMetricInformation - List of application capacity metric description.
	ApplicationLoadMetricInformation *[]ApplicationMetricDescription `json:"ApplicationLoadMetricInformation,omitempty"`
}

// ApplicationMetricDescription describes capacity information for a custom resource balancing metric. This
// can be used to limit the total consumption of this metric by the services of this application.
type ApplicationMetricDescription struct {
	// Name - The name of the metric.
	Name *string `json:"Name,omitempty"`
	// MaximumCapacity - The maximum node capacity for Service Fabric application.
	// This is the maximum Load for an instance of this application on a single node. Even if the capacity of node is greater than this value, Service Fabric will limit the total load of services within the application on each node to this value.
	// If set to zero, capacity for this metric is unlimited on each node.
	// When creating a new application with application capacity defined, the product of MaximumNodes and this value must always be smaller than or equal to TotalApplicationCapacity.
	// When updating existing application with application capacity, the product of MaximumNodes and this value must always be smaller than or equal to TotalApplicationCapacity.
	MaximumCapacity *int64 `json:"MaximumCapacity,omitempty"`
	// ReservationCapacity - The node reservation capacity for Service Fabric application.
	// This is the amount of load which is reserved on nodes which have instances of this application.
	// If MinimumNodes is specified, then the product of these values will be the capacity reserved in the cluster for the application.
	// If set to zero, no capacity is reserved for this metric.
	// When setting application capacity or when updating application capacity; this value must be smaller than or equal to MaximumCapacity for each metric.
	ReservationCapacity *int64 `json:"ReservationCapacity,omitempty"`
	// TotalApplicationCapacity - The total metric capacity for Service Fabric application.
	// This is the total metric capacity for this application in the cluster. Service Fabric will try to limit the sum of loads of services within the application to this value.
	// When creating a new application with application capacity defined, the product of MaximumNodes and MaximumCapacity must always be smaller than or equal to this value.
	TotalApplicationCapacity *int64 `json:"TotalApplicationCapacity,omitempty"`
}

// ApplicationNameInfo information about the application name.
type ApplicationNameInfo struct {
	autorest.Response `json:"-"`
	// ID - The identity of the application. This is an encoded representation of the application name. This is used in the REST APIs to identify the application resource.
	// Starting in version 6.0, hierarchical names are delimited with the "\~" character. For example, if the application name is "fabric:/myapp/app1",
	// the application identity would be "myapp\~app1" in 6.0+ and "myapp/app1" in previous versions.
	ID *string `json:"Id,omitempty"`
	// Name - The name of the application, including the 'fabric:' URI scheme.
	Name *string `json:"Name,omitempty"`
}

// ApplicationParameter describes an application parameter override to be applied when creating or
// upgrading an application.
type ApplicationParameter struct {
	// Key - The name of the parameter.
	Key *string `json:"Key,omitempty"`
	// Value - The value of the parameter.
	Value *string `json:"Value,omitempty"`
}

// ApplicationProperties this type describes properties of an application resource.
type ApplicationProperties struct {
	// Description - User readable description of the application.
	Description *string `json:"description,omitempty"`
	// DebugParams - Internal use.
	DebugParams *string `json:"debugParams,omitempty"`
	// Services - describes the services in the application.
	Services *[]ServiceResourceDescription `json:"services,omitempty"`
	// HealthState - Describes the health state of an application resource. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	HealthState HealthState `json:"healthState,omitempty"`
	// UnhealthyEvaluation - When the application's health state is not 'Ok', this additional details from service fabric Health Manager for the user to know why the application is marked unhealthy.
	UnhealthyEvaluation *string `json:"unhealthyEvaluation,omitempty"`
	// Status - Status of the application resource. Possible values include: 'ApplicationResourceStatusInvalid', 'ApplicationResourceStatusReady', 'ApplicationResourceStatusUpgrading', 'ApplicationResourceStatusCreating', 'ApplicationResourceStatusDeleting', 'ApplicationResourceStatusFailed'
	Status ApplicationResourceStatus `json:"status,omitempty"`
	// StatusDetails - Gives additional information about the current status of the application deployment.
	StatusDetails *string `json:"statusDetails,omitempty"`
	// ServiceNames - Names of the services in the application.
	ServiceNames *[]string `json:"serviceNames,omitempty"`
	// Diagnostics - Describes the diagnostics definition and usage for an application resource.
	Diagnostics *DiagnosticsDescription `json:"diagnostics,omitempty"`
}

// ApplicationResourceDescription describes a service fabric application resource.
type ApplicationResourceDescription struct {
	autorest.Response `json:"-"`
	// ApplicationProperties - This type describes properties of an application resource.
	*ApplicationProperties `json:"properties,omitempty"`
	// Name - Application resource name.
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationResourceDescription.
func (ard ApplicationResourceDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ard.ApplicationProperties != nil {
		objectMap["properties"] = ard.ApplicationProperties
	}
	if ard.Name != nil {
		objectMap["name"] = ard.Name
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationResourceDescription struct.
func (ard *ApplicationResourceDescription) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationProperties ApplicationProperties
				err = json.Unmarshal(*v, &applicationProperties)
				if err != nil {
					return err
				}
				ard.ApplicationProperties = &applicationProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ard.Name = &name
			}
		}
	}

	return nil
}

// ApplicationsHealthEvaluation represents health evaluation for applications, containing health
// evaluations for each unhealthy application that impacted current aggregated health state.
type ApplicationsHealthEvaluation struct {
	// MaxPercentUnhealthyApplications - Maximum allowed percentage of unhealthy applications from the ClusterHealthPolicy.
	MaxPercentUnhealthyApplications *int32 `json:"MaxPercentUnhealthyApplications,omitempty"`
	// TotalCount - Total number of applications from the health store.
	TotalCount *int64 `json:"TotalCount,omitempty"`
	// UnhealthyEvaluations - List of unhealthy evaluations that led to the aggregated health state. Includes all the unhealthy ApplicationHealthEvaluation that impacted the aggregated health.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// AggregatedHealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
	// Description - Description of the health evaluation, which represents a summary of the evaluation process.
	Description *string `json:"Description,omitempty"`
	// Kind - Possible values include: 'KindHealthEvaluation', 'KindApplication', 'KindApplications', 'KindApplicationTypeApplications', 'KindDeltaNodesCheck', 'KindDeployedApplication', 'KindDeployedApplications', 'KindDeployedServicePackage', 'KindDeployedServicePackages', 'KindEvent', 'KindNode', 'KindNodes', 'KindPartition', 'KindPartitions', 'KindReplica', 'KindReplicas', 'KindService', 'KindServices', 'KindSystemApplication', 'KindUpgradeDomainDeltaNodesCheck', 'KindUpgradeDomainNodes'
	Kind Kind `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) MarshalJSON() ([]byte, error) {
	ahe.Kind = KindApplications
	objectMap := make(map[string]interface{})
	if ahe.MaxPercentUnhealthyApplications != nil {
		objectMap["MaxPercentUnhealthyApplications"] = ahe.MaxPercentUnhealthyApplications
	}
	if ahe.TotalCount != nil {
		objectMap["TotalCount"] = ahe.TotalCount
	}
	if ahe.UnhealthyEvaluations != nil {
		objectMap["UnhealthyEvaluations"] = ahe.UnhealthyEvaluations
	}
	if ahe.AggregatedHealthState != "" {
		objectMap["AggregatedHealthState"] = ahe.AggregatedHealthState
	}
	if ahe.Description != nil {
		objectMap["Description"] = ahe.Description
	}
	if ahe.Kind != "" {
		objectMap["Kind"] = ahe.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsApplicationHealthEvaluation() (*ApplicationHealthEvaluation, bool) {
	return nil, false
}

// AsApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsApplicationsHealthEvaluation() (*ApplicationsHealthEvaluation, bool) {
	return &ahe, true
}

// AsApplicationTypeApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsApplicationTypeApplicationsHealthEvaluation() (*ApplicationTypeApplicationsHealthEvaluation, bool) {
	return nil, false
}

// AsDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsDeltaNodesCheckHealthEvaluation() (*DeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// AsDeployedApplicationHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsDeployedApplicationHealthEvaluation() (*DeployedApplicationHealthEvaluation, bool) {
	return nil, false
}

// AsDeployedApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsDeployedApplicationsHealthEvaluation() (*DeployedApplicationsHealthEvaluation, bool) {
	return nil, false
}

// AsDeployedServicePackageHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsDeployedServicePackageHealthEvaluation() (*DeployedServicePackageHealthEvaluation, bool) {
	return nil, false
}

// AsDeployedServicePackagesHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsDeployedServicePackagesHealthEvaluation() (*DeployedServicePackagesHealthEvaluation, bool) {
	return nil, false
}

// AsEventHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsEventHealthEvaluation() (*EventHealthEvaluation, bool) {
	return nil, false
}

// AsNodeHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsNodeHealthEvaluation() (*NodeHealthEvaluation, bool) {
	return nil, false
}

// AsNodesHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsNodesHealthEvaluation() (*NodesHealthEvaluation, bool) {
	return nil, false
}

// AsPartitionHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsPartitionHealthEvaluation() (*PartitionHealthEvaluation, bool) {
	return nil, false
}

// AsPartitionsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsPartitionsHealthEvaluation() (*PartitionsHealthEvaluation, bool) {
	return nil, false
}

// AsReplicaHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsReplicaHealthEvaluation() (*ReplicaHealthEvaluation, bool) {
	return nil, false
}

// AsReplicasHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsReplicasHealthEvaluation() (*ReplicasHealthEvaluation, bool) {
	return nil, false
}

// AsServiceHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsServiceHealthEvaluation() (*ServiceHealthEvaluation, bool) {
	return nil, false
}

// AsServicesHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsServicesHealthEvaluation() (*ServicesHealthEvaluation, bool) {
	return nil, false
}

// AsSystemApplicationHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsSystemApplicationHealthEvaluation() (*SystemApplicationHealthEvaluation, bool) {
	return nil, false
}

// AsUpgradeDomainDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsUpgradeDomainDeltaNodesCheckHealthEvaluation() (*UpgradeDomainDeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// AsUpgradeDomainNodesHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsUpgradeDomainNodesHealthEvaluation() (*UpgradeDomainNodesHealthEvaluation, bool) {
	return nil, false
}

// AsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsHealthEvaluation() (*HealthEvaluation, bool) {
	return nil, false
}

// AsBasicHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsBasicHealthEvaluation() (BasicHealthEvaluation, bool) {
	return &ahe, true
}

// ApplicationTypeApplicationsHealthEvaluation represents health evaluation for applications of a
// particular application type. The application type applications evaluation can be returned when cluster
// health evaluation returns unhealthy aggregated health state, either Error or Warning. It contains health
// evaluations for each unhealthy application of the included application type that impacted current
// aggregated health state.
type ApplicationTypeApplicationsHealthEvaluation struct {
	// ApplicationTypeName - The application type name as defined in the application manifest.
	ApplicationTypeName *string `json:"ApplicationTypeName,omitempty"`
	// MaxPercentUnhealthyApplications - Maximum allowed percentage of unhealthy applications for the application type, specified as an entry in ApplicationTypeHealthPolicyMap.
	MaxPercentUnhealthyApplications *int32 `json:"MaxPercentUnhealthyApplications,omitempty"`
	// TotalCount - Total number of applications of the application type found in the health store.
	TotalCount *int64 `json:"TotalCount,omitempty"`
	// UnhealthyEvaluations - List of unhealthy evaluations that led to the aggregated health state. Includes all the unhealthy ApplicationHealthEvaluation of this application type that impacted the aggregated health.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// AggregatedHealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
	// Description - Description of the health evaluation, which represents a summary of the evaluation process.
	Description *string `json:"Description,omitempty"`
	// Kind - Possible values include: 'KindHealthEvaluation', 'KindApplication', 'KindApplications', 'KindApplicationTypeApplications', 'KindDeltaNodesCheck', 'KindDeployedApplication', 'KindDeployedApplications', 'KindDeployedServicePackage', 'KindDeployedServicePackages', 'KindEvent', 'KindNode', 'KindNodes', 'KindPartition', 'KindPartitions', 'KindReplica', 'KindReplicas', 'KindService', 'KindServices', 'KindSystemApplication', 'KindUpgradeDomainDeltaNodesCheck', 'KindUpgradeDomainNodes'
	Kind Kind `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) MarshalJSON() ([]byte, error) {
	atahe.Kind = KindApplicationTypeApplications
	objectMap := make(map[string]interface{})
	if atahe.ApplicationTypeName != nil {
		objectMap["ApplicationTypeName"] = atahe.ApplicationTypeName
	}
	if atahe.MaxPercentUnhealthyApplications != nil {
		objectMap["MaxPercentUnhealthyApplications"] = atahe.MaxPercentUnhealthyApplications
	}
	if atahe.TotalCount != nil {
		objectMap["TotalCount"] = atahe.TotalCount
	}
	if atahe.UnhealthyEvaluations != nil {
		objectMap["UnhealthyEvaluations"] = atahe.UnhealthyEvaluations
	}
	if atahe.AggregatedHealthState != "" {
		objectMap["AggregatedHealthState"] = atahe.AggregatedHealthState
	}
	if atahe.Description != nil {
		objectMap["Description"] = atahe.Description
	}
	if atahe.Kind != "" {
		objectMap["Kind"] = atahe.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsApplicationHealthEvaluation() (*ApplicationHealthEvaluation, bool) {
	return nil, false
}

// AsApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsApplicationsHealthEvaluation() (*ApplicationsHealthEvaluation, bool) {
	return nil, false
}

// AsApplicationTypeApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsApplicationTypeApplicationsHealthEvaluation() (*ApplicationTypeApplicationsHealthEvaluation, bool) {
	return &atahe, true
}

// AsDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsDeltaNodesCheckHealthEvaluation() (*DeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// AsDeployedApplicationHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsDeployedApplicationHealthEvaluation() (*DeployedApplicationHealthEvaluation, bool) {
	return nil, false
}

// AsDeployedApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsDeployedApplicationsHealthEvaluation() (*DeployedApplicationsHealthEvaluation, bool) {
	return nil, false
}

// AsDeployedServicePackageHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsDeployedServicePackageHealthEvaluation() (*DeployedServicePackageHealthEvaluation, bool) {
	return nil, false
}

// AsDeployedServicePackagesHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsDeployedServicePackagesHealthEvaluation() (*DeployedServicePackagesHealthEvaluation, bool) {
	return nil, false
}

// AsEventHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsEventHealthEvaluation() (*EventHealthEvaluation, bool) {
	return nil, false
}

// AsNodeHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsNodeHealthEvaluation() (*NodeHealthEvaluation, bool) {
	return nil, false
}

// AsNodesHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsNodesHealthEvaluation() (*NodesHealthEvaluation, bool) {
	return nil, false
}

// AsPartitionHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsPartitionHealthEvaluation() (*PartitionHealthEvaluation, bool) {
	return nil, false
}

// AsPartitionsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsPartitionsHealthEvaluation() (*PartitionsHealthEvaluation, bool) {
	return nil, false
}

// AsReplicaHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsReplicaHealthEvaluation() (*ReplicaHealthEvaluation, bool) {
	return nil, false
}

// AsReplicasHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsReplicasHealthEvaluation() (*ReplicasHealthEvaluation, bool) {
	return nil, false
}

// AsServiceHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsServiceHealthEvaluation() (*ServiceHealthEvaluation, bool) {
	return nil, false
}

// AsServicesHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsServicesHealthEvaluation() (*ServicesHealthEvaluation, bool) {
	return nil, false
}

// AsSystemApplicationHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsSystemApplicationHealthEvaluation() (*SystemApplicationHealthEvaluation, bool) {
	return nil, false
}

// AsUpgradeDomainDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsUpgradeDomainDeltaNodesCheckHealthEvaluation() (*UpgradeDomainDeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// AsUpgradeDomainNodesHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsUpgradeDomainNodesHealthEvaluation() (*UpgradeDomainNodesHealthEvaluation, bool) {
	return nil, false
}

// AsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsHealthEvaluation() (*HealthEvaluation, bool) {
	return nil, false
}

// AsBasicHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsBasicHealthEvaluation() (BasicHealthEvaluation, bool) {
	return &atahe, true
}

// ApplicationTypeHealthPolicyMapItem defines an item in ApplicationTypeHealthPolicyMap.
type ApplicationTypeHealthPolicyMapItem struct {
	// Key - The key of the application type health policy map item. This is the name of the application type.
	Key *string `json:"Key,omitempty"`
	// Value - The value of the application type health policy map item.
	// The max percent unhealthy applications allowed for the application type. Must be between zero and 100.
	Value *int32 `json:"Value,omitempty"`
}

// ApplicationTypeImageStorePath path description for the application package in the image store specified
// during the prior copy operation.
type ApplicationTypeImageStorePath struct {
	// ApplicationTypeBuildPath - The relative image store path to the application package.
	ApplicationTypeBuildPath *string `json:"ApplicationTypeBuildPath,omitempty"`
}

// ApplicationTypeInfo information about an application type.
type ApplicationTypeInfo struct {
	// Name - The application type name as defined in the application manifest.
	Name *string `json:"Name,omitempty"`
	// Version - The version of the application type as defined in the application manifest.
	Version *string `json:"Version,omitempty"`
	// DefaultParameterList - List of application type parameters that can be overridden when creating or updating the application.
	DefaultParameterList *[]ApplicationParameter `json:"DefaultParameterList,omitempty"`
	// Status - The status of the application type. Possible values include: 'ApplicationTypeStatusInvalid', 'ApplicationTypeStatusProvisioning', 'ApplicationTypeStatusAvailable', 'ApplicationTypeStatusUnprovisioning', 'ApplicationTypeStatusFailed'
	Status ApplicationTypeStatus `json:"Status,omitempty"`
	// StatusDetails - Additional detailed information about the status of the application type.
	StatusDetails *string `json:"StatusDetails,omitempty"`
	// ApplicationTypeDefinitionKind - The mechanism used to define a Service Fabric application type. Possible values include: 'ApplicationTypeDefinitionKindInvalid', 'ApplicationTypeDefinitionKindServiceFabricApplicationPackage', 'ApplicationTypeDefinitionKindCompose'
	ApplicationTypeDefinitionKind ApplicationTypeDefinitionKind `json:"ApplicationTypeDefinitionKind,omitempty"`
}

// ApplicationTypeManifest contains the manifest describing an application type registered in a Service
// Fabric cluster.
type ApplicationTypeManifest struct {
	autorest.Response `json:"-"`
	// Manifest - The XML manifest as a string.
	Manifest *string `json:"Manifest,omitempty"`
}

// ApplicationUpgradeCompleteEvent application Upgrade Complete event.
type ApplicationUpgradeCompleteEvent struct {
	// ApplicationTypeName - Application type name.
	ApplicationTypeName *string `json:"ApplicationTypeName,omitempty"`
	// ApplicationTypeVersion - Application type version.
	ApplicationTypeVersion *string `json:"ApplicationTypeVersion,omitempty"`
	// OverallUpgradeElapsedTimeInMs - Overall upgrade time in milli-seconds.
	OverallUpgradeElapsedTimeInMs *float64 `json:"OverallUpgradeElapsedTimeInMs,omitempty"`
	// ApplicationID - The identity of the application. This is an encoded representation of the application name. This is used in the REST APIs to identify the application resource.
	// Starting in version 6.0, hierarchical names are delimited with the "\~" character. For example, if the application name is "fabric:/myapp/app1",
	// the application identity would be "myapp\~app1" in 6.0+ and "myapp/app1" in previous versions.
	ApplicationID *string `json:"ApplicationId,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationHealthReportCreated', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeComplete', 'KindApplicationUpgradeDomainComplete', 'KindApplicationUpgradeRollbackComplete', 'KindApplicationUpgradeRollbackStart', 'KindApplicationUpgradeStart', 'KindDeployedApplicationHealthReportCreated', 'KindDeployedApplicationHealthReportExpired', 'KindProcessDeactivated', 'KindContainerDeactivated', 'KindNodeAborted', 'KindNodeAborting', 'KindNodeAdded', 'KindNodeClose', 'KindNodeClosing', 'KindNodeDeactivateComplete', 'KindNodeDeactivateStart', 'KindNodeDown', 'KindNodeHealthReportCreated', 'KindNodeHealthReportExpired', 'KindNodeOpenedSuccess', 'KindNodeOpenFailed', 'KindNodeOpening', 'KindNodeRemoved', 'KindNodeUp', 'KindPartitionHealthReportCreated', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigurationCompleted', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceHealthReportCreated', 'KindServiceHealthReportExpired', 'KindDeployedServiceHealthReportCreated', 'KindDeployedServiceHealthReportExpired', 'KindStatefulReplicaHealthReportCreated', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaHealthReportCreated', 'KindStatelessReplicaHealthReportExpired', 'KindClusterHealthReportCreated', 'KindClusterHealthReportExpired', 'KindClusterUpgradeComplete', 'KindClusterUpgradeDomainComplete', 'KindClusterUpgradeRollbackComplete', 'KindClusterUpgradeRollbackStart', 'KindClusterUpgradeStart', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosRestartNodeFaultCompleted', 'KindChaosRestartCodePackageFaultScheduled', 'KindChaosRestartCodePackageFaultCompleted', 'KindChaosRemoveReplicaFaultScheduled', 'KindChaosRemoveReplicaFaultCompleted', 'KindChaosMoveSecondaryFaultScheduled', 'KindChaosMovePrimaryFaultScheduled', 'KindChaosRestartReplicaFaultScheduled', 'KindChaosRestartNodeFaultScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) MarshalJSON() ([]byte, error) {
	auce.Kind = KindApplicationUpgradeComplete
	objectMap := make(map[string]interface{})
	if auce.ApplicationTypeName != nil {
		objectMap["ApplicationTypeName"] = auce.ApplicationTypeName
	}
	if auce.ApplicationTypeVersion != nil {
		objectMap["ApplicationTypeVersion"] = auce.ApplicationTypeVersion
	}
	if auce.OverallUpgradeElapsedTimeInMs != nil {
		objectMap["OverallUpgradeElapsedTimeInMs"] = auce.OverallUpgradeElapsedTimeInMs
	}
	if auce.ApplicationID != nil {
		objectMap["ApplicationId"] = auce.ApplicationID
	}
	if auce.EventInstanceID != nil {
		objectMap["EventInstanceId"] = auce.EventInstanceID
	}
	if auce.TimeStamp != nil {
		objectMap["TimeStamp"] = auce.TimeStamp
	}
	if auce.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = auce.HasCorrelatedEvents
	}
	if auce.Kind != "" {
		objectMap["Kind"] = auce.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return &auce, true
}

// AsClusterEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return nil, false
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsApplicationHealthReportCreatedEvent() (*ApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompleteEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsApplicationUpgradeCompleteEvent() (*ApplicationUpgradeCompleteEvent, bool) {
	return &auce, true
}

// AsApplicationUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsApplicationUpgradeDomainCompleteEvent() (*ApplicationUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsApplicationUpgradeRollbackCompleteEvent() (*ApplicationUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsApplicationUpgradeRollbackStartEvent() (*ApplicationUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsApplicationUpgradeStartEvent() (*ApplicationUpgradeStartEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsDeployedApplicationHealthReportCreatedEvent() (*DeployedApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsProcessDeactivatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsProcessDeactivatedEvent() (*ProcessDeactivatedEvent, bool) {
	return nil, false
}

// AsContainerDeactivatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsContainerDeactivatedEvent() (*ContainerDeactivatedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAbortingEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsNodeAbortingEvent() (*NodeAbortingEvent, bool) {
	return nil, false
}

// AsNodeAddedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsNodeAddedEvent() (*NodeAddedEvent, bool) {
	return nil, false
}

// AsNodeCloseEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsNodeCloseEvent() (*NodeCloseEvent, bool) {
	return nil, false
}

// AsNodeClosingEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsNodeClosingEvent() (*NodeClosingEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompleteEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsNodeDeactivateCompleteEvent() (*NodeDeactivateCompleteEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsNodeDeactivateStartEvent() (*NodeDeactivateStartEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsNodeHealthReportCreatedEvent() (*NodeHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenedSuccessEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsNodeOpenedSuccessEvent() (*NodeOpenedSuccessEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeOpeningEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsNodeOpeningEvent() (*NodeOpeningEvent, bool) {
	return nil, false
}

// AsNodeRemovedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsNodeRemovedEvent() (*NodeRemovedEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsPartitionHealthReportCreatedEvent() (*PartitionHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfigurationCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsPartitionReconfigurationCompletedEvent() (*PartitionReconfigurationCompletedEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsServiceHealthReportCreatedEvent() (*ServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsDeployedServiceHealthReportCreatedEvent() (*DeployedServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsDeployedServiceHealthReportExpiredEvent() (*DeployedServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsStatefulReplicaHealthReportCreatedEvent() (*StatefulReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsStatelessReplicaHealthReportCreatedEvent() (*StatelessReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsClusterHealthReportCreatedEvent() (*ClusterHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompleteEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsClusterUpgradeCompleteEvent() (*ClusterUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsClusterUpgradeDomainCompleteEvent() (*ClusterUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsClusterUpgradeRollbackCompleteEvent() (*ClusterUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsClusterUpgradeRollbackStartEvent() (*ClusterUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsClusterUpgradeStartEvent() (*ClusterUpgradeStartEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsChaosRestartNodeFaultCompletedEvent() (*ChaosRestartNodeFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsChaosRestartCodePackageFaultScheduledEvent() (*ChaosRestartCodePackageFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsChaosRestartCodePackageFaultCompletedEvent() (*ChaosRestartCodePackageFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsChaosRemoveReplicaFaultScheduledEvent() (*ChaosRemoveReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsChaosRemoveReplicaFaultCompletedEvent() (*ChaosRemoveReplicaFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosMoveSecondaryFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsChaosMoveSecondaryFaultScheduledEvent() (*ChaosMoveSecondaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosMovePrimaryFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsChaosMovePrimaryFaultScheduledEvent() (*ChaosMovePrimaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsChaosRestartReplicaFaultScheduledEvent() (*ChaosRestartReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsChaosRestartNodeFaultScheduledEvent() (*ChaosRestartNodeFaultScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompleteEvent.
func (auce ApplicationUpgradeCompleteEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &auce, true
}

// ApplicationUpgradeDescription describes the parameters for an application upgrade. Note that upgrade
// description replaces the existing application description. This means that if the parameters are not
// specified, the existing parameters on the applications will be overwritten with the empty parameters
// list. This would result in the application using the default value of the parameters from the
// application manifest. If you do not want to change any existing parameter values, please get the
// application parameters first using the GetApplicationInfo query and then supply those values as
// Parameters in this ApplicationUpgradeDescription.
type ApplicationUpgradeDescription struct {
	// Name - The name of the target application, including the 'fabric:' URI scheme.
	Name *string `json:"Name,omitempty"`
	// TargetApplicationTypeVersion - The target application type version (found in the application manifest) for the application upgrade.
	TargetApplicationTypeVersion *string `json:"TargetApplicationTypeVersion,omitempty"`
	// Parameters - List of application parameters with overridden values from their default values specified in the application manifest.
	Parameters *[]ApplicationParameter `json:"Parameters,omitempty"`
	// UpgradeKind - The kind of upgrade out of the following possible values. Possible values include: 'UpgradeKindInvalid', 'UpgradeKindRolling'
	UpgradeKind UpgradeKind `json:"UpgradeKind,omitempty"`
	// RollingUpgradeMode - The mode used to monitor health during a rolling upgrade. The values are UnmonitoredAuto, UnmonitoredManual, and Monitored. Possible values include: 'UpgradeModeInvalid', 'UpgradeModeUnmonitoredAuto', 'UpgradeModeUnmonitoredManual', 'UpgradeModeMonitored'
	RollingUpgradeMode UpgradeMode `json:"RollingUpgradeMode,omitempty"`
	// UpgradeReplicaSetCheckTimeoutInSeconds - The maximum amount of time to block processing of an upgrade domain and prevent loss of availability when there are unexpected issues. When this timeout expires, processing of the upgrade domain will proceed regardless of availability loss issues. The timeout is reset at the start of each upgrade domain. Valid values are between 0 and 42949672925 inclusive. (unsigned 32-bit integer).
	UpgradeReplicaSetCheckTimeoutInSeconds *int64 `json:"UpgradeReplicaSetCheckTimeoutInSeconds,omitempty"`
	// ForceRestart - If true, then processes are forcefully restarted during upgrade even when the code version has not changed (the upgrade only changes configuration or data).
	ForceRestart *bool `json:"ForceRestart,omitempty"`
	// MonitoringPolicy - Describes the parameters for monitoring an upgrade in Monitored mode.
	MonitoringPolicy *MonitoringPolicyDescription `json:"MonitoringPolicy,omitempty"`
	// ApplicationHealthPolicy - Defines a health policy used to evaluate the health of an application or one of its children entities.
	ApplicationHealthPolicy *ApplicationHealthPolicy `json:"ApplicationHealthPolicy,omitempty"`
}

// ApplicationUpgradeDomainCompleteEvent application Upgrade Domain Complete event.
type ApplicationUpgradeDomainCompleteEvent struct {
	// ApplicationTypeName - Application type name.
	ApplicationTypeName *string `json:"ApplicationTypeName,omitempty"`
	// CurrentApplicationTypeVersion - Current Application type version.
	CurrentApplicationTypeVersion *string `json:"CurrentApplicationTypeVersion,omitempty"`
	// ApplicationTypeVersion - Target Application type version.
	ApplicationTypeVersion *string `json:"ApplicationTypeVersion,omitempty"`
	// UpgradeState - State of upgrade.
	UpgradeState *string `json:"UpgradeState,omitempty"`
	// UpgradeDomains - Upgrade domains.
	UpgradeDomains *string `json:"UpgradeDomains,omitempty"`
	// UpgradeDomainElapsedTimeInMs - Upgrade time of domain in milli-seconds.
	UpgradeDomainElapsedTimeInMs *float64 `json:"UpgradeDomainElapsedTimeInMs,omitempty"`
	// ApplicationID - The identity of the application. This is an encoded representation of the application name. This is used in the REST APIs to identify the application resource.
	// Starting in version 6.0, hierarchical names are delimited with the "\~" character. For example, if the application name is "fabric:/myapp/app1",
	// the application identity would be "myapp\~app1" in 6.0+ and "myapp/app1" in previous versions.
	ApplicationID *string `json:"ApplicationId,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationHealthReportCreated', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeComplete', 'KindApplicationUpgradeDomainComplete', 'KindApplicationUpgradeRollbackComplete', 'KindApplicationUpgradeRollbackStart', 'KindApplicationUpgradeStart', 'KindDeployedApplicationHealthReportCreated', 'KindDeployedApplicationHealthReportExpired', 'KindProcessDeactivated', 'KindContainerDeactivated', 'KindNodeAborted', 'KindNodeAborting', 'KindNodeAdded', 'KindNodeClose', 'KindNodeClosing', 'KindNodeDeactivateComplete', 'KindNodeDeactivateStart', 'KindNodeDown', 'KindNodeHealthReportCreated', 'KindNodeHealthReportExpired', 'KindNodeOpenedSuccess', 'KindNodeOpenFailed', 'KindNodeOpening', 'KindNodeRemoved', 'KindNodeUp', 'KindPartitionHealthReportCreated', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigurationCompleted', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceHealthReportCreated', 'KindServiceHealthReportExpired', 'KindDeployedServiceHealthReportCreated', 'KindDeployedServiceHealthReportExpired', 'KindStatefulReplicaHealthReportCreated', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaHealthReportCreated', 'KindStatelessReplicaHealthReportExpired', 'KindClusterHealthReportCreated', 'KindClusterHealthReportExpired', 'KindClusterUpgradeComplete', 'KindClusterUpgradeDomainComplete', 'KindClusterUpgradeRollbackComplete', 'KindClusterUpgradeRollbackStart', 'KindClusterUpgradeStart', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosRestartNodeFaultCompleted', 'KindChaosRestartCodePackageFaultScheduled', 'KindChaosRestartCodePackageFaultCompleted', 'KindChaosRemoveReplicaFaultScheduled', 'KindChaosRemoveReplicaFaultCompleted', 'KindChaosMoveSecondaryFaultScheduled', 'KindChaosMovePrimaryFaultScheduled', 'KindChaosRestartReplicaFaultScheduled', 'KindChaosRestartNodeFaultScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) MarshalJSON() ([]byte, error) {
	audce.Kind = KindApplicationUpgradeDomainComplete
	objectMap := make(map[string]interface{})
	if audce.ApplicationTypeName != nil {
		objectMap["ApplicationTypeName"] = audce.ApplicationTypeName
	}
	if audce.CurrentApplicationTypeVersion != nil {
		objectMap["CurrentApplicationTypeVersion"] = audce.CurrentApplicationTypeVersion
	}
	if audce.ApplicationTypeVersion != nil {
		objectMap["ApplicationTypeVersion"] = audce.ApplicationTypeVersion
	}
	if audce.UpgradeState != nil {
		objectMap["UpgradeState"] = audce.UpgradeState
	}
	if audce.UpgradeDomains != nil {
		objectMap["UpgradeDomains"] = audce.UpgradeDomains
	}
	if audce.UpgradeDomainElapsedTimeInMs != nil {
		objectMap["UpgradeDomainElapsedTimeInMs"] = audce.UpgradeDomainElapsedTimeInMs
	}
	if audce.ApplicationID != nil {
		objectMap["ApplicationId"] = audce.ApplicationID
	}
	if audce.EventInstanceID != nil {
		objectMap["EventInstanceId"] = audce.EventInstanceID
	}
	if audce.TimeStamp != nil {
		objectMap["TimeStamp"] = audce.TimeStamp
	}
	if audce.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = audce.HasCorrelatedEvents
	}
	if audce.Kind != "" {
		objectMap["Kind"] = audce.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return &audce, true
}

// AsClusterEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return nil, false
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsApplicationHealthReportCreatedEvent() (*ApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompleteEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsApplicationUpgradeCompleteEvent() (*ApplicationUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsApplicationUpgradeDomainCompleteEvent() (*ApplicationUpgradeDomainCompleteEvent, bool) {
	return &audce, true
}

// AsApplicationUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsApplicationUpgradeRollbackCompleteEvent() (*ApplicationUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsApplicationUpgradeRollbackStartEvent() (*ApplicationUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsApplicationUpgradeStartEvent() (*ApplicationUpgradeStartEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsDeployedApplicationHealthReportCreatedEvent() (*DeployedApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsProcessDeactivatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsProcessDeactivatedEvent() (*ProcessDeactivatedEvent, bool) {
	return nil, false
}

// AsContainerDeactivatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsContainerDeactivatedEvent() (*ContainerDeactivatedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAbortingEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsNodeAbortingEvent() (*NodeAbortingEvent, bool) {
	return nil, false
}

// AsNodeAddedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsNodeAddedEvent() (*NodeAddedEvent, bool) {
	return nil, false
}

// AsNodeCloseEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsNodeCloseEvent() (*NodeCloseEvent, bool) {
	return nil, false
}

// AsNodeClosingEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsNodeClosingEvent() (*NodeClosingEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompleteEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsNodeDeactivateCompleteEvent() (*NodeDeactivateCompleteEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsNodeDeactivateStartEvent() (*NodeDeactivateStartEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsNodeHealthReportCreatedEvent() (*NodeHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenedSuccessEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsNodeOpenedSuccessEvent() (*NodeOpenedSuccessEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeOpeningEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsNodeOpeningEvent() (*NodeOpeningEvent, bool) {
	return nil, false
}

// AsNodeRemovedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsNodeRemovedEvent() (*NodeRemovedEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsPartitionHealthReportCreatedEvent() (*PartitionHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfigurationCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsPartitionReconfigurationCompletedEvent() (*PartitionReconfigurationCompletedEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsServiceHealthReportCreatedEvent() (*ServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsDeployedServiceHealthReportCreatedEvent() (*DeployedServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsDeployedServiceHealthReportExpiredEvent() (*DeployedServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsStatefulReplicaHealthReportCreatedEvent() (*StatefulReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsStatelessReplicaHealthReportCreatedEvent() (*StatelessReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsClusterHealthReportCreatedEvent() (*ClusterHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompleteEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsClusterUpgradeCompleteEvent() (*ClusterUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsClusterUpgradeDomainCompleteEvent() (*ClusterUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsClusterUpgradeRollbackCompleteEvent() (*ClusterUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsClusterUpgradeRollbackStartEvent() (*ClusterUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsClusterUpgradeStartEvent() (*ClusterUpgradeStartEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsChaosRestartNodeFaultCompletedEvent() (*ChaosRestartNodeFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsChaosRestartCodePackageFaultScheduledEvent() (*ChaosRestartCodePackageFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsChaosRestartCodePackageFaultCompletedEvent() (*ChaosRestartCodePackageFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsChaosRemoveReplicaFaultScheduledEvent() (*ChaosRemoveReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsChaosRemoveReplicaFaultCompletedEvent() (*ChaosRemoveReplicaFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosMoveSecondaryFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsChaosMoveSecondaryFaultScheduledEvent() (*ChaosMoveSecondaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosMovePrimaryFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsChaosMovePrimaryFaultScheduledEvent() (*ChaosMovePrimaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsChaosRestartReplicaFaultScheduledEvent() (*ChaosRestartReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsChaosRestartNodeFaultScheduledEvent() (*ChaosRestartNodeFaultScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompleteEvent.
func (audce ApplicationUpgradeDomainCompleteEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &audce, true
}

// ApplicationUpgradeProgressInfo describes the parameters for an application upgrade.
type ApplicationUpgradeProgressInfo struct {
	autorest.Response `json:"-"`
	// Name - The name of the target application, including the 'fabric:' URI scheme.
	Name *string `json:"Name,omitempty"`
	// TypeName - The application type name as defined in the application manifest.
	TypeName *string `json:"TypeName,omitempty"`
	// TargetApplicationTypeVersion - The target application type version (found in the application manifest) for the application upgrade.
	TargetApplicationTypeVersion *string `json:"TargetApplicationTypeVersion,omitempty"`
	// UpgradeDomains - List of upgrade domains and their statuses.
	UpgradeDomains *[]UpgradeDomainInfo `json:"UpgradeDomains,omitempty"`
	// UpgradeState - The state of the upgrade domain. Possible values include: 'UpgradeStateInvalid', 'UpgradeStateRollingBackInProgress', 'UpgradeStateRollingBackCompleted', 'UpgradeStateRollingForwardPending', 'UpgradeStateRollingForwardInProgress', 'UpgradeStateRollingForwardCompleted', 'UpgradeStateFailed'
	UpgradeState UpgradeState `json:"UpgradeState,omitempty"`
	// NextUpgradeDomain - The name of the next upgrade domain to be processed.
	NextUpgradeDomain *string `json:"NextUpgradeDomain,omitempty"`
	// RollingUpgradeMode - The mode used to monitor health during a rolling upgrade. The values are UnmonitoredAuto, UnmonitoredManual, and Monitored. Possible values include: 'UpgradeModeInvalid', 'UpgradeModeUnmonitoredAuto', 'UpgradeModeUnmonitoredManual', 'UpgradeModeMonitored'
	RollingUpgradeMode UpgradeMode `json:"RollingUpgradeMode,omitempty"`
	// UpgradeDescription - Describes the parameters for an application upgrade. Note that upgrade description replaces the existing application description. This means that if the parameters are not specified, the existing parameters on the applications will be overwritten with the empty parameters list. This would result in the application using the default value of the parameters from the application manifest. If you do not want to change any existing parameter values, please get the application parameters first using the GetApplicationInfo query and then supply those values as Parameters in this ApplicationUpgradeDescription.
	UpgradeDescription *ApplicationUpgradeDescription `json:"UpgradeDescription,omitempty"`
	// UpgradeDurationInMilliseconds - The estimated total amount of time spent processing the overall upgrade.
	UpgradeDurationInMilliseconds *string `json:"UpgradeDurationInMilliseconds,omitempty"`
	// UpgradeDomainDurationInMilliseconds - The estimated total amount of time spent processing the current upgrade domain.
	UpgradeDomainDurationInMilliseconds *string `json:"UpgradeDomainDurationInMilliseconds,omitempty"`
	// UnhealthyEvaluations - List of health evaluations that resulted in the current aggregated health state.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// CurrentUpgradeDomainProgress - Information about the current in-progress upgrade domain.
	CurrentUpgradeDomainProgress *CurrentUpgradeDomainProgressInfo `json:"CurrentUpgradeDomainProgress,omitempty"`
	// StartTimestampUtc - The estimated UTC datetime when the upgrade started.
	StartTimestampUtc *string `json:"StartTimestampUtc,omitempty"`
	// FailureTimestampUtc - The estimated UTC datetime when the upgrade failed and FailureAction was executed.
	FailureTimestampUtc *string `json:"FailureTimestampUtc,omitempty"`
	// FailureReason - The cause of an upgrade failure that resulted in FailureAction being executed. Possible values include: 'None', 'Interrupted', 'HealthCheck', 'UpgradeDomainTimeout', 'OverallUpgradeTimeout'
	FailureReason FailureReason `json:"FailureReason,omitempty"`
	// UpgradeDomainProgressAtFailure - Information about the upgrade domain progress at the time of upgrade failure.
	UpgradeDomainProgressAtFailure *FailureUpgradeDomainProgressInfo `json:"UpgradeDomainProgressAtFailure,omitempty"`
	// UpgradeStatusDetails - Additional detailed information about the status of the pending upgrade.
	UpgradeStatusDetails *string `json:"UpgradeStatusDetails,omitempty"`
}

// ApplicationUpgradeRollbackCompleteEvent application Upgrade Rollback Complete event.
type ApplicationUpgradeRollbackCompleteEvent struct {
	// ApplicationTypeName - Application type name.
	ApplicationTypeName *string `json:"ApplicationTypeName,omitempty"`
	// ApplicationTypeVersion - Application type version.
	ApplicationTypeVersion *string `json:"ApplicationTypeVersion,omitempty"`
	// FailureReason - Describes reason of failure.
	FailureReason *string `json:"FailureReason,omitempty"`
	// OverallUpgradeElapsedTimeInMs - Overall upgrade time in milli-seconds.
	OverallUpgradeElapsedTimeInMs *float64 `json:"OverallUpgradeElapsedTimeInMs,omitempty"`
	// ApplicationID - The identity of the application. This is an encoded representation of the application name. This is used in the REST APIs to identify the application resource.
	// Starting in version 6.0, hierarchical names are delimited with the "\~" character. For example, if the application name is "fabric:/myapp/app1",
	// the application identity would be "myapp\~app1" in 6.0+ and "myapp/app1" in previous versions.
	ApplicationID *string `json:"ApplicationId,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationHealthReportCreated', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeComplete', 'KindApplicationUpgradeDomainComplete', 'KindApplicationUpgradeRollbackComplete', 'KindApplicationUpgradeRollbackStart', 'KindApplicationUpgradeStart', 'KindDeployedApplicationHealthReportCreated', 'KindDeployedApplicationHealthReportExpired', 'KindProcessDeactivated', 'KindContainerDeactivated', 'KindNodeAborted', 'KindNodeAborting', 'KindNodeAdded', 'KindNodeClose', 'KindNodeClosing', 'KindNodeDeactivateComplete', 'KindNodeDeactivateStart', 'KindNodeDown', 'KindNodeHealthReportCreated', 'KindNodeHealthReportExpired', 'KindNodeOpenedSuccess', 'KindNodeOpenFailed', 'KindNodeOpening', 'KindNodeRemoved', 'KindNodeUp', 'KindPartitionHealthReportCreated', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigurationCompleted', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceHealthReportCreated', 'KindServiceHealthReportExpired', 'KindDeployedServiceHealthReportCreated', 'KindDeployedServiceHealthReportExpired', 'KindStatefulReplicaHealthReportCreated', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaHealthReportCreated', 'KindStatelessReplicaHealthReportExpired', 'KindClusterHealthReportCreated', 'KindClusterHealthReportExpired', 'KindClusterUpgradeComplete', 'KindClusterUpgradeDomainComplete', 'KindClusterUpgradeRollbackComplete', 'KindClusterUpgradeRollbackStart', 'KindClusterUpgradeStart', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosRestartNodeFaultCompleted', 'KindChaosRestartCodePackageFaultScheduled', 'KindChaosRestartCodePackageFaultCompleted', 'KindChaosRemoveReplicaFaultScheduled', 'KindChaosRemoveReplicaFaultCompleted', 'KindChaosMoveSecondaryFaultScheduled', 'KindChaosMovePrimaryFaultScheduled', 'KindChaosRestartReplicaFaultScheduled', 'KindChaosRestartNodeFaultScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) MarshalJSON() ([]byte, error) {
	aurce.Kind = KindApplicationUpgradeRollbackComplete
	objectMap := make(map[string]interface{})
	if aurce.ApplicationTypeName != nil {
		objectMap["ApplicationTypeName"] = aurce.ApplicationTypeName
	}
	if aurce.ApplicationTypeVersion != nil {
		objectMap["ApplicationTypeVersion"] = aurce.ApplicationTypeVersion
	}
	if aurce.FailureReason != nil {
		objectMap["FailureReason"] = aurce.FailureReason
	}
	if aurce.OverallUpgradeElapsedTimeInMs != nil {
		objectMap["OverallUpgradeElapsedTimeInMs"] = aurce.OverallUpgradeElapsedTimeInMs
	}
	if aurce.ApplicationID != nil {
		objectMap["ApplicationId"] = aurce.ApplicationID
	}
	if aurce.EventInstanceID != nil {
		objectMap["EventInstanceId"] = aurce.EventInstanceID
	}
	if aurce.TimeStamp != nil {
		objectMap["TimeStamp"] = aurce.TimeStamp
	}
	if aurce.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = aurce.HasCorrelatedEvents
	}
	if aurce.Kind != "" {
		objectMap["Kind"] = aurce.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return &aurce, true
}

// AsClusterEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return nil, false
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsApplicationHealthReportCreatedEvent() (*ApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompleteEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsApplicationUpgradeCompleteEvent() (*ApplicationUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsApplicationUpgradeDomainCompleteEvent() (*ApplicationUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsApplicationUpgradeRollbackCompleteEvent() (*ApplicationUpgradeRollbackCompleteEvent, bool) {
	return &aurce, true
}

// AsApplicationUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsApplicationUpgradeRollbackStartEvent() (*ApplicationUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsApplicationUpgradeStartEvent() (*ApplicationUpgradeStartEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsDeployedApplicationHealthReportCreatedEvent() (*DeployedApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsProcessDeactivatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsProcessDeactivatedEvent() (*ProcessDeactivatedEvent, bool) {
	return nil, false
}

// AsContainerDeactivatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsContainerDeactivatedEvent() (*ContainerDeactivatedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAbortingEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsNodeAbortingEvent() (*NodeAbortingEvent, bool) {
	return nil, false
}

// AsNodeAddedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsNodeAddedEvent() (*NodeAddedEvent, bool) {
	return nil, false
}

// AsNodeCloseEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsNodeCloseEvent() (*NodeCloseEvent, bool) {
	return nil, false
}

// AsNodeClosingEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsNodeClosingEvent() (*NodeClosingEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompleteEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsNodeDeactivateCompleteEvent() (*NodeDeactivateCompleteEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsNodeDeactivateStartEvent() (*NodeDeactivateStartEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsNodeHealthReportCreatedEvent() (*NodeHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenedSuccessEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsNodeOpenedSuccessEvent() (*NodeOpenedSuccessEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeOpeningEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsNodeOpeningEvent() (*NodeOpeningEvent, bool) {
	return nil, false
}

// AsNodeRemovedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsNodeRemovedEvent() (*NodeRemovedEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsPartitionHealthReportCreatedEvent() (*PartitionHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfigurationCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsPartitionReconfigurationCompletedEvent() (*PartitionReconfigurationCompletedEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsServiceHealthReportCreatedEvent() (*ServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsDeployedServiceHealthReportCreatedEvent() (*DeployedServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsDeployedServiceHealthReportExpiredEvent() (*DeployedServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsStatefulReplicaHealthReportCreatedEvent() (*StatefulReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsStatelessReplicaHealthReportCreatedEvent() (*StatelessReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsClusterHealthReportCreatedEvent() (*ClusterHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompleteEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsClusterUpgradeCompleteEvent() (*ClusterUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsClusterUpgradeDomainCompleteEvent() (*ClusterUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsClusterUpgradeRollbackCompleteEvent() (*ClusterUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsClusterUpgradeRollbackStartEvent() (*ClusterUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsClusterUpgradeStartEvent() (*ClusterUpgradeStartEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsChaosRestartNodeFaultCompletedEvent() (*ChaosRestartNodeFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsChaosRestartCodePackageFaultScheduledEvent() (*ChaosRestartCodePackageFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsChaosRestartCodePackageFaultCompletedEvent() (*ChaosRestartCodePackageFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsChaosRemoveReplicaFaultScheduledEvent() (*ChaosRemoveReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsChaosRemoveReplicaFaultCompletedEvent() (*ChaosRemoveReplicaFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosMoveSecondaryFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsChaosMoveSecondaryFaultScheduledEvent() (*ChaosMoveSecondaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosMovePrimaryFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsChaosMovePrimaryFaultScheduledEvent() (*ChaosMovePrimaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsChaosRestartReplicaFaultScheduledEvent() (*ChaosRestartReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsChaosRestartNodeFaultScheduledEvent() (*ChaosRestartNodeFaultScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompleteEvent.
func (aurce ApplicationUpgradeRollbackCompleteEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &aurce, true
}

// ApplicationUpgradeRollbackStartEvent application Upgrade Rollback Start event.
type ApplicationUpgradeRollbackStartEvent struct {
	// ApplicationTypeName - Application type name.
	ApplicationTypeName *string `json:"ApplicationTypeName,omitempty"`
	// CurrentApplicationTypeVersion - Current Application type version.
	CurrentApplicationTypeVersion *string `json:"CurrentApplicationTypeVersion,omitempty"`
	// ApplicationTypeVersion - Target Application type version.
	ApplicationTypeVersion *string `json:"ApplicationTypeVersion,omitempty"`
	// FailureReason - Describes reason of failure.
	FailureReason *string `json:"FailureReason,omitempty"`
	// OverallUpgradeElapsedTimeInMs - Overall upgrade time in milli-seconds.
	OverallUpgradeElapsedTimeInMs *float64 `json:"OverallUpgradeElapsedTimeInMs,omitempty"`
	// ApplicationID - The identity of the application. This is an encoded representation of the application name. This is used in the REST APIs to identify the application resource.
	// Starting in version 6.0, hierarchical names are delimited with the "\~" character. For example, if the application name is "fabric:/myapp/app1",
	// the application identity would be "myapp\~app1" in 6.0+ and "myapp/app1" in previous versions.
	ApplicationID *string `json:"ApplicationId,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationHealthReportCreated', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeComplete', 'KindApplicationUpgradeDomainComplete', 'KindApplicationUpgradeRollbackComplete', 'KindApplicationUpgradeRollbackStart', 'KindApplicationUpgradeStart', 'KindDeployedApplicationHealthReportCreated', 'KindDeployedApplicationHealthReportExpired', 'KindProcessDeactivated', 'KindContainerDeactivated', 'KindNodeAborted', 'KindNodeAborting', 'KindNodeAdded', 'KindNodeClose', 'KindNodeClosing', 'KindNodeDeactivateComplete', 'KindNodeDeactivateStart', 'KindNodeDown', 'KindNodeHealthReportCreated', 'KindNodeHealthReportExpired', 'KindNodeOpenedSuccess', 'KindNodeOpenFailed', 'KindNodeOpening', 'KindNodeRemoved', 'KindNodeUp', 'KindPartitionHealthReportCreated', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigurationCompleted', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceHealthReportCreated', 'KindServiceHealthReportExpired', 'KindDeployedServiceHealthReportCreated', 'KindDeployedServiceHealthReportExpired', 'KindStatefulReplicaHealthReportCreated', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaHealthReportCreated', 'KindStatelessReplicaHealthReportExpired', 'KindClusterHealthReportCreated', 'KindClusterHealthReportExpired', 'KindClusterUpgradeComplete', 'KindClusterUpgradeDomainComplete', 'KindClusterUpgradeRollbackComplete', 'KindClusterUpgradeRollbackStart', 'KindClusterUpgradeStart', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosRestartNodeFaultCompleted', 'KindChaosRestartCodePackageFaultScheduled', 'KindChaosRestartCodePackageFaultCompleted', 'KindChaosRemoveReplicaFaultScheduled', 'KindChaosRemoveReplicaFaultCompleted', 'KindChaosMoveSecondaryFaultScheduled', 'KindChaosMovePrimaryFaultScheduled', 'KindChaosRestartReplicaFaultScheduled', 'KindChaosRestartNodeFaultScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) MarshalJSON() ([]byte, error) {
	aurse.Kind = KindApplicationUpgradeRollbackStart
	objectMap := make(map[string]interface{})
	if aurse.ApplicationTypeName != nil {
		objectMap["ApplicationTypeName"] = aurse.ApplicationTypeName
	}
	if aurse.CurrentApplicationTypeVersion != nil {
		objectMap["CurrentApplicationTypeVersion"] = aurse.CurrentApplicationTypeVersion
	}
	if aurse.ApplicationTypeVersion != nil {
		objectMap["ApplicationTypeVersion"] = aurse.ApplicationTypeVersion
	}
	if aurse.FailureReason != nil {
		objectMap["FailureReason"] = aurse.FailureReason
	}
	if aurse.OverallUpgradeElapsedTimeInMs != nil {
		objectMap["OverallUpgradeElapsedTimeInMs"] = aurse.OverallUpgradeElapsedTimeInMs
	}
	if aurse.ApplicationID != nil {
		objectMap["ApplicationId"] = aurse.ApplicationID
	}
	if aurse.EventInstanceID != nil {
		objectMap["EventInstanceId"] = aurse.EventInstanceID
	}
	if aurse.TimeStamp != nil {
		objectMap["TimeStamp"] = aurse.TimeStamp
	}
	if aurse.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = aurse.HasCorrelatedEvents
	}
	if aurse.Kind != "" {
		objectMap["Kind"] = aurse.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return &aurse, true
}

// AsClusterEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return nil, false
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsApplicationHealthReportCreatedEvent() (*ApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompleteEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsApplicationUpgradeCompleteEvent() (*ApplicationUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsApplicationUpgradeDomainCompleteEvent() (*ApplicationUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsApplicationUpgradeRollbackCompleteEvent() (*ApplicationUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsApplicationUpgradeRollbackStartEvent() (*ApplicationUpgradeRollbackStartEvent, bool) {
	return &aurse, true
}

// AsApplicationUpgradeStartEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsApplicationUpgradeStartEvent() (*ApplicationUpgradeStartEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsDeployedApplicationHealthReportCreatedEvent() (*DeployedApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsProcessDeactivatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsProcessDeactivatedEvent() (*ProcessDeactivatedEvent, bool) {
	return nil, false
}

// AsContainerDeactivatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsContainerDeactivatedEvent() (*ContainerDeactivatedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAbortingEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsNodeAbortingEvent() (*NodeAbortingEvent, bool) {
	return nil, false
}

// AsNodeAddedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsNodeAddedEvent() (*NodeAddedEvent, bool) {
	return nil, false
}

// AsNodeCloseEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsNodeCloseEvent() (*NodeCloseEvent, bool) {
	return nil, false
}

// AsNodeClosingEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsNodeClosingEvent() (*NodeClosingEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompleteEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsNodeDeactivateCompleteEvent() (*NodeDeactivateCompleteEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsNodeDeactivateStartEvent() (*NodeDeactivateStartEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsNodeHealthReportCreatedEvent() (*NodeHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenedSuccessEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsNodeOpenedSuccessEvent() (*NodeOpenedSuccessEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeOpeningEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsNodeOpeningEvent() (*NodeOpeningEvent, bool) {
	return nil, false
}

// AsNodeRemovedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsNodeRemovedEvent() (*NodeRemovedEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsPartitionHealthReportCreatedEvent() (*PartitionHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfigurationCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsPartitionReconfigurationCompletedEvent() (*PartitionReconfigurationCompletedEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsServiceHealthReportCreatedEvent() (*ServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsDeployedServiceHealthReportCreatedEvent() (*DeployedServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsDeployedServiceHealthReportExpiredEvent() (*DeployedServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsStatefulReplicaHealthReportCreatedEvent() (*StatefulReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsStatelessReplicaHealthReportCreatedEvent() (*StatelessReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsClusterHealthReportCreatedEvent() (*ClusterHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompleteEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsClusterUpgradeCompleteEvent() (*ClusterUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsClusterUpgradeDomainCompleteEvent() (*ClusterUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsClusterUpgradeRollbackCompleteEvent() (*ClusterUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsClusterUpgradeRollbackStartEvent() (*ClusterUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsClusterUpgradeStartEvent() (*ClusterUpgradeStartEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsChaosRestartNodeFaultCompletedEvent() (*ChaosRestartNodeFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsChaosRestartCodePackageFaultScheduledEvent() (*ChaosRestartCodePackageFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsChaosRestartCodePackageFaultCompletedEvent() (*ChaosRestartCodePackageFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsChaosRemoveReplicaFaultScheduledEvent() (*ChaosRemoveReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsChaosRemoveReplicaFaultCompletedEvent() (*ChaosRemoveReplicaFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosMoveSecondaryFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsChaosMoveSecondaryFaultScheduledEvent() (*ChaosMoveSecondaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosMovePrimaryFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsChaosMovePrimaryFaultScheduledEvent() (*ChaosMovePrimaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsChaosRestartReplicaFaultScheduledEvent() (*ChaosRestartReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsChaosRestartNodeFaultScheduledEvent() (*ChaosRestartNodeFaultScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartEvent.
func (aurse ApplicationUpgradeRollbackStartEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &aurse, true
}

// ApplicationUpgradeStartEvent application Upgrade Start event.
type ApplicationUpgradeStartEvent struct {
	// ApplicationTypeName - Application type name.
	ApplicationTypeName *string `json:"ApplicationTypeName,omitempty"`
	// CurrentApplicationTypeVersion - Current Application type version.
	CurrentApplicationTypeVersion *string `json:"CurrentApplicationTypeVersion,omitempty"`
	// ApplicationTypeVersion - Target Application type version.
	ApplicationTypeVersion *string `json:"ApplicationTypeVersion,omitempty"`
	// UpgradeType - Type of upgrade.
	UpgradeType *string `json:"UpgradeType,omitempty"`
	// RollingUpgradeMode - Mode of upgrade.
	RollingUpgradeMode *string `json:"RollingUpgradeMode,omitempty"`
	// FailureAction - Action if failed.
	FailureAction *string `json:"FailureAction,omitempty"`
	// ApplicationID - The identity of the application. This is an encoded representation of the application name. This is used in the REST APIs to identify the application resource.
	// Starting in version 6.0, hierarchical names are delimited with the "\~" character. For example, if the application name is "fabric:/myapp/app1",
	// the application identity would be "myapp\~app1" in 6.0+ and "myapp/app1" in previous versions.
	ApplicationID *string `json:"ApplicationId,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationHealthReportCreated', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeComplete', 'KindApplicationUpgradeDomainComplete', 'KindApplicationUpgradeRollbackComplete', 'KindApplicationUpgradeRollbackStart', 'KindApplicationUpgradeStart', 'KindDeployedApplicationHealthReportCreated', 'KindDeployedApplicationHealthReportExpired', 'KindProcessDeactivated', 'KindContainerDeactivated', 'KindNodeAborted', 'KindNodeAborting', 'KindNodeAdded', 'KindNodeClose', 'KindNodeClosing', 'KindNodeDeactivateComplete', 'KindNodeDeactivateStart', 'KindNodeDown', 'KindNodeHealthReportCreated', 'KindNodeHealthReportExpired', 'KindNodeOpenedSuccess', 'KindNodeOpenFailed', 'KindNodeOpening', 'KindNodeRemoved', 'KindNodeUp', 'KindPartitionHealthReportCreated', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigurationCompleted', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceHealthReportCreated', 'KindServiceHealthReportExpired', 'KindDeployedServiceHealthReportCreated', 'KindDeployedServiceHealthReportExpired', 'KindStatefulReplicaHealthReportCreated', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaHealthReportCreated', 'KindStatelessReplicaHealthReportExpired', 'KindClusterHealthReportCreated', 'KindClusterHealthReportExpired', 'KindClusterUpgradeComplete', 'KindClusterUpgradeDomainComplete', 'KindClusterUpgradeRollbackComplete', 'KindClusterUpgradeRollbackStart', 'KindClusterUpgradeStart', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosRestartNodeFaultCompleted', 'KindChaosRestartCodePackageFaultScheduled', 'KindChaosRestartCodePackageFaultCompleted', 'KindChaosRemoveReplicaFaultScheduled', 'KindChaosRemoveReplicaFaultCompleted', 'KindChaosMoveSecondaryFaultScheduled', 'KindChaosMovePrimaryFaultScheduled', 'KindChaosRestartReplicaFaultScheduled', 'KindChaosRestartNodeFaultScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) MarshalJSON() ([]byte, error) {
	ause.Kind = KindApplicationUpgradeStart
	objectMap := make(map[string]interface{})
	if ause.ApplicationTypeName != nil {
		objectMap["ApplicationTypeName"] = ause.ApplicationTypeName
	}
	if ause.CurrentApplicationTypeVersion != nil {
		objectMap["CurrentApplicationTypeVersion"] = ause.CurrentApplicationTypeVersion
	}
	if ause.ApplicationTypeVersion != nil {
		objectMap["ApplicationTypeVersion"] = ause.ApplicationTypeVersion
	}
	if ause.UpgradeType != nil {
		objectMap["UpgradeType"] = ause.UpgradeType
	}
	if ause.RollingUpgradeMode != nil {
		objectMap["RollingUpgradeMode"] = ause.RollingUpgradeMode
	}
	if ause.FailureAction != nil {
		objectMap["FailureAction"] = ause.FailureAction
	}
	if ause.ApplicationID != nil {
		objectMap["ApplicationId"] = ause.ApplicationID
	}
	if ause.EventInstanceID != nil {
		objectMap["EventInstanceId"] = ause.EventInstanceID
	}
	if ause.TimeStamp != nil {
		objectMap["TimeStamp"] = ause.TimeStamp
	}
	if ause.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = ause.HasCorrelatedEvents
	}
	if ause.Kind != "" {
		objectMap["Kind"] = ause.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return &ause, true
}

// AsClusterEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return nil, false
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsApplicationHealthReportCreatedEvent() (*ApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompleteEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsApplicationUpgradeCompleteEvent() (*ApplicationUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsApplicationUpgradeDomainCompleteEvent() (*ApplicationUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsApplicationUpgradeRollbackCompleteEvent() (*ApplicationUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsApplicationUpgradeRollbackStartEvent() (*ApplicationUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsApplicationUpgradeStartEvent() (*ApplicationUpgradeStartEvent, bool) {
	return &ause, true
}

// AsDeployedApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsDeployedApplicationHealthReportCreatedEvent() (*DeployedApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsProcessDeactivatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsProcessDeactivatedEvent() (*ProcessDeactivatedEvent, bool) {
	return nil, false
}

// AsContainerDeactivatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsContainerDeactivatedEvent() (*ContainerDeactivatedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAbortingEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsNodeAbortingEvent() (*NodeAbortingEvent, bool) {
	return nil, false
}

// AsNodeAddedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsNodeAddedEvent() (*NodeAddedEvent, bool) {
	return nil, false
}

// AsNodeCloseEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsNodeCloseEvent() (*NodeCloseEvent, bool) {
	return nil, false
}

// AsNodeClosingEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsNodeClosingEvent() (*NodeClosingEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompleteEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsNodeDeactivateCompleteEvent() (*NodeDeactivateCompleteEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsNodeDeactivateStartEvent() (*NodeDeactivateStartEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsNodeHealthReportCreatedEvent() (*NodeHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenedSuccessEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsNodeOpenedSuccessEvent() (*NodeOpenedSuccessEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeOpeningEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsNodeOpeningEvent() (*NodeOpeningEvent, bool) {
	return nil, false
}

// AsNodeRemovedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsNodeRemovedEvent() (*NodeRemovedEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsPartitionHealthReportCreatedEvent() (*PartitionHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfigurationCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsPartitionReconfigurationCompletedEvent() (*PartitionReconfigurationCompletedEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsServiceHealthReportCreatedEvent() (*ServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsDeployedServiceHealthReportCreatedEvent() (*DeployedServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsDeployedServiceHealthReportExpiredEvent() (*DeployedServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsStatefulReplicaHealthReportCreatedEvent() (*StatefulReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsStatelessReplicaHealthReportCreatedEvent() (*StatelessReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterHealthReportCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsClusterHealthReportCreatedEvent() (*ClusterHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompleteEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsClusterUpgradeCompleteEvent() (*ClusterUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsClusterUpgradeDomainCompleteEvent() (*ClusterUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsClusterUpgradeRollbackCompleteEvent() (*ClusterUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsClusterUpgradeRollbackStartEvent() (*ClusterUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsClusterUpgradeStartEvent() (*ClusterUpgradeStartEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsChaosRestartNodeFaultCompletedEvent() (*ChaosRestartNodeFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsChaosRestartCodePackageFaultScheduledEvent() (*ChaosRestartCodePackageFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsChaosRestartCodePackageFaultCompletedEvent() (*ChaosRestartCodePackageFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsChaosRemoveReplicaFaultScheduledEvent() (*ChaosRemoveReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsChaosRemoveReplicaFaultCompletedEvent() (*ChaosRemoveReplicaFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosMoveSecondaryFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsChaosMoveSecondaryFaultScheduledEvent() (*ChaosMoveSecondaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosMovePrimaryFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsChaosMovePrimaryFaultScheduledEvent() (*ChaosMovePrimaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsChaosRestartReplicaFaultScheduledEvent() (*ChaosRestartReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsChaosRestartNodeFaultScheduledEvent() (*ChaosRestartNodeFaultScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartEvent.
func (ause ApplicationUpgradeStartEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &ause, true
}

// ApplicationUpgradeUpdateDescription describes the parameters for updating an ongoing application
// upgrade.
type ApplicationUpgradeUpdateDescription struct {
	// Name - The name of the application, including the 'fabric:' URI scheme.
	Name *string `json:"Name,omitempty"`
	// UpgradeKind - The kind of upgrade out of the following possible values. Possible values include: 'UpgradeKindInvalid', 'UpgradeKindRolling'
	UpgradeKind UpgradeKind `json:"UpgradeKind,omitempty"`
	// ApplicationHealthPolicy - Defines a health policy used to evaluate the health of an application or one of its children entities.
	ApplicationHealthPolicy *ApplicationHealthPolicy `json:"ApplicationHealthPolicy,omitempty"`
	// UpdateDescription - Describes the parameters for updating a rolling upgrade of application or cluster.
	UpdateDescription *RollingUpgradeUpdateDescription `json:"UpdateDescription,omitempty"`
}

// AveragePartitionLoadScalingTrigger represents a scaling trigger related to an average load of a
// metric/resource of a partition.
type AveragePartitionLoadScalingTrigger struct {
	// MetricName - The name of the metric for which usage should be tracked.
	MetricName *string `json:"MetricName,omitempty"`
	// LowerLoadThreshold - The lower limit of the load below which a scale in operation should be performed.
	LowerLoadThreshold *string `json:"LowerLoadThreshold,omitempty"`
	// UpperLoadThreshold - The upper limit of the load beyond which a scale out operation should be performed.
	UpperLoadThreshold *string `json:"UpperLoadThreshold,omitempty"`
	// ScaleIntervalInSeconds - The period in seconds on which a decision is made whether to scale or not.
	ScaleIntervalInSeconds *int64 `json:"ScaleIntervalInSeconds,omitempty"`
	// Kind - Possible values include: 'KindScalingTriggerDescription', 'KindAveragePartitionLoad', 'KindAverageServiceLoad'
	Kind KindBasicScalingTriggerDescription `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AveragePartitionLoadScalingTrigger.
func (aplst AveragePartitionLoadScalingTrigger) MarshalJSON() ([]byte, error) {
	aplst.Kind = KindAveragePartitionLoad
	objectMap := make(map[string]interface{})
	if aplst.MetricName != nil {
		objectMap["MetricName"] = aplst.MetricName
	}
	if aplst.LowerLoadThreshold != nil {
		objectMap["LowerLoadThreshold"] = aplst.LowerLoadThreshold
	}
	if aplst.UpperLoadThreshold != nil {
		objectMap["UpperLoadThreshold"] = aplst.UpperLoadThreshold
	}
	if aplst.ScaleIntervalInSeconds != nil {
		objectMap["ScaleIntervalInSeconds"] = aplst.ScaleIntervalInSeconds
	}
	if aplst.Kind != "" {
		objectMap["Kind"] = aplst.Kind
	}
	return json.Marshal(objectMap)
}

// AsAveragePartitionLoadScalingTrigger is the BasicScalingTriggerDescription implementation for AveragePartitionLoadScalingTrigger.
func (aplst AveragePartitionLoadScalingTrigger) AsAveragePartitionLoadScalingTrigger() (*AveragePartitionLoadScalingTrigger, bool) {
	return &aplst, true
}

// AsAverageServiceLoadScalingTrigger is the BasicScalingTriggerDescription implementation for AveragePartitionLoadScalingTrigger.
func (aplst AveragePartitionLoadScalingTrigger) AsAverageServiceLoadScalingTrigger() (*AverageServiceLoadScalingTrigger, bool) {
	return nil, false
}

// AsScalingTriggerDescription is the BasicScalingTriggerDescription implementation for AveragePartitionLoadScalingTrigger.
func (aplst AveragePartitionLoadScalingTrigger) AsScalingTriggerDescription() (*ScalingTriggerDescription, bool) {
	return nil, false
}

// AsBasicScalingTriggerDescription is the BasicScalingTriggerDescription implementation for AveragePartitionLoadScalingTrigger.
func (aplst AveragePartitionLoadScalingTrigger) AsBasicScalingTriggerDescription() (BasicScalingTriggerDescription, bool) {
	return &aplst, true
}

// AverageServiceLoadScalingTrigger represents a scaling policy related to an average load of a
// metric/resource of a service.
type AverageServiceLoadScalingTrigger struct {
	// MetricName - The name of the metric for which usage should be tracked.
	MetricName *string `json:"MetricName,omitempty"`
	// LowerLoadThreshold - The lower limit of the load below which a scale in operation should be performed.
	LowerLoadThreshold *string `json:"LowerLoadThreshold,omitempty"`
	// UpperLoadThreshold - The upper limit of the load beyond which a scale out operation should be performed.
	UpperLoadThreshold *string `json:"UpperLoadThreshold,omitempty"`
	// ScaleIntervalInSeconds - The period in seconds on which a decision is made whether to scale or not.
	ScaleIntervalInSeconds *int64 `json:"ScaleIntervalInSeconds,omitempty"`
	// Kind - Possible values include: 'KindScalingTriggerDescription', 'KindAveragePartitionLoad', 'KindAverageServiceLoad'
	Kind KindBasicScalingTriggerDescription `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AverageServiceLoadScalingTrigger.
func (aslst AverageServiceLoadScalingTrigger) MarshalJSON() ([]byte, error) {
	aslst.Kind = KindAverageServiceLoad
	objectMap := make(map[string]interface{})
	if aslst.MetricName != nil {
		objectMap["MetricName"] = aslst.MetricName
	}
	if aslst.LowerLoadThreshold != nil {
		objectMap["LowerLoadThreshold"] = aslst.LowerLoadThreshold
	}
	if aslst.UpperLoadThreshold != nil {
		objectMap["UpperLoadThreshold"] = aslst.UpperLoadThreshold
	}
	if aslst.ScaleIntervalInSeconds != nil {
		objectMap["ScaleIntervalInSeconds"] = aslst.ScaleIntervalInSeconds
	}
	if aslst.Kind != "" {
		objectMap["Kind"] = aslst.Kind
	}
	return json.Marshal(objectMap)
}

// AsAveragePartitionLoadScalingTrigger is the BasicScalingTriggerDescription implementation for AverageServiceLoadScalingTrigger.
func (aslst AverageServiceLoadScalingTrigger) AsAveragePartitionLoadScalingTrigger() (*AveragePartitionLoadScalingTrigger, bool) {
	return nil, false
}

// AsAverageServiceLoadScalingTrigger is the BasicScalingTriggerDescription implementation for AverageServiceLoadScalingTrigger.
func (aslst AverageServiceLoadScalingTrigger) AsAverageServiceLoadScalingTrigger() (*AverageServiceLoadScalingTrigger, bool) {
	return &aslst, true
}

// AsScalingTriggerDescription is the BasicScalingTriggerDescription implementation for AverageServiceLoadScalingTrigger.
func (aslst AverageServiceLoadScalingTrigger) AsScalingTriggerDescription() (*ScalingTriggerDescription, bool) {
	return nil, false
}

// AsBasicScalingTriggerDescription is the BasicScalingTriggerDescription implementation for AverageServiceLoadScalingTrigger.
func (aslst AverageServiceLoadScalingTrigger) AsBasicScalingTriggerDescription() (BasicScalingTriggerDescription, bool) {
	return &aslst, true
}

// AzureBlobBackupStorageDescription describes the parameters for Azure blob store used for storing and
// enumerating backups.
type AzureBlobBackupStorageDescription struct {
	// ConnectionString - The connection string to connect to the Azure blob store.
	ConnectionString *string `json:"ConnectionString,omitempty"`
	// ContainerName - The name of the container in the blob store to store and enumerate backups from.
	ContainerName *string `json:"ContainerName,omitempty"`
	// FriendlyName - Friendly name for this backup storage.
	FriendlyName *string `json:"FriendlyName,omitempty"`
	// StorageKind - Possible values include: 'StorageKindBackupStorageDescription', 'StorageKindAzureBlobStore', 'StorageKindFileShare'
	StorageKind StorageKind `json:"StorageKind,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBlobBackupStorageDescription.
func (abbsd AzureBlobBackupStorageDescription) MarshalJSON() ([]byte, error) {
	abbsd.StorageKind = StorageKindAzureBlobStore
	objectMap := make(map[string]interface{})
	if abbsd.ConnectionString != nil {
		objectMap["ConnectionString"] = abbsd.ConnectionString
	}
	if abbsd.ContainerName != nil {
		objectMap["ContainerName"] = abbsd.ContainerName
	}
	if abbsd.FriendlyName != nil {
		objectMap["FriendlyName"] = abbsd.FriendlyName
	}
	if abbsd.StorageKind != "" {
		objectMap["StorageKind"] = abbsd.StorageKind
	}
	return json.Marshal(objectMap)
}

// AsAzureBlobBackupStorageDescription is the BasicBackupStorageDescription implementation for AzureBlobBackupStorageDescription.
func (abbsd AzureBlobBackupStorageDescription) AsAzureBlobBackupStorageDescription() (*AzureBlobBackupStorageDescription, bool) {
	return &abbsd, true
}

// AsFileShareBackupStorageDescription is the BasicBackupStorageDescription implementation for AzureBlobBackupStorageDescription.
func (abbsd AzureBlobBackupStorageDescription) AsFileShareBackupStorageDescription() (*FileShareBackupStorageDescription, bool) {
	return nil, false
}

// AsBackupStorageDescription is the BasicBackupStorageDescription implementation for AzureBlobBackupStorageDescription.
func (abbsd AzureBlobBackupStorageDescription) AsBackupStorageDescription() (*BackupStorageDescription, bool) {
	return nil, false
}

// AsBasicBackupStorageDescription is the BasicBackupStorageDescription implementation for AzureBlobBackupStorageDescription.
func (abbsd AzureBlobBackupStorageDescription) AsBasicBackupStorageDescription() (BasicBackupStorageDescription, bool) {
	return &abbsd, true
}

// BasicBackupConfigurationInfo describes the backup configuration information.
type BasicBackupConfigurationInfo interface {
	AsApplicationBackupConfigurationInfo() (*ApplicationBackupConfigurationInfo, bool)
	AsServiceBackupConfigurationInfo() (*ServiceBackupConfigurationInfo, bool)
	AsPartitionBackupConfigurationInfo() (*PartitionBackupConfigurationInfo, bool)
	AsBackupConfigurationInfo() (*BackupConfigurationInfo, bool)
}

// BackupConfigurationInfo describes the backup configuration information.
type BackupConfigurationInfo struct {
	// PolicyName - The name of the backup policy which is applicable to this Service Fabric application or service or partition.
	PolicyName *string `json:"PolicyName,omitempty"`
	// PolicyInheritedFrom - Specifies the scope at which the backup policy is applied. Possible values include: 'BackupPolicyScopeInvalid', 'BackupPolicyScopePartition', 'BackupPolicyScopeService', 'BackupPolicyScopeApplication'
	PolicyInheritedFrom BackupPolicyScope `json:"PolicyInheritedFrom,omitempty"`
	// SuspensionInfo - Describes the backup suspension details.
	SuspensionInfo *BackupSuspensionInfo `json:"SuspensionInfo,omitempty"`
	// Kind - Possible values include: 'KindBasicBackupConfigurationInfoKindBackupConfigurationInfo', 'KindBasicBackupConfigurationInfoKindApplication', 'KindBasicBackupConfigurationInfoKindService', 'KindBasicBackupConfigurationInfoKindPartition'
	Kind KindBasicBackupConfigurationInfo `json:"Kind,omitempty"`
}

func unmarshalBasicBackupConfigurationInfo(body []byte) (BasicBackupConfigurationInfo, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["Kind"] {
	case string(KindBasicBackupConfigurationInfoKindApplication):
		var abci ApplicationBackupConfigurationInfo
		err := json.Unmarshal(body, &abci)
		return abci, err
	case string(KindBasicBackupConfigurationInfoKindService):
		var sbci ServiceBackupConfigurationInfo
		err := json.Unmarshal(body, &sbci)
		return sbci, err
	case string(KindBasicBackupConfigurationInfoKindPartition):
		var pbci PartitionBackupConfigurationInfo
		err := json.Unmarshal(body, &pbci)
		return pbci, err
	default:
		var bci BackupConfigurationInfo
		err := json.Unmarshal(body, &bci)
		return bci, err
	}
}
func unmarshalBasicBackupConfigurationInfoArray(body []byte) ([]BasicBackupConfigurationInfo, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	bciArray := make([]BasicBackupConfigurationInfo, len(rawMessages))

	for index, rawMessage := range rawMessages {
		bci, err := unmarshalBasicBackupConfigurationInfo(*rawMessage)
		if err != nil {
			return nil, err
		}
		bciArray[index] = bci
	}
	return bciArray, nil
}

// MarshalJSON is the custom marshaler for BackupConfigurationInfo.
func (bci BackupConfigurationInfo) MarshalJSON() ([]byte, error) {
	bci.Kind = KindBasicBackupConfigurationInfoKindBackupConfigurationInfo
	objectMap := make(map[string]interface{})
	if bci.PolicyName != nil {
		objectMap["PolicyName"] = bci.PolicyName
	}
	if bci.PolicyInheritedFrom != "" {
		objectMap["PolicyInheritedFrom"] = bci.PolicyInheritedFrom
	}
	if bci.SuspensionInfo != nil {
		objectMap["SuspensionInfo"] = bci.SuspensionInfo
	}
	if bci.Kind != "" {
		objectMap["Kind"] = bci.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationBackupConfigurationInfo is the BasicBackupConfigurationInfo implementation for BackupConfigurationInfo.
func (bci BackupConfigurationInfo) AsApplicationBackupConfigurationInfo() (*ApplicationBackupConfigurationInfo, bool) {
	return nil, false
}

// AsServiceBackupConfigurationInfo is the BasicBackupConfigurationInfo implementation for BackupConfigurationInfo.
func (bci BackupConfigurationInfo) AsServiceBackupConfigurationInfo() (*ServiceBackupConfigurationInfo, bool) {
	return nil, false
}

// AsPartitionBackupConfigurationInfo is the BasicBackupConfigurationInfo implementation for BackupConfigurationInfo.
func (bci BackupConfigurationInfo) AsPartitionBackupConfigurationInfo() (*PartitionBackupConfigurationInfo, bool) {
	return nil, false
}

// AsBackupConfigurationInfo is the BasicBackupConfigurationInfo implementation for BackupConfigurationInfo.
func (bci BackupConfigurationInfo) AsBackupConfigurationInfo() (*BackupConfigurationInfo, bool) {
	return &bci, true
}

// AsBasicBackupConfigurationInfo is the BasicBackupConfigurationInfo implementation for BackupConfigurationInfo.
func (bci BackupConfigurationInfo) AsBasicBackupConfigurationInfo() (BasicBackupConfigurationInfo, bool) {
	return &bci, true
}

// BasicBackupEntity describes the Service Fabric entity that is configured for backup.
type BasicBackupEntity interface {
	AsApplicationBackupEntity() (*ApplicationBackupEntity, bool)
	AsServiceBackupEntity() (*ServiceBackupEntity, bool)
	AsPartitionBackupEntity() (*PartitionBackupEntity, bool)
	AsBackupEntity() (*BackupEntity, bool)
}

// BackupEntity describes the Service Fabric entity that is configured for backup.
type BackupEntity struct {
	// EntityKind - Possible values include: 'EntityKindBackupEntity', 'EntityKindApplication1', 'EntityKindService1', 'EntityKindPartition1'
	EntityKind EntityKindBasicBackupEntity `json:"EntityKind,omitempty"`
}

func unmarshalBasicBackupEntity(body []byte) (BasicBackupEntity, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["EntityKind"] {
	case string(EntityKindApplication1):
		var abe ApplicationBackupEntity
		err := json.Unmarshal(body, &abe)
		return abe, err
	case string(EntityKindService1):
		var sbe ServiceBackupEntity
		err := json.Unmarshal(body, &sbe)
		return sbe, err
	case string(EntityKindPartition1):
		var pbe PartitionBackupEntity
		err := json.Unmarshal(body, &pbe)
		return pbe, err
	default:
		var be BackupEntity
		err := json.Unmarshal(body, &be)
		return be, err
	}
}
func unmarshalBasicBackupEntityArray(body []byte) ([]BasicBackupEntity, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	beArray := make([]BasicBackupEntity, len(rawMessages))

	for index, rawMessage := range rawMessages {
		be, err := unmarshalBasicBackupEntity(*rawMessage)
		if err != nil {
			return nil, err
		}
		beArray[index] = be
	}
	return beArray, nil
}

// MarshalJSON is the custom marshaler for BackupEntity.
func (be BackupEntity) MarshalJSON() ([]byte, error) {
	be.EntityKind = EntityKindBackupEntity
	objectMap := make(map[string]interface{})
	if be.EntityKind != "" {
		objectMap["EntityKind"] = be.EntityKind
	}
	return json.Marshal(objectMap)
}

// AsApplicationBackupEntity is the BasicBackupEntity implementation for BackupEntity.
func (be BackupEntity) AsApplicationBackupEntity() (*ApplicationBackupEntity, bool) {
	return nil, false
}

// AsServiceBackupEntity is the BasicBackupEntity implementation for BackupEntity.
func (be BackupEntity) AsServiceBackupEntity() (*ServiceBackupEntity, bool) {
	return nil, false
}

// AsPartitionBackupEntity is the BasicBackupEntity implementation for BackupEntity.
func (be BackupEntity) AsPartitionBackupEntity() (*PartitionBackupEntity, bool) {
	return nil, false
}

// AsBackupEntity is the BasicBackupEntity implementation for BackupEntity.
func (be BackupEntity) AsBackupEntity() (*BackupEntity, bool) {
	return &be, true
}

// AsBasicBackupEntity is the BasicBackupEntity implementation for BackupEntity.
func (be BackupEntity) AsBasicBackupEntity() (BasicBackupEntity, bool) {
	return &be, true
}

// BackupEpoch an Epoch is a configuration number for the partition as a whole. When the configuration of
// the replica set changes, for example when the Primary replica changes, the operations that are
// replicated from the new Primary replica are said to be a new Epoch from the ones which were sent by the
// old Primary replica.
type BackupEpoch struct {
	// ConfigurationNumber - The current configuration number of this Epoch. The configuration number is an increasing value that is updated whenever the configuration of this replica set changes.
	ConfigurationNumber *string `json:"ConfigurationNumber,omitempty"`
	// DataLossNumber - The current data loss number of this Epoch. The data loss number property is an increasing value which is updated whenever data loss is suspected, as when loss of a quorum of replicas in the replica set that includes the Primary replica.
	DataLossNumber *string `json:"DataLossNumber,omitempty"`
}

// BackupInfo represents a backup point which can be used to trigger a restore.
type BackupInfo struct {
	// BackupID - Unique backup ID .
	BackupID *uuid.UUID `json:"BackupId,omitempty"`
	// BackupChainID - Unique backup chain ID. All backups part of the same chain has the same backup chain id. A backup chain is comprised of 1 full backup and multiple incremental backups.
	BackupChainID *uuid.UUID `json:"BackupChainId,omitempty"`
	// ApplicationName - Name of the Service Fabric application this partition backup belongs to.
	ApplicationName *string `json:"ApplicationName,omitempty"`
	// ServiceName - Name of the Service Fabric service this partition backup belongs to.
	ServiceName *string `json:"ServiceName,omitempty"`
	// PartitionInformation - Information about the partition to which this backup belongs to
	PartitionInformation BasicPartitionInformation `json:"PartitionInformation,omitempty"`
	// BackupLocation - Location of the backup, relative to the backup store.
	BackupLocation *string `json:"BackupLocation,omitempty"`
	// BackupType - Describes the type of backup, whether its full or incremental. Possible values include: 'BackupTypeInvalid', 'BackupTypeFull', 'BackupTypeIncremental'
	BackupType BackupType `json:"BackupType,omitempty"`
	// EpochOfLastBackupRecord - Epoch of the last record in this backup.
	EpochOfLastBackupRecord *BackupEpoch `json:"EpochOfLastBackupRecord,omitempty"`
	// LsnOfLastBackupRecord - LSN of the last record in this backup.
	LsnOfLastBackupRecord *string `json:"LsnOfLastBackupRecord,omitempty"`
	// CreationTimeUtc - The date time when this backup was taken.
	CreationTimeUtc *date.Time `json:"CreationTimeUtc,omitempty"`
	// FailureError - Denotes the failure encountered in getting backup point information.
	FailureError *FabricErrorError `json:"FailureError,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for BackupInfo struct.
func (bi *BackupInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "BackupId":
			if v != nil {
				var backupID uuid.UUID
				err = json.Unmarshal(*v, &backupID)
				if err != nil {
					return err
				}
				bi.BackupID = &backupID
			}
		case "BackupChainId":
			if v != nil {
				var backupChainID uuid.UUID
				err = json.Unmarshal(*v, &backupChainID)
				if err != nil {
					return err
				}
				bi.BackupChainID = &backupChainID
			}
		case "ApplicationName":
			if v != nil {
				var applicationName string
				err = json.Unmarshal(*v, &applicationName)
				if err != nil {
					return err
				}
				bi.ApplicationName = &applicationName
			}
		case "ServiceName":
			if v != nil {
				var serviceName string
				err = json.Unmarshal(*v, &serviceName)
				if err != nil {
					return err
				}
				bi.ServiceName = &serviceName
			}
		case "PartitionInformation":
			if v != nil {
				partitionInformation, err := unmarshalBasicPartitionInformation(*v)
				if err != nil {
					return err
				}
				bi.PartitionInformation = partitionInformation
			}
		case "BackupLocation":
			if v != nil {
				var backupLocation string
				err = json.Unmarshal(*v, &backupLocation)
				if err != nil {
					return err
				}
				bi.BackupLocation = &backupLocation
			}
		case "BackupType":
			if v != nil {
				var backupType BackupType
				err = json.Unmarshal(*v, &backupType)
				if err != nil {
					return err
				}
				bi.BackupType = backupType
			}
		case "EpochOfLastBackupRecord":
			if v != nil {
				var epochOfLastBackupRecord BackupEpoch
				err = json.Unmarshal(*v, &epochOfLastBackupRecord)
				if err != nil {
					return err
				}
				bi.EpochOfLastBackupRecord = &epochOfLastBackupRecord
			}
		case "LsnOfLastBackupRecord":
			if v != nil {
				var lsnOfLastBackupRecord string
				err = json.Unmarshal(*v, &lsnOfLastBackupRecord)
				if err != nil {
					return err
				}
				bi.LsnOfLastBackupRecord = &lsnOfLastBackupRecord
			}
		case "CreationTimeUtc":
			if v != nil {
				var creationTimeUtc date.Time
				err = json.Unmarshal(*v, &creationTimeUtc)
				if err != nil {
					return err
				}
				bi.CreationTimeUtc = &creationTimeUtc
			}
		case "FailureError":
			if v != nil {
				var failureError FabricErrorError
				err = json.Unmarshal(*v, &failureError)
				if err != nil {
					return err
				}
				bi.FailureError = &failureError
			}
		}
	}

	return nil
}

// BackupPartitionDescription describes the parameters for triggering partition's backup.
type BackupPartitionDescription struct {
	// BackupStorage - Specifies the details of the backup storage where to save the backup.
	BackupStorage BasicBackupStorageDescription `json:"BackupStorage,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for BackupPartitionDescription struct.
func (bpd *BackupPartitionDescription) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "BackupStorage":
			if v != nil {
				backupStorage, err := unmarshalBasicBackupStorageDescription(*v)
				if err != nil {
					return err
				}
				bpd.BackupStorage = backupStorage
			}
		}
	}

	return nil
}

// BackupPolicyDescription describes a backup policy for configuring periodic backup.
type BackupPolicyDescription struct {
	autorest.Response `json:"-"`
	// Name - The unique name identifying this backup policy.
	Name *string `json:"Name,omitempty"`
	// AutoRestoreOnDataLoss - Specifies whether to trigger restore automatically using the latest available backup in case the partition experiences a data loss event.
	AutoRestoreOnDataLoss *bool `json:"AutoRestoreOnDataLoss,omitempty"`
	// MaxIncrementalBackups - Defines the maximum number of incremental backups to be taken between two full backups. This is just the upper limit. A full backup may be taken before specified number of incremental backups are completed in one of the following conditions
	// - The replica has never taken a full backup since it has become primary,
	// - Some of the log records since the last backup has been truncated, or
	// - Replica passed the MaxAccumulatedBackupLogSizeInMB limit.
	MaxIncrementalBackups *int32 `json:"MaxIncrementalBackups,omitempty"`
	// Schedule - Describes the backup schedule parameters.
	Schedule BasicBackupScheduleDescription `json:"Schedule,omitempty"`
	// Storage - Describes the details of backup storage where to store the periodic backups.
	Storage BasicBackupStorageDescription `json:"Storage,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for BackupPolicyDescription struct.
func (bpd *BackupPolicyDescription) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "Name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bpd.Name = &name
			}
		case "AutoRestoreOnDataLoss":
			if v != nil {
				var autoRestoreOnDataLoss bool
				err = json.Unmarshal(*v, &autoRestoreOnDataLoss)
				if err != nil {
					return err
				}
				bpd.AutoRestoreOnDataLoss = &autoRestoreOnDataLoss
			}
		case "MaxIncrementalBackups":
			if v != nil {
				var maxIncrementalBackups int32
				err = json.Unmarshal(*v, &maxIncrementalBackups)
				if err != nil {
					return err
				}
				bpd.MaxIncrementalBackups = &maxIncrementalBackups
			}
		case "Schedule":
			if v != nil {
				schedule, err := unmarshalBasicBackupScheduleDescription(*v)
				if err != nil {
					return err
				}
				bpd.Schedule = schedule
			}
		case "Storage":
			if v != nil {
				storage, err := unmarshalBasicBackupStorageDescription(*v)
				if err != nil {
					return err
				}
				bpd.Storage = storage
			}
		}
	}

	return nil
}

// BackupProgressInfo describes the progress of a partition's backup.
type BackupProgressInfo struct {
	autorest.Response `json:"-"`
	// BackupState - Represents the current state of the partition backup operation. Possible values include: 'BackupStateInvalid', 'BackupStateAccepted', 'BackupStateBackupInProgress', 'BackupStateSuccess', 'BackupStateFailure', 'BackupStateTimeout'
	BackupState BackupState `json:"BackupState,omitempty"`
	// TimeStampUtc - TimeStamp in UTC when operation succeeded or failed.
	TimeStampUtc *date.Time `json:"TimeStampUtc,omitempty"`
	// BackupID - Unique ID of the newly created backup.
	BackupID *uuid.UUID `json:"BackupId,omitempty"`
	// BackupLocation - Location, relative to the backup store, of the newly created backup.
	BackupLocation *string `json:"BackupLocation,omitempty"`
	// EpochOfLastBackupRecord - Specifies the epoch of the last record included in backup.
	EpochOfLastBackupRecord *BackupEpoch `json:"EpochOfLastBackupRecord,omitempty"`
	// LsnOfLastBackupRecord - The LSN of last record included in backup.
	LsnOfLastBackupRecord *string `json:"LsnOfLastBackupRecord,omitempty"`
	// FailureError - Denotes the failure encountered in performing backup operation.
	FailureError *FabricErrorError `json:"FailureError,omitempty"`
}

// BasicBackupScheduleDescription describes the backup schedule parameters.
type BasicBackupScheduleDescription interface {
	AsFrequencyBasedBackupScheduleDescription() (*FrequencyBasedBackupScheduleDescription, bool)
	AsTimeBasedBackupScheduleDescription() (*TimeBasedBackupScheduleDescription, bool)
	AsBackupScheduleDescription() (*BackupScheduleDescription, bool)
}

// BackupScheduleDescription describes the backup schedule parameters.
type BackupScheduleDescription struct {
	// ScheduleKind - Possible values include: 'ScheduleKindBackupScheduleDescription', 'ScheduleKindFrequencyBased', 'ScheduleKindTimeBased'
	ScheduleKind ScheduleKind `json:"ScheduleKind,omitempty"`
}

func unmarshalBasicBackupScheduleDescription(body []byte) (BasicBackupScheduleDescription, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["ScheduleKind"] {
	case string(ScheduleKindFrequencyBased):
		var fbbsd FrequencyBasedBackupScheduleDescription
		err := json.Unmarshal(body, &fbbsd)
		return fbbsd, err
	case string(ScheduleKindTimeBased):
		var tbbsd TimeBasedBackupScheduleDescription
		err := json.Unmarshal(body, &tbbsd)
		return tbbsd, err
	default:
		var bsd BackupScheduleDescription
		err := json.Unmarshal(body, &bsd)
		return bsd, err
	}
}
func unmarshalBasicBackupScheduleDescriptionArray(body []byte) ([]BasicBackupScheduleDescription, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	bsdArray := make([]BasicBackupScheduleDescription, len(rawMessages))

	for index, rawMessage := range rawMessages {
		bsd, err := unmarshalBasicBackupScheduleDescription(*rawMessage)
		if err != nil {
			return nil, err
		}
		bsdArray[index] = bsd
	}
	return bsdArray, nil
}

// MarshalJSON is the custom marshaler for BackupScheduleDescription.
func (bsd BackupScheduleDescription) MarshalJSON() ([]byte, error) {
	bsd.ScheduleKind = ScheduleKindBackupScheduleDescription
	objectMap := make(map[string]interface{})
	if bsd.ScheduleKind != "" {
		objectMap["ScheduleKind"] = bsd.ScheduleKind
	}
	return json.Marshal(objectMap)
}

// AsFrequencyBasedBackupScheduleDescription is the BasicBackupScheduleDescription implementation for BackupScheduleDescription.
func (bsd BackupScheduleDescription) AsFrequencyBasedBackupScheduleDescription() (*FrequencyBasedBackupScheduleDescription, bool) {
	return nil, false
}

// AsTimeBasedBackupScheduleDescription is the BasicBackupScheduleDescription implementation for BackupScheduleDescription.
func (bsd BackupScheduleDescription) AsTimeBasedBackupScheduleDescription() (*TimeBasedBackupScheduleDescription, bool) {
	return nil, false
}

// AsBackupScheduleDescription is the BasicBackupScheduleDescription implementation for BackupScheduleDescription.
func (bsd BackupScheduleDescription) AsBackupScheduleDescription() (*BackupScheduleDescription, bool) {
	return &bsd, true
}

// AsBasicBackupScheduleDescription is the BasicBackupScheduleDescription implementation for BackupScheduleDescription.
func (bsd BackupScheduleDescription) AsBasicBackupScheduleDescription() (BasicBackupScheduleDescription, bool) {
	return &bsd, true
}

// BasicBackupStorageDescription describes the parameters for the backup storage.
type BasicBackupStorageDescription interface {
	AsAzureBlobBackupStorageDescription() (*AzureBlobBackupStorageDescription, bool)
	AsFileShareBackupStorageDescription() (*FileShareBackupStorageDescription, bool)
	AsBackupStorageDescription() (*BackupStorageDescription, bool)
}

// BackupStorageDescription describes the parameters for the backup storage.
type BackupStorageDescription struct {
	// FriendlyName - Friendly name for this backup storage.
	FriendlyName *string `json:"FriendlyName,omitempty"`
	// StorageKind - Possible values include: 'StorageKindBackupStorageDescription', 'StorageKindAzureBlobStore', 'StorageKindFileShare'
	StorageKind StorageKind `json:"StorageKind,omitempty"`
}

func unmarshalBasicBackupStorageDescription(body []byte) (BasicBackupStorageDescription, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["StorageKind"] {
	case string(StorageKindAzureBlobStore):
		var abbsd AzureBlobBackupStorageDescription
		err := json.Unmarshal(body, &abbsd)
		return abbsd, err
	case string(StorageKindFileShare):
		var fsbsd FileShareBackupStorageDescription
		err := json.Unmarshal(body, &fsbsd)
		return fsbsd, err
	default:
		var bsd BackupStorageDescription
		err := json.Unmarshal(body, &bsd)
		return bsd, err
	}
}
func unmarshalBasicBackupStorageDescriptionArray(body []byte) ([]BasicBackupStorageDescription, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	bsdArray := make([]BasicBackupStorageDescription, len(rawMessages))

	for index, rawMessage := range rawMessages {
		bsd, err := unmarshalBasicBackupStorageDescription(*rawMessage)
		if err != nil {
			return nil, err
		}
		bsdArray[index] = bsd
	}
	return bsdArray, nil
}

// MarshalJSON is the custom marshaler for BackupStorageDescription.
func (bsd BackupStorageDescription) MarshalJSON() ([]byte, error) {
	bsd.StorageKind = StorageKindBackupStorageDescription
	objectMap := make(map[string]interface{})
	if bsd.FriendlyName != nil {
		objectMap["FriendlyName"] = bsd.FriendlyName
	}
	if bsd.StorageKind != "" {
		objectMap["StorageKind"] = bsd.StorageKind
	}
	return json.Marshal(objectMap)
}

// AsAzureBlobBackupStorageDescription is the BasicBackupStorageDescription implementation for BackupStorageDescription.
func (bsd BackupStorageDescription) AsAzureBlobBackupStorageDescription() (*AzureBlobBackupStorageDescription, bool) {
	return nil, false
}

// AsFileShareBackupStorageDescription is the BasicBackupStorageDescription implementation for BackupStorageDescription.
func (bsd BackupStorageDescription) AsFileShareBackupStorageDescription() (*FileShareBackupStorageDescription, bool) {
	return nil, false
}

// AsBackupStorageDescription is the BasicBackupStorageDescription implementation for BackupStorageDescription.
func (bsd BackupStorageDescription) AsBackupStorageDescription() (*BackupStorageDescription, bool) {
	return &bsd, true
}

// AsBasicBackupStorageDescription is the BasicBackupStorageDescription implementation for BackupStorageDescription.
func (bsd BackupStorageDescription) AsBasicBackupStorageDescription() (BasicBackupStorageDescription, bool) {
	return &bsd, true
}

// BackupSuspensionInfo describes the backup suspension details.
type BackupSuspensionInfo struct {
	// IsSuspended - Indicates whether periodic backup is suspended at this level or not.
	IsSuspended *bool `json:"IsSuspended,omitempty"`
	// SuspensionInheritedFrom - Specifies the scope at which the backup suspension was applied. Possible values include: 'BackupSuspensionScopeInvalid', 'BackupSuspensionScopePartition', 'BackupSuspensionScopeService', 'BackupSuspensionScopeApplication'
	SuspensionInheritedFrom BackupSuspensionScope `json:"SuspensionInheritedFrom,omitempty"`
}

// BinaryPropertyValue describes a Service Fabric property value of type Binary.
type BinaryPropertyValue struct {
	// Data - Array of bytes to be sent as an integer array. Each element of array is a number between 0 and 255.
	Data *[]int32 `json:"Data,omitempty"`
	// Kind - Possible values include: 'KindPropertyValue', 'KindBinary', 'KindInt64', 'KindDouble', 'KindString', 'KindGUID'
	Kind KindBasicPropertyValue `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for BinaryPropertyValue.
func (bpv BinaryPropertyValue) MarshalJSON() ([]byte, error) {
	bpv.Kind = KindBinary
	objectMap := make(map[string]interface{})
	if bpv.Data != nil {
		objectMap["Data"] = bpv.Data
	}
	if bpv.Kind != "" {
		objectMap["Kind"] = bpv.Kind
	}
	return json.Marshal(objectMap)
}

// AsBinaryPropertyValue is the BasicPropertyValue implementation for BinaryPropertyValue.
func (bpv BinaryPropertyValue) AsBinaryPropertyValue() (*BinaryPropertyValue, bool) {
	return &bpv, true
}

// AsInt64PropertyValue is the BasicPropertyValue implementation for BinaryPropertyValue.
func (bpv BinaryPropertyValue) AsInt64PropertyValue() (*Int64PropertyValue, bool) {
	return nil, false
}

// AsDoublePropertyValue is the BasicPropertyValue implementation for BinaryPropertyValue.
func (bpv BinaryPropertyValue) AsDoublePropertyValue() (*DoublePropertyValue, bool) {
	return nil, false
}

// AsStringPropertyValue is the BasicPropertyValue implementation for BinaryPropertyValue.
func (bpv BinaryPropertyValue) AsStringPropertyValue() (*StringPropertyValue, bool) {
	return nil, false
}

// AsGUIDPropertyValue is the BasicPropertyValue implementation for BinaryPropertyValue.
func (bpv BinaryPropertyValue) AsGUIDPropertyValue() (*GUIDPropertyValue, bool) {
	return nil, false
}

// AsPropertyValue is the BasicPropertyValue implementation for BinaryPropertyValue.
func (bpv BinaryPropertyValue) AsPropertyValue() (*PropertyValue, bool) {
	return nil, false
}

// AsBasicPropertyValue is the BasicPropertyValue implementation for BinaryPropertyValue.
func (bpv BinaryPropertyValue) AsBasicPropertyValue() (BasicPropertyValue, bool) {
	return &bpv, true
}

// Chaos contains a description of Chaos.
type Chaos struct {
	autorest.Response `json:"-"`
	// ChaosParameters - If Chaos is running, these are the parameters Chaos is running with.
	ChaosParameters *ChaosParameters `json:"ChaosParameters,omitempty"`
	// Status - Current status of the Chaos run. Possible values include: 'ChaosStatusInvalid', 'ChaosStatusRunning', 'ChaosStatusStopped'
	Status ChaosStatus `json:"Status,omitempty"`
	// ScheduleStatus - Current status of the schedule. Possible values include: 'ChaosScheduleStatusInvalid', 'ChaosScheduleStatusStopped', 'ChaosScheduleStatusActive', 'ChaosScheduleStatusExpired', 'ChaosScheduleStatusPending'
	ScheduleStatus ChaosScheduleStatus `json:"ScheduleStatus,omitempty"`
}

// ChaosContext describes a map, which is a collection of (string, string) type key-value pairs. The map
// can be used to record information about
// the Chaos run. There cannot be more than 100 such pairs and each string (key or value) can be at most
// 4095 characters long.
// This map is set by the starter of the Chaos run to optionally store the context about the specific run.
type ChaosContext struct {
	// Map - Describes a map that contains a collection of ChaosContextMapItem's.
	Map map[string]*string `json:"Map"`
}

// MarshalJSON is the custom marshaler for ChaosContext.
func (cc ChaosContext) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cc.Map != nil {
		objectMap["Map"] = cc.Map
	}
	return json.Marshal(objectMap)
}

// BasicChaosEvent represents an event generated during a Chaos run.
type BasicChaosEvent interface {
	AsExecutingFaultsChaosEvent() (*ExecutingFaultsChaosEvent, bool)
	AsStartedChaosEvent() (*StartedChaosEvent, bool)
	AsStoppedChaosEvent() (*StoppedChaosEvent, bool)
	AsTestErrorChaosEvent() (*TestErrorChaosEvent, bool)
	AsValidationFailedChaosEvent() (*ValidationFailedChaosEvent, bool)
	AsWaitingChaosEvent() (*WaitingChaosEvent, bool)
	AsChaosEvent() (*ChaosEvent, bool)
}

// ChaosEvent represents an event generated during a Chaos run.
type ChaosEvent struct {
	// TimeStampUtc - The UTC timestamp when this Chaos event was generated.
	TimeStampUtc *date.Time `json:"TimeStampUtc,omitempty"`
	// Kind - Possible values include: 'KindChaosEvent', 'KindExecutingFaults', 'KindStarted', 'KindStopped', 'KindTestError', 'KindValidationFailed', 'KindWaiting'
	Kind KindBasicChaosEvent `json:"Kind,omitempty"`
}

func unmarshalBasicChaosEvent(body []byte) (BasicChaosEvent, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["Kind"] {
	case string(KindExecutingFaults):
		var efce ExecutingFaultsChaosEvent
		err := json.Unmarshal(body, &efce)
		return efce, err
	case string(KindStarted):
		var sce StartedChaosEvent
		err := json.Unmarshal(body, &sce)
		return sce, err
	case string(KindStopped):
		var sce StoppedChaosEvent
		err := json.Unmarshal(body, &sce)
		return sce, err
	case string(KindTestError):
		var tece TestErrorChaosEvent
		err := json.Unmarshal(body, &tece)
		return tece, err
	case string(KindValidationFailed):
		var vfce ValidationFailedChaosEvent
		err := json.Unmarshal(body, &vfce)
		return vfce, err
	case string(KindWaiting):
		var wce WaitingChaosEvent
		err := json.Unmarshal(body, &wce)
		return wce, err
	default:
		var ce ChaosEvent
		err := json.Unmarshal(body, &ce)
		return ce, err
	}
}
func unmarshalBasicChaosEventArray(body []byte) ([]BasicChaosEvent, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ceArray := make([]BasicChaosEvent, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ce, err := unmarshalBasicChaosEvent(*rawMessage)
		if err != nil {
			return nil, err
		}
		ceArray[index] = ce
	}
	return ceArray, nil
}

// MarshalJSON is the custom marshaler for ChaosEvent.
func (ce ChaosEvent) MarshalJSON() ([]byte, error) {
	ce.Kind = KindChaosEvent
	objectMap := make(map[string]interface{})
	if ce.TimeStampUtc != nil {
		objectMap["TimeStampUtc"] = ce.TimeStampUtc
	}
	if ce.Kind != "" {
		objectMap["Kind"] = ce.Kind
	}
	return json.Marshal(objectMap)
}

// AsExecutingFaultsChaosEvent is the BasicChaosEvent implementation for ChaosEvent.
func (ce ChaosEvent) AsExecutingFaultsChaosEvent() (*ExecutingFaultsChaosEvent, bool) {
	return nil, false
}

// AsStartedChaosEvent is the BasicChaosEvent implementation for ChaosEvent.
func (ce ChaosEvent) AsStartedChaosEvent() (*StartedChaosEvent, bool) {
	return nil, false
}

// AsStoppedChaosEvent is the BasicChaosEvent implementation for ChaosEvent.
func (ce ChaosEvent) AsStoppedChaosEvent() (*StoppedChaosEvent, bool) {
	return nil, false
}

// AsTestErrorChaosEvent is the BasicChaosEvent implementation for ChaosEvent.
func (ce ChaosEvent) AsTestErrorChaosEvent() (*TestErrorChaosEvent, bool) {
	return nil, false
}

// AsValidationFailedChaosEvent is the BasicChaosEvent implementation for ChaosEvent.
func (ce ChaosEvent) AsValidationFailedChaosEvent() (*ValidationFailedChaosEvent, bool) {
	return nil, false
}

// AsWaitingChaosEvent is the BasicChaosEvent implementation for ChaosEvent.
func (ce ChaosEvent) AsWaitingChaosEvent() (*WaitingChaosEvent, bool) {
	return nil, false
}

// AsChaosEvent is the BasicChaosEvent implementation for ChaosEvent.
func (ce ChaosEvent) AsChaosEvent() (*ChaosEvent, bool) {
	return &ce, true
}

// AsBasicChaosEvent is the BasicChaosEvent implementation for ChaosEvent.
func (ce ChaosEvent) AsBasicChaosEvent() (BasicChaosEvent, bool) {
	return &ce, true
}

// ChaosEventsSegment contains the list of Chaos events and the continuation token to get the next segment.
type ChaosEventsSegment struct {
	autorest.Response `json:"-"`
	// ContinuationToken - The continuation token parameter is used to obtain next set of results. The continuation token is included in the response of the API when the results from the system do not fit in a single response. When this value is passed to the next API call, the API returns next set of results. If there are no further results, then the continuation token is not included in the response.
	ContinuationToken *string `json:"ContinuationToken,omitempty"`
	// History - List of Chaos events that meet the user-supplied criteria.
	History *[]ChaosEventWrapper `json:"History,omitempty"`
}

// ChaosEventWrapper wrapper object for Chaos event.
type ChaosEventWrapper struct {
	// ChaosEvent - Represents an event generated during a Chaos run.
	ChaosEvent BasicChaosEvent `json:"ChaosEvent,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ChaosEventWrapper struct.
func (cew *ChaosEventWrapper) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "ChaosEvent":
			if v != nil {
				chaosEvent, err := unmarshalBasicChaosEvent(*v)
				if err != nil {
					return err
				}
				cew.ChaosEvent = chaosEvent
			}
		}
	}

	return nil
}

// ChaosMovePrimaryFaultScheduledEvent chaos Move Primary Fault Scheduled event.
type ChaosMovePrimaryFaultScheduledEvent struct {
	// FaultGroupID - Id of fault group.
	FaultGroupID *uuid.UUID `json:"FaultGroupId,omitempty"`
	// FaultID - Id of fault.
	FaultID *uuid.UUID `json:"FaultId,omitempty"`
	// ServiceName - Service name.
	ServiceName *string `json:"ServiceName,omitempty"`
	// NodeTo - The name of a Service Fabric node.
	NodeTo *string `json:"NodeTo,omitempty"`
	// ForcedMove - Indicates a forced move.
	ForcedMove *bool `json:"ForcedMove,omitempty"`
	// PartitionID - An internal ID used by Service Fabric to uniquely identify a partition. This is a randomly generated GUID when the service was created. The partition ID is unique and does not change for the lifetime of the service. If the same service was deleted and recreated the IDs of its partitions would be different.
	PartitionID *uuid.UUID `json:"PartitionId,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationHealthReportCreated', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeComplete', 'KindApplicationUpgradeDomainComplete', 'KindApplicationUpgradeRollbackComplete', 'KindApplicationUpgradeRollbackStart', 'KindApplicationUpgradeStart', 'KindDeployedApplicationHealthReportCreated', 'KindDeployedApplicationHealthReportExpired', 'KindProcessDeactivated', 'KindContainerDeactivated', 'KindNodeAborted', 'KindNodeAborting', 'KindNodeAdded', 'KindNodeClose', 'KindNodeClosing', 'KindNodeDeactivateComplete', 'KindNodeDeactivateStart', 'KindNodeDown', 'KindNodeHealthReportCreated', 'KindNodeHealthReportExpired', 'KindNodeOpenedSuccess', 'KindNodeOpenFailed', 'KindNodeOpening', 'KindNodeRemoved', 'KindNodeUp', 'KindPartitionHealthReportCreated', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigurationCompleted', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceHealthReportCreated', 'KindServiceHealthReportExpired', 'KindDeployedServiceHealthReportCreated', 'KindDeployedServiceHealthReportExpired', 'KindStatefulReplicaHealthReportCreated', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaHealthReportCreated', 'KindStatelessReplicaHealthReportExpired', 'KindClusterHealthReportCreated', 'KindClusterHealthReportExpired', 'KindClusterUpgradeComplete', 'KindClusterUpgradeDomainComplete', 'KindClusterUpgradeRollbackComplete', 'KindClusterUpgradeRollbackStart', 'KindClusterUpgradeStart', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosRestartNodeFaultCompleted', 'KindChaosRestartCodePackageFaultScheduled', 'KindChaosRestartCodePackageFaultCompleted', 'KindChaosRemoveReplicaFaultScheduled', 'KindChaosRemoveReplicaFaultCompleted', 'KindChaosMoveSecondaryFaultScheduled', 'KindChaosMovePrimaryFaultScheduled', 'KindChaosRestartReplicaFaultScheduled', 'KindChaosRestartNodeFaultScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) MarshalJSON() ([]byte, error) {
	cmpfse.Kind = KindChaosMovePrimaryFaultScheduled
	objectMap := make(map[string]interface{})
	if cmpfse.FaultGroupID != nil {
		objectMap["FaultGroupId"] = cmpfse.FaultGroupID
	}
	if cmpfse.FaultID != nil {
		objectMap["FaultId"] = cmpfse.FaultID
	}
	if cmpfse.ServiceName != nil {
		objectMap["ServiceName"] = cmpfse.ServiceName
	}
	if cmpfse.NodeTo != nil {
		objectMap["NodeTo"] = cmpfse.NodeTo
	}
	if cmpfse.ForcedMove != nil {
		objectMap["ForcedMove"] = cmpfse.ForcedMove
	}
	if cmpfse.PartitionID != nil {
		objectMap["PartitionId"] = cmpfse.PartitionID
	}
	if cmpfse.EventInstanceID != nil {
		objectMap["EventInstanceId"] = cmpfse.EventInstanceID
	}
	if cmpfse.TimeStamp != nil {
		objectMap["TimeStamp"] = cmpfse.TimeStamp
	}
	if cmpfse.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = cmpfse.HasCorrelatedEvents
	}
	if cmpfse.Kind != "" {
		objectMap["Kind"] = cmpfse.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return nil, false
}

// AsClusterEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return nil, false
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return &cmpfse, true
}

// AsReplicaEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsApplicationHealthReportCreatedEvent() (*ApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompleteEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsApplicationUpgradeCompleteEvent() (*ApplicationUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsApplicationUpgradeDomainCompleteEvent() (*ApplicationUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsApplicationUpgradeRollbackCompleteEvent() (*ApplicationUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsApplicationUpgradeRollbackStartEvent() (*ApplicationUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsApplicationUpgradeStartEvent() (*ApplicationUpgradeStartEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsDeployedApplicationHealthReportCreatedEvent() (*DeployedApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsProcessDeactivatedEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsProcessDeactivatedEvent() (*ProcessDeactivatedEvent, bool) {
	return nil, false
}

// AsContainerDeactivatedEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsContainerDeactivatedEvent() (*ContainerDeactivatedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAbortingEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsNodeAbortingEvent() (*NodeAbortingEvent, bool) {
	return nil, false
}

// AsNodeAddedEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsNodeAddedEvent() (*NodeAddedEvent, bool) {
	return nil, false
}

// AsNodeCloseEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsNodeCloseEvent() (*NodeCloseEvent, bool) {
	return nil, false
}

// AsNodeClosingEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsNodeClosingEvent() (*NodeClosingEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompleteEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsNodeDeactivateCompleteEvent() (*NodeDeactivateCompleteEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsNodeDeactivateStartEvent() (*NodeDeactivateStartEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsNodeHealthReportCreatedEvent() (*NodeHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenedSuccessEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsNodeOpenedSuccessEvent() (*NodeOpenedSuccessEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeOpeningEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsNodeOpeningEvent() (*NodeOpeningEvent, bool) {
	return nil, false
}

// AsNodeRemovedEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsNodeRemovedEvent() (*NodeRemovedEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsPartitionHealthReportCreatedEvent() (*PartitionHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfigurationCompletedEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsPartitionReconfigurationCompletedEvent() (*PartitionReconfigurationCompletedEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsServiceHealthReportCreatedEvent() (*ServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsDeployedServiceHealthReportCreatedEvent() (*DeployedServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsDeployedServiceHealthReportExpiredEvent() (*DeployedServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsStatefulReplicaHealthReportCreatedEvent() (*StatefulReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsStatelessReplicaHealthReportCreatedEvent() (*StatelessReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsClusterHealthReportCreatedEvent() (*ClusterHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompleteEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsClusterUpgradeCompleteEvent() (*ClusterUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsClusterUpgradeDomainCompleteEvent() (*ClusterUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsClusterUpgradeRollbackCompleteEvent() (*ClusterUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsClusterUpgradeRollbackStartEvent() (*ClusterUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsClusterUpgradeStartEvent() (*ClusterUpgradeStartEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultCompletedEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsChaosRestartNodeFaultCompletedEvent() (*ChaosRestartNodeFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultScheduledEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsChaosRestartCodePackageFaultScheduledEvent() (*ChaosRestartCodePackageFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultCompletedEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsChaosRestartCodePackageFaultCompletedEvent() (*ChaosRestartCodePackageFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsChaosRemoveReplicaFaultScheduledEvent() (*ChaosRemoveReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultCompletedEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsChaosRemoveReplicaFaultCompletedEvent() (*ChaosRemoveReplicaFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosMoveSecondaryFaultScheduledEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsChaosMoveSecondaryFaultScheduledEvent() (*ChaosMoveSecondaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosMovePrimaryFaultScheduledEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsChaosMovePrimaryFaultScheduledEvent() (*ChaosMovePrimaryFaultScheduledEvent, bool) {
	return &cmpfse, true
}

// AsChaosRestartReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsChaosRestartReplicaFaultScheduledEvent() (*ChaosRestartReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultScheduledEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsChaosRestartNodeFaultScheduledEvent() (*ChaosRestartNodeFaultScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ChaosMovePrimaryFaultScheduledEvent.
func (cmpfse ChaosMovePrimaryFaultScheduledEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &cmpfse, true
}

// ChaosMoveSecondaryFaultScheduledEvent chaos Move Secondary Fault Scheduled event.
type ChaosMoveSecondaryFaultScheduledEvent struct {
	// FaultGroupID - Id of fault group.
	FaultGroupID *uuid.UUID `json:"FaultGroupId,omitempty"`
	// FaultID - Id of fault.
	FaultID *uuid.UUID `json:"FaultId,omitempty"`
	// ServiceName - Service name.
	ServiceName *string `json:"ServiceName,omitempty"`
	// SourceNode - The name of a Service Fabric node.
	SourceNode *string `json:"SourceNode,omitempty"`
	// DestinationNode - The name of a Service Fabric node.
	DestinationNode *string `json:"DestinationNode,omitempty"`
	// ForcedMove - Indicates a forced move.
	ForcedMove *bool `json:"ForcedMove,omitempty"`
	// PartitionID - An internal ID used by Service Fabric to uniquely identify a partition. This is a randomly generated GUID when the service was created. The partition ID is unique and does not change for the lifetime of the service. If the same service was deleted and recreated the IDs of its partitions would be different.
	PartitionID *uuid.UUID `json:"PartitionId,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationHealthReportCreated', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeComplete', 'KindApplicationUpgradeDomainComplete', 'KindApplicationUpgradeRollbackComplete', 'KindApplicationUpgradeRollbackStart', 'KindApplicationUpgradeStart', 'KindDeployedApplicationHealthReportCreated', 'KindDeployedApplicationHealthReportExpired', 'KindProcessDeactivated', 'KindContainerDeactivated', 'KindNodeAborted', 'KindNodeAborting', 'KindNodeAdded', 'KindNodeClose', 'KindNodeClosing', 'KindNodeDeactivateComplete', 'KindNodeDeactivateStart', 'KindNodeDown', 'KindNodeHealthReportCreated', 'KindNodeHealthReportExpired', 'KindNodeOpenedSuccess', 'KindNodeOpenFailed', 'KindNodeOpening', 'KindNodeRemoved', 'KindNodeUp', 'KindPartitionHealthReportCreated', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigurationCompleted', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceHealthReportCreated', 'KindServiceHealthReportExpired', 'KindDeployedServiceHealthReportCreated', 'KindDeployedServiceHealthReportExpired', 'KindStatefulReplicaHealthReportCreated', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaHealthReportCreated', 'KindStatelessReplicaHealthReportExpired', 'KindClusterHealthReportCreated', 'KindClusterHealthReportExpired', 'KindClusterUpgradeComplete', 'KindClusterUpgradeDomainComplete', 'KindClusterUpgradeRollbackComplete', 'KindClusterUpgradeRollbackStart', 'KindClusterUpgradeStart', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosRestartNodeFaultCompleted', 'KindChaosRestartCodePackageFaultScheduled', 'KindChaosRestartCodePackageFaultCompleted', 'KindChaosRemoveReplicaFaultScheduled', 'KindChaosRemoveReplicaFaultCompleted', 'KindChaosMoveSecondaryFaultScheduled', 'KindChaosMovePrimaryFaultScheduled', 'KindChaosRestartReplicaFaultScheduled', 'KindChaosRestartNodeFaultScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) MarshalJSON() ([]byte, error) {
	cmsfse.Kind = KindChaosMoveSecondaryFaultScheduled
	objectMap := make(map[string]interface{})
	if cmsfse.FaultGroupID != nil {
		objectMap["FaultGroupId"] = cmsfse.FaultGroupID
	}
	if cmsfse.FaultID != nil {
		objectMap["FaultId"] = cmsfse.FaultID
	}
	if cmsfse.ServiceName != nil {
		objectMap["ServiceName"] = cmsfse.ServiceName
	}
	if cmsfse.SourceNode != nil {
		objectMap["SourceNode"] = cmsfse.SourceNode
	}
	if cmsfse.DestinationNode != nil {
		objectMap["DestinationNode"] = cmsfse.DestinationNode
	}
	if cmsfse.ForcedMove != nil {
		objectMap["ForcedMove"] = cmsfse.ForcedMove
	}
	if cmsfse.PartitionID != nil {
		objectMap["PartitionId"] = cmsfse.PartitionID
	}
	if cmsfse.EventInstanceID != nil {
		objectMap["EventInstanceId"] = cmsfse.EventInstanceID
	}
	if cmsfse.TimeStamp != nil {
		objectMap["TimeStamp"] = cmsfse.TimeStamp
	}
	if cmsfse.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = cmsfse.HasCorrelatedEvents
	}
	if cmsfse.Kind != "" {
		objectMap["Kind"] = cmsfse.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return nil, false
}

// AsClusterEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return nil, false
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return &cmsfse, true
}

// AsReplicaEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsApplicationHealthReportCreatedEvent() (*ApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompleteEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsApplicationUpgradeCompleteEvent() (*ApplicationUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsApplicationUpgradeDomainCompleteEvent() (*ApplicationUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsApplicationUpgradeRollbackCompleteEvent() (*ApplicationUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsApplicationUpgradeRollbackStartEvent() (*ApplicationUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsApplicationUpgradeStartEvent() (*ApplicationUpgradeStartEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsDeployedApplicationHealthReportCreatedEvent() (*DeployedApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsProcessDeactivatedEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsProcessDeactivatedEvent() (*ProcessDeactivatedEvent, bool) {
	return nil, false
}

// AsContainerDeactivatedEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsContainerDeactivatedEvent() (*ContainerDeactivatedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAbortingEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsNodeAbortingEvent() (*NodeAbortingEvent, bool) {
	return nil, false
}

// AsNodeAddedEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsNodeAddedEvent() (*NodeAddedEvent, bool) {
	return nil, false
}

// AsNodeCloseEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsNodeCloseEvent() (*NodeCloseEvent, bool) {
	return nil, false
}

// AsNodeClosingEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsNodeClosingEvent() (*NodeClosingEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompleteEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsNodeDeactivateCompleteEvent() (*NodeDeactivateCompleteEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsNodeDeactivateStartEvent() (*NodeDeactivateStartEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsNodeHealthReportCreatedEvent() (*NodeHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenedSuccessEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsNodeOpenedSuccessEvent() (*NodeOpenedSuccessEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeOpeningEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsNodeOpeningEvent() (*NodeOpeningEvent, bool) {
	return nil, false
}

// AsNodeRemovedEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsNodeRemovedEvent() (*NodeRemovedEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsPartitionHealthReportCreatedEvent() (*PartitionHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfigurationCompletedEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsPartitionReconfigurationCompletedEvent() (*PartitionReconfigurationCompletedEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsServiceHealthReportCreatedEvent() (*ServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsDeployedServiceHealthReportCreatedEvent() (*DeployedServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsDeployedServiceHealthReportExpiredEvent() (*DeployedServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsStatefulReplicaHealthReportCreatedEvent() (*StatefulReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsStatelessReplicaHealthReportCreatedEvent() (*StatelessReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsClusterHealthReportCreatedEvent() (*ClusterHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompleteEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsClusterUpgradeCompleteEvent() (*ClusterUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsClusterUpgradeDomainCompleteEvent() (*ClusterUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsClusterUpgradeRollbackCompleteEvent() (*ClusterUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsClusterUpgradeRollbackStartEvent() (*ClusterUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsClusterUpgradeStartEvent() (*ClusterUpgradeStartEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultCompletedEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsChaosRestartNodeFaultCompletedEvent() (*ChaosRestartNodeFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultScheduledEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsChaosRestartCodePackageFaultScheduledEvent() (*ChaosRestartCodePackageFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultCompletedEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsChaosRestartCodePackageFaultCompletedEvent() (*ChaosRestartCodePackageFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsChaosRemoveReplicaFaultScheduledEvent() (*ChaosRemoveReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultCompletedEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsChaosRemoveReplicaFaultCompletedEvent() (*ChaosRemoveReplicaFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosMoveSecondaryFaultScheduledEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsChaosMoveSecondaryFaultScheduledEvent() (*ChaosMoveSecondaryFaultScheduledEvent, bool) {
	return &cmsfse, true
}

// AsChaosMovePrimaryFaultScheduledEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsChaosMovePrimaryFaultScheduledEvent() (*ChaosMovePrimaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsChaosRestartReplicaFaultScheduledEvent() (*ChaosRestartReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultScheduledEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsChaosRestartNodeFaultScheduledEvent() (*ChaosRestartNodeFaultScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ChaosMoveSecondaryFaultScheduledEvent.
func (cmsfse ChaosMoveSecondaryFaultScheduledEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &cmsfse, true
}

// ChaosParameters defines all the parameters to configure a Chaos run.
type ChaosParameters struct {
	// TimeToRunInSeconds - Total time (in seconds) for which Chaos will run before automatically stopping. The maximum allowed value is 4,294,967,295 (System.UInt32.MaxValue).
	TimeToRunInSeconds *string `json:"TimeToRunInSeconds,omitempty"`
	// MaxClusterStabilizationTimeoutInSeconds - The maximum amount of time to wait for all cluster entities to become stable and healthy. Chaos executes in iterations and at the start of each iteration it validates the health of cluster entities.
	// During validation if a cluster entity is not stable and healthy within MaxClusterStabilizationTimeoutInSeconds, Chaos generates a validation failed event.
	MaxClusterStabilizationTimeoutInSeconds *int64 `json:"MaxClusterStabilizationTimeoutInSeconds,omitempty"`
	// MaxConcurrentFaults - MaxConcurrentFaults is the maximum number of concurrent faults induced per iteration.
	// Chaos executes in iterations and two consecutive iterations are separated by a validation phase.
	// The higher the concurrency, the more aggressive the injection of faults, leading to inducing more complex series of states to uncover bugs.
	// The recommendation is to start with a value of 2 or 3 and to exercise caution while moving up.
	MaxConcurrentFaults *int64 `json:"MaxConcurrentFaults,omitempty"`
	// EnableMoveReplicaFaults - Enables or disables the move primary and move secondary faults.
	EnableMoveReplicaFaults *bool `json:"EnableMoveReplicaFaults,omitempty"`
	// WaitTimeBetweenFaultsInSeconds - Wait time (in seconds) between consecutive faults within a single iteration.
	// The larger the value, the lower the overlapping between faults and the simpler the sequence of state transitions that the cluster goes through.
	// The recommendation is to start with a value between 1 and 5 and exercise caution while moving up.
	WaitTimeBetweenFaultsInSeconds *int64 `json:"WaitTimeBetweenFaultsInSeconds,omitempty"`
	// WaitTimeBetweenIterationsInSeconds - Time-separation (in seconds) between two consecutive iterations of Chaos.
	// The larger the value, the lower the fault injection rate.
	WaitTimeBetweenIterationsInSeconds *int64 `json:"WaitTimeBetweenIterationsInSeconds,omitempty"`
	// ClusterHealthPolicy - Passed-in cluster health policy is used to validate health of the cluster in between Chaos iterations. If the cluster health is in error or if an unexpected exception happens during fault execution--to provide the cluster with some time to recuperate--Chaos will wait for 30 minutes before the next health-check.
	ClusterHealthPolicy *ClusterHealthPolicy `json:"ClusterHealthPolicy,omitempty"`
	// Context - Describes a map, which is a collection of (string, string) type key-value pairs. The map can be used to record information about
	// the Chaos run. There cannot be more than 100 such pairs and each string (key or value) can be at most 4095 characters long.
	// This map is set by the starter of the Chaos run to optionally store the context about the specific run.
	Context *ChaosContext `json:"Context,omitempty"`
	// ChaosTargetFilter - List of cluster entities to target for Chaos faults.
	// This filter can be used to target Chaos faults only to certain node types or only to certain application instances. If ChaosTargetFilter is not used, Chaos faults all cluster entities.
	// If ChaosTargetFilter is used, Chaos faults only the entities that meet the ChaosTargetFilter specification.
	ChaosTargetFilter *ChaosTargetFilter `json:"ChaosTargetFilter,omitempty"`
}

// ChaosParametersDictionaryItem defines an item in ChaosParametersDictionary of the Chaos Schedule.
type ChaosParametersDictionaryItem struct {
	// Key - The key identifying the Chaos Parameter in the dictionary. This key is referenced by Chaos Schedule Jobs.
	Key *string `json:"Key,omitempty"`
	// Value - Defines all the parameters to configure a Chaos run.
	Value *ChaosParameters `json:"Value,omitempty"`
}

// ChaosRemoveReplicaFaultCompletedEvent chaos Remove Replica Fault Completed event.
type ChaosRemoveReplicaFaultCompletedEvent struct {
	// FaultGroupID - Id of fault group.
	FaultGroupID *uuid.UUID `json:"FaultGroupId,omitempty"`
	// FaultID - Id of fault.
	FaultID *uuid.UUID `json:"FaultId,omitempty"`
	// ServiceURI - Service name.
	ServiceURI *string `json:"ServiceUri,omitempty"`
	// PartitionID - An internal ID used by Service Fabric to uniquely identify a partition. This is a randomly generated GUID when the service was created. The partition ID is unique and does not change for the lifetime of the service. If the same service was deleted and recreated the IDs of its partitions would be different.
	PartitionID *uuid.UUID `json:"PartitionId,omitempty"`
	// ReplicaID - Id of a stateful service replica. ReplicaId is used by Service Fabric to uniquely identify a replica of a partition. It is unique within a partition and does not change for the lifetime of the replica. If a replica gets dropped and another replica gets created on the same node for the same partition, it will get a different value for the id. Sometimes the id of a stateless service instance is also referred as a replica id.
	ReplicaID *int64 `json:"ReplicaId,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationHealthReportCreated', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeComplete', 'KindApplicationUpgradeDomainComplete', 'KindApplicationUpgradeRollbackComplete', 'KindApplicationUpgradeRollbackStart', 'KindApplicationUpgradeStart', 'KindDeployedApplicationHealthReportCreated', 'KindDeployedApplicationHealthReportExpired', 'KindProcessDeactivated', 'KindContainerDeactivated', 'KindNodeAborted', 'KindNodeAborting', 'KindNodeAdded', 'KindNodeClose', 'KindNodeClosing', 'KindNodeDeactivateComplete', 'KindNodeDeactivateStart', 'KindNodeDown', 'KindNodeHealthReportCreated', 'KindNodeHealthReportExpired', 'KindNodeOpenedSuccess', 'KindNodeOpenFailed', 'KindNodeOpening', 'KindNodeRemoved', 'KindNodeUp', 'KindPartitionHealthReportCreated', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigurationCompleted', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceHealthReportCreated', 'KindServiceHealthReportExpired', 'KindDeployedServiceHealthReportCreated', 'KindDeployedServiceHealthReportExpired', 'KindStatefulReplicaHealthReportCreated', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaHealthReportCreated', 'KindStatelessReplicaHealthReportExpired', 'KindClusterHealthReportCreated', 'KindClusterHealthReportExpired', 'KindClusterUpgradeComplete', 'KindClusterUpgradeDomainComplete', 'KindClusterUpgradeRollbackComplete', 'KindClusterUpgradeRollbackStart', 'KindClusterUpgradeStart', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosRestartNodeFaultCompleted', 'KindChaosRestartCodePackageFaultScheduled', 'KindChaosRestartCodePackageFaultCompleted', 'KindChaosRemoveReplicaFaultScheduled', 'KindChaosRemoveReplicaFaultCompleted', 'KindChaosMoveSecondaryFaultScheduled', 'KindChaosMovePrimaryFaultScheduled', 'KindChaosRestartReplicaFaultScheduled', 'KindChaosRestartNodeFaultScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) MarshalJSON() ([]byte, error) {
	crrfce.Kind = KindChaosRemoveReplicaFaultCompleted
	objectMap := make(map[string]interface{})
	if crrfce.FaultGroupID != nil {
		objectMap["FaultGroupId"] = crrfce.FaultGroupID
	}
	if crrfce.FaultID != nil {
		objectMap["FaultId"] = crrfce.FaultID
	}
	if crrfce.ServiceURI != nil {
		objectMap["ServiceUri"] = crrfce.ServiceURI
	}
	if crrfce.PartitionID != nil {
		objectMap["PartitionId"] = crrfce.PartitionID
	}
	if crrfce.ReplicaID != nil {
		objectMap["ReplicaId"] = crrfce.ReplicaID
	}
	if crrfce.EventInstanceID != nil {
		objectMap["EventInstanceId"] = crrfce.EventInstanceID
	}
	if crrfce.TimeStamp != nil {
		objectMap["TimeStamp"] = crrfce.TimeStamp
	}
	if crrfce.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = crrfce.HasCorrelatedEvents
	}
	if crrfce.Kind != "" {
		objectMap["Kind"] = crrfce.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return nil, false
}

// AsClusterEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return nil, false
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return &crrfce, true
}

// AsServiceEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsApplicationHealthReportCreatedEvent() (*ApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompleteEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsApplicationUpgradeCompleteEvent() (*ApplicationUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsApplicationUpgradeDomainCompleteEvent() (*ApplicationUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsApplicationUpgradeRollbackCompleteEvent() (*ApplicationUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsApplicationUpgradeRollbackStartEvent() (*ApplicationUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsApplicationUpgradeStartEvent() (*ApplicationUpgradeStartEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsDeployedApplicationHealthReportCreatedEvent() (*DeployedApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsProcessDeactivatedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsProcessDeactivatedEvent() (*ProcessDeactivatedEvent, bool) {
	return nil, false
}

// AsContainerDeactivatedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsContainerDeactivatedEvent() (*ContainerDeactivatedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAbortingEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsNodeAbortingEvent() (*NodeAbortingEvent, bool) {
	return nil, false
}

// AsNodeAddedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsNodeAddedEvent() (*NodeAddedEvent, bool) {
	return nil, false
}

// AsNodeCloseEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsNodeCloseEvent() (*NodeCloseEvent, bool) {
	return nil, false
}

// AsNodeClosingEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsNodeClosingEvent() (*NodeClosingEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompleteEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsNodeDeactivateCompleteEvent() (*NodeDeactivateCompleteEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsNodeDeactivateStartEvent() (*NodeDeactivateStartEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsNodeHealthReportCreatedEvent() (*NodeHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenedSuccessEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsNodeOpenedSuccessEvent() (*NodeOpenedSuccessEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeOpeningEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsNodeOpeningEvent() (*NodeOpeningEvent, bool) {
	return nil, false
}

// AsNodeRemovedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsNodeRemovedEvent() (*NodeRemovedEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsPartitionHealthReportCreatedEvent() (*PartitionHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfigurationCompletedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsPartitionReconfigurationCompletedEvent() (*PartitionReconfigurationCompletedEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsServiceHealthReportCreatedEvent() (*ServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsDeployedServiceHealthReportCreatedEvent() (*DeployedServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsDeployedServiceHealthReportExpiredEvent() (*DeployedServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsStatefulReplicaHealthReportCreatedEvent() (*StatefulReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsStatelessReplicaHealthReportCreatedEvent() (*StatelessReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsClusterHealthReportCreatedEvent() (*ClusterHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompleteEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsClusterUpgradeCompleteEvent() (*ClusterUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsClusterUpgradeDomainCompleteEvent() (*ClusterUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsClusterUpgradeRollbackCompleteEvent() (*ClusterUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsClusterUpgradeRollbackStartEvent() (*ClusterUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsClusterUpgradeStartEvent() (*ClusterUpgradeStartEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultCompletedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsChaosRestartNodeFaultCompletedEvent() (*ChaosRestartNodeFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsChaosRestartCodePackageFaultScheduledEvent() (*ChaosRestartCodePackageFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultCompletedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsChaosRestartCodePackageFaultCompletedEvent() (*ChaosRestartCodePackageFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsChaosRemoveReplicaFaultScheduledEvent() (*ChaosRemoveReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultCompletedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsChaosRemoveReplicaFaultCompletedEvent() (*ChaosRemoveReplicaFaultCompletedEvent, bool) {
	return &crrfce, true
}

// AsChaosMoveSecondaryFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsChaosMoveSecondaryFaultScheduledEvent() (*ChaosMoveSecondaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosMovePrimaryFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsChaosMovePrimaryFaultScheduledEvent() (*ChaosMovePrimaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsChaosRestartReplicaFaultScheduledEvent() (*ChaosRestartReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsChaosRestartNodeFaultScheduledEvent() (*ChaosRestartNodeFaultScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultCompletedEvent.
func (crrfce ChaosRemoveReplicaFaultCompletedEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &crrfce, true
}

// ChaosRemoveReplicaFaultScheduledEvent chaos Remove Replica Fault Scheduled event.
type ChaosRemoveReplicaFaultScheduledEvent struct {
	// FaultGroupID - Id of fault group.
	FaultGroupID *uuid.UUID `json:"FaultGroupId,omitempty"`
	// FaultID - Id of fault.
	FaultID *uuid.UUID `json:"FaultId,omitempty"`
	// ServiceURI - Service name.
	ServiceURI *string `json:"ServiceUri,omitempty"`
	// PartitionID - An internal ID used by Service Fabric to uniquely identify a partition. This is a randomly generated GUID when the service was created. The partition ID is unique and does not change for the lifetime of the service. If the same service was deleted and recreated the IDs of its partitions would be different.
	PartitionID *uuid.UUID `json:"PartitionId,omitempty"`
	// ReplicaID - Id of a stateful service replica. ReplicaId is used by Service Fabric to uniquely identify a replica of a partition. It is unique within a partition and does not change for the lifetime of the replica. If a replica gets dropped and another replica gets created on the same node for the same partition, it will get a different value for the id. Sometimes the id of a stateless service instance is also referred as a replica id.
	ReplicaID *int64 `json:"ReplicaId,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationHealthReportCreated', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeComplete', 'KindApplicationUpgradeDomainComplete', 'KindApplicationUpgradeRollbackComplete', 'KindApplicationUpgradeRollbackStart', 'KindApplicationUpgradeStart', 'KindDeployedApplicationHealthReportCreated', 'KindDeployedApplicationHealthReportExpired', 'KindProcessDeactivated', 'KindContainerDeactivated', 'KindNodeAborted', 'KindNodeAborting', 'KindNodeAdded', 'KindNodeClose', 'KindNodeClosing', 'KindNodeDeactivateComplete', 'KindNodeDeactivateStart', 'KindNodeDown', 'KindNodeHealthReportCreated', 'KindNodeHealthReportExpired', 'KindNodeOpenedSuccess', 'KindNodeOpenFailed', 'KindNodeOpening', 'KindNodeRemoved', 'KindNodeUp', 'KindPartitionHealthReportCreated', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigurationCompleted', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceHealthReportCreated', 'KindServiceHealthReportExpired', 'KindDeployedServiceHealthReportCreated', 'KindDeployedServiceHealthReportExpired', 'KindStatefulReplicaHealthReportCreated', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaHealthReportCreated', 'KindStatelessReplicaHealthReportExpired', 'KindClusterHealthReportCreated', 'KindClusterHealthReportExpired', 'KindClusterUpgradeComplete', 'KindClusterUpgradeDomainComplete', 'KindClusterUpgradeRollbackComplete', 'KindClusterUpgradeRollbackStart', 'KindClusterUpgradeStart', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosRestartNodeFaultCompleted', 'KindChaosRestartCodePackageFaultScheduled', 'KindChaosRestartCodePackageFaultCompleted', 'KindChaosRemoveReplicaFaultScheduled', 'KindChaosRemoveReplicaFaultCompleted', 'KindChaosMoveSecondaryFaultScheduled', 'KindChaosMovePrimaryFaultScheduled', 'KindChaosRestartReplicaFaultScheduled', 'KindChaosRestartNodeFaultScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) MarshalJSON() ([]byte, error) {
	crrfse.Kind = KindChaosRemoveReplicaFaultScheduled
	objectMap := make(map[string]interface{})
	if crrfse.FaultGroupID != nil {
		objectMap["FaultGroupId"] = crrfse.FaultGroupID
	}
	if crrfse.FaultID != nil {
		objectMap["FaultId"] = crrfse.FaultID
	}
	if crrfse.ServiceURI != nil {
		objectMap["ServiceUri"] = crrfse.ServiceURI
	}
	if crrfse.PartitionID != nil {
		objectMap["PartitionId"] = crrfse.PartitionID
	}
	if crrfse.ReplicaID != nil {
		objectMap["ReplicaId"] = crrfse.ReplicaID
	}
	if crrfse.EventInstanceID != nil {
		objectMap["EventInstanceId"] = crrfse.EventInstanceID
	}
	if crrfse.TimeStamp != nil {
		objectMap["TimeStamp"] = crrfse.TimeStamp
	}
	if crrfse.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = crrfse.HasCorrelatedEvents
	}
	if crrfse.Kind != "" {
		objectMap["Kind"] = crrfse.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return nil, false
}

// AsClusterEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return nil, false
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return &crrfse, true
}

// AsServiceEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsApplicationHealthReportCreatedEvent() (*ApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompleteEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsApplicationUpgradeCompleteEvent() (*ApplicationUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsApplicationUpgradeDomainCompleteEvent() (*ApplicationUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsApplicationUpgradeRollbackCompleteEvent() (*ApplicationUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsApplicationUpgradeRollbackStartEvent() (*ApplicationUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsApplicationUpgradeStartEvent() (*ApplicationUpgradeStartEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsDeployedApplicationHealthReportCreatedEvent() (*DeployedApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsProcessDeactivatedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsProcessDeactivatedEvent() (*ProcessDeactivatedEvent, bool) {
	return nil, false
}

// AsContainerDeactivatedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsContainerDeactivatedEvent() (*ContainerDeactivatedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAbortingEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsNodeAbortingEvent() (*NodeAbortingEvent, bool) {
	return nil, false
}

// AsNodeAddedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsNodeAddedEvent() (*NodeAddedEvent, bool) {
	return nil, false
}

// AsNodeCloseEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsNodeCloseEvent() (*NodeCloseEvent, bool) {
	return nil, false
}

// AsNodeClosingEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsNodeClosingEvent() (*NodeClosingEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompleteEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsNodeDeactivateCompleteEvent() (*NodeDeactivateCompleteEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsNodeDeactivateStartEvent() (*NodeDeactivateStartEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsNodeHealthReportCreatedEvent() (*NodeHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenedSuccessEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsNodeOpenedSuccessEvent() (*NodeOpenedSuccessEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeOpeningEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsNodeOpeningEvent() (*NodeOpeningEvent, bool) {
	return nil, false
}

// AsNodeRemovedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsNodeRemovedEvent() (*NodeRemovedEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsPartitionHealthReportCreatedEvent() (*PartitionHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfigurationCompletedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsPartitionReconfigurationCompletedEvent() (*PartitionReconfigurationCompletedEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsServiceHealthReportCreatedEvent() (*ServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsDeployedServiceHealthReportCreatedEvent() (*DeployedServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsDeployedServiceHealthReportExpiredEvent() (*DeployedServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsStatefulReplicaHealthReportCreatedEvent() (*StatefulReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsStatelessReplicaHealthReportCreatedEvent() (*StatelessReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsClusterHealthReportCreatedEvent() (*ClusterHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompleteEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsClusterUpgradeCompleteEvent() (*ClusterUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsClusterUpgradeDomainCompleteEvent() (*ClusterUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsClusterUpgradeRollbackCompleteEvent() (*ClusterUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsClusterUpgradeRollbackStartEvent() (*ClusterUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsClusterUpgradeStartEvent() (*ClusterUpgradeStartEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultCompletedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsChaosRestartNodeFaultCompletedEvent() (*ChaosRestartNodeFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsChaosRestartCodePackageFaultScheduledEvent() (*ChaosRestartCodePackageFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultCompletedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsChaosRestartCodePackageFaultCompletedEvent() (*ChaosRestartCodePackageFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsChaosRemoveReplicaFaultScheduledEvent() (*ChaosRemoveReplicaFaultScheduledEvent, bool) {
	return &crrfse, true
}

// AsChaosRemoveReplicaFaultCompletedEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsChaosRemoveReplicaFaultCompletedEvent() (*ChaosRemoveReplicaFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosMoveSecondaryFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsChaosMoveSecondaryFaultScheduledEvent() (*ChaosMoveSecondaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosMovePrimaryFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsChaosMovePrimaryFaultScheduledEvent() (*ChaosMovePrimaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsChaosRestartReplicaFaultScheduledEvent() (*ChaosRestartReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsChaosRestartNodeFaultScheduledEvent() (*ChaosRestartNodeFaultScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ChaosRemoveReplicaFaultScheduledEvent.
func (crrfse ChaosRemoveReplicaFaultScheduledEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &crrfse, true
}

// ChaosRestartCodePackageFaultCompletedEvent chaos Restart Code Package Fault Completed event.
type ChaosRestartCodePackageFaultCompletedEvent struct {
	// FaultGroupID - Id of fault group.
	FaultGroupID *uuid.UUID `json:"FaultGroupId,omitempty"`
	// FaultID - Id of fault.
	FaultID *uuid.UUID `json:"FaultId,omitempty"`
	// NodeName - The name of a Service Fabric node.
	NodeName *string `json:"NodeName,omitempty"`
	// ServiceManifestName - Service manifest name.
	ServiceManifestName *string `json:"ServiceManifestName,omitempty"`
	// CodePackageName - Code package name.
	CodePackageName *string `json:"CodePackageName,omitempty"`
	// ServicePackageActivationID - Id of Service package activation.
	ServicePackageActivationID *string `json:"ServicePackageActivationId,omitempty"`
	// ApplicationID - The identity of the application. This is an encoded representation of the application name. This is used in the REST APIs to identify the application resource.
	// Starting in version 6.0, hierarchical names are delimited with the "\~" character. For example, if the application name is "fabric:/myapp/app1",
	// the application identity would be "myapp\~app1" in 6.0+ and "myapp/app1" in previous versions.
	ApplicationID *string `json:"ApplicationId,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationHealthReportCreated', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeComplete', 'KindApplicationUpgradeDomainComplete', 'KindApplicationUpgradeRollbackComplete', 'KindApplicationUpgradeRollbackStart', 'KindApplicationUpgradeStart', 'KindDeployedApplicationHealthReportCreated', 'KindDeployedApplicationHealthReportExpired', 'KindProcessDeactivated', 'KindContainerDeactivated', 'KindNodeAborted', 'KindNodeAborting', 'KindNodeAdded', 'KindNodeClose', 'KindNodeClosing', 'KindNodeDeactivateComplete', 'KindNodeDeactivateStart', 'KindNodeDown', 'KindNodeHealthReportCreated', 'KindNodeHealthReportExpired', 'KindNodeOpenedSuccess', 'KindNodeOpenFailed', 'KindNodeOpening', 'KindNodeRemoved', 'KindNodeUp', 'KindPartitionHealthReportCreated', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigurationCompleted', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceHealthReportCreated', 'KindServiceHealthReportExpired', 'KindDeployedServiceHealthReportCreated', 'KindDeployedServiceHealthReportExpired', 'KindStatefulReplicaHealthReportCreated', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaHealthReportCreated', 'KindStatelessReplicaHealthReportExpired', 'KindClusterHealthReportCreated', 'KindClusterHealthReportExpired', 'KindClusterUpgradeComplete', 'KindClusterUpgradeDomainComplete', 'KindClusterUpgradeRollbackComplete', 'KindClusterUpgradeRollbackStart', 'KindClusterUpgradeStart', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosRestartNodeFaultCompleted', 'KindChaosRestartCodePackageFaultScheduled', 'KindChaosRestartCodePackageFaultCompleted', 'KindChaosRemoveReplicaFaultScheduled', 'KindChaosRemoveReplicaFaultCompleted', 'KindChaosMoveSecondaryFaultScheduled', 'KindChaosMovePrimaryFaultScheduled', 'KindChaosRestartReplicaFaultScheduled', 'KindChaosRestartNodeFaultScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) MarshalJSON() ([]byte, error) {
	crcpfce.Kind = KindChaosRestartCodePackageFaultCompleted
	objectMap := make(map[string]interface{})
	if crcpfce.FaultGroupID != nil {
		objectMap["FaultGroupId"] = crcpfce.FaultGroupID
	}
	if crcpfce.FaultID != nil {
		objectMap["FaultId"] = crcpfce.FaultID
	}
	if crcpfce.NodeName != nil {
		objectMap["NodeName"] = crcpfce.NodeName
	}
	if crcpfce.ServiceManifestName != nil {
		objectMap["ServiceManifestName"] = crcpfce.ServiceManifestName
	}
	if crcpfce.CodePackageName != nil {
		objectMap["CodePackageName"] = crcpfce.CodePackageName
	}
	if crcpfce.ServicePackageActivationID != nil {
		objectMap["ServicePackageActivationId"] = crcpfce.ServicePackageActivationID
	}
	if crcpfce.ApplicationID != nil {
		objectMap["ApplicationId"] = crcpfce.ApplicationID
	}
	if crcpfce.EventInstanceID != nil {
		objectMap["EventInstanceId"] = crcpfce.EventInstanceID
	}
	if crcpfce.TimeStamp != nil {
		objectMap["TimeStamp"] = crcpfce.TimeStamp
	}
	if crcpfce.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = crcpfce.HasCorrelatedEvents
	}
	if crcpfce.Kind != "" {
		objectMap["Kind"] = crcpfce.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return &crcpfce, true
}

// AsClusterEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return nil, false
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsApplicationHealthReportCreatedEvent() (*ApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompleteEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsApplicationUpgradeCompleteEvent() (*ApplicationUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsApplicationUpgradeDomainCompleteEvent() (*ApplicationUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsApplicationUpgradeRollbackCompleteEvent() (*ApplicationUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsApplicationUpgradeRollbackStartEvent() (*ApplicationUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsApplicationUpgradeStartEvent() (*ApplicationUpgradeStartEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsDeployedApplicationHealthReportCreatedEvent() (*DeployedApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsProcessDeactivatedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsProcessDeactivatedEvent() (*ProcessDeactivatedEvent, bool) {
	return nil, false
}

// AsContainerDeactivatedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsContainerDeactivatedEvent() (*ContainerDeactivatedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAbortingEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsNodeAbortingEvent() (*NodeAbortingEvent, bool) {
	return nil, false
}

// AsNodeAddedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsNodeAddedEvent() (*NodeAddedEvent, bool) {
	return nil, false
}

// AsNodeCloseEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsNodeCloseEvent() (*NodeCloseEvent, bool) {
	return nil, false
}

// AsNodeClosingEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsNodeClosingEvent() (*NodeClosingEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompleteEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsNodeDeactivateCompleteEvent() (*NodeDeactivateCompleteEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsNodeDeactivateStartEvent() (*NodeDeactivateStartEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsNodeHealthReportCreatedEvent() (*NodeHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenedSuccessEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsNodeOpenedSuccessEvent() (*NodeOpenedSuccessEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeOpeningEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsNodeOpeningEvent() (*NodeOpeningEvent, bool) {
	return nil, false
}

// AsNodeRemovedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsNodeRemovedEvent() (*NodeRemovedEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsPartitionHealthReportCreatedEvent() (*PartitionHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfigurationCompletedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsPartitionReconfigurationCompletedEvent() (*PartitionReconfigurationCompletedEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsServiceHealthReportCreatedEvent() (*ServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsDeployedServiceHealthReportCreatedEvent() (*DeployedServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsDeployedServiceHealthReportExpiredEvent() (*DeployedServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsStatefulReplicaHealthReportCreatedEvent() (*StatefulReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsStatelessReplicaHealthReportCreatedEvent() (*StatelessReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsClusterHealthReportCreatedEvent() (*ClusterHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompleteEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsClusterUpgradeCompleteEvent() (*ClusterUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsClusterUpgradeDomainCompleteEvent() (*ClusterUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsClusterUpgradeRollbackCompleteEvent() (*ClusterUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsClusterUpgradeRollbackStartEvent() (*ClusterUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsClusterUpgradeStartEvent() (*ClusterUpgradeStartEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultCompletedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsChaosRestartNodeFaultCompletedEvent() (*ChaosRestartNodeFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsChaosRestartCodePackageFaultScheduledEvent() (*ChaosRestartCodePackageFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultCompletedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsChaosRestartCodePackageFaultCompletedEvent() (*ChaosRestartCodePackageFaultCompletedEvent, bool) {
	return &crcpfce, true
}

// AsChaosRemoveReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsChaosRemoveReplicaFaultScheduledEvent() (*ChaosRemoveReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultCompletedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsChaosRemoveReplicaFaultCompletedEvent() (*ChaosRemoveReplicaFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosMoveSecondaryFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsChaosMoveSecondaryFaultScheduledEvent() (*ChaosMoveSecondaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosMovePrimaryFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsChaosMovePrimaryFaultScheduledEvent() (*ChaosMovePrimaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsChaosRestartReplicaFaultScheduledEvent() (*ChaosRestartReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsChaosRestartNodeFaultScheduledEvent() (*ChaosRestartNodeFaultScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultCompletedEvent.
func (crcpfce ChaosRestartCodePackageFaultCompletedEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &crcpfce, true
}

// ChaosRestartCodePackageFaultScheduledEvent chaos Restart Code Package Fault Scheduled event.
type ChaosRestartCodePackageFaultScheduledEvent struct {
	// FaultGroupID - Id of fault group.
	FaultGroupID *uuid.UUID `json:"FaultGroupId,omitempty"`
	// FaultID - Id of fault.
	FaultID *uuid.UUID `json:"FaultId,omitempty"`
	// NodeName - The name of a Service Fabric node.
	NodeName *string `json:"NodeName,omitempty"`
	// ServiceManifestName - Service manifest name.
	ServiceManifestName *string `json:"ServiceManifestName,omitempty"`
	// CodePackageName - Code package name.
	CodePackageName *string `json:"CodePackageName,omitempty"`
	// ServicePackageActivationID - Id of Service package activation.
	ServicePackageActivationID *string `json:"ServicePackageActivationId,omitempty"`
	// ApplicationID - The identity of the application. This is an encoded representation of the application name. This is used in the REST APIs to identify the application resource.
	// Starting in version 6.0, hierarchical names are delimited with the "\~" character. For example, if the application name is "fabric:/myapp/app1",
	// the application identity would be "myapp\~app1" in 6.0+ and "myapp/app1" in previous versions.
	ApplicationID *string `json:"ApplicationId,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationHealthReportCreated', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeComplete', 'KindApplicationUpgradeDomainComplete', 'KindApplicationUpgradeRollbackComplete', 'KindApplicationUpgradeRollbackStart', 'KindApplicationUpgradeStart', 'KindDeployedApplicationHealthReportCreated', 'KindDeployedApplicationHealthReportExpired', 'KindProcessDeactivated', 'KindContainerDeactivated', 'KindNodeAborted', 'KindNodeAborting', 'KindNodeAdded', 'KindNodeClose', 'KindNodeClosing', 'KindNodeDeactivateComplete', 'KindNodeDeactivateStart', 'KindNodeDown', 'KindNodeHealthReportCreated', 'KindNodeHealthReportExpired', 'KindNodeOpenedSuccess', 'KindNodeOpenFailed', 'KindNodeOpening', 'KindNodeRemoved', 'KindNodeUp', 'KindPartitionHealthReportCreated', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigurationCompleted', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceHealthReportCreated', 'KindServiceHealthReportExpired', 'KindDeployedServiceHealthReportCreated', 'KindDeployedServiceHealthReportExpired', 'KindStatefulReplicaHealthReportCreated', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaHealthReportCreated', 'KindStatelessReplicaHealthReportExpired', 'KindClusterHealthReportCreated', 'KindClusterHealthReportExpired', 'KindClusterUpgradeComplete', 'KindClusterUpgradeDomainComplete', 'KindClusterUpgradeRollbackComplete', 'KindClusterUpgradeRollbackStart', 'KindClusterUpgradeStart', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosRestartNodeFaultCompleted', 'KindChaosRestartCodePackageFaultScheduled', 'KindChaosRestartCodePackageFaultCompleted', 'KindChaosRemoveReplicaFaultScheduled', 'KindChaosRemoveReplicaFaultCompleted', 'KindChaosMoveSecondaryFaultScheduled', 'KindChaosMovePrimaryFaultScheduled', 'KindChaosRestartReplicaFaultScheduled', 'KindChaosRestartNodeFaultScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) MarshalJSON() ([]byte, error) {
	crcpfse.Kind = KindChaosRestartCodePackageFaultScheduled
	objectMap := make(map[string]interface{})
	if crcpfse.FaultGroupID != nil {
		objectMap["FaultGroupId"] = crcpfse.FaultGroupID
	}
	if crcpfse.FaultID != nil {
		objectMap["FaultId"] = crcpfse.FaultID
	}
	if crcpfse.NodeName != nil {
		objectMap["NodeName"] = crcpfse.NodeName
	}
	if crcpfse.ServiceManifestName != nil {
		objectMap["ServiceManifestName"] = crcpfse.ServiceManifestName
	}
	if crcpfse.CodePackageName != nil {
		objectMap["CodePackageName"] = crcpfse.CodePackageName
	}
	if crcpfse.ServicePackageActivationID != nil {
		objectMap["ServicePackageActivationId"] = crcpfse.ServicePackageActivationID
	}
	if crcpfse.ApplicationID != nil {
		objectMap["ApplicationId"] = crcpfse.ApplicationID
	}
	if crcpfse.EventInstanceID != nil {
		objectMap["EventInstanceId"] = crcpfse.EventInstanceID
	}
	if crcpfse.TimeStamp != nil {
		objectMap["TimeStamp"] = crcpfse.TimeStamp
	}
	if crcpfse.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = crcpfse.HasCorrelatedEvents
	}
	if crcpfse.Kind != "" {
		objectMap["Kind"] = crcpfse.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return &crcpfse, true
}

// AsClusterEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return nil, false
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsApplicationHealthReportCreatedEvent() (*ApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompleteEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsApplicationUpgradeCompleteEvent() (*ApplicationUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsApplicationUpgradeDomainCompleteEvent() (*ApplicationUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsApplicationUpgradeRollbackCompleteEvent() (*ApplicationUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsApplicationUpgradeRollbackStartEvent() (*ApplicationUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsApplicationUpgradeStartEvent() (*ApplicationUpgradeStartEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsDeployedApplicationHealthReportCreatedEvent() (*DeployedApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsProcessDeactivatedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsProcessDeactivatedEvent() (*ProcessDeactivatedEvent, bool) {
	return nil, false
}

// AsContainerDeactivatedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsContainerDeactivatedEvent() (*ContainerDeactivatedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAbortingEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsNodeAbortingEvent() (*NodeAbortingEvent, bool) {
	return nil, false
}

// AsNodeAddedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsNodeAddedEvent() (*NodeAddedEvent, bool) {
	return nil, false
}

// AsNodeCloseEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsNodeCloseEvent() (*NodeCloseEvent, bool) {
	return nil, false
}

// AsNodeClosingEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsNodeClosingEvent() (*NodeClosingEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompleteEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsNodeDeactivateCompleteEvent() (*NodeDeactivateCompleteEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsNodeDeactivateStartEvent() (*NodeDeactivateStartEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsNodeHealthReportCreatedEvent() (*NodeHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenedSuccessEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsNodeOpenedSuccessEvent() (*NodeOpenedSuccessEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeOpeningEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsNodeOpeningEvent() (*NodeOpeningEvent, bool) {
	return nil, false
}

// AsNodeRemovedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsNodeRemovedEvent() (*NodeRemovedEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsPartitionHealthReportCreatedEvent() (*PartitionHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfigurationCompletedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsPartitionReconfigurationCompletedEvent() (*PartitionReconfigurationCompletedEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsServiceHealthReportCreatedEvent() (*ServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsDeployedServiceHealthReportCreatedEvent() (*DeployedServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsDeployedServiceHealthReportExpiredEvent() (*DeployedServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsStatefulReplicaHealthReportCreatedEvent() (*StatefulReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsStatelessReplicaHealthReportCreatedEvent() (*StatelessReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsClusterHealthReportCreatedEvent() (*ClusterHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompleteEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsClusterUpgradeCompleteEvent() (*ClusterUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsClusterUpgradeDomainCompleteEvent() (*ClusterUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsClusterUpgradeRollbackCompleteEvent() (*ClusterUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsClusterUpgradeRollbackStartEvent() (*ClusterUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsClusterUpgradeStartEvent() (*ClusterUpgradeStartEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultCompletedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsChaosRestartNodeFaultCompletedEvent() (*ChaosRestartNodeFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsChaosRestartCodePackageFaultScheduledEvent() (*ChaosRestartCodePackageFaultScheduledEvent, bool) {
	return &crcpfse, true
}

// AsChaosRestartCodePackageFaultCompletedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsChaosRestartCodePackageFaultCompletedEvent() (*ChaosRestartCodePackageFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsChaosRemoveReplicaFaultScheduledEvent() (*ChaosRemoveReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultCompletedEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsChaosRemoveReplicaFaultCompletedEvent() (*ChaosRemoveReplicaFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosMoveSecondaryFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsChaosMoveSecondaryFaultScheduledEvent() (*ChaosMoveSecondaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosMovePrimaryFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsChaosMovePrimaryFaultScheduledEvent() (*ChaosMovePrimaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsChaosRestartReplicaFaultScheduledEvent() (*ChaosRestartReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsChaosRestartNodeFaultScheduledEvent() (*ChaosRestartNodeFaultScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ChaosRestartCodePackageFaultScheduledEvent.
func (crcpfse ChaosRestartCodePackageFaultScheduledEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &crcpfse, true
}

// ChaosRestartNodeFaultCompletedEvent chaos Restart Node Fault Completed event.
type ChaosRestartNodeFaultCompletedEvent struct {
	// NodeInstanceID - Id of Node instance.
	NodeInstanceID *int64 `json:"NodeInstanceId,omitempty"`
	// FaultGroupID - Id of fault group.
	FaultGroupID *uuid.UUID `json:"FaultGroupId,omitempty"`
	// FaultID - Id of fault.
	FaultID *uuid.UUID `json:"FaultId,omitempty"`
	// NodeName - The name of a Service Fabric node.
	NodeName *string `json:"NodeName,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationHealthReportCreated', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeComplete', 'KindApplicationUpgradeDomainComplete', 'KindApplicationUpgradeRollbackComplete', 'KindApplicationUpgradeRollbackStart', 'KindApplicationUpgradeStart', 'KindDeployedApplicationHealthReportCreated', 'KindDeployedApplicationHealthReportExpired', 'KindProcessDeactivated', 'KindContainerDeactivated', 'KindNodeAborted', 'KindNodeAborting', 'KindNodeAdded', 'KindNodeClose', 'KindNodeClosing', 'KindNodeDeactivateComplete', 'KindNodeDeactivateStart', 'KindNodeDown', 'KindNodeHealthReportCreated', 'KindNodeHealthReportExpired', 'KindNodeOpenedSuccess', 'KindNodeOpenFailed', 'KindNodeOpening', 'KindNodeRemoved', 'KindNodeUp', 'KindPartitionHealthReportCreated', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigurationCompleted', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceHealthReportCreated', 'KindServiceHealthReportExpired', 'KindDeployedServiceHealthReportCreated', 'KindDeployedServiceHealthReportExpired', 'KindStatefulReplicaHealthReportCreated', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaHealthReportCreated', 'KindStatelessReplicaHealthReportExpired', 'KindClusterHealthReportCreated', 'KindClusterHealthReportExpired', 'KindClusterUpgradeComplete', 'KindClusterUpgradeDomainComplete', 'KindClusterUpgradeRollbackComplete', 'KindClusterUpgradeRollbackStart', 'KindClusterUpgradeStart', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosRestartNodeFaultCompleted', 'KindChaosRestartCodePackageFaultScheduled', 'KindChaosRestartCodePackageFaultCompleted', 'KindChaosRemoveReplicaFaultScheduled', 'KindChaosRemoveReplicaFaultCompleted', 'KindChaosMoveSecondaryFaultScheduled', 'KindChaosMovePrimaryFaultScheduled', 'KindChaosRestartReplicaFaultScheduled', 'KindChaosRestartNodeFaultScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) MarshalJSON() ([]byte, error) {
	crnfce.Kind = KindChaosRestartNodeFaultCompleted
	objectMap := make(map[string]interface{})
	if crnfce.NodeInstanceID != nil {
		objectMap["NodeInstanceId"] = crnfce.NodeInstanceID
	}
	if crnfce.FaultGroupID != nil {
		objectMap["FaultGroupId"] = crnfce.FaultGroupID
	}
	if crnfce.FaultID != nil {
		objectMap["FaultId"] = crnfce.FaultID
	}
	if crnfce.NodeName != nil {
		objectMap["NodeName"] = crnfce.NodeName
	}
	if crnfce.EventInstanceID != nil {
		objectMap["EventInstanceId"] = crnfce.EventInstanceID
	}
	if crnfce.TimeStamp != nil {
		objectMap["TimeStamp"] = crnfce.TimeStamp
	}
	if crnfce.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = crnfce.HasCorrelatedEvents
	}
	if crnfce.Kind != "" {
		objectMap["Kind"] = crnfce.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return nil, false
}

// AsClusterEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return nil, false
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return &crnfce, true
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsApplicationHealthReportCreatedEvent() (*ApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompleteEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsApplicationUpgradeCompleteEvent() (*ApplicationUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsApplicationUpgradeDomainCompleteEvent() (*ApplicationUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsApplicationUpgradeRollbackCompleteEvent() (*ApplicationUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsApplicationUpgradeRollbackStartEvent() (*ApplicationUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsApplicationUpgradeStartEvent() (*ApplicationUpgradeStartEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsDeployedApplicationHealthReportCreatedEvent() (*DeployedApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsProcessDeactivatedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsProcessDeactivatedEvent() (*ProcessDeactivatedEvent, bool) {
	return nil, false
}

// AsContainerDeactivatedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsContainerDeactivatedEvent() (*ContainerDeactivatedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAbortingEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsNodeAbortingEvent() (*NodeAbortingEvent, bool) {
	return nil, false
}

// AsNodeAddedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsNodeAddedEvent() (*NodeAddedEvent, bool) {
	return nil, false
}

// AsNodeCloseEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsNodeCloseEvent() (*NodeCloseEvent, bool) {
	return nil, false
}

// AsNodeClosingEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsNodeClosingEvent() (*NodeClosingEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompleteEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsNodeDeactivateCompleteEvent() (*NodeDeactivateCompleteEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsNodeDeactivateStartEvent() (*NodeDeactivateStartEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsNodeHealthReportCreatedEvent() (*NodeHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenedSuccessEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsNodeOpenedSuccessEvent() (*NodeOpenedSuccessEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeOpeningEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsNodeOpeningEvent() (*NodeOpeningEvent, bool) {
	return nil, false
}

// AsNodeRemovedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsNodeRemovedEvent() (*NodeRemovedEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsPartitionHealthReportCreatedEvent() (*PartitionHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfigurationCompletedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsPartitionReconfigurationCompletedEvent() (*PartitionReconfigurationCompletedEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsServiceHealthReportCreatedEvent() (*ServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsDeployedServiceHealthReportCreatedEvent() (*DeployedServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsDeployedServiceHealthReportExpiredEvent() (*DeployedServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsStatefulReplicaHealthReportCreatedEvent() (*StatefulReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsStatelessReplicaHealthReportCreatedEvent() (*StatelessReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsClusterHealthReportCreatedEvent() (*ClusterHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompleteEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsClusterUpgradeCompleteEvent() (*ClusterUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsClusterUpgradeDomainCompleteEvent() (*ClusterUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsClusterUpgradeRollbackCompleteEvent() (*ClusterUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsClusterUpgradeRollbackStartEvent() (*ClusterUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsClusterUpgradeStartEvent() (*ClusterUpgradeStartEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultCompletedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsChaosRestartNodeFaultCompletedEvent() (*ChaosRestartNodeFaultCompletedEvent, bool) {
	return &crnfce, true
}

// AsChaosRestartCodePackageFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsChaosRestartCodePackageFaultScheduledEvent() (*ChaosRestartCodePackageFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultCompletedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsChaosRestartCodePackageFaultCompletedEvent() (*ChaosRestartCodePackageFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsChaosRemoveReplicaFaultScheduledEvent() (*ChaosRemoveReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultCompletedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsChaosRemoveReplicaFaultCompletedEvent() (*ChaosRemoveReplicaFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosMoveSecondaryFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsChaosMoveSecondaryFaultScheduledEvent() (*ChaosMoveSecondaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosMovePrimaryFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsChaosMovePrimaryFaultScheduledEvent() (*ChaosMovePrimaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsChaosRestartReplicaFaultScheduledEvent() (*ChaosRestartReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsChaosRestartNodeFaultScheduledEvent() (*ChaosRestartNodeFaultScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultCompletedEvent.
func (crnfce ChaosRestartNodeFaultCompletedEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &crnfce, true
}

// ChaosRestartNodeFaultScheduledEvent chaos Restart Node Fault Scheduled event.
type ChaosRestartNodeFaultScheduledEvent struct {
	// NodeInstanceID - Id of Node instance.
	NodeInstanceID *int64 `json:"NodeInstanceId,omitempty"`
	// FaultGroupID - Id of fault group.
	FaultGroupID *uuid.UUID `json:"FaultGroupId,omitempty"`
	// FaultID - Id of fault.
	FaultID *uuid.UUID `json:"FaultId,omitempty"`
	// NodeName - The name of a Service Fabric node.
	NodeName *string `json:"NodeName,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationHealthReportCreated', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeComplete', 'KindApplicationUpgradeDomainComplete', 'KindApplicationUpgradeRollbackComplete', 'KindApplicationUpgradeRollbackStart', 'KindApplicationUpgradeStart', 'KindDeployedApplicationHealthReportCreated', 'KindDeployedApplicationHealthReportExpired', 'KindProcessDeactivated', 'KindContainerDeactivated', 'KindNodeAborted', 'KindNodeAborting', 'KindNodeAdded', 'KindNodeClose', 'KindNodeClosing', 'KindNodeDeactivateComplete', 'KindNodeDeactivateStart', 'KindNodeDown', 'KindNodeHealthReportCreated', 'KindNodeHealthReportExpired', 'KindNodeOpenedSuccess', 'KindNodeOpenFailed', 'KindNodeOpening', 'KindNodeRemoved', 'KindNodeUp', 'KindPartitionHealthReportCreated', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigurationCompleted', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceHealthReportCreated', 'KindServiceHealthReportExpired', 'KindDeployedServiceHealthReportCreated', 'KindDeployedServiceHealthReportExpired', 'KindStatefulReplicaHealthReportCreated', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaHealthReportCreated', 'KindStatelessReplicaHealthReportExpired', 'KindClusterHealthReportCreated', 'KindClusterHealthReportExpired', 'KindClusterUpgradeComplete', 'KindClusterUpgradeDomainComplete', 'KindClusterUpgradeRollbackComplete', 'KindClusterUpgradeRollbackStart', 'KindClusterUpgradeStart', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosRestartNodeFaultCompleted', 'KindChaosRestartCodePackageFaultScheduled', 'KindChaosRestartCodePackageFaultCompleted', 'KindChaosRemoveReplicaFaultScheduled', 'KindChaosRemoveReplicaFaultCompleted', 'KindChaosMoveSecondaryFaultScheduled', 'KindChaosMovePrimaryFaultScheduled', 'KindChaosRestartReplicaFaultScheduled', 'KindChaosRestartNodeFaultScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) MarshalJSON() ([]byte, error) {
	crnfse.Kind = KindChaosRestartNodeFaultScheduled
	objectMap := make(map[string]interface{})
	if crnfse.NodeInstanceID != nil {
		objectMap["NodeInstanceId"] = crnfse.NodeInstanceID
	}
	if crnfse.FaultGroupID != nil {
		objectMap["FaultGroupId"] = crnfse.FaultGroupID
	}
	if crnfse.FaultID != nil {
		objectMap["FaultId"] = crnfse.FaultID
	}
	if crnfse.NodeName != nil {
		objectMap["NodeName"] = crnfse.NodeName
	}
	if crnfse.EventInstanceID != nil {
		objectMap["EventInstanceId"] = crnfse.EventInstanceID
	}
	if crnfse.TimeStamp != nil {
		objectMap["TimeStamp"] = crnfse.TimeStamp
	}
	if crnfse.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = crnfse.HasCorrelatedEvents
	}
	if crnfse.Kind != "" {
		objectMap["Kind"] = crnfse.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return nil, false
}

// AsClusterEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return nil, false
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return &crnfse, true
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsApplicationHealthReportCreatedEvent() (*ApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompleteEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsApplicationUpgradeCompleteEvent() (*ApplicationUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsApplicationUpgradeDomainCompleteEvent() (*ApplicationUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsApplicationUpgradeRollbackCompleteEvent() (*ApplicationUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsApplicationUpgradeRollbackStartEvent() (*ApplicationUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsApplicationUpgradeStartEvent() (*ApplicationUpgradeStartEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsDeployedApplicationHealthReportCreatedEvent() (*DeployedApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsProcessDeactivatedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsProcessDeactivatedEvent() (*ProcessDeactivatedEvent, bool) {
	return nil, false
}

// AsContainerDeactivatedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsContainerDeactivatedEvent() (*ContainerDeactivatedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAbortingEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsNodeAbortingEvent() (*NodeAbortingEvent, bool) {
	return nil, false
}

// AsNodeAddedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsNodeAddedEvent() (*NodeAddedEvent, bool) {
	return nil, false
}

// AsNodeCloseEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsNodeCloseEvent() (*NodeCloseEvent, bool) {
	return nil, false
}

// AsNodeClosingEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsNodeClosingEvent() (*NodeClosingEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompleteEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsNodeDeactivateCompleteEvent() (*NodeDeactivateCompleteEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsNodeDeactivateStartEvent() (*NodeDeactivateStartEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsNodeHealthReportCreatedEvent() (*NodeHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenedSuccessEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsNodeOpenedSuccessEvent() (*NodeOpenedSuccessEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeOpeningEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsNodeOpeningEvent() (*NodeOpeningEvent, bool) {
	return nil, false
}

// AsNodeRemovedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsNodeRemovedEvent() (*NodeRemovedEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsPartitionHealthReportCreatedEvent() (*PartitionHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfigurationCompletedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsPartitionReconfigurationCompletedEvent() (*PartitionReconfigurationCompletedEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsServiceHealthReportCreatedEvent() (*ServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsDeployedServiceHealthReportCreatedEvent() (*DeployedServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsDeployedServiceHealthReportExpiredEvent() (*DeployedServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsStatefulReplicaHealthReportCreatedEvent() (*StatefulReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsStatelessReplicaHealthReportCreatedEvent() (*StatelessReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsClusterHealthReportCreatedEvent() (*ClusterHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompleteEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsClusterUpgradeCompleteEvent() (*ClusterUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsClusterUpgradeDomainCompleteEvent() (*ClusterUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsClusterUpgradeRollbackCompleteEvent() (*ClusterUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsClusterUpgradeRollbackStartEvent() (*ClusterUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsClusterUpgradeStartEvent() (*ClusterUpgradeStartEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultCompletedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsChaosRestartNodeFaultCompletedEvent() (*ChaosRestartNodeFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsChaosRestartCodePackageFaultScheduledEvent() (*ChaosRestartCodePackageFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultCompletedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsChaosRestartCodePackageFaultCompletedEvent() (*ChaosRestartCodePackageFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsChaosRemoveReplicaFaultScheduledEvent() (*ChaosRemoveReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultCompletedEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsChaosRemoveReplicaFaultCompletedEvent() (*ChaosRemoveReplicaFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosMoveSecondaryFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsChaosMoveSecondaryFaultScheduledEvent() (*ChaosMoveSecondaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosMovePrimaryFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsChaosMovePrimaryFaultScheduledEvent() (*ChaosMovePrimaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsChaosRestartReplicaFaultScheduledEvent() (*ChaosRestartReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsChaosRestartNodeFaultScheduledEvent() (*ChaosRestartNodeFaultScheduledEvent, bool) {
	return &crnfse, true
}

// AsFabricEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ChaosRestartNodeFaultScheduledEvent.
func (crnfse ChaosRestartNodeFaultScheduledEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &crnfse, true
}

// ChaosRestartReplicaFaultScheduledEvent chaos Restart Replica Fault Scheduled event.
type ChaosRestartReplicaFaultScheduledEvent struct {
	// FaultGroupID - Id of fault group.
	FaultGroupID *uuid.UUID `json:"FaultGroupId,omitempty"`
	// FaultID - Id of fault.
	FaultID *uuid.UUID `json:"FaultId,omitempty"`
	// ServiceURI - Service name.
	ServiceURI *string `json:"ServiceUri,omitempty"`
	// PartitionID - An internal ID used by Service Fabric to uniquely identify a partition. This is a randomly generated GUID when the service was created. The partition ID is unique and does not change for the lifetime of the service. If the same service was deleted and recreated the IDs of its partitions would be different.
	PartitionID *uuid.UUID `json:"PartitionId,omitempty"`
	// ReplicaID - Id of a stateful service replica. ReplicaId is used by Service Fabric to uniquely identify a replica of a partition. It is unique within a partition and does not change for the lifetime of the replica. If a replica gets dropped and another replica gets created on the same node for the same partition, it will get a different value for the id. Sometimes the id of a stateless service instance is also referred as a replica id.
	ReplicaID *int64 `json:"ReplicaId,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationHealthReportCreated', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeComplete', 'KindApplicationUpgradeDomainComplete', 'KindApplicationUpgradeRollbackComplete', 'KindApplicationUpgradeRollbackStart', 'KindApplicationUpgradeStart', 'KindDeployedApplicationHealthReportCreated', 'KindDeployedApplicationHealthReportExpired', 'KindProcessDeactivated', 'KindContainerDeactivated', 'KindNodeAborted', 'KindNodeAborting', 'KindNodeAdded', 'KindNodeClose', 'KindNodeClosing', 'KindNodeDeactivateComplete', 'KindNodeDeactivateStart', 'KindNodeDown', 'KindNodeHealthReportCreated', 'KindNodeHealthReportExpired', 'KindNodeOpenedSuccess', 'KindNodeOpenFailed', 'KindNodeOpening', 'KindNodeRemoved', 'KindNodeUp', 'KindPartitionHealthReportCreated', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigurationCompleted', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceHealthReportCreated', 'KindServiceHealthReportExpired', 'KindDeployedServiceHealthReportCreated', 'KindDeployedServiceHealthReportExpired', 'KindStatefulReplicaHealthReportCreated', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaHealthReportCreated', 'KindStatelessReplicaHealthReportExpired', 'KindClusterHealthReportCreated', 'KindClusterHealthReportExpired', 'KindClusterUpgradeComplete', 'KindClusterUpgradeDomainComplete', 'KindClusterUpgradeRollbackComplete', 'KindClusterUpgradeRollbackStart', 'KindClusterUpgradeStart', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosRestartNodeFaultCompleted', 'KindChaosRestartCodePackageFaultScheduled', 'KindChaosRestartCodePackageFaultCompleted', 'KindChaosRemoveReplicaFaultScheduled', 'KindChaosRemoveReplicaFaultCompleted', 'KindChaosMoveSecondaryFaultScheduled', 'KindChaosMovePrimaryFaultScheduled', 'KindChaosRestartReplicaFaultScheduled', 'KindChaosRestartNodeFaultScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) MarshalJSON() ([]byte, error) {
	crrfse.Kind = KindChaosRestartReplicaFaultScheduled
	objectMap := make(map[string]interface{})
	if crrfse.FaultGroupID != nil {
		objectMap["FaultGroupId"] = crrfse.FaultGroupID
	}
	if crrfse.FaultID != nil {
		objectMap["FaultId"] = crrfse.FaultID
	}
	if crrfse.ServiceURI != nil {
		objectMap["ServiceUri"] = crrfse.ServiceURI
	}
	if crrfse.PartitionID != nil {
		objectMap["PartitionId"] = crrfse.PartitionID
	}
	if crrfse.ReplicaID != nil {
		objectMap["ReplicaId"] = crrfse.ReplicaID
	}
	if crrfse.EventInstanceID != nil {
		objectMap["EventInstanceId"] = crrfse.EventInstanceID
	}
	if crrfse.TimeStamp != nil {
		objectMap["TimeStamp"] = crrfse.TimeStamp
	}
	if crrfse.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = crrfse.HasCorrelatedEvents
	}
	if crrfse.Kind != "" {
		objectMap["Kind"] = crrfse.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return nil, false
}

// AsClusterEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return nil, false
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return &crrfse, true
}

// AsServiceEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsApplicationHealthReportCreatedEvent() (*ApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompleteEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsApplicationUpgradeCompleteEvent() (*ApplicationUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsApplicationUpgradeDomainCompleteEvent() (*ApplicationUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsApplicationUpgradeRollbackCompleteEvent() (*ApplicationUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsApplicationUpgradeRollbackStartEvent() (*ApplicationUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsApplicationUpgradeStartEvent() (*ApplicationUpgradeStartEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsDeployedApplicationHealthReportCreatedEvent() (*DeployedApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsProcessDeactivatedEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsProcessDeactivatedEvent() (*ProcessDeactivatedEvent, bool) {
	return nil, false
}

// AsContainerDeactivatedEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsContainerDeactivatedEvent() (*ContainerDeactivatedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAbortingEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsNodeAbortingEvent() (*NodeAbortingEvent, bool) {
	return nil, false
}

// AsNodeAddedEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsNodeAddedEvent() (*NodeAddedEvent, bool) {
	return nil, false
}

// AsNodeCloseEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsNodeCloseEvent() (*NodeCloseEvent, bool) {
	return nil, false
}

// AsNodeClosingEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsNodeClosingEvent() (*NodeClosingEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompleteEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsNodeDeactivateCompleteEvent() (*NodeDeactivateCompleteEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsNodeDeactivateStartEvent() (*NodeDeactivateStartEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsNodeHealthReportCreatedEvent() (*NodeHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenedSuccessEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsNodeOpenedSuccessEvent() (*NodeOpenedSuccessEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeOpeningEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsNodeOpeningEvent() (*NodeOpeningEvent, bool) {
	return nil, false
}

// AsNodeRemovedEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsNodeRemovedEvent() (*NodeRemovedEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsPartitionHealthReportCreatedEvent() (*PartitionHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfigurationCompletedEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsPartitionReconfigurationCompletedEvent() (*PartitionReconfigurationCompletedEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsServiceHealthReportCreatedEvent() (*ServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsDeployedServiceHealthReportCreatedEvent() (*DeployedServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsDeployedServiceHealthReportExpiredEvent() (*DeployedServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsStatefulReplicaHealthReportCreatedEvent() (*StatefulReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsStatelessReplicaHealthReportCreatedEvent() (*StatelessReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsClusterHealthReportCreatedEvent() (*ClusterHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompleteEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsClusterUpgradeCompleteEvent() (*ClusterUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsClusterUpgradeDomainCompleteEvent() (*ClusterUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsClusterUpgradeRollbackCompleteEvent() (*ClusterUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsClusterUpgradeRollbackStartEvent() (*ClusterUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsClusterUpgradeStartEvent() (*ClusterUpgradeStartEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultCompletedEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsChaosRestartNodeFaultCompletedEvent() (*ChaosRestartNodeFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsChaosRestartCodePackageFaultScheduledEvent() (*ChaosRestartCodePackageFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultCompletedEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsChaosRestartCodePackageFaultCompletedEvent() (*ChaosRestartCodePackageFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsChaosRemoveReplicaFaultScheduledEvent() (*ChaosRemoveReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultCompletedEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsChaosRemoveReplicaFaultCompletedEvent() (*ChaosRemoveReplicaFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosMoveSecondaryFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsChaosMoveSecondaryFaultScheduledEvent() (*ChaosMoveSecondaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosMovePrimaryFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsChaosMovePrimaryFaultScheduledEvent() (*ChaosMovePrimaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsChaosRestartReplicaFaultScheduledEvent() (*ChaosRestartReplicaFaultScheduledEvent, bool) {
	return &crrfse, true
}

// AsChaosRestartNodeFaultScheduledEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsChaosRestartNodeFaultScheduledEvent() (*ChaosRestartNodeFaultScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ChaosRestartReplicaFaultScheduledEvent.
func (crrfse ChaosRestartReplicaFaultScheduledEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &crrfse, true
}

// ChaosSchedule defines the schedule used by Chaos.
type ChaosSchedule struct {
	// StartDate - The date and time Chaos will start using this schedule.
	StartDate *date.Time `json:"StartDate,omitempty"`
	// ExpiryDate - The date and time Chaos will continue to use this schedule until.
	ExpiryDate *date.Time `json:"ExpiryDate,omitempty"`
	// ChaosParametersDictionary - A mapping of string names to Chaos Parameters to be referenced by Chaos Schedule Jobs.
	ChaosParametersDictionary *[]ChaosParametersDictionaryItem `json:"ChaosParametersDictionary,omitempty"`
	// Jobs - A list of all Chaos Schedule Jobs that will be automated by the schedule.
	Jobs *[]ChaosScheduleJob `json:"Jobs,omitempty"`
}

// ChaosScheduleDescription defines the Chaos Schedule used by Chaos and the version of the Chaos Schedule.
// The version value wraps back to 0 after surpassing 2,147,483,647.
type ChaosScheduleDescription struct {
	autorest.Response `json:"-"`
	// Version - The version number of the Schedule.
	Version *int32 `json:"Version,omitempty"`
	// Schedule - Defines the schedule used by Chaos.
	Schedule *ChaosSchedule `json:"Schedule,omitempty"`
}

// ChaosScheduleJob defines a repetition rule and parameters of Chaos to be used with the Chaos Schedule.
type ChaosScheduleJob struct {
	// ChaosParameters - A reference to which Chaos Parameters of the Chaos Schedule to use.
	ChaosParameters *string `json:"ChaosParameters,omitempty"`
	// Days - Defines the days of the week that a Chaos Schedule Job will run for.
	Days *ChaosScheduleJobActiveDaysOfWeek `json:"Days,omitempty"`
	// Times - A list of Time Ranges that specify when during active days that this job will run. The times are interpreted as UTC.
	Times *[]TimeRange `json:"Times,omitempty"`
}

// ChaosScheduleJobActiveDaysOfWeek defines the days of the week that a Chaos Schedule Job will run for.
type ChaosScheduleJobActiveDaysOfWeek struct {
	// Sunday - Indicates if the Chaos Schedule Job will run on Sunday
	Sunday *bool `json:"Sunday,omitempty"`
	// Monday - Indicates if the Chaos Schedule Job will run on Monday
	Monday *bool `json:"Monday,omitempty"`
	// Tuesday - Indicates if the Chaos Schedule Job will run on Tuesday
	Tuesday *bool `json:"Tuesday,omitempty"`
	// Wednesday - Indicates if the Chaos Schedule Job will run on Wednesday
	Wednesday *bool `json:"Wednesday,omitempty"`
	// Thursday - Indicates if the Chaos Schedule Job will run on Thursday
	Thursday *bool `json:"Thursday,omitempty"`
	// Friday - Indicates if the Chaos Schedule Job will run on Friday
	Friday *bool `json:"Friday,omitempty"`
	// Saturday - Indicates if the Chaos Schedule Job will run on Saturday
	Saturday *bool `json:"Saturday,omitempty"`
}

// ChaosStartedEvent chaos Started event.
type ChaosStartedEvent struct {
	// MaxConcurrentFaults - Maximum number of concurrent faults.
	MaxConcurrentFaults *int64 `json:"MaxConcurrentFaults,omitempty"`
	// TimeToRunInSeconds - Time to run in seconds.
	TimeToRunInSeconds *float64 `json:"TimeToRunInSeconds,omitempty"`
	// MaxClusterStabilizationTimeoutInSeconds - Maximum timeout for cluster stabilization in seconds.
	MaxClusterStabilizationTimeoutInSeconds *float64 `json:"MaxClusterStabilizationTimeoutInSeconds,omitempty"`
	// WaitTimeBetweenIterationsInSeconds - Wait time between iterations in seconds.
	WaitTimeBetweenIterationsInSeconds *float64 `json:"WaitTimeBetweenIterationsInSeconds,omitempty"`
	// WaitTimeBetweenFautlsInSeconds - Wait time between faults in seconds.
	WaitTimeBetweenFautlsInSeconds *float64 `json:"WaitTimeBetweenFautlsInSeconds,omitempty"`
	// MoveReplicaFaultEnabled - Indicates MoveReplica fault is enabled.
	MoveReplicaFaultEnabled *bool `json:"MoveReplicaFaultEnabled,omitempty"`
	// IncludedNodeTypeList - List of included Node types.
	IncludedNodeTypeList *string `json:"IncludedNodeTypeList,omitempty"`
	// IncludedApplicationList - List of included Applications.
	IncludedApplicationList *string `json:"IncludedApplicationList,omitempty"`
	// ClusterHealthPolicy - Health policy.
	ClusterHealthPolicy *string `json:"ClusterHealthPolicy,omitempty"`
	// ChaosContext - Chaos Context.
	ChaosContext *string `json:"ChaosContext,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationHealthReportCreated', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeComplete', 'KindApplicationUpgradeDomainComplete', 'KindApplicationUpgradeRollbackComplete', 'KindApplicationUpgradeRollbackStart', 'KindApplicationUpgradeStart', 'KindDeployedApplicationHealthReportCreated', 'KindDeployedApplicationHealthReportExpired', 'KindProcessDeactivated', 'KindContainerDeactivated', 'KindNodeAborted', 'KindNodeAborting', 'KindNodeAdded', 'KindNodeClose', 'KindNodeClosing', 'KindNodeDeactivateComplete', 'KindNodeDeactivateStart', 'KindNodeDown', 'KindNodeHealthReportCreated', 'KindNodeHealthReportExpired', 'KindNodeOpenedSuccess', 'KindNodeOpenFailed', 'KindNodeOpening', 'KindNodeRemoved', 'KindNodeUp', 'KindPartitionHealthReportCreated', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigurationCompleted', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceHealthReportCreated', 'KindServiceHealthReportExpired', 'KindDeployedServiceHealthReportCreated', 'KindDeployedServiceHealthReportExpired', 'KindStatefulReplicaHealthReportCreated', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaHealthReportCreated', 'KindStatelessReplicaHealthReportExpired', 'KindClusterHealthReportCreated', 'KindClusterHealthReportExpired', 'KindClusterUpgradeComplete', 'KindClusterUpgradeDomainComplete', 'KindClusterUpgradeRollbackComplete', 'KindClusterUpgradeRollbackStart', 'KindClusterUpgradeStart', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosRestartNodeFaultCompleted', 'KindChaosRestartCodePackageFaultScheduled', 'KindChaosRestartCodePackageFaultCompleted', 'KindChaosRemoveReplicaFaultScheduled', 'KindChaosRemoveReplicaFaultCompleted', 'KindChaosMoveSecondaryFaultScheduled', 'KindChaosMovePrimaryFaultScheduled', 'KindChaosRestartReplicaFaultScheduled', 'KindChaosRestartNodeFaultScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ChaosStartedEvent.
func (cse ChaosStartedEvent) MarshalJSON() ([]byte, error) {
	cse.Kind = KindChaosStarted
	objectMap := make(map[string]interface{})
	if cse.MaxConcurrentFaults != nil {
		objectMap["MaxConcurrentFaults"] = cse.MaxConcurrentFaults
	}
	if cse.TimeToRunInSeconds != nil {
		objectMap["TimeToRunInSeconds"] = cse.TimeToRunInSeconds
	}
	if cse.MaxClusterStabilizationTimeoutInSeconds != nil {
		objectMap["MaxClusterStabilizationTimeoutInSeconds"] = cse.MaxClusterStabilizationTimeoutInSeconds
	}
	if cse.WaitTimeBetweenIterationsInSeconds != nil {
		objectMap["WaitTimeBetweenIterationsInSeconds"] = cse.WaitTimeBetweenIterationsInSeconds
	}
	if cse.WaitTimeBetweenFautlsInSeconds != nil {
		objectMap["WaitTimeBetweenFautlsInSeconds"] = cse.WaitTimeBetweenFautlsInSeconds
	}
	if cse.MoveReplicaFaultEnabled != nil {
		objectMap["MoveReplicaFaultEnabled"] = cse.MoveReplicaFaultEnabled
	}
	if cse.IncludedNodeTypeList != nil {
		objectMap["IncludedNodeTypeList"] = cse.IncludedNodeTypeList
	}
	if cse.IncludedApplicationList != nil {
		objectMap["IncludedApplicationList"] = cse.IncludedApplicationList
	}
	if cse.ClusterHealthPolicy != nil {
		objectMap["ClusterHealthPolicy"] = cse.ClusterHealthPolicy
	}
	if cse.ChaosContext != nil {
		objectMap["ChaosContext"] = cse.ChaosContext
	}
	if cse.EventInstanceID != nil {
		objectMap["EventInstanceId"] = cse.EventInstanceID
	}
	if cse.TimeStamp != nil {
		objectMap["TimeStamp"] = cse.TimeStamp
	}
	if cse.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = cse.HasCorrelatedEvents
	}
	if cse.Kind != "" {
		objectMap["Kind"] = cse.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return nil, false
}

// AsClusterEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return &cse, true
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsApplicationHealthReportCreatedEvent() (*ApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompleteEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsApplicationUpgradeCompleteEvent() (*ApplicationUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsApplicationUpgradeDomainCompleteEvent() (*ApplicationUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsApplicationUpgradeRollbackCompleteEvent() (*ApplicationUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsApplicationUpgradeRollbackStartEvent() (*ApplicationUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsApplicationUpgradeStartEvent() (*ApplicationUpgradeStartEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsDeployedApplicationHealthReportCreatedEvent() (*DeployedApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsProcessDeactivatedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsProcessDeactivatedEvent() (*ProcessDeactivatedEvent, bool) {
	return nil, false
}

// AsContainerDeactivatedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsContainerDeactivatedEvent() (*ContainerDeactivatedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAbortingEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsNodeAbortingEvent() (*NodeAbortingEvent, bool) {
	return nil, false
}

// AsNodeAddedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsNodeAddedEvent() (*NodeAddedEvent, bool) {
	return nil, false
}

// AsNodeCloseEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsNodeCloseEvent() (*NodeCloseEvent, bool) {
	return nil, false
}

// AsNodeClosingEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsNodeClosingEvent() (*NodeClosingEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompleteEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsNodeDeactivateCompleteEvent() (*NodeDeactivateCompleteEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsNodeDeactivateStartEvent() (*NodeDeactivateStartEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsNodeHealthReportCreatedEvent() (*NodeHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenedSuccessEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsNodeOpenedSuccessEvent() (*NodeOpenedSuccessEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeOpeningEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsNodeOpeningEvent() (*NodeOpeningEvent, bool) {
	return nil, false
}

// AsNodeRemovedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsNodeRemovedEvent() (*NodeRemovedEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsPartitionHealthReportCreatedEvent() (*PartitionHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfigurationCompletedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsPartitionReconfigurationCompletedEvent() (*PartitionReconfigurationCompletedEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsServiceHealthReportCreatedEvent() (*ServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsDeployedServiceHealthReportCreatedEvent() (*DeployedServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsDeployedServiceHealthReportExpiredEvent() (*DeployedServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsStatefulReplicaHealthReportCreatedEvent() (*StatefulReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsStatelessReplicaHealthReportCreatedEvent() (*StatelessReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsClusterHealthReportCreatedEvent() (*ClusterHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompleteEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsClusterUpgradeCompleteEvent() (*ClusterUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsClusterUpgradeDomainCompleteEvent() (*ClusterUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsClusterUpgradeRollbackCompleteEvent() (*ClusterUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsClusterUpgradeRollbackStartEvent() (*ClusterUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsClusterUpgradeStartEvent() (*ClusterUpgradeStartEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return &cse, true
}

// AsChaosRestartNodeFaultCompletedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsChaosRestartNodeFaultCompletedEvent() (*ChaosRestartNodeFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultScheduledEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsChaosRestartCodePackageFaultScheduledEvent() (*ChaosRestartCodePackageFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultCompletedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsChaosRestartCodePackageFaultCompletedEvent() (*ChaosRestartCodePackageFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsChaosRemoveReplicaFaultScheduledEvent() (*ChaosRemoveReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultCompletedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsChaosRemoveReplicaFaultCompletedEvent() (*ChaosRemoveReplicaFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosMoveSecondaryFaultScheduledEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsChaosMoveSecondaryFaultScheduledEvent() (*ChaosMoveSecondaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosMovePrimaryFaultScheduledEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsChaosMovePrimaryFaultScheduledEvent() (*ChaosMovePrimaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsChaosRestartReplicaFaultScheduledEvent() (*ChaosRestartReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultScheduledEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsChaosRestartNodeFaultScheduledEvent() (*ChaosRestartNodeFaultScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &cse, true
}

// ChaosStoppedEvent chaos Stopped event.
type ChaosStoppedEvent struct {
	// Reason - Describes reason.
	Reason *string `json:"Reason,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationHealthReportCreated', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeComplete', 'KindApplicationUpgradeDomainComplete', 'KindApplicationUpgradeRollbackComplete', 'KindApplicationUpgradeRollbackStart', 'KindApplicationUpgradeStart', 'KindDeployedApplicationHealthReportCreated', 'KindDeployedApplicationHealthReportExpired', 'KindProcessDeactivated', 'KindContainerDeactivated', 'KindNodeAborted', 'KindNodeAborting', 'KindNodeAdded', 'KindNodeClose', 'KindNodeClosing', 'KindNodeDeactivateComplete', 'KindNodeDeactivateStart', 'KindNodeDown', 'KindNodeHealthReportCreated', 'KindNodeHealthReportExpired', 'KindNodeOpenedSuccess', 'KindNodeOpenFailed', 'KindNodeOpening', 'KindNodeRemoved', 'KindNodeUp', 'KindPartitionHealthReportCreated', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigurationCompleted', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceHealthReportCreated', 'KindServiceHealthReportExpired', 'KindDeployedServiceHealthReportCreated', 'KindDeployedServiceHealthReportExpired', 'KindStatefulReplicaHealthReportCreated', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaHealthReportCreated', 'KindStatelessReplicaHealthReportExpired', 'KindClusterHealthReportCreated', 'KindClusterHealthReportExpired', 'KindClusterUpgradeComplete', 'KindClusterUpgradeDomainComplete', 'KindClusterUpgradeRollbackComplete', 'KindClusterUpgradeRollbackStart', 'KindClusterUpgradeStart', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosRestartNodeFaultCompleted', 'KindChaosRestartCodePackageFaultScheduled', 'KindChaosRestartCodePackageFaultCompleted', 'KindChaosRemoveReplicaFaultScheduled', 'KindChaosRemoveReplicaFaultCompleted', 'KindChaosMoveSecondaryFaultScheduled', 'KindChaosMovePrimaryFaultScheduled', 'KindChaosRestartReplicaFaultScheduled', 'KindChaosRestartNodeFaultScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) MarshalJSON() ([]byte, error) {
	cse.Kind = KindChaosStopped
	objectMap := make(map[string]interface{})
	if cse.Reason != nil {
		objectMap["Reason"] = cse.Reason
	}
	if cse.EventInstanceID != nil {
		objectMap["EventInstanceId"] = cse.EventInstanceID
	}
	if cse.TimeStamp != nil {
		objectMap["TimeStamp"] = cse.TimeStamp
	}
	if cse.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = cse.HasCorrelatedEvents
	}
	if cse.Kind != "" {
		objectMap["Kind"] = cse.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return nil, false
}

// AsClusterEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return &cse, true
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsApplicationHealthReportCreatedEvent() (*ApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompleteEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsApplicationUpgradeCompleteEvent() (*ApplicationUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsApplicationUpgradeDomainCompleteEvent() (*ApplicationUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsApplicationUpgradeRollbackCompleteEvent() (*ApplicationUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsApplicationUpgradeRollbackStartEvent() (*ApplicationUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsApplicationUpgradeStartEvent() (*ApplicationUpgradeStartEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsDeployedApplicationHealthReportCreatedEvent() (*DeployedApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsProcessDeactivatedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsProcessDeactivatedEvent() (*ProcessDeactivatedEvent, bool) {
	return nil, false
}

// AsContainerDeactivatedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsContainerDeactivatedEvent() (*ContainerDeactivatedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAbortingEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsNodeAbortingEvent() (*NodeAbortingEvent, bool) {
	return nil, false
}

// AsNodeAddedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsNodeAddedEvent() (*NodeAddedEvent, bool) {
	return nil, false
}

// AsNodeCloseEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsNodeCloseEvent() (*NodeCloseEvent, bool) {
	return nil, false
}

// AsNodeClosingEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsNodeClosingEvent() (*NodeClosingEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompleteEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsNodeDeactivateCompleteEvent() (*NodeDeactivateCompleteEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsNodeDeactivateStartEvent() (*NodeDeactivateStartEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsNodeHealthReportCreatedEvent() (*NodeHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenedSuccessEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsNodeOpenedSuccessEvent() (*NodeOpenedSuccessEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeOpeningEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsNodeOpeningEvent() (*NodeOpeningEvent, bool) {
	return nil, false
}

// AsNodeRemovedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsNodeRemovedEvent() (*NodeRemovedEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsPartitionHealthReportCreatedEvent() (*PartitionHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfigurationCompletedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsPartitionReconfigurationCompletedEvent() (*PartitionReconfigurationCompletedEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsServiceHealthReportCreatedEvent() (*ServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsDeployedServiceHealthReportCreatedEvent() (*DeployedServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsDeployedServiceHealthReportExpiredEvent() (*DeployedServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsStatefulReplicaHealthReportCreatedEvent() (*StatefulReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsStatelessReplicaHealthReportCreatedEvent() (*StatelessReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterHealthReportCreatedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsClusterHealthReportCreatedEvent() (*ClusterHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompleteEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsClusterUpgradeCompleteEvent() (*ClusterUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsClusterUpgradeDomainCompleteEvent() (*ClusterUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsClusterUpgradeRollbackCompleteEvent() (*ClusterUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsClusterUpgradeRollbackStartEvent() (*ClusterUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsClusterUpgradeStartEvent() (*ClusterUpgradeStartEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return &cse, true
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultCompletedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsChaosRestartNodeFaultCompletedEvent() (*ChaosRestartNodeFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultScheduledEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsChaosRestartCodePackageFaultScheduledEvent() (*ChaosRestartCodePackageFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultCompletedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsChaosRestartCodePackageFaultCompletedEvent() (*ChaosRestartCodePackageFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsChaosRemoveReplicaFaultScheduledEvent() (*ChaosRemoveReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultCompletedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsChaosRemoveReplicaFaultCompletedEvent() (*ChaosRemoveReplicaFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosMoveSecondaryFaultScheduledEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsChaosMoveSecondaryFaultScheduledEvent() (*ChaosMoveSecondaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosMovePrimaryFaultScheduledEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsChaosMovePrimaryFaultScheduledEvent() (*ChaosMovePrimaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsChaosRestartReplicaFaultScheduledEvent() (*ChaosRestartReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultScheduledEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsChaosRestartNodeFaultScheduledEvent() (*ChaosRestartNodeFaultScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &cse, true
}

// ChaosTargetFilter defines all filters for targeted Chaos faults, for example, faulting only certain node
// types or faulting only certain applications.
// If ChaosTargetFilter is not used, Chaos faults all cluster entities. If ChaosTargetFilter is used, Chaos
// faults only the entities that meet the ChaosTargetFilter
// specification. NodeTypeInclusionList and ApplicationInclusionList allow a union semantics only. It is
// not possible to specify an intersection
// of NodeTypeInclusionList and ApplicationInclusionList. For example, it is not possible to specify "fault
// this application only when it is on that node type."
// Once an entity is included in either NodeTypeInclusionList or ApplicationInclusionList, that entity
// cannot be excluded using ChaosTargetFilter. Even if
// applicationX does not appear in ApplicationInclusionList, in some Chaos iteration applicationX can be
// faulted because it happens to be on a node of nodeTypeY that is included
// in NodeTypeInclusionList. If both NodeTypeInclusionList and ApplicationInclusionList are null or empty,
// an ArgumentException is thrown.
type ChaosTargetFilter struct {
	// NodeTypeInclusionList - A list of node types to include in Chaos faults.
	// All types of faults (restart node, restart code package, remove replica, restart replica, move primary, and move secondary) are enabled for the nodes of these node types.
	// If a node type (say NodeTypeX) does not appear in the NodeTypeInclusionList, then node level faults (like NodeRestart) will never be enabled for the nodes of
	// NodeTypeX, but code package and replica faults can still be enabled for NodeTypeX if an application in the ApplicationInclusionList.
	// happens to reside on a node of NodeTypeX.
	// At most 100 node type names can be included in this list, to increase this number, a config upgrade is required for MaxNumberOfNodeTypesInChaosEntityFilter configuration.
	NodeTypeInclusionList *[]string `json:"NodeTypeInclusionList,omitempty"`
	// ApplicationInclusionList - A list of application URIs to include in Chaos faults.
	// All replicas belonging to services of these applications are amenable to replica faults (restart replica, remove replica, move primary, and move secondary) by Chaos.
	// Chaos may restart a code package only if the code package hosts replicas of these applications only.
	// If an application does not appear in this list, it can still be faulted in some Chaos iteration if the application ends up on a node of a node type that is included in NodeTypeInclusionList.
	// However, if applicationX is tied to nodeTypeY through placement constraints and applicationX is absent from ApplicationInclusionList and nodeTypeY is absent from NodeTypeInclusionList, then applicationX will never be faulted.
	// At most 1000 application names can be included in this list, to increase this number, a config upgrade is required for MaxNumberOfApplicationsInChaosEntityFilter configuration.
	ApplicationInclusionList *[]string `json:"ApplicationInclusionList,omitempty"`
}

// CheckExistsPropertyBatchOperation represents a PropertyBatchOperation that compares the Boolean
// existence of a property with the Exists argument.
// The PropertyBatchOperation operation fails if the property's existence is not equal to the Exists
// argument.
// The CheckExistsPropertyBatchOperation is generally used as a precondition for the write operations in
// the batch.
// Note that if one PropertyBatchOperation in a PropertyBatch fails,
// the entire batch fails and cannot be committed in a transactional manner.
type CheckExistsPropertyBatchOperation struct {
	// Exists - Whether or not the property should exist for the operation to pass.
	Exists *bool `json:"Exists,omitempty"`
	// PropertyName - The name of the Service Fabric property.
	PropertyName *string `json:"PropertyName,omitempty"`
	// Kind - Possible values include: 'KindPropertyBatchOperation', 'KindCheckExists', 'KindCheckSequence', 'KindCheckValue', 'KindDelete', 'KindGet', 'KindPut'
	Kind KindBasicPropertyBatchOperation `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for CheckExistsPropertyBatchOperation.
func (cepbo CheckExistsPropertyBatchOperation) MarshalJSON() ([]byte, error) {
	cepbo.Kind = KindCheckExists
	objectMap := make(map[string]interface{})
	if cepbo.Exists != nil {
		objectMap["Exists"] = cepbo.Exists
	}
	if cepbo.PropertyName != nil {
		objectMap["PropertyName"] = cepbo.PropertyName
	}
	if cepbo.Kind != "" {
		objectMap["Kind"] = cepbo.Kind
	}
	return json.Marshal(objectMap)
}

// AsCheckExistsPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckExistsPropertyBatchOperation.
func (cepbo CheckExistsPropertyBatchOperation) AsCheckExistsPropertyBatchOperation() (*CheckExistsPropertyBatchOperation, bool) {
	return &cepbo, true
}

// AsCheckSequencePropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckExistsPropertyBatchOperation.
func (cepbo CheckExistsPropertyBatchOperation) AsCheckSequencePropertyBatchOperation() (*CheckSequencePropertyBatchOperation, bool) {
	return nil, false
}

// AsCheckValuePropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckExistsPropertyBatchOperation.
func (cepbo CheckExistsPropertyBatchOperation) AsCheckValuePropertyBatchOperation() (*CheckValuePropertyBatchOperation, bool) {
	return nil, false
}

// AsDeletePropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckExistsPropertyBatchOperation.
func (cepbo CheckExistsPropertyBatchOperation) AsDeletePropertyBatchOperation() (*DeletePropertyBatchOperation, bool) {
	return nil, false
}

// AsGetPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckExistsPropertyBatchOperation.
func (cepbo CheckExistsPropertyBatchOperation) AsGetPropertyBatchOperation() (*GetPropertyBatchOperation, bool) {
	return nil, false
}

// AsPutPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckExistsPropertyBatchOperation.
func (cepbo CheckExistsPropertyBatchOperation) AsPutPropertyBatchOperation() (*PutPropertyBatchOperation, bool) {
	return nil, false
}

// AsPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckExistsPropertyBatchOperation.
func (cepbo CheckExistsPropertyBatchOperation) AsPropertyBatchOperation() (*PropertyBatchOperation, bool) {
	return nil, false
}

// AsBasicPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckExistsPropertyBatchOperation.
func (cepbo CheckExistsPropertyBatchOperation) AsBasicPropertyBatchOperation() (BasicPropertyBatchOperation, bool) {
	return &cepbo, true
}

// CheckSequencePropertyBatchOperation compares the Sequence Number of a property with the SequenceNumber
// argument.
// A property's sequence number can be thought of as that property's version.
// Every time the property is modified, its sequence number is increased.
// The sequence number can be found in a property's metadata.
// The comparison fails if the sequence numbers are not equal.
// CheckSequencePropertyBatchOperation is generally used as a precondition for the write operations in the
// batch.
// Note that if one PropertyBatchOperation in a PropertyBatch fails,
// the entire batch fails and cannot be committed in a transactional manner.
type CheckSequencePropertyBatchOperation struct {
	// SequenceNumber - The expected sequence number.
	SequenceNumber *string `json:"SequenceNumber,omitempty"`
	// PropertyName - The name of the Service Fabric property.
	PropertyName *string `json:"PropertyName,omitempty"`
	// Kind - Possible values include: 'KindPropertyBatchOperation', 'KindCheckExists', 'KindCheckSequence', 'KindCheckValue', 'KindDelete', 'KindGet', 'KindPut'
	Kind KindBasicPropertyBatchOperation `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for CheckSequencePropertyBatchOperation.
func (cspbo CheckSequencePropertyBatchOperation) MarshalJSON() ([]byte, error) {
	cspbo.Kind = KindCheckSequence
	objectMap := make(map[string]interface{})
	if cspbo.SequenceNumber != nil {
		objectMap["SequenceNumber"] = cspbo.SequenceNumber
	}
	if cspbo.PropertyName != nil {
		objectMap["PropertyName"] = cspbo.PropertyName
	}
	if cspbo.Kind != "" {
		objectMap["Kind"] = cspbo.Kind
	}
	return json.Marshal(objectMap)
}

// AsCheckExistsPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckSequencePropertyBatchOperation.
func (cspbo CheckSequencePropertyBatchOperation) AsCheckExistsPropertyBatchOperation() (*CheckExistsPropertyBatchOperation, bool) {
	return nil, false
}

// AsCheckSequencePropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckSequencePropertyBatchOperation.
func (cspbo CheckSequencePropertyBatchOperation) AsCheckSequencePropertyBatchOperation() (*CheckSequencePropertyBatchOperation, bool) {
	return &cspbo, true
}

// AsCheckValuePropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckSequencePropertyBatchOperation.
func (cspbo CheckSequencePropertyBatchOperation) AsCheckValuePropertyBatchOperation() (*CheckValuePropertyBatchOperation, bool) {
	return nil, false
}

// AsDeletePropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckSequencePropertyBatchOperation.
func (cspbo CheckSequencePropertyBatchOperation) AsDeletePropertyBatchOperation() (*DeletePropertyBatchOperation, bool) {
	return nil, false
}

// AsGetPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckSequencePropertyBatchOperation.
func (cspbo CheckSequencePropertyBatchOperation) AsGetPropertyBatchOperation() (*GetPropertyBatchOperation, bool) {
	return nil, false
}

// AsPutPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckSequencePropertyBatchOperation.
func (cspbo CheckSequencePropertyBatchOperation) AsPutPropertyBatchOperation() (*PutPropertyBatchOperation, bool) {
	return nil, false
}

// AsPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckSequencePropertyBatchOperation.
func (cspbo CheckSequencePropertyBatchOperation) AsPropertyBatchOperation() (*PropertyBatchOperation, bool) {
	return nil, false
}

// AsBasicPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckSequencePropertyBatchOperation.
func (cspbo CheckSequencePropertyBatchOperation) AsBasicPropertyBatchOperation() (BasicPropertyBatchOperation, bool) {
	return &cspbo, true
}

// CheckValuePropertyBatchOperation represents a PropertyBatchOperation that compares the value of the
// property with the expected value.
// The CheckValuePropertyBatchOperation is generally used as a precondition for the write operations in the
// batch.
// Note that if one PropertyBatchOperation in a PropertyBatch fails,
// the entire batch fails and cannot be committed in a transactional manner.
type CheckValuePropertyBatchOperation struct {
	// Value - The expected property value.
	Value BasicPropertyValue `json:"Value,omitempty"`
	// PropertyName - The name of the Service Fabric property.
	PropertyName *string `json:"PropertyName,omitempty"`
	// Kind - Possible values include: 'KindPropertyBatchOperation', 'KindCheckExists', 'KindCheckSequence', 'KindCheckValue', 'KindDelete', 'KindGet', 'KindPut'
	Kind KindBasicPropertyBatchOperation `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for CheckValuePropertyBatchOperation.
func (cvpbo CheckValuePropertyBatchOperation) MarshalJSON() ([]byte, error) {
	cvpbo.Kind = KindCheckValue
	objectMap := make(map[string]interface{})
	objectMap["Value"] = cvpbo.Value
	if cvpbo.PropertyName != nil {
		objectMap["PropertyName"] = cvpbo.PropertyName
	}
	if cvpbo.Kind != "" {
		objectMap["Kind"] = cvpbo.Kind
	}
	return json.Marshal(objectMap)
}

// AsCheckExistsPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckValuePropertyBatchOperation.
func (cvpbo CheckValuePropertyBatchOperation) AsCheckExistsPropertyBatchOperation() (*CheckExistsPropertyBatchOperation, bool) {
	return nil, false
}

// AsCheckSequencePropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckValuePropertyBatchOperation.
func (cvpbo CheckValuePropertyBatchOperation) AsCheckSequencePropertyBatchOperation() (*CheckSequencePropertyBatchOperation, bool) {
	return nil, false
}

// AsCheckValuePropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckValuePropertyBatchOperation.
func (cvpbo CheckValuePropertyBatchOperation) AsCheckValuePropertyBatchOperation() (*CheckValuePropertyBatchOperation, bool) {
	return &cvpbo, true
}

// AsDeletePropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckValuePropertyBatchOperation.
func (cvpbo CheckValuePropertyBatchOperation) AsDeletePropertyBatchOperation() (*DeletePropertyBatchOperation, bool) {
	return nil, false
}

// AsGetPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckValuePropertyBatchOperation.
func (cvpbo CheckValuePropertyBatchOperation) AsGetPropertyBatchOperation() (*GetPropertyBatchOperation, bool) {
	return nil, false
}

// AsPutPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckValuePropertyBatchOperation.
func (cvpbo CheckValuePropertyBatchOperation) AsPutPropertyBatchOperation() (*PutPropertyBatchOperation, bool) {
	return nil, false
}

// AsPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckValuePropertyBatchOperation.
func (cvpbo CheckValuePropertyBatchOperation) AsPropertyBatchOperation() (*PropertyBatchOperation, bool) {
	return nil, false
}

// AsBasicPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckValuePropertyBatchOperation.
func (cvpbo CheckValuePropertyBatchOperation) AsBasicPropertyBatchOperation() (BasicPropertyBatchOperation, bool) {
	return &cvpbo, true
}

// UnmarshalJSON is the custom unmarshaler for CheckValuePropertyBatchOperation struct.
func (cvpbo *CheckValuePropertyBatchOperation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "Value":
			if v != nil {
				value, err := unmarshalBasicPropertyValue(*v)
				if err != nil {
					return err
				}
				cvpbo.Value = value
			}
		case "PropertyName":
			if v != nil {
				var propertyName string
				err = json.Unmarshal(*v, &propertyName)
				if err != nil {
					return err
				}
				cvpbo.PropertyName = &propertyName
			}
		case "Kind":
			if v != nil {
				var kind KindBasicPropertyBatchOperation
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				cvpbo.Kind = kind
			}
		}
	}

	return nil
}

// ClusterConfiguration information about the standalone cluster configuration.
type ClusterConfiguration struct {
	autorest.Response `json:"-"`
	// ClusterConfiguration - The contents of the cluster configuration file.
	ClusterConfiguration *string `json:"ClusterConfiguration,omitempty"`
}

// ClusterConfigurationUpgradeDescription describes the parameters for a standalone cluster configuration
// upgrade.
type ClusterConfigurationUpgradeDescription struct {
	// ClusterConfig - The cluster configuration.
	ClusterConfig *string `json:"ClusterConfig,omitempty"`
	// HealthCheckRetryTimeout - The length of time between attempts to perform a health checks if the application or cluster is not healthy.
	HealthCheckRetryTimeout *string `json:"HealthCheckRetryTimeout,omitempty"`
	// HealthCheckWaitDurationInSeconds - The length of time to wait after completing an upgrade domain before starting the health checks process.
	HealthCheckWaitDurationInSeconds *string `json:"HealthCheckWaitDurationInSeconds,omitempty"`
	// HealthCheckStableDurationInSeconds - The length of time that the application or cluster must remain healthy.
	HealthCheckStableDurationInSeconds *string `json:"HealthCheckStableDurationInSeconds,omitempty"`
	// UpgradeDomainTimeoutInSeconds - The timeout for the upgrade domain.
	UpgradeDomainTimeoutInSeconds *string `json:"UpgradeDomainTimeoutInSeconds,omitempty"`
	// UpgradeTimeoutInSeconds - The upgrade timeout.
	UpgradeTimeoutInSeconds *string `json:"UpgradeTimeoutInSeconds,omitempty"`
	// MaxPercentUnhealthyApplications - The maximum allowed percentage of unhealthy applications during the upgrade. Allowed values are integer values from zero to 100.
	MaxPercentUnhealthyApplications *int32 `json:"MaxPercentUnhealthyApplications,omitempty"`
	// MaxPercentUnhealthyNodes - The maximum allowed percentage of unhealthy nodes during the upgrade. Allowed values are integer values from zero to 100.
	MaxPercentUnhealthyNodes *int32 `json:"MaxPercentUnhealthyNodes,omitempty"`
	// MaxPercentDeltaUnhealthyNodes - The maximum allowed percentage of delta health degradation during the upgrade. Allowed values are integer values from zero to 100.
	MaxPercentDeltaUnhealthyNodes *int32 `json:"MaxPercentDeltaUnhealthyNodes,omitempty"`
	// MaxPercentUpgradeDomainDeltaUnhealthyNodes - The maximum allowed percentage of upgrade domain delta health degradation during the upgrade. Allowed values are integer values from zero to 100.
	MaxPercentUpgradeDomainDeltaUnhealthyNodes *int32 `json:"MaxPercentUpgradeDomainDeltaUnhealthyNodes,omitempty"`
	// ApplicationHealthPolicies - Defines the application health policy map used to evaluate the health of an application or one of its children entities.
	ApplicationHealthPolicies *ApplicationHealthPolicies `json:"ApplicationHealthPolicies,omitempty"`
}

// ClusterConfigurationUpgradeStatusInfo information about a standalone cluster configuration upgrade
// status.
type ClusterConfigurationUpgradeStatusInfo struct {
	autorest.Response `json:"-"`
	// UpgradeState - The state of the upgrade domain. Possible values include: 'UpgradeStateInvalid', 'UpgradeStateRollingBackInProgress', 'UpgradeStateRollingBackCompleted', 'UpgradeStateRollingForwardPending', 'UpgradeStateRollingForwardInProgress', 'UpgradeStateRollingForwardCompleted', 'UpgradeStateFailed'
	UpgradeState UpgradeState `json:"UpgradeState,omitempty"`
	// ProgressStatus - The cluster manifest version.
	ProgressStatus *int32 `json:"ProgressStatus,omitempty"`
	// ConfigVersion - The cluster configuration version.
	ConfigVersion *string `json:"ConfigVersion,omitempty"`
	// Details - The cluster upgrade status details.
	Details *string `json:"Details,omitempty"`
}

// BasicClusterEvent represents the base for all Cluster Events.
type BasicClusterEvent interface {
	AsClusterHealthReportCreatedEvent() (*ClusterHealthReportCreatedEvent, bool)
	AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool)
	AsClusterUpgradeCompleteEvent() (*ClusterUpgradeCompleteEvent, bool)
	AsClusterUpgradeDomainCompleteEvent() (*ClusterUpgradeDomainCompleteEvent, bool)
	AsClusterUpgradeRollbackCompleteEvent() (*ClusterUpgradeRollbackCompleteEvent, bool)
	AsClusterUpgradeRollbackStartEvent() (*ClusterUpgradeRollbackStartEvent, bool)
	AsClusterUpgradeStartEvent() (*ClusterUpgradeStartEvent, bool)
	AsChaosStoppedEvent() (*ChaosStoppedEvent, bool)
	AsChaosStartedEvent() (*ChaosStartedEvent, bool)
	AsClusterEvent() (*ClusterEvent, bool)
}

// ClusterEvent represents the base for all Cluster Events.
type ClusterEvent struct {
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationHealthReportCreated', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeComplete', 'KindApplicationUpgradeDomainComplete', 'KindApplicationUpgradeRollbackComplete', 'KindApplicationUpgradeRollbackStart', 'KindApplicationUpgradeStart', 'KindDeployedApplicationHealthReportCreated', 'KindDeployedApplicationHealthReportExpired', 'KindProcessDeactivated', 'KindContainerDeactivated', 'KindNodeAborted', 'KindNodeAborting', 'KindNodeAdded', 'KindNodeClose', 'KindNodeClosing', 'KindNodeDeactivateComplete', 'KindNodeDeactivateStart', 'KindNodeDown', 'KindNodeHealthReportCreated', 'KindNodeHealthReportExpired', 'KindNodeOpenedSuccess', 'KindNodeOpenFailed', 'KindNodeOpening', 'KindNodeRemoved', 'KindNodeUp', 'KindPartitionHealthReportCreated', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigurationCompleted', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceHealthReportCreated', 'KindServiceHealthReportExpired', 'KindDeployedServiceHealthReportCreated', 'KindDeployedServiceHealthReportExpired', 'KindStatefulReplicaHealthReportCreated', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaHealthReportCreated', 'KindStatelessReplicaHealthReportExpired', 'KindClusterHealthReportCreated', 'KindClusterHealthReportExpired', 'KindClusterUpgradeComplete', 'KindClusterUpgradeDomainComplete', 'KindClusterUpgradeRollbackComplete', 'KindClusterUpgradeRollbackStart', 'KindClusterUpgradeStart', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosRestartNodeFaultCompleted', 'KindChaosRestartCodePackageFaultScheduled', 'KindChaosRestartCodePackageFaultCompleted', 'KindChaosRemoveReplicaFaultScheduled', 'KindChaosRemoveReplicaFaultCompleted', 'KindChaosMoveSecondaryFaultScheduled', 'KindChaosMovePrimaryFaultScheduled', 'KindChaosRestartReplicaFaultScheduled', 'KindChaosRestartNodeFaultScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

func unmarshalBasicClusterEvent(body []byte) (BasicClusterEvent, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["Kind"] {
	case string(KindClusterHealthReportCreated):
		var chrce ClusterHealthReportCreatedEvent
		err := json.Unmarshal(body, &chrce)
		return chrce, err
	case string(KindClusterHealthReportExpired):
		var chree ClusterHealthReportExpiredEvent
		err := json.Unmarshal(body, &chree)
		return chree, err
	case string(KindClusterUpgradeComplete):
		var cuce ClusterUpgradeCompleteEvent
		err := json.Unmarshal(body, &cuce)
		return cuce, err
	case string(KindClusterUpgradeDomainComplete):
		var cudce ClusterUpgradeDomainCompleteEvent
		err := json.Unmarshal(body, &cudce)
		return cudce, err
	case string(KindClusterUpgradeRollbackComplete):
		var curce ClusterUpgradeRollbackCompleteEvent
		err := json.Unmarshal(body, &curce)
		return curce, err
	case string(KindClusterUpgradeRollbackStart):
		var curse ClusterUpgradeRollbackStartEvent
		err := json.Unmarshal(body, &curse)
		return curse, err
	case string(KindClusterUpgradeStart):
		var cuse ClusterUpgradeStartEvent
		err := json.Unmarshal(body, &cuse)
		return cuse, err
	case string(KindChaosStopped):
		var cse ChaosStoppedEvent
		err := json.Unmarshal(body, &cse)
		return cse, err
	case string(KindChaosStarted):
		var cse ChaosStartedEvent
		err := json.Unmarshal(body, &cse)
		return cse, err
	default:
		var ce ClusterEvent
		err := json.Unmarshal(body, &ce)
		return ce, err
	}
}
func unmarshalBasicClusterEventArray(body []byte) ([]BasicClusterEvent, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ceArray := make([]BasicClusterEvent, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ce, err := unmarshalBasicClusterEvent(*rawMessage)
		if err != nil {
			return nil, err
		}
		ceArray[index] = ce
	}
	return ceArray, nil
}

// MarshalJSON is the custom marshaler for ClusterEvent.
func (ce ClusterEvent) MarshalJSON() ([]byte, error) {
	ce.Kind = KindClusterEvent
	objectMap := make(map[string]interface{})
	if ce.EventInstanceID != nil {
		objectMap["EventInstanceId"] = ce.EventInstanceID
	}
	if ce.TimeStamp != nil {
		objectMap["TimeStamp"] = ce.TimeStamp
	}
	if ce.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = ce.HasCorrelatedEvents
	}
	if ce.Kind != "" {
		objectMap["Kind"] = ce.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return nil, false
}

// AsClusterEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return &ce, true
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return &ce, true
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsApplicationHealthReportCreatedEvent() (*ApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompleteEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsApplicationUpgradeCompleteEvent() (*ApplicationUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsApplicationUpgradeDomainCompleteEvent() (*ApplicationUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsApplicationUpgradeRollbackCompleteEvent() (*ApplicationUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsApplicationUpgradeRollbackStartEvent() (*ApplicationUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsApplicationUpgradeStartEvent() (*ApplicationUpgradeStartEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsDeployedApplicationHealthReportCreatedEvent() (*DeployedApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsProcessDeactivatedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsProcessDeactivatedEvent() (*ProcessDeactivatedEvent, bool) {
	return nil, false
}

// AsContainerDeactivatedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsContainerDeactivatedEvent() (*ContainerDeactivatedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAbortingEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsNodeAbortingEvent() (*NodeAbortingEvent, bool) {
	return nil, false
}

// AsNodeAddedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsNodeAddedEvent() (*NodeAddedEvent, bool) {
	return nil, false
}

// AsNodeCloseEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsNodeCloseEvent() (*NodeCloseEvent, bool) {
	return nil, false
}

// AsNodeClosingEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsNodeClosingEvent() (*NodeClosingEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompleteEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsNodeDeactivateCompleteEvent() (*NodeDeactivateCompleteEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsNodeDeactivateStartEvent() (*NodeDeactivateStartEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsNodeHealthReportCreatedEvent() (*NodeHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenedSuccessEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsNodeOpenedSuccessEvent() (*NodeOpenedSuccessEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeOpeningEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsNodeOpeningEvent() (*NodeOpeningEvent, bool) {
	return nil, false
}

// AsNodeRemovedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsNodeRemovedEvent() (*NodeRemovedEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsPartitionHealthReportCreatedEvent() (*PartitionHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfigurationCompletedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsPartitionReconfigurationCompletedEvent() (*PartitionReconfigurationCompletedEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsServiceHealthReportCreatedEvent() (*ServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsDeployedServiceHealthReportCreatedEvent() (*DeployedServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsDeployedServiceHealthReportExpiredEvent() (*DeployedServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsStatefulReplicaHealthReportCreatedEvent() (*StatefulReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsStatelessReplicaHealthReportCreatedEvent() (*StatelessReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsClusterHealthReportCreatedEvent() (*ClusterHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompleteEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsClusterUpgradeCompleteEvent() (*ClusterUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsClusterUpgradeDomainCompleteEvent() (*ClusterUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsClusterUpgradeRollbackCompleteEvent() (*ClusterUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsClusterUpgradeRollbackStartEvent() (*ClusterUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsClusterUpgradeStartEvent() (*ClusterUpgradeStartEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultCompletedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsChaosRestartNodeFaultCompletedEvent() (*ChaosRestartNodeFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultScheduledEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsChaosRestartCodePackageFaultScheduledEvent() (*ChaosRestartCodePackageFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultCompletedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsChaosRestartCodePackageFaultCompletedEvent() (*ChaosRestartCodePackageFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsChaosRemoveReplicaFaultScheduledEvent() (*ChaosRemoveReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultCompletedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsChaosRemoveReplicaFaultCompletedEvent() (*ChaosRemoveReplicaFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosMoveSecondaryFaultScheduledEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsChaosMoveSecondaryFaultScheduledEvent() (*ChaosMoveSecondaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosMovePrimaryFaultScheduledEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsChaosMovePrimaryFaultScheduledEvent() (*ChaosMovePrimaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsChaosRestartReplicaFaultScheduledEvent() (*ChaosRestartReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultScheduledEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsChaosRestartNodeFaultScheduledEvent() (*ChaosRestartNodeFaultScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &ce, true
}

// ClusterHealth represents the health of the cluster.
// Contains the cluster aggregated health state, the cluster application and node health states as well as
// the health events and the unhealthy evaluations.
type ClusterHealth struct {
	autorest.Response `json:"-"`
	// NodeHealthStates - Cluster node health states as found in the health store.
	NodeHealthStates *[]NodeHealthState `json:"NodeHealthStates,omitempty"`
	// ApplicationHealthStates - Cluster application health states as found in the health store.
	ApplicationHealthStates *[]ApplicationHealthState `json:"ApplicationHealthStates,omitempty"`
	// AggregatedHealthState - The HealthState representing the aggregated health state of the entity computed by Health Manager.
	// The health evaluation of the entity reflects all events reported on the entity and its children (if any).
	// The aggregation is done by applying the desired health policy. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
	// HealthEvents - The list of health events reported on the entity.
	HealthEvents *[]HealthEvent `json:"HealthEvents,omitempty"`
	// UnhealthyEvaluations - The unhealthy evaluations that show why the current aggregated health state was returned by Health Manager.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// HealthStatistics - Shows the health statistics for all children types of the queried entity.
	HealthStatistics *HealthStatistics `json:"HealthStatistics,omitempty"`
}

// ClusterHealthChunk represents the health chunk of the cluster.
// Contains the cluster aggregated health state, and the cluster entities that respect the input filter.
type ClusterHealthChunk struct {
	autorest.Response `json:"-"`
	// HealthState - The HealthState representing the aggregated health state of the cluster computed by Health Manager.
	// The health evaluation of the entity reflects all events reported on the entity and its children (if any).
	// The aggregation is done by applying the desired cluster health policy and the application health policies. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	HealthState HealthState `json:"HealthState,omitempty"`
	// NodeHealthStateChunks - The list of node health state chunks in the cluster that respect the filters in the cluster health chunk query description.
	NodeHealthStateChunks *NodeHealthStateChunkList `json:"NodeHealthStateChunks,omitempty"`
	// ApplicationHealthStateChunks - The list of application health state chunks in the cluster that respect the filters in the cluster health chunk query description.
	ApplicationHealthStateChunks *ApplicationHealthStateChunkList `json:"ApplicationHealthStateChunks,omitempty"`
}

// ClusterHealthChunkQueryDescription the cluster health chunk query description, which can specify the
// health policies to evaluate cluster health and very expressive filters to select which cluster entities
// to include in response.
type ClusterHealthChunkQueryDescription struct {
	// NodeFilters - Defines a list of filters that specify which nodes to be included in the returned cluster health chunk.
	// If no filters are specified, no nodes are returned. All the nodes are used to evaluate the cluster's aggregated health state, regardless of the input filters.
	// The cluster health chunk query may specify multiple node filters.
	// For example, it can specify a filter to return all nodes with health state Error and another filter to always include a node identified by its NodeName.
	NodeFilters *[]NodeHealthStateFilter `json:"NodeFilters,omitempty"`
	// ApplicationFilters - Defines a list of filters that specify which applications to be included in the returned cluster health chunk.
	// If no filters are specified, no applications are returned. All the applications are used to evaluate the cluster's aggregated health state, regardless of the input filters.
	// The cluster health chunk query may specify multiple application filters.
	// For example, it can specify a filter to return all applications with health state Error and another filter to always include applications of a specified application type.
	ApplicationFilters *[]ApplicationHealthStateFilter `json:"ApplicationFilters,omitempty"`
	// ClusterHealthPolicy - Defines a health policy used to evaluate the health of the cluster or of a cluster node.
	ClusterHealthPolicy *ClusterHealthPolicy `json:"ClusterHealthPolicy,omitempty"`
	// ApplicationHealthPolicies - Defines the application health policy map used to evaluate the health of an application or one of its children entities.
	ApplicationHealthPolicies *ApplicationHealthPolicies `json:"ApplicationHealthPolicies,omitempty"`
}

// ClusterHealthPolicies health policies to evaluate cluster health.
type ClusterHealthPolicies struct {
	// ApplicationHealthPolicyMap - Defines a map that contains specific application health policies for different applications.
	// Each entry specifies as key the application name and as value an ApplicationHealthPolicy used to evaluate the application health.
	// If an application is not specified in the map, the application health evaluation uses the ApplicationHealthPolicy found in its application manifest or the default application health policy (if no health policy is defined in the manifest).
	// The map is empty by default.
	ApplicationHealthPolicyMap *[]ApplicationHealthPolicyMapItem `json:"ApplicationHealthPolicyMap,omitempty"`
	// ClusterHealthPolicy - Defines a health policy used to evaluate the health of the cluster or of a cluster node.
	ClusterHealthPolicy *ClusterHealthPolicy `json:"ClusterHealthPolicy,omitempty"`
}

// ClusterHealthPolicy defines a health policy used to evaluate the health of the cluster or of a cluster
// node.
type ClusterHealthPolicy struct {
	// ConsiderWarningAsError - Indicates whether warnings are treated with the same severity as errors.
	ConsiderWarningAsError *bool `json:"ConsiderWarningAsError,omitempty"`
	// MaxPercentUnhealthyNodes - The maximum allowed percentage of unhealthy nodes before reporting an error. For example, to allow 10% of nodes to be unhealthy, this value would be 10.
	// The percentage represents the maximum tolerated percentage of nodes that can be unhealthy before the cluster is considered in error.
	// If the percentage is respected but there is at least one unhealthy node, the health is evaluated as Warning.
	// The percentage is calculated by dividing the number of unhealthy nodes over the total number of nodes in the cluster.
	// The computation rounds up to tolerate one failure on small numbers of nodes. Default percentage is zero.
	// In large clusters, some nodes will always be down or out for repairs, so this percentage should be configured to tolerate that.
	MaxPercentUnhealthyNodes *int32 `json:"MaxPercentUnhealthyNodes,omitempty"`
	// MaxPercentUnhealthyApplications - The maximum allowed percentage of unhealthy applications before reporting an error. For example, to allow 10% of applications to be unhealthy, this value would be 10.
	// The percentage represents the maximum tolerated percentage of applications that can be unhealthy before the cluster is considered in error.
	// If the percentage is respected but there is at least one unhealthy application, the health is evaluated as Warning.
	// This is calculated by dividing the number of unhealthy applications over the total number of application instances in the cluster, excluding applications of application types that are included in the ApplicationTypeHealthPolicyMap.
	// The computation rounds up to tolerate one failure on small numbers of applications. Default percentage is zero.
	MaxPercentUnhealthyApplications *int32 `json:"MaxPercentUnhealthyApplications,omitempty"`
	// ApplicationTypeHealthPolicyMap - Defines a map with max percentage unhealthy applications for specific application types.
	// Each entry specifies as key the application type name and as value an integer that represents the MaxPercentUnhealthyApplications percentage used to evaluate the applications of the specified application type.
	// The application type health policy map can be used during cluster health evaluation to describe special application types.
	// The application types included in the map are evaluated against the percentage specified in the map, and not with the global MaxPercentUnhealthyApplications defined in the cluster health policy.
	// The applications of application types specified in the map are not counted against the global pool of applications.
	// For example, if some applications of a type are critical, the cluster administrator can add an entry to the map for that application type
	// and assign it a value of 0% (that is, do not tolerate any failures).
	// All other applications can be evaluated with MaxPercentUnhealthyApplications set to 20% to tolerate some failures out of the thousands of application instances.
	// The application type health policy map is used only if the cluster manifest enables application type health evaluation using the configuration entry for HealthManager/EnableApplicationTypeHealthEvaluation.
	ApplicationTypeHealthPolicyMap *[]ApplicationTypeHealthPolicyMapItem `json:"ApplicationTypeHealthPolicyMap,omitempty"`
}

// ClusterHealthReportCreatedEvent cluster Health Report Created event.
type ClusterHealthReportCreatedEvent struct {
	// SourceID - Id of report source.
	SourceID *string `json:"SourceId,omitempty"`
	// Property - Describes the property.
	Property *string `json:"Property,omitempty"`
	// HealthState - Describes the property health state.
	HealthState *string `json:"HealthState,omitempty"`
	// TimeToLiveMs - Time to live in milli-seconds.
	TimeToLiveMs *int64 `json:"TimeToLiveMs,omitempty"`
	// SequenceNumber - Sequence number of report.
	SequenceNumber *int64 `json:"SequenceNumber,omitempty"`
	// Description - Description of report.
	Description *string `json:"Description,omitempty"`
	// RemoveWhenExpired - Indicates the removal when it expires.
	RemoveWhenExpired *bool `json:"RemoveWhenExpired,omitempty"`
	// SourceUtcTimestamp - Source time.
	SourceUtcTimestamp *date.Time `json:"SourceUtcTimestamp,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationHealthReportCreated', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeComplete', 'KindApplicationUpgradeDomainComplete', 'KindApplicationUpgradeRollbackComplete', 'KindApplicationUpgradeRollbackStart', 'KindApplicationUpgradeStart', 'KindDeployedApplicationHealthReportCreated', 'KindDeployedApplicationHealthReportExpired', 'KindProcessDeactivated', 'KindContainerDeactivated', 'KindNodeAborted', 'KindNodeAborting', 'KindNodeAdded', 'KindNodeClose', 'KindNodeClosing', 'KindNodeDeactivateComplete', 'KindNodeDeactivateStart', 'KindNodeDown', 'KindNodeHealthReportCreated', 'KindNodeHealthReportExpired', 'KindNodeOpenedSuccess', 'KindNodeOpenFailed', 'KindNodeOpening', 'KindNodeRemoved', 'KindNodeUp', 'KindPartitionHealthReportCreated', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigurationCompleted', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceHealthReportCreated', 'KindServiceHealthReportExpired', 'KindDeployedServiceHealthReportCreated', 'KindDeployedServiceHealthReportExpired', 'KindStatefulReplicaHealthReportCreated', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaHealthReportCreated', 'KindStatelessReplicaHealthReportExpired', 'KindClusterHealthReportCreated', 'KindClusterHealthReportExpired', 'KindClusterUpgradeComplete', 'KindClusterUpgradeDomainComplete', 'KindClusterUpgradeRollbackComplete', 'KindClusterUpgradeRollbackStart', 'KindClusterUpgradeStart', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosRestartNodeFaultCompleted', 'KindChaosRestartCodePackageFaultScheduled', 'KindChaosRestartCodePackageFaultCompleted', 'KindChaosRemoveReplicaFaultScheduled', 'KindChaosRemoveReplicaFaultCompleted', 'KindChaosMoveSecondaryFaultScheduled', 'KindChaosMovePrimaryFaultScheduled', 'KindChaosRestartReplicaFaultScheduled', 'KindChaosRestartNodeFaultScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) MarshalJSON() ([]byte, error) {
	chrce.Kind = KindClusterHealthReportCreated
	objectMap := make(map[string]interface{})
	if chrce.SourceID != nil {
		objectMap["SourceId"] = chrce.SourceID
	}
	if chrce.Property != nil {
		objectMap["Property"] = chrce.Property
	}
	if chrce.HealthState != nil {
		objectMap["HealthState"] = chrce.HealthState
	}
	if chrce.TimeToLiveMs != nil {
		objectMap["TimeToLiveMs"] = chrce.TimeToLiveMs
	}
	if chrce.SequenceNumber != nil {
		objectMap["SequenceNumber"] = chrce.SequenceNumber
	}
	if chrce.Description != nil {
		objectMap["Description"] = chrce.Description
	}
	if chrce.RemoveWhenExpired != nil {
		objectMap["RemoveWhenExpired"] = chrce.RemoveWhenExpired
	}
	if chrce.SourceUtcTimestamp != nil {
		objectMap["SourceUtcTimestamp"] = chrce.SourceUtcTimestamp
	}
	if chrce.EventInstanceID != nil {
		objectMap["EventInstanceId"] = chrce.EventInstanceID
	}
	if chrce.TimeStamp != nil {
		objectMap["TimeStamp"] = chrce.TimeStamp
	}
	if chrce.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = chrce.HasCorrelatedEvents
	}
	if chrce.Kind != "" {
		objectMap["Kind"] = chrce.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return nil, false
}

// AsClusterEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return &chrce, true
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsApplicationHealthReportCreatedEvent() (*ApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompleteEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsApplicationUpgradeCompleteEvent() (*ApplicationUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsApplicationUpgradeDomainCompleteEvent() (*ApplicationUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsApplicationUpgradeRollbackCompleteEvent() (*ApplicationUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsApplicationUpgradeRollbackStartEvent() (*ApplicationUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsApplicationUpgradeStartEvent() (*ApplicationUpgradeStartEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsDeployedApplicationHealthReportCreatedEvent() (*DeployedApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsProcessDeactivatedEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsProcessDeactivatedEvent() (*ProcessDeactivatedEvent, bool) {
	return nil, false
}

// AsContainerDeactivatedEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsContainerDeactivatedEvent() (*ContainerDeactivatedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAbortingEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsNodeAbortingEvent() (*NodeAbortingEvent, bool) {
	return nil, false
}

// AsNodeAddedEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsNodeAddedEvent() (*NodeAddedEvent, bool) {
	return nil, false
}

// AsNodeCloseEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsNodeCloseEvent() (*NodeCloseEvent, bool) {
	return nil, false
}

// AsNodeClosingEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsNodeClosingEvent() (*NodeClosingEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompleteEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsNodeDeactivateCompleteEvent() (*NodeDeactivateCompleteEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsNodeDeactivateStartEvent() (*NodeDeactivateStartEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsNodeHealthReportCreatedEvent() (*NodeHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenedSuccessEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsNodeOpenedSuccessEvent() (*NodeOpenedSuccessEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeOpeningEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsNodeOpeningEvent() (*NodeOpeningEvent, bool) {
	return nil, false
}

// AsNodeRemovedEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsNodeRemovedEvent() (*NodeRemovedEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsPartitionHealthReportCreatedEvent() (*PartitionHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfigurationCompletedEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsPartitionReconfigurationCompletedEvent() (*PartitionReconfigurationCompletedEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsServiceHealthReportCreatedEvent() (*ServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsDeployedServiceHealthReportCreatedEvent() (*DeployedServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsDeployedServiceHealthReportExpiredEvent() (*DeployedServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsStatefulReplicaHealthReportCreatedEvent() (*StatefulReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsStatelessReplicaHealthReportCreatedEvent() (*StatelessReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsClusterHealthReportCreatedEvent() (*ClusterHealthReportCreatedEvent, bool) {
	return &chrce, true
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompleteEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsClusterUpgradeCompleteEvent() (*ClusterUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsClusterUpgradeDomainCompleteEvent() (*ClusterUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsClusterUpgradeRollbackCompleteEvent() (*ClusterUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsClusterUpgradeRollbackStartEvent() (*ClusterUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsClusterUpgradeStartEvent() (*ClusterUpgradeStartEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultCompletedEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsChaosRestartNodeFaultCompletedEvent() (*ChaosRestartNodeFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultScheduledEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsChaosRestartCodePackageFaultScheduledEvent() (*ChaosRestartCodePackageFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultCompletedEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsChaosRestartCodePackageFaultCompletedEvent() (*ChaosRestartCodePackageFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsChaosRemoveReplicaFaultScheduledEvent() (*ChaosRemoveReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultCompletedEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsChaosRemoveReplicaFaultCompletedEvent() (*ChaosRemoveReplicaFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosMoveSecondaryFaultScheduledEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsChaosMoveSecondaryFaultScheduledEvent() (*ChaosMoveSecondaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosMovePrimaryFaultScheduledEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsChaosMovePrimaryFaultScheduledEvent() (*ChaosMovePrimaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsChaosRestartReplicaFaultScheduledEvent() (*ChaosRestartReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultScheduledEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsChaosRestartNodeFaultScheduledEvent() (*ChaosRestartNodeFaultScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ClusterHealthReportCreatedEvent.
func (chrce ClusterHealthReportCreatedEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &chrce, true
}

// ClusterHealthReportExpiredEvent cluster Health Report Expired event.
type ClusterHealthReportExpiredEvent struct {
	// SourceID - Id of report source.
	SourceID *string `json:"SourceId,omitempty"`
	// Property - Describes the property.
	Property *string `json:"Property,omitempty"`
	// HealthState - Describes the property health state.
	HealthState *string `json:"HealthState,omitempty"`
	// TimeToLiveMs - Time to live in milli-seconds.
	TimeToLiveMs *int64 `json:"TimeToLiveMs,omitempty"`
	// SequenceNumber - Sequence number of report.
	SequenceNumber *int64 `json:"SequenceNumber,omitempty"`
	// Description - Description of report.
	Description *string `json:"Description,omitempty"`
	// RemoveWhenExpired - Indicates the removal when it expires.
	RemoveWhenExpired *bool `json:"RemoveWhenExpired,omitempty"`
	// SourceUtcTimestamp - Source time.
	SourceUtcTimestamp *date.Time `json:"SourceUtcTimestamp,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationHealthReportCreated', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeComplete', 'KindApplicationUpgradeDomainComplete', 'KindApplicationUpgradeRollbackComplete', 'KindApplicationUpgradeRollbackStart', 'KindApplicationUpgradeStart', 'KindDeployedApplicationHealthReportCreated', 'KindDeployedApplicationHealthReportExpired', 'KindProcessDeactivated', 'KindContainerDeactivated', 'KindNodeAborted', 'KindNodeAborting', 'KindNodeAdded', 'KindNodeClose', 'KindNodeClosing', 'KindNodeDeactivateComplete', 'KindNodeDeactivateStart', 'KindNodeDown', 'KindNodeHealthReportCreated', 'KindNodeHealthReportExpired', 'KindNodeOpenedSuccess', 'KindNodeOpenFailed', 'KindNodeOpening', 'KindNodeRemoved', 'KindNodeUp', 'KindPartitionHealthReportCreated', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigurationCompleted', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceHealthReportCreated', 'KindServiceHealthReportExpired', 'KindDeployedServiceHealthReportCreated', 'KindDeployedServiceHealthReportExpired', 'KindStatefulReplicaHealthReportCreated', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaHealthReportCreated', 'KindStatelessReplicaHealthReportExpired', 'KindClusterHealthReportCreated', 'KindClusterHealthReportExpired', 'KindClusterUpgradeComplete', 'KindClusterUpgradeDomainComplete', 'KindClusterUpgradeRollbackComplete', 'KindClusterUpgradeRollbackStart', 'KindClusterUpgradeStart', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosRestartNodeFaultCompleted', 'KindChaosRestartCodePackageFaultScheduled', 'KindChaosRestartCodePackageFaultCompleted', 'KindChaosRemoveReplicaFaultScheduled', 'KindChaosRemoveReplicaFaultCompleted', 'KindChaosMoveSecondaryFaultScheduled', 'KindChaosMovePrimaryFaultScheduled', 'KindChaosRestartReplicaFaultScheduled', 'KindChaosRestartNodeFaultScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) MarshalJSON() ([]byte, error) {
	chree.Kind = KindClusterHealthReportExpired
	objectMap := make(map[string]interface{})
	if chree.SourceID != nil {
		objectMap["SourceId"] = chree.SourceID
	}
	if chree.Property != nil {
		objectMap["Property"] = chree.Property
	}
	if chree.HealthState != nil {
		objectMap["HealthState"] = chree.HealthState
	}
	if chree.TimeToLiveMs != nil {
		objectMap["TimeToLiveMs"] = chree.TimeToLiveMs
	}
	if chree.SequenceNumber != nil {
		objectMap["SequenceNumber"] = chree.SequenceNumber
	}
	if chree.Description != nil {
		objectMap["Description"] = chree.Description
	}
	if chree.RemoveWhenExpired != nil {
		objectMap["RemoveWhenExpired"] = chree.RemoveWhenExpired
	}
	if chree.SourceUtcTimestamp != nil {
		objectMap["SourceUtcTimestamp"] = chree.SourceUtcTimestamp
	}
	if chree.EventInstanceID != nil {
		objectMap["EventInstanceId"] = chree.EventInstanceID
	}
	if chree.TimeStamp != nil {
		objectMap["TimeStamp"] = chree.TimeStamp
	}
	if chree.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = chree.HasCorrelatedEvents
	}
	if chree.Kind != "" {
		objectMap["Kind"] = chree.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return nil, false
}

// AsClusterEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return &chree, true
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsApplicationHealthReportCreatedEvent() (*ApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompleteEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsApplicationUpgradeCompleteEvent() (*ApplicationUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsApplicationUpgradeDomainCompleteEvent() (*ApplicationUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsApplicationUpgradeRollbackCompleteEvent() (*ApplicationUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsApplicationUpgradeRollbackStartEvent() (*ApplicationUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsApplicationUpgradeStartEvent() (*ApplicationUpgradeStartEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsDeployedApplicationHealthReportCreatedEvent() (*DeployedApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsProcessDeactivatedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsProcessDeactivatedEvent() (*ProcessDeactivatedEvent, bool) {
	return nil, false
}

// AsContainerDeactivatedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsContainerDeactivatedEvent() (*ContainerDeactivatedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAbortingEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsNodeAbortingEvent() (*NodeAbortingEvent, bool) {
	return nil, false
}

// AsNodeAddedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsNodeAddedEvent() (*NodeAddedEvent, bool) {
	return nil, false
}

// AsNodeCloseEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsNodeCloseEvent() (*NodeCloseEvent, bool) {
	return nil, false
}

// AsNodeClosingEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsNodeClosingEvent() (*NodeClosingEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompleteEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsNodeDeactivateCompleteEvent() (*NodeDeactivateCompleteEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsNodeDeactivateStartEvent() (*NodeDeactivateStartEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsNodeHealthReportCreatedEvent() (*NodeHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenedSuccessEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsNodeOpenedSuccessEvent() (*NodeOpenedSuccessEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeOpeningEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsNodeOpeningEvent() (*NodeOpeningEvent, bool) {
	return nil, false
}

// AsNodeRemovedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsNodeRemovedEvent() (*NodeRemovedEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsPartitionHealthReportCreatedEvent() (*PartitionHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfigurationCompletedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsPartitionReconfigurationCompletedEvent() (*PartitionReconfigurationCompletedEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsServiceHealthReportCreatedEvent() (*ServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsDeployedServiceHealthReportCreatedEvent() (*DeployedServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsDeployedServiceHealthReportExpiredEvent() (*DeployedServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsStatefulReplicaHealthReportCreatedEvent() (*StatefulReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsStatelessReplicaHealthReportCreatedEvent() (*StatelessReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsClusterHealthReportCreatedEvent() (*ClusterHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return &chree, true
}

// AsClusterUpgradeCompleteEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsClusterUpgradeCompleteEvent() (*ClusterUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsClusterUpgradeDomainCompleteEvent() (*ClusterUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsClusterUpgradeRollbackCompleteEvent() (*ClusterUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsClusterUpgradeRollbackStartEvent() (*ClusterUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsClusterUpgradeStartEvent() (*ClusterUpgradeStartEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultCompletedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsChaosRestartNodeFaultCompletedEvent() (*ChaosRestartNodeFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultScheduledEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsChaosRestartCodePackageFaultScheduledEvent() (*ChaosRestartCodePackageFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultCompletedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsChaosRestartCodePackageFaultCompletedEvent() (*ChaosRestartCodePackageFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsChaosRemoveReplicaFaultScheduledEvent() (*ChaosRemoveReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultCompletedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsChaosRemoveReplicaFaultCompletedEvent() (*ChaosRemoveReplicaFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosMoveSecondaryFaultScheduledEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsChaosMoveSecondaryFaultScheduledEvent() (*ChaosMoveSecondaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosMovePrimaryFaultScheduledEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsChaosMovePrimaryFaultScheduledEvent() (*ChaosMovePrimaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsChaosRestartReplicaFaultScheduledEvent() (*ChaosRestartReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultScheduledEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsChaosRestartNodeFaultScheduledEvent() (*ChaosRestartNodeFaultScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &chree, true
}

// ClusterManifest information about the cluster manifest.
type ClusterManifest struct {
	autorest.Response `json:"-"`
	// Manifest - The contents of the cluster manifest file.
	Manifest *string `json:"Manifest,omitempty"`
}

// ClusterUpgradeCompleteEvent cluster Upgrade Complete event.
type ClusterUpgradeCompleteEvent struct {
	// TargetClusterVersion - Target Cluster version.
	TargetClusterVersion *string `json:"TargetClusterVersion,omitempty"`
	// OverallUpgradeElapsedTimeInMs - Overall duration of upgrade in milli-seconds.
	OverallUpgradeElapsedTimeInMs *float64 `json:"OverallUpgradeElapsedTimeInMs,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationHealthReportCreated', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeComplete', 'KindApplicationUpgradeDomainComplete', 'KindApplicationUpgradeRollbackComplete', 'KindApplicationUpgradeRollbackStart', 'KindApplicationUpgradeStart', 'KindDeployedApplicationHealthReportCreated', 'KindDeployedApplicationHealthReportExpired', 'KindProcessDeactivated', 'KindContainerDeactivated', 'KindNodeAborted', 'KindNodeAborting', 'KindNodeAdded', 'KindNodeClose', 'KindNodeClosing', 'KindNodeDeactivateComplete', 'KindNodeDeactivateStart', 'KindNodeDown', 'KindNodeHealthReportCreated', 'KindNodeHealthReportExpired', 'KindNodeOpenedSuccess', 'KindNodeOpenFailed', 'KindNodeOpening', 'KindNodeRemoved', 'KindNodeUp', 'KindPartitionHealthReportCreated', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigurationCompleted', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceHealthReportCreated', 'KindServiceHealthReportExpired', 'KindDeployedServiceHealthReportCreated', 'KindDeployedServiceHealthReportExpired', 'KindStatefulReplicaHealthReportCreated', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaHealthReportCreated', 'KindStatelessReplicaHealthReportExpired', 'KindClusterHealthReportCreated', 'KindClusterHealthReportExpired', 'KindClusterUpgradeComplete', 'KindClusterUpgradeDomainComplete', 'KindClusterUpgradeRollbackComplete', 'KindClusterUpgradeRollbackStart', 'KindClusterUpgradeStart', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosRestartNodeFaultCompleted', 'KindChaosRestartCodePackageFaultScheduled', 'KindChaosRestartCodePackageFaultCompleted', 'KindChaosRemoveReplicaFaultScheduled', 'KindChaosRemoveReplicaFaultCompleted', 'KindChaosMoveSecondaryFaultScheduled', 'KindChaosMovePrimaryFaultScheduled', 'KindChaosRestartReplicaFaultScheduled', 'KindChaosRestartNodeFaultScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) MarshalJSON() ([]byte, error) {
	cuce.Kind = KindClusterUpgradeComplete
	objectMap := make(map[string]interface{})
	if cuce.TargetClusterVersion != nil {
		objectMap["TargetClusterVersion"] = cuce.TargetClusterVersion
	}
	if cuce.OverallUpgradeElapsedTimeInMs != nil {
		objectMap["OverallUpgradeElapsedTimeInMs"] = cuce.OverallUpgradeElapsedTimeInMs
	}
	if cuce.EventInstanceID != nil {
		objectMap["EventInstanceId"] = cuce.EventInstanceID
	}
	if cuce.TimeStamp != nil {
		objectMap["TimeStamp"] = cuce.TimeStamp
	}
	if cuce.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = cuce.HasCorrelatedEvents
	}
	if cuce.Kind != "" {
		objectMap["Kind"] = cuce.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return nil, false
}

// AsClusterEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return &cuce, true
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsApplicationHealthReportCreatedEvent() (*ApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompleteEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsApplicationUpgradeCompleteEvent() (*ApplicationUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsApplicationUpgradeDomainCompleteEvent() (*ApplicationUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsApplicationUpgradeRollbackCompleteEvent() (*ApplicationUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsApplicationUpgradeRollbackStartEvent() (*ApplicationUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsApplicationUpgradeStartEvent() (*ApplicationUpgradeStartEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsDeployedApplicationHealthReportCreatedEvent() (*DeployedApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsProcessDeactivatedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsProcessDeactivatedEvent() (*ProcessDeactivatedEvent, bool) {
	return nil, false
}

// AsContainerDeactivatedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsContainerDeactivatedEvent() (*ContainerDeactivatedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAbortingEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsNodeAbortingEvent() (*NodeAbortingEvent, bool) {
	return nil, false
}

// AsNodeAddedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsNodeAddedEvent() (*NodeAddedEvent, bool) {
	return nil, false
}

// AsNodeCloseEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsNodeCloseEvent() (*NodeCloseEvent, bool) {
	return nil, false
}

// AsNodeClosingEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsNodeClosingEvent() (*NodeClosingEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompleteEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsNodeDeactivateCompleteEvent() (*NodeDeactivateCompleteEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsNodeDeactivateStartEvent() (*NodeDeactivateStartEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsNodeHealthReportCreatedEvent() (*NodeHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenedSuccessEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsNodeOpenedSuccessEvent() (*NodeOpenedSuccessEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeOpeningEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsNodeOpeningEvent() (*NodeOpeningEvent, bool) {
	return nil, false
}

// AsNodeRemovedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsNodeRemovedEvent() (*NodeRemovedEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsPartitionHealthReportCreatedEvent() (*PartitionHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfigurationCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsPartitionReconfigurationCompletedEvent() (*PartitionReconfigurationCompletedEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsServiceHealthReportCreatedEvent() (*ServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsDeployedServiceHealthReportCreatedEvent() (*DeployedServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsDeployedServiceHealthReportExpiredEvent() (*DeployedServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsStatefulReplicaHealthReportCreatedEvent() (*StatefulReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsStatelessReplicaHealthReportCreatedEvent() (*StatelessReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsClusterHealthReportCreatedEvent() (*ClusterHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompleteEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsClusterUpgradeCompleteEvent() (*ClusterUpgradeCompleteEvent, bool) {
	return &cuce, true
}

// AsClusterUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsClusterUpgradeDomainCompleteEvent() (*ClusterUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsClusterUpgradeRollbackCompleteEvent() (*ClusterUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsClusterUpgradeRollbackStartEvent() (*ClusterUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsClusterUpgradeStartEvent() (*ClusterUpgradeStartEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsChaosRestartNodeFaultCompletedEvent() (*ChaosRestartNodeFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsChaosRestartCodePackageFaultScheduledEvent() (*ChaosRestartCodePackageFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsChaosRestartCodePackageFaultCompletedEvent() (*ChaosRestartCodePackageFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsChaosRemoveReplicaFaultScheduledEvent() (*ChaosRemoveReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsChaosRemoveReplicaFaultCompletedEvent() (*ChaosRemoveReplicaFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosMoveSecondaryFaultScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsChaosMoveSecondaryFaultScheduledEvent() (*ChaosMoveSecondaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosMovePrimaryFaultScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsChaosMovePrimaryFaultScheduledEvent() (*ChaosMovePrimaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsChaosRestartReplicaFaultScheduledEvent() (*ChaosRestartReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsChaosRestartNodeFaultScheduledEvent() (*ChaosRestartNodeFaultScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ClusterUpgradeCompleteEvent.
func (cuce ClusterUpgradeCompleteEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &cuce, true
}

// ClusterUpgradeDescriptionObject represents a ServiceFabric cluster upgrade
type ClusterUpgradeDescriptionObject struct {
	// ConfigVersion - The cluster configuration version (specified in the cluster manifest).
	ConfigVersion *string `json:"ConfigVersion,omitempty"`
	// CodeVersion - The ServiceFabric code version of the cluster.
	CodeVersion *string `json:"CodeVersion,omitempty"`
	// UpgradeKind - The kind of upgrade out of the following possible values. Possible values include: 'UpgradeKindInvalid', 'UpgradeKindRolling'
	UpgradeKind UpgradeKind `json:"UpgradeKind,omitempty"`
	// RollingUpgradeMode - The mode used to monitor health during a rolling upgrade. The values are UnmonitoredAuto, UnmonitoredManual, and Monitored. Possible values include: 'UpgradeModeInvalid', 'UpgradeModeUnmonitoredAuto', 'UpgradeModeUnmonitoredManual', 'UpgradeModeMonitored'
	RollingUpgradeMode UpgradeMode `json:"RollingUpgradeMode,omitempty"`
	// UpgradeReplicaSetCheckTimeoutInSeconds - The maximum amount of time to block processing of an upgrade domain and prevent loss of availability when there are unexpected issues. When this timeout expires, processing of the upgrade domain will proceed regardless of availability loss issues. The timeout is reset at the start of each upgrade domain. Valid values are between 0 and 42949672925 inclusive. (unsigned 32-bit integer).
	UpgradeReplicaSetCheckTimeoutInSeconds *int64 `json:"UpgradeReplicaSetCheckTimeoutInSeconds,omitempty"`
	// ForceRestart - If true, then processes are forcefully restarted during upgrade even when the code version has not changed (the upgrade only changes configuration or data).
	ForceRestart *bool `json:"ForceRestart,omitempty"`
	// EnableDeltaHealthEvaluation - When true, enables delta health evaluation rather than absolute health evaluation after completion of each upgrade domain.
	EnableDeltaHealthEvaluation *bool `json:"EnableDeltaHealthEvaluation,omitempty"`
	// MonitoringPolicy - Describes the parameters for monitoring an upgrade in Monitored mode.
	MonitoringPolicy *MonitoringPolicyDescription `json:"MonitoringPolicy,omitempty"`
	// ClusterHealthPolicy - Defines a health policy used to evaluate the health of the cluster or of a cluster node.
	ClusterHealthPolicy *ClusterHealthPolicy `json:"ClusterHealthPolicy,omitempty"`
	// ClusterUpgradeHealthPolicy - Defines a health policy used to evaluate the health of the cluster during a cluster upgrade.
	ClusterUpgradeHealthPolicy *ClusterUpgradeHealthPolicyObject `json:"ClusterUpgradeHealthPolicy,omitempty"`
	// ApplicationHealthPolicyMap - Defines a map that contains specific application health policies for different applications.
	// Each entry specifies as key the application name and as value an ApplicationHealthPolicy used to evaluate the application health.
	// If an application is not specified in the map, the application health evaluation uses the ApplicationHealthPolicy found in its application manifest or the default application health policy (if no health policy is defined in the manifest).
	// The map is empty by default.
	ApplicationHealthPolicyMap *[]ApplicationHealthPolicyMapItem `json:"ApplicationHealthPolicyMap,omitempty"`
}

// ClusterUpgradeDomainCompleteEvent cluster Upgrade Domain Complete event.
type ClusterUpgradeDomainCompleteEvent struct {
	// TargetClusterVersion - Target Cluster version.
	TargetClusterVersion *string `json:"TargetClusterVersion,omitempty"`
	// UpgradeState - State of upgrade.
	UpgradeState *string `json:"UpgradeState,omitempty"`
	// UpgradeDomains - Upgrade domains.
	UpgradeDomains *string `json:"UpgradeDomains,omitempty"`
	// UpgradeDomainElapsedTimeInMs - Duration of domain upgrade in milli-seconds.
	UpgradeDomainElapsedTimeInMs *float64 `json:"UpgradeDomainElapsedTimeInMs,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationHealthReportCreated', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeComplete', 'KindApplicationUpgradeDomainComplete', 'KindApplicationUpgradeRollbackComplete', 'KindApplicationUpgradeRollbackStart', 'KindApplicationUpgradeStart', 'KindDeployedApplicationHealthReportCreated', 'KindDeployedApplicationHealthReportExpired', 'KindProcessDeactivated', 'KindContainerDeactivated', 'KindNodeAborted', 'KindNodeAborting', 'KindNodeAdded', 'KindNodeClose', 'KindNodeClosing', 'KindNodeDeactivateComplete', 'KindNodeDeactivateStart', 'KindNodeDown', 'KindNodeHealthReportCreated', 'KindNodeHealthReportExpired', 'KindNodeOpenedSuccess', 'KindNodeOpenFailed', 'KindNodeOpening', 'KindNodeRemoved', 'KindNodeUp', 'KindPartitionHealthReportCreated', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigurationCompleted', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceHealthReportCreated', 'KindServiceHealthReportExpired', 'KindDeployedServiceHealthReportCreated', 'KindDeployedServiceHealthReportExpired', 'KindStatefulReplicaHealthReportCreated', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaHealthReportCreated', 'KindStatelessReplicaHealthReportExpired', 'KindClusterHealthReportCreated', 'KindClusterHealthReportExpired', 'KindClusterUpgradeComplete', 'KindClusterUpgradeDomainComplete', 'KindClusterUpgradeRollbackComplete', 'KindClusterUpgradeRollbackStart', 'KindClusterUpgradeStart', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosRestartNodeFaultCompleted', 'KindChaosRestartCodePackageFaultScheduled', 'KindChaosRestartCodePackageFaultCompleted', 'KindChaosRemoveReplicaFaultScheduled', 'KindChaosRemoveReplicaFaultCompleted', 'KindChaosMoveSecondaryFaultScheduled', 'KindChaosMovePrimaryFaultScheduled', 'KindChaosRestartReplicaFaultScheduled', 'KindChaosRestartNodeFaultScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) MarshalJSON() ([]byte, error) {
	cudce.Kind = KindClusterUpgradeDomainComplete
	objectMap := make(map[string]interface{})
	if cudce.TargetClusterVersion != nil {
		objectMap["TargetClusterVersion"] = cudce.TargetClusterVersion
	}
	if cudce.UpgradeState != nil {
		objectMap["UpgradeState"] = cudce.UpgradeState
	}
	if cudce.UpgradeDomains != nil {
		objectMap["UpgradeDomains"] = cudce.UpgradeDomains
	}
	if cudce.UpgradeDomainElapsedTimeInMs != nil {
		objectMap["UpgradeDomainElapsedTimeInMs"] = cudce.UpgradeDomainElapsedTimeInMs
	}
	if cudce.EventInstanceID != nil {
		objectMap["EventInstanceId"] = cudce.EventInstanceID
	}
	if cudce.TimeStamp != nil {
		objectMap["TimeStamp"] = cudce.TimeStamp
	}
	if cudce.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = cudce.HasCorrelatedEvents
	}
	if cudce.Kind != "" {
		objectMap["Kind"] = cudce.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return nil, false
}

// AsClusterEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return &cudce, true
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsApplicationHealthReportCreatedEvent() (*ApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompleteEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsApplicationUpgradeCompleteEvent() (*ApplicationUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsApplicationUpgradeDomainCompleteEvent() (*ApplicationUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsApplicationUpgradeRollbackCompleteEvent() (*ApplicationUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsApplicationUpgradeRollbackStartEvent() (*ApplicationUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsApplicationUpgradeStartEvent() (*ApplicationUpgradeStartEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsDeployedApplicationHealthReportCreatedEvent() (*DeployedApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsProcessDeactivatedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsProcessDeactivatedEvent() (*ProcessDeactivatedEvent, bool) {
	return nil, false
}

// AsContainerDeactivatedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsContainerDeactivatedEvent() (*ContainerDeactivatedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAbortingEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsNodeAbortingEvent() (*NodeAbortingEvent, bool) {
	return nil, false
}

// AsNodeAddedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsNodeAddedEvent() (*NodeAddedEvent, bool) {
	return nil, false
}

// AsNodeCloseEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsNodeCloseEvent() (*NodeCloseEvent, bool) {
	return nil, false
}

// AsNodeClosingEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsNodeClosingEvent() (*NodeClosingEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompleteEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsNodeDeactivateCompleteEvent() (*NodeDeactivateCompleteEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsNodeDeactivateStartEvent() (*NodeDeactivateStartEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsNodeHealthReportCreatedEvent() (*NodeHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenedSuccessEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsNodeOpenedSuccessEvent() (*NodeOpenedSuccessEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeOpeningEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsNodeOpeningEvent() (*NodeOpeningEvent, bool) {
	return nil, false
}

// AsNodeRemovedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsNodeRemovedEvent() (*NodeRemovedEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsPartitionHealthReportCreatedEvent() (*PartitionHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfigurationCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsPartitionReconfigurationCompletedEvent() (*PartitionReconfigurationCompletedEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsServiceHealthReportCreatedEvent() (*ServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsDeployedServiceHealthReportCreatedEvent() (*DeployedServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsDeployedServiceHealthReportExpiredEvent() (*DeployedServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsStatefulReplicaHealthReportCreatedEvent() (*StatefulReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsStatelessReplicaHealthReportCreatedEvent() (*StatelessReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsClusterHealthReportCreatedEvent() (*ClusterHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompleteEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsClusterUpgradeCompleteEvent() (*ClusterUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsClusterUpgradeDomainCompleteEvent() (*ClusterUpgradeDomainCompleteEvent, bool) {
	return &cudce, true
}

// AsClusterUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsClusterUpgradeRollbackCompleteEvent() (*ClusterUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsClusterUpgradeRollbackStartEvent() (*ClusterUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsClusterUpgradeStartEvent() (*ClusterUpgradeStartEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsChaosRestartNodeFaultCompletedEvent() (*ChaosRestartNodeFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsChaosRestartCodePackageFaultScheduledEvent() (*ChaosRestartCodePackageFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsChaosRestartCodePackageFaultCompletedEvent() (*ChaosRestartCodePackageFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsChaosRemoveReplicaFaultScheduledEvent() (*ChaosRemoveReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsChaosRemoveReplicaFaultCompletedEvent() (*ChaosRemoveReplicaFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosMoveSecondaryFaultScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsChaosMoveSecondaryFaultScheduledEvent() (*ChaosMoveSecondaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosMovePrimaryFaultScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsChaosMovePrimaryFaultScheduledEvent() (*ChaosMovePrimaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsChaosRestartReplicaFaultScheduledEvent() (*ChaosRestartReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsChaosRestartNodeFaultScheduledEvent() (*ChaosRestartNodeFaultScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompleteEvent.
func (cudce ClusterUpgradeDomainCompleteEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &cudce, true
}

// ClusterUpgradeHealthPolicyObject defines a health policy used to evaluate the health of the cluster
// during a cluster upgrade.
type ClusterUpgradeHealthPolicyObject struct {
	// MaxPercentDeltaUnhealthyNodes - The maximum allowed percentage of nodes health degradation allowed during cluster upgrades. The delta is measured between the state of the nodes at the beginning of upgrade and the state of the nodes at the time of the health evaluation. The check is performed after every upgrade domain upgrade completion to make sure the global state of the cluster is within tolerated limits. The default value is 10%.
	MaxPercentDeltaUnhealthyNodes *int32 `json:"MaxPercentDeltaUnhealthyNodes,omitempty"`
	// MaxPercentUpgradeDomainDeltaUnhealthyNodes - The maximum allowed percentage of upgrade domain nodes health degradation allowed during cluster upgrades. The delta is measured between the state of the upgrade domain nodes at the beginning of upgrade and the state of the upgrade domain nodes at the time of the health evaluation. The check is performed after every upgrade domain upgrade completion for all completed upgrade domains to make sure the state of the upgrade domains is within tolerated limits. The default value is 15%.
	MaxPercentUpgradeDomainDeltaUnhealthyNodes *int32 `json:"MaxPercentUpgradeDomainDeltaUnhealthyNodes,omitempty"`
}

// ClusterUpgradeProgressObject information about a cluster upgrade.
type ClusterUpgradeProgressObject struct {
	autorest.Response `json:"-"`
	// CodeVersion - The ServiceFabric code version of the cluster.
	CodeVersion *string `json:"CodeVersion,omitempty"`
	// ConfigVersion - The cluster configuration version (specified in the cluster manifest).
	ConfigVersion *string `json:"ConfigVersion,omitempty"`
	// UpgradeDomains - List of upgrade domains and their statuses.
	UpgradeDomains *[]UpgradeDomainInfo `json:"UpgradeDomains,omitempty"`
	// UpgradeState - The state of the upgrade domain. Possible values include: 'UpgradeStateInvalid', 'UpgradeStateRollingBackInProgress', 'UpgradeStateRollingBackCompleted', 'UpgradeStateRollingForwardPending', 'UpgradeStateRollingForwardInProgress', 'UpgradeStateRollingForwardCompleted', 'UpgradeStateFailed'
	UpgradeState UpgradeState `json:"UpgradeState,omitempty"`
	// NextUpgradeDomain - The name of the next upgrade domain to be processed.
	NextUpgradeDomain *string `json:"NextUpgradeDomain,omitempty"`
	// RollingUpgradeMode - The mode used to monitor health during a rolling upgrade. The values are UnmonitoredAuto, UnmonitoredManual, and Monitored. Possible values include: 'UpgradeModeInvalid', 'UpgradeModeUnmonitoredAuto', 'UpgradeModeUnmonitoredManual', 'UpgradeModeMonitored'
	RollingUpgradeMode UpgradeMode `json:"RollingUpgradeMode,omitempty"`
	// UpgradeDescription - Represents a ServiceFabric cluster upgrade
	UpgradeDescription *ClusterUpgradeDescriptionObject `json:"UpgradeDescription,omitempty"`
	// UpgradeDurationInMilliseconds - The estimated elapsed time spent processing the current overall upgrade.
	UpgradeDurationInMilliseconds *string `json:"UpgradeDurationInMilliseconds,omitempty"`
	// UpgradeDomainDurationInMilliseconds - The estimated elapsed time spent processing the current upgrade domain.
	UpgradeDomainDurationInMilliseconds *string `json:"UpgradeDomainDurationInMilliseconds,omitempty"`
	// UnhealthyEvaluations - List of health evaluations that resulted in the current aggregated health state.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// CurrentUpgradeDomainProgress - Information about the current in-progress upgrade domain.
	CurrentUpgradeDomainProgress *CurrentUpgradeDomainProgressInfo `json:"CurrentUpgradeDomainProgress,omitempty"`
	// StartTimestampUtc - The start time of the upgrade in UTC.
	StartTimestampUtc *string `json:"StartTimestampUtc,omitempty"`
	// FailureTimestampUtc - The failure time of the upgrade in UTC.
	FailureTimestampUtc *string `json:"FailureTimestampUtc,omitempty"`
	// FailureReason - The cause of an upgrade failure that resulted in FailureAction being executed. Possible values include: 'None', 'Interrupted', 'HealthCheck', 'UpgradeDomainTimeout', 'OverallUpgradeTimeout'
	FailureReason FailureReason `json:"FailureReason,omitempty"`
	// UpgradeDomainProgressAtFailure - The detailed upgrade progress for nodes in the current upgrade domain at the point of failure.
	UpgradeDomainProgressAtFailure *FailedUpgradeDomainProgressObject `json:"UpgradeDomainProgressAtFailure,omitempty"`
}

// ClusterUpgradeRollbackCompleteEvent cluster Upgrade Rollback Complete event.
type ClusterUpgradeRollbackCompleteEvent struct {
	// TargetClusterVersion - Target Cluster version.
	TargetClusterVersion *string `json:"TargetClusterVersion,omitempty"`
	// FailureReason - Describes failure.
	FailureReason *string `json:"FailureReason,omitempty"`
	// OverallUpgradeElapsedTimeInMs - Overall duration of upgrade in milli-seconds.
	OverallUpgradeElapsedTimeInMs *float64 `json:"OverallUpgradeElapsedTimeInMs,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationHealthReportCreated', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeComplete', 'KindApplicationUpgradeDomainComplete', 'KindApplicationUpgradeRollbackComplete', 'KindApplicationUpgradeRollbackStart', 'KindApplicationUpgradeStart', 'KindDeployedApplicationHealthReportCreated', 'KindDeployedApplicationHealthReportExpired', 'KindProcessDeactivated', 'KindContainerDeactivated', 'KindNodeAborted', 'KindNodeAborting', 'KindNodeAdded', 'KindNodeClose', 'KindNodeClosing', 'KindNodeDeactivateComplete', 'KindNodeDeactivateStart', 'KindNodeDown', 'KindNodeHealthReportCreated', 'KindNodeHealthReportExpired', 'KindNodeOpenedSuccess', 'KindNodeOpenFailed', 'KindNodeOpening', 'KindNodeRemoved', 'KindNodeUp', 'KindPartitionHealthReportCreated', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigurationCompleted', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceHealthReportCreated', 'KindServiceHealthReportExpired', 'KindDeployedServiceHealthReportCreated', 'KindDeployedServiceHealthReportExpired', 'KindStatefulReplicaHealthReportCreated', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaHealthReportCreated', 'KindStatelessReplicaHealthReportExpired', 'KindClusterHealthReportCreated', 'KindClusterHealthReportExpired', 'KindClusterUpgradeComplete', 'KindClusterUpgradeDomainComplete', 'KindClusterUpgradeRollbackComplete', 'KindClusterUpgradeRollbackStart', 'KindClusterUpgradeStart', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosRestartNodeFaultCompleted', 'KindChaosRestartCodePackageFaultScheduled', 'KindChaosRestartCodePackageFaultCompleted', 'KindChaosRemoveReplicaFaultScheduled', 'KindChaosRemoveReplicaFaultCompleted', 'KindChaosMoveSecondaryFaultScheduled', 'KindChaosMovePrimaryFaultScheduled', 'KindChaosRestartReplicaFaultScheduled', 'KindChaosRestartNodeFaultScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) MarshalJSON() ([]byte, error) {
	curce.Kind = KindClusterUpgradeRollbackComplete
	objectMap := make(map[string]interface{})
	if curce.TargetClusterVersion != nil {
		objectMap["TargetClusterVersion"] = curce.TargetClusterVersion
	}
	if curce.FailureReason != nil {
		objectMap["FailureReason"] = curce.FailureReason
	}
	if curce.OverallUpgradeElapsedTimeInMs != nil {
		objectMap["OverallUpgradeElapsedTimeInMs"] = curce.OverallUpgradeElapsedTimeInMs
	}
	if curce.EventInstanceID != nil {
		objectMap["EventInstanceId"] = curce.EventInstanceID
	}
	if curce.TimeStamp != nil {
		objectMap["TimeStamp"] = curce.TimeStamp
	}
	if curce.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = curce.HasCorrelatedEvents
	}
	if curce.Kind != "" {
		objectMap["Kind"] = curce.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return nil, false
}

// AsClusterEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return &curce, true
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsApplicationHealthReportCreatedEvent() (*ApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompleteEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsApplicationUpgradeCompleteEvent() (*ApplicationUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsApplicationUpgradeDomainCompleteEvent() (*ApplicationUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsApplicationUpgradeRollbackCompleteEvent() (*ApplicationUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsApplicationUpgradeRollbackStartEvent() (*ApplicationUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsApplicationUpgradeStartEvent() (*ApplicationUpgradeStartEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsDeployedApplicationHealthReportCreatedEvent() (*DeployedApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsProcessDeactivatedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsProcessDeactivatedEvent() (*ProcessDeactivatedEvent, bool) {
	return nil, false
}

// AsContainerDeactivatedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsContainerDeactivatedEvent() (*ContainerDeactivatedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAbortingEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsNodeAbortingEvent() (*NodeAbortingEvent, bool) {
	return nil, false
}

// AsNodeAddedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsNodeAddedEvent() (*NodeAddedEvent, bool) {
	return nil, false
}

// AsNodeCloseEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsNodeCloseEvent() (*NodeCloseEvent, bool) {
	return nil, false
}

// AsNodeClosingEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsNodeClosingEvent() (*NodeClosingEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompleteEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsNodeDeactivateCompleteEvent() (*NodeDeactivateCompleteEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsNodeDeactivateStartEvent() (*NodeDeactivateStartEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsNodeHealthReportCreatedEvent() (*NodeHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenedSuccessEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsNodeOpenedSuccessEvent() (*NodeOpenedSuccessEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeOpeningEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsNodeOpeningEvent() (*NodeOpeningEvent, bool) {
	return nil, false
}

// AsNodeRemovedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsNodeRemovedEvent() (*NodeRemovedEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsPartitionHealthReportCreatedEvent() (*PartitionHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfigurationCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsPartitionReconfigurationCompletedEvent() (*PartitionReconfigurationCompletedEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsServiceHealthReportCreatedEvent() (*ServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsDeployedServiceHealthReportCreatedEvent() (*DeployedServiceHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsDeployedServiceHealthReportExpiredEvent() (*DeployedServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsStatefulReplicaHealthReportCreatedEvent() (*StatefulReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsStatelessReplicaHealthReportCreatedEvent() (*StatelessReplicaHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsClusterHealthReportCreatedEvent() (*ClusterHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompleteEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsClusterUpgradeCompleteEvent() (*ClusterUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsClusterUpgradeDomainCompleteEvent() (*ClusterUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsClusterUpgradeRollbackCompleteEvent() (*ClusterUpgradeRollbackCompleteEvent, bool) {
	return &curce, true
}

// AsClusterUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsClusterUpgradeRollbackStartEvent() (*ClusterUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsClusterUpgradeStartEvent() (*ClusterUpgradeStartEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsChaosRestartNodeFaultCompletedEvent() (*ChaosRestartNodeFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsChaosRestartCodePackageFaultScheduledEvent() (*ChaosRestartCodePackageFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartCodePackageFaultCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsChaosRestartCodePackageFaultCompletedEvent() (*ChaosRestartCodePackageFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsChaosRemoveReplicaFaultScheduledEvent() (*ChaosRemoveReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRemoveReplicaFaultCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsChaosRemoveReplicaFaultCompletedEvent() (*ChaosRemoveReplicaFaultCompletedEvent, bool) {
	return nil, false
}

// AsChaosMoveSecondaryFaultScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsChaosMoveSecondaryFaultScheduledEvent() (*ChaosMoveSecondaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosMovePrimaryFaultScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsChaosMovePrimaryFaultScheduledEvent() (*ChaosMovePrimaryFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartReplicaFaultScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsChaosRestartReplicaFaultScheduledEvent() (*ChaosRestartReplicaFaultScheduledEvent, bool) {
	return nil, false
}

// AsChaosRestartNodeFaultScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsChaosRestartNodeFaultScheduledEvent() (*ChaosRestartNodeFaultScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompleteEvent.
func (curce ClusterUpgradeRollbackCompleteEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &curce, true
}

// ClusterUpgradeRollbackStartEvent cluster Upgrade Rollback Start event.
type ClusterUpgradeRollbackStartEvent struct {
	// TargetClusterVersion - Target Cluster version.
	TargetClusterVersion *string `json:"TargetClusterVersion,omitempty"`
	// FailureReason - Describes failure.
	FailureReason *string `json:"FailureReason,omitempty"`
	// OverallUpgradeElapsedTimeInMs - Overall duration of upgrade in milli-seconds.
	OverallUpgradeElapsedTimeInMs *float64 `json:"OverallUpgradeElapsedTimeInMs,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationHealthReportCreated', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeComplete', 'KindApplicationUpgradeDomainComplete', 'KindApplicationUpgradeRollbackComplete', 'KindApplicationUpgradeRollbackStart', 'KindApplicationUpgradeStart', 'KindDeployedApplicationHealthReportCreated', 'KindDeployedApplicationHealthReportExpired', 'KindProcessDeactivated', 'KindContainerDeactivated', 'KindNodeAborted', 'KindNodeAborting', 'KindNodeAdded', 'KindNodeClose', 'KindNodeClosing', 'KindNodeDeactivateComplete', 'KindNodeDeactivateStart', 'KindNodeDown', 'KindNodeHealthReportCreated', 'KindNodeHealthReportExpired', 'KindNodeOpenedSuccess', 'KindNodeOpenFailed', 'KindNodeOpening', 'KindNodeRemoved', 'KindNodeUp', 'KindPartitionHealthReportCreated', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigurationCompleted', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceHealthReportCreated', 'KindServiceHealthReportExpired', 'KindDeployedServiceHealthReportCreated', 'KindDeployedServiceHealthReportExpired', 'KindStatefulReplicaHealthReportCreated', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaHealthReportCreated', 'KindStatelessReplicaHealthReportExpired', 'KindClusterHealthReportCreated', 'KindClusterHealthReportExpired', 'KindClusterUpgradeComplete', 'KindClusterUpgradeDomainComplete', 'KindClusterUpgradeRollbackComplete', 'KindClusterUpgradeRollbackStart', 'KindClusterUpgradeStart', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosRestartNodeFaultCompleted', 'KindChaosRestartCodePackageFaultScheduled', 'KindChaosRestartCodePackageFaultCompleted', 'KindChaosRemoveReplicaFaultScheduled', 'KindChaosRemoveReplicaFaultCompleted', 'KindChaosMoveSecondaryFaultScheduled', 'KindChaosMovePrimaryFaultScheduled', 'KindChaosRestartReplicaFaultScheduled', 'KindChaosRestartNodeFaultScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterUpgradeRollbackStartEvent.
func (curse ClusterUpgradeRollbackStartEvent) MarshalJSON() ([]byte, error) {
	curse.Kind = KindClusterUpgradeRollbackStart
	objectMap := make(map[string]interface{})
	if curse.TargetClusterVersion != nil {
		objectMap["TargetClusterVersion"] = curse.TargetClusterVersion
	}
	if curse.FailureReason != nil {
		objectMap["FailureReason"] = curse.FailureReason
	}
	if curse.OverallUpgradeElapsedTimeInMs != nil {
		objectMap["OverallUpgradeElapsedTimeInMs"] = curse.OverallUpgradeElapsedTimeInMs
	}
	if curse.EventInstanceID != nil {
		objectMap["EventInstanceId"] = curse.EventInstanceID
	}
	if curse.TimeStamp != nil {
		objectMap["TimeStamp"] = curse.TimeStamp
	}
	if curse.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = curse.HasCorrelatedEvents
	}
	if curse.Kind != "" {
		objectMap["Kind"] = curse.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartEvent.
func (curse ClusterUpgradeRollbackStartEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartEvent.
func (curse ClusterUpgradeRollbackStartEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return nil, false
}

// AsClusterEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartEvent.
func (curse ClusterUpgradeRollbackStartEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartEvent.
func (curse ClusterUpgradeRollbackStartEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return &curse, true
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartEvent.
func (curse ClusterUpgradeRollbackStartEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartEvent.
func (curse ClusterUpgradeRollbackStartEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartEvent.
func (curse ClusterUpgradeRollbackStartEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartEvent.
func (curse ClusterUpgradeRollbackStartEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartEvent.
func (curse ClusterUpgradeRollbackStartEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartEvent.
func (curse ClusterUpgradeRollbackStartEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartEvent.
func (curse ClusterUpgradeRollbackStartEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartEvent.
func (curse ClusterUpgradeRollbackStartEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartEvent.
func (curse ClusterUpgradeRollbackStartEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartEvent.
func (curse ClusterUpgradeRollbackStartEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartEvent.
func (curse ClusterUpgradeRollbackStartEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartEvent.
func (curse ClusterUpgradeRollbackStartEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartEvent.
func (curse ClusterUpgradeRollbackStartEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartEvent.
func (curse ClusterUpgradeRollbackStartEvent) AsApplicationHealthReportCreatedEvent() (*ApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartEvent.
func (curse ClusterUpgradeRollbackStartEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompleteEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartEvent.
func (curse ClusterUpgradeRollbackStartEvent) AsApplicationUpgradeCompleteEvent() (*ApplicationUpgradeCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompleteEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartEvent.
func (curse ClusterUpgradeRollbackStartEvent) AsApplicationUpgradeDomainCompleteEvent() (*ApplicationUpgradeDomainCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompleteEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartEvent.
func (curse ClusterUpgradeRollbackStartEvent) AsApplicationUpgradeRollbackCompleteEvent() (*ApplicationUpgradeRollbackCompleteEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartEvent.
func (curse ClusterUpgradeRollbackStartEvent) AsApplicationUpgradeRollbackStartEvent() (*ApplicationUpgradeRollbackStartEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartEvent.
func (curse ClusterUpgradeRollbackStartEvent) AsApplicationUpgradeStartEvent() (*ApplicationUpgradeStartEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartEvent.
func (curse ClusterUpgradeRollbackStartEvent) AsDeployedApplicationHealthReportCreatedEvent() (*DeployedApplicationHealthReportCreatedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartEvent.
func (curse ClusterUpgradeRollbackStartEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsProcessDeactivatedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartEvent.
func (curse ClusterUpgradeRollbackStartEvent) AsProcessDeactivatedEvent() (*ProcessDeactivatedEvent, bool) {
	return nil, false
}

// AsContainerDeactivatedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartEvent.
func (curse ClusterUpgradeRollbackStartEvent) AsContainerDeactivatedEvent() (*ContainerDeactivatedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartEvent.
func (curse ClusterUpgradeRollbackStartEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAbortingEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartEvent.
func (curse ClusterUpgradeRollbackStartEvent) AsNodeAbortingEvent() (*NodeAbortingEvent, bool) {
	return nil, false
}

// AsNodeAddedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartEvent.
func (curse ClusterUpgradeRollbackStartEvent) AsNodeAddedEvent() (*NodeAddedEvent, bool) {
	return nil, false
}

// AsNodeCloseEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartEvent.
func (curse ClusterUpgradeRollbackStartEvent) AsNodeCloseEvent() (*NodeCloseEvent, bool) {
	return nil, false
}

// AsNodeClosingEvent is the BasicFabricEvent implementation for Clu