// Code generated by gen_tests.py and process_polyglot.py.
// Do not edit this file directly.
// The template for this file is located at:
// ../template.go.tpl
package reql_tests

import (
	"testing"
	"time"

	"github.com/stretchr/testify/suite"
	r "gopkg.in/gorethink/gorethink.v4"
	"gopkg.in/gorethink/gorethink.v4/internal/compare"
)

// tests for `floor`, `ceil`, and `round`, tests inspired by the Python test suite
func TestMathLogicFloorCeilRoundSuite(t *testing.T) {
	suite.Run(t, new(MathLogicFloorCeilRoundSuite))
}

type MathLogicFloorCeilRoundSuite struct {
	suite.Suite

	session *r.Session
}

func (suite *MathLogicFloorCeilRoundSuite) SetupTest() {
	suite.T().Log("Setting up MathLogicFloorCeilRoundSuite")
	// Use imports to prevent errors
	_ = time.Time{}
	_ = compare.AnythingIsFine

	session, err := r.Connect(r.ConnectOpts{
		Address: url,
	})
	suite.Require().NoError(err, "Error returned when connecting to server")
	suite.session = session

	r.DBDrop("test").Exec(suite.session)
	err = r.DBCreate("test").Exec(suite.session)
	suite.Require().NoError(err)
	err = r.DB("test").Wait().Exec(suite.session)
	suite.Require().NoError(err)

}

func (suite *MathLogicFloorCeilRoundSuite) TearDownSuite() {
	suite.T().Log("Tearing down MathLogicFloorCeilRoundSuite")

	if suite.session != nil {
		r.DB("rethinkdb").Table("_debug_scratch").Delete().Exec(suite.session)
		r.DBDrop("test").Exec(suite.session)

		suite.session.Close()
	}
}

func (suite *MathLogicFloorCeilRoundSuite) TestCases() {
	suite.T().Log("Running MathLogicFloorCeilRoundSuite: tests for `floor`, `ceil`, and `round`, tests inspired by the Python test suite")

	{
		// math_logic/floor_ceil_round.yaml line #3
		/* "NUMBER" */
		var expected_ string = "NUMBER"
		/* r.floor(1.0).type_of() */

		suite.T().Log("About to run line #3: r.Floor(1.0).TypeOf()")

		runAndAssert(suite.Suite, expected_, r.Floor(1.0).TypeOf(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #3")
	}

	{
		// math_logic/floor_ceil_round.yaml line #5
		/* 1.0 */
		var expected_ float64 = 1.0
		/* r.floor(1.0) */

		suite.T().Log("About to run line #5: r.Floor(1.0)")

		runAndAssert(suite.Suite, expected_, r.Floor(1.0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #5")
	}

	{
		// math_logic/floor_ceil_round.yaml line #7
		/* 1.0 */
		var expected_ float64 = 1.0
		/* r.expr(1.0).floor() */

		suite.T().Log("About to run line #7: r.Expr(1.0).Floor()")

		runAndAssert(suite.Suite, expected_, r.Expr(1.0).Floor(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #7")
	}

	{
		// math_logic/floor_ceil_round.yaml line #10
		/* 0.0 */
		var expected_ float64 = 0.0
		/* r.floor(0.5) */

		suite.T().Log("About to run line #10: r.Floor(0.5)")

		runAndAssert(suite.Suite, expected_, r.Floor(0.5), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #10")
	}

	{
		// math_logic/floor_ceil_round.yaml line #12
		/* 1.0 */
		var expected_ float64 = 1.0
		/* r.floor(1.0) */

		suite.T().Log("About to run line #12: r.Floor(1.0)")

		runAndAssert(suite.Suite, expected_, r.Floor(1.0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #12")
	}

	{
		// math_logic/floor_ceil_round.yaml line #14
		/* 1.0 */
		var expected_ float64 = 1.0
		/* r.floor(1.5) */

		suite.T().Log("About to run line #14: r.Floor(1.5)")

		runAndAssert(suite.Suite, expected_, r.Floor(1.5), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #14")
	}

	{
		// math_logic/floor_ceil_round.yaml line #16
		/* -1.0 */
		var expected_ float64 = -1.0
		/* r.floor(-0.5) */

		suite.T().Log("About to run line #16: r.Floor(-0.5)")

		runAndAssert(suite.Suite, expected_, r.Floor(-0.5), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #16")
	}

	{
		// math_logic/floor_ceil_round.yaml line #18
		/* -1.0 */
		var expected_ float64 = -1.0
		/* r.floor(-1.0) */

		suite.T().Log("About to run line #18: r.Floor(-1.0)")

		runAndAssert(suite.Suite, expected_, r.Floor(-1.0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #18")
	}

	{
		// math_logic/floor_ceil_round.yaml line #20
		/* -2.0 */
		var expected_ float64 = -2.0
		/* r.floor(-1.5) */

		suite.T().Log("About to run line #20: r.Floor(-1.5)")

		runAndAssert(suite.Suite, expected_, r.Floor(-1.5), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #20")
	}

	{
		// math_logic/floor_ceil_round.yaml line #23
		/* err("ReqlQueryLogicError", "Expected type NUMBER but found STRING.", []) */
		var expected_ Err = err("ReqlQueryLogicError", "Expected type NUMBER but found STRING.")
		/* r.expr('X').floor() */

		suite.T().Log("About to run line #23: r.Expr('X').Floor()")

		runAndAssert(suite.Suite, expected_, r.Expr("X").Floor(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #23")
	}

	{
		// math_logic/floor_ceil_round.yaml line #27
		/* "NUMBER" */
		var expected_ string = "NUMBER"
		/* r.ceil(1.0).type_of() */

		suite.T().Log("About to run line #27: r.Ceil(1.0).TypeOf()")

		runAndAssert(suite.Suite, expected_, r.Ceil(1.0).TypeOf(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #27")
	}

	{
		// math_logic/floor_ceil_round.yaml line #29
		/* 1.0 */
		var expected_ float64 = 1.0
		/* r.ceil(1.0) */

		suite.T().Log("About to run line #29: r.Ceil(1.0)")

		runAndAssert(suite.Suite, expected_, r.Ceil(1.0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #29")
	}

	{
		// math_logic/floor_ceil_round.yaml line #31
		/* 1.0 */
		var expected_ float64 = 1.0
		/* r.expr(1.0).ceil() */

		suite.T().Log("About to run line #31: r.Expr(1.0).Ceil()")

		runAndAssert(suite.Suite, expected_, r.Expr(1.0).Ceil(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #31")
	}

	{
		// math_logic/floor_ceil_round.yaml line #34
		/* 1.0 */
		var expected_ float64 = 1.0
		/* r.ceil(0.5) */

		suite.T().Log("About to run line #34: r.Ceil(0.5)")

		runAndAssert(suite.Suite, expected_, r.Ceil(0.5), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #34")
	}

	{
		// math_logic/floor_ceil_round.yaml line #36
		/* 1.0 */
		var expected_ float64 = 1.0
		/* r.ceil(1.0) */

		suite.T().Log("About to run line #36: r.Ceil(1.0)")

		runAndAssert(suite.Suite, expected_, r.Ceil(1.0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #36")
	}

	{
		// math_logic/floor_ceil_round.yaml line #38
		/* 2.0 */
		var expected_ float64 = 2.0
		/* r.ceil(1.5) */

		suite.T().Log("About to run line #38: r.Ceil(1.5)")

		runAndAssert(suite.Suite, expected_, r.Ceil(1.5), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #38")
	}

	{
		// math_logic/floor_ceil_round.yaml line #40
		/* 0.0 */
		var expected_ float64 = 0.0
		/* r.ceil(-0.5) */

		suite.T().Log("About to run line #40: r.Ceil(-0.5)")

		runAndAssert(suite.Suite, expected_, r.Ceil(-0.5), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #40")
	}

	{
		// math_logic/floor_ceil_round.yaml line #42
		/* -1.0 */
		var expected_ float64 = -1.0
		/* r.ceil(-1.0) */

		suite.T().Log("About to run line #42: r.Ceil(-1.0)")

		runAndAssert(suite.Suite, expected_, r.Ceil(-1.0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #42")
	}

	{
		// math_logic/floor_ceil_round.yaml line #44
		/* -1.0 */
		var expected_ float64 = -1.0
		/* r.ceil(-1.5) */

		suite.T().Log("About to run line #44: r.Ceil(-1.5)")

		runAndAssert(suite.Suite, expected_, r.Ceil(-1.5), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #44")
	}

	{
		// math_logic/floor_ceil_round.yaml line #47
		/* err("ReqlQueryLogicError", "Expected type NUMBER but found STRING.", []) */
		var expected_ Err = err("ReqlQueryLogicError", "Expected type NUMBER but found STRING.")
		/* r.expr('X').ceil() */

		suite.T().Log("About to run line #47: r.Expr('X').Ceil()")

		runAndAssert(suite.Suite, expected_, r.Expr("X").Ceil(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #47")
	}

	{
		// math_logic/floor_ceil_round.yaml line #51
		/* "NUMBER" */
		var expected_ string = "NUMBER"
		/* r.round(1.0).type_of() */

		suite.T().Log("About to run line #51: r.Round(1.0).TypeOf()")

		runAndAssert(suite.Suite, expected_, r.Round(1.0).TypeOf(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #51")
	}

	{
		// math_logic/floor_ceil_round.yaml line #53
		/* 1.0 */
		var expected_ float64 = 1.0
		/* r.round(1.0) */

		suite.T().Log("About to run line #53: r.Round(1.0)")

		runAndAssert(suite.Suite, expected_, r.Round(1.0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #53")
	}

	{
		// math_logic/floor_ceil_round.yaml line #55
		/* 1.0 */
		var expected_ float64 = 1.0
		/* r.expr(1.0).round() */

		suite.T().Log("About to run line #55: r.Expr(1.0).Round()")

		runAndAssert(suite.Suite, expected_, r.Expr(1.0).Round(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #55")
	}

	{
		// math_logic/floor_ceil_round.yaml line #58
		/* 1.0 */
		var expected_ float64 = 1.0
		/* r.round(0.5) */

		suite.T().Log("About to run line #58: r.Round(0.5)")

		runAndAssert(suite.Suite, expected_, r.Round(0.5), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #58")
	}

	{
		// math_logic/floor_ceil_round.yaml line #60
		/* -1.0 */
		var expected_ float64 = -1.0
		/* r.round(-0.5) */

		suite.T().Log("About to run line #60: r.Round(-0.5)")

		runAndAssert(suite.Suite, expected_, r.Round(-0.5), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #60")
	}

	{
		// math_logic/floor_ceil_round.yaml line #63
		/* 0.0 */
		var expected_ float64 = 0.0
		/* r.round(0.0) */

		suite.T().Log("About to run line #63: r.Round(0.0)")

		runAndAssert(suite.Suite, expected_, r.Round(0.0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #63")
	}

	{
		// math_logic/floor_ceil_round.yaml line #65
		/* 1.0 */
		var expected_ float64 = 1.0
		/* r.round(1.0) */

		suite.T().Log("About to run line #65: r.Round(1.0)")

		runAndAssert(suite.Suite, expected_, r.Round(1.0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #65")
	}

	{
		// math_logic/floor_ceil_round.yaml line #67
		/* 10.0 */
		var expected_ float64 = 10.0
		/* r.round(10.0) */

		suite.T().Log("About to run line #67: r.Round(10.0)")

		runAndAssert(suite.Suite, expected_, r.Round(10.0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #67")
	}

	{
		// math_logic/floor_ceil_round.yaml line #69
		/* 1000000000.0 */
		var expected_ float64 = 1000000000.0
		/* r.round(1000000000.0) */

		suite.T().Log("About to run line #69: r.Round(1000000000.0)")

		runAndAssert(suite.Suite, expected_, r.Round(1000000000.0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #69")
	}

	{
		// math_logic/floor_ceil_round.yaml line #71
		/* 1e20 */
		var expected_ float64 = 1e+20
		/* r.round(1e20) */

		suite.T().Log("About to run line #71: r.Round(1e+20)")

		runAndAssert(suite.Suite, expected_, r.Round(1e+20), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #71")
	}

	{
		// math_logic/floor_ceil_round.yaml line #74
		/* -1.0 */
		var expected_ float64 = -1.0
		/* r.round(-1.0) */

		suite.T().Log("About to run line #74: r.Round(-1.0)")

		runAndAssert(suite.Suite, expected_, r.Round(-1.0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #74")
	}

	{
		// math_logic/floor_ceil_round.yaml line #76
		/* -10.0 */
		var expected_ float64 = -10.0
		/* r.round(-10.0) */

		suite.T().Log("About to run line #76: r.Round(-10.0)")

		runAndAssert(suite.Suite, expected_, r.Round(-10.0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #76")
	}

	{
		// math_logic/floor_ceil_round.yaml line #78
		/* -1000000000.0 */
		var expected_ float64 = -1000000000.0
		/* r.round(-1000000000.0) */

		suite.T().Log("About to run line #78: r.Round(-1000000000.0)")

		runAndAssert(suite.Suite, expected_, r.Round(-1000000000.0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #78")
	}

	{
		// math_logic/floor_ceil_round.yaml line #80
		/* -1e20 */
		var expected_ float64 = -1e+20
		/* r.round(-1e20) */

		suite.T().Log("About to run line #80: r.Round(-1e+20)")

		runAndAssert(suite.Suite, expected_, r.Round(-1e+20), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #80")
	}

	{
		// math_logic/floor_ceil_round.yaml line #83
		/* 0.0 */
		var expected_ float64 = 0.0
		/* r.round(0.1) */

		suite.T().Log("About to run line #83: r.Round(0.1)")

		runAndAssert(suite.Suite, expected_, r.Round(0.1), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #83")
	}

	{
		// math_logic/floor_ceil_round.yaml line #85
		/* 1.0 */
		var expected_ float64 = 1.0
		/* r.round(1.1) */

		suite.T().Log("About to run line #85: r.Round(1.1)")

		runAndAssert(suite.Suite, expected_, r.Round(1.1), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #85")
	}

	{
		// math_logic/floor_ceil_round.yaml line #87
		/* 10.0 */
		var expected_ float64 = 10.0
		/* r.round(10.1) */

		suite.T().Log("About to run line #87: r.Round(10.1)")

		runAndAssert(suite.Suite, expected_, r.Round(10.1), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #87")
	}

	{
		// math_logic/floor_ceil_round.yaml line #89
		/* 1000000000.0 */
		var expected_ float64 = 1000000000.0
		/* r.round(1000000000.1) */

		suite.T().Log("About to run line #89: r.Round(1000000000.1)")

		runAndAssert(suite.Suite, expected_, r.Round(1000000000.1), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #89")
	}

	{
		// math_logic/floor_ceil_round.yaml line #92
		/* -1.0 */
		var expected_ float64 = -1.0
		/* r.round(-1.1) */

		suite.T().Log("About to run line #92: r.Round(-1.1)")

		runAndAssert(suite.Suite, expected_, r.Round(-1.1), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #92")
	}

	{
		// math_logic/floor_ceil_round.yaml line #94
		/* -10.0 */
		var expected_ float64 = -10.0
		/* r.round(-10.1) */

		suite.T().Log("About to run line #94: r.Round(-10.1)")

		runAndAssert(suite.Suite, expected_, r.Round(-10.1), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #94")
	}

	{
		// math_logic/floor_ceil_round.yaml line #96
		/* -1000000000.0 */
		var expected_ float64 = -1000000000.0
		/* r.round(-1000000000.1) */

		suite.T().Log("About to run line #96: r.Round(-1000000000.1)")

		runAndAssert(suite.Suite, expected_, r.Round(-1000000000.1), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #96")
	}

	{
		// math_logic/floor_ceil_round.yaml line #99
		/* 1.0 */
		var expected_ float64 = 1.0
		/* r.round(0.9) */

		suite.T().Log("About to run line #99: r.Round(0.9)")

		runAndAssert(suite.Suite, expected_, r.Round(0.9), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #99")
	}

	{
		// math_logic/floor_ceil_round.yaml line #101
		/* 10.0 */
		var expected_ float64 = 10.0
		/* r.round(9.9) */

		suite.T().Log("About to run line #101: r.Round(9.9)")

		runAndAssert(suite.Suite, expected_, r.Round(9.9), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #101")
	}

	{
		// math_logic/floor_ceil_round.yaml line #103
		/* 1000000000.0 */
		var expected_ float64 = 1000000000.0
		/* r.round(999999999.9) */

		suite.T().Log("About to run line #103: r.Round(999999999.9)")

		runAndAssert(suite.Suite, expected_, r.Round(999999999.9), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #103")
	}

	{
		// math_logic/floor_ceil_round.yaml line #106
		/* -1.0 */
		var expected_ float64 = -1.0
		/* r.round(-0.9) */

		suite.T().Log("About to run line #106: r.Round(-0.9)")

		runAndAssert(suite.Suite, expected_, r.Round(-0.9), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #106")
	}

	{
		// math_logic/floor_ceil_round.yaml line #108
		/* -10.0 */
		var expected_ float64 = -10.0
		/* r.round(-9.9) */

		suite.T().Log("About to run line #108: r.Round(-9.9)")

		runAndAssert(suite.Suite, expected_, r.Round(-9.9), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #108")
	}

	{
		// math_logic/floor_ceil_round.yaml line #110
		/* -1000000000.0 */
		var expected_ float64 = -1000000000.0
		/* r.round(-999999999.9) */

		suite.T().Log("About to run line #110: r.Round(-999999999.9)")

		runAndAssert(suite.Suite, expected_, r.Round(-999999999.9), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #110")
	}

	{
		// math_logic/floor_ceil_round.yaml line #113
		/* err("ReqlQueryLogicError", "Expected type NUMBER but found STRING.", []) */
		var expected_ Err = err("ReqlQueryLogicError", "Expected type NUMBER but found STRING.")
		/* r.expr('X').round() */

		suite.T().Log("About to run line #113: r.Expr('X').Round()")

		runAndAssert(suite.Suite, expected_, r.Expr("X").Round(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #113")
	}
}
