// Code generated by gen_tests.py and process_polyglot.py.
// Do not edit this file directly.
// The template for this file is located at:
// ../template.go.tpl
package reql_tests

import (
	"testing"
	"time"

	"github.com/stretchr/testify/suite"
	r "gopkg.in/gorethink/gorethink.v4"
	"gopkg.in/gorethink/gorethink.v4/internal/compare"
)

// Tests timeouts.
func TestTimeoutSuite(t *testing.T) {
	suite.Run(t, new(TimeoutSuite))
}

type TimeoutSuite struct {
	suite.Suite

	session *r.Session
}

func (suite *TimeoutSuite) SetupTest() {
	suite.T().Log("Setting up TimeoutSuite")
	// Use imports to prevent errors
	_ = time.Time{}
	_ = compare.AnythingIsFine

	session, err := r.Connect(r.ConnectOpts{
		Address: url,
	})
	suite.Require().NoError(err, "Error returned when connecting to server")
	suite.session = session

	r.DBDrop("test").Exec(suite.session)
	err = r.DBCreate("test").Exec(suite.session)
	suite.Require().NoError(err)
	err = r.DB("test").Wait().Exec(suite.session)
	suite.Require().NoError(err)

}

func (suite *TimeoutSuite) TearDownSuite() {
	suite.T().Log("Tearing down TimeoutSuite")

	if suite.session != nil {
		r.DB("rethinkdb").Table("_debug_scratch").Delete().Exec(suite.session)
		r.DBDrop("test").Exec(suite.session)

		suite.session.Close()
	}
}

func (suite *TimeoutSuite) TestCases() {
	suite.T().Log("Running TimeoutSuite: Tests timeouts.")

	{
		// timeout.yaml line #5
		/* err("ReqlQueryLogicError", "JavaScript query `while(true) {}` timed out after 5.000 seconds.", [0]) */
		var expected_ Err = err("ReqlQueryLogicError", "JavaScript query `while(true) {}` timed out after 5.000 seconds.")
		/* r.js('while(true) {}') */

		suite.T().Log("About to run line #5: r.JS('while(true) {}')")

		runAndAssert(suite.Suite, expected_, r.JS("while(true) {}"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #5")
	}

	{
		// timeout.yaml line #8
		/* err("ReqlQueryLogicError", "JavaScript query `while(true) {}` timed out after 1.300 seconds.", [0]) */
		var expected_ Err = err("ReqlQueryLogicError", "JavaScript query `while(true) {}` timed out after 1.300 seconds.")
		/* r.js('while(true) {}', timeout=1.3) */

		suite.T().Log("About to run line #8: r.JS('while(true) {}').OptArgs(r.JSOpts{Timeout: 1.3, })")

		runAndAssert(suite.Suite, expected_, r.JS("while(true) {}").OptArgs(r.JSOpts{Timeout: 1.3}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #8")
	}

	{
		// timeout.yaml line #13
		/* err("ReqlQueryLogicError", "JavaScript query `while(true) {}` timed out after 8.000 seconds.", [0]) */
		var expected_ Err = err("ReqlQueryLogicError", "JavaScript query `while(true) {}` timed out after 8.000 seconds.")
		/* r.js('while(true) {}', timeout=8) */

		suite.T().Log("About to run line #13: r.JS('while(true) {}').OptArgs(r.JSOpts{Timeout: 8, })")

		runAndAssert(suite.Suite, expected_, r.JS("while(true) {}").OptArgs(r.JSOpts{Timeout: 8}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #13")
	}

	{
		// timeout.yaml line #18
		/* err("ReqlQueryLogicError", "JavaScript query `(function(x) { while(true) {} })` timed out after 5.000 seconds.", [0]) */
		var expected_ Err = err("ReqlQueryLogicError", "JavaScript query `(function(x) { while(true) {} })` timed out after 5.000 seconds.")
		/* r.expr('foo').do(r.js('(function(x) { while(true) {} })')) */

		suite.T().Log("About to run line #18: r.Expr('foo').Do(r.JS('(function(x) { while(true) {} })'))")

		runAndAssert(suite.Suite, expected_, r.Expr("foo").Do(r.JS("(function(x) { while(true) {} })")), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #18")
	}

	{
		// timeout.yaml line #21
		/* err("ReqlQueryLogicError", "JavaScript query `(function(x) { while(true) {} })` timed out after 1.300 seconds.", [0]) */
		var expected_ Err = err("ReqlQueryLogicError", "JavaScript query `(function(x) { while(true) {} })` timed out after 1.300 seconds.")
		/* r.expr('foo').do(r.js('(function(x) { while(true) {} })', timeout=1.3)) */

		suite.T().Log("About to run line #21: r.Expr('foo').Do(r.JS('(function(x) { while(true) {} })').OptArgs(r.JSOpts{Timeout: 1.3, }))")

		runAndAssert(suite.Suite, expected_, r.Expr("foo").Do(r.JS("(function(x) { while(true) {} })").OptArgs(r.JSOpts{Timeout: 1.3})), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #21")
	}

	{
		// timeout.yaml line #26
		/* err("ReqlQueryLogicError", "JavaScript query `(function(x) { while(true) {} })` timed out after 8.000 seconds.", [0]) */
		var expected_ Err = err("ReqlQueryLogicError", "JavaScript query `(function(x) { while(true) {} })` timed out after 8.000 seconds.")
		/* r.expr('foo').do(r.js('(function(x) { while(true) {} })', timeout=8)) */

		suite.T().Log("About to run line #26: r.Expr('foo').Do(r.JS('(function(x) { while(true) {} })').OptArgs(r.JSOpts{Timeout: 8, }))")

		runAndAssert(suite.Suite, expected_, r.Expr("foo").Do(r.JS("(function(x) { while(true) {} })").OptArgs(r.JSOpts{Timeout: 8})), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #26")
	}

	{
		// timeout.yaml line #32
		/* err("ReqlNonExistenceError", "Error in HTTP GET of `httpbin.org/delay/10`:" + " timed out after 0.800 seconds.", []) */
		var expected_ Err = err("ReqlNonExistenceError", "Error in HTTP GET of `httpbin.org/delay/10`:"+" timed out after 0.800 seconds.")
		/* r.http('httpbin.org/delay/10', timeout=0.8) */

		suite.T().Log("About to run line #32: r.HTTP('httpbin.org/delay/10').OptArgs(r.HTTPOpts{Timeout: 0.8, })")

		runAndAssert(suite.Suite, expected_, r.HTTP("httpbin.org/delay/10").OptArgs(r.HTTPOpts{Timeout: 0.8}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #32")
	}

	{
		// timeout.yaml line #36
		/* err("ReqlNonExistenceError", "Error in HTTP PUT of `httpbin.org/delay/10`:" + " timed out after 0.000 seconds.", []) */
		var expected_ Err = err("ReqlNonExistenceError", "Error in HTTP PUT of `httpbin.org/delay/10`:"+" timed out after 0.000 seconds.")
		/* r.http('httpbin.org/delay/10', method='PUT', timeout=0.0) */

		suite.T().Log("About to run line #36: r.HTTP('httpbin.org/delay/10').OptArgs(r.HTTPOpts{Method: 'PUT', Timeout: 0.0, })")

		runAndAssert(suite.Suite, expected_, r.HTTP("httpbin.org/delay/10").OptArgs(r.HTTPOpts{Method: "PUT", Timeout: 0.0}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #36")
	}
}
