---
layout: "docs"
page_title: "Zookeeper - Storage Backends - Configuration"
sidebar_title: "Zookeeper"
sidebar_current: "docs-configuration-storage-zookeeper"
description: |-
  The Zookeeper storage backend is used to persist Vault's data in Zookeeper.
---

# Zookeeper Storage Backend

The Zookeeper storage backend is used to persist Vault's data in
[Zookeeper][zk].

- **High Availability** – the Zookeeper storage backend supports high
  availability.

- **Community Supported** – the Zookeeper storage backend is supported by the
  community. While it has undergone review by HashiCorp employees, they may not
  be as knowledgeable about the technology. If you encounter problems with them,
  you may be referred to the original author.

```hcl
storage "zookeeper" {
  address = "localhost:2181"
  path    = "vault/"
}
```

## `zookeeper` Parameters

- `address` `(string: "localhost:2181")` – Specifies the addresses of the
  Zookeeper instances as a comma-separated list.

- `path` `(string: "vault/")` – Specifies the path in Zookeeper where data will
  be stored.

The following optional settings can be used to configure zNode ACLs:

~> **Warning!** If neither `auth_info` nor `znode_owner` are set, the backend
will not authenticate with Zookeeper and will set the `OPEN_ACL_UNSAFE` ACL on
all nodes. In this scenario, anyone connected to Zookeeper could change Vault’s
znodes and, potentially, take Vault out of service.

- `auth_info` `(string: "")` – Specifies an authentication string in Zookeeper
  AddAuth format. For example, `digest:UserName:Password` could be used to
  authenticate as user `UserName` using password `Password` with the `digest`
  mechanism.

- `znode_owner` `(string: "")` – If specified, Vault will always set all
  permissions (CRWDA) to the ACL identified here via the Schema and User parts
  of the Zookeeper ACL format. The expected format is `schema:user-ACL-match`,
  for example:

    ```text
    # Access for user "UserName" with corresponding digest "HIDfRvTv623G=="
    digest:UserName:HIDfRvTv623G==
    ```

    ```text
    # Access from localhost only
    ip:127.0.0.1
    ```

    ```text
    # Access from any host on the 70.95.0.0 network (Zookeeper 3.5+)
    ip:70.95.0.0/16
    ```

- `tls_enabled` `(bool: false)` – Specifies if TLS communication with the Zookeeper
   backend has to be enabled.

- `tls_ca_file` `(string: "")` – Specifies the path to the CA certificate file used
  for Zookeeper communication. Multiple CA certificates can be provided in the same file.

- `tls_cert_file` `(string: "")` (optional) – Specifies the path to the
  client certificate for Zookeeper communication.

- `tls_key_file` `(string: "")` – Specifies the path to the private key for
  Zookeeper communication.

- `tls_min_version` `(string: "tls12")` – Specifies the minimum TLS version to
  use. Accepted values are `"tls10"`, `"tls11"` or `"tls12"`.

- `tls_skip_verify` `(bool: false)` – Specifies if the TLS host verification
  should be disabled. It is highly discouraged that you disable this option.

- `tls_verify_ip` `(bool: false)` - This property comes into play only when
  'tls_skip_verify' is set to false. When 'tls_verify_ip' is set to 'true', the
  zookeeper server's IP is verified in the presented certificates CN/SAN entry. 
  When set to 'false' the server's DNS name is verified in the certificates CN/SAN entry.


## `zookeeper` Examples

### Custom Address and Path

This example shows configuring Vault to communicate with a Zookeeper
installation running on a custom port and to store data at a custom path.

```hcl
storage "zookeeper" {
  address = "localhost:3253"
  path    = "my-vault-data/"
}
```

### zNode Vault User Only

This example instructs Vault to set an ACL on all of its zNodes which permit
access only to the user "vaultUser". As per Zookeeper's ACL model, the digest
value in `znode_owner` must match the user in `znode_owner`.

```hcl
storage "zookeeper" {
  znode_owner = "digest:vaultUser:raxgVAfnDRljZDAcJFxznkZsExs="
  auth_info   = "digest:vaultUser:abc"
}
```

### zNode Localhost Only

This example instructs Vault to only allow access from localhost. As this is the
`ip` no `auth_info` is required since Zookeeper uses the address of the client
for the ACL check.

```hcl
storage "zookeeper" {
  znode_owner = "ip:127.0.0.1"
}
```

### zNode connection over TLS.

This example instructs Vault to connect to Zookeeper using the provided TLS configuration. The host verification will happen with the presented certificate using the servers IP because 'tls_verify_ip' is set to true.

```hcl
storage "zookeeper" {
  address = "host1.com:5200,host2.com:5200,host3.com:5200"
  path = "vault_path_on_zk/"
  znode_owner = "digest:vault_user:digestvalueforpassword="
  auth_info = "digest:vault_user:thisisthepassword"
  redirect_addr = "http://localhost:8200"
  tls_verify_ip = "true"
  tls_enabled= "true"
  tls_min_version= "tls12"
  tls_cert_file = "/path/to/the/cert/file/zkcert.pem"
  tls_key_file = "/path/to/the/key/file/zkkey.pem"
  tls_skip_verify= "false"
  tls_ca_file= "/path/to/the/ca/file/ca.pem"
}
```

[zk]: https://zookeeper.apache.org/
