package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDiversify invokes the airec.DescribeDiversify API synchronously
// api document: https://help.aliyun.com/api/airec/describediversify.html
func (client *Client) DescribeDiversify(request *DescribeDiversifyRequest) (response *DescribeDiversifyResponse, err error) {
	response = CreateDescribeDiversifyResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDiversifyWithChan invokes the airec.DescribeDiversify API asynchronously
// api document: https://help.aliyun.com/api/airec/describediversify.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDiversifyWithChan(request *DescribeDiversifyRequest) (<-chan *DescribeDiversifyResponse, <-chan error) {
	responseChan := make(chan *DescribeDiversifyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDiversify(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDiversifyWithCallback invokes the airec.DescribeDiversify API asynchronously
// api document: https://help.aliyun.com/api/airec/describediversify.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDiversifyWithCallback(request *DescribeDiversifyRequest, callback func(response *DescribeDiversifyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDiversifyResponse
		var err error
		defer close(result)
		response, err = client.DescribeDiversify(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDiversifyRequest is the request struct for api DescribeDiversify
type DescribeDiversifyRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
	Name       string `position:"Path" name:"Name"`
}

// DescribeDiversifyResponse is the response struct for api DescribeDiversify
type DescribeDiversifyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDescribeDiversifyRequest creates a request to invoke DescribeDiversify API
func CreateDescribeDiversifyRequest() (request *DescribeDiversifyRequest) {
	request = &DescribeDiversifyRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2018-10-12", "DescribeDiversify", "/openapi/instances/[InstanceId]/diversifies/[Name]", "airec", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeDiversifyResponse creates a response to parse from DescribeDiversify response
func CreateDescribeDiversifyResponse() (response *DescribeDiversifyResponse) {
	response = &DescribeDiversifyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
