package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryBlock invokes the baas.QueryBlock API synchronously
// api document: https://help.aliyun.com/api/baas/queryblock.html
func (client *Client) QueryBlock(request *QueryBlockRequest) (response *QueryBlockResponse, err error) {
	response = CreateQueryBlockResponse()
	err = client.DoAction(request, response)
	return
}

// QueryBlockWithChan invokes the baas.QueryBlock API asynchronously
// api document: https://help.aliyun.com/api/baas/queryblock.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryBlockWithChan(request *QueryBlockRequest) (<-chan *QueryBlockResponse, <-chan error) {
	responseChan := make(chan *QueryBlockResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryBlock(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryBlockWithCallback invokes the baas.QueryBlock API asynchronously
// api document: https://help.aliyun.com/api/baas/queryblock.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryBlockWithCallback(request *QueryBlockRequest, callback func(response *QueryBlockResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryBlockResponse
		var err error
		defer close(result)
		response, err = client.QueryBlock(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryBlockRequest is the request struct for api QueryBlock
type QueryBlockRequest struct {
	*requests.RpcRequest
	Bizid  string           `position:"Body" name:"Bizid"`
	Height requests.Integer `position:"Body" name:"Height"`
}

// QueryBlockResponse is the response struct for api QueryBlock
type QueryBlockResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateQueryBlockRequest creates a request to invoke QueryBlock API
func CreateQueryBlockRequest() (request *QueryBlockRequest) {
	request = &QueryBlockRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "QueryBlock", "", "")
	return
}

// CreateQueryBlockResponse creates a response to parse from QueryBlock response
func CreateQueryBlockResponse() (response *QueryBlockResponse) {
	response = &QueryBlockResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
