package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryCustomEventHistogram invokes the cms.QueryCustomEventHistogram API synchronously
// api document: https://help.aliyun.com/api/cms/querycustomeventhistogram.html
func (client *Client) QueryCustomEventHistogram(request *QueryCustomEventHistogramRequest) (response *QueryCustomEventHistogramResponse, err error) {
	response = CreateQueryCustomEventHistogramResponse()
	err = client.DoAction(request, response)
	return
}

// QueryCustomEventHistogramWithChan invokes the cms.QueryCustomEventHistogram API asynchronously
// api document: https://help.aliyun.com/api/cms/querycustomeventhistogram.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryCustomEventHistogramWithChan(request *QueryCustomEventHistogramRequest) (<-chan *QueryCustomEventHistogramResponse, <-chan error) {
	responseChan := make(chan *QueryCustomEventHistogramResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryCustomEventHistogram(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryCustomEventHistogramWithCallback invokes the cms.QueryCustomEventHistogram API asynchronously
// api document: https://help.aliyun.com/api/cms/querycustomeventhistogram.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryCustomEventHistogramWithCallback(request *QueryCustomEventHistogramRequest, callback func(response *QueryCustomEventHistogramResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryCustomEventHistogramResponse
		var err error
		defer close(result)
		response, err = client.QueryCustomEventHistogram(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryCustomEventHistogramRequest is the request struct for api QueryCustomEventHistogram
type QueryCustomEventHistogramRequest struct {
	*requests.RpcRequest
	QueryJson string `position:"Query" name:"QueryJson"`
}

// QueryCustomEventHistogramResponse is the response struct for api QueryCustomEventHistogram
type QueryCustomEventHistogramResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   string `json:"Success" xml:"Success"`
}

// CreateQueryCustomEventHistogramRequest creates a request to invoke QueryCustomEventHistogram API
func CreateQueryCustomEventHistogramRequest() (request *QueryCustomEventHistogramRequest) {
	request = &QueryCustomEventHistogramRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2018-03-08", "QueryCustomEventHistogram", "cms", "openAPI")
	return
}

// CreateQueryCustomEventHistogramResponse creates a response to parse from QueryCustomEventHistogram response
func CreateQueryCustomEventHistogramResponse() (response *QueryCustomEventHistogramResponse) {
	response = &QueryCustomEventHistogramResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
