package cs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeClusterNodeInfo invokes the cs.DescribeClusterNodeInfo API synchronously
// api document: https://help.aliyun.com/api/cs/describeclusternodeinfo.html
func (client *Client) DescribeClusterNodeInfo(request *DescribeClusterNodeInfoRequest) (response *DescribeClusterNodeInfoResponse, err error) {
	response = CreateDescribeClusterNodeInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeClusterNodeInfoWithChan invokes the cs.DescribeClusterNodeInfo API asynchronously
// api document: https://help.aliyun.com/api/cs/describeclusternodeinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeClusterNodeInfoWithChan(request *DescribeClusterNodeInfoRequest) (<-chan *DescribeClusterNodeInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeClusterNodeInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeClusterNodeInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeClusterNodeInfoWithCallback invokes the cs.DescribeClusterNodeInfo API asynchronously
// api document: https://help.aliyun.com/api/cs/describeclusternodeinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeClusterNodeInfoWithCallback(request *DescribeClusterNodeInfoRequest, callback func(response *DescribeClusterNodeInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeClusterNodeInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeClusterNodeInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeClusterNodeInfoRequest is the request struct for api DescribeClusterNodeInfo
type DescribeClusterNodeInfoRequest struct {
	*requests.RoaRequest
	Token string `position:"Path" name:"Token"`
}

// DescribeClusterNodeInfoResponse is the response struct for api DescribeClusterNodeInfo
type DescribeClusterNodeInfoResponse struct {
	*responses.BaseResponse
}

// CreateDescribeClusterNodeInfoRequest creates a request to invoke DescribeClusterNodeInfo API
func CreateDescribeClusterNodeInfoRequest() (request *DescribeClusterNodeInfoRequest) {
	request = &DescribeClusterNodeInfoRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("CS", "2015-12-15", "DescribeClusterNodeInfo", "/token/[Token]/node_info", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeClusterNodeInfoResponse creates a response to parse from DescribeClusterNodeInfo response
func CreateDescribeClusterNodeInfoResponse() (response *DescribeClusterNodeInfoResponse) {
	response = &DescribeClusterNodeInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
