package cs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateSubUserResouces invokes the cs.UpdateSubUserResouces API synchronously
// api document: https://help.aliyun.com/api/cs/updatesubuserresouces.html
func (client *Client) UpdateSubUserResouces(request *UpdateSubUserResoucesRequest) (response *UpdateSubUserResoucesResponse, err error) {
	response = CreateUpdateSubUserResoucesResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateSubUserResoucesWithChan invokes the cs.UpdateSubUserResouces API asynchronously
// api document: https://help.aliyun.com/api/cs/updatesubuserresouces.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateSubUserResoucesWithChan(request *UpdateSubUserResoucesRequest) (<-chan *UpdateSubUserResoucesResponse, <-chan error) {
	responseChan := make(chan *UpdateSubUserResoucesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateSubUserResouces(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateSubUserResoucesWithCallback invokes the cs.UpdateSubUserResouces API asynchronously
// api document: https://help.aliyun.com/api/cs/updatesubuserresouces.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateSubUserResoucesWithCallback(request *UpdateSubUserResoucesRequest, callback func(response *UpdateSubUserResoucesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateSubUserResoucesResponse
		var err error
		defer close(result)
		response, err = client.UpdateSubUserResouces(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateSubUserResoucesRequest is the request struct for api UpdateSubUserResouces
type UpdateSubUserResoucesRequest struct {
	*requests.RoaRequest
}

// UpdateSubUserResoucesResponse is the response struct for api UpdateSubUserResouces
type UpdateSubUserResoucesResponse struct {
	*responses.BaseResponse
}

// CreateUpdateSubUserResoucesRequest creates a request to invoke UpdateSubUserResouces API
func CreateUpdateSubUserResoucesRequest() (request *UpdateSubUserResoucesRequest) {
	request = &UpdateSubUserResoucesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("CS", "2015-12-15", "UpdateSubUserResouces", "/ram/resources", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateSubUserResoucesResponse creates a response to parse from UpdateSubUserResouces response
func CreateUpdateSubUserResoucesResponse() (response *UpdateSubUserResoucesResponse) {
	response = &UpdateSubUserResoucesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
