package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BindSlb invokes the edas.BindSlb API synchronously
// api document: https://help.aliyun.com/api/edas/bindslb.html
func (client *Client) BindSlb(request *BindSlbRequest) (response *BindSlbResponse, err error) {
	response = CreateBindSlbResponse()
	err = client.DoAction(request, response)
	return
}

// BindSlbWithChan invokes the edas.BindSlb API asynchronously
// api document: https://help.aliyun.com/api/edas/bindslb.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BindSlbWithChan(request *BindSlbRequest) (<-chan *BindSlbResponse, <-chan error) {
	responseChan := make(chan *BindSlbResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BindSlb(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BindSlbWithCallback invokes the edas.BindSlb API asynchronously
// api document: https://help.aliyun.com/api/edas/bindslb.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BindSlbWithCallback(request *BindSlbRequest, callback func(response *BindSlbResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BindSlbResponse
		var err error
		defer close(result)
		response, err = client.BindSlb(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BindSlbRequest is the request struct for api BindSlb
type BindSlbRequest struct {
	*requests.RoaRequest
	VServerGroupId string           `position:"Query" name:"VServerGroupId"`
	ListenerPort   requests.Integer `position:"Query" name:"ListenerPort"`
	SlbId          string           `position:"Query" name:"SlbId"`
	AppId          string           `position:"Query" name:"AppId"`
	SlbIp          string           `position:"Query" name:"SlbIp"`
	Type           string           `position:"Query" name:"Type"`
}

// BindSlbResponse is the response struct for api BindSlb
type BindSlbResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateBindSlbRequest creates a request to invoke BindSlb API
func CreateBindSlbRequest() (request *BindSlbRequest) {
	request = &BindSlbRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "BindSlb", "/pop/app/bind_slb_json", "edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBindSlbResponse creates a response to parse from BindSlb response
func CreateBindSlbResponse() (response *BindSlbResponse) {
	response = &BindSlbResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
