package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// InsertDeployGroup invokes the edas.InsertDeployGroup API synchronously
// api document: https://help.aliyun.com/api/edas/insertdeploygroup.html
func (client *Client) InsertDeployGroup(request *InsertDeployGroupRequest) (response *InsertDeployGroupResponse, err error) {
	response = CreateInsertDeployGroupResponse()
	err = client.DoAction(request, response)
	return
}

// InsertDeployGroupWithChan invokes the edas.InsertDeployGroup API asynchronously
// api document: https://help.aliyun.com/api/edas/insertdeploygroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) InsertDeployGroupWithChan(request *InsertDeployGroupRequest) (<-chan *InsertDeployGroupResponse, <-chan error) {
	responseChan := make(chan *InsertDeployGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.InsertDeployGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// InsertDeployGroupWithCallback invokes the edas.InsertDeployGroup API asynchronously
// api document: https://help.aliyun.com/api/edas/insertdeploygroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) InsertDeployGroupWithCallback(request *InsertDeployGroupRequest, callback func(response *InsertDeployGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *InsertDeployGroupResponse
		var err error
		defer close(result)
		response, err = client.InsertDeployGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// InsertDeployGroupRequest is the request struct for api InsertDeployGroup
type InsertDeployGroupRequest struct {
	*requests.RoaRequest
	AppId     string `position:"Query" name:"AppId"`
	GroupName string `position:"Query" name:"GroupName"`
}

// InsertDeployGroupResponse is the response struct for api InsertDeployGroup
type InsertDeployGroupResponse struct {
	*responses.BaseResponse
	Code              int               `json:"Code" xml:"Code"`
	Message           string            `json:"Message" xml:"Message"`
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	DeployGroupEntity DeployGroupEntity `json:"DeployGroupEntity" xml:"DeployGroupEntity"`
}

// CreateInsertDeployGroupRequest creates a request to invoke InsertDeployGroup API
func CreateInsertDeployGroupRequest() (request *InsertDeployGroupRequest) {
	request = &InsertDeployGroupRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "InsertDeployGroup", "/pop/v5/deploy_group", "edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateInsertDeployGroupResponse creates a response to parse from InsertDeployGroup response
func CreateInsertDeployGroupResponse() (response *InsertDeployGroupResponse) {
	response = &InsertDeployGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
