package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// KillExecutionPlanInstance invokes the emr.KillExecutionPlanInstance API synchronously
// api document: https://help.aliyun.com/api/emr/killexecutionplaninstance.html
func (client *Client) KillExecutionPlanInstance(request *KillExecutionPlanInstanceRequest) (response *KillExecutionPlanInstanceResponse, err error) {
	response = CreateKillExecutionPlanInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// KillExecutionPlanInstanceWithChan invokes the emr.KillExecutionPlanInstance API asynchronously
// api document: https://help.aliyun.com/api/emr/killexecutionplaninstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) KillExecutionPlanInstanceWithChan(request *KillExecutionPlanInstanceRequest) (<-chan *KillExecutionPlanInstanceResponse, <-chan error) {
	responseChan := make(chan *KillExecutionPlanInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.KillExecutionPlanInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// KillExecutionPlanInstanceWithCallback invokes the emr.KillExecutionPlanInstance API asynchronously
// api document: https://help.aliyun.com/api/emr/killexecutionplaninstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) KillExecutionPlanInstanceWithCallback(request *KillExecutionPlanInstanceRequest, callback func(response *KillExecutionPlanInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *KillExecutionPlanInstanceResponse
		var err error
		defer close(result)
		response, err = client.KillExecutionPlanInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// KillExecutionPlanInstanceRequest is the request struct for api KillExecutionPlanInstance
type KillExecutionPlanInstanceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Id              string           `position:"Query" name:"Id"`
}

// KillExecutionPlanInstanceResponse is the response struct for api KillExecutionPlanInstance
type KillExecutionPlanInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateKillExecutionPlanInstanceRequest creates a request to invoke KillExecutionPlanInstance API
func CreateKillExecutionPlanInstanceRequest() (request *KillExecutionPlanInstanceRequest) {
	request = &KillExecutionPlanInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "KillExecutionPlanInstance", "emr", "openAPI")
	return
}

// CreateKillExecutionPlanInstanceResponse creates a response to parse from KillExecutionPlanInstance response
func CreateKillExecutionPlanInstanceResponse() (response *KillExecutionPlanInstanceResponse) {
	response = &KillExecutionPlanInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
