package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RetryExecutionPlan invokes the emr.RetryExecutionPlan API synchronously
// api document: https://help.aliyun.com/api/emr/retryexecutionplan.html
func (client *Client) RetryExecutionPlan(request *RetryExecutionPlanRequest) (response *RetryExecutionPlanResponse, err error) {
	response = CreateRetryExecutionPlanResponse()
	err = client.DoAction(request, response)
	return
}

// RetryExecutionPlanWithChan invokes the emr.RetryExecutionPlan API asynchronously
// api document: https://help.aliyun.com/api/emr/retryexecutionplan.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RetryExecutionPlanWithChan(request *RetryExecutionPlanRequest) (<-chan *RetryExecutionPlanResponse, <-chan error) {
	responseChan := make(chan *RetryExecutionPlanResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RetryExecutionPlan(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RetryExecutionPlanWithCallback invokes the emr.RetryExecutionPlan API asynchronously
// api document: https://help.aliyun.com/api/emr/retryexecutionplan.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RetryExecutionPlanWithCallback(request *RetryExecutionPlanRequest, callback func(response *RetryExecutionPlanResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RetryExecutionPlanResponse
		var err error
		defer close(result)
		response, err = client.RetryExecutionPlan(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RetryExecutionPlanRequest is the request struct for api RetryExecutionPlan
type RetryExecutionPlanRequest struct {
	*requests.RpcRequest
	ResourceOwnerId          requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ExecutionPlanWorkNodeIds string           `position:"Query" name:"ExecutionPlanWorkNodeIds"`
	Id                       string           `position:"Query" name:"Id"`
}

// RetryExecutionPlanResponse is the response struct for api RetryExecutionPlan
type RetryExecutionPlanResponse struct {
	*responses.BaseResponse
	RequestId               string `json:"RequestId" xml:"RequestId"`
	ExecutionPlanInstanceId string `json:"ExecutionPlanInstanceId" xml:"ExecutionPlanInstanceId"`
}

// CreateRetryExecutionPlanRequest creates a request to invoke RetryExecutionPlan API
func CreateRetryExecutionPlanRequest() (request *RetryExecutionPlanRequest) {
	request = &RetryExecutionPlanRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "RetryExecutionPlan", "emr", "openAPI")
	return
}

// CreateRetryExecutionPlanResponse creates a response to parse from RetryExecutionPlan response
func CreateRetryExecutionPlanResponse() (response *RetryExecutionPlanResponse) {
	response = &RetryExecutionPlanResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
