package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// FileAsyncScan invokes the green.FileAsyncScan API synchronously
// api document: https://help.aliyun.com/api/green/fileasyncscan.html
func (client *Client) FileAsyncScan(request *FileAsyncScanRequest) (response *FileAsyncScanResponse, err error) {
	response = CreateFileAsyncScanResponse()
	err = client.DoAction(request, response)
	return
}

// FileAsyncScanWithChan invokes the green.FileAsyncScan API asynchronously
// api document: https://help.aliyun.com/api/green/fileasyncscan.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) FileAsyncScanWithChan(request *FileAsyncScanRequest) (<-chan *FileAsyncScanResponse, <-chan error) {
	responseChan := make(chan *FileAsyncScanResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.FileAsyncScan(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// FileAsyncScanWithCallback invokes the green.FileAsyncScan API asynchronously
// api document: https://help.aliyun.com/api/green/fileasyncscan.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) FileAsyncScanWithCallback(request *FileAsyncScanRequest, callback func(response *FileAsyncScanResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *FileAsyncScanResponse
		var err error
		defer close(result)
		response, err = client.FileAsyncScan(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// FileAsyncScanRequest is the request struct for api FileAsyncScan
type FileAsyncScanRequest struct {
	*requests.RoaRequest
	ClientInfo string `position:"Query" name:"ClientInfo"`
}

// FileAsyncScanResponse is the response struct for api FileAsyncScan
type FileAsyncScanResponse struct {
	*responses.BaseResponse
}

// CreateFileAsyncScanRequest creates a request to invoke FileAsyncScan API
func CreateFileAsyncScanRequest() (request *FileAsyncScanRequest) {
	request = &FileAsyncScanRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Green", "2018-05-09", "FileAsyncScan", "/green/file/asyncscan", "green", "openAPI")
	request.Method = requests.POST
	return
}

// CreateFileAsyncScanResponse creates a response to parse from FileAsyncScan response
func CreateFileAsyncScanResponse() (response *FileAsyncScanResponse) {
	response = &FileAsyncScanResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
